// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package oam

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateLink = "CreateLink"

// CreateLinkRequest generates a "aws/request.Request" representing the
// client's request for the CreateLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLink for more information on using the CreateLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLinkRequest method.
//	req, resp := client.CreateLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/CreateLink
func (c *OAM) CreateLinkRequest(input *CreateLinkInput) (req *request.Request, output *CreateLinkOutput) {
	op := &request.Operation{
		Name:       opCreateLink,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateLink",
	}

	if input == nil {
		input = &CreateLinkInput{}
	}

	output = &CreateLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLink API operation for CloudWatch Observability Access Manager.
//
// Creates a link between a source account and a sink that you have created
// in a monitoring account.
//
// Before you create a link, you must create a sink in the monitoring account
// and create a sink policy in that account. The sink policy must permit the
// source account to link to it. You can grant permission to source accounts
// by granting permission to an entire organization or to individual accounts.
//
// For more information, see CreateSink (https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html)
// and PutSinkPolicy (https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html).
//
// Each monitoring account can be linked to as many as 100,000 source accounts.
//
// Each source account can be linked to as many as five monitoring accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation CreateLink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/CreateLink
func (c *OAM) CreateLink(input *CreateLinkInput) (*CreateLinkOutput, error) {
	req, out := c.CreateLinkRequest(input)
	return out, req.Send()
}

// CreateLinkWithContext is the same as CreateLink with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) CreateLinkWithContext(ctx aws.Context, input *CreateLinkInput, opts ...request.Option) (*CreateLinkOutput, error) {
	req, out := c.CreateLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSink = "CreateSink"

// CreateSinkRequest generates a "aws/request.Request" representing the
// client's request for the CreateSink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSink for more information on using the CreateSink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSinkRequest method.
//	req, resp := client.CreateSinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/CreateSink
func (c *OAM) CreateSinkRequest(input *CreateSinkInput) (req *request.Request, output *CreateSinkOutput) {
	op := &request.Operation{
		Name:       opCreateSink,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateSink",
	}

	if input == nil {
		input = &CreateSinkInput{}
	}

	output = &CreateSinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSink API operation for CloudWatch Observability Access Manager.
//
// Use this to create a sink in the current account, so that it can be used
// as a monitoring account in CloudWatch cross-account observability. A sink
// is a resource that represents an attachment point in a monitoring account.
// Source accounts can link to the sink to send observability data.
//
// After you create a sink, you must create a sink policy that allows source
// accounts to attach to it. For more information, see PutSinkPolicy (https://docs.aws.amazon.com/OAM/latest/APIReference/API_PutSinkPolicy.html).
//
// Each account can contain one sink. If you delete a sink, you can then create
// a new one in that account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation CreateSink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/CreateSink
func (c *OAM) CreateSink(input *CreateSinkInput) (*CreateSinkOutput, error) {
	req, out := c.CreateSinkRequest(input)
	return out, req.Send()
}

// CreateSinkWithContext is the same as CreateSink with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) CreateSinkWithContext(ctx aws.Context, input *CreateSinkInput, opts ...request.Option) (*CreateSinkOutput, error) {
	req, out := c.CreateSinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLink = "DeleteLink"

// DeleteLinkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLink for more information on using the DeleteLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLinkRequest method.
//	req, resp := client.DeleteLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/DeleteLink
func (c *OAM) DeleteLinkRequest(input *DeleteLinkInput) (req *request.Request, output *DeleteLinkOutput) {
	op := &request.Operation{
		Name:       opDeleteLink,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteLink",
	}

	if input == nil {
		input = &DeleteLinkInput{}
	}

	output = &DeleteLinkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLink API operation for CloudWatch Observability Access Manager.
//
// Deletes a link between a monitoring account sink and a source account. You
// must run this operation in the source account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation DeleteLink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/DeleteLink
func (c *OAM) DeleteLink(input *DeleteLinkInput) (*DeleteLinkOutput, error) {
	req, out := c.DeleteLinkRequest(input)
	return out, req.Send()
}

// DeleteLinkWithContext is the same as DeleteLink with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) DeleteLinkWithContext(ctx aws.Context, input *DeleteLinkInput, opts ...request.Option) (*DeleteLinkOutput, error) {
	req, out := c.DeleteLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSink = "DeleteSink"

// DeleteSinkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSink for more information on using the DeleteSink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSinkRequest method.
//	req, resp := client.DeleteSinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/DeleteSink
func (c *OAM) DeleteSinkRequest(input *DeleteSinkInput) (req *request.Request, output *DeleteSinkOutput) {
	op := &request.Operation{
		Name:       opDeleteSink,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteSink",
	}

	if input == nil {
		input = &DeleteSinkInput{}
	}

	output = &DeleteSinkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSink API operation for CloudWatch Observability Access Manager.
//
// Deletes a sink. You must delete all links to a sink before you can delete
// that sink.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation DeleteSink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - ConflictException
//     A resource was in an inconsistent state during an update or a deletion.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/DeleteSink
func (c *OAM) DeleteSink(input *DeleteSinkInput) (*DeleteSinkOutput, error) {
	req, out := c.DeleteSinkRequest(input)
	return out, req.Send()
}

// DeleteSinkWithContext is the same as DeleteSink with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) DeleteSinkWithContext(ctx aws.Context, input *DeleteSinkInput, opts ...request.Option) (*DeleteSinkOutput, error) {
	req, out := c.DeleteSinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLink = "GetLink"

// GetLinkRequest generates a "aws/request.Request" representing the
// client's request for the GetLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLink for more information on using the GetLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLinkRequest method.
//	req, resp := client.GetLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/GetLink
func (c *OAM) GetLinkRequest(input *GetLinkInput) (req *request.Request, output *GetLinkOutput) {
	op := &request.Operation{
		Name:       opGetLink,
		HTTPMethod: "POST",
		HTTPPath:   "/GetLink",
	}

	if input == nil {
		input = &GetLinkInput{}
	}

	output = &GetLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLink API operation for CloudWatch Observability Access Manager.
//
// Returns complete information about one link.
//
// To use this operation, provide the link ARN. To retrieve a list of link ARNs,
// use ListLinks (https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListLinks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation GetLink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/GetLink
func (c *OAM) GetLink(input *GetLinkInput) (*GetLinkOutput, error) {
	req, out := c.GetLinkRequest(input)
	return out, req.Send()
}

// GetLinkWithContext is the same as GetLink with the addition of
// the ability to pass a context and additional request options.
//
// See GetLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) GetLinkWithContext(ctx aws.Context, input *GetLinkInput, opts ...request.Option) (*GetLinkOutput, error) {
	req, out := c.GetLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSink = "GetSink"

// GetSinkRequest generates a "aws/request.Request" representing the
// client's request for the GetSink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSink for more information on using the GetSink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSinkRequest method.
//	req, resp := client.GetSinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/GetSink
func (c *OAM) GetSinkRequest(input *GetSinkInput) (req *request.Request, output *GetSinkOutput) {
	op := &request.Operation{
		Name:       opGetSink,
		HTTPMethod: "POST",
		HTTPPath:   "/GetSink",
	}

	if input == nil {
		input = &GetSinkInput{}
	}

	output = &GetSinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSink API operation for CloudWatch Observability Access Manager.
//
// Returns complete information about one monitoring account sink.
//
// To use this operation, provide the sink ARN. To retrieve a list of sink ARNs,
// use ListSinks (https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation GetSink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/GetSink
func (c *OAM) GetSink(input *GetSinkInput) (*GetSinkOutput, error) {
	req, out := c.GetSinkRequest(input)
	return out, req.Send()
}

// GetSinkWithContext is the same as GetSink with the addition of
// the ability to pass a context and additional request options.
//
// See GetSink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) GetSinkWithContext(ctx aws.Context, input *GetSinkInput, opts ...request.Option) (*GetSinkOutput, error) {
	req, out := c.GetSinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSinkPolicy = "GetSinkPolicy"

// GetSinkPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetSinkPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSinkPolicy for more information on using the GetSinkPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSinkPolicyRequest method.
//	req, resp := client.GetSinkPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/GetSinkPolicy
func (c *OAM) GetSinkPolicyRequest(input *GetSinkPolicyInput) (req *request.Request, output *GetSinkPolicyOutput) {
	op := &request.Operation{
		Name:       opGetSinkPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/GetSinkPolicy",
	}

	if input == nil {
		input = &GetSinkPolicyInput{}
	}

	output = &GetSinkPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSinkPolicy API operation for CloudWatch Observability Access Manager.
//
// Returns the current sink policy attached to this sink. The sink policy specifies
// what accounts can attach to this sink as source accounts, and what types
// of data they can share.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation GetSinkPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/GetSinkPolicy
func (c *OAM) GetSinkPolicy(input *GetSinkPolicyInput) (*GetSinkPolicyOutput, error) {
	req, out := c.GetSinkPolicyRequest(input)
	return out, req.Send()
}

// GetSinkPolicyWithContext is the same as GetSinkPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetSinkPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) GetSinkPolicyWithContext(ctx aws.Context, input *GetSinkPolicyInput, opts ...request.Option) (*GetSinkPolicyOutput, error) {
	req, out := c.GetSinkPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttachedLinks = "ListAttachedLinks"

// ListAttachedLinksRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttachedLinks for more information on using the ListAttachedLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAttachedLinksRequest method.
//	req, resp := client.ListAttachedLinksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListAttachedLinks
func (c *OAM) ListAttachedLinksRequest(input *ListAttachedLinksInput) (req *request.Request, output *ListAttachedLinksOutput) {
	op := &request.Operation{
		Name:       opListAttachedLinks,
		HTTPMethod: "POST",
		HTTPPath:   "/ListAttachedLinks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttachedLinksInput{}
	}

	output = &ListAttachedLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedLinks API operation for CloudWatch Observability Access Manager.
//
// Returns a list of source account links that are linked to this monitoring
// account sink.
//
// To use this operation, provide the sink ARN. To retrieve a list of sink ARNs,
// use ListSinks (https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html).
//
// To find a list of links for one source account, use ListLinks (https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListLinks.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation ListAttachedLinks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListAttachedLinks
func (c *OAM) ListAttachedLinks(input *ListAttachedLinksInput) (*ListAttachedLinksOutput, error) {
	req, out := c.ListAttachedLinksRequest(input)
	return out, req.Send()
}

// ListAttachedLinksWithContext is the same as ListAttachedLinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttachedLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListAttachedLinksWithContext(ctx aws.Context, input *ListAttachedLinksInput, opts ...request.Option) (*ListAttachedLinksOutput, error) {
	req, out := c.ListAttachedLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttachedLinksPages iterates over the pages of a ListAttachedLinks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttachedLinks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAttachedLinks operation.
//	pageNum := 0
//	err := client.ListAttachedLinksPages(params,
//	    func(page *oam.ListAttachedLinksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OAM) ListAttachedLinksPages(input *ListAttachedLinksInput, fn func(*ListAttachedLinksOutput, bool) bool) error {
	return c.ListAttachedLinksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttachedLinksPagesWithContext same as ListAttachedLinksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListAttachedLinksPagesWithContext(ctx aws.Context, input *ListAttachedLinksInput, fn func(*ListAttachedLinksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttachedLinksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttachedLinksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttachedLinksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLinks = "ListLinks"

// ListLinksRequest generates a "aws/request.Request" representing the
// client's request for the ListLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLinks for more information on using the ListLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLinksRequest method.
//	req, resp := client.ListLinksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListLinks
func (c *OAM) ListLinksRequest(input *ListLinksInput) (req *request.Request, output *ListLinksOutput) {
	op := &request.Operation{
		Name:       opListLinks,
		HTTPMethod: "POST",
		HTTPPath:   "/ListLinks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLinksInput{}
	}

	output = &ListLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLinks API operation for CloudWatch Observability Access Manager.
//
// Use this operation in a source account to return a list of links to monitoring
// account sinks that this source account has.
//
// To find a list of links for one monitoring account sink, use ListAttachedLinks
// (https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListAttachedLinks.html)
// from within the monitoring account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation ListLinks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListLinks
func (c *OAM) ListLinks(input *ListLinksInput) (*ListLinksOutput, error) {
	req, out := c.ListLinksRequest(input)
	return out, req.Send()
}

// ListLinksWithContext is the same as ListLinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListLinksWithContext(ctx aws.Context, input *ListLinksInput, opts ...request.Option) (*ListLinksOutput, error) {
	req, out := c.ListLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLinksPages iterates over the pages of a ListLinks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLinks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLinks operation.
//	pageNum := 0
//	err := client.ListLinksPages(params,
//	    func(page *oam.ListLinksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OAM) ListLinksPages(input *ListLinksInput, fn func(*ListLinksOutput, bool) bool) error {
	return c.ListLinksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLinksPagesWithContext same as ListLinksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListLinksPagesWithContext(ctx aws.Context, input *ListLinksInput, fn func(*ListLinksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLinksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLinksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLinksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSinks = "ListSinks"

// ListSinksRequest generates a "aws/request.Request" representing the
// client's request for the ListSinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSinks for more information on using the ListSinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSinksRequest method.
//	req, resp := client.ListSinksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListSinks
func (c *OAM) ListSinksRequest(input *ListSinksInput) (req *request.Request, output *ListSinksOutput) {
	op := &request.Operation{
		Name:       opListSinks,
		HTTPMethod: "POST",
		HTTPPath:   "/ListSinks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSinksInput{}
	}

	output = &ListSinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSinks API operation for CloudWatch Observability Access Manager.
//
// Use this operation in a monitoring account to return the list of sinks created
// in that account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation ListSinks for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListSinks
func (c *OAM) ListSinks(input *ListSinksInput) (*ListSinksOutput, error) {
	req, out := c.ListSinksRequest(input)
	return out, req.Send()
}

// ListSinksWithContext is the same as ListSinks with the addition of
// the ability to pass a context and additional request options.
//
// See ListSinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListSinksWithContext(ctx aws.Context, input *ListSinksInput, opts ...request.Option) (*ListSinksOutput, error) {
	req, out := c.ListSinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSinksPages iterates over the pages of a ListSinks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSinks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSinks operation.
//	pageNum := 0
//	err := client.ListSinksPages(params,
//	    func(page *oam.ListSinksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OAM) ListSinksPages(input *ListSinksInput, fn func(*ListSinksOutput, bool) bool) error {
	return c.ListSinksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSinksPagesWithContext same as ListSinksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListSinksPagesWithContext(ctx aws.Context, input *ListSinksInput, fn func(*ListSinksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSinksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSinksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSinksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListTagsForResource
func (c *OAM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for CloudWatch Observability Access Manager.
//
// Displays the tags associated with a resource. Both sinks and links support
// tagging.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/ListTagsForResource
func (c *OAM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSinkPolicy = "PutSinkPolicy"

// PutSinkPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutSinkPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSinkPolicy for more information on using the PutSinkPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutSinkPolicyRequest method.
//	req, resp := client.PutSinkPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/PutSinkPolicy
func (c *OAM) PutSinkPolicyRequest(input *PutSinkPolicyInput) (req *request.Request, output *PutSinkPolicyOutput) {
	op := &request.Operation{
		Name:       opPutSinkPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/PutSinkPolicy",
	}

	if input == nil {
		input = &PutSinkPolicyInput{}
	}

	output = &PutSinkPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutSinkPolicy API operation for CloudWatch Observability Access Manager.
//
// Creates or updates the resource policy that grants permissions to source
// accounts to link to the monitoring account sink. When you create a sink policy,
// you can grant permissions to all accounts in an organization or to individual
// accounts.
//
// You can also use a sink policy to limit the types of data that is shared.
// The three types that you can allow or deny are:
//
//   - Metrics - Specify with AWS::CloudWatch::Metric
//
//   - Log groups - Specify with AWS::Logs::LogGroup
//
//   - Traces - Specify with AWS::XRay::Trace
//
//   - Application Insights - Applications - Specify with AWS::ApplicationInsights::Application
//
// See the examples in this section to see how to specify permitted source accounts
// and data types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation PutSinkPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/PutSinkPolicy
func (c *OAM) PutSinkPolicy(input *PutSinkPolicyInput) (*PutSinkPolicyOutput, error) {
	req, out := c.PutSinkPolicyRequest(input)
	return out, req.Send()
}

// PutSinkPolicyWithContext is the same as PutSinkPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutSinkPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) PutSinkPolicyWithContext(ctx aws.Context, input *PutSinkPolicyInput, opts ...request.Option) (*PutSinkPolicyOutput, error) {
	req, out := c.PutSinkPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/TagResource
func (c *OAM) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for CloudWatch Observability Access Manager.
//
// Assigns one or more tags (key-value pairs) to the specified resource. Both
// sinks and links can be tagged.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions by granting a user permission to access or
// change only resources with certain tag values.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with a resource that already has tags.
// If you specify a new tag key for the alarm, this tag is appended to the list
// of tags associated with the alarm. If you specify a tag key that is already
// associated with the alarm, the new tag value that you specify replaces the
// previous value for that tag.
//
// You can associate as many as 50 tags with a resource.
//
// Unlike tagging permissions in other Amazon Web Services services, to tag
// or untag links and sinks you must have the oam:ResourceTag permission. The
// iam:ResourceTag permission does not allow you to tag and untag links and
// sinks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - TooManyTagsException
//     A resource can have no more than 50 tags.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/TagResource
func (c *OAM) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/UntagResource
func (c *OAM) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for CloudWatch Observability Access Manager.
//
// Removes one or more tags from the specified resource.
//
// Unlike tagging permissions in other Amazon Web Services services, to tag
// or untag links and sinks you must have the oam:ResourceTag permission. The
// iam:TagResource permission does not allow you to tag and untag links and
// sinks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The value of a parameter in the request caused an error.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/UntagResource
func (c *OAM) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLink = "UpdateLink"

// UpdateLinkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLink for more information on using the UpdateLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLinkRequest method.
//	req, resp := client.UpdateLinkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/UpdateLink
func (c *OAM) UpdateLinkRequest(input *UpdateLinkInput) (req *request.Request, output *UpdateLinkOutput) {
	op := &request.Operation{
		Name:       opUpdateLink,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateLink",
	}

	if input == nil {
		input = &UpdateLinkInput{}
	}

	output = &UpdateLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLink API operation for CloudWatch Observability Access Manager.
//
// Use this operation to change what types of data are shared from a source
// account to its linked monitoring account sink. You can't change the sink
// or change the monitoring account with this operation.
//
// To update the list of tags associated with the sink, use TagResource (https://docs.aws.amazon.com/OAM/latest/APIReference/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for CloudWatch Observability Access Manager's
// API operation UpdateLink for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceFault
//     Unexpected error while processing the request. Retry the request.
//
//   - MissingRequiredParameterException
//     A required parameter is missing from the request.
//
//   - InvalidParameterException
//     A parameter is specified incorrectly.
//
//   - ResourceNotFoundException
//     The request references a resource that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/oam-2022-06-10/UpdateLink
func (c *OAM) UpdateLink(input *UpdateLinkInput) (*UpdateLinkOutput, error) {
	req, out := c.UpdateLinkRequest(input)
	return out, req.Send()
}

// UpdateLinkWithContext is the same as UpdateLink with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OAM) UpdateLinkWithContext(ctx aws.Context, input *UpdateLinkInput, opts ...request.Option) (*UpdateLinkOutput, error) {
	req, out := c.UpdateLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A resource was in an inconsistent state during an update or a deletion.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The name of the exception.
	AmznErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateLinkInput struct {
	_ struct{} `type:"structure"`

	// Specify a friendly human-readable name to use to identify this source account
	// when you are viewing data from it in the monitoring account.
	//
	// You can use a custom label or use the following variables:
	//
	//    * $AccountName is the name of the account
	//
	//    * $AccountEmail is the globally unique email address of the account
	//
	//    * $AccountEmailNoDomain is the email address of the account without the
	//    domain name
	//
	// LabelTemplate is a required field
	LabelTemplate *string `min:"1" type:"string" required:"true"`

	// An array of strings that define which types of data that the source account
	// shares with the monitoring account.
	//
	// ResourceTypes is a required field
	ResourceTypes []*string `min:"1" type:"list" required:"true" enum:"ResourceType"`

	// The ARN of the sink to use to create this link. You can use ListSinks (https://docs.aws.amazon.com/OAM/latest/APIReference/API_ListSinks.html)
	// to find the ARNs of sinks.
	//
	// For more information about sinks, see CreateSink (https://docs.aws.amazon.com/OAM/latest/APIReference/API_CreateSink.html).
	//
	// SinkIdentifier is a required field
	SinkIdentifier *string `type:"string" required:"true"`

	// Assigns one or more tags (key-value pairs) to the link.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// For more information about using tags to control access, see Controlling
	// access to Amazon Web Services resources using tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLinkInput"}
	if s.LabelTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelTemplate"))
	}
	if s.LabelTemplate != nil && len(*s.LabelTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelTemplate", 1))
	}
	if s.ResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTypes"))
	}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.SinkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelTemplate sets the LabelTemplate field's value.
func (s *CreateLinkInput) SetLabelTemplate(v string) *CreateLinkInput {
	s.LabelTemplate = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateLinkInput) SetResourceTypes(v []*string) *CreateLinkInput {
	s.ResourceTypes = v
	return s
}

// SetSinkIdentifier sets the SinkIdentifier field's value.
func (s *CreateLinkInput) SetSinkIdentifier(v string) *CreateLinkInput {
	s.SinkIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLinkInput) SetTags(v map[string]*string) *CreateLinkInput {
	s.Tags = v
	return s
}

type CreateLinkOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the link that is newly created.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the link
	// ARN.
	Id *string `type:"string"`

	// The label that you assigned to this link. If the labelTemplate includes variables,
	// this field displays the variables resolved to their actual values.
	Label *string `type:"string"`

	// The exact label template that you specified, with the variables not resolved.
	LabelTemplate *string `type:"string"`

	// The resource types supported by this link.
	ResourceTypes []*string `type:"list"`

	// The ARN of the sink that is used for this link.
	SinkArn *string `type:"string"`

	// The tags assigned to the link.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLinkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateLinkOutput) SetArn(v string) *CreateLinkOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateLinkOutput) SetId(v string) *CreateLinkOutput {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *CreateLinkOutput) SetLabel(v string) *CreateLinkOutput {
	s.Label = &v
	return s
}

// SetLabelTemplate sets the LabelTemplate field's value.
func (s *CreateLinkOutput) SetLabelTemplate(v string) *CreateLinkOutput {
	s.LabelTemplate = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *CreateLinkOutput) SetResourceTypes(v []*string) *CreateLinkOutput {
	s.ResourceTypes = v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *CreateLinkOutput) SetSinkArn(v string) *CreateLinkOutput {
	s.SinkArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLinkOutput) SetTags(v map[string]*string) *CreateLinkOutput {
	s.Tags = v
	return s
}

type CreateSinkInput struct {
	_ struct{} `type:"structure"`

	// A name for the sink.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Assigns one or more tags (key-value pairs) to the link.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions by granting a user permission to access or
	// change only resources with certain tag values.
	//
	// For more information about using tags to control access, see Controlling
	// access to Amazon Web Services resources using tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html).
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSinkInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSinkInput) SetName(v string) *CreateSinkInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSinkInput) SetTags(v map[string]*string) *CreateSinkInput {
	s.Tags = v
	return s
}

type CreateSinkOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the sink that is newly created.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the sink
	// ARN.
	Id *string `type:"string"`

	// The name of the sink.
	Name *string `type:"string"`

	// The tags assigned to the sink.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSinkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSinkOutput) SetArn(v string) *CreateSinkOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSinkOutput) SetId(v string) *CreateSinkOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSinkOutput) SetName(v string) *CreateSinkOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSinkOutput) SetTags(v map[string]*string) *CreateSinkOutput {
	s.Tags = v
	return s
}

type DeleteLinkInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the link to delete.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLinkInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteLinkInput) SetIdentifier(v string) *DeleteLinkInput {
	s.Identifier = &v
	return s
}

type DeleteLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLinkOutput) GoString() string {
	return s.String()
}

type DeleteSinkInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the sink to delete.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSinkInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteSinkInput) SetIdentifier(v string) *DeleteSinkInput {
	s.Identifier = &v
	return s
}

type DeleteSinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSinkOutput) GoString() string {
	return s.String()
}

type GetLinkInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the link to retrieve information for.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLinkInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetLinkInput) SetIdentifier(v string) *GetLinkInput {
	s.Identifier = &v
	return s
}

type GetLinkOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the link.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the link
	// ARN.
	Id *string `type:"string"`

	// The label that you assigned to this link, with the variables resolved to
	// their actual values.
	Label *string `type:"string"`

	// The exact label template that was specified when the link was created, with
	// the template variables not resolved.
	LabelTemplate *string `type:"string"`

	// The resource types supported by this link.
	ResourceTypes []*string `type:"list"`

	// The ARN of the sink that is used for this link.
	SinkArn *string `type:"string"`

	// The tags assigned to the link.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLinkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetLinkOutput) SetArn(v string) *GetLinkOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetLinkOutput) SetId(v string) *GetLinkOutput {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *GetLinkOutput) SetLabel(v string) *GetLinkOutput {
	s.Label = &v
	return s
}

// SetLabelTemplate sets the LabelTemplate field's value.
func (s *GetLinkOutput) SetLabelTemplate(v string) *GetLinkOutput {
	s.LabelTemplate = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetLinkOutput) SetResourceTypes(v []*string) *GetLinkOutput {
	s.ResourceTypes = v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *GetLinkOutput) SetSinkArn(v string) *GetLinkOutput {
	s.SinkArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetLinkOutput) SetTags(v map[string]*string) *GetLinkOutput {
	s.Tags = v
	return s
}

type GetSinkInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the sink to retrieve information for.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSinkInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetSinkInput) SetIdentifier(v string) *GetSinkInput {
	s.Identifier = &v
	return s
}

type GetSinkOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the sink.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the sink
	// ARN.
	Id *string `type:"string"`

	// The name of the sink.
	Name *string `type:"string"`

	// The tags assigned to the sink.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSinkOutput) SetArn(v string) *GetSinkOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetSinkOutput) SetId(v string) *GetSinkOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetSinkOutput) SetName(v string) *GetSinkOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSinkOutput) SetTags(v map[string]*string) *GetSinkOutput {
	s.Tags = v
	return s
}

type GetSinkPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the sink to retrieve the policy of.
	//
	// SinkIdentifier is a required field
	SinkIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSinkPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSinkPolicyInput"}
	if s.SinkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSinkIdentifier sets the SinkIdentifier field's value.
func (s *GetSinkPolicyInput) SetSinkIdentifier(v string) *GetSinkPolicyInput {
	s.SinkIdentifier = &v
	return s
}

type GetSinkPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy that you specified, in JSON format.
	Policy *string `type:"string"`

	// The ARN of the sink.
	SinkArn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the sink
	// ARN.
	SinkId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSinkPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetSinkPolicyOutput) SetPolicy(v string) *GetSinkPolicyOutput {
	s.Policy = &v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *GetSinkPolicyOutput) SetSinkArn(v string) *GetSinkPolicyOutput {
	s.SinkArn = &v
	return s
}

// SetSinkId sets the SinkId field's value.
func (s *GetSinkPolicyOutput) SetSinkId(v string) *GetSinkPolicyOutput {
	s.SinkId = &v
	return s
}

// Unexpected error while processing the request. Retry the request.
type InternalServiceFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The name of the exception.
	AmznErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceFault) GoString() string {
	return s.String()
}

func newErrorInternalServiceFault(v protocol.ResponseMetadata) error {
	return &InternalServiceFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceFault) Code() string {
	return "InternalServiceFault"
}

// Message returns the exception's message.
func (s *InternalServiceFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceFault) OrigErr() error {
	return nil
}

func (s *InternalServiceFault) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter is specified incorrectly.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The name of the exception.
	AmznErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAttachedLinksInput struct {
	_ struct{} `type:"structure"`

	// Limits the number of returned links to the specified number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. You received this token from
	// a previous call.
	NextToken *string `type:"string"`

	// The ARN of the sink that you want to retrieve links for.
	//
	// SinkIdentifier is a required field
	SinkIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttachedLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttachedLinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedLinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttachedLinksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SinkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttachedLinksInput) SetMaxResults(v int64) *ListAttachedLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttachedLinksInput) SetNextToken(v string) *ListAttachedLinksInput {
	s.NextToken = &v
	return s
}

// SetSinkIdentifier sets the SinkIdentifier field's value.
func (s *ListAttachedLinksInput) SetSinkIdentifier(v string) *ListAttachedLinksInput {
	s.SinkIdentifier = &v
	return s
}

// A structure that contains information about one link attached to this monitoring
// account sink.
type ListAttachedLinksItem struct {
	_ struct{} `type:"structure"`

	// The label that was assigned to this link at creation, with the variables
	// resolved to their actual values.
	Label *string `type:"string"`

	// The ARN of the link.
	LinkArn *string `type:"string"`

	// The resource types supported by this link.
	ResourceTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttachedLinksItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttachedLinksItem) GoString() string {
	return s.String()
}

// SetLabel sets the Label field's value.
func (s *ListAttachedLinksItem) SetLabel(v string) *ListAttachedLinksItem {
	s.Label = &v
	return s
}

// SetLinkArn sets the LinkArn field's value.
func (s *ListAttachedLinksItem) SetLinkArn(v string) *ListAttachedLinksItem {
	s.LinkArn = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *ListAttachedLinksItem) SetResourceTypes(v []*string) *ListAttachedLinksItem {
	s.ResourceTypes = v
	return s
}

type ListAttachedLinksOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the information about the attached links.
	//
	// Items is a required field
	Items []*ListAttachedLinksItem `type:"list" required:"true"`

	// The token to use when requesting the next set of links.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttachedLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttachedLinksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListAttachedLinksOutput) SetItems(v []*ListAttachedLinksItem) *ListAttachedLinksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttachedLinksOutput) SetNextToken(v string) *ListAttachedLinksOutput {
	s.NextToken = &v
	return s
}

type ListLinksInput struct {
	_ struct{} `type:"structure"`

	// Limits the number of returned links to the specified number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. You received this token from
	// a previous call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLinksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLinksInput) SetMaxResults(v int64) *ListLinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLinksInput) SetNextToken(v string) *ListLinksInput {
	s.NextToken = &v
	return s
}

// A structure that contains information about one of this source account's
// links to a monitoring account.
type ListLinksItem struct {
	_ struct{} `type:"structure"`

	// The ARN of the link.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the link
	// ARN.
	Id *string `type:"string"`

	// The label that was assigned to this link at creation, with the variables
	// resolved to their actual values.
	Label *string `type:"string"`

	// The resource types supported by this link.
	ResourceTypes []*string `type:"list"`

	// The ARN of the sink that this link is attached to.
	SinkArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLinksItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLinksItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListLinksItem) SetArn(v string) *ListLinksItem {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListLinksItem) SetId(v string) *ListLinksItem {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ListLinksItem) SetLabel(v string) *ListLinksItem {
	s.Label = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *ListLinksItem) SetResourceTypes(v []*string) *ListLinksItem {
	s.ResourceTypes = v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *ListLinksItem) SetSinkArn(v string) *ListLinksItem {
	s.SinkArn = &v
	return s
}

type ListLinksOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the information about the returned links.
	//
	// Items is a required field
	Items []*ListLinksItem `type:"list" required:"true"`

	// The token to use when requesting the next set of links.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLinksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListLinksOutput) SetItems(v []*ListLinksItem) *ListLinksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLinksOutput) SetNextToken(v string) *ListLinksOutput {
	s.NextToken = &v
	return s
}

type ListSinksInput struct {
	_ struct{} `type:"structure"`

	// Limits the number of returned links to the specified number.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. You received this token from
	// a previous call.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSinksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSinksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSinksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSinksInput) SetMaxResults(v int64) *ListSinksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSinksInput) SetNextToken(v string) *ListSinksInput {
	s.NextToken = &v
	return s
}

// A structure that contains information about one of this monitoring account's
// sinks.
type ListSinksItem struct {
	_ struct{} `type:"structure"`

	// The ARN of the sink.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the sink
	// ARN.
	Id *string `type:"string"`

	// The name of the sink.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSinksItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSinksItem) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListSinksItem) SetArn(v string) *ListSinksItem {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListSinksItem) SetId(v string) *ListSinksItem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListSinksItem) SetName(v string) *ListSinksItem {
	s.Name = &v
	return s
}

type ListSinksOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain the information about the returned sinks.
	//
	// Items is a required field
	Items []*ListSinksItem `type:"list" required:"true"`

	// The token to use when requesting the next set of sinks.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSinksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListSinksOutput) SetItems(v []*ListSinksItem) *ListSinksOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSinksOutput) SetNextToken(v string) *ListSinksOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource that you want to view tags for.
	//
	// The ARN format of a sink is arn:aws:oam:Region:account-id:sink/sink-id
	//
	// The ARN format of a link is arn:aws:oam:Region:account-id:link/link-id
	//
	// For more information about ARN format, see CloudWatch Logs resources and
	// operations (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
	//
	// Unlike tagging permissions in other Amazon Web Services services, to retrieve
	// the list of tags for links or sinks you must have the oam:RequestTag permission.
	// The aws:ReguestTag permission does not allow you to tag and untag links and
	// sinks.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags associated with the requested resource.>
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A required parameter is missing from the request.
type MissingRequiredParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The name of the exception.
	AmznErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingRequiredParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingRequiredParameterException) GoString() string {
	return s.String()
}

func newErrorMissingRequiredParameterException(v protocol.ResponseMetadata) error {
	return &MissingRequiredParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingRequiredParameterException) Code() string {
	return "MissingRequiredParameterException"
}

// Message returns the exception's message.
func (s *MissingRequiredParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingRequiredParameterException) OrigErr() error {
	return nil
}

func (s *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingRequiredParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingRequiredParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutSinkPolicyInput struct {
	_ struct{} `type:"structure"`

	// The JSON policy to use. If you are updating an existing policy, the entire
	// existing policy is replaced by what you specify here.
	//
	// The policy must be in JSON string format with quotation marks escaped and
	// no newlines.
	//
	// For examples of different types of policies, see the Examples section on
	// this page.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`

	// The ARN of the sink to attach this policy to.
	//
	// SinkIdentifier is a required field
	SinkIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSinkPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSinkPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSinkPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSinkPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.SinkIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutSinkPolicyInput) SetPolicy(v string) *PutSinkPolicyInput {
	s.Policy = &v
	return s
}

// SetSinkIdentifier sets the SinkIdentifier field's value.
func (s *PutSinkPolicyInput) SetSinkIdentifier(v string) *PutSinkPolicyInput {
	s.SinkIdentifier = &v
	return s
}

type PutSinkPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy that you specified.
	Policy *string `type:"string"`

	// The ARN of the sink.
	SinkArn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the sink
	// ARN.
	SinkId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSinkPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutSinkPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *PutSinkPolicyOutput) SetPolicy(v string) *PutSinkPolicyOutput {
	s.Policy = &v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *PutSinkPolicyOutput) SetSinkArn(v string) *PutSinkPolicyOutput {
	s.SinkArn = &v
	return s
}

// SetSinkId sets the SinkId field's value.
func (s *PutSinkPolicyOutput) SetSinkId(v string) *PutSinkPolicyOutput {
	s.SinkId = &v
	return s
}

// The request references a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The name of the exception.
	AmznErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The name of the exception.
	AmznErrorType *string `location:"header" locationName:"x-amzn-ErrorType" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource that you're adding tags to.
	//
	// The ARN format of a sink is arn:aws:oam:Region:account-id:sink/sink-id
	//
	// The ARN format of a link is arn:aws:oam:Region:account-id:link/link-id
	//
	// For more information about ARN format, see CloudWatch Logs resources and
	// operations (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of key-value pairs to associate with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A resource can have no more than 50 tags.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource that you're removing tags from.
	//
	// The ARN format of a sink is arn:aws:oam:Region:account-id:sink/sink-id
	//
	// The ARN format of a link is arn:aws:oam:Region:account-id:link/link-id
	//
	// For more information about ARN format, see CloudWatch Logs resources and
	// operations (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLinkInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the link that you want to update.
	//
	// Identifier is a required field
	Identifier *string `type:"string" required:"true"`

	// An array of strings that define which types of data that the source account
	// will send to the monitoring account.
	//
	// Your input here replaces the current set of data types that are shared.
	//
	// ResourceTypes is a required field
	ResourceTypes []*string `min:"1" type:"list" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLinkInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.ResourceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTypes"))
	}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateLinkInput) SetIdentifier(v string) *UpdateLinkInput {
	s.Identifier = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *UpdateLinkInput) SetResourceTypes(v []*string) *UpdateLinkInput {
	s.ResourceTypes = v
	return s
}

type UpdateLinkOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the link that you have updated.
	Arn *string `type:"string"`

	// The random ID string that Amazon Web Services generated as part of the sink
	// ARN.
	Id *string `type:"string"`

	// The label assigned to this link, with the variables resolved to their actual
	// values.
	Label *string `type:"string"`

	// The exact label template that was specified when the link was created, with
	// the template variables not resolved.
	LabelTemplate *string `min:"1" type:"string"`

	// The resource types now supported by this link.
	ResourceTypes []*string `type:"list"`

	// The ARN of the sink that is used for this link.
	SinkArn *string `type:"string"`

	// The tags assigned to the link.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLinkOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateLinkOutput) SetArn(v string) *UpdateLinkOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateLinkOutput) SetId(v string) *UpdateLinkOutput {
	s.Id = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *UpdateLinkOutput) SetLabel(v string) *UpdateLinkOutput {
	s.Label = &v
	return s
}

// SetLabelTemplate sets the LabelTemplate field's value.
func (s *UpdateLinkOutput) SetLabelTemplate(v string) *UpdateLinkOutput {
	s.LabelTemplate = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *UpdateLinkOutput) SetResourceTypes(v []*string) *UpdateLinkOutput {
	s.ResourceTypes = v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *UpdateLinkOutput) SetSinkArn(v string) *UpdateLinkOutput {
	s.SinkArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateLinkOutput) SetTags(v map[string]*string) *UpdateLinkOutput {
	s.Tags = v
	return s
}

// The value of a parameter in the request caused an error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ResourceTypeAwsCloudWatchMetric is a ResourceType enum value
	ResourceTypeAwsCloudWatchMetric = "AWS::CloudWatch::Metric"

	// ResourceTypeAwsLogsLogGroup is a ResourceType enum value
	ResourceTypeAwsLogsLogGroup = "AWS::Logs::LogGroup"

	// ResourceTypeAwsXrayTrace is a ResourceType enum value
	ResourceTypeAwsXrayTrace = "AWS::XRay::Trace"

	// ResourceTypeAwsApplicationInsightsApplication is a ResourceType enum value
	ResourceTypeAwsApplicationInsightsApplication = "AWS::ApplicationInsights::Application"

	// ResourceTypeAwsInternetMonitorMonitor is a ResourceType enum value
	ResourceTypeAwsInternetMonitorMonitor = "AWS::InternetMonitor::Monitor"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeAwsCloudWatchMetric,
		ResourceTypeAwsLogsLogGroup,
		ResourceTypeAwsXrayTrace,
		ResourceTypeAwsApplicationInsightsApplication,
		ResourceTypeAwsInternetMonitorMonitor,
	}
}
