//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package azkeys

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// Client contains the methods for the Client group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal *azcore.Client
	endpoint string
}

// BackupKey - The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does
// NOT return key material in a form that can be used outside the Azure Key Vault system,
// the returned key material is either protected to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this
// operation is to allow a client to GENERATE a key in one Azure Key Vault
// instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP operation may be used to
// export, in protected form, any key type from Azure Key Vault. Individual
// versions of a key cannot be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that
// a BACKUP from one geographical area cannot be restored to another
// geographical area. For example, a backup from the US geographical area cannot be restored in an EU geographical area. This
// operation requires the key/backup permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - options - BackupKeyOptions contains the optional parameters for the Client.BackupKey method.
func (client *Client) BackupKey(ctx context.Context, name string, options *BackupKeyOptions) (BackupKeyResponse, error) {
	req, err := client.backupKeyCreateRequest(ctx, name, options)
	if err != nil {
		return BackupKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BackupKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BackupKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.backupKeyHandleResponse(resp)
}

// backupKeyCreateRequest creates the BackupKey request.
func (client *Client) backupKeyCreateRequest(ctx context.Context, name string, options *BackupKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/backup"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// backupKeyHandleResponse handles the BackupKey response.
func (client *Client) backupKeyHandleResponse(resp *http.Response) (BackupKeyResponse, error) {
	result := BackupKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupKeyResult); err != nil {
		return BackupKeyResponse{}, err
	}
	return result, nil
}

// CreateKey - The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists,
// Azure Key Vault creates a new version of the key. It requires the keys/create
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name for the new key. The system will generate the version name for the new key. The value you provide may be
//     copied globally for the purpose of running the service. The value provided should not
//     include personally identifiable or sensitive information.
//   - parameters - The parameters to create a key.
//   - options - CreateKeyOptions contains the optional parameters for the Client.CreateKey method.
func (client *Client) CreateKey(ctx context.Context, name string, parameters CreateKeyParameters, options *CreateKeyOptions) (CreateKeyResponse, error) {
	req, err := client.createKeyCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return CreateKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return CreateKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.createKeyHandleResponse(resp)
}

// createKeyCreateRequest creates the CreateKey request.
func (client *Client) createKeyCreateRequest(ctx context.Context, name string, parameters CreateKeyParameters, options *CreateKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/create"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createKeyHandleResponse handles the CreateKey response.
func (client *Client) createKeyHandleResponse(resp *http.Response) (CreateKeyResponse, error) {
	result := CreateKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return CreateKeyResponse{}, err
	}
	return result, nil
}

// Decrypt - The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified
// algorithm. This operation is the reverse of the ENCRYPT operation; only a single block of
// data may be decrypted, the size of this block is dependent on the target key and the algorithm to be used. The DECRYPT
// operation applies to asymmetric and symmetric keys stored in Azure Key Vault
// since it uses the private portion of the key. This operation requires the keys/decrypt permission. Microsoft recommends
// not to use CBC algorithms for decryption without first ensuring the integrity of
// the ciphertext using an HMAC, for example. See https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode
// for more information.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the decryption operation.
//   - options - DecryptOptions contains the optional parameters for the Client.Decrypt method.
func (client *Client) Decrypt(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *DecryptOptions) (DecryptResponse, error) {
	req, err := client.decryptCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return DecryptResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DecryptResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DecryptResponse{}, runtime.NewResponseError(resp)
	}
	return client.decryptHandleResponse(resp)
}

// decryptCreateRequest creates the Decrypt request.
func (client *Client) decryptCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *DecryptOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/decrypt"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// decryptHandleResponse handles the Decrypt response.
func (client *Client) decryptHandleResponse(resp *http.Response) (DecryptResponse, error) {
	result := DecryptResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return DecryptResponse{}, err
	}
	return result, nil
}

// DeleteKey - The delete key operation cannot be used to remove individual versions of a key. This operation removes the
// cryptographic material associated with the key, which means the key is not usable for
// Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the keys/delete permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key to delete.
//   - options - DeleteKeyOptions contains the optional parameters for the Client.DeleteKey method.
func (client *Client) DeleteKey(ctx context.Context, name string, options *DeleteKeyOptions) (DeleteKeyResponse, error) {
	req, err := client.deleteKeyCreateRequest(ctx, name, options)
	if err != nil {
		return DeleteKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeleteKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteKeyHandleResponse(resp)
}

// deleteKeyCreateRequest creates the DeleteKey request.
func (client *Client) deleteKeyCreateRequest(ctx context.Context, name string, options *DeleteKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteKeyHandleResponse handles the DeleteKey response.
func (client *Client) deleteKeyHandleResponse(resp *http.Response) (DeleteKeyResponse, error) {
	result := DeleteKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyBundle); err != nil {
		return DeleteKeyResponse{}, err
	}
	return result, nil
}

// Encrypt - The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure
// Key Vault. Note that the ENCRYPT operation only supports a single block of data, the size
// of which is dependent on the target key and the encryption algorithm to be used. The ENCRYPT operation is only strictly
// necessary for symmetric keys stored in Azure Key Vault since protection with an
// asymmetric key can be performed using public portion of the key. This operation is supported for asymmetric keys as a convenience
// for callers that have a key-reference but do not have access to the
// public key material. This operation requires the keys/encrypt permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the encryption operation.
//   - options - EncryptOptions contains the optional parameters for the Client.Encrypt method.
func (client *Client) Encrypt(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *EncryptOptions) (EncryptResponse, error) {
	req, err := client.encryptCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return EncryptResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EncryptResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EncryptResponse{}, runtime.NewResponseError(resp)
	}
	return client.encryptHandleResponse(resp)
}

// encryptCreateRequest creates the Encrypt request.
func (client *Client) encryptCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *EncryptOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/encrypt"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// encryptHandleResponse handles the Encrypt response.
func (client *Client) encryptHandleResponse(resp *http.Response) (EncryptResponse, error) {
	result := EncryptResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return EncryptResponse{}, err
	}
	return result, nil
}

// GetDeletedKey - The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be
// invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault. This
// operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - options - GetDeletedKeyOptions contains the optional parameters for the Client.GetDeletedKey method.
func (client *Client) GetDeletedKey(ctx context.Context, name string, options *GetDeletedKeyOptions) (GetDeletedKeyResponse, error) {
	req, err := client.getDeletedKeyCreateRequest(ctx, name, options)
	if err != nil {
		return GetDeletedKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetDeletedKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeletedKeyHandleResponse(resp)
}

// getDeletedKeyCreateRequest creates the GetDeletedKey request.
func (client *Client) getDeletedKeyCreateRequest(ctx context.Context, name string, options *GetDeletedKeyOptions) (*policy.Request, error) {
	urlPath := "/deletedkeys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeletedKeyHandleResponse handles the GetDeletedKey response.
func (client *Client) getDeletedKeyHandleResponse(resp *http.Response) (GetDeletedKeyResponse, error) {
	result := GetDeletedKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyBundle); err != nil {
		return GetDeletedKeyResponse{}, err
	}
	return result, nil
}

// GetKey - The get key operation is applicable to all key types. If the requested key is symmetric, then no key material
// is released in the response. This operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key to get.
//   - version - Adding the version parameter retrieves a specific version of a key. This URI fragment is optional. If not specified,
//     the latest version of the key is returned.
//   - options - GetKeyOptions contains the optional parameters for the Client.GetKey method.
func (client *Client) GetKey(ctx context.Context, name string, version string, options *GetKeyOptions) (GetKeyResponse, error) {
	req, err := client.getKeyCreateRequest(ctx, name, version, options)
	if err != nil {
		return GetKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getKeyHandleResponse(resp)
}

// getKeyCreateRequest creates the GetKey request.
func (client *Client) getKeyCreateRequest(ctx context.Context, name string, version string, options *GetKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getKeyHandleResponse handles the GetKey response.
func (client *Client) getKeyHandleResponse(resp *http.Response) (GetKeyResponse, error) {
	result := GetKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return GetKeyResponse{}, err
	}
	return result, nil
}

// GetKeyRotationPolicy - The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key
// vault. This operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key in a given key vault.
//   - options - GetKeyRotationPolicyOptions contains the optional parameters for the Client.GetKeyRotationPolicy method.
func (client *Client) GetKeyRotationPolicy(ctx context.Context, name string, options *GetKeyRotationPolicyOptions) (GetKeyRotationPolicyResponse, error) {
	req, err := client.getKeyRotationPolicyCreateRequest(ctx, name, options)
	if err != nil {
		return GetKeyRotationPolicyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetKeyRotationPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetKeyRotationPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getKeyRotationPolicyHandleResponse(resp)
}

// getKeyRotationPolicyCreateRequest creates the GetKeyRotationPolicy request.
func (client *Client) getKeyRotationPolicyCreateRequest(ctx context.Context, name string, options *GetKeyRotationPolicyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/rotationpolicy"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getKeyRotationPolicyHandleResponse handles the GetKeyRotationPolicy response.
func (client *Client) getKeyRotationPolicyHandleResponse(resp *http.Response) (GetKeyRotationPolicyResponse, error) {
	result := GetKeyRotationPolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyRotationPolicy); err != nil {
		return GetKeyRotationPolicyResponse{}, err
	}
	return result, nil
}

// GetRandomBytes - Get the requested number of bytes containing random values from a managed HSM.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - parameters - The request object to get random bytes.
//   - options - GetRandomBytesOptions contains the optional parameters for the Client.GetRandomBytes method.
func (client *Client) GetRandomBytes(ctx context.Context, parameters GetRandomBytesRequest, options *GetRandomBytesOptions) (GetRandomBytesResponse, error) {
	req, err := client.getRandomBytesCreateRequest(ctx, parameters, options)
	if err != nil {
		return GetRandomBytesResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetRandomBytesResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetRandomBytesResponse{}, runtime.NewResponseError(resp)
	}
	return client.getRandomBytesHandleResponse(resp)
}

// getRandomBytesCreateRequest creates the GetRandomBytes request.
func (client *Client) getRandomBytesCreateRequest(ctx context.Context, parameters GetRandomBytesRequest, options *GetRandomBytesOptions) (*policy.Request, error) {
	urlPath := "/rng"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// getRandomBytesHandleResponse handles the GetRandomBytes response.
func (client *Client) getRandomBytesHandleResponse(resp *http.Response) (GetRandomBytesResponse, error) {
	result := GetRandomBytesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RandomBytes); err != nil {
		return GetRandomBytesResponse{}, err
	}
	return result, nil
}

// ImportKey - The import key operation may be used to import any key type into an Azure Key Vault. If the named key already
// exists, Azure Key Vault creates a new version of the key. This operation requires the
// keys/import permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - Name for the imported key. The value you provide may be copied globally for the purpose of running the service.
//     The value provided should not include personally identifiable or sensitive information.
//   - parameters - The parameters to import a key.
//   - options - ImportKeyOptions contains the optional parameters for the Client.ImportKey method.
func (client *Client) ImportKey(ctx context.Context, name string, parameters ImportKeyParameters, options *ImportKeyOptions) (ImportKeyResponse, error) {
	req, err := client.importKeyCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return ImportKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ImportKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ImportKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.importKeyHandleResponse(resp)
}

// importKeyCreateRequest creates the ImportKey request.
func (client *Client) importKeyCreateRequest(ctx context.Context, name string, parameters ImportKeyParameters, options *ImportKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// importKeyHandleResponse handles the ImportKey response.
func (client *Client) importKeyHandleResponse(resp *http.Response) (ImportKeyResponse, error) {
	result := ImportKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return ImportKeyResponse{}, err
	}
	return result, nil
}

// NewListDeletedKeysPager - Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public
// part of a deleted key. This operation includes deletion-specific information. The Get Deleted Keys
// operation is applicable for vaults enabled for soft-delete. While the operation can be invoked on any vault, it will return
// an error if invoked on a non soft-delete enabled vault. This operation
// requires the keys/list permission.
//
// Generated from API version 7.4
//   - options - ListDeletedKeysOptions contains the optional parameters for the Client.NewListDeletedKeysPager method.
func (client *Client) NewListDeletedKeysPager(options *ListDeletedKeysOptions) *runtime.Pager[ListDeletedKeysResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListDeletedKeysResponse]{
		More: func(page ListDeletedKeysResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListDeletedKeysResponse) (ListDeletedKeysResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listDeletedKeysCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListDeletedKeysResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ListDeletedKeysResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListDeletedKeysResponse{}, runtime.NewResponseError(resp)
			}
			return client.listDeletedKeysHandleResponse(resp)
		},
	})
}

// listDeletedKeysCreateRequest creates the ListDeletedKeys request.
func (client *Client) listDeletedKeysCreateRequest(ctx context.Context, options *ListDeletedKeysOptions) (*policy.Request, error) {
	urlPath := "/deletedkeys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeletedKeysHandleResponse handles the ListDeletedKeys response.
func (client *Client) listDeletedKeysHandleResponse(resp *http.Response) (ListDeletedKeysResponse, error) {
	result := ListDeletedKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyListResult); err != nil {
		return ListDeletedKeysResponse{}, err
	}
	return result, nil
}

// NewListKeyVersionsPager - The full key identifier, attributes, and tags are provided in the response. This operation requires
// the keys/list permission.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - options - ListKeyVersionsOptions contains the optional parameters for the Client.NewListKeyVersionsPager method.
func (client *Client) NewListKeyVersionsPager(name string, options *ListKeyVersionsOptions) *runtime.Pager[ListKeyVersionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListKeyVersionsResponse]{
		More: func(page ListKeyVersionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListKeyVersionsResponse) (ListKeyVersionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listKeyVersionsCreateRequest(ctx, name, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListKeyVersionsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ListKeyVersionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListKeyVersionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listKeyVersionsHandleResponse(resp)
		},
	})
}

// listKeyVersionsCreateRequest creates the ListKeyVersions request.
func (client *Client) listKeyVersionsCreateRequest(ctx context.Context, name string, options *ListKeyVersionsOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/versions"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeyVersionsHandleResponse handles the ListKeyVersions response.
func (client *Client) listKeyVersionsHandleResponse(resp *http.Response) (ListKeyVersionsResponse, error) {
	result := ListKeyVersionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return ListKeyVersionsResponse{}, err
	}
	return result, nil
}

// NewListKeysPager - Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part
// of a stored key. The LIST operation is applicable to all key types, however only the base key
// identifier, attributes, and tags are provided in the response. Individual versions of a key are not listed in the response.
// This operation requires the keys/list permission.
//
// Generated from API version 7.4
//   - options - ListKeysOptions contains the optional parameters for the Client.NewListKeysPager method.
func (client *Client) NewListKeysPager(options *ListKeysOptions) *runtime.Pager[ListKeysResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListKeysResponse]{
		More: func(page ListKeysResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListKeysResponse) (ListKeysResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listKeysCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListKeysResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ListKeysResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListKeysResponse{}, runtime.NewResponseError(resp)
			}
			return client.listKeysHandleResponse(resp)
		},
	})
}

// listKeysCreateRequest creates the ListKeys request.
func (client *Client) listKeysCreateRequest(ctx context.Context, options *ListKeysOptions) (*policy.Request, error) {
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeysHandleResponse handles the ListKeys response.
func (client *Client) listKeysHandleResponse(resp *http.Response) (ListKeysResponse, error) {
	result := ListKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyListResult); err != nil {
		return ListKeysResponse{}, err
	}
	return result, nil
}

// PurgeDeletedKey - The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can
// be invoked on any vault, it will return an error if invoked on a non soft-delete enabled vault.
// This operation requires the keys/purge permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key
//   - options - PurgeDeletedKeyOptions contains the optional parameters for the Client.PurgeDeletedKey method.
func (client *Client) PurgeDeletedKey(ctx context.Context, name string, options *PurgeDeletedKeyOptions) (PurgeDeletedKeyResponse, error) {
	req, err := client.purgeDeletedKeyCreateRequest(ctx, name, options)
	if err != nil {
		return PurgeDeletedKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PurgeDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return PurgeDeletedKeyResponse{}, runtime.NewResponseError(resp)
	}
	return PurgeDeletedKeyResponse{}, nil
}

// purgeDeletedKeyCreateRequest creates the PurgeDeletedKey request.
func (client *Client) purgeDeletedKeyCreateRequest(ctx context.Context, name string, options *PurgeDeletedKeyOptions) (*policy.Request, error) {
	urlPath := "/deletedkeys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RecoverDeletedKey - The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It
// recovers the deleted key back to its latest version under /keys. An attempt to recover an non-deleted
// key will return an error. Consider this the inverse of the delete operation on soft-delete enabled vaults. This operation
// requires the keys/recover permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the deleted key.
//   - options - RecoverDeletedKeyOptions contains the optional parameters for the Client.RecoverDeletedKey method.
func (client *Client) RecoverDeletedKey(ctx context.Context, name string, options *RecoverDeletedKeyOptions) (RecoverDeletedKeyResponse, error) {
	req, err := client.recoverDeletedKeyCreateRequest(ctx, name, options)
	if err != nil {
		return RecoverDeletedKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RecoverDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecoverDeletedKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.recoverDeletedKeyHandleResponse(resp)
}

// recoverDeletedKeyCreateRequest creates the RecoverDeletedKey request.
func (client *Client) recoverDeletedKeyCreateRequest(ctx context.Context, name string, options *RecoverDeletedKeyOptions) (*policy.Request, error) {
	urlPath := "/deletedkeys/{key-name}/recover"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// recoverDeletedKeyHandleResponse handles the RecoverDeletedKey response.
func (client *Client) recoverDeletedKeyHandleResponse(resp *http.Response) (RecoverDeletedKeyResponse, error) {
	result := RecoverDeletedKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return RecoverDeletedKeyResponse{}, err
	}
	return result, nil
}

// Release - The release key operation is applicable to all key types. The target key must be marked exportable. This operation
// requires the keys/release permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key to get.
//   - version - Adding the version parameter retrieves a specific version of a key.
//   - parameters - The parameters for the key release operation.
//   - options - ReleaseOptions contains the optional parameters for the Client.Release method.
func (client *Client) Release(ctx context.Context, name string, version string, parameters ReleaseParameters, options *ReleaseOptions) (ReleaseResponse, error) {
	req, err := client.releaseCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return ReleaseResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ReleaseResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ReleaseResponse{}, runtime.NewResponseError(resp)
	}
	return client.releaseHandleResponse(resp)
}

// releaseCreateRequest creates the Release request.
func (client *Client) releaseCreateRequest(ctx context.Context, name string, version string, parameters ReleaseParameters, options *ReleaseOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/release"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// releaseHandleResponse handles the Release response.
func (client *Client) releaseHandleResponse(resp *http.Response) (ReleaseResponse, error) {
	result := ReleaseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyReleaseResult); err != nil {
		return ReleaseResponse{}, err
	}
	return result, nil
}

// RestoreKey - Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes
// and access control policies. The RESTORE operation may be used to import a previously backed
// up key. Individual versions of a key cannot be restored. The key is restored in its entirety with the same key name as
// it had when it was backed up. If the key name is not available in the target Key
// Vault, the RESTORE operation will be rejected. While the key name is retained during restore, the final key identifier
// will change if the key is restored to a different vault. Restore will restore all
// versions and preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault
// must be owned by the same Microsoft Azure Subscription as the source Key Vault
// The user must have RESTORE permission in the target Key Vault. This operation requires the keys/restore permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - parameters - The parameters to restore the key.
//   - options - RestoreKeyOptions contains the optional parameters for the Client.RestoreKey method.
func (client *Client) RestoreKey(ctx context.Context, parameters RestoreKeyParameters, options *RestoreKeyOptions) (RestoreKeyResponse, error) {
	req, err := client.restoreKeyCreateRequest(ctx, parameters, options)
	if err != nil {
		return RestoreKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RestoreKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RestoreKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.restoreKeyHandleResponse(resp)
}

// restoreKeyCreateRequest creates the RestoreKey request.
func (client *Client) restoreKeyCreateRequest(ctx context.Context, parameters RestoreKeyParameters, options *RestoreKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// restoreKeyHandleResponse handles the RestoreKey response.
func (client *Client) restoreKeyHandleResponse(resp *http.Response) (RestoreKeyResponse, error) {
	result := RestoreKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return RestoreKeyResponse{}, err
	}
	return result, nil
}

// RotateKey - The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of key to be rotated. The system will generate a new version in the specified key.
//   - options - RotateKeyOptions contains the optional parameters for the Client.RotateKey method.
func (client *Client) RotateKey(ctx context.Context, name string, options *RotateKeyOptions) (RotateKeyResponse, error) {
	req, err := client.rotateKeyCreateRequest(ctx, name, options)
	if err != nil {
		return RotateKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RotateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RotateKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.rotateKeyHandleResponse(resp)
}

// rotateKeyCreateRequest creates the RotateKey request.
func (client *Client) rotateKeyCreateRequest(ctx context.Context, name string, options *RotateKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/rotate"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// rotateKeyHandleResponse handles the RotateKey response.
func (client *Client) rotateKeyHandleResponse(resp *http.Response) (RotateKeyResponse, error) {
	result := RotateKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return RotateKeyResponse{}, err
	}
	return result, nil
}

// Sign - The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation
// uses the private portion of the key. This operation requires the keys/sign permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the signing operation.
//   - options - SignOptions contains the optional parameters for the Client.Sign method.
func (client *Client) Sign(ctx context.Context, name string, version string, parameters SignParameters, options *SignOptions) (SignResponse, error) {
	req, err := client.signCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return SignResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SignResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SignResponse{}, runtime.NewResponseError(resp)
	}
	return client.signHandleResponse(resp)
}

// signCreateRequest creates the Sign request.
func (client *Client) signCreateRequest(ctx context.Context, name string, version string, parameters SignParameters, options *SignOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/sign"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// signHandleResponse handles the Sign response.
func (client *Client) signHandleResponse(resp *http.Response) (SignResponse, error) {
	result := SignResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return SignResponse{}, err
	}
	return result, nil
}

// UnwrapKey - The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation
// is the reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and
// symmetric keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/unwrapKey
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the key operation.
//   - options - UnwrapKeyOptions contains the optional parameters for the Client.UnwrapKey method.
func (client *Client) UnwrapKey(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *UnwrapKeyOptions) (UnwrapKeyResponse, error) {
	req, err := client.unwrapKeyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return UnwrapKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UnwrapKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UnwrapKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.unwrapKeyHandleResponse(resp)
}

// unwrapKeyCreateRequest creates the UnwrapKey request.
func (client *Client) unwrapKeyCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *UnwrapKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/unwrapkey"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// unwrapKeyHandleResponse handles the UnwrapKey response.
func (client *Client) unwrapKeyHandleResponse(resp *http.Response) (UnwrapKeyResponse, error) {
	result := UnwrapKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return UnwrapKeyResponse{}, err
	}
	return result, nil
}

// UpdateKey - In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material
// of a key itself cannot be changed. This operation requires the keys/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of key to update.
//   - version - The version of the key to update.
//   - parameters - The parameters of the key to update.
//   - options - UpdateKeyOptions contains the optional parameters for the Client.UpdateKey method.
func (client *Client) UpdateKey(ctx context.Context, name string, version string, parameters UpdateKeyParameters, options *UpdateKeyOptions) (UpdateKeyResponse, error) {
	req, err := client.updateKeyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return UpdateKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UpdateKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateKeyHandleResponse(resp)
}

// updateKeyCreateRequest creates the UpdateKey request.
func (client *Client) updateKeyCreateRequest(ctx context.Context, name string, version string, parameters UpdateKeyParameters, options *UpdateKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateKeyHandleResponse handles the UpdateKey response.
func (client *Client) updateKeyHandleResponse(resp *http.Response) (UpdateKeyResponse, error) {
	result := UpdateKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return UpdateKeyResponse{}, err
	}
	return result, nil
}

// UpdateKeyRotationPolicy - Set specified members in the key policy. Leave others as undefined. This operation requires the
// keys/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key in the given vault.
//   - keyRotationPolicy - The policy for the key.
//   - options - UpdateKeyRotationPolicyOptions contains the optional parameters for the Client.UpdateKeyRotationPolicy
//     method.
func (client *Client) UpdateKeyRotationPolicy(ctx context.Context, name string, keyRotationPolicy KeyRotationPolicy, options *UpdateKeyRotationPolicyOptions) (UpdateKeyRotationPolicyResponse, error) {
	req, err := client.updateKeyRotationPolicyCreateRequest(ctx, name, keyRotationPolicy, options)
	if err != nil {
		return UpdateKeyRotationPolicyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateKeyRotationPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UpdateKeyRotationPolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateKeyRotationPolicyHandleResponse(resp)
}

// updateKeyRotationPolicyCreateRequest creates the UpdateKeyRotationPolicy request.
func (client *Client) updateKeyRotationPolicyCreateRequest(ctx context.Context, name string, keyRotationPolicy KeyRotationPolicy, options *UpdateKeyRotationPolicyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/rotationpolicy"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, keyRotationPolicy)
}

// updateKeyRotationPolicyHandleResponse handles the UpdateKeyRotationPolicy response.
func (client *Client) updateKeyRotationPolicyHandleResponse(resp *http.Response) (UpdateKeyRotationPolicyResponse, error) {
	result := UpdateKeyRotationPolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyRotationPolicy); err != nil {
		return UpdateKeyRotationPolicyResponse{}, err
	}
	return result, nil
}

// Verify - The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary
// for asymmetric keys stored in Azure Key Vault since signature verification can be
// performed using the public portion of the key but this operation is supported as a convenience for callers that only have
// a key-reference and not the public portion of the key. This operation requires
// the keys/verify permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for verify operations.
//   - options - VerifyOptions contains the optional parameters for the Client.Verify method.
func (client *Client) Verify(ctx context.Context, name string, version string, parameters VerifyParameters, options *VerifyOptions) (VerifyResponse, error) {
	req, err := client.verifyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return VerifyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VerifyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return VerifyResponse{}, runtime.NewResponseError(resp)
	}
	return client.verifyHandleResponse(resp)
}

// verifyCreateRequest creates the Verify request.
func (client *Client) verifyCreateRequest(ctx context.Context, name string, version string, parameters VerifyParameters, options *VerifyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/verify"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// verifyHandleResponse handles the Verify response.
func (client *Client) verifyHandleResponse(resp *http.Response) (VerifyResponse, error) {
	result := VerifyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyVerifyResult); err != nil {
		return VerifyResponse{}, err
	}
	return result, nil
}

// WrapKey - The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been
// stored in an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric
// keys stored in Azure Key Vault since protection with an asymmetric key can be performed using the public portion of the
// key. This operation is supported for asymmetric keys as a convenience for
// callers that have a key-reference but do not have access to the public key material. This operation requires the keys/wrapKey
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.4
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for wrap operation.
//   - options - WrapKeyOptions contains the optional parameters for the Client.WrapKey method.
func (client *Client) WrapKey(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *WrapKeyOptions) (WrapKeyResponse, error) {
	req, err := client.wrapKeyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return WrapKeyResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WrapKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WrapKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.wrapKeyHandleResponse(resp)
}

// wrapKeyCreateRequest creates the WrapKey request.
func (client *Client) wrapKeyCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationsParameters, options *WrapKeyOptions) (*policy.Request, error) {
	urlPath := "/keys/{key-name}/{key-version}/wrapkey"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.4")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// wrapKeyHandleResponse handles the WrapKey response.
func (client *Client) wrapKeyHandleResponse(resp *http.Response) (WrapKeyResponse, error) {
	result := WrapKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return WrapKeyResponse{}, err
	}
	return result, nil
}
