/*
* Copyright 2018 - Present Okta, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by okta openapi generator. DO NOT EDIT.

package okta

import (
	"context"
	"fmt"
)

type EmailTemplateResource resource

type EmailTemplate struct {
	Links interface{} `json:"_links,omitempty"`
	Name  string      `json:"name,omitempty"`
}

// Fetch an email template by templateName
func (m *EmailTemplateResource) GetEmailTemplate(ctx context.Context, brandId string, templateName string) (*EmailTemplate, *Response, error) {
	url := fmt.Sprintf("/api/v1/brands/%v/templates/email/%v", brandId, templateName)

	rq := m.client.CloneRequestExecutor()

	req, err := rq.WithAccept("application/json").WithContentType("application/json").NewRequest("GET", url, nil)
	if err != nil {
		return nil, nil, err
	}

	var emailTemplate *EmailTemplate

	resp, err := rq.Do(ctx, req, &emailTemplate)
	if err != nil {
		return nil, resp, err
	}

	return emailTemplate, resp, nil
}
