//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfboolean?language=objc)
#[repr(C)]
pub struct CFBoolean {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFBoolean"]
    unsafe impl CFBoolean {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbooleantrue?language=objc)
    pub static kCFBooleanTrue: Option<&'static CFBoolean>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbooleanfalse?language=objc)
    pub static kCFBooleanFalse: Option<&'static CFBoolean>;
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFBoolean {
    #[doc(alias = "CFBooleanGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFBooleanGetTypeID() -> CFTypeID;
        }
        unsafe { CFBooleanGetTypeID() }
    }
}

#[inline]
pub unsafe extern "C-unwind" fn CFBooleanGetValue(boolean: &CFBoolean) -> bool {
    extern "C-unwind" {
        fn CFBooleanGetValue(boolean: &CFBoolean) -> Boolean;
    }
    let ret = unsafe { CFBooleanGetValue(boolean) };
    ret != 0
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumbertype?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFNumberType(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFNumberType {
    #[doc(alias = "kCFNumberSInt8Type")]
    pub const SInt8Type: Self = Self(1);
    #[doc(alias = "kCFNumberSInt16Type")]
    pub const SInt16Type: Self = Self(2);
    #[doc(alias = "kCFNumberSInt32Type")]
    pub const SInt32Type: Self = Self(3);
    #[doc(alias = "kCFNumberSInt64Type")]
    pub const SInt64Type: Self = Self(4);
    #[doc(alias = "kCFNumberFloat32Type")]
    pub const Float32Type: Self = Self(5);
    #[doc(alias = "kCFNumberFloat64Type")]
    pub const Float64Type: Self = Self(6);
    #[doc(alias = "kCFNumberCharType")]
    pub const CharType: Self = Self(7);
    #[doc(alias = "kCFNumberShortType")]
    pub const ShortType: Self = Self(8);
    #[doc(alias = "kCFNumberIntType")]
    pub const IntType: Self = Self(9);
    #[doc(alias = "kCFNumberLongType")]
    pub const LongType: Self = Self(10);
    #[doc(alias = "kCFNumberLongLongType")]
    pub const LongLongType: Self = Self(11);
    #[doc(alias = "kCFNumberFloatType")]
    pub const FloatType: Self = Self(12);
    #[doc(alias = "kCFNumberDoubleType")]
    pub const DoubleType: Self = Self(13);
    #[doc(alias = "kCFNumberCFIndexType")]
    pub const CFIndexType: Self = Self(14);
    #[doc(alias = "kCFNumberNSIntegerType")]
    pub const NSIntegerType: Self = Self(15);
    #[doc(alias = "kCFNumberCGFloatType")]
    pub const CGFloatType: Self = Self(16);
    #[doc(alias = "kCFNumberMaxType")]
    pub const MaxType: Self = Self(16);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFNumberType {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFNumberType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnumber?language=objc)
#[repr(C)]
pub struct CFNumber {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFNumber"]
    unsafe impl CFNumber {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumberpositiveinfinity?language=objc)
    pub static kCFNumberPositiveInfinity: Option<&'static CFNumber>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumbernegativeinfinity?language=objc)
    pub static kCFNumberNegativeInfinity: Option<&'static CFNumber>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnumbernan?language=objc)
    pub static kCFNumberNaN: Option<&'static CFNumber>;
}

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFNumber {
    #[doc(alias = "CFNumberGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFNumberGetTypeID() -> CFTypeID;
        }
        unsafe { CFNumberGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberCreate(
    allocator: Option<&CFAllocator>,
    the_type: CFNumberType,
    value_ptr: *const c_void,
) -> Option<CFRetained<CFNumber>> {
    extern "C-unwind" {
        fn CFNumberCreate(
            allocator: Option<&CFAllocator>,
            the_type: CFNumberType,
            value_ptr: *const c_void,
        ) -> Option<NonNull<CFNumber>>;
    }
    let ret = unsafe { CFNumberCreate(allocator, the_type, value_ptr) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFNumberGetType(number: &CFNumber) -> CFNumberType;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFNumberGetByteSize(number: &CFNumber) -> CFIndex;
}

#[inline]
pub unsafe extern "C-unwind" fn CFNumberIsFloatType(number: &CFNumber) -> bool {
    extern "C-unwind" {
        fn CFNumberIsFloatType(number: &CFNumber) -> Boolean;
    }
    let ret = unsafe { CFNumberIsFloatType(number) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFNumberGetValue(
    number: &CFNumber,
    the_type: CFNumberType,
    value_ptr: *mut c_void,
) -> bool {
    extern "C-unwind" {
        fn CFNumberGetValue(
            number: &CFNumber,
            the_type: CFNumberType,
            value_ptr: *mut c_void,
        ) -> Boolean;
    }
    let ret = unsafe { CFNumberGetValue(number, the_type, value_ptr) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFNumberCompare(
        number: &CFNumber,
        other_number: Option<&CFNumber>,
        context: *mut c_void,
    ) -> CFComparisonResult;
}
