/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench.reports;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBFileChooserButton;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBSaveLoadTemplate;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.pegacat.jxworkbench.reports.JRLDAPDataSource;
import com.pegacat.jxworkbench.reports.JasperApplication;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class JXWReport
extends CBDialog {
    private static String currentTemplateName = "";
    protected JXplorerBrowser owningBrowser;
    final JRadioButton reportDN = new JRadioButton("...", false);
    final JRadioButton currentSelectedDN = new JRadioButton("...", true);
    final JTextField reportFileName = new JTextField();
    final JTextField outputDirName = new JTextField();
    final JCheckBox outputPDF = new JCheckBox("PDF");
    final JCheckBox outputHTML = new JCheckBox("HTML");
    final JCheckBox outputXML = new JCheckBox("XML");
    final JCheckBox outputRTF = new JCheckBox("RTF");
    final JCheckBox outputPPTX = new JCheckBox("PPTX");
    final JCheckBox outputDOCX = new JCheckBox("DOCX");
    final JCheckBox outputXLS = new JCheckBox("XLS");
    final JCheckBox outputViewer = new JCheckBox("viewer");
    final CBSaveLoadTemplate myTemplater = new CBSaveLoadTemplate(JXplorer.APPLICATION_NAME, "reportconfig.txt");
    private static boolean firstTime = true;
    private static Logger log = Logger.getLogger(JXWReport.class.getName());
    CBFileChooserButton reportFileChooser = new CBFileChooserButton((JTextComponent)this.reportFileName, (Component)((Object)this), CBIntText.get((String)"report"));
    CBFileChooserButton outputDirChooser = new CBFileChooserButton((JTextComponent)this.outputDirName, (Component)((Object)this), CBIntText.get((String)"directory"));
    boolean jasperAvailable = false;

    public JXWReport(JXplorerBrowser owner) {
        super((Frame)owner, CBIntText.get((String)"JXWorkBench Report Manager"), "workbench.io");
        this.owningBrowser = owner;
        this.setupBaseOptionsDialog();
    }

    public File getReportFile() {
        try {
            File reportFile = new File(this.reportFileName.getText());
            JXConfig.setProperty((String)"report.sourceDir", (String)reportFile.getParent());
            return reportFile;
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getDestinationDirectory() {
        try {
            File outputFile = new File(this.outputDirName.getText());
            JXConfig.setProperty((String)"report.outputDir", (String)outputFile.getAbsolutePath());
            return outputFile;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getOutputFormats() {
        JCheckBox[] outputCheckBoxes = new JCheckBox[]{this.outputPDF, this.outputHTML, this.outputXML, this.outputRTF, this.outputPPTX, this.outputDOCX, this.outputXLS, this.outputViewer};
        String[] options = new String[outputCheckBoxes.length];
        int i = 0;
        for (JCheckBox box : outputCheckBoxes) {
            if (!box.isSelected()) continue;
            options[i++] = box.getText().toUpperCase();
        }
        return options;
    }

    public DN getReportDN() {
        DN reportRoot = this.reportDN.isSelected() ? null : new DN(this.currentSelectedDN.getText());
        return reportRoot;
    }

    public void showUI() {
        SmartTree tree = this.owningBrowser.getActiveTree();
        if (tree == null) {
            log.warning("Attempt to show report screen with no active tree");
        } else {
            DN selected = tree.getCurrentDN();
            this.reportDN.setText("DN in Report");
            this.currentSelectedDN.setText(selected == null ? "error" : selected.toString());
        }
        if (this.checkIfJasperAvailable()) {
            this.setVisible(true);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), CBIntText.get((String)"Jasper Reports package is not loaded.  Please download from http://jxworkbench.com"), CBIntText.get((String)"Jasper Error"), 0);
        }
    }

    public boolean checkIfJasperAvailable() {
        if (this.jasperAvailable) {
            return true;
        }
        try {
            ClassLoader classLoader = this.owningBrowser.getJXplorer().getClassLoader();
            Class<?> c = classLoader.loadClass("net.sf.jasperreports.engine.JasperPrint");
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            Object printObject = constructor.newInstance(new Object[0]);
            log.info("Jasper Available loaded");
            JasperApplication.initJasperProperties();
            this.jasperAvailable = true;
            return true;
        }
        catch (Exception e) {
            log.info("Jasper classes are not available - download patch from jxworkbench.com");
            this.jasperAvailable = false;
            return false;
        }
    }

    public void doOK() {
        String[] bloop;
        if (!this.jasperAvailable) {
            this.closeDown();
            return;
        }
        if (this.getReportFile() == null) {
            CBUtility.error((Component)((Object)this), (String)"No Report Selected.");
            return;
        }
        if (!(this.getDestinationDirectory() != null || (bloop = this.getOutputFormats()).length == 1 && bloop[1].equals(this.outputViewer.getText().toUpperCase()))) {
            CBUtility.error((Component)((Object)this), (String)"No Report Selected.");
            return;
        }
        final SmartTree tree = this.owningBrowser.getActiveTree();
        if (tree.isEmpty()) {
            CBUtility.error((String)CBIntText.get((String)"Unable to export empty tree (no data available)"), null);
            return;
        }
        DataBroker dataSource = tree.getDataSource();
        ProgressMonitor progressBar = new ProgressMonitor((Component)((Object)this), "running report", "compiling report", 0, 100);
        if (progressBar != null) {
            JRLDAPDataSource.setProgressMonitor(progressBar);
            progressBar.setProgress(0);
        }
        dataSource.extendedRequest(new DataQuery(256){

            public void doExtendedRequest(DataBroker b) {
                try {
                    JasperApplication dataSourceApp;
                    boolean hasData = false;
                    if (JXWReport.this.owningBrowser.getDisplayMode() == JXplorerBrowser.DisplayMode.SEARCH) {
                        hasData = true;
                        JRLDAPDataSource dataSource = new JRLDAPDataSource(tree, JXWReport.this.getReportDN());
                        log.warning("Using provided search results: ignoring report query parameter");
                        dataSourceApp = new JasperApplication(dataSource, JXWReport.this.getReportFile(), JXWReport.this.getDestinationDirectory(), JXWReport.this.getOutputFormats());
                    } else {
                        JNDIDataBroker broker = JXWReport.this.owningBrowser.getSearchBroker();
                        dataSourceApp = new JasperApplication(broker, JXWReport.this.getReportFile(), JXWReport.this.getDestinationDirectory(), JXWReport.this.getOutputFormats(), JXWReport.this.getReportDN());
                    }
                    boolean compile = dataSourceApp.doesCompiledReportExist();
                    if (compile) {
                        JRLDAPDataSource.setNote("compilingReport");
                        dataSourceApp.compile();
                    }
                    if (hasData) {
                        JRLDAPDataSource.setProgress(50);
                        JRLDAPDataSource.setNote("filling report");
                    } else {
                        JRLDAPDataSource.setProgress(25);
                        JRLDAPDataSource.setNote("searching data");
                    }
                    dataSourceApp.runReport();
                }
                catch (Exception e) {
                    new CBErrorWin((Frame)JXWReport.this.owningBrowser, "Error Running Report:\n" + e.getMessage(), e);
                    this.setException(e);
                }
                if (JRLDAPDataSource.getProgressMonitor() != null) {
                    JRLDAPDataSource.getProgressMonitor().close();
                }
                JXWReport.this.closeDown();
            }
        });
    }

    public void setupBaseOptionsDialog() {
        this.setSize(480, 370);
        CBPanel display = this.getDisplayPanel();
        String sourceDir = JXConfig.getProperty((String)"report.sourceDir");
        if (sourceDir == null) {
            sourceDir = new File("jasper/reports").getAbsolutePath();
        }
        this.reportFileChooser.setLocalDirectory(sourceDir);
        this.outputDirChooser.setLocalDirectory(JXConfig.getProperty((String)"report.outputDir"));
        this.reportFileName.setName("reportFile");
        this.outputDirName.setName("outputDir");
        this.outputPDF.setName("PDF");
        this.outputPDF.setToolTipText("Adobe PDF Format");
        this.outputHTML.setName("HTML");
        this.outputHTML.setToolTipText("HTML Web Page");
        this.outputXML.setName("XML");
        this.outputXML.setToolTipText("Generic XML");
        this.outputRTF.setName("RTF");
        this.outputRTF.setToolTipText("Generic RTF text document");
        this.outputPPTX.setName("PPTX");
        this.outputPPTX.setToolTipText("Microsoft Powerpoint");
        this.outputDOCX.setName("DOCX");
        this.outputDOCX.setToolTipText("Microsoft Word document");
        this.outputXLS.setName("XLS");
        this.outputXLS.setToolTipText("Microsoft Excel spreadsheet");
        CBPanel rootDNinset = new CBPanel();
        this.reportDN.setSelected(true);
        rootDNinset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Export from:")));
        rootDNinset.addln((Component)this.reportDN);
        rootDNinset.addln((Component)this.currentSelectedDN);
        ButtonGroup dnGroup = new ButtonGroup();
        dnGroup.add(this.reportDN);
        dnGroup.add(this.currentSelectedDN);
        display.add((Component)rootDNinset, 1, 1);
        this.reportFileChooser.addChoosableFileFilter((FileFilter)new CBFileFilter(new String[]{"jrxml", "jasper"}, CBIntText.get((String)"Jasper Report Files")));
        CBPanel inputsInset = new CBPanel();
        inputsInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Jasper Report: ")));
        inputsInset.add((Component)new JLabel(CBIntText.get((String)"select: ")));
        inputsInset.makeHeavy();
        inputsInset.add((Component)new JLabel("  "));
        inputsInset.addln((Component)this.reportFileChooser);
        inputsInset.addGreedyWide((Component)this.reportFileName, 3);
        display.makeWide();
        display.add((Component)inputsInset, 1, 2);
        this.outputDirChooser.setFileSelectionMode(1);
        CBPanel ouputInset = new CBPanel();
        ouputInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Output Directory: ")));
        ouputInset.add((Component)new JLabel(CBIntText.get((String)"select: ")));
        ouputInset.makeHeavy();
        ouputInset.add((Component)new JLabel("  "));
        ouputInset.addln((Component)this.outputDirChooser);
        ouputInset.addGreedyWide((Component)this.outputDirName, 3);
        display.add((Component)ouputInset, 1, 3);
        display.add((Component)this.myTemplater, 1, 4, 2, 1);
        CBPanel outputsInset = new CBPanel();
        outputsInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Format:")));
        this.outputViewer.setSelected(true);
        outputsInset.addln((Component)this.outputViewer);
        outputsInset.addln((Component)new JLabel("   "));
        outputsInset.addln((Component)this.outputPDF);
        outputsInset.addln((Component)this.outputHTML);
        outputsInset.addln((Component)this.outputXML);
        outputsInset.addln((Component)this.outputRTF);
        outputsInset.addln((Component)this.outputPPTX);
        outputsInset.addln((Component)this.outputDOCX);
        outputsInset.addln((Component)this.outputXLS);
        display.makeLight();
        display.add((Component)outputsInset, 2, 1, 1, 3);
        display.newLine();
        CBUtility.center((Component)((Object)this), (Component)this.owningBrowser);
        if (firstTime) {
            this.myTemplater.loadDefault();
            firstTime = false;
        } else {
            this.myTemplater.setCurrentTemplateName(currentTemplateName);
        }
    }

    public void loadTemplate(String templateName) {
        this.myTemplater.loadTemplateName(templateName);
    }

    private void closeDown() {
        this.setVisible(false);
        this.dispose();
    }

    private void flipCancelToFinish() {
        this.Cancel.setText(CBIntText.get((String)"Finished"));
    }
}

