/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.testprovider;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class TestProviderEnumeration<E>
extends ArrayList<E>
implements NamingEnumeration<E> {
    private int currentElement = 0;

    public TestProviderEnumeration(Enumeration<E> initialiser) {
        while (initialiser.hasMoreElements()) {
            this.add(initialiser.nextElement());
        }
    }

    public TestProviderEnumeration() {
    }

    public TestProviderEnumeration(Collection c) {
        super(c);
    }

    @Override
    public E next() throws NamingException {
        if (!this.hasMoreElements()) {
            throw new NamingException("no more elements");
        }
        return this.get(this.currentElement++);
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    @Override
    public void close() throws NamingException {
        this.clear();
        this.currentElement = 0;
    }

    @Override
    public boolean hasMoreElements() {
        return this.currentElement < this.size();
    }

    @Override
    public E nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        return this.get(this.currentElement++);
    }

    public String[] toStringArray() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Object o = this.get(i);
            if (o == null) {
                o = "null";
            }
            ret[i] = o.toString();
        }
        return ret;
    }

    public void sort() {
        Collections.sort(this, new AlphabeticComparator());
    }

    private class AlphabeticComparator
    implements Comparator {
        Collator collator = Collator.getInstance();

        private AlphabeticComparator() {
        }

        public int compare(Object a, Object b) {
            return this.collator.compare(a, b);
        }
    }
}

