// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/v1/datastore.proto

package datastore // import "google.golang.org/genproto/googleapis/datastore/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The modes available for commits.
type CommitRequest_Mode int32

const (
	// Unspecified. This value must not be used.
	CommitRequest_MODE_UNSPECIFIED CommitRequest_Mode = 0
	// Transactional: The mutations are either all applied, or none are applied.
	// Learn about transactions
	// [here](https://cloud.google.com/datastore/docs/concepts/transactions).
	CommitRequest_TRANSACTIONAL CommitRequest_Mode = 1
	// Non-transactional: The mutations may not apply as all or none.
	CommitRequest_NON_TRANSACTIONAL CommitRequest_Mode = 2
)

var CommitRequest_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "TRANSACTIONAL",
	2: "NON_TRANSACTIONAL",
}
var CommitRequest_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED":  0,
	"TRANSACTIONAL":     1,
	"NON_TRANSACTIONAL": 2,
}

func (x CommitRequest_Mode) String() string {
	return proto.EnumName(CommitRequest_Mode_name, int32(x))
}
func (CommitRequest_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{8, 0}
}

// The possible values for read consistencies.
type ReadOptions_ReadConsistency int32

const (
	// Unspecified. This value must not be used.
	ReadOptions_READ_CONSISTENCY_UNSPECIFIED ReadOptions_ReadConsistency = 0
	// Strong consistency.
	ReadOptions_STRONG ReadOptions_ReadConsistency = 1
	// Eventual consistency.
	ReadOptions_EVENTUAL ReadOptions_ReadConsistency = 2
)

var ReadOptions_ReadConsistency_name = map[int32]string{
	0: "READ_CONSISTENCY_UNSPECIFIED",
	1: "STRONG",
	2: "EVENTUAL",
}
var ReadOptions_ReadConsistency_value = map[string]int32{
	"READ_CONSISTENCY_UNSPECIFIED": 0,
	"STRONG":                       1,
	"EVENTUAL":                     2,
}

func (x ReadOptions_ReadConsistency) String() string {
	return proto.EnumName(ReadOptions_ReadConsistency_name, int32(x))
}
func (ReadOptions_ReadConsistency) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{16, 0}
}

// The request for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The options for this lookup request.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// Keys of entities to look up.
	Keys                 []*Key   `protobuf:"bytes,3,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LookupRequest) Reset()         { *m = LookupRequest{} }
func (m *LookupRequest) String() string { return proto.CompactTextString(m) }
func (*LookupRequest) ProtoMessage()    {}
func (*LookupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{0}
}
func (m *LookupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupRequest.Unmarshal(m, b)
}
func (m *LookupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupRequest.Marshal(b, m, deterministic)
}
func (dst *LookupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupRequest.Merge(dst, src)
}
func (m *LookupRequest) XXX_Size() int {
	return xxx_messageInfo_LookupRequest.Size(m)
}
func (m *LookupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupRequest proto.InternalMessageInfo

func (m *LookupRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *LookupRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *LookupRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupResponse struct {
	// Entities found as `ResultType.FULL` entities. The order of results in this
	// field is undefined and has no relation to the order of the keys in the
	// input.
	Found []*EntityResult `protobuf:"bytes,1,rep,name=found,proto3" json:"found,omitempty"`
	// Entities not found as `ResultType.KEY_ONLY` entities. The order of results
	// in this field is undefined and has no relation to the order of the keys
	// in the input.
	Missing []*EntityResult `protobuf:"bytes,2,rep,name=missing,proto3" json:"missing,omitempty"`
	// A list of keys that were not looked up due to resource constraints. The
	// order of results in this field is undefined and has no relation to the
	// order of the keys in the input.
	Deferred             []*Key   `protobuf:"bytes,3,rep,name=deferred,proto3" json:"deferred,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LookupResponse) Reset()         { *m = LookupResponse{} }
func (m *LookupResponse) String() string { return proto.CompactTextString(m) }
func (*LookupResponse) ProtoMessage()    {}
func (*LookupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{1}
}
func (m *LookupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupResponse.Unmarshal(m, b)
}
func (m *LookupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupResponse.Marshal(b, m, deterministic)
}
func (dst *LookupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupResponse.Merge(dst, src)
}
func (m *LookupResponse) XXX_Size() int {
	return xxx_messageInfo_LookupResponse.Size(m)
}
func (m *LookupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LookupResponse proto.InternalMessageInfo

func (m *LookupResponse) GetFound() []*EntityResult {
	if m != nil {
		return m.Found
	}
	return nil
}

func (m *LookupResponse) GetMissing() []*EntityResult {
	if m != nil {
		return m.Missing
	}
	return nil
}

func (m *LookupResponse) GetDeferred() []*Key {
	if m != nil {
		return m.Deferred
	}
	return nil
}

// The request for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Entities are partitioned into subsets, identified by a partition ID.
	// Queries are scoped to a single partition.
	// This partition ID is normalized with the standard default context
	// partition ID.
	PartitionId *PartitionId `protobuf:"bytes,2,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// The options for this query.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions,proto3" json:"read_options,omitempty"`
	// The type of query.
	//
	// Types that are valid to be assigned to QueryType:
	//	*RunQueryRequest_Query
	//	*RunQueryRequest_GqlQuery
	QueryType            isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *RunQueryRequest) Reset()         { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()    {}
func (*RunQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{2}
}
func (m *RunQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunQueryRequest.Unmarshal(m, b)
}
func (m *RunQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunQueryRequest.Marshal(b, m, deterministic)
}
func (dst *RunQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunQueryRequest.Merge(dst, src)
}
func (m *RunQueryRequest) XXX_Size() int {
	return xxx_messageInfo_RunQueryRequest.Size(m)
}
func (m *RunQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunQueryRequest proto.InternalMessageInfo

func (m *RunQueryRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RunQueryRequest) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *RunQueryRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}

type RunQueryRequest_Query struct {
	Query *Query `protobuf:"bytes,3,opt,name=query,proto3,oneof"`
}

type RunQueryRequest_GqlQuery struct {
	GqlQuery *GqlQuery `protobuf:"bytes,7,opt,name=gql_query,json=gqlQuery,proto3,oneof"`
}

func (*RunQueryRequest_Query) isRunQueryRequest_QueryType() {}

func (*RunQueryRequest_GqlQuery) isRunQueryRequest_QueryType() {}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *RunQueryRequest) GetQuery() *Query {
	if x, ok := m.GetQueryType().(*RunQueryRequest_Query); ok {
		return x.Query
	}
	return nil
}

func (m *RunQueryRequest) GetGqlQuery() *GqlQuery {
	if x, ok := m.GetQueryType().(*RunQueryRequest_GqlQuery); ok {
		return x.GqlQuery
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RunQueryRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RunQueryRequest_OneofMarshaler, _RunQueryRequest_OneofUnmarshaler, _RunQueryRequest_OneofSizer, []interface{}{
		(*RunQueryRequest_Query)(nil),
		(*RunQueryRequest_GqlQuery)(nil),
	}
}

func _RunQueryRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_Query:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Query); err != nil {
			return err
		}
	case *RunQueryRequest_GqlQuery:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GqlQuery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunQueryRequest.QueryType has unexpected type %T", x)
	}
	return nil
}

func _RunQueryRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RunQueryRequest)
	switch tag {
	case 3: // query_type.query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Query)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_Query{msg}
		return true, err
	case 7: // query_type.gql_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GqlQuery)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_GqlQuery{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RunQueryRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_Query:
		s := proto.Size(x.Query)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RunQueryRequest_GqlQuery:
		s := proto.Size(x.GqlQuery)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for
// [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryResponse struct {
	// A batch of query results (always present).
	Batch *QueryResultBatch `protobuf:"bytes,1,opt,name=batch,proto3" json:"batch,omitempty"`
	// The parsed form of the `GqlQuery` from the request, if it was set.
	Query                *Query   `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunQueryResponse) Reset()         { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()    {}
func (*RunQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{3}
}
func (m *RunQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunQueryResponse.Unmarshal(m, b)
}
func (m *RunQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunQueryResponse.Marshal(b, m, deterministic)
}
func (dst *RunQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunQueryResponse.Merge(dst, src)
}
func (m *RunQueryResponse) XXX_Size() int {
	return xxx_messageInfo_RunQueryResponse.Size(m)
}
func (m *RunQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunQueryResponse proto.InternalMessageInfo

func (m *RunQueryResponse) GetBatch() *QueryResultBatch {
	if m != nil {
		return m.Batch
	}
	return nil
}

func (m *RunQueryResponse) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

// The request for
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Options for a new transaction.
	TransactionOptions   *TransactionOptions `protobuf:"bytes,10,opt,name=transaction_options,json=transactionOptions,proto3" json:"transaction_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *BeginTransactionRequest) Reset()         { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()    {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{4}
}
func (m *BeginTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionRequest.Unmarshal(m, b)
}
func (m *BeginTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionRequest.Marshal(b, m, deterministic)
}
func (dst *BeginTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionRequest.Merge(dst, src)
}
func (m *BeginTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionRequest.Size(m)
}
func (m *BeginTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionRequest proto.InternalMessageInfo

func (m *BeginTransactionRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BeginTransactionRequest) GetTransactionOptions() *TransactionOptions {
	if m != nil {
		return m.TransactionOptions
	}
	return nil
}

// The response for
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionResponse struct {
	// The transaction identifier (always present).
	Transaction          []byte   `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginTransactionResponse) Reset()         { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()    {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{5}
}
func (m *BeginTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginTransactionResponse.Unmarshal(m, b)
}
func (m *BeginTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginTransactionResponse.Marshal(b, m, deterministic)
}
func (dst *BeginTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginTransactionResponse.Merge(dst, src)
}
func (m *BeginTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_BeginTransactionResponse.Size(m)
}
func (m *BeginTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginTransactionResponse proto.InternalMessageInfo

func (m *BeginTransactionResponse) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The request for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
type RollbackRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The transaction identifier, returned by a call to
	// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
	Transaction          []byte   `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{6}
}
func (m *RollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackRequest.Unmarshal(m, b)
}
func (m *RollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackRequest.Marshal(b, m, deterministic)
}
func (dst *RollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackRequest.Merge(dst, src)
}
func (m *RollbackRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackRequest.Size(m)
}
func (m *RollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackRequest proto.InternalMessageInfo

func (m *RollbackRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RollbackRequest) GetTransaction() []byte {
	if m != nil {
		return m.Transaction
	}
	return nil
}

// The response for
// [Datastore.Rollback][google.datastore.v1.Datastore.Rollback]. (an empty
// message).
type RollbackResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackResponse) Reset()         { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()    {}
func (*RollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{7}
}
func (m *RollbackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackResponse.Unmarshal(m, b)
}
func (m *RollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackResponse.Marshal(b, m, deterministic)
}
func (dst *RollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackResponse.Merge(dst, src)
}
func (m *RollbackResponse) XXX_Size() int {
	return xxx_messageInfo_RollbackResponse.Size(m)
}
func (m *RollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackResponse proto.InternalMessageInfo

// The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The type of commit to perform. Defaults to `TRANSACTIONAL`.
	Mode CommitRequest_Mode `protobuf:"varint,5,opt,name=mode,proto3,enum=google.datastore.v1.CommitRequest_Mode" json:"mode,omitempty"`
	// Must be set when mode is `TRANSACTIONAL`.
	//
	// Types that are valid to be assigned to TransactionSelector:
	//	*CommitRequest_Transaction
	TransactionSelector isCommitRequest_TransactionSelector `protobuf_oneof:"transaction_selector"`
	// The mutations to perform.
	//
	// When mode is `TRANSACTIONAL`, mutations affecting a single entity are
	// applied in order. The following sequences of mutations affecting a single
	// entity are not permitted in a single `Commit` request:
	//
	// - `insert` followed by `insert`
	// - `update` followed by `insert`
	// - `upsert` followed by `insert`
	// - `delete` followed by `update`
	//
	// When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
	// entity.
	Mutations            []*Mutation `protobuf:"bytes,6,rep,name=mutations,proto3" json:"mutations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{8}
}
func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitRequest.Unmarshal(m, b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
}
func (dst *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(dst, src)
}
func (m *CommitRequest) XXX_Size() int {
	return xxx_messageInfo_CommitRequest.Size(m)
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

func (m *CommitRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CommitRequest) GetMode() CommitRequest_Mode {
	if m != nil {
		return m.Mode
	}
	return CommitRequest_MODE_UNSPECIFIED
}

type isCommitRequest_TransactionSelector interface {
	isCommitRequest_TransactionSelector()
}

type CommitRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3,oneof"`
}

func (*CommitRequest_Transaction) isCommitRequest_TransactionSelector() {}

func (m *CommitRequest) GetTransactionSelector() isCommitRequest_TransactionSelector {
	if m != nil {
		return m.TransactionSelector
	}
	return nil
}

func (m *CommitRequest) GetTransaction() []byte {
	if x, ok := m.GetTransactionSelector().(*CommitRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *CommitRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommitRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommitRequest_OneofMarshaler, _CommitRequest_OneofUnmarshaler, _CommitRequest_OneofSizer, []interface{}{
		(*CommitRequest_Transaction)(nil),
	}
}

func _CommitRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommitRequest)
	// transaction_selector
	switch x := m.TransactionSelector.(type) {
	case *CommitRequest_Transaction:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case nil:
	default:
		return fmt.Errorf("CommitRequest.TransactionSelector has unexpected type %T", x)
	}
	return nil
}

func _CommitRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommitRequest)
	switch tag {
	case 1: // transaction_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.TransactionSelector = &CommitRequest_Transaction{x}
		return true, err
	default:
		return false, nil
	}
}

func _CommitRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommitRequest)
	// transaction_selector
	switch x := m.TransactionSelector.(type) {
	case *CommitRequest_Transaction:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitResponse struct {
	// The result of performing the mutations.
	// The i-th mutation result corresponds to the i-th mutation in the request.
	MutationResults []*MutationResult `protobuf:"bytes,3,rep,name=mutation_results,json=mutationResults,proto3" json:"mutation_results,omitempty"`
	// The number of index entries updated during the commit, or zero if none were
	// updated.
	IndexUpdates         int32    `protobuf:"varint,4,opt,name=index_updates,json=indexUpdates,proto3" json:"index_updates,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{9}
}
func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResponse.Unmarshal(m, b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
}
func (dst *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(dst, src)
}
func (m *CommitResponse) XXX_Size() int {
	return xxx_messageInfo_CommitResponse.Size(m)
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

func (m *CommitResponse) GetMutationResults() []*MutationResult {
	if m != nil {
		return m.MutationResults
	}
	return nil
}

func (m *CommitResponse) GetIndexUpdates() int32 {
	if m != nil {
		return m.IndexUpdates
	}
	return 0
}

// The request for
// [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A list of keys with incomplete key paths for which to allocate IDs.
	// No key may be reserved/read-only.
	Keys                 []*Key   `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocateIdsRequest) Reset()         { *m = AllocateIdsRequest{} }
func (m *AllocateIdsRequest) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsRequest) ProtoMessage()    {}
func (*AllocateIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{10}
}
func (m *AllocateIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocateIdsRequest.Unmarshal(m, b)
}
func (m *AllocateIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocateIdsRequest.Marshal(b, m, deterministic)
}
func (dst *AllocateIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocateIdsRequest.Merge(dst, src)
}
func (m *AllocateIdsRequest) XXX_Size() int {
	return xxx_messageInfo_AllocateIdsRequest.Size(m)
}
func (m *AllocateIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocateIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AllocateIdsRequest proto.InternalMessageInfo

func (m *AllocateIdsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AllocateIdsRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for
// [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsResponse struct {
	// The keys specified in the request (in the same order), each with
	// its key path completed with a newly allocated ID.
	Keys                 []*Key   `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllocateIdsResponse) Reset()         { *m = AllocateIdsResponse{} }
func (m *AllocateIdsResponse) String() string { return proto.CompactTextString(m) }
func (*AllocateIdsResponse) ProtoMessage()    {}
func (*AllocateIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{11}
}
func (m *AllocateIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllocateIdsResponse.Unmarshal(m, b)
}
func (m *AllocateIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllocateIdsResponse.Marshal(b, m, deterministic)
}
func (dst *AllocateIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllocateIdsResponse.Merge(dst, src)
}
func (m *AllocateIdsResponse) XXX_Size() int {
	return xxx_messageInfo_AllocateIdsResponse.Size(m)
}
func (m *AllocateIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AllocateIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AllocateIdsResponse proto.InternalMessageInfo

func (m *AllocateIdsResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The request for
// [Datastore.ReserveIds][google.datastore.v1.Datastore.ReserveIds].
type ReserveIdsRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If not empty, the ID of the database against which to make the request.
	DatabaseId string `protobuf:"bytes,9,opt,name=database_id,json=databaseId,proto3" json:"database_id,omitempty"`
	// A list of keys with complete key paths whose numeric IDs should not be
	// auto-allocated.
	Keys                 []*Key   `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReserveIdsRequest) Reset()         { *m = ReserveIdsRequest{} }
func (m *ReserveIdsRequest) String() string { return proto.CompactTextString(m) }
func (*ReserveIdsRequest) ProtoMessage()    {}
func (*ReserveIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{12}
}
func (m *ReserveIdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReserveIdsRequest.Unmarshal(m, b)
}
func (m *ReserveIdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReserveIdsRequest.Marshal(b, m, deterministic)
}
func (dst *ReserveIdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReserveIdsRequest.Merge(dst, src)
}
func (m *ReserveIdsRequest) XXX_Size() int {
	return xxx_messageInfo_ReserveIdsRequest.Size(m)
}
func (m *ReserveIdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReserveIdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReserveIdsRequest proto.InternalMessageInfo

func (m *ReserveIdsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ReserveIdsRequest) GetDatabaseId() string {
	if m != nil {
		return m.DatabaseId
	}
	return ""
}

func (m *ReserveIdsRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for
// [Datastore.ReserveIds][google.datastore.v1.Datastore.ReserveIds].
type ReserveIdsResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReserveIdsResponse) Reset()         { *m = ReserveIdsResponse{} }
func (m *ReserveIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ReserveIdsResponse) ProtoMessage()    {}
func (*ReserveIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{13}
}
func (m *ReserveIdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReserveIdsResponse.Unmarshal(m, b)
}
func (m *ReserveIdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReserveIdsResponse.Marshal(b, m, deterministic)
}
func (dst *ReserveIdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReserveIdsResponse.Merge(dst, src)
}
func (m *ReserveIdsResponse) XXX_Size() int {
	return xxx_messageInfo_ReserveIdsResponse.Size(m)
}
func (m *ReserveIdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReserveIdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReserveIdsResponse proto.InternalMessageInfo

// A mutation to apply to an entity.
type Mutation struct {
	// The mutation operation.
	//
	// For `insert`, `update`, and `upsert`:
	// - The entity's key must not be reserved/read-only.
	// - No property in the entity may have a reserved name,
	//   not even a property in an entity in a value.
	// - No value in the entity may have meaning 18,
	//   not even a value in an entity in another value.
	//
	// Types that are valid to be assigned to Operation:
	//	*Mutation_Insert
	//	*Mutation_Update
	//	*Mutation_Upsert
	//	*Mutation_Delete
	Operation isMutation_Operation `protobuf_oneof:"operation"`
	// When set, the server will detect whether or not this mutation conflicts
	// with the current version of the entity on the server. Conflicting mutations
	// are not applied, and are marked as such in MutationResult.
	//
	// Types that are valid to be assigned to ConflictDetectionStrategy:
	//	*Mutation_BaseVersion
	ConflictDetectionStrategy isMutation_ConflictDetectionStrategy `protobuf_oneof:"conflict_detection_strategy"`
	XXX_NoUnkeyedLiteral      struct{}                             `json:"-"`
	XXX_unrecognized          []byte                               `json:"-"`
	XXX_sizecache             int32                                `json:"-"`
}

func (m *Mutation) Reset()         { *m = Mutation{} }
func (m *Mutation) String() string { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()    {}
func (*Mutation) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{14}
}
func (m *Mutation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Mutation.Unmarshal(m, b)
}
func (m *Mutation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Mutation.Marshal(b, m, deterministic)
}
func (dst *Mutation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation.Merge(dst, src)
}
func (m *Mutation) XXX_Size() int {
	return xxx_messageInfo_Mutation.Size(m)
}
func (m *Mutation) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation proto.InternalMessageInfo

type isMutation_Operation interface {
	isMutation_Operation()
}

type Mutation_Insert struct {
	Insert *Entity `protobuf:"bytes,4,opt,name=insert,proto3,oneof"`
}

type Mutation_Update struct {
	Update *Entity `protobuf:"bytes,5,opt,name=update,proto3,oneof"`
}

type Mutation_Upsert struct {
	Upsert *Entity `protobuf:"bytes,6,opt,name=upsert,proto3,oneof"`
}

type Mutation_Delete struct {
	Delete *Key `protobuf:"bytes,7,opt,name=delete,proto3,oneof"`
}

func (*Mutation_Insert) isMutation_Operation() {}

func (*Mutation_Update) isMutation_Operation() {}

func (*Mutation_Upsert) isMutation_Operation() {}

func (*Mutation_Delete) isMutation_Operation() {}

func (m *Mutation) GetOperation() isMutation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *Mutation) GetInsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Insert); ok {
		return x.Insert
	}
	return nil
}

func (m *Mutation) GetUpdate() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *Mutation) GetUpsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Upsert); ok {
		return x.Upsert
	}
	return nil
}

func (m *Mutation) GetDelete() *Key {
	if x, ok := m.GetOperation().(*Mutation_Delete); ok {
		return x.Delete
	}
	return nil
}

type isMutation_ConflictDetectionStrategy interface {
	isMutation_ConflictDetectionStrategy()
}

type Mutation_BaseVersion struct {
	BaseVersion int64 `protobuf:"varint,8,opt,name=base_version,json=baseVersion,proto3,oneof"`
}

func (*Mutation_BaseVersion) isMutation_ConflictDetectionStrategy() {}

func (m *Mutation) GetConflictDetectionStrategy() isMutation_ConflictDetectionStrategy {
	if m != nil {
		return m.ConflictDetectionStrategy
	}
	return nil
}

func (m *Mutation) GetBaseVersion() int64 {
	if x, ok := m.GetConflictDetectionStrategy().(*Mutation_BaseVersion); ok {
		return x.BaseVersion
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, _Mutation_OneofSizer, []interface{}{
		(*Mutation_Insert)(nil),
		(*Mutation_Update)(nil),
		(*Mutation_Upsert)(nil),
		(*Mutation_Delete)(nil),
		(*Mutation_BaseVersion)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Insert); err != nil {
			return err
		}
	case *Mutation_Update:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *Mutation_Upsert:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Upsert); err != nil {
			return err
		}
	case *Mutation_Delete:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Operation has unexpected type %T", x)
	}
	// conflict_detection_strategy
	switch x := m.ConflictDetectionStrategy.(type) {
	case *Mutation_BaseVersion:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.BaseVersion))
	case nil:
	default:
		return fmt.Errorf("Mutation.ConflictDetectionStrategy has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 4: // operation.insert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Insert{msg}
		return true, err
	case 5: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Update{msg}
		return true, err
	case 6: // operation.upsert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Upsert{msg}
		return true, err
	case 7: // operation.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Key)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Delete{msg}
		return true, err
	case 8: // conflict_detection_strategy.base_version
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConflictDetectionStrategy = &Mutation_BaseVersion{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _Mutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		s := proto.Size(x.Insert)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Upsert:
		s := proto.Size(x.Upsert)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Delete:
		s := proto.Size(x.Delete)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// conflict_detection_strategy
	switch x := m.ConflictDetectionStrategy.(type) {
	case *Mutation_BaseVersion:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.BaseVersion))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The result of applying a mutation.
type MutationResult struct {
	// The automatically allocated key.
	// Set only when the mutation allocated a key.
	Key *Key `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// The version of the entity on the server after processing the mutation. If
	// the mutation doesn't change anything on the server, then the version will
	// be the version of the current entity or, if no entity is present, a version
	// that is strictly greater than the version of any previous entity and less
	// than the version of any possible future entity.
	Version int64 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// Whether a conflict was detected for this mutation. Always false when a
	// conflict detection strategy field is not set in the mutation.
	ConflictDetected     bool     `protobuf:"varint,5,opt,name=conflict_detected,json=conflictDetected,proto3" json:"conflict_detected,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutationResult) Reset()         { *m = MutationResult{} }
func (m *MutationResult) String() string { return proto.CompactTextString(m) }
func (*MutationResult) ProtoMessage()    {}
func (*MutationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{15}
}
func (m *MutationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutationResult.Unmarshal(m, b)
}
func (m *MutationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutationResult.Marshal(b, m, deterministic)
}
func (dst *MutationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutationResult.Merge(dst, src)
}
func (m *MutationResult) XXX_Size() int {
	return xxx_messageInfo_MutationResult.Size(m)
}
func (m *MutationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutationResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutationResult proto.InternalMessageInfo

func (m *MutationResult) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *MutationResult) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *MutationResult) GetConflictDetected() bool {
	if m != nil {
		return m.ConflictDetected
	}
	return false
}

// The options shared by read requests.
type ReadOptions struct {
	// If not specified, lookups and ancestor queries default to
	// `read_consistency`=`STRONG`, global queries default to
	// `read_consistency`=`EVENTUAL`.
	//
	// Types that are valid to be assigned to ConsistencyType:
	//	*ReadOptions_ReadConsistency_
	//	*ReadOptions_Transaction
	ConsistencyType      isReadOptions_ConsistencyType `protobuf_oneof:"consistency_type"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ReadOptions) Reset()         { *m = ReadOptions{} }
func (m *ReadOptions) String() string { return proto.CompactTextString(m) }
func (*ReadOptions) ProtoMessage()    {}
func (*ReadOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{16}
}
func (m *ReadOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadOptions.Unmarshal(m, b)
}
func (m *ReadOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadOptions.Marshal(b, m, deterministic)
}
func (dst *ReadOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadOptions.Merge(dst, src)
}
func (m *ReadOptions) XXX_Size() int {
	return xxx_messageInfo_ReadOptions.Size(m)
}
func (m *ReadOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ReadOptions proto.InternalMessageInfo

type isReadOptions_ConsistencyType interface {
	isReadOptions_ConsistencyType()
}

type ReadOptions_ReadConsistency_ struct {
	ReadConsistency ReadOptions_ReadConsistency `protobuf:"varint,1,opt,name=read_consistency,json=readConsistency,proto3,enum=google.datastore.v1.ReadOptions_ReadConsistency,oneof"`
}

type ReadOptions_Transaction struct {
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3,oneof"`
}

func (*ReadOptions_ReadConsistency_) isReadOptions_ConsistencyType() {}

func (*ReadOptions_Transaction) isReadOptions_ConsistencyType() {}

func (m *ReadOptions) GetConsistencyType() isReadOptions_ConsistencyType {
	if m != nil {
		return m.ConsistencyType
	}
	return nil
}

func (m *ReadOptions) GetReadConsistency() ReadOptions_ReadConsistency {
	if x, ok := m.GetConsistencyType().(*ReadOptions_ReadConsistency_); ok {
		return x.ReadConsistency
	}
	return ReadOptions_READ_CONSISTENCY_UNSPECIFIED
}

func (m *ReadOptions) GetTransaction() []byte {
	if x, ok := m.GetConsistencyType().(*ReadOptions_Transaction); ok {
		return x.Transaction
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadOptions) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadOptions_OneofMarshaler, _ReadOptions_OneofUnmarshaler, _ReadOptions_OneofSizer, []interface{}{
		(*ReadOptions_ReadConsistency_)(nil),
		(*ReadOptions_Transaction)(nil),
	}
}

func _ReadOptions_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadOptions)
	// consistency_type
	switch x := m.ConsistencyType.(type) {
	case *ReadOptions_ReadConsistency_:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.ReadConsistency))
	case *ReadOptions_Transaction:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case nil:
	default:
		return fmt.Errorf("ReadOptions.ConsistencyType has unexpected type %T", x)
	}
	return nil
}

func _ReadOptions_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadOptions)
	switch tag {
	case 1: // consistency_type.read_consistency
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConsistencyType = &ReadOptions_ReadConsistency_{ReadOptions_ReadConsistency(x)}
		return true, err
	case 2: // consistency_type.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencyType = &ReadOptions_Transaction{x}
		return true, err
	default:
		return false, nil
	}
}

func _ReadOptions_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadOptions)
	// consistency_type
	switch x := m.ConsistencyType.(type) {
	case *ReadOptions_ReadConsistency_:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.ReadConsistency))
	case *ReadOptions_Transaction:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Options for beginning a new transaction.
//
// Transactions can be created explicitly with calls to
// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction]
// or implicitly by setting
// [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
// in read requests.
type TransactionOptions struct {
	// The `mode` of the transaction, indicating whether write operations are
	// supported.
	//
	// Types that are valid to be assigned to Mode:
	//	*TransactionOptions_ReadWrite_
	//	*TransactionOptions_ReadOnly_
	Mode                 isTransactionOptions_Mode `protobuf_oneof:"mode"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *TransactionOptions) Reset()         { *m = TransactionOptions{} }
func (m *TransactionOptions) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions) ProtoMessage()    {}
func (*TransactionOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{17}
}
func (m *TransactionOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionOptions.Unmarshal(m, b)
}
func (m *TransactionOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionOptions.Marshal(b, m, deterministic)
}
func (dst *TransactionOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionOptions.Merge(dst, src)
}
func (m *TransactionOptions) XXX_Size() int {
	return xxx_messageInfo_TransactionOptions.Size(m)
}
func (m *TransactionOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionOptions.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionOptions proto.InternalMessageInfo

type isTransactionOptions_Mode interface {
	isTransactionOptions_Mode()
}

type TransactionOptions_ReadWrite_ struct {
	ReadWrite *TransactionOptions_ReadWrite `protobuf:"bytes,1,opt,name=read_write,json=readWrite,proto3,oneof"`
}

type TransactionOptions_ReadOnly_ struct {
	ReadOnly *TransactionOptions_ReadOnly `protobuf:"bytes,2,opt,name=read_only,json=readOnly,proto3,oneof"`
}

func (*TransactionOptions_ReadWrite_) isTransactionOptions_Mode() {}

func (*TransactionOptions_ReadOnly_) isTransactionOptions_Mode() {}

func (m *TransactionOptions) GetMode() isTransactionOptions_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (m *TransactionOptions) GetReadWrite() *TransactionOptions_ReadWrite {
	if x, ok := m.GetMode().(*TransactionOptions_ReadWrite_); ok {
		return x.ReadWrite
	}
	return nil
}

func (m *TransactionOptions) GetReadOnly() *TransactionOptions_ReadOnly {
	if x, ok := m.GetMode().(*TransactionOptions_ReadOnly_); ok {
		return x.ReadOnly
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TransactionOptions) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TransactionOptions_OneofMarshaler, _TransactionOptions_OneofUnmarshaler, _TransactionOptions_OneofSizer, []interface{}{
		(*TransactionOptions_ReadWrite_)(nil),
		(*TransactionOptions_ReadOnly_)(nil),
	}
}

func _TransactionOptions_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TransactionOptions)
	// mode
	switch x := m.Mode.(type) {
	case *TransactionOptions_ReadWrite_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadWrite); err != nil {
			return err
		}
	case *TransactionOptions_ReadOnly_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadOnly); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TransactionOptions.Mode has unexpected type %T", x)
	}
	return nil
}

func _TransactionOptions_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TransactionOptions)
	switch tag {
	case 1: // mode.read_write
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions_ReadWrite)
		err := b.DecodeMessage(msg)
		m.Mode = &TransactionOptions_ReadWrite_{msg}
		return true, err
	case 2: // mode.read_only
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TransactionOptions_ReadOnly)
		err := b.DecodeMessage(msg)
		m.Mode = &TransactionOptions_ReadOnly_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TransactionOptions_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TransactionOptions)
	// mode
	switch x := m.Mode.(type) {
	case *TransactionOptions_ReadWrite_:
		s := proto.Size(x.ReadWrite)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TransactionOptions_ReadOnly_:
		s := proto.Size(x.ReadOnly)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Options specific to read / write transactions.
type TransactionOptions_ReadWrite struct {
	// The transaction identifier of the transaction being retried.
	PreviousTransaction  []byte   `protobuf:"bytes,1,opt,name=previous_transaction,json=previousTransaction,proto3" json:"previous_transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransactionOptions_ReadWrite) Reset()         { *m = TransactionOptions_ReadWrite{} }
func (m *TransactionOptions_ReadWrite) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions_ReadWrite) ProtoMessage()    {}
func (*TransactionOptions_ReadWrite) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{17, 0}
}
func (m *TransactionOptions_ReadWrite) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionOptions_ReadWrite.Unmarshal(m, b)
}
func (m *TransactionOptions_ReadWrite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionOptions_ReadWrite.Marshal(b, m, deterministic)
}
func (dst *TransactionOptions_ReadWrite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionOptions_ReadWrite.Merge(dst, src)
}
func (m *TransactionOptions_ReadWrite) XXX_Size() int {
	return xxx_messageInfo_TransactionOptions_ReadWrite.Size(m)
}
func (m *TransactionOptions_ReadWrite) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionOptions_ReadWrite.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionOptions_ReadWrite proto.InternalMessageInfo

func (m *TransactionOptions_ReadWrite) GetPreviousTransaction() []byte {
	if m != nil {
		return m.PreviousTransaction
	}
	return nil
}

// Options specific to read-only transactions.
type TransactionOptions_ReadOnly struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TransactionOptions_ReadOnly) Reset()         { *m = TransactionOptions_ReadOnly{} }
func (m *TransactionOptions_ReadOnly) String() string { return proto.CompactTextString(m) }
func (*TransactionOptions_ReadOnly) ProtoMessage()    {}
func (*TransactionOptions_ReadOnly) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_8b950cadd2f2dedc, []int{17, 1}
}
func (m *TransactionOptions_ReadOnly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionOptions_ReadOnly.Unmarshal(m, b)
}
func (m *TransactionOptions_ReadOnly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionOptions_ReadOnly.Marshal(b, m, deterministic)
}
func (dst *TransactionOptions_ReadOnly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionOptions_ReadOnly.Merge(dst, src)
}
func (m *TransactionOptions_ReadOnly) XXX_Size() int {
	return xxx_messageInfo_TransactionOptions_ReadOnly.Size(m)
}
func (m *TransactionOptions_ReadOnly) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionOptions_ReadOnly.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionOptions_ReadOnly proto.InternalMessageInfo

func init() {
	proto.RegisterType((*LookupRequest)(nil), "google.datastore.v1.LookupRequest")
	proto.RegisterType((*LookupResponse)(nil), "google.datastore.v1.LookupResponse")
	proto.RegisterType((*RunQueryRequest)(nil), "google.datastore.v1.RunQueryRequest")
	proto.RegisterType((*RunQueryResponse)(nil), "google.datastore.v1.RunQueryResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.datastore.v1.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "google.datastore.v1.BeginTransactionResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.datastore.v1.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "google.datastore.v1.RollbackResponse")
	proto.RegisterType((*CommitRequest)(nil), "google.datastore.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.datastore.v1.CommitResponse")
	proto.RegisterType((*AllocateIdsRequest)(nil), "google.datastore.v1.AllocateIdsRequest")
	proto.RegisterType((*AllocateIdsResponse)(nil), "google.datastore.v1.AllocateIdsResponse")
	proto.RegisterType((*ReserveIdsRequest)(nil), "google.datastore.v1.ReserveIdsRequest")
	proto.RegisterType((*ReserveIdsResponse)(nil), "google.datastore.v1.ReserveIdsResponse")
	proto.RegisterType((*Mutation)(nil), "google.datastore.v1.Mutation")
	proto.RegisterType((*MutationResult)(nil), "google.datastore.v1.MutationResult")
	proto.RegisterType((*ReadOptions)(nil), "google.datastore.v1.ReadOptions")
	proto.RegisterType((*TransactionOptions)(nil), "google.datastore.v1.TransactionOptions")
	proto.RegisterType((*TransactionOptions_ReadWrite)(nil), "google.datastore.v1.TransactionOptions.ReadWrite")
	proto.RegisterType((*TransactionOptions_ReadOnly)(nil), "google.datastore.v1.TransactionOptions.ReadOnly")
	proto.RegisterEnum("google.datastore.v1.CommitRequest_Mode", CommitRequest_Mode_name, CommitRequest_Mode_value)
	proto.RegisterEnum("google.datastore.v1.ReadOptions_ReadConsistency", ReadOptions_ReadConsistency_name, ReadOptions_ReadConsistency_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DatastoreClient is the client API for Datastore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatastoreClient interface {
	// Looks up entities by key.
	Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error)
	// Prevents the supplied keys' IDs from being auto-allocated by Cloud
	// Datastore.
	ReserveIds(ctx context.Context, in *ReserveIdsRequest, opts ...grpc.CallOption) (*ReserveIdsResponse, error)
}

type datastoreClient struct {
	cc *grpc.ClientConn
}

func NewDatastoreClient(cc *grpc.ClientConn) DatastoreClient {
	return &datastoreClient{cc}
}

func (c *datastoreClient) Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error) {
	out := new(LookupResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/Lookup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error) {
	out := new(RunQueryResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/RunQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/BeginTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/Commit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error) {
	out := new(RollbackResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/Rollback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error) {
	out := new(AllocateIdsResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/AllocateIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) ReserveIds(ctx context.Context, in *ReserveIdsRequest, opts ...grpc.CallOption) (*ReserveIdsResponse, error) {
	out := new(ReserveIdsResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.v1.Datastore/ReserveIds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreServer is the server API for Datastore service.
type DatastoreServer interface {
	// Looks up entities by key.
	Lookup(context.Context, *LookupRequest) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(context.Context, *RunQueryRequest) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(context.Context, *AllocateIdsRequest) (*AllocateIdsResponse, error)
	// Prevents the supplied keys' IDs from being auto-allocated by Cloud
	// Datastore.
	ReserveIds(context.Context, *ReserveIdsRequest) (*ReserveIdsResponse, error)
}

func RegisterDatastoreServer(s *grpc.Server, srv DatastoreServer) {
	s.RegisterService(&_Datastore_serviceDesc, srv)
}

func _Datastore_Lookup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Lookup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Lookup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Lookup(ctx, req.(*LookupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_RunQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).RunQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/RunQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).RunQuery(ctx, req.(*RunQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_AllocateIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocateIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).AllocateIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/AllocateIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).AllocateIds(ctx, req.(*AllocateIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_ReserveIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReserveIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).ReserveIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/ReserveIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).ReserveIds(ctx, req.(*ReserveIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Datastore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.v1.Datastore",
	HandlerType: (*DatastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Lookup",
			Handler:    _Datastore_Lookup_Handler,
		},
		{
			MethodName: "RunQuery",
			Handler:    _Datastore_RunQuery_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Datastore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Datastore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Datastore_Rollback_Handler,
		},
		{
			MethodName: "AllocateIds",
			Handler:    _Datastore_AllocateIds_Handler,
		},
		{
			MethodName: "ReserveIds",
			Handler:    _Datastore_ReserveIds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/v1/datastore.proto",
}

func init() {
	proto.RegisterFile("google/datastore/v1/datastore.proto", fileDescriptor_datastore_8b950cadd2f2dedc)
}

var fileDescriptor_datastore_8b950cadd2f2dedc = []byte{
	// 1390 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdf, 0x6f, 0x1b, 0xc5,
	0x13, 0xcf, 0x3a, 0x89, 0x63, 0x8f, 0xf3, 0xc3, 0xd9, 0xe4, 0xfb, 0xad, 0x71, 0x5b, 0xd5, 0x5c,
	0x1a, 0x1a, 0xd2, 0xd6, 0x4e, 0x0c, 0x15, 0x52, 0x53, 0x21, 0xc5, 0x8e, 0xdb, 0x58, 0x34, 0x76,
	0xd8, 0xa4, 0xe1, 0x87, 0x8a, 0xac, 0x8b, 0x6f, 0x6b, 0x8e, 0x9c, 0x6f, 0x2f, 0x77, 0xeb, 0x80,
	0x85, 0xa8, 0x54, 0x10, 0xbc, 0xc1, 0x43, 0xf9, 0x0b, 0xfa, 0xc2, 0x03, 0xe2, 0x91, 0x27, 0xc4,
	0x5f, 0xc0, 0x2b, 0xff, 0x02, 0x8f, 0xbc, 0xf1, 0x0f, 0xa0, 0xdb, 0xdb, 0xb3, 0x7d, 0xce, 0x5d,
	0xec, 0x48, 0xbc, 0x79, 0x67, 0xe7, 0x33, 0xf3, 0x99, 0x99, 0xbd, 0x99, 0x31, 0xac, 0xb4, 0x18,
	0x6b, 0x19, 0xb4, 0xa0, 0xa9, 0x5c, 0x75, 0x38, 0xb3, 0x69, 0xe1, 0x6c, 0xb3, 0x7f, 0xc8, 0x5b,
	0x36, 0xe3, 0x0c, 0x2f, 0x79, 0x4a, 0xf9, 0xbe, 0xfc, 0x6c, 0x33, 0x7b, 0x4d, 0x22, 0x55, 0x4b,
	0x2f, 0xa8, 0xa6, 0xc9, 0xb8, 0xca, 0x75, 0x66, 0x3a, 0x1e, 0x24, 0x9b, 0x0b, 0xb3, 0x4b, 0x4d,
	0xae, 0xf3, 0xae, 0xd4, 0xb8, 0x11, 0xa6, 0x71, 0xda, 0xa1, 0xb6, 0x54, 0x50, 0x5e, 0x21, 0x98,
	0x7b, 0xcc, 0xd8, 0x49, 0xc7, 0x22, 0xf4, 0xb4, 0x43, 0x1d, 0x8e, 0xaf, 0x03, 0x58, 0x36, 0xfb,
	0x8c, 0x36, 0x79, 0x43, 0xd7, 0x32, 0x89, 0x1c, 0x5a, 0x4b, 0x92, 0xa4, 0x94, 0x54, 0x35, 0x5c,
	0x86, 0x59, 0x9b, 0xaa, 0x5a, 0x83, 0x59, 0x82, 0x49, 0x06, 0xe5, 0xd0, 0x5a, 0xaa, 0x98, 0xcb,
	0x87, 0xb0, 0xcf, 0x13, 0xaa, 0x6a, 0x75, 0x4f, 0x8f, 0xa4, 0xec, 0xfe, 0x01, 0xdf, 0x81, 0xa9,
	0x13, 0xda, 0x75, 0x32, 0x93, 0xb9, 0xc9, 0xb5, 0x54, 0x31, 0x13, 0x0a, 0x7e, 0x8f, 0x76, 0x89,
	0xd0, 0x52, 0x7e, 0x47, 0x30, 0xef, 0x73, 0x74, 0x2c, 0x66, 0x3a, 0x14, 0xbf, 0x03, 0xd3, 0xcf,
	0x58, 0xc7, 0xd4, 0x32, 0x48, 0x58, 0x78, 0x3d, 0xd4, 0x42, 0x45, 0x64, 0x82, 0x50, 0xa7, 0x63,
	0x70, 0xe2, 0xe9, 0xe3, 0x2d, 0x98, 0x69, 0xeb, 0x8e, 0xa3, 0x9b, 0xad, 0x4c, 0x6c, 0x5c, 0xa8,
	0x8f, 0xc0, 0x6f, 0x43, 0x42, 0xa3, 0xcf, 0xa8, 0x6d, 0x53, 0x6d, 0x24, 0xf5, 0x9e, 0xa6, 0xf2,
	0x5b, 0x0c, 0x16, 0x48, 0xc7, 0x7c, 0xdf, 0xcd, 0xfa, 0xf8, 0x49, 0xb6, 0x54, 0x9b, 0xeb, 0x6e,
	0xb6, 0x5c, 0x85, 0xd8, 0x05, 0x49, 0xde, 0xf7, 0x15, 0xab, 0x1a, 0x49, 0x59, 0xfd, 0xc3, 0x7f,
	0x53, 0xa9, 0x22, 0x4c, 0x8b, 0xe7, 0x92, 0x99, 0x14, 0xe8, 0x6c, 0x28, 0x5a, 0x84, 0xb6, 0x3b,
	0x41, 0x3c, 0x55, 0xfc, 0x00, 0x92, 0xad, 0x53, 0xa3, 0xe1, 0xe1, 0x66, 0x04, 0xee, 0x7a, 0x28,
	0xee, 0xd1, 0xa9, 0xe1, 0x43, 0x13, 0x2d, 0xf9, 0xbb, 0x34, 0x0b, 0x20, 0x90, 0x0d, 0xde, 0xb5,
	0xa8, 0xf2, 0x02, 0x41, 0xba, 0x9f, 0x3c, 0x59, 0xfd, 0x2d, 0x98, 0x3e, 0x56, 0x79, 0xf3, 0x53,
	0x19, 0xd2, 0x6a, 0x34, 0x29, 0xaf, 0x82, 0x25, 0x57, 0x99, 0x78, 0x18, 0xbc, 0xe1, 0x47, 0x14,
	0x1b, 0x15, 0x91, 0x8c, 0x47, 0x79, 0x89, 0xe0, 0x4a, 0x89, 0xb6, 0x74, 0xf3, 0xd0, 0x56, 0x4d,
	0x47, 0x6d, 0xba, 0x99, 0x19, 0xb3, 0x90, 0x1f, 0xc2, 0x12, 0xef, 0x83, 0x7a, 0xa5, 0x00, 0xe1,
	0xfa, 0x56, 0xa8, 0xeb, 0x01, 0x27, 0x7e, 0x45, 0x30, 0x3f, 0x27, 0x53, 0x1e, 0x40, 0xe6, 0x3c,
	0x27, 0x99, 0x9f, 0x1c, 0xa4, 0x06, 0x10, 0x22, 0x4b, 0xb3, 0x64, 0x50, 0xa4, 0x10, 0x58, 0x20,
	0xcc, 0x30, 0x8e, 0xd5, 0xe6, 0xc9, 0x98, 0x91, 0x8c, 0xb6, 0x89, 0x21, 0xdd, 0xb7, 0xe9, 0x31,
	0x51, 0x7e, 0x89, 0xc1, 0x5c, 0x99, 0xb5, 0xdb, 0x3a, 0x1f, 0xd3, 0xcd, 0x16, 0x4c, 0xb5, 0x99,
	0x46, 0x33, 0xd3, 0x39, 0xb4, 0x36, 0x1f, 0x91, 0xa1, 0x80, 0xc1, 0xfc, 0x1e, 0xd3, 0x28, 0x11,
	0x20, 0xac, 0x84, 0x70, 0xdc, 0x9d, 0x08, 0xb0, 0xc4, 0x5b, 0x90, 0x6c, 0x77, 0x64, 0x1b, 0xcd,
	0xc4, 0xc5, 0x47, 0x1c, 0xfe, 0x38, 0xf7, 0xa4, 0x16, 0xe9, 0xeb, 0x2b, 0x0f, 0x61, 0xca, 0x75,
	0x87, 0x97, 0x21, 0xbd, 0x57, 0xdf, 0xa9, 0x34, 0x9e, 0xd4, 0x0e, 0xf6, 0x2b, 0xe5, 0xea, 0xc3,
	0x6a, 0x65, 0x27, 0x3d, 0x81, 0x17, 0x61, 0xee, 0x90, 0x6c, 0xd7, 0x0e, 0xb6, 0xcb, 0x87, 0xd5,
	0x7a, 0x6d, 0xfb, 0x71, 0x1a, 0xe1, 0xff, 0xc1, 0x62, 0xad, 0x5e, 0x6b, 0x04, 0xc5, 0xb1, 0xd2,
	0xff, 0x61, 0x79, 0xf0, 0x59, 0x38, 0xd4, 0xa0, 0x4d, 0xce, 0x6c, 0xe5, 0x5b, 0x04, 0xf3, 0x7e,
	0x74, 0xb2, 0x96, 0x35, 0x48, 0xfb, 0xfe, 0x1b, 0xb6, 0x78, 0xcd, 0x7e, 0xdb, 0x5c, 0xb9, 0x98,
	0xb6, 0xd7, 0xbb, 0x16, 0xda, 0x81, 0xb3, 0x83, 0x57, 0x60, 0x4e, 0x37, 0x35, 0xfa, 0x45, 0xa3,
	0x63, 0x69, 0x2a, 0xa7, 0x4e, 0x66, 0x2a, 0x87, 0xd6, 0xa6, 0xc9, 0xac, 0x10, 0x3e, 0xf1, 0x64,
	0x8a, 0x0a, 0x78, 0xdb, 0x30, 0x58, 0x53, 0xe5, 0xb4, 0xaa, 0x39, 0x63, 0x96, 0xce, 0x6f, 0xea,
	0x68, 0xac, 0xa6, 0x5e, 0x86, 0xa5, 0x80, 0x0b, 0x19, 0xee, 0xe5, 0x8c, 0xbc, 0x40, 0xb0, 0x48,
	0xa8, 0x43, 0xed, 0xb3, 0x4b, 0xf0, 0xbc, 0x01, 0x29, 0xd7, 0xdc, 0xb1, 0xea, 0x50, 0xf7, 0x3e,
	0x29, 0xee, 0xc1, 0x17, 0x5d, 0x3a, 0x90, 0x65, 0xc0, 0x83, 0x14, 0xe4, 0xc3, 0xff, 0x35, 0x06,
	0x09, 0xbf, 0x14, 0xf8, 0x1e, 0xc4, 0x75, 0xd3, 0xa1, 0x36, 0x17, 0xc9, 0x4e, 0x15, 0xaf, 0x5e,
	0x30, 0x73, 0x76, 0x27, 0x88, 0x54, 0x76, 0x61, 0x5e, 0x91, 0xc4, 0xd7, 0x30, 0x1a, 0xe6, 0x29,
	0x7b, 0x30, 0xe1, 0x2d, 0x3e, 0x26, 0x4c, 0x78, 0x2b, 0x42, 0x5c, 0xa3, 0x06, 0xe5, 0x54, 0xb6,
	0xec, 0xc8, 0xb8, 0x5d, 0x8c, 0xa7, 0x89, 0x57, 0x60, 0x56, 0xa4, 0xf1, 0x8c, 0xda, 0x8e, 0xfb,
	0xc5, 0xb9, 0xb9, 0x9e, 0xdc, 0x45, 0x24, 0xe5, 0x4a, 0x8f, 0x3c, 0x61, 0x29, 0x05, 0x49, 0x66,
	0x51, 0x5b, 0xa4, 0xa2, 0x74, 0x1d, 0xae, 0x36, 0x99, 0xf9, 0xcc, 0xd0, 0x9b, 0xbc, 0xa1, 0x51,
	0x4e, 0xe5, 0x07, 0xc0, 0x6d, 0x95, 0xd3, 0x56, 0x57, 0xf9, 0x06, 0xc1, 0x7c, 0xf0, 0x05, 0xe3,
	0x75, 0x98, 0x3c, 0xa1, 0xfe, 0xfc, 0x89, 0x2e, 0x86, 0xab, 0x84, 0x33, 0x30, 0xe3, 0x53, 0x71,
	0x33, 0x3d, 0x49, 0xfc, 0x23, 0xbe, 0x0d, 0x8b, 0x43, 0x7e, 0xa9, 0x26, 0xd2, 0x9a, 0x20, 0x69,
	0xff, 0x62, 0x47, 0xca, 0x95, 0x7f, 0x10, 0xa4, 0x06, 0x26, 0x22, 0xfe, 0x04, 0xd2, 0x62, 0x92,
	0x36, 0x99, 0xe9, 0xe8, 0x0e, 0xa7, 0x66, 0xb3, 0x2b, 0x9a, 0xcb, 0x7c, 0x71, 0x63, 0xd4, 0x34,
	0x15, 0xbf, 0xcb, 0x7d, 0xdc, 0xee, 0x04, 0x59, 0xb0, 0x83, 0xa2, 0xe1, 0xb6, 0x15, 0x0b, 0x69,
	0x5b, 0xca, 0x1e, 0x2c, 0x0c, 0x59, 0xc2, 0x39, 0xb8, 0x46, 0x2a, 0xdb, 0x3b, 0x8d, 0x72, 0xbd,
	0x76, 0x50, 0x3d, 0x38, 0xac, 0xd4, 0xca, 0x1f, 0x0d, 0x35, 0x24, 0x80, 0xf8, 0xc1, 0x21, 0xa9,
	0xd7, 0x1e, 0xa5, 0x11, 0x9e, 0x85, 0x44, 0xe5, 0xa8, 0x52, 0x3b, 0x7c, 0x22, 0x1a, 0x10, 0x86,
	0xf4, 0x40, 0x30, 0xde, 0xa8, 0xfd, 0x3e, 0x06, 0xf8, 0xfc, 0xf0, 0xc1, 0x04, 0x40, 0x04, 0xff,
	0xb9, 0xad, 0x73, 0x2a, 0x27, 0xee, 0xe6, 0x98, 0x93, 0x4b, 0x44, 0xff, 0x81, 0x0b, 0xdc, 0x9d,
	0x20, 0x49, 0xdb, 0x3f, 0xe0, 0x3a, 0x24, 0xbd, 0xd5, 0xc4, 0x34, 0xfc, 0x39, 0xbc, 0x71, 0x19,
	0x93, 0x75, 0xd3, 0x10, 0x4b, 0x83, 0x2d, 0x7f, 0x67, 0xdf, 0x85, 0x64, 0xcf, 0x15, 0xde, 0x84,
	0x65, 0xcb, 0xa6, 0x67, 0x3a, 0xeb, 0x38, 0x8d, 0xf3, 0x33, 0x6b, 0xc9, 0xbf, 0x1b, 0xb0, 0x9d,
	0x05, 0x48, 0xf8, 0x76, 0x4b, 0x71, 0x6f, 0x04, 0x15, 0xff, 0x9e, 0x81, 0xe4, 0x8e, 0x4f, 0x06,
	0x3f, 0x87, 0xb8, 0xb7, 0x83, 0x62, 0x25, 0x94, 0x69, 0x60, 0x89, 0xce, 0xae, 0x5c, 0xa8, 0x23,
	0x7b, 0xc4, 0xed, 0xaf, 0xff, 0xfc, 0xeb, 0xc7, 0xd8, 0xaa, 0x92, 0x73, 0x97, 0x72, 0xd9, 0x9f,
	0x9c, 0xc2, 0x97, 0xfd, 0xde, 0xf5, 0xd5, 0x7d, 0x43, 0x20, 0xee, 0xa3, 0x75, 0xfc, 0x1d, 0x82,
	0x84, 0xbf, 0x08, 0xe1, 0x9b, 0xe1, 0xcf, 0x2e, 0xb8, 0x64, 0x66, 0x57, 0x47, 0x68, 0x49, 0x1a,
	0x77, 0x05, 0x8d, 0x5b, 0x8a, 0x12, 0x4d, 0xc3, 0x96, 0x18, 0x97, 0xc8, 0x4f, 0x08, 0xd2, 0xc3,
	0x9b, 0x07, 0xbe, 0x13, 0xea, 0x2a, 0x62, 0x69, 0xca, 0xde, 0x1d, 0x53, 0x5b, 0x12, 0xbc, 0x27,
	0x08, 0x16, 0x94, 0xf5, 0x68, 0x82, 0xc7, 0x43, 0x58, 0x97, 0xe8, 0x73, 0x88, 0x7b, 0xb3, 0x34,
	0xa2, 0x62, 0x81, 0x35, 0x22, 0xa2, 0x62, 0xc1, 0x61, 0x3c, 0x4e, 0xc5, 0x9a, 0x02, 0xd1, 0xab,
	0x98, 0x5c, 0x88, 0xa2, 0x2a, 0x16, 0xdc, 0xc1, 0xa2, 0x2a, 0x36, 0xbc, 0x55, 0x8d, 0x53, 0x31,
	0x89, 0x71, 0x89, 0xbc, 0x44, 0x90, 0x1a, 0x98, 0xb5, 0x38, 0x7c, 0xab, 0x3a, 0x3f, 0xf0, 0xb3,
	0x6b, 0xa3, 0x15, 0x25, 0xa3, 0x0d, 0xc1, 0x68, 0x5d, 0x59, 0x8d, 0x66, 0xa4, 0xf6, 0x61, 0x2e,
	0xa9, 0x1f, 0x10, 0x40, 0x7f, 0x6e, 0xe2, 0x37, 0x22, 0x1a, 0xe9, 0xd0, 0x6c, 0xcf, 0xde, 0x1a,
	0xa9, 0x27, 0x19, 0x15, 0x04, 0xa3, 0x37, 0x95, 0x9b, 0x17, 0xe4, 0xa8, 0x87, 0xba, 0x8f, 0xd6,
	0x4b, 0xaf, 0x10, 0x5c, 0x69, 0xb2, 0x76, 0x98, 0xfd, 0xd2, 0x7c, 0xaf, 0x0f, 0xec, 0xbb, 0xff,
	0x9a, 0xf7, 0xd1, 0xc7, 0x0f, 0xa4, 0x5a, 0x8b, 0x19, 0xaa, 0xd9, 0xca, 0x33, 0xbb, 0x55, 0x68,
	0x51, 0x53, 0xfc, 0xa7, 0x2e, 0x78, 0x57, 0xaa, 0xa5, 0x3b, 0x81, 0xff, 0xdd, 0x5b, 0xbd, 0xc3,
	0xcf, 0xb1, 0xd7, 0x1e, 0x79, 0xf0, 0xb2, 0xc1, 0x3a, 0x5a, 0xbe, 0x67, 0x3d, 0x7f, 0xb4, 0xf9,
	0x87, 0x7f, 0xf7, 0x54, 0xdc, 0x3d, 0xed, 0xdd, 0x3d, 0x3d, 0xda, 0x3c, 0x8e, 0x0b, 0x07, 0x6f,
	0xfd, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x25, 0x27, 0xe9, 0x95, 0x51, 0x10, 0x00, 0x00,
}
