/***************************************************************************
 *                                                                         *
 *   inndarr.cpp    (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include "inndarr.h"
#include "ali.h"


//construction function
InNdArr::InNdArr () {
	curNInNd_ = 0;
	maxNInNd_ = 0;
	maxNExNd_ = alignment.getNSeq ();
}

//--------------------------------------------------------------------
//construction function
InNdArr::InNdArr (const int maxNInNd) {
	curNInNd_ = 0;
	maxNInNd_ = 0;
	maxNExNd_ = alignment.getNSeq ();
	setLimit (maxNInNd);
}

//--------------------------------------------------------------------
//set the limit of this array
void InNdArr::setLimit (const int maxNInNd) {
	maxNInNd_ = maxNInNd;
	maxNExNd_ = maxNInNd_ + 2;
	items_.set (maxNInNd_, maxNInNd_);
	//the number of external nodes is more than 2 the number of internal nodes
	for (int count_ = 0; count_ < maxNInNd_; count_ ++)
		items_[count_].setLimit (maxNExNd_);
}

//--------------------------------------------------------------------
//set the number of external nodes
void InNdArr::setMaxNExNd (const int maxNExNd) {
	maxNExNd_ = maxNExNd;
}

//--------------------------------------------------------------------
//add a new node
void InNdArr::operator += (InNd &inNd) {
	curNInNd_++;
	int inNdNo_ = inNd.getId ();
	items_[inNdNo_ - maxNExNd_] = inNd;
}

//--------------------------------------------------------------------
//change the content of this item
void InNdArr::changeItem (InNd &inNd) {
	int inNdNo_ = inNd.getId ();
	items_[inNdNo_ - maxNExNd_] = inNd;
}

//--------------------------------------------------------------------
//get the number of currently existing in nds
int InNdArr::getCurNNd () {
	return curNInNd_;
}

//--------------------------------------------------------------------
//get the maximum number of external nodes
int InNdArr::getMaxNExNd () {
	return maxNExNd_;
}


//--------------------------------------------------------------------
//del an existing in nd
void InNdArr::operator -= (int inNdNo) {
	curNInNd_ --;
	items_[inNdNo - maxNExNd_].clean ();
}

//--------------------------------------------------------------------
//return a new internal node
int InNdArr::getNewNd () {
	for (int inNdNo_ = maxNExNd_; inNdNo_ < maxNExNd_ + curNInNd_ + 1; inNdNo_ ++)
		if (items_[inNdNo_ - maxNExNd_].getId () == -1)
			return inNdNo_;
	return -1;
}

//--------------------------------------------------------------------
//clean the content of this array
void InNdArr::clean () {
	for (int count_ = 0; count_ < maxNInNd_; count_ ++)
		items_[count_].clean ();

	curNInNd_ = 0;
}

//--------------------------------------------------------------------
//return the in nd of number ndNo
InNd &InNdArr::operator[] (const int index) {
	return items_[index - maxNExNd_];
}

//--------------------------------------------------------------------
//get the maximum number internal  of this class
int InNdArr::getMaxNNd () {
	return maxNInNd_;
}

//--------------------------------------------------------------------
//get the items list of this class
Vec<InNd> &InNdArr::getItem () {
	return items_;
}


void InNdArr::getExDesNd (int parNdNo, int ndNo, Vec<int> &exDesNdNoLs) {
	if (isExNd (ndNo) == 1) {
		exDesNdNoLs.setLimit (1);
		exDesNdNoLs += ndNo;
	} else {
		int lChiNdNo_, rChiNdNo_;
		items_[ndNo - maxNExNd_].get2RemNeiNd (parNdNo, lChiNdNo_, rChiNdNo_);
		getExDesNd (ndNo, lChiNdNo_, exDesNdNoLs);

		Vec<int> rExDesNdNoLs_;
		getExDesNd (ndNo, rChiNdNo_, rExDesNdNoLs_);
		exDesNdNoLs += rExDesNdNoLs_;
	}
}


//--------------------------------------------------------------------
//this = InNdArr
void InNdArr::operator = (InNdArr &inNdArr) {
	this->curNInNd_ = inNdArr.getCurNNd ();
	this->maxNInNd_ = inNdArr.getMaxNNd ();
	this->maxNExNd_ = inNdArr.getMaxNExNd ();
	this->items_ = inNdArr.getItem ();
}

//--------------------------------------------------------------------
//check whether of not ndNo is an internal node
int InNdArr::isInNd (const int ndNo) {
	return (ndNo >= maxNExNd_);
}

//--------------------------------------------------------------------
//check whether of not ndNo is an external node
int InNdArr::isExNd (const int ndNo) {
	return (ndNo < maxNExNd_);
}

//--------------------------------------------------------------------
//release all memory of this class
void InNdArr::release () {
	int realLimit_ = items_.getLimit ();
	items_.setSize (realLimit_);
	for (int count_ = 0; count_ < realLimit_; count_ ++)
		items_[count_].release ();
	items_.release ();

}

//--------------------------------------------------------------------
//destruction function
InNdArr::~InNdArr () {
	release ();
	//  std::cout << "this is the constructor function of InNdArr class " << endl;
}
