/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "tn93m.h"

#include "opturtree.h"

#include "brent.h"

//=========================================================================
//=========================================================================
void TN93M::createRateParameters () {
	tsAG_ = tsTvRatio_ * ( 2.0 / (pyPuRatio_ + 1.0 ) );
	tsCT_ = tsTvRatio_ * ( 2.0 * pyPuRatio_ / (pyPuRatio_ + 1.0) );
	tvAC_ =  1.0;
	tvAT_ =  1.0;
	tvCG_ =  1.0;
	tvGT_ =  1.0;

	double sumGenPam_ = tsAG_ + tsCT_ + tvAC_ + tvAT_ + tvCG_ + tvGT_;
	tsAG_ /=  sumGenPam_;
	tsCT_ /=  sumGenPam_;
	tvAC_ /=  sumGenPam_;
	tvAT_ /=  sumGenPam_;
	tvCG_ /=  sumGenPam_;
	tvGT_ /=  sumGenPam_;

	unitRateMat_[BASE_A][BASE_C] = tvAC_;
	unitRateMat_[BASE_C][BASE_A] = tvAC_;

	unitRateMat_[BASE_A][BASE_G] = tsAG_;
	unitRateMat_[BASE_G][BASE_A] = tsAG_;

	unitRateMat_[BASE_A][BASE_T] = tvAT_;
	unitRateMat_[BASE_T][BASE_A] = tvAT_;

	unitRateMat_[BASE_C][BASE_G] = tvCG_;
	unitRateMat_[BASE_G][BASE_C] = tvCG_;

	unitRateMat_[BASE_C][BASE_T] = tsCT_;
	unitRateMat_[BASE_T][BASE_C] = tsCT_;

	unitRateMat_[BASE_G][BASE_T] = tvGT_;
	unitRateMat_[BASE_T][BASE_G] = tvGT_;

	unitRateMat_[BASE_A][BASE_A] = 0.0;
	unitRateMat_[BASE_C][BASE_C] = 0.0;
	unitRateMat_[BASE_G][BASE_G] = 0.0;
	unitRateMat_[BASE_T][BASE_T] = 0.0;
}

//=========================================================================
//=========================================================================
void TN93M::init () {
	createRateParameters ();
	tranprobmat(nState_);
} /* tranprobmat */

void TN93M::reInit () {
	createRateParameters ();
	tranprobmat(nState_);
}

//----------------------------------------------------------------------------------------------------------------------------------------
double TN93M::cmpNegLogLi (double value) {
	if (isActPam_ == TS_TV_RATIO)
		tsTvRatio_ = value;
	else
		pyPuRatio_ = value;

	reInit ();

	opt_urtree.cmpLiNd ();
	//opt_urtree.opt (MAX_IT_UR_BR_PAM_OPT);
	double logLi_ = opt_urtree.getLogLi ();
	return -logLi_;
}


//--------------------------------------------------------------------
//optimize the tsTvRatio basing Brent method
bool TN93M::optPam (const PAM_TYPE tsTvRatioType, const PAM_TYPE pyPuRatioType) {
	double fx_, error_;
	double oriTsTvRatio_ = tsTvRatio_;
	double oriPyPuRatio_ = pyPuRatio_;


	//  double logLi_ = opt_urtree.getLogLi ();
	if (isMasterProc())
		std::cout <<"Optimizing Tamura-Nei model parameters ..." << endl;
	Brent::turnOnOptedPam ();
	double logLi_ = opt_urtree.cmpLogLi ();
	//  std::cout <<"Log likelihood: " << logLi_ << endl;


	if (tsTvRatioType == ESTIMATE) {
		isActPam_ = TS_TV_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing transition/transversion ratio..." << endl;
		tsTvRatio_= Brent::optOneDim (MIN_TS_TV_RATIO, tsTvRatio_, MAX_TS_TV_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();
	}//end of optimizing tsTvRatio

	if (pyPuRatioType == ESTIMATE) {
		isActPam_ = PY_PU_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing pyrimidine/purine ratio..." << endl;
		pyPuRatio_= Brent::optOneDim (MIN_PY_PU_RATIO, pyPuRatio_, MAX_PY_PU_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}//end of optimizing pyPuRatio

	//      logLi_ = opt_urtree.cmpLogLi ();
	//     std::cout <<"Log likelihood: " << logLi_ << endl;
	//------------------------------/------------------------------/





	opt_urtree.cmpLiNd ();
	logLi_ = opt_urtree.getLogLi ();

	std::cout.precision (10);
	//  std::cout << "Log likelihood: " << logLi_ << endl;

	if (isMasterProc()) {

		std::cout.precision (5);
		std::cout << "Transition/transversion ratio =  " << tsTvRatio_/2.0 << endl;
		std::cout << "Pyrimidine/purine ratio       =  " << pyPuRatio_ << endl;
	}

	Brent::turnOffOptedPam ();
	return (fabs (tsTvRatio_ - oriTsTvRatio_) > EPS_MODEL_PAM_ERROR ||
	        fabs (pyPuRatio_ - oriPyPuRatio_) > EPS_MODEL_PAM_ERROR );
}

