package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLogQuery invokes the aegis.CreateLogQuery API synchronously
// api document: https://help.aliyun.com/api/aegis/createlogquery.html
func (client *Client) CreateLogQuery(request *CreateLogQueryRequest) (response *CreateLogQueryResponse, err error) {
	response = CreateCreateLogQueryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLogQueryWithChan invokes the aegis.CreateLogQuery API asynchronously
// api document: https://help.aliyun.com/api/aegis/createlogquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateLogQueryWithChan(request *CreateLogQueryRequest) (<-chan *CreateLogQueryResponse, <-chan error) {
	responseChan := make(chan *CreateLogQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLogQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLogQueryWithCallback invokes the aegis.CreateLogQuery API asynchronously
// api document: https://help.aliyun.com/api/aegis/createlogquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateLogQueryWithCallback(request *CreateLogQueryRequest, callback func(response *CreateLogQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLogQueryResponse
		var err error
		defer close(result)
		response, err = client.CreateLogQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLogQueryRequest is the request struct for api CreateLogQuery
type CreateLogQueryRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	QueryName   string `position:"Query" name:"QueryName"`
	Conditions  string `position:"Query" name:"Conditions"`
	QueryDetail string `position:"Query" name:"QueryDetail"`
}

// CreateLogQueryResponse is the response struct for api CreateLogQuery
type CreateLogQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLogQueryRequest creates a request to invoke CreateLogQuery API
func CreateCreateLogQueryRequest() (request *CreateLogQueryRequest) {
	request = &CreateLogQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CreateLogQuery", "vipaegis", "openAPI")
	return
}

// CreateCreateLogQueryResponse creates a response to parse from CreateLogQuery response
func CreateCreateLogQueryResponse() (response *CreateLogQueryResponse) {
	response = &CreateLogQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
