package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScene invokes the airec.DeleteScene API synchronously
func (client *Client) DeleteScene(request *DeleteSceneRequest) (response *DeleteSceneResponse, err error) {
	response = CreateDeleteSceneResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSceneWithChan invokes the airec.DeleteScene API asynchronously
func (client *Client) DeleteSceneWithChan(request *DeleteSceneRequest) (<-chan *DeleteSceneResponse, <-chan error) {
	responseChan := make(chan *DeleteSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSceneWithCallback invokes the airec.DeleteScene API asynchronously
func (client *Client) DeleteSceneWithCallback(request *DeleteSceneRequest, callback func(response *DeleteSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSceneResponse
		var err error
		defer close(result)
		response, err = client.DeleteScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSceneRequest is the request struct for api DeleteScene
type DeleteSceneRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Path" name:"sceneId"`
}

// DeleteSceneResponse is the response struct for api DeleteScene
type DeleteSceneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Code      string `json:"code" xml:"code"`
	Message   string `json:"message" xml:"message"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDeleteSceneRequest creates a request to invoke DeleteScene API
func CreateDeleteSceneRequest() (request *DeleteSceneRequest) {
	request = &DeleteSceneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DeleteScene", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]", "airec", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteSceneResponse creates a response to parse from DeleteScene response
func CreateDeleteSceneResponse() (response *DeleteSceneResponse) {
	response = &DeleteSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
