package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceErrorRank invokes the dataworks_public.GetInstanceErrorRank API synchronously
func (client *Client) GetInstanceErrorRank(request *GetInstanceErrorRankRequest) (response *GetInstanceErrorRankResponse, err error) {
	response = CreateGetInstanceErrorRankResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceErrorRankWithChan invokes the dataworks_public.GetInstanceErrorRank API asynchronously
func (client *Client) GetInstanceErrorRankWithChan(request *GetInstanceErrorRankRequest) (<-chan *GetInstanceErrorRankResponse, <-chan error) {
	responseChan := make(chan *GetInstanceErrorRankResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceErrorRank(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceErrorRankWithCallback invokes the dataworks_public.GetInstanceErrorRank API asynchronously
func (client *Client) GetInstanceErrorRankWithCallback(request *GetInstanceErrorRankRequest, callback func(response *GetInstanceErrorRankResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceErrorRankResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceErrorRank(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceErrorRankRequest is the request struct for api GetInstanceErrorRank
type GetInstanceErrorRankRequest struct {
	*requests.RpcRequest
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// GetInstanceErrorRankResponse is the response struct for api GetInstanceErrorRank
type GetInstanceErrorRankResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	InstanceErrorRank InstanceErrorRank `json:"InstanceErrorRank" xml:"InstanceErrorRank"`
}

// CreateGetInstanceErrorRankRequest creates a request to invoke GetInstanceErrorRank API
func CreateGetInstanceErrorRankRequest() (request *GetInstanceErrorRankRequest) {
	request = &GetInstanceErrorRankRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetInstanceErrorRank", "", "")
	request.Method = requests.POST
	return
}

// CreateGetInstanceErrorRankResponse creates a response to parse from GetInstanceErrorRank response
func CreateGetInstanceErrorRankResponse() (response *GetInstanceErrorRankResponse) {
	response = &GetInstanceErrorRankResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
