package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigCenters invokes the edas.ListConfigCenters API synchronously
func (client *Client) ListConfigCenters(request *ListConfigCentersRequest) (response *ListConfigCentersResponse, err error) {
	response = CreateListConfigCentersResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigCentersWithChan invokes the edas.ListConfigCenters API asynchronously
func (client *Client) ListConfigCentersWithChan(request *ListConfigCentersRequest) (<-chan *ListConfigCentersResponse, <-chan error) {
	responseChan := make(chan *ListConfigCentersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigCenters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigCentersWithCallback invokes the edas.ListConfigCenters API asynchronously
func (client *Client) ListConfigCentersWithCallback(request *ListConfigCentersRequest, callback func(response *ListConfigCentersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigCentersResponse
		var err error
		defer close(result)
		response, err = client.ListConfigCenters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigCentersRequest is the request struct for api ListConfigCenters
type ListConfigCentersRequest struct {
	*requests.RoaRequest
	AppName         string `position:"Query" name:"AppName"`
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
	DataIdPattern   string `position:"Query" name:"DataIdPattern"`
	Group           string `position:"Query" name:"Group"`
}

// ListConfigCentersResponse is the response struct for api ListConfigCenters
type ListConfigCentersResponse struct {
	*responses.BaseResponse
	Code              int               `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ConfigCentersList ConfigCentersList `json:"ConfigCentersList" xml:"ConfigCentersList"`
}

// CreateListConfigCentersRequest creates a request to invoke ListConfigCenters API
func CreateListConfigCentersRequest() (request *ListConfigCentersRequest) {
	request = &ListConfigCentersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListConfigCenters", "/pop/v5/configCenters", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListConfigCentersResponse creates a response to parse from ListConfigCenters response
func CreateListConfigCentersResponse() (response *ListConfigCentersResponse) {
	response = &ListConfigCentersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
