package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPackage invokes the foas.ListPackage API synchronously
func (client *Client) ListPackage(request *ListPackageRequest) (response *ListPackageResponse, err error) {
	response = CreateListPackageResponse()
	err = client.DoAction(request, response)
	return
}

// ListPackageWithChan invokes the foas.ListPackage API asynchronously
func (client *Client) ListPackageWithChan(request *ListPackageRequest) (<-chan *ListPackageResponse, <-chan error) {
	responseChan := make(chan *ListPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPackageWithCallback invokes the foas.ListPackage API asynchronously
func (client *Client) ListPackageWithCallback(request *ListPackageRequest, callback func(response *ListPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPackageResponse
		var err error
		defer close(result)
		response, err = client.ListPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPackageRequest is the request struct for api ListPackage
type ListPackageRequest struct {
	*requests.RoaRequest
	ProjectName string           `position:"Path" name:"projectName"`
	PackageName string           `position:"Query" name:"packageName"`
	PageSize    requests.Integer `position:"Query" name:"pageSize"`
	PageIndex   requests.Integer `position:"Query" name:"pageIndex"`
	Tag         string           `position:"Query" name:"tag"`
	Type        string           `position:"Query" name:"type"`
}

// ListPackageResponse is the response struct for api ListPackage
type ListPackageResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageIndex  int      `json:"PageIndex" xml:"PageIndex"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	TotalPage  int      `json:"TotalPage" xml:"TotalPage"`
	TotalCount int64    `json:"TotalCount" xml:"TotalCount"`
	Packages   Packages `json:"Packages" xml:"Packages"`
}

// CreateListPackageRequest creates a request to invoke ListPackage API
func CreateListPackageRequest() (request *ListPackageRequest) {
	request = &ListPackageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "ListPackage", "/api/v2/projects/[projectName]/packages", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListPackageResponse creates a response to parse from ListPackage response
func CreateListPackageResponse() (response *ListPackageResponse) {
	response = &ListPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
