// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbautoconf/auto_config.proto

package pbautoconf

import (
	pbconfig "github.com/hashicorp/consul/proto/private/pbconfig"
	pbconnect "github.com/hashicorp/consul/proto/private/pbconnect"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AutoConfigRequest is the data structure to be sent along with the
// AutoConfig.InitialConfiguration RPC
type AutoConfigRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Datacenter is the local datacenter name. This wont actually be set by clients
	// but rather will be set by the servers to allow for forwarding to
	// the leader. If it ever happens to be set and differs from the local datacenters
	// name then an error should be returned.
	Datacenter string `protobuf:"bytes,1,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	// Node is the node name that the requester would like to assume
	// the identity of.
	Node string `protobuf:"bytes,2,opt,name=Node,proto3" json:"Node,omitempty"`
	// Segment is the network segment that the requester would like to join
	Segment string `protobuf:"bytes,4,opt,name=Segment,proto3" json:"Segment,omitempty"`
	// Partition is the partition that the requester would like to join
	Partition string `protobuf:"bytes,8,opt,name=Partition,proto3" json:"Partition,omitempty"`
	// JWT is a signed JSON Web Token used to authorize the request
	JWT string `protobuf:"bytes,5,opt,name=JWT,proto3" json:"JWT,omitempty"`
	// ConsulToken is a Consul ACL token that the agent requesting the
	// configuration already has.
	ConsulToken string `protobuf:"bytes,6,opt,name=ConsulToken,proto3" json:"ConsulToken,omitempty"`
	// CSR is a certificate signing request to be used when generating the
	// agents TLS certificate
	CSR           string `protobuf:"bytes,7,opt,name=CSR,proto3" json:"CSR,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutoConfigRequest) Reset() {
	*x = AutoConfigRequest{}
	mi := &file_private_pbautoconf_auto_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoConfigRequest) ProtoMessage() {}

func (x *AutoConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbautoconf_auto_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoConfigRequest.ProtoReflect.Descriptor instead.
func (*AutoConfigRequest) Descriptor() ([]byte, []int) {
	return file_private_pbautoconf_auto_config_proto_rawDescGZIP(), []int{0}
}

func (x *AutoConfigRequest) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *AutoConfigRequest) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *AutoConfigRequest) GetSegment() string {
	if x != nil {
		return x.Segment
	}
	return ""
}

func (x *AutoConfigRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *AutoConfigRequest) GetJWT() string {
	if x != nil {
		return x.JWT
	}
	return ""
}

func (x *AutoConfigRequest) GetConsulToken() string {
	if x != nil {
		return x.ConsulToken
	}
	return ""
}

func (x *AutoConfigRequest) GetCSR() string {
	if x != nil {
		return x.CSR
	}
	return ""
}

// AutoConfigResponse is the data structure sent in response to a AutoConfig.InitialConfiguration request
type AutoConfigResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Config is the partial Consul configuration to inject into the agents own configuration
	Config *pbconfig.Config `protobuf:"bytes,1,opt,name=Config,proto3" json:"Config,omitempty"`
	// CARoots is the current list of Connect CA Roots
	CARoots *pbconnect.CARoots `protobuf:"bytes,2,opt,name=CARoots,proto3" json:"CARoots,omitempty"`
	// Certificate is the TLS certificate issued for the agent
	Certificate *pbconnect.IssuedCert `protobuf:"bytes,3,opt,name=Certificate,proto3" json:"Certificate,omitempty"`
	// ExtraCACertificates holds non-Connect certificates that may be necessary
	// to verify TLS connections with the Consul servers
	ExtraCACertificates []string `protobuf:"bytes,4,rep,name=ExtraCACertificates,proto3" json:"ExtraCACertificates,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *AutoConfigResponse) Reset() {
	*x = AutoConfigResponse{}
	mi := &file_private_pbautoconf_auto_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoConfigResponse) ProtoMessage() {}

func (x *AutoConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbautoconf_auto_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoConfigResponse.ProtoReflect.Descriptor instead.
func (*AutoConfigResponse) Descriptor() ([]byte, []int) {
	return file_private_pbautoconf_auto_config_proto_rawDescGZIP(), []int{1}
}

func (x *AutoConfigResponse) GetConfig() *pbconfig.Config {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AutoConfigResponse) GetCARoots() *pbconnect.CARoots {
	if x != nil {
		return x.CARoots
	}
	return nil
}

func (x *AutoConfigResponse) GetCertificate() *pbconnect.IssuedCert {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *AutoConfigResponse) GetExtraCACertificates() []string {
	if x != nil {
		return x.ExtraCACertificates
	}
	return nil
}

var File_private_pbautoconf_auto_config_proto protoreflect.FileDescriptor

const file_private_pbautoconf_auto_config_proto_rawDesc = "" +
	"\n" +
	"$private/pbautoconf/auto_config.proto\x12\"hashicorp.consul.internal.autoconf\x1a\x1dprivate/pbconfig/config.proto\x1a\x1fprivate/pbconnect/connect.proto\"\xc5\x01\n" +
	"\x11AutoConfigRequest\x12\x1e\n" +
	"\n" +
	"Datacenter\x18\x01 \x01(\tR\n" +
	"Datacenter\x12\x12\n" +
	"\x04Node\x18\x02 \x01(\tR\x04Node\x12\x18\n" +
	"\aSegment\x18\x04 \x01(\tR\aSegment\x12\x1c\n" +
	"\tPartition\x18\b \x01(\tR\tPartition\x12\x10\n" +
	"\x03JWT\x18\x05 \x01(\tR\x03JWT\x12 \n" +
	"\vConsulToken\x18\x06 \x01(\tR\vConsulToken\x12\x10\n" +
	"\x03CSR\x18\a \x01(\tR\x03CSR\"\x9f\x02\n" +
	"\x12AutoConfigResponse\x12@\n" +
	"\x06Config\x18\x01 \x01(\v2(.hashicorp.consul.internal.config.ConfigR\x06Config\x12D\n" +
	"\aCARoots\x18\x02 \x01(\v2*.hashicorp.consul.internal.connect.CARootsR\aCARoots\x12O\n" +
	"\vCertificate\x18\x03 \x01(\v2-.hashicorp.consul.internal.connect.IssuedCertR\vCertificate\x120\n" +
	"\x13ExtraCACertificates\x18\x04 \x03(\tR\x13ExtraCACertificatesB\x9b\x02\n" +
	"&com.hashicorp.consul.internal.autoconfB\x0fAutoConfigProtoP\x01Z4github.com/hashicorp/consul/proto/private/pbautoconf\xa2\x02\x04HCIA\xaa\x02\"Hashicorp.Consul.Internal.Autoconf\xca\x02\"Hashicorp\\Consul\\Internal\\Autoconf\xe2\x02.Hashicorp\\Consul\\Internal\\Autoconf\\GPBMetadata\xea\x02%Hashicorp::Consul::Internal::Autoconfb\x06proto3"

var (
	file_private_pbautoconf_auto_config_proto_rawDescOnce sync.Once
	file_private_pbautoconf_auto_config_proto_rawDescData []byte
)

func file_private_pbautoconf_auto_config_proto_rawDescGZIP() []byte {
	file_private_pbautoconf_auto_config_proto_rawDescOnce.Do(func() {
		file_private_pbautoconf_auto_config_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbautoconf_auto_config_proto_rawDesc), len(file_private_pbautoconf_auto_config_proto_rawDesc)))
	})
	return file_private_pbautoconf_auto_config_proto_rawDescData
}

var file_private_pbautoconf_auto_config_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_private_pbautoconf_auto_config_proto_goTypes = []any{
	(*AutoConfigRequest)(nil),    // 0: hashicorp.consul.internal.autoconf.AutoConfigRequest
	(*AutoConfigResponse)(nil),   // 1: hashicorp.consul.internal.autoconf.AutoConfigResponse
	(*pbconfig.Config)(nil),      // 2: hashicorp.consul.internal.config.Config
	(*pbconnect.CARoots)(nil),    // 3: hashicorp.consul.internal.connect.CARoots
	(*pbconnect.IssuedCert)(nil), // 4: hashicorp.consul.internal.connect.IssuedCert
}
var file_private_pbautoconf_auto_config_proto_depIdxs = []int32{
	2, // 0: hashicorp.consul.internal.autoconf.AutoConfigResponse.Config:type_name -> hashicorp.consul.internal.config.Config
	3, // 1: hashicorp.consul.internal.autoconf.AutoConfigResponse.CARoots:type_name -> hashicorp.consul.internal.connect.CARoots
	4, // 2: hashicorp.consul.internal.autoconf.AutoConfigResponse.Certificate:type_name -> hashicorp.consul.internal.connect.IssuedCert
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_private_pbautoconf_auto_config_proto_init() }
func file_private_pbautoconf_auto_config_proto_init() {
	if File_private_pbautoconf_auto_config_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbautoconf_auto_config_proto_rawDesc), len(file_private_pbautoconf_auto_config_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_private_pbautoconf_auto_config_proto_goTypes,
		DependencyIndexes: file_private_pbautoconf_auto_config_proto_depIdxs,
		MessageInfos:      file_private_pbautoconf_auto_config_proto_msgTypes,
	}.Build()
	File_private_pbautoconf_auto_config_proto = out.File
	file_private_pbautoconf_auto_config_proto_goTypes = nil
	file_private_pbautoconf_auto_config_proto_depIdxs = nil
}
