/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.ILoggerFactory;
import org.slf4j.impl.AndroidLogger;

public class AndroidLoggerFactory
implements ILoggerFactory {
    private final Map<String, AndroidLogger> loggerMap = new HashMap<String, AndroidLogger>();
    static final int TAG_MAX_LENGTH = 23;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidLogger getLogger(String name) {
        String actualName = this.forceValidName(name);
        AndroidLogger slogger = null;
        AndroidLoggerFactory androidLoggerFactory = this;
        synchronized (androidLoggerFactory) {
            slogger = this.loggerMap.get(actualName);
            if (slogger == null) {
                if (!actualName.equals(name)) {
                    Log.i((String)AndroidLoggerFactory.class.getSimpleName(), (String)("Logger name '" + name + "' exceeds maximum length of " + 23 + " characters, using '" + actualName + "' instead."));
                }
                slogger = new AndroidLogger(actualName);
                this.loggerMap.put(actualName, slogger);
            }
        }
        return slogger;
    }

    private final String forceValidName(String name) {
        if (name != null && name.length() > 23) {
            StringTokenizer st = new StringTokenizer(name, ".");
            if (st.hasMoreTokens()) {
                StringBuilder sb = new StringBuilder();
                do {
                    String token;
                    if ((token = st.nextToken()).length() == 1) {
                        sb.append(token);
                        sb.append('.');
                        continue;
                    }
                    if (st.hasMoreTokens()) {
                        sb.append(token.charAt(0));
                        sb.append("*.");
                        continue;
                    }
                    sb.append(token);
                } while (st.hasMoreTokens());
                name = sb.toString();
            }
            if (name.length() > 23) {
                name = name.substring(0, 22) + '*';
            }
        }
        return name;
    }
}

