/***************************************************************************
                          game.cpp  -  play a round
                             -------------------
    begin                : Tue Oct 14 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cob.hxx"

//	**************************************************************************************************************************
//
//                                                      Run a level
//
//	**************************************************************************************************************************

int Game::Run(int Speed,int Level,int Chasers)
{
    int Move;
    int Killed = 0;
    int StartTime,StartColour;
        
    if (map.Load(Level) == 0) SDWERROR();       // Try to load the level

    Player player(map,graphics);                // Player object
    Chaser *chaser[MAXCHASERS];                 // Chaser objects
    if (Chasers > MAXCHASERS) SDWERROR();
    for (int i = 0;i < Chasers;i++)             // Create them
                chaser[i] = new Chaser(map,graphics);

    Move = GameClock();                         // Movement control
    StartTime = SystemClock();
    StartColour = map.ToColour();
    while (ExitKey() == 0 &&                    // Main loop
                    map.IsComplete() == 0 && Killed == 0)
    {
        surface.Copy();                         // Copy map surface to logical screen
        while (Move < GameClock())              // Move all objects
        {
            player.Move();                      // Player
            for (int i = 0;i < Chasers;i++)     // Work through the chasers
            {
                chaser[i]->Move();              // Move, check if hit player
                if (chaser[i]->Collide(player)) Killed = 1;
            }
            Move += 1000/108*100/Speed;         // Resynchronise
        }
        map.CheckHide();                        // Check to see if holes are removed
        player.Paint();                         // Draw player
        for (int i = 0;i < Chasers;i++)         // Draw chasers
                                chaser[i]->Paint();
        surface.Flip();                         // Flip to front
    }
    if (Killed) GameOver();                     // Dead, display game over
    if (map.IsComplete())                       // Completed map, add score
                LevelOver(SystemClock()-StartTime,StartColour);
    else                                        // otherwise just what you got
        Score = Score + (StartColour-map.ToColour());
    return map.IsComplete();
}

//	**************************************************************************************************************************
//
//                                                      Run a level
//
//	**************************************************************************************************************************

void Game::GameOver(void)
{
    Timer t(3000);
    DisplaySurface disp;
    Rect r(128,284,896,484);
    while (!t.TimedOut())
    {
        disp.SetColour(rand()%256,rand()%256,rand()%256);
        disp.String(r,"Game Over");
        disp.Flip();
    }
}

//	**************************************************************************************************************************
//
//                                                      Run a level
//
//	**************************************************************************************************************************

void Game::LevelOver(int Time,int Colour)
{
    int a,b,x,y;
    DisplaySurface disp;
    int TimeBonus = Colour*3-Time/1000;         // 3 secs per colour
    if (TimeBonus < 0) TimeBonus = 0;
    disp.SetColour(0,0,0);disp.FillRect();
    DrawScore(768/3,"Score:",Colour);
    DrawScore(768*2/3,"Bonus:",TimeBonus);
    Score = Score + Colour+TimeBonus;
    disp.Flip();
    while (ReadStick(a,b,x,y) != 0) {};         // Wait release
    while (ReadStick(a,b,x,y) == 0) {};         // Wait press
    while (ReadStick(a,b,x,y) != 0) {};         // Wait release
}

//	**************************************************************************************************************************
//
//                                             Display a score entry
//
//	**************************************************************************************************************************

void Game::DrawScore(int yc,char *Text,int Num)
{
    DisplaySurface disp;
    char Buffer[6];
    disp.SetColour(255,255,0);
    Rect rc(192,yc-80,576,yc+80);
    disp.String(rc,Text);
    rc.Left = 704;rc.Right = rc.Left+256;
    sprintf(Buffer,"%-4d",Num);
    disp.SetColour(0,255,255);
    disp.String(rc,Buffer);
}
