#!/usr/bin/perl -w
#
# Name ............: simplebackup.pl
# Type ............: Perl Script
#
# Version .........: 1.8.1
# Last Update .....: 12 January 2007
#
# License .........: GNU GENERAL PUBLIC LICENSE Version 2, June 1991.
#
# Authors ..........: Miguel Angelo Martins Morais Leite,
# Program E-Mail ...: migas.miguel@gmail.com
# Site .............: http://migas-sbackup.sourceforge.net
# Forum ............: http://sourceforge.net/projects/migas-sbackup
#
# Objective .......: Read a configuration file and do a backup of one or more directories
#                    and files and generate one or more a compressed files. The compressed
#                    file(s) will be placed on a chosen directory, a remote ftp server, a
#                    remote sftp server, one or more email accounts or on a tape device
#                    (unix only).
#                    It supports full,incremental or differential backups using
#                    automatic backup session management.
#
# Depends on ......: Perl (v5.6 or over)
#                    Following archive programs (executables must be on your $PATH variable)
#                      * rar/winrar (v3.6 or over http://www.rarlab.com) : for rar backup format
#                      * 7-Zip (v4.42 or over http://www.7-zip.org) : for 7z backup format
#                      * info-zip (http://www.info-zip.org) : for zip backup format
#                      * tar : for tar, tar compress, tar gzip, tar bzip2 backup format
#                      * compress : for tar compress backup format
#                      * gzip (http://www.gzip.org): for tar gzip backup format
#                      * bzip2 (http://www.bzip.org) : for tar bzip2 backup format
#
# Runs On .........: Windows NT4, Windows 2000, Windows XP, 2003 and All Unix systems
#
#
# Revision History (Change Log):
#                    1.0.0 RC1 - 10 March 2004 - Miguel Angelo Martins Leite
#                      1. First version.
#
#                    1.0.0 RC2 - 13 March 2004 - Miguel Angelo Martins Leite
#                      1. Loads of tests on Unix (Linux) and Windows (XP) systems, most with
#                         success.
#                      2. Small fixes on Unix systems (Linux).
#                      3. Added support to run scripts/batch files/commands before and
#                         after a backup. Can be used to for example to shut-down a database
#                         do the backup, and in the end bring the database backup on-line.
#                      4. Improved the log messages.
#                      5. Improved a lot the documentation (readme.txt).
#                      6. Added support for zip backup files, using the info-zip software
#                         (http://www.info-zip.org/pub/infozip/) and included a Windows
#                         version to the simplebackup package, this will help Windows users
#                         get the backups running faster.
#
#                    1.0.0 RC3 - 17 March 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Small fixes on the documentation (readme.txt).
#                      3. Fixed a bug that reported a success backup even if the backup failed.
#                         It happened when the write move of the backup file into the final
#                         backup directory failed, fallowed by a success backup reported.
#                         Now if the move of the file fails (lack of space, permissions, etc)
#                         the backup is reported has failed.
#                      4. Added a new field on the log file message, the configuration file name,
#                         this should help people that only use a single log file for all backups.
#                         Thanks to my friend Alexandre Pereira for this suggestion.
#                      5. Added a new option on the configuration file ( backup_compression_ratio )
#                         which enables users to select the compression ratio that they want to use
#                         on their compression files. Options are generic for all archive formats, 
#                         none ; minimal ; average and maximal.
#                         Notice that not all formats support the compression ratio in that case
#                         the option is adapted or ignored, and simplebackup will not fail.
#                         Thanks to my friend Alexandre Pereira for this suggestion.
#
#                    1.0.0 RC4 - 19 March 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Small fixes on the documentation (readme.txt).
#
#                    1.0.0 RC5 - 25 March 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Improved the documentation (readme.txt).
#                      3. Fixed a small message that was miss representing the operation, it was
#                         reporting "Executing before backup procedure using command...", when it
#                         should be reporting "Executing after backup procedure using command..."
#                      4. Improved a bit more the log file, reporting the path him self.
#                      5. Added a new argument (--tconf) and function show_config(), --tconf tests
#                         the a given configuration file (example: simplebackup.pl --tconf file.conf),
#                         and the show_config() function will print the file configuration.
#                         And the most important reason, now i can use this to produce a screenshot
#                         to place on the program site hehehehe :).
#                      6. Centralized the operating system null device on the configuration hash
#                         (%global_config), and this value is now loaded on the read_config() function.
#                      7. Changed the simplebackup.pl intro screen to match the changes.
#
#                    1.0.0 RC6 - 27 March 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Improved the documentation (readme.txt).
#                      3. Small improvement on the log messages.
#                      4. Changed the Windows NT4 [ host_os ] parameter from nt4 into winnt4, it
#                         makes more sense this way, i think.
#                      5. Small fix on Windows NT4, simplebackup was letting Windows move command
#                         print a message when it shouldn't.
#                      6. Added a new warning, if simplebackup is unable to write into the backup
#                         log file, it will complain generally A LOT !, but will not fail.
#                      7. Fixed the zip support on Unix, info-zip does not support the -S parameter
#                         on Unix systems, -S is only for Microsoft Windows Systems, and Mac's.
#                      8. Remove code that added the null device into the command defined by
#                         "run_before_backup" and the "run_after_backup" on the configuration file,
#                         this might cause problems on some Windows programs that simply do not
#                         understand the concept of text redirect "command 2>nul", one example of
#                         this is Microsoft Outlook XP.
#                         If you want to redirect a output of a external command into the null
#                         device you must add that option into the "run_before_arguments" and the
#                         "run_afters_arguments" in the configuration file.
#                      9. Added support for directories and file names with spaces, example
#                         [ d:\test\name 1 with spaces\name 2 with spaces\final directory with spaces ]
#                         or [ /name 1 with spaces/name 2 with spaces/final directory with spaces ].
#
#                    1.0.0 28 March 2004 - Miguel Angelo Martins Leite
#                      1. Final stable version, simplebackup was tested on several operating systems
#                         and several situations. This is a copy of RC6.
#
#                    1.1.0 RC1 - 12 April 2004 - Miguel Angelo Martins Leite
#                      1. Fixed a bug, in the move_file() function, that in some situations could
#                         make it fail to report a missed moved file. In the previous simplebackup
#                         version the bug existed but failed to "work" hehehehe, but because of
#                         changes on the function the bug "worked" ;)
#                      2. Added support for backup's into FTP servers, with url check up, support
#                         for FTP passive mode and open FTP proxies.
#                      3. Added new options to the sample configuration file (simplebackup_example.conf).
#                      4. Added the function local_db_file_history() that manages a simple db file,
#                         that contains the backup file list managed by simplebackup. This is done
#                         to permit simplebackup to operate with "strange" ftp servers that produce
#                         weird file lists (ls/dir commands).
#                      5. Added support to show the FTP details on the --tconf option (test
#                         configuration file).
#                      6. Improvements on the program commentaries.
#                      7. Changed a bit the log messages.
#                      8. Previous backup configuration files (from simplebackup 1.0.0) remain 100%
#                         compatible.
#
#                    1.1.0 RC2 - 13 April 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Improved the documentation (readme.txt).
#                      3. General code change in order to simplify and improve the program performance
#                         in the function read_config().
#                      4. Added extra security to the move_file() function, in order to prevent
#                         writing over already existing files.
#                      5. Small improvement on the log messages.
#                      6. Changed a bit the simplebackup.pl intro screen to match the changes.
#
#                    1.1.0 RC3 - 16 April 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Improved the documentation (readme.txt).
#                      3. Bug fix on the session management, it was incorrectly reducing one backup
#                         session.
#                      4. Bug fix on a situation related to erasing data from the database file, if
#                         simplebackup was using the database file and working in "local file system"
#                         mode.
#                      5. Bug fix on a problem that prevented backup's into the / (root) path of a ftp
#                         server.
#                      6. To make it more coherent with the log_file name, changed the name of variables
#                         from local_db_file_history into local_db_history_file, and to prevent
#                         confusions also change the name of the function local_db_file_history() into
#                         work_local_db_history_file().
#                      7. Improvements on the program commentaries.
#                      8. Changed a bit the log messages.
#
#                    1.1.0 RC4 - 29 April 2004 - Miguel Angelo Martins Leite
#                      1. Added a new security mechanism on the ftp backups. If the upload of the backup
#                         file fails simplebackup will attempt to erase the partially upload file, since
#                         it is damaged.
#                         Plus in situations where simplebackup is using a local database file, there for
#                         using the function local_db_history_file(), if the erase of the partially uploaded
#                         uploaded file fails the file name will be added into the database file. This is
#                         done in order to prevent constant backup failures, backup's will recover more
#                         easily.
#                       2. Fixed the sample configuration file for windows.
#
#                    1.1.0 - 01 May 2004 - Miguel Angelo Martins Leite
#                      1. New stable version of simplebackup, this is a copy of RC4.
#                      2. Main features of this new version compared to version 1.0.0 are:
#                         . Support backup's into FTP servers,
#                         . Possibility to use a local database file to manage backup session,
#                         . Improved program commentaries,
#                         . Improved backup log,
#                         . Previous backup configuration files from version 1.0.0 remain 100%
#                           compatible.
#
#                    1.2.0 RC1 - 11 May 2004 - Miguel Angelo Martins Leite
#                      1. Added support for backup mail reporting, using SMTP mail servers only,
#                         simplebackup can now report the backup results into one or more email
#                         addresses, this means small changes all over the program. Specially
#                         into the functions read_config() and write_file_log().
#                      2. Added new options to the sample configuration file (simplebackup_example.conf).
#                      3. Added support to show the mail details on the --tconf option (test
#                         configuration file).
#                      4. Added the function send_email() that actualy attempts to send the backup
#                         mail report.
#                      5  Added the function get_mail_date() that returns the system date in mail format,
#                         this function is used by the send_email() function.
#                      6. For security reasons the code that wrote the ftp password into the log
#                         file was removed.
#                      7. Changed the default ftp timeout value from 240 to 480, this is a attempt to make
#                         simplebackup even more tolerant to network failures.
#                      8. The mail server timeout value is also 480.
#                      9. Now simplebackup will report the hostname where it's running in the log file and
#                         in the email subject.
#                     10. Bug fix on the readme.txt file, my friend is called Nuno Mu�oz and not Nuno Munhoz.
#                     11. Previous backup configuration files (from simplebackup 1.0.0 and 1.1.0)
#                         remain 100% compatible.
#
#                    1.2.0 RC2 - 13 May 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (XP) systems.
#                      2. Improved the documentation (readme.txt).
#                      3. Small improvement on the log messages.
#                      4. Improved a bit the backup report email.
#                      5. Fixed the english on the sample configuration file.
#                      6. Bug fix on the email subject field, simplebackup was not correctly reporting the
#                         configuration file name, it was reporting teste.conf over and over again.
#
#                    1.2.0 RC3 - 14 May 2004 - Miguel Angelo Martins Leite
#                      1. Continuing testes on Unix (Linux) and Windows (NT4, 2000, XP) systems.
#                      2. Improved a bit the backup report email.
#
#                    1.2.0 - 22 May 2004 - Miguel Angelo Martins Leite
#                      1. New stable version of simplebackup, this is a copy of 1.2.0 RC3 with very little changes.
#                      2. Tested simplebackup under Microsoft Windows 2003 with 100% success, simplebackup is fully
#                         compatible with it.
#                      3. Added support for Microsoft Windows 2003 in the configuration files, where you reported
#                         "host = win2000/xp", you should now report "host = win2000/xp/2003", but simplebackup
#                         will continue to accepted old configuration files with "host = win2000/xp".
#                      4. Main features of this new version compared to version 1.1.0 are:
#                         . Simplebackup can now send backup reports using email (smtp mail servers only),
#                         . Tested and found simplebackup 100% compatible with Microsoft Windows 2003,
#                         . Improved backup log,
#                         . Previous backup configuration files from version 1.0.0 and 1.1.0 remain 100%
#                           compatible.
#
#                    1.2.1 - 01 June 2004 - Miguel Angelo Martins Leite
#                      1. Bug fix on the function get_previous_filedir_name(), it was causing Perl warnings during
#                         unix backups if the backup directory was close to the root level, example /etc.
#                         The error passes without problems on Perl 5.6 but starts producing problems on Perl 5.8.
#
#                    1.3.0 RC1 - 29 June 2004 - Miguel Angelo Martins Leite
#                      1. Testes on Unix (Linux, FreeBsd) and Windows (XP) systems.
#                      2. Improved and re-worked the documentation (readme.txt) adding more stuff and changing
#                         the line size in order for it to be better view on standard console/shell/command line,
#                         meaning 24x80 chars.
#                      3. Added support to show the new options on the --tconf option (test configuration file),
#                         also improved a bit this entire option.
#                      4. Added support for incremental and differential backups. This meant new functions,
#                         check_add_to_backup(), build_present_backup_list(), read_write_management_file(),
#                         rebuild_full_path() is_today(), is_year_bisex(), and several changes all over,
#                         configuration file changes using configuration keys renames and new configuration keys.
#                      5. Added support of file rejections, simplebackup can now do backups selecting what file
#                         types not to backup, this can be used for example to do a user home backup rejecting all
#                         mp3,mov,wav,ogg files.
#                      6. Added support for file size limitation, simplebackup can reject files if they are over
#                         a given size.
#                      7. Added support for specific directory orders by using a special file named
#                         [ simplebackup_rejection.txt ].
#                      8. Added the function remove_excess_spaces() do deal with era tic user input on some
#                         configuration options.
#                      9. Added a new option that allows simplebackup to send the backup log into a external
#                         command using the standard input (stdin), the command or commands can be and do anything.
#                     10. Added a new function check_if_full_path() that will check if the user is using full path's
#                         in the configuration file.
#                     11. Added a pause of 60 seconds that will run after simplebackup runs with success the program
#                         defined by the configuration key [ run_before_backup ]. This is done to make safer backups
#                         since some programs don't free their files immediately after ending.
#                     12. Centralized the operating system file/directory separator, the "d:\my\path" or
#                         "/my/path" char) on the configuration hash (%global_config), and this value is now
#                         loaded in the read_config() function.
#                     13. Removed the all the truncate() perl commands since they where creating problems with perl
#                         5.8.0 causing some file corruption (log file, etc). This appears to be a perl bug.
#                     14. Bug fix, i was using the perl close() function to close directories when i should be using
#                         closedir(). This is tolerable but definitely wasn't good programming.
#                     15. Renamed the function compress_input_dir() into do_backup().
#                     16. Moved the actual compress commands (rar,zip,tar,etc) into the do_compress() function this
#                         will make it simpler maintain the program in the future.
#                     17. Small code improvements all over the program, in order to improve security, performance
#                         (where possible) and to allow for future improvements.
#                     18. Re-worked the error messages that are printed into the shell in order for them to fit
#                         better on a standard console/shell/command line, meaning 24x80 chars.
#                     19. Previous backup configuration files (from simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1)
#                         remain 100% compatible.
#
#                    1.3.0 RC2 - 30 June 2004 - Miguel Angelo Martins Leite
#                      1. Small improvement on the is_today() function.
#                      2. Improved the documentation (readme.txt).
#
#                    1.3.0 RC3 - 04 July 2004 - Miguel Angelo Martins Leite
#                      1. Added code to remove excess \ (Windows) or / (Unix) from the directory paths, this could
#                         cause problems in backup modes that used a backup list of files.
#                      2. Added a new check in order to prevent users from using the same file to do Database backup
#                         management (incremental/differential backups) and  Local Database file history (management
#                         of the backup file names).
#                      3. Bug fix a situation that was forcing full backups in Windows even if the simplebackup was
#                         working in incremental or differential backup modes.
#                      4. Bug fix a backup failure related to empty directories in incremental or differential
#                         backup modes if the tar format was being used.
#                      5. Corrected a small problem on the log file, that was causing a missed typed text in the
#                         last message of each backup.
#                      6. Renamed function is_year_bisex() to is_leap_year(), in portuguese bisesto is leap year, in
#                         english it's something about sex :) hehehe.
#                      7. Changed some log messages.
#                      8. Improved the documentation (readme.txt).
#
#                    1.3.0 RC4 - 11 July 2004 - Miguel Angelo Martins Leite
#                      1. Testes on Unix (Linux, FreeBsd) and Windows (XP) systems.
#                      2. Added a extra security, now if simplebackup is working in incremental or differential
#                         backup mode and if it's a "full backup day" the management file is erased. This is done
#                         to always force a full backup every time until a one finishes with success.
#                      3. Improved the documentation (readme.txt).
#
#                    1.3.0 - 25 July 2004 - Miguel Angelo Martins Leite
#                      1. New stable version of simplebackup, this is a copy of 1.3.0 RC4 with very little changes.
#                      2. Bug fixed a situation that would cause backup failure if simplebackup was doing full backups
#                         and using advanced backup file selections.
#                      3. Added a new field on the test configuration screen that shows up the operating system
#                         detected by simplebackup.
#                      4. For backups that require a backup list and if tar format is used the "-T" parameter will
#                         be used for Linux and Windows. The "-I" for all other operating systems. This will further
#                         improve compatibility with Unix operating systems.
#                      5. This is the most tested simplebackup version to date. Tested under SuSe Linux 8.1, SuSe
#                         Linux 9.1, Red Hat 8.0, Red Hat 9.0, Freebsd 4.1.0, FreeBsd 5.2.1, OpenBsd 3.5, Windows NT4
#                         Windows 2000, Windows XP, Windows 2003.
#                      6. Improved the documentation (readme.txt).
#                      7. Main features of this new version compared to version 1.2.1 are:
#                         . Several small bug fixes and compatibility improvements,
#                         . Added support for incremental and differential backup modes,
#                         . Advanced file selection, simplebackup can now reject backup files by type (extension)
#                           and by size,
#                         . Advanced backup directory selections,
#                         . Better control over the backup configuration files,
#                         . Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1 remain
#                           100% compatible.
#
#                    1.3.1 - 06 August 2004 - Miguel Angelo Martins Leite
#                      1. Bug fix on the zip format support, function do_compress(), it was failing in Unix systems
#                         during incremental/differential backup modes due to bad parameters being passed to 
#                         info-zip, solution replace "-S" parameter with "-@".
#                      2. Improved the documentation (readme.txt).
#
#                    1.4.0 RC1 - 15 October 2004 - Miguel Angelo Martins Leite
#                      1. Performance improvement in the incremental, differential modes. This is noticeable on large
#                         backup directory trees that have many files and sub-directories mainly under Microsoft Windows.
#                         Preliminary testing results for a backup directory with 6232 files and directories using a
#                         pentium 4 - 1600 Mhz with 512 Mb ram and using Microsoft Windows XP. With simplebackup 1.3.1
#                         the process to build the backup list toke 6 minutes and 28 seconds to build the backup list,
#                         with simplebackup 1.4.0 RC1 the same list toke only 36 seconds.
#                      2. Added support to do backups into tape devices using the tar format and with the possibility
#                         to use any commands before and after writing to tape, example mt -t /dev/tape0 rewind.
#                         Changes where done a bit all over but mainly in the functions move_file() and
#                         clear_previous_backups().
#                      3. Added code to report the size of the current compressed backup file on the backup log,
#                         thanks to Thomas for this neat feature request.
#                      4. Added code to report the full size of all compressed backup files on the backup log
#                         again thanks to Thomas for this neat feature request.
#                      5. Added a new rejection option, backup_filenames_rejections, now it's possible to reject
#                         files with a given name.
#                      6. Added a new debug option, mail_debug_level, to enable a debug of the connection to the mail
#                         server.
#                      7. Added a new debug option, ftp_debug_level, to enable a debug of the connection to the ftp
#                         server.
#                      8. Renamed the function work_local_db_history_file() to read_write_history_file().
#                      9. Re-write of the read_write_history_file() function in order to make it generate files
#                         that are similar to the simplebackup management files (with file start and end line marker)
#                         this makes history files more robust, and makes it more easy to detect file corruption and
#                         to keep the size of the backup files. This makes the previous versions of the history files
#                         incompatible with this version of simplebackup. The history file is defined by the
#                         configuration key [ local_db_history_file ].
#                     10. Change a bit the function read_write_management_file() to improve the error detection in
#                         the management file. The management file is defined by the configuration key
#                         [ backup_db_management_file ].
#                     11. Better control over weird chars in the configuration file.
#                     12. Change a bit the simplebackup intro screen.
#                     13. Changed the way the temporary file is created, now the temporary file is always created in
#                         the path defined by temporary_dir with the name of the configuration file plus the .tmp
#                         extension, example my_backup.conf.tmp.
#                     14. Fixed a compatibility problem with some external commands that use the = char in their
#                         arguments, for example the oracle exp command makes used of this in the argument
#                         file=some_file_name.dmp.
#                     15. Bug fixed a obscure bug that would show-up if the remote ftp server would change his
#                         configuration in the middle of the backup. This is only related to ftp backups.
#                     16. Bug fixed a bug in the email message system, huge thanxs to Renato Leon for his pacient
#                         testing.
#                     17. Fixed a error message that could miss represent the path into the temporary file. This
#                         only affected the advanced backup modes.
#                     18. Full code revision and improvement.
#                     19. Improved the backup log.
#                     20. Improved the documentation (readme.txt).
#                     21. Small improvement on the program commentaries.
#                     22. Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0,
#                         1.3.1 remain 100% compatible.
#
#                    1.4.0 RC2 - 22 October 2004 - Miguel Angelo Martins Leite
#                      1. Reactivated the log message that reported the total erased files in the function
#                         clear_previous_backups(), this was accidentally turn off in simplebackup 1.4.0 RC1.
#                      2. In tape backups simplebackup will now clear the history file.
#                      3. Improved the documentation (readme.txt).
#
#                    1.4.0 RC3 - 05 November 2004 - Miguel Angelo Martins Leite
#                      1. Changed the separator character used by simplebackup in the history and management
#                         files, the previous char was * and was causing problems with some programs, such as
#                         www.openwebmail.org, that generate file names with the * char, example
#                         miguel-session_look_*_.txt. This further improves simplebackup portability.
#                      2. Bug fixed a problem in the ftp backups that keep on detecting that the ftp debug
#                         level was wrong, uuups sorry.
#                      3. Improved the documentation (readme.txt).
#
#                    1.4.0 RC4 - 06 November 2004 - Miguel Angelo Martins Leite
#                      1. Improved error handling in differential/incremental backup modes, now if a full backup
#                         is forced because the management file is corrupted and if the full backup ends with success
#                         the previous backup session files will be erased and only the current full backup will be
#                         keep. This is the usual procedure of simplebackup during full backup days.
#
#                    1.4.0- 12 November 2004 - Miguel Angelo Martins Leite
#                      1. New stable version of simplebackup, this is a copy of 1.4.0 RC4 with very little changes.
#                      2. Bug fixed a problem in the mail authentication, that causes failures.
#                      3. Introduced some workaround code to deal with users that don't have the standard smtp
#                         authentication library (Authen::SASL), a warning will now be reported on the log file and
#                         simplebackup will no longer fail.
#                      4. Improved the warning messages that show up when there are problems in the mail reporting.
#                      5. Added copies of the Authen::SASL library for unix (from perl cpan) and for windows (from
#                         activestate), this will make life easier for simplebackup users.
#                      6  Improved documentation (readme.txt).
#                      7. Main features of this new version compared to version 1.3.1 are:
#                         . Several small bug fixes and compatibility improvements has a result of a full code revision
#                           and user feedback,
#                         . Improved the speed of incremental/differential backups mainly under windows,
#                         . Added tape backup support (under unix/linux only),
#                         . Added another advanced file selection, simplebackup can now reject backup files by
#                           filename,
#                         . Better control over the backup configuration files and other auxiliary files,
#                         . Greatly improved documentation (readme.txt).
#                         . Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0 and
#                           1.3.1 remain 100% compatible.
#
#                    1.4.1- 18 November 2004 - Miguel Angelo Martins Leite
#                      1. Fixed a bug that could cause a simplebackup crash during the ftp backup, if the ftp server
#                         blocks the connection right before the backup file upload. This was corrected in the function
#                         sum_all_backups() and was introduced in simplebackup 1.4.0, sorry !.
#                      2. Bug fixed several small problems in ftp backups that could occurred if simplebackup was
#                         running under a windows operating system.
#                      3. Now the message that reports "Disconnecting from ftp server" will only appear if we actually
#                         managed to connect in the first place.
#
#                    1.5.0 RC1 - 19 January 2005 - Miguel Angelo Martins Leite
#                      1. Huge speed improvement of incremental/differential under any supported operating system.
#                      2. Removed the requirement in simplebackup to always have the libnet perl library installed, this
#                         library is still required to use ftp backups and email reporting, but if the user doesn't use
#                         those features then simplebackup will work without errors.
#                      3. Added code to deal with perl installations that don't have libnet perl library installed, if ftp
#                         backups or email reporting are used simplebackup will report a error but will no longer crash.
#                      4. Removed the configuration parameters run_before_arguments and run_after_arguments, external
#                         commands and arguments can be fully declared in the configuration keys run_before and run_after.
#                         This makes simplebackup simpler ;).
#                      5. Bug fixed a problem on the function clear_previous_backups() that made simplebackup crash if the ftp
#                         connection dropped, notice that this bug did not affected any older simplebackup version.
#                      6. Added code so that simplebackup can now automatically detect the operating system, in the function
#                         get_os_type().
#                      7. Added code so that simplebackup can now automatically configure the temporary directory, in the
#                         function get_tmp_dir().
#                      8. Added code so that simplebackup can now automatically attribute the full path into the auxiliary
#                         files, the path is based on 3 things: the configuration parameter temporary_dir, the configuration
#                         file name and on the auxiliary file type.
#                      9. Improved the process that detects if a given backup file (the actual files generated by simplebackup
#                         that contain the backup data) is part or not of a backup. This detection logic is now centralized
#                         in the functions check_session_filename() and test_date().
#                     10. The backup file names will now contain a new meta data field that reflects some important extra data.
#                         Previously the logic was session_number.directory_name.extension, example [ 2.documents.zip ], the new
#                         logic is directory_name.meta_data.extension, example
#                         [ documents.2 full monday 14-12-2004 crc1234131.zip ].
#                     11. Added support for the backup of single files, previously simplebackup could only backup entire
#                         directories.
#                     12. Added multi-directory and multi-file backup options, now one can do a backup of more than one directory
#                         and file per configuration file.
#                     13. Added support to read the backup list from a separated text file.
#                     14. Added the function get_filename_session_metadata() that is used to get the session number and file
#                         metadata of any backup file, previously this code was spread and duplicated in several other functions.
#                     15. Added the function sum_backup_types() that counts the backup types (full, incremental, differential)
#                         available.
#                     16. Changed what goes into the label section of the management file, previously it was the backup directory
#                         name, now it's the crc32 number build from the path into the backup directory or file. This is part of
#                         the support of the multi-directory and multi-file backup option.
#                     17. Changed the error situation that made backups stop into a warning. If a problem is detected while building
#                         the backup list (incremental/differential and other advanced backup modes) a warning message is written
#                         into the log and the offending file or directory is ignored. This could occurred for example if the user
#                         is doing the backup of a directory and has lack of permissions for a given file.
#                     18. The function clear_previous_backups() was changed to support the multi-directory and multi-file backup
#                         options.
#                     19. Renamed the configuration key input_backup_dirs to input_backup.
#                     20. Updated the function remove_excess_spaces() to support the < separator char.
#                     21. Added the configuration parameter ftp_connect_retries. This defines the number of times that
#                         simplebackup will retry the connection into the backup ftp server, and has a default value of 6.
#                         This will make ftp backups more robust under bad network conditions.
#                     22. During ftp backup simplebackup will now automatically switch the passive mode value and retry if the
#                         ftp connection fails more than 3 times. Again this will make ftp backups more robust under bad
#                         network conditions.
#                     23. Moved the code that detects the missing Authen::SASL module from the send_email() function into the
#                         read_config() function. So now simplebackup will produce a error and not do a backup if one tries
#                         to do a backup using mail authentication without the required module available. The Authen::SASL
#                         module is required in order to support mail servers that request user authentication.
#                     24. Improved the process that compresses the backup data in function do_compress(), now simplebackup will
#                         erase the previous temporary archive files that could be left over if simplebackup crashed or if
#                         simplebackup was killed by the user.
#                     25. Added the -p parameter into the tar command backups, this will make simplebackup backups contain all
#                         permission information.
#                     26. Improved the test configuration option (--tconf parameter).
#                     27. Improved the log file with more error messages.
#                     28. General code improvements and simplifications.
#                     29. Improved the documentation (readme.txt).
#                     30. Improved the configuration file example (simplebackup_example.conf).
#                     31. Previous backup configuration files (from simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0,
#                         1.4.1) remain 100% compatible.
#
#                    1.5.0 RC2 - 21 January 2005 - Miguel Angelo Martins Leite
#                      1. Bug fixed the problem with the backup list coming from external a file that prevented any valid
#                         file from being loaded. Huge thanks to Dr. A.M. Genaev for this bug fix.
#
#                    1.5.0 RC3 - 26 January 2005 - Miguel Angelo Martins Leite
#                      1. Bug fixed a non critical problem in the ftp backups. If a problem appeared on the initial ftp connection
#                         to the ftp server simplebackup would double the connections.
#                      2. Added the parameter --econf, function create_edit_config(), this will allow simplebackup create (if no file
#                         exists) and edit a given configuration file using the operating system text editor, vi under unix and notepad
#                         under windows.
#                      3. Improved the way simplebackup detects "out of sync" backups, a full backup is also forced if incremental or
#                         differential backups files are detected and the backup is working in the other backup mode (in differential
#                         or incremental).
#                      4. Improved the documentation (readme.txt).
#                      5. Uncompressed all files inside of the simplebackup package, this makes the installation a little bit easier.
#
#                    1.5.0 - 12 February 2005 - Miguel Angelo Martins Leite
#                      1. New stable version of simplebackup, this is a copy of 1.5.0 RC3 with very little changes.
#                      2. Bug fixed a problem in the way simplebackup processed the input_backup parameter in configurations
#                         with multiple directories/files and the use of space chars. Thanks to John for reporting this.
#                      3. Improved some log messages.
#                      4. Main features of this new version compared to version 1.4.1 are:
#                         . Huge speed improvement during incremental/differential backups under any supported operating system,
#                         . Support for the backup of multi-directory and multi-individual files on a single backup configuration,
#                         . Improved backup file names,
#                         . Option to include the hostname on the backup file names,
#                         . Simpler backup configuration with less configuration keys and the use of automatic detections, example
#                           detect the operating system,
#                         . Added the parameted --econf, that can create and edit configurations files, users are no longer required
#                           to use the example configuration files,
#                         . The backup list can be read from a simple text file,
#                         . Improved documentation (readme.txt),
#                         . Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1
#                           remain 100% compatible.
#
#                    1.5.1 - 28 February 2005 - Miguel Angelo Martins Leite
#                      1. Bug fixed a problem that could lead simplebackup to dump warnings into the prompt if it was unable to
#                         get the file modification time, this occurred during incremental/differential backups. Simplebackup can
#                         fail to get the file modification time because of, lack of permissions, file system errors or if it gets files
#                         with "weird" dates, meaning dates before "00:00 January 1, 1970 GMT" (unix epoc), in those cases a warning is
#                         written into the backup log and the file is ignored. This is a very rare problem, and is simple perl warning.
#                         Thanks to Dave Eduards for reporting this bug.
#                      2. Now if the user is using the configuration key hostname_on_backup_files and the auto configuration options the
#                         hostname will be also added into the auxiliary files (log file, management file, history file).
#                      3. Improved some log messages.
#                      4. Improved documentation (readme.txt),
#
#                    1.6.0 RC1 - 16 September 2005 - Miguel Angelo Martins Leite
#                      1. Added support for doing restores, to allow this the functions test_and_prepare_restore_config() ;
#                         get_substring() ; build_restore_list() ; get_backup_file() ; copy_file() ; make_directory() ; do_uncompress() ;
#                         do_restore() ; rebuild_restore_history_file() ; list_all_backup_files() ; get_substring() ; restore_menu() and
#                         clear_screen() where added. The restore supports several options and modes
#                         including a autosync mode that allows simplebackup to act has a synchronization tool between different data
#                         depots, and a manual restore that enables the user to configure the restore by using text menus.
#                      2. Added two new configuration options, run_before_restore and run_after_restore, this will allow the the user to
#                         run what ever commands are required before and after doing the restore (example stopping/starting a database).
#                      3. Added a new advanced way to reject files and directories from the backup list, the backup_full_path_rejections
#                         configuration key enables rejection of multiple files and directories even with the use of standard wild cards.
#                         The backup list can also be loaded by using a external rejection file, similar to the one used on the
#                         backup list (input_backup configuration key). Simplebackup will also automatically add the files that it uses
#                         into this rejection list.
#                      4. Added support to allow root (/) backups, please notices that this only affects Unix operating systems, also
#                         notice that under Linux the /proc file system is automatically rejected.
#                      5. Added the function prepare_full_rejections() that prepares the backup_full_path_rejections configuration key
#                         in a way that is compatible with the perl programming language.
#                      6. Added support for doing email backups, into one or more email accounts. This meant some changes on the
#                         send_email() function and the adding of the create_email_attachment() that encodes a file into base64.
#                         The create_email_attachment() function was copied and adapted from the send_attachment() function of the
#                         sendEmail program that was written by: Brandon Zehm <caspian@dotconf.net> , huge thankx to him
#                      7. Improved the test configuration option (--tconf parameter).
#                      8. Removed the configuration keys ftp_debug_level and mail_debug_level both options were centralized on a single
#                         configuration key, the debug_level.
#                      9. Improved the debug level of simplebackup, more things are debugged and now three levels exist, none, half and
#                         full.
#                     10. Added a new configuration key, the compressed_file_size_limit, that can be used to limit the total size of the
#                         backup files generated by simplebackup.
#                     11. Added a new configuration key, the backup_mail_attachment_method that defines if simplebackup will add all the
#                         backup files into a single email or if it will send a email for each backup file.
#                     12. Added the text_note configuration key that will allow users to add a personal note into the backup log and email
#                         backups (during smtp email backups).
#                     13. Added the option to disable the backup log file.
#                     14. Added the parameter --lconf and the function show_log_file() that will allow simplebackup to show the log file
#                         of a given configuration file.
#                     15. Added the parameter --ffconf and the function force_full_backup() that will allow the user to forced full backups
#                         when ever he wants. This only affects backups that are in incremental or differential modes and it works by
#                         a simple erase of the management file.
#                     16. Turn the error that caused simplebackup to failed, if it was unable to get the size of all backup files, into a
#                         warning.
#                     17. Added a 20 seconds pause when connecting into the ftp server in order to prevent problems when getting the size
#                         of all backup files.
#                     18. Added two new configuration keys on_failure_run_after_backup ; on_failure_run_after_restore that will control
#                         if simplebackup will execute the run after backup and the run after restore commands when a error occurs.
#                     19. Changed the function read_write_history_file() in order to allow simplebackup to keep a list of what was restored,
#                         when it was restored, and how many times it was restored, this will allow it to operate like a sync copy.
#                     20. Added the configuration key local_db_restore_history_file that will allow the creation of a separated history file
#                         that will just contain the history of the restored files, this is important if the restore procedure cannot write
#                         into the standard history file (written by the backup process).
#                     21. Added new code to check and report a error if the log file is the same has the Local database history file or the
#                         Local Database restore history file.
#                     22. Renamed the function move_file() into put_backup_file().
#                     23. Replaced the use of the operating system command mv (unix) / move (windows) with the function move_file(), this
#                         means less operating system dependency.
#                     24. Updated the zip info-zip package and added the unzip info-zip package, http://www.info-zip.org/pub/infozip/. This
#                         programs help Windows users to get simplebackup running faster using zip backups.
#                     25. Improved the way simplebackup reads the configuration file, by changing the way it detects the configuration keys
#                         and by adding the option to accept low/upper case chars in most configuration values. Example the full backup day
#                         can now be defined has monday, MONDAY, Monday, etc, in practice those values are simply converted into lower case.
#                     26. Under Microsoft Windows operating systems the backup rejections, by full path, by extension, by filename, the
#                         temporary directory (temporary_dir) and the backup destination (output_backup) are converted into lower case. This
#                         will make life easier for Windows users and increase the accuracy of the rejections. Notice that under present
#                         Windows backups it could increase the amount of files and directories that are rejected from the backup.
#                     27. Removed the requirement to always have the backup directories/files (input_backup), the backup destiny
#                         (output_backup) and the temporary directory (temporary_dir) available during backups and turned this "problems"
#                         into warnings that will appear during the backup testing (--tconf argument). Errors will be logged into the
#                         simplebackup log if any of this files/directories are not available on the exact moment that they are needed.
#                         This change will allow a dynamically use of those directories or files, by doing a network mount, changing
#                         permissions, etc. A use of this change could be for example, mount a remote network drive using the
#                         run_before_backup configuration key and do the backup into that network drive. Any errors caused by this will
#                         now be reported in the log file.
#                     28. Changed the email support from [ miguel.angelo.public@migas.mine.nu ] to [ migas.miguel@gmail.com ].
#                     29. Changed the site home page from [ http://migas.mine.nu/index.php?pag=en.myapps&subpag=simplebackup ] into 
#                         [ http://migas.kicks-ass.org/index.php?pag=en.myapps&subpag=simplebackup ].
#                     30. Bug fixed a possible problem, under Windows simplebackup was not considering the upper/lower case situation when
#                         dealing when the auxiliary files (management and history file), for example [ d:\management.db ] was different
#                         from [ D:\MANAGEMENT.DB ]. Under Windows simplebackup will always lower-case the auxiliary files (management,
#                         history and restore history file).
#                     31. Bug fixed a small problem related to ftp backups, that could cause errors when connecting into the ftp server.
#                     32. Bug fixed a small "cosmetic" problem, during ftp backups simplebackup would disconnect from the ftp server twice
#                         if the initial ftp connection failed.
#                     33. Bug fixed a possible problem with the input_backup list if the user added a \ or / char on the last part of
#                         each backup entry.
#                     34. Bug fixed a small problem with the name of the backup files that where being written into tape device, during
#                         tape backups.
#                     35. Bug fixed a problem on the history file, simplebackup was keeping the wrong backup file sizes when doing a backup
#                         of more than one file/directory.
#                     36. Bug fixed a problem, simplebackup was clearing previous backups even if the backup run without success.
#                     37. Bug fixed a problem, with the logic that detected missing backup files. This bug could cause simplebackup to "fail"
#                         the backup, but generate backup files without a session number.
#                     38. Improved the program comments.
#                     39. Improved the english of the program messages.
#                     40. Improved the documentation and convert it into web format (readme.html), the previous ascii format (readme.txt)
#                         is still available.
#                     41. Previous backup configuration files (from simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0,
#                         1.4.1, 1.5.0, 1.5.1) remain 100% compatible.
#
#                    1.6.0 rc2 - 13 October 2005 - Miguel Angelo Martins Leite
#                      1. Changed the way simplebackup deals with unix link files, previously it was a bit of random, in some backup formats
#                         (tar, tar+gz, tar+bzip2, tar+compress) links were stored and in others (zip, rar) a copy of the linked file was stored.
#                         Now simplebackup will always store the link and not a copy of the linked file/directory. This change only affects
#                         simplebackup if it's running under a unix operating system.
#                      2. Improved the debug level, when working in debug mode the compress/uncompress commands will print a lot more messages,
#                         each log message created is printed and the functions build_present_backup_list(), check_add_to_backup() will print
#                         each path being tested.
#                      3. The compressed commands will only print messages when using the full debug level (debug_level = full).
#                      4. Restore the on-line simplebackup forum [ http://migas.kicks-ass.org/phpBB2 ], this will provide a much communication and
#                         support between everyone related to simplebackup.
#                      5. Added the link of the simplebackup forum into the help arguments in the function show_commands().
#                      6. Bug fixed a problem during restores if the temporary directory (temporary_dir) was the same has the backup destination
#                         (output_destiny).
#                      7. Bug fixed several problems with the restore when using a tar compressed format (tar + compress, gzip, bzip2).
#                      8. Bug fixed a problem in detecting the [ tar.Z ] format that was introduced in simplebackup 1.6.0 rc1.
#                      9. Improved the log messages.
#                     10. Improved the documentation (readme.html/readme.txt).
#
#                    1.6.0 - 09 November 2005 - Miguel Angelo Martins Leite
#                      1. New stable version of simplebackup, this is a copy of 1.6.0 rc2 with very little changes.
#                      2. Fixed a problem on the text of the default configuration file, huge thankx to Uwe for 
#                         reporting this.
#                      3. Created a "short help" that will show a simplified help.
#                      4. Added a new argument (--version) that will print the simplebackup version number.
#                      5. Added a new argument (--help) that will show the current full cmd line help.
#                      5. Improved the documentation.
#                      8. Main features of this new version compared to version 1.5.1 are:
#                         . Support for restores (except for email and tape backups) with many options and modes
#                           including a mode that allows synchronizations across different servers/locations,
#                         . Support for email backups, this will allow doing backups into one or more email accounts,
#                         . Huge improvement on the debug,
#                         . Added a new flexible method to select what files and directories to reject from the
#                           backup, this new option fully supports wild cards (example /home/*.mp3 ; c:\*.mp3),
#                         . Added several new command line parameters (--ffconf ; --lconf ; --version ; --help),
#                         . Huge improvement on the documentation, two formats are now available html(readme.html)
#                           and text(readme.txt),
#                         . Added a compiled Windows version (simplebackup.exe) to allow Microsoft Windows users to
#                           get simplebackup running faster... without having to install perl,
#                         . Updated the Windows version of info-zip zip package included with simplebackup and added
#                           the info-zip unzip package in order to allow simplebackup Windows users to restore from
#                           zip backups,
#                         . Loads of small improvements,
#                         . Several bug fixes,
#                         . Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1,
#                           1.4.0, 1.4.1, 1.5.0, 1.5.1 remain 100% compatible.
#
#                    1.7.0 rc1 - 27 December 2005 - Miguel Angelo Martins Leite
#                      1. Created and added a encryption algorithm (SimpleCrypt algorithm), that allows simplebackup to add a little
#                         security by protecting the backup from direct tapering (if used, strait uncompress will not be possible).
#                         The SimpleCrypt algorithm is very flexible and has part of his support three new configuration keys where
#                         added [ encryption_passwd ; encryption_crypt ; encryption_level ] and is present in the functions
#                         improve_encryption_sed(), return_bits(), crypt_decrypt_bytes(), crypt_decrypt_file().
#                         Please notice that encripted files will have the [ .sc ] extension added into them.
#                      2. Changes a bit all over to accommodate the [ .sc ] encryption file extension.
#                      3. Added the simplecrypt program into the simplebackup package, this program will allow the user to
#                         encrypt and decrypt any file he wants using the SimpleCrypt algorithm. It will also allow the user to
#                         manually decrypt backup files generated by simplebackup. Please notice that simplebackup will automatically
#                         decrypt the encrypted backup files during restores, so the simplecrypt program is not needed for this.
#                      4. Major code simplification by centralizing most operations that read the list of the backup files into the
#                         function list_all_backup_files(), the affected functions where get_present_session_number(),
#                         clear_previous_backups(), sum_all_backups(), sum_backup_types(), build_restore_list(). This cleared almost
#                         200 lines of code.
#                      5. Removed the log message "Notice : link file is stored as link and not as a copy of the file/directory where
#                         it pointed..." it could increase the log a lot and served little purpose, a single message will now be
#                         written into the log file. This only affects unix users.
#                      6. Improvements on the "About simplebackup" in the manual restore menu.
#                      7. Bug fixed a small cosmetic bug on the log file, that occurred if simplebackup was unable to connect into
#                         the mail server (during email backups and email reporting).
#                      8. Bug fixed a non critical bug, the erased backup files where not being properly counted during mail or tape
#                         backups.
#                      9. Bug fixed a problem with the tape backups, the null device (/dev/null) was being wrongly added into the
#                         tape_before_backup and tape_after_backup configuration keys.
#                     10. Improved the documentation.
#                     11. Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1,
#                         1.5.0, 1.5.1, 1.6.0 remain 100% compatible.
#
#                    1.7.0 rc2 - 19 January 2006 - Miguel Angelo Martins Leite
#                      1. Added specific support "advanced" tar commands (recent versions from Linux, Openbsd, Freebsd, Netbsd, etc),
#                         this will allow several improvements such has the ability to backup empty directories and direct use of
#                         compression (using compress, gzip or bzip2) lowering the disk space required for the temporary files.
#                         Standard tar is still supported.
#                      2. Removed the code that allowed backups without a backup list, backups under simplebackup are now always done
#                         using a backup list, this is another code simplification procedure.
#                      3. Added Jorge Gomes and Thomas Schwarz into the thank you section of the manual restore.
#                      4. Changed the Windows [ host_os ] parameter from winnt4 or win2000/xp/2003 into winnt4/win2000/xp/2003,
#                         simplebackup no longer needs to maintain two compatibility options for Windows Systems.
#                      5. Fixed a english problem, sucess is correctly written success, thanks to Thomas Schwarz for reporting this.
#                      6. Bug fixed a possible problem that could occurred if the encryption/decryption process failed, in this case
#                         the temporary files would not be erased.
#                      7. Bug fixed a problem with the tar support under the Aix operating system, tar on Aix does not support the -I
#                         argument, but the -L.
#                      8. Ported a bug fix and major security enhancement of the simplecrypt algorithm from the simplecrypt program.
#                         In some rare combination of passwords and encryption cycles the encryption algorithm would not encrypt. This
#                         bug fix enhances the way the simplecrypt reads the encryption sed and adds a alternative encryption sed, there
#                         for encryption will now be done using two encryption keys. Warning this makes files encrypted with
#                         simplecrypt/simplebackup 1.7.0 rc1 incompatible with this new version.
#                         Huge thanks to my friend Alexandre Pereira for all is testing and for reporting this.
#                      9. Ported a bug fix from the simplecrypt program, the algorithm was wrongly adding one encrypting cycle into what
#                         the user had required, has a result of this bug fix the encryption/decryption is a little bit faster.
#                         Again huge thanks to my friend Alexandre Pereira for all is testing and for reporting this.
#                     10. Improved the documentation.
#
#                    1.7.0 - 02 March 2006 - Miguel Angelo Martins Morais Leite
#                      1. New stable version of simplebackup, this is a copy of 1.7.0 rc2.
#                      2. Main features of this new version compared to version 1.6.0 are:
#                         . I got married ;), my name changed from Miguel Angelo Martins Leite into Miguel Angelo Martins Morais
#                           Leite,
#                         . Support for "advanced" tar commands that allows several improvements during backups and restores,
#                           this should only be used on recent tar versions from Linux, Openbsd, Freebsd, Netbsd, etc,
#                         . Added a encryption option and that allows the encryption of the generated backup files using the
#                           simplecrypt algorithm, this makes backups safer,
#                         . Added the simplecrypt program, this program allows the encryption/decryption of files using the
#                           simplecrypt algorithm,
#                         . Loads of testing on several different operating systems (Windows, Linux, Openbsd, Freebsd) and
#                           different operating systems versions,
#                         . Loads of small improvements,
#                         . Several bug fixes,
#                         . Major code clean up,
#                         . Improved documentation,
#                         . Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0,
#                           1.4.1, 1.5.0, 1.5.1, 1.6.0 remain 100% compatible.
#
#                    1.7.1 - 13 March 2006 - Miguel Angelo Martins Morais Leite
#                      1. Removed the path into the management file (even if defined by the user) if the backup is working in full
#                         backup mode. This file is only used during incremental or differential backups.
#                      2. Added default values for the configuration keys: [ backup_mode ] with full, [ full_backup_day ] with
#                         monday and [ backup_compression_ratio ] with maximal.
#                      3. Fixed the error message about the backup formats, it was not reporting the advanced_tar formats.
#                      4. Small improvements in the functions sum_all_backups().
#                      5. Major improvement of the text used by newly created configuration files (option --econf).
#                      6. The ftp connect retries number will now show up on the configuration file test (option --tconf).
#                      7. Bug fixed small control problems in the functions clear_previous_backups() and sum_backup_types() that 
#                         occurred if simplebackup was unable to list the backup destination, [ output_backup ]configuration key.
#                      8. Added Patrick into the thank you list because he reported the bug on point 7, huge thanks Patrick!.
#                      9. Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0,
#                         1.4.1, 1.5.0, 1.5.1, 1.6.0, 1.7.0 remain 100% compatible.
#
#                    1.8.0 rc1 - 28 November 2006 - Miguel Angelo Martins Morais Leite
#                      1. Added backup and restore support for http dav servers, using standard webdav protocol
#                         (http://www.webdav.org), this will allow simplebackup to backup into any web dav server such as
#                         the Apache web server, Microsoft Internet Information Server, Microsoft Exchange, Microsoft SharePoint,
#                         Subversion, etc.
#                      2. Added backup and restore support for secure ftp (ssh sftp) servers. Has part of this the function
#                         sftp_external_commands() was added, this is responsible for managing sftp connections when using the
#                         openssh sftp program or the putty sftp program (Windows only).
#                      3. Full restructuration of the restores. Restores of individual files and directories are now possible,
#                         the selection of what to restore can be done by using a restore list file or the restore menu. It's
#                         now more easy the select of large selections groups of data by using wild cards. Restores will also
#                         try to keep the disk space usage has low has possible in the temporary directory.
#                      4. Has part of the restore restructuration the restore cmd line parameters changed a bit.
#                      5. Has part of the restore restructuration the functions build_restore_list() ;
#                         test_and_prepare_restore_config() where improved or completely changed.
#                      6. Has part of the restore restructuration added the functions remove_directory() ; check_if_erase() and clear_to(),
#                         this will be responsible for erasing extra files and directories that are not part of the backup set. This will
#                         only be executed in the default restore directory and only !! during autosync restore mode or when the user so
#                         choses it.
#                      7. Added support for the 7-zip (http://www.7-zip.org) format.
#                      8. Added the function get_file_metadata_date() that will return the present backup date for the backup files
#                         and general usage on the support file.
#                      9. Added support for a support file that replaces all other database files, has a part of this the functions
#                         read_write_support_file() ; check_management_record() ; check_backup_files_record() ;
#                         check_backup_files_details_record() ; check_full_list_record() ; patch_management_records() ;
#                         patch_backup_files_records() ; patch_full_list_records() where added.
#                     10. Added the configuration keys run_backup_on_failure_run_before_backup and run_restore_on_failure_run_before_restore
#                         that allow backups and restores to continue even if the commands defined to run before backups (run_before_backup)
#                         and before restores (run_before_restore) fail.
#                     11. Added the configuration keys backup_list_on_log and restore_list_on_log that allow the user to select if the list of
#                         files and directories backup ed or restored should be added into the log.
#                     12. Added the configuration key sftp_transport that allows the user to select how simplebackup make the connection into
#                         the ssh/sftp server. This is only relevant during sftp backup or restore.
#                     13. Changed the functions get_previous_filedir_name() and get_filedir_name() to allow them to be more flexible.
#                     14. Added the command line parameters --sconf that allows the listing of the backup files or the the list of the data in
#                         the backup.
#                     15. Added debug option into the encryption/decryption functions.
#                     16. Added code to detect and write into the log and email backup message the username running the backup or restore.
#                     17. Added the function check_email() to check the email addresses and added code to notify the user if the mails addresses
#                         are not valid internet mail addresses into the configuration file testing option (--tconf).
#                     18. Added the configuration key username_on_backup_files to give the option to add the name of the user running the
#                         backup into the backup file names.
#                     19. Added the function get_external_command() that is responsible for returning the name or full path of any external command
#                         used by simplebackup. It was added to support the internal executables included in the simplebackup.exe Win32 compiled
#                         version, this allows Windows users to run simplebackup smolder with zip format support and sftp (secure ftp) build in.
#                     20. The new simplebackup windows compiled version (simplebackup.exe) now features build in zip format support and sftp (secure
#                         ftp), this are provided because the simplebackup.exe file contains inside the info-zip (zip.exe ; unzip.exe) files and the
#                         putty secure ftp program (psftp.exe). The use of this build in programs is automatically managed by simplebackup, the user
#                         should never notice this for him zip backups and secure ftp just work "out of the box".
#                     21. Added or updated the perl modules that required for using with the perl simplebackup version. This has no efect on using
#                         that are using the Windows compiled version (simplebackup.exe).
#                     22. Added a install.cmd (windows command file) that is responsible to install activestate perl modules on windows system,
#                         this should make life a bit easier for Windows people.
#                     23. Added tests to determine if some external commands are available, this is done by the function test_external_command()
#                         according to what is required and will give some warnings to the user. The tested commands are info-zip (zip ; unzip) ;
#                         rar ; 7-zip (7z) ; putty sftp (psftp) ; gzip and bzip2.
#                     24. Added the argument [ --requirements ] that lists the requirements needed by simplebackup.
#                     25. Added the configuration keys backup_list_encoding and restore_list_encoding to allow the selection of the encoding of
#                         the list that is passed into the archive command during backups and restores.
#                     26. Improved the send_email() function in order to make it more flexible and not requiring that the email text
#                         (mail body) ended with two (\n\n) when sending file attachments.
#                     27. Improved the way simplebackup works during incremental/differential backups, changed data will now be detected
#                         using the modification time and size, previously only the modification time was being used.
#                     28. Improved the way restores work with backup files, previously simplebackup would restored based on the backup format
#                         (zip, rar, tar, etc) selected on the configuration file, now it will restored each backup file based on the file type.
#                          This means that any given backup can now be formed by different backup file types (example the first backup session was
#                          done in the zip format but the next are done using the rar format. This i hope will make backups and restores are a little
#                          more flexible and easier for everyone.
#                     29. Improved the amount of information reported by simplebackup during backups and restores, it will now report the amount of
#                         data backuped/restored and what backup files where created/used. This meant several small changes mainly on the
#                         sum_all_backups() function.
#                     30. Improved the get_filename_session_metadata() function, this will now detect if the backup file is using encrypt by it's name,
#                         example home.zip is not using encryption but home.zip.sc is using encryption. Previously it was detecting this by using the
#                         encryption_passwd configuration key of the configuration file... this worked during backups but could cause problems on
#                         restores.
#                     31. Improved the way simplebackup reads the configuration file, by changing the way it detects the configuration key output_backup
#                         by adding the option to accept low/upper case chars in ftp / smtp and tape url's. Example if using ftp backups you can now write
#                         the url using: FTP://some_user:some_pass@ftp_server:8021/backup_directory or Ftp://some_user:some_pass@ftp_server:8021/backup_directory
#                         or Ftp://some_user:some_pass@ftp_server:8021/backup_directory ; etc. Please notice that case sensitive rules still aplye to the
#                         rest of the url.
#                     32. Improved the log messages and made the log data/time more "pretty".
#                     33. Improved the test file configuration option (--tconf).
#                     34. Improved the debug, now most simplebackup functions will print their exit values if running under full debug level.
#                     35. Improved the configuration file created by simplebackup (--econf parameter).
#                     36. Improved the function check_if_full_path() to deal with really small or non existing paths on windows systems.
#                     37. Improved the function get_os_type() now it should be able to detect most Windows versions.
#                     38. Improved the email backup message.
#                     39. Dropped the support for the management, history and restore history database files, has a result a massive
#                         code simplification was archived.
#                     40. Dropped the configuration keys backup_db_management_file ; local_db_history_file and local_db_restore_history_file.
#                     41. The functions read_write_history_file() and read_write_management_file() where dropped.
#                     42. Replaced the configuration keys ftp_timeout and mail_timeout with a single configuration key called network_timeout,
#                         this new configuration key can also be used (where possible) in future network operations (sftp backups, http backups,
#                         etc).
#                     43. Replaced the configuration key ftp_connect_retries with the configuration key network_connect_retries this new
#                         configuration key is used during ftp and sftp backups and can also be used (where possible) in future network operations.
#                     44. Dropped the functions get_present_session_number() ; rebuild_restore_history_file() ; list_all_backup_files() ;
#                         check_session_filename() ; test_read_rejection_file() ; get_substring().
#                     45. Dropped support for the simplebackup_rejection.txt files, this support was complicating the code, files and
#                         directory rejections should now be done using the backup_full_path_rejections configuration key.
#                     46. Changes where done a bit all over to support the support file ;), this also meant a major code simplification.
#                     47. Increased the pause seconds from 20 seconds to 30 during ftp backups, this paused occurs to prevent a ftp server
#                         overrun with connects/disconnects.
#                     48. Simplebackup will no longer connect into the ftp server (during ftp backup) if no previous backup files are to be
#                         erased.
#                     49. Renamed the function prepare_full_rejections() into prepare_perl_wildcards(), this function is to be generic and not
#                         only to be used to treat the full_rejections configuration key.
#                     50. Renamed the function ftp_connect_login() into network_connect_login() and added code to allow sftp connect login and
#                         http dav connect and login.
#                     51. Renamed the configuration key ftp_proxy into network_proxy, this is done to allow a more fast use of proxy systems
#                         in future simplebackup versions (htpp-dav proxy, ssh proxy, etc).
#                     52. Renamed the function build_present_backup_list() into build_backup_list().
#                     53. Removed the need to call the external commands cat (unix) or type (windows) when using the rar backup format.
#                     54. Degraded the tape backup support to experimental, this feature is not properly tested and i'm unable to test if further
#                         because my personal tape drive died. Users are advice against it's use on important data such has production systems.
#                     55. To make life easier for windows users renamed the simplebackup license file from copying into windows_copying.txt.
#                     56. Updated the program site and program forum url's.
#                     57. Bug fixed a problem with the rar format, if the files or directories being backuped used non english names the rar command
#                         would silently ignore them and the backup would wrongly run with success. The solution for this was to implement unicode
#                         (UTF16-LE) support, now rar gets the backup list in unicode format if running on Windows Systems. The unix rar version still
#                         does not support unicode.
#                     58. Bug fixed several problems processing ftp url's that have @ or : chars in the username or password, has part of this bug fix
#                         the functions url_test_load() ; split_part() where added. Huge thanks to jllado for reporting this.
#                     59. Bug fixed several problems processing smtp url's that have @ or : chars in the username or password, has part of this bug fix
#                         the functions url_test_load() ; split_part() where added. Huge thanks to jllado for reporting this.
#                     60. Bug fixed a problem in the function sum_backup_types(), it was not returning all the proper values.
#                     61. Bug fixed a problem, simplebackup was not doing backups of empty directories.
#                     62. Bug fixed a problem in the function check_if_full_path() that could in some rare cases report that something was a full
#                         when the string defining the path was very small.
#                     63. Bug fixed a non critical problem on the copy_file() function, that would allow simplebackup to produce warnings when it was
#                         copying files, no files where corrupted by this. This problem was (only) observed by Schwarz Thomas on a Solaris system,
#                         so huge thanks to him !.
#                     64. Bug fixed the way the full path rejections are done, configuration key [ backup_full_path_rejections ] some files could be
#                         wrongly added into the backup set.
#                     65. Bug fixed a problem when using proftp servers. This type of servers fails to support the ftp size command if not working in
#                         binary mode. Huge thanks to Nick for reporting this are presenting a patch.
#                     66. Given up on cpio format support because it has big limitations when dealing with directories.
#                     67. Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0, 1.5.1, 1.6.0,
#                         1.7.0, 1.7.1 remain 100% compatible.
#
#                    1.8.0 rc2 - 07 December 2006 - Miguel Angelo Martins Morais Leite
#                      1. Bug fixed the http dav and ftp backup support, simplebackup had a debug exit code that was wrongly exiting the program when
#                         ever http or ftp connections where made. Ups sorry ! :).
#                      2. Bug fix two links on the html documentation.
#
#                    1.8.0 - 19 December 2006 - Miguel Angelo Martins Morais Leite
#                      1. Added the --clconf argument and the clear_log() function, this allows the user to clear (erase) the log file with the option
#                         to previously do a backup of it.
#                      2. Made the --ffconf argument a bit more friendly, now simplebackup accepts upper and lower cases on the y/n question.
#                      3. New stable version of simplebackup, this is a copy of 1.8.0 rc2 with very little changes.
#                      4. Main features of this new version compared to version 1.7.1 are:
#                         . Added backup and restore support for sftp (secure ftp / ssh2) and http dav ( http://www.webdav.org, webdav protocol also know
#                           in windows has web folders).
#                         . Full restore restructuration, resulting in a huge improvement of the restore system. Restores can now restore individual
#                           files and directories, use wild cards for file select, use restore lists, etc.
#                         . Real synchronization mechanisms across different servers can now be created, even across different operating systems, example
#                           backup on Windows and restore on Linux.
#                         . Everything about the backups and restores is now stored on a single location, the support database file.
#                         . Vast number of small improvements.
#                         . Several bug fixes.
#                         . Three new cmd line arguments, [ --clconf ] to "optionally backup" clear the log file, [ --requirements ] to show the simplebackup
#                           requirements and [ --sconf ] to list the backups.
#                         . Previous backup configuration files from version 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0, 1.5.1, 1.6.0,
#                           1.7.0, 1.7.1 remain 100% compatible.
#
#                    1.8.1 - 12 January 2007 - Miguel Angelo Martins Morais Leite
#                      1. Bug fixed two bugs on the algorithm that builds the restore list. Huge thanks to Kent Xu for his very accurate bug reporting and
#                         testing patience.
#                      2. Bug fixed a restore problem, simplebackup would paused (for ever) during restores if the restored files already existed, this only
#                         occurred on the rar and 7z formats.
#                      3. Bug fixed a bug related to sftp (secure ftp) support in unix systems that was preventing it to work. Huge thanks to Kent Xu for
#                         reporting this.
#
# Future Plans (todo)...:
#   * Add a build in logic to allow backup file spanning, so that it is possible to span large backup files across different backup mediums, for
#     example across two or more dvd's.
#   * Add backup support to CD-R/CD-RW or DVD-R/DVD-RW.
#   * Create a cross-platform graphical front-end possibly using Java.
#   * Add a install/uninstall program.
#   * Implement sftp support using perl modules.
#   * Adding multi-language support, English and Portuguese for a start.
#   * Study ways to improve the restore extra feature has suggested by  Kent Xu.
#
#
# Misc future programming Notes (this could be dead wrong or be changed) :
#   * To enable backup file spannning
#         1. The backup file shall have a new added extension (similar to the rar program), example, "home.1 full monday 05-06-2006 crc3689257328.zip"
#            if spanned across 3 dvds will become "home.1 full monday 05-06-2006 crc3689257328.zip.000001", 
#            "home.1 full monday 05-06-2006 crc3689257328.zip.000002" and "home.1 full monday 05-06-2006 crc3689257328.zip.000003".
#         2. The max number of spanned files will be 999999.
#         3. To be more easy for the user the first spanned files will be have the extension 000001 and not 000000.
#         4. We should maintain the general logic in the support file, and on the field reservated for the backup file name should be fill up with the
#            names of all spanned backup separated by the ">" char, example
#            "home.1 full monday 05-06-2006 crc3689257328.zip.000001>home.1 full monday 05-06-2006 crc3689257328.zip.000002>home.1 full monday 05-06-2006 crc3689257328.zip.000003"
#         5. This means that the support file has no details (size, etc) of each of the individual spanned files, but this is irrelevant.
#         6. During backups the data shall only be written into the backup destination (ftp, cdrom, etc) after all spanned files where generated with sucess, if not all
#            should be erased.
#         7. During backup support file should only be written when simplebackup has backuped with sucess all spanned files.
#         8. There should be a parameter to ask the user to change medium (if required), but notice that in some kind of backups it should't be necessario to ask the user
#            example Amazon S3 service has a 5 Gb limit per file... but there is no need to ask the user to for to change his S3... medium service ;)
#         9. Restores should only start after the spanned files are put togerther again on a single file, this means by nature the spanned files must be joined on the
#            temporary dir
#
#
#Perl libraries forcefully added to allow the perl2exe program to correctly compile this program with Unicode support
#perl2exe_include PerlIO
#perl2exe_include utf8
#perl2exe_include Encode::Unicode
#
#
#Tell perl2exe (Windows Perl Compiler) to include some external executables
#This files will be automaticly uncompressed and used by simplebackup when needed.
#To add more executables add a similar entry then adapt and use the get_external_command() function.
#
#The info-zip (http://www.info-zip.org) zip.exe
#perl2exe_bundle ".\zip.exe"
#
#The info-zip (http://www.info-zip.org) "unzip.exe" file (zip format uncompressor).
#perl2exe_bundle ".\unzip.exe"
#
#The putty (http://www.chiark.greenend.org.uk/~sgtatham/putty/download.html) "psftp.exe" file (secure ftp) transfer.
#perl2exe_bundle ".\psftp.exe"
#
#
##########################
# Modules
##########################
use strict; # implement a more strict language
use Sys::Hostname; # to enable the possibility to get the machine hostname
use Fcntl qw(:DEFAULT :flock);  # file locking for the logs and other written files


##########################
# Global Variables
##########################
my $script_version = "1.8.1";
my $script_last_update = "12 January 2007";
my $script_license = "GNU GENERAL PUBLIC LICENSE Version 2, June 1991.";
my $script_authors = "Miguel Angelo Martins Morais Leite";
my $script_email = "migas.miguel\@gmail.com";
my $script_site = "http://migas-sbackup.sourceforge.net";
my $script_forum = "http://sourceforge.net/projects/migas-sbackup";
my $crypting_algorithm_version = "SimpleCrypt 1.0.0"; # current SimpleCrypt generated version
my %global_config = (    # script configuration hash
    "configuration_file"        => "",    # Path into the configuration file, ex: /some/path/a_file.conf
    "configuration_file_name"   => "",    # Configuration file name, ex: a_file.conf
    "debug_level"               => "",    # Simplebackup debug level valid values are: none, half, full
    "host_os"                   => "",    # Operating system running the script
    "host_null_device"          => "",    # Operating system null device (stderr)
    "host_stdout_null_device"   => "",    # Operating system null device (stdout)
    "host_file_separator"       => "",    # Operating system file separator,   \ for windows and / for unix
    "backup_format"             => "",    # Backup type: rar, 7z, zip, tar.bz2, tar.gz, tar.Z, tar
    "backup_format_details"     => "",    # Extra information that might be used to know what archive tool to use (example distinting a simple tar utility from the gnu tar version)
    "backup_compression_ratio"  => "",    # Chose backup compression ratio:
                                          #   none = no compression = 0 (rar, info-zip) or 1 (gzip,
                                          #   bzip2)
                                          #   minimal = minimal compression = 1
                                          #   average = average type of compression = 3 (rar) or
                                          #             6 (info-zip,gzip,bzip2)
                                          #   maximal = maximal compression = 5 (rar) or
                                          #   9 (info-zip, gzip, bzip2)
                                          # Note tar and compress formats are not affected by the
                                          # argument
    "backup_real_ratio"         => "",    # The actual number to be passed into the compressor,
                                          # 0 up to 5 or 9
    "text_note"                 => "",    # A user text that can be included latter on backup logs, mails etc
    "backup_mode"               => "",    # Type of backup : full, incremental or differental, comes
                                          # from the configuration file
    "build_backup_list"         => "",    # If build_backup_list() will be used to build the
                                          # backup list, values yes/no.
    "backup_real_mode"          => "",    # Actual type of backup used : full, incremental or differental,
                                          # for example it can be a full backup even in incremental or
                                          # differental backups if we have arrived at the full backup day
    "full_backup_day"           => "",    # When will the full backup occured.
    "backup_full_path_rejections" => "",  # List of full path files/directories and wild cards to be rejected
    "backup_extension_rejections" => "",  # List of types of backups that are suppose to be rejected
                                          # on backups... this is given in extensions, example
                                          # txt,zip,mp3
    "backup_filenames_rejections"  => "", # List of files to reject, example my_boss.jpg,secret.doc
    "backup_file_size_limit"       => "", # Limit the maximal file size to backup (in kbytes)
    "backup_file_size_limit_bytes" => "", # Limit the maximal file size to backup (in bytes)
    "backup_working"            => "",    # Where is the backup file is going, configured on the
                                          # read_config() function.
                                          #  local file system = for local file system directory, this
                                          #                      also included windows mounted drives
                                          #                      and unix mounted directories (devices,
                                          #                      nfs, samba, etc).
                                          #                ftp = if the backup is going into a remote
                                          #                      ftp server.
                                          #                scp = if the backup is going into a remote
                                          #                      server using scp (secure copy)
    "ftp_server"                => "",    # Remote ftp server.
    "ftp_debug_level"           => "",    # FTP debug level, none/full, default is none
    "ftp_debug_level_real"      => "",    # The actual parameter that is passed into the ftp module
    "ftp_server_port"           => "",    # Remote ftp server port number.
    "ftp_username"              => "",    # FTP Username.
    "ftp_password"              => "",    # FTP Password.
    "ftp_directory"             => "",    # FTP directory where we will upload the backup file.
    "ftp_passive_mode"          => "",    # FTP Passive mode [ 0 ; 1 ].
    "ftp_passive_mode_real"     => "",    # The real parameter passed into the Net:FTP, here is
                                          # only [ 0 ; 1 ].
    "sftp_server"               => "",    # Remote ftp server.
    "sftp_debug_level"          => "",    # SFTP debug level, none/full, default is none
    "sftp_transport"            => "",    # Type of sftp that will be used: net::ssh2 (for the Net::SSH2 perl module) ;
                                          # putty (for the psftp putty program) or auto that will be autodetected by simplebackup
    "psftp_private_key_file"    => "",    # Path into a putty psftp private key file, this might not be used at all
    "sftp_debug_level_real"     => "",    # The actual parameter that is passed into the ftp module
    "sftp_server_port"          => "",    # Remote ftp server port number.
    "sftp_username"             => "",    # SFTP Username.
    "sftp_password"             => "",    # SFTP Password.
    "sftp_directory"            => "",    # SFTP directory where we will upload the backup file.
    "dav_server"                => "",    # Remote dav server.
    "dav_url"                   => "",    # Rebuild url actualy used by the HTTP::DAV with just the http url + server name + port
    "dav_url_full"              => "",    # Rebuild url actualy used by the HTTP::DAV for the connection/disconnection, http url + server name + port + path to directory
    "dav_debug_level"           => "",    # Dav debug level, none/full, default is none
    "dav_debug_level_real"      => "",    # Dav actual parameter that is passed into the ftp module
    "dav_server_port"           => "",    # Remote dav server port number.
    "dav_username"              => "",    # dav Username.
    "dav_password"              => "",    # dav Password
    "dav_directory"             => "",    # dav directory where we will upload the backup file.
    "network_timeout"           => "",    # Network timeout value (default 480) used during som network operations
                                          # ftp, smtp
    "network_connect_retries"   => "",    # SFTP/FTP/DAV retries that simplebackup will use during connect
    "network_proxy"             => "",    # FTP Proxy, must work in open mode.
    "tape_device"               => "",    # The tape device, example /dev/tp0
    "tape_command"              => "",    # The actual command that places the stuff on tar, default is tar
    "tape_before_backup"        => "",    # Command to execute before running the command that places
                                          # data on the tape, example mt -t /dev/tp0 rew
    "tape_after_backup"         => "",    # Command to execute after running the command that places
                                          # data on the tape, example mt -t /dev/tp0 offline
    "backup_mail_type"              => "",    # The Backup  backup server, empty for no email backup, smtp for smtp mail server type
                                              # other backup server types (example imap) are not yet supported
    "backup_mail_server"            => "",    # Backup Mail server name/address used during email backups.
    "backup_mail_debug_level"       => "",    # Backup Mail debug level, none/full, default is none
    "backup_mail_debug_level_real"  => "",    # The actual parameter that is passed into the mail module (0/1)
    "backup_mail_port"              => "",    # Backup Mail server port (default is 25)
    "backup_mail_username"          => "",    # Backup Mail username (might be required to smtp login).
    "backup_mail_password"          => "",    # Backup Mail password, if it's not empty simplebackup will attempt
                                              # to login into the mail server.
    "backup_mail_from_address"      => "",    # E-Mail address from,    where the backup comes from.
    "backup_mail_to_addresses"      => "",    # E-Mail address(es) to,  where the backup is/are going.
    "compressed_file_size_limit"    => "",    # Limit of the size (in kbytes) of the backup file(s) to atach into the email
    "compressed_file_size_limit_bytes"  => "",    # Limit of the size (in bytes) of the backup file(s) to atach into the email
    "backup_mail_attachment_method"     => "",    # How simplebackup will backup multiple backup files, attach all or individually
    "mail_type"                 => "",    # The backup server, empty for no email reporting, smtp for smtp mail server type
                                          # other backup server types (example imap) are not yet supported
    "mail_server"               => "",    # Mail server name/address.
    "mail_debug_level"          => "",    # Mail debug level, none/full, default is none
    "mail_debug_level_real"     => "",    # The actual parameter that is passed into the mail module (0/1)
    "mail_port"                 => "",    # Mail server port (default is 25)
    "mail_username"             => "",    # Mail username (might be required to smtp login).
    "mail_password"             => "",    # Mail password, if it's not empty simplebackup will attempt
                                          # to login into the mail server.
    "mail_from_address"         => "",    # E-Mail address from,    where the report comes from.
    "mail_to_addresses"         => "",    # E-Mail address(es) to,  where the report is/are going.
    "encryption_passwd"         => "",    # Encryption password (optional) used to encrypt/decrypt the backup files
    "encryption_crypt"          => "",    # Number of times that each byte/bit is encrypted/decrypted, must be a integer number over zero
    "encryption_level"          => "",    # Encryption level (byte/bit), the encryption algorithm can act on every data byte or on every data bit
                                          # bit level is safer but slower
    "encryption_file_read_size" => "",    # The amount of bytes read each time, from the file that is being encrypted/decrypted
    "input_backup"              => "",    # The list of files and directories to backup
    "output_backup"             => "",    # Where the final compress file will be placed
    "temporary_dir"             => "",    # Where the data shall be compress, this is a temporary
                                          # destiny for the compressed file
    "keep_last_n_files"         => "",    # Number of the last backup files that shall be keep
                                          # 5 for example the script shall erase all compress backup
                                          # file except the last 5 sessions + the current backup
                                          # session
                                          # Notes : -1  -> all backup files shall be keep
                                          #          0  -> only the present backup file shall be keep
                                          #         If the backups are working in incremental or
                                          #         differential modes this value is automanaged.
    "run_before_backup"         => "",    # Optional script/batch file/command to run before backup
    "run_backup_on_failure_run_before_backup" => "", # Run backup even if the command defined in run_before_backup
                                                     # fails, values (yes / no)
    "run_after_backup"          => "",    # Optional script/batch file/command to run after backup
    "on_failure_run_after_backup" => "",  # Run the run_after_backup command even with a backup failure (yes / no)
    "pass_log_to_external_cmd"  => "",    # Pass the log into a external program via stdin... similar to
                                          # cat log.txt | my_command
    "log_file"                  => "",    # Where the log file shall live or none for no log file
    "hostname"                  => "",    # Machine name where simplebackup is running, replaced by "unavailable"
                                          # if the hostname cannot be obtained
    "hostname_on_backup_files"  => "",    # If were are going to include the hostname on each backup file
    "username"                  => "",    # Username running the backup/restored,  replaced by "unavailable" if
                                          # hostname cannot be optained
    "username_on_backup_files"  => "",    # If were are going to include the username on each backup file
    "backup_support_file_copy1" => "",    # Database suport file that containts the backup files managed ; the
                                          # managed data (for incremental/differencial backups) and the 
                                          # list of all data available, this is the copy one of this file
    "backup_support_file_copy2" => "",    # Database suport file that containts the backup files managed ; the
                                          # managed data (for incremental/differencial backups) and the 
                                          # list of all data available, this is the copy two of this file
    "backup_support_file_copy3" => "",    # Database suport file that containts the backup files managed ; the
                                          # managed data (for incremental/differencial backups) and the 
                                          # list of all data available, this is the copy two of this file
    "run_before_restore"        => "",    # Optional script/batch file/command to run before restore, it
                                          # can be a copy of run_before_backup if the "auto" parameter was used.
    "run_restore_on_failure_run_before_restore" => "", # Run restore even if the command defined in run_before_restore
                                                       # fails, values (yes / no)
    "run_after_restore"         => "",    # Optional script/batch file/command to run after restore, it
                                          # can be a copy of run_after_backup if the "auto" parameter was used.
    "on_failure_run_after_restore" => "", # Run the run_after_restore command even with a restore failure (yes / no)
    "backup_list_on_log"  => "",          # Add the list of files and directories backuped into the log (yes / no)
    "restore_list_on_log" => "",          # Add the list of files and directories restored into the log (yes / no)
    "screen_height" => "",                # Number of lines that the console/terminal has... (default value 25) this is used
                                          # by the restore menu (in manual restore mode)
    "backup_list_encoding" => "",         # what is the encoding used when passing the backup list into the archive command
                                          # valid values:  ascii ; utf-8 ; utf16-le ; auto
    "restore_list_encoding" => "",        # what is the encoding used when passing the restore list into the archive command
                                          # valid values:  ascii ; utf-8 ; utf16-le ; auto

);


##########################
# Functions
##########################


#
# Show a small command line help or the full help or the requirements
# Will return: 0
# Explain: 0 is success
sub show_commands {

    my $my_script_version = $_[0]; # script version parameter
    my $my_script_last_update = $_[1]; # script lastupdate version
    my $my_script_license = $_[2]; # script license
    my $my_script_authors = $_[3]; # script authors
    my $my_script_email = $_[4]; # script email
    my $my_script_site = $_[5]; # script site
    my $my_script_forum = $_[6]; # script forum
    my $my_option = $_[7]; # what commands to show

    if ( defined $my_option and $my_option eq "--help" ) { # if we want to show the full help
    print <<EOF;

  Name ...: simplebackup.pl v$my_script_version ($my_script_last_update)
  License : $script_license
  Author .: $my_script_authors
  E-Mail .: $my_script_email
  Forum ..: $my_script_forum
  Site ...: $my_script_site

  Do a backup of directories and files by compressing each backup directory
  or file listed on the backup list into a separated archive file and then
  placing each one into some other path, machine or tape device (unix only),
  this also includes ftp, sftp, http web dav servers and email accounts
  (email backups).
  Supported formats: rar, 7z, zip, tar, tar+compress, tar+gzip, tar+bzip2.

  Create/Edit a configuration file :
    Unix > simplebackup.pl --econf full/path/config_file.conf
    Win .> perl -w simplebackup.pl --econf full\\path\\config_file.conf

  Testing Configuration :
    Unix > simplebackup.pl --tconf full/path/config_file.conf
    Win .> perl -w simplebackup.pl --tconf full\\path\\config_file.conf

  Backup Execution :
    Unix > simplebackup.pl --conf full/path/config_file.conf
    Win .> perl -w simplebackup.pl --conf full\\path\\config_file.conf

  See the log file (if it exists) :
    Unix > simplebackup.pl --lconf full/path/config_file.conf
    Win .> perl -w simplebackup.pl --lconf full\\path\\config_file.conf

  Clear the log file data (with the possibility of a optional backup) :
    Unix > simplebackup.pl --clconf full/path/config_file.conf
    Win .> perl -w simplebackup.pl --clconf full\\path\\config_file.conf

  List the backup sessions or the details of a backup session :
    Unix > simplebackup.pl --sconf full/path/config_file.conf *1
    Win .> perl -w simplebackup.pl --sconf full\\path\\config_file.conf *1
    *1 alternative option that can be defined :
      --session session_number : list the backup files and directories
                                 contained inside a given backup session.

  Force a full backup (under differential/incremental backups) :
    Unix > simplebackup.pl --ffconf full/path/config_file.conf
    Win .> perl -w simplebackup.pl --ffconf full\\path\\config_file.conf

  Listing the simplebackup requirements :
    Unix > simplebackup.pl --requirements
    Win .> perl -w simplebackup.pl --requirements

  Restore Execution :
    Unix > simplebackup.pl --rconf full/path/config_file.conf *2
    Win .> perl -w simplebackup.pl --rconf full\\path\\config_file.conf *2
    *2 other restore options that can be defined :
     --rlist_file list.txt
        text file that contains a list of what to restore and optionally
        where to restore, check the documentation for more details.
      --to some_path
        default path where the files and directories will be restored, this
        can be overwritten by using options in restore menu or by the
        restore list file (--rlist_file).
      --session some_session_number
        session number to take has a reference during restores, if this is
        used only files and directories existing during that backup session
        will be restored.
        If defined has 0 (zero) simplebackup will match up against the most
        recent backup session.
      --erase_extra yes/no
        erase or not files and directories not found on the defined session
        number (--session), default value is no (except in autosync mode).
      --mode manual/auto/autosync
        how simplebackup will restore,
        in [ manual ] a menu will be presented and questions will be made,
        this is the default mode;
        in [ auto ] the restore starts and no questions are made;
        in [ autosync ] the restore starts and no questions are made but only
        restores the backup files and directories that where never restored,
        it will also automatically erase files and directories not found on
        the last backup session (similar to using --session 0 --erase_extra
        yes), notice that this can be changed by using --erase_extra no.
        This allows simplebackup to create syncing mechanisms across
        different systems.

  Print the simplebackup version :
    Unix > simplebackup.pl --version
    Win .> perl -w simplebackup.pl --version

  To see this help use :
    Unix > simplebackup.pl --help
    Win .> perl -w simplebackup.pl --help

  Notes :
    1 > Don't forget to edit and configure your backup configuration files.
    2 > This program was designed to automate, you easily use it to set up
        automatic backups using Unix Cron, Windows Task Scheduler, etc.
    3 > If you are using the Windows compiled version (simplebackup.exe),
        replace [ perl -w simplebackup.pl ] with [ simplebackup ].

   The crc32 algorithm used is based on the Swissknife library (crc32.pm
   module) from Wolfgang Fleischmann wfl\@ebi.ac.uk

   The email file attachment code is based on the SendEmail program,
   http://caspian.dotconf.net/menu/Software/SendEmail/ by Brandon
   Zehm caspian\@dotconf.net

   The Microsoft Windows compiled version includes the putty (psftp.exe) and
   the info-zip (zip.exe and unzip.exe) programs.

EOF
    }
    elsif ( defined $my_option and $my_option eq "--requirements" ) { # if we want to show the full help
    print <<EOF;

  The simplebackup needs some external software to function properly.
  Not everything is needed at once, it all depends on what kind of backups
  you need to do. This list aims at giving you a list of what you need and
  for what.

  If using the perl version [ simplebackup.pl ] *5 :

    HTTP::DAV ..> Perl Module for http backups.
    LibNet .....> Perl Module for ftp backups, email backups and email
                  reporting.
    Authen-SASL > Perl module required if your smtp mail server needs
                  authentication.
    Expect .....> Perl Module for sftp backups (only required if using the
                  openssh sftp program, usually on Unix systems).

  If using the Windows compiled version [ simplebackup.exe ] :
    < no perl module is required everything is build in >
    < zip backup/restore support is build in >
    < secure ftp is build in >

  Shared requirements.
    > rar / Winrar 3.6 or over installed if doing backups/restores using
      the rar format. *1
    > 7-zip (7z) 4.42 or over installed if doing backups/restores using the
      7z format. *1
    > info-zip zip and unzip installed if doing backups/restores using the
      zip format. *1 *3
    > tar installed if doing backups/restores using the tar, tar+compress
      (tar.Z), tar+gzip (tar.gz), tar+bzip2 (tar.bz2). The tar command must
      support reading a list file (-T or -I or -L argument). *1 ; *2
    > compress installed if doing backups/restores if using the
       tar+compress (tar.Z) format. *1 *2
    > gzip installed if doing backups/restores if using the tar+bzip
      (tar.gz) format. *1 *2
    > bzip2 installed if doing backups/restores if using the tar+bzip2
      (tar.bz2) format. *1 *2
    > Open ssh sftp program if doing backups/restores using sftp
      (secure ftp) into a ssh server using the sftp transport,
      configuration key [ sftp_transport = sftp ]. *1 *2
    > Putty sftp program if doing backups/restores using sftp (secure ftp)
      into a ssh server using the psftp transport, configuration key
      [ sftp_transport = psftp ]. *1 *3
    > cat command for use during all backups/restores (except rar and 7z)
      on Unix systems. *1 *4
    > type command for use during all backups/restores (except rar and 7z)
      on Windows systems. *1 *4
    > clear command to clear the screen on the restore menu on Unix
      systems. *1 *4
    > cls command to clear the screen on the restore menu. on Windows
      systems. *1 *4

    *1 All programs used must be available on the system PATH variable.
    *2 Usually only available on Unix systems.
    *3 Not needed if running the windows compiled version (simplebackup.exe)
    *4 This commands are standard on all unix and windows systems.
    *5 The use of Perl 5.8 or over is recommended.

    Most requirements are tested during the configuration file test phase
    (--tconf) argument.

EOF
    }
    else { # partial help
    print <<EOF;

  simplebackup.pl v$my_script_version ($my_script_last_update)

  Creating/Editing configuration files :
    --econf config_file.conf
  Testing Configuration :
    --tconf config_file.conf
  Backup Execution :
    --conf config_file.conf
  See the log file (if it exists) :
    --lconf config_file.conf
  Clear the log file data (with the possibility of a optional backup) :
    --clconf config_file.conf
  List the backup sessions or the details of a backup session :
    --sconf config_file.conf
    --sconf config_file.conf --session some_session_number
  Force a full backup (under differential/incremental backups) :
    --ffconf config_file.conf
  Listing the simplebackup requirements :
    --requirements
  Restore Execution :
    --rconf config_file.conf (+ optional restore options)
  Print the simplebackup version :
    --version

  To see the full help use :
    --help

EOF
    }

    return 0; # always return success
}


#
# Check if a email is valid
# Tests aplied: there must not be space chars on the mail, there must be only one @ char, there must be a mail user
#               there must be a mail domain and a domain prefix
#               optionally it can also restrict a email into a given list of domain prefixes (com,pt,org,etc)
# Will Return 0 ; 1
# 0 email is valid ; 1 email is not valid
sub check_email {

    my $email = $_[0]; # email to test
    my $global_config_p = $_[1]; # configuration pointer
    print "Running the check_email() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $alllowed_domain_prefixes = $_[2]; # optional value where you can say what email prefixes (.pt .com .org etc) are allowed 
                                          # the list should be passed without the . char and separated by the , char example (pt,com,org,es)

    my $error_flag = 1; # by default the email is invalid

    $email =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
    $email =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.

    if ( length($email) >= 5 and ($email =~ tr/@//) == 1 and ($email =~ tr/ //) == 0 ) { # email must have at least 5 chars ( a@a.c) and one @ char and no SPACE CHARS

        my ( $mail_user, $mail_domain ) = split (/@/, $email );
        # find the last occurence of .
        my $mail_domain_pref_pos = rindex($mail_domain,".");
        my $mail_domain_prefix = ""; # .pt .org etc
        if ( $mail_domain_pref_pos >= 0 ) {
            $mail_domain_prefix = substr($mail_domain,$mail_domain_pref_pos+1,length($mail_domain)); # get the domain prefix
        }

        # if mail user exists (exanmple miguel) and if the mail domain exists (mail.pt) and if the mail domain prefix exists (pt)
        if ( defined $mail_user and defined $mail_domain and defined $mail_domain_prefix and length($mail_user) > 0 and length($mail_domain) > 0 and length($mail_domain_prefix) > 0 ) {
            my $allowed_prefix = "";
            if ( defined $alllowed_domain_prefixes and length($alllowed_domain_prefixes) > 0 ) { # check the allowed prefixed if required (pt com org etc)
                my @alllowed_domain_prefixes = split(/,/, $alllowed_domain_prefixes);
                $allowed_prefix = "no";
                foreach my $allowed_prefix_record (@alllowed_domain_prefixes) {
                    if ( $mail_domain_prefix eq $allowed_prefix_record ) {
                        $allowed_prefix = "yes";
                        last;
                    }
                }
            }
            if ( $allowed_prefix ne "no" ) { # check if the prefix is not allowed
                $error_flag = 0; # mail is valid
            }
        }
    }

    print "Function check_email() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Receive any string and split it and return what we want (last split part, first split part
# a specicil part)
# The string separated chars supported are: @ : space_char \ / < >
# Will return: a string or undef
# Explain: string is the string part we want ; undef is failure string part not found
sub split_part {

    my $input_string = $_[0]; # string to split
    my $string_split = $_[1]; # the char that divides the string
    my $want = $_[2]; # what we want... last (the last split part), first (the first split part; any_integer (a given part number)
    my $global_config_p = $_[3]; # configuration pointer
    print "Running the split_part() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it

    my @split_array;
    my $split_part; # part to split

    # break the string into a array
    switch: {
        # split with @
        $string_split eq "@" && do {
            @split_array = split(/\@/, $input_string);
        };
         # split with :
        $string_split eq ":" && do {
            @split_array = split(/:/, $input_string);
        };
        # split with space char
        $string_split eq " " && do {
            @split_array = split(/ /, $input_string); 
        };
        # split with / char
        $string_split eq "/" && do {
            @split_array = split(/\//, $input_string);
        };
        $string_split eq "\\" && do {
            @split_array = split(/\\/, $input_string);
        };
        $string_split eq "<" && do {
            @split_array = split(/</, $input_string);
        };
        $string_split eq ">" && do {
            @split_array = split(/>/, $input_string);
        };
    }

    # now select what we want
    switch: {
        # I want first record
        lc($want) eq "first" && do {
            $split_part = $split_array[0];
        };
        # I want the last record
        lc($want) eq "last" && do {
            my $split_array_size = scalar(@split_array);
            $split_part = $split_array[$split_array_size-1];
        };
        lc($want) ne "first" and lc($want) ne "last" && do {
            $split_part = $split_array[$want];
        };
    }

    print "Function split_part() exit value is [ $split_part ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $split_part;
}


# Receive a smtp url test it and if all goes ok, load up several variables (pointers) with the values
# (user, password, server, port, from user and to users) it also does a very basic test to see if the email
# addresses are valid by using the function check_email().
# Will return: 0 ; 1 ; 2 ; 3 ; 4 ; 5 ; 6
# Explain: 0 is sucess ftp url is correct ; 1 sucess but a invalid from email address was detected ; 
#          2 sucess but one or more invalid to mail addressses where detected ; 3 failure undefined server ;
#          4 failure - invalid port ; 5 failure empty from email address ; 6 failure empty to email addresses
#          7 failure generical invalid smtp url
sub smtp_url_test_load {

    my $smtp_url = $_[0]; # url to test
    my $smtp_username_p = $_[1]; # pointer into the variable that defines the username used on the connection (will be cleared if any error occures)
    my $smtp_password_p = $_[2]; # pointer into the variable that defines the password used on the connection (will be cleared if any error occures)
    my $smtp_server_p = $_[3]; # pointer into the variable that defines the server (will be cleared if any error occures)
    my $smtp_server_port_p = $_[4]; # pointer into the variable that defines the server port (will be cleared if any error occures)
    my $smtp_from_p = $_[5]; # pointer into the variable that defines the from mail address (will be cleared if any error occures)
    my $smtp_to_cc_p = $_[6]; # pointer into the variable that defines the to mail addresses (cc mode), (will be cleared if any error occures)
    my $global_config_p = $_[7]; # configuration pointer
    print "Running the smtp_url_test_load() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it

    my $error_flag = 0; # to mark errors

    # first remove the smtp:// from the url
    if ( lc(substr($smtp_url,0,7)) eq "smtp://" ) { # smtp url
        $smtp_url =~ s/^smtp:\/\///;
        $$smtp_server_port_p = 25; # default smtp port is 25
    }
    else {
        $error_flag = 7; # mark error badly defined url
    }

    # first get the "to" mail addresses
    $$smtp_to_cc_p = substr($smtp_url, (index($smtp_url,"mail_to_addresses=")+length("mail_to_addresses=")), length($smtp_url));

    # remove the to mail addresses from the url (similar to mail_to_addresses=email_address1@email_server, email_address2@email_server
    $smtp_url =~ s/mail_to_addresses=$$smtp_to_cc_p$//;

    # first get the "from" mail address
    $$smtp_from_p = substr($smtp_url, (index($smtp_url,"mail_from_address=")+length("mail_from_address=")), length($smtp_url));

    # remove the to mail addresses from the url (similar to mail_to_addresses=email_address1@email_server, email_address2@email_server
    $smtp_url =~ s/mail_from_address=$$smtp_from_p$//;

    # remove the extra & char from the mail to address
    $$smtp_from_p =~ s/&$//;

    # remove the extra ? char from the url that remains
    $smtp_url =~ s/\?$//;

    my $smtp_server_port;
    # now detect if we are using username/password... SASL smtp authentication
    if ( ($smtp_url =~ tr/@//) >= 1 ) {
        $smtp_server_port = split_part($smtp_url, "@", "last"); # get the server name and port (if configured)
        # remove the smtp server name and port from the url
        $smtp_url =~ s/\@$smtp_server_port$//;

        # get the smtp user
        $$smtp_username_p = split_part($smtp_url, ":", "first");

        # get the smtp password
        $$smtp_password_p = $smtp_url;
        # remove the smtp user from the password
        $$smtp_password_p =~ s/^$$smtp_username_p://;
    }
    else { # there is no username and no password
        $smtp_server_port = $smtp_url; # servername and port (optinal) are on the url
        $$smtp_username_p = "";
        $$smtp_password_p = ""; 
    }

    # now break up the smtp server name and port (if required)
    if ( ($smtp_server_port =~ tr/://) >= 1 ) { # we have a : char on the server name then we have a port assign by user
        # get the smtp port
        $$smtp_server_port_p = split_part($smtp_server_port, ":", "last");

        # get the smtp server name
        $$smtp_server_p = $smtp_server_port;
        # remove the smtp port from the server name
        $$smtp_server_p =~ s/:$$smtp_server_port_p$//;
    }
    else { # there is no user assign smtp port
        $$smtp_server_p = $smtp_server_port;
    }

    # now clean up spaces that might exist bettwen mail addresses
    $$smtp_from_p = remove_excess_spaces($$smtp_from_p, "," ) if ( defined $$smtp_from_p and $$smtp_from_p ne "" );
    $$smtp_to_cc_p = remove_excess_spaces($$smtp_to_cc_p, "," ) if ( defined $$smtp_to_cc_p and $$smtp_to_cc_p ne "" );

    if ( $error_flag == 0 ) { # continue if no error occured
        # now validate the smtp connection values
        $error_flag = 3 if ( $error_flag == 0 and (! defined $$smtp_server_p or $$smtp_server_p eq "") );
        $error_flag = 4 if ( $error_flag == 0 and (! defined $$smtp_server_port_p or !($$smtp_server_port_p =~ /^\d+$/) or $$smtp_server_port_p <= 0 ) );
        $error_flag = 5 if ( $error_flag == 0 and (! defined $$smtp_from_p or $$smtp_from_p eq "") );
        $error_flag = 6 if ( $error_flag == 0 and (! defined $$smtp_to_cc_p or $$smtp_to_cc_p eq "") );
    }

    # mark invalid from mail address,if no previous error occured
    $error_flag = 1 if ( $error_flag == 0 and check_email($$smtp_from_p, $global_config_p) != 0 ); # mark invalid from mail address
    if ( $error_flag == 0 ) { # continue if no error occured, now testing the to mail addresses
        my @smtp_to_cc_array = split (/,/, $$smtp_from_p);
        foreach my $smtp_email ( @smtp_to_cc_array ) {
            $error_flag = 1 if ( check_email($smtp_email, $global_config_p) != 0 );
            last if ( $error_flag != 0 );
        }
    }

    if ( $error_flag >= 3 ) { # if a error was found reset all smtp pointer values to empty
        $$smtp_username_p = "";
        $$smtp_password_p = "";
        $$smtp_server_p = "";
        $$smtp_server_port_p = "";
        $$smtp_from_p = "";
        $$smtp_to_cc_p = "";
    }

    print "Function smtp_url_test_load() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    return $error_flag;
}


#
# Receive a ftp, sftp or webdav url or encrypted webdav url test it and if all goes ok, load up several variables (pointers)
# with the values (user, password, server, port, etc)
# Will return: 0 ; 1 ; 2 ; 3 ; 4 ; 5 ; 6 ; 7
# Explain: 0 is sucess url is correct ; 1 failure - badly defined url ; 2 failure - empty username ;
#          3 failure - empy password ; 4 failure - undefined server ; 5 failure - invalid port
#          ; 6 failure empty directory ; 7 failure directory not defined has a unix path
sub url_test_load {

    my $ftp_sftp_dav_url = $_[0]; # url to test
    my $ftp_sftp_dav_username_p = $_[1]; # pointer into the variable that defines the username used on the connection (will be cleared if any error occures)
    my $ftp_sftp_dav_password_p = $_[2]; # pointer into the variable that defines the password used on the connection (will be cleared if any error occures)
    my $ftp_sftp_dav_server_p = $_[3]; # pointer into the variable that defines the server (will be cleared if any error occures)
    my $ftp_sftp_dav_server_port_p = $_[4]; # pointer into the variable that defines the server port (will be cleared if any error occures)
    my $ftp_sftp_dav_directory_p = $_[5]; # pointer into the variable that defines the server (will be cleared if any error occures)
    my $global_config_p = $_[6]; # configuration pointer
    print "Running the url_test_load() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it

    my $error_flag = 0; # to mark errors

    # first remove the ftp:// from the ftp url or the sftp from the sftp url
    if ( lc(substr($ftp_sftp_dav_url,0,6)) eq "ftp://" ) { # ftp url
        $ftp_sftp_dav_url =~ s/^ftp:\/\///; # remove the url protocol
        $$ftp_sftp_dav_server_port_p = 21; # default ftp port is 21
    }
    elsif ( lc(substr($ftp_sftp_dav_url,0,7)) eq "sftp://" ) { # sftp url (secure ftp)
        $ftp_sftp_dav_url =~ s/^sftp:\/\///; # remove the url protocol
        $$ftp_sftp_dav_server_port_p = 22; # default sftp port is 22
    }
    elsif ( lc(substr($ftp_sftp_dav_url,0,7)) eq "http://" ) { # http/dav url
        $ftp_sftp_dav_url =~ s/^http:\/\///; # remove the url protocol
        $$ftp_sftp_dav_server_port_p = 80; # default http port is 80
    }
    elsif ( lc(substr($ftp_sftp_dav_url,0,8)) eq "https://" ) { # https/dav url
        $ftp_sftp_dav_url =~ s/^https:\/\///; # remove the url protocol
        $$ftp_sftp_dav_server_port_p = 403; # default http port is 403
    }
    else {
        $error_flag = 1; # mark error badly defined url
    }

    # security checks... must have at least one : char ; one @ char and one / char
    if ( ($ftp_sftp_dav_url =~ tr/://) == 0 or ($ftp_sftp_dav_url =~ tr/@//) == 0 or ($ftp_sftp_dav_url =~ tr/\///) == 0) {
        $error_flag = 1; # mark error badly defined url
    }

    if ( $error_flag == 0 ) { # continue if no error occured

        #extract the server name, port and directory
        my $ftp_sftp_server_port_dir = "";
        $ftp_sftp_server_port_dir = split_part($ftp_sftp_dav_url, "@", "last") if ( $ftp_sftp_dav_url );

        # remove the ftp/sftp server port and directory from the url
        $ftp_sftp_dav_url =~ s/\@$ftp_sftp_server_port_dir$// if ( $ftp_sftp_server_port_dir );

        # get the ftp/sftp user
        $$ftp_sftp_dav_username_p = split_part($ftp_sftp_dav_url, ":", "first") if ( $ftp_sftp_dav_url );

        # remove the ftp/sftp user from the url
        $ftp_sftp_dav_url =~ s/^$$ftp_sftp_dav_username_p:// if ( $ftp_sftp_dav_username_p );

        # what remains is the ftp/sftp password
        $$ftp_sftp_dav_password_p = $ftp_sftp_dav_url if ( $ftp_sftp_dav_url );

        # get the ftp/sftp server name and port
        my $ftp_server_and_port = "";
        $ftp_server_and_port = split_part($ftp_sftp_server_port_dir, "/", "first") if ( $ftp_sftp_server_port_dir );

        # get the ftp/sftp directory
        $$ftp_sftp_dav_directory_p = $ftp_sftp_server_port_dir;
        # remove the ftp/sftp server name and port from the directory path
        $$ftp_sftp_dav_directory_p =~ s/^$ftp_server_and_port// if ( $ftp_server_and_port );
        # now break up the ftp port
        if ( ($ftp_sftp_server_port_dir =~ tr/://) >= 1 ) { # we have a : char, we have a port assign by user
            # get the ftp/sftp port
            $$ftp_sftp_dav_server_port_p = split_part($ftp_server_and_port, ":", "last");

            # get the ftp/sftp server name
            $$ftp_sftp_dav_server_p = $ftp_server_and_port;
            # remove the ftp/sftp port from the server name
            $$ftp_sftp_dav_server_p =~ s/:$$ftp_sftp_dav_server_port_p$//;
        }
        else {
            $$ftp_sftp_dav_server_p = $ftp_server_and_port;
        }

        # now validate the ftp connection values
        # empty username
        $error_flag = 2 if ( ! defined $$ftp_sftp_dav_username_p or $$ftp_sftp_dav_username_p eq "" );
        # empty password
        $error_flag = 3 if ( $error_flag == 0 and (! defined $$ftp_sftp_dav_password_p or $$ftp_sftp_dav_password_p eq "") );
        # empty ftp/sftp server
        $error_flag = 4 if ( $error_flag == 0 and (! defined $$ftp_sftp_dav_server_p or $$ftp_sftp_dav_server_p eq "") );
        # empty or invalid ftp/sftp port
        $error_flag = 5 if ( $error_flag == 0 and (! defined $$ftp_sftp_dav_server_port_p or !($$ftp_sftp_dav_server_port_p =~ /^\d+$/) or $$ftp_sftp_dav_server_port_p <= 0 ) );
        # empty ftp/sftp directory
        $error_flag = 6 if ( $error_flag == 0 and (! defined $$ftp_sftp_dav_directory_p or $$ftp_sftp_dav_directory_p eq "") );
        # invalid ftp/sftp directory, not defined has full path
        $error_flag = 7 if ( $error_flag == 0 and (! defined $$ftp_sftp_dav_directory_p or check_if_full_path($$ftp_sftp_dav_directory_p, "unix", $global_config_p) != 0) );
    }

    if ( $error_flag != 0 ) { # if a error was found reset all ftp pointer values to empty
        $$ftp_sftp_dav_username_p = "";
        $$ftp_sftp_dav_password_p = "";
        $$ftp_sftp_dav_server_p = "";
        $$ftp_sftp_dav_server_port_p = "";
        $$ftp_sftp_dav_directory_p = "";
    }

    print "Function url_test_load() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    return $error_flag;
}


#
# Get the user encryption sed (password) and add more spice to it with more things and also encrypted using the same algorightm
# Will return: undef ; sequence of bytes
# Explain: undef is failure ; any other is the encrypted sequence of bytes
sub improve_encryption_sed {

    my $encrypting_sed = $_[0];
    my $new_sed = $_[1]; # this must be always a integer number
    my $encryption_times = $_[2]; # number of times that a encryption loop is done on each byte/bit
    my $encryption_level = $_[3]; # at what level is the encryption (byte / bit)
    my $crypting_file_algorithm_version = $_[4]; # The version of the crypting algoritm the encrypted file will use,
                                                 # notice this might change during the decrypt operation (if the file
                                                 # was encrypted with a older version of the algorith)
    my $global_config_p = $_[5]; # pointer into the configuration
    my $new_sed_position;

    my $new_sed_alternative = build_crc32("$new_sed", $global_config_p); # build the crc32 number for this backup directory

    if ( $crypting_file_algorithm_version eq "SimpleCrypt 1.0.0" ) { # if the file is using version 1.0.0 of the encryption algorithm
        $encrypting_sed = $encrypting_sed . ($new_sed * length($new_sed)); # complicate a little more by  user encrption sed by adding the new sed * it's lenght
        $encrypting_sed .= $new_sed; # complicate the user encrption sed by adding the new sed to the end of this
        if ( $encryption_level eq "byte" ) { # if using bytes
            $new_sed_position = (length($new_sed)-1);
        }
        else { # if using bits
            $new_sed = return_bits($new_sed, $global_config_p); # Convert the spiced user encryption sed string into bits
            $new_sed_alternative = return_bits($new_sed_alternative, $global_config_p); # Convert the spiced user encryption sed string into bits
            $new_sed_position = (length($new_sed)-8);
        }
        $encryption_times = $encryption_times * 10; # the encryption key is encrypted a lot ( configuration crypting times * 10 )
        # encript the encryption sed
        $encrypting_sed = crypt_decrypt_bytes($encrypting_sed, $new_sed, $new_sed_alternative, \$new_sed_position, $encryption_times, $encryption_level, "encrypt", $crypting_file_algorithm_version, $global_config_p); # add the read buffer into the write buffer
    }

    print "Function improve_encryption_sed() exit value is [ $encrypting_sed ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $encrypting_sed;
}


#
# Receive a sequence of bytes and return the corresponding sequence of bits
# Will return: a sequence of bits
# Explain: the sequence of bits represents the bytes entered
sub return_bits {

    my $in_bytes = $_[0]; # bytes or bits to encrypt/decrypt
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the return_bits() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $out_bits = "";

    # Sequence of bytes into a sequence of bits
    for ( my $i=0 ; $i<length($in_bytes) ; $i++ ) { # read each char at a time
        $out_bits .= unpack("B8", substr($in_bytes,$i,1)); # B8 because, 8 bits is a byte
    }

    print "Function return_bits() exit value is [ $out_bits ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $out_bits;
}


#
# Encrypt/Decrypt sequence of bytes by using a encryption sed (password)
# Notes: The encryption is done by using a xor, bit by bit, to complicate things even further the
# encryption sed is read from end to start and from start to end and it will start being read from
# a position passed by a argument (usually the start value is equal to the last value...), the
# sequence of bytes to encrypt can be encrypted several times (encrypt_decrypt_times argumment).
# The bit by bit encrition reads each byte from end to start.
# Will return: undef ; sequence of bytes
# Explain: undef is failure ; any other is the encrypted/decrypted sequence of bytes
sub crypt_decrypt_bytes {

    my $in_bytes_bits_tmp = $_[0]; # bytes or bits to encrypt/decrypt
    my $encrypting_sed_1 = $_[1]; # the "password" to encrypt/decrypt this sequence of bytes/bits
    my $encrypting_sed_2 = $_[2]; # the alternative "password" to encrypt/decrypt this sequence of bytes/bits
    my $encrypting_sed_position_pointer = $_[3]; # the position where the encryption sed will start to be read
    my $encrypt_decrypt_times = $_[4]; # number of times that the byte string will be encrypted/decrypted
    my $encryption_level = $_[5];  # at what level is the encryption (byte / bit)
    my $operation = $_[6]; # type of operation ( encrypt / decrypt ), this is only used if the level is bit
    my $crypting_file_algorithm_version = $_[7]; # The version of the crypting algoritm the encrypted file will use,
                                                 # notice this might change during the decrypt operation (if the file
                                                 # was encrypted with a older version of the algorith)
    my $global_config_p = $_[8]; # pointer into the configuration
    print "Running the crypt_decrypt_bytes() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it

    my $out_bytes; # will contain the bytes encrypted/decrypted

    if ( $crypting_file_algorithm_version eq "SimpleCrypt 1.0.0" ) {
        my $encrypting_sed_position = $$encrypting_sed_position_pointer; # get the sed position from the previous cycle
        my $encryption_sed_max; # size of the user encryption key minus one byte/bit
        my $sed_movement = "minus"; # when starting it will go backwards
        my $in_bits_tmp; # variable declared here to try to increase bit encryption speed a bit
        my $encrypting_sed_bits; # variable declared here to try to increase bit encryption speed a bit
        my $in_byte_tmp; # variable declared here to try to increase byte encryption speed a bit
        my $encrypting_sed_byte; # variable declared here to try to increase byte encryption speed a bit
        my $encrypting_sed = $encrypting_sed_1; # encrytpion sed when starting comes from the outside
        my $byte_bit_counter = 0;
        if ( $encryption_level eq "byte" ) {
            $encryption_sed_max = (length($encrypting_sed)-1); # The encryption key arrives in bytes
        }
        else {
            $encryption_sed_max = (length($encrypting_sed)-8); # The encryption key arrives in bits
        }

        while ( $encrypt_decrypt_times > 0 ) {
            $out_bytes = (); 

            for ( my $i=0 ; $i<length($in_bytes_bits_tmp) ; $i++ ) {
                if ( $encrypting_sed_position >= $encryption_sed_max ) { # update the encryption key position
                    $sed_movement = "minus"; # sed position is larger or equal than the sed
                }
                elsif ( $encrypting_sed_position <= 0 ) {
                    $sed_movement = "plus"; # sed position is smaller or equal to zero
                }
                if ( $encryption_level eq "byte" ) { # if things came in bytes
                    $in_byte_tmp = substr($in_bytes_bits_tmp,$i,1);
                    $encrypting_sed_byte = substr($encrypting_sed, $encrypting_sed_position, 1);
                    $out_bytes .= ($in_byte_tmp) ^ ($encrypting_sed_byte); # encrypt/decrypt the byte
                }
                else { # if things came in bits
                    $in_bits_tmp = unpack("B8", substr($in_bytes_bits_tmp,$i,1));
                    $encrypting_sed_bits = substr($encrypting_sed, $encrypting_sed_position, 8);
                    my $encrypted_decrypt_bits = "";
                    if ( $operation eq "encrypt" ) { # if encripting
                        for ( my $ii = 7 ; $ii>=0 ; $ii-- ) { # encrypt/decrypt every bit of the byte, notice the byte is read from end to start
                                $encrypted_decrypt_bits .= (0+substr($in_bits_tmp,$ii,1)) ^ (0+substr($encrypting_sed_bits,$ii,1));
                        }
                    }
                    else { # if decrypting
                        my $sed_ii = 7; # sed posioion is the last
                        for ( my $ii = 0 ; $ii<8 ; $ii++ ) { # encrypt/decrypt every bit of the byte, notice the byte was encrypted from end to start, so now read start to end
                                $encrypted_decrypt_bits = ((0+substr($in_bits_tmp,$ii,1)) ^ (0+substr($encrypting_sed_bits,$sed_ii,1))) . $encrypted_decrypt_bits;
                                $sed_ii--; # encryption sed is still read from the same position
                        }
                    }
                    $out_bytes .= pack("B8", $encrypted_decrypt_bits); # reconvert the encrypt/decrypt bits into a encrypt/decrypt byte and add it into the string to crypt/decrypt
                }
                # add or decrease the position inside the encryption sed... this complicates things a bit futher
                if ( $sed_movement eq "plus" ) {
                    $encrypting_sed_position = $encrypting_sed_position + 1 if ( $encryption_level eq "byte" );
                    $encrypting_sed_position = $encrypting_sed_position + 8 if ( $encryption_level eq "bit" );
                }
                else {
                    $encrypting_sed_position = $encrypting_sed_position - 1 if ( $encryption_level eq "byte" );
                    $encrypting_sed_position = $encrypting_sed_position - 8 if ( $encryption_level eq "bit" );
                }
                $byte_bit_counter++; # count the number of bytes/bits encrypted
            }

            # play a bit around with the way the encryption sed and what is read bettwen each encryption cycle, this is a further security eachement
            if ( ($encrypt_decrypt_times)%2 == 0 ) { # if the crypting cycle number is odd
                $encrypting_sed =  $encrypting_sed_2 . $byte_bit_counter if $encryption_level eq "byte"; # if using bytes, create a new encryption sed, based on the alternative of the encryption sed and on the last byte_bit_counter
                $encrypting_sed =  $encrypting_sed_2 . return_bits($byte_bit_counter, $global_config_p) if $encryption_level eq "bit"; # if using bits create a new encryption sed, based on the alternative of the encryption sed and on the last byte_bit_counter and convert the value into bit
            }
            else {
                $encrypting_sed =  $encrypting_sed_1; # use the main encryption sed
            }

            if ( $encryption_level eq "byte" ) {
                $encryption_sed_max = (length($encrypting_sed)-1); # The encryption key arrives in bytes
            }
            else {
                $encryption_sed_max = (length($encrypting_sed)-8); # The encryption key arrives in bits
            }

            if ( $encrypting_sed_position >= $encryption_sed_max ) { # update the encryption key position if required
                $encrypting_sed_position = $encryption_sed_max;
                $sed_movement = "minus"; # sed position is larger or equal than the sed
            }
            if ( $sed_movement eq "plus" and $encrypting_sed_position > 0  and ($byte_bit_counter)%2 == 0 ) { # if the movement in the encryption sed is going up and if the sed posionton is over zero and number is odd(dividable by 2)
                $sed_movement = "minus"; # change the movement to decrease
            }
            elsif ( $sed_movement eq "plus" and ($byte_bit_counter)%2 != 0 ) { # if the movement in the encryption sed is going up and number is even(not dividable by 2)
                $encrypting_sed_position = $encryption_sed_max; # reset into the max position
                $sed_movement = "minus"; # change the movement to decrease
            }
            elsif ( $sed_movement eq "minus" and $encrypting_sed_position < $encryption_sed_max and ($byte_bit_counter)%2 == 0 ) { # if the movement in the encryption sed is going down and the number is odd(dividable by 2)
                $sed_movement = "plus";  # change the movement into going up
            }
            elsif ( $sed_movement eq "minus" and ($byte_bit_counter)%2 != 0 ) { # if the movement in the encryption sed is going down and the number is odd(dividable by 2)
                $encrypting_sed_position = 0; # reset into the zero position
                $sed_movement = "plus";  # change the movement into going up
            }

            $encrypt_decrypt_times--;
            $in_bytes_bits_tmp = $out_bytes;
        }
        $$encrypting_sed_position_pointer = $encrypting_sed_position; # update the encryption pointer posiontion, for the next sequence of bytes to encrypt
    }

    return $out_bytes;
}


#
# Encrypt/Decrypt a file, by reading the source file and write a new file.
# 
# Will return: 0 ; 1
# Explain: 0 is sucess ; 1 is failure
sub crypt_decrypt_file {

    my $in_file = $_[0]; # filename to encrypt/decrypt
    my $out_file = $_[1]; # new filename (the encrypted/decrypted output)
    my $encrypting_sed = $_[2]; # the "password" to encrypt/decrypt the file
    my $operation = $_[3]; # type of operation ( encrypt / decrypt )
    my $read_buffer_size = $_[4]; # the read buffer, write buffer is always 32 times larger
    my $encryption_times = $_[5]; # number of times that a encryption loop is done on the file
    my $encryption_level = $_[6];  # at what level is the encryption (byte / bit)
    my $crypting_file_algorithm_version = $_[7]; # The version of the crypting algoritm the encrypted file will use,
                                                 # notice this might change during the decrypt operation (if the file
                                                 # was encrypted with a older version of the algorith)
    my $erase_source = $_[8]; # erase the user input file or not after sucessefull encryption/decryption (yes/no)
    my $give_feedback = $_[9]; # if this function will print a feedback info on the screen (yes/no), during each file read operation
    my $global_config_p = $_[10]; # pointer into the configuration

    print "Running the crypt_decrypt_file() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $error_flag = 0; # flag to mark errors
    # open the source file in read mode ( < )
    open(source_file_handle, "<$in_file") or $error_flag = 1;
    # open or create the log file in append > rewrite mode
    open(destiny_file_handle, ">$out_file") or $error_flag = 1;
    #lock the file for exclusive script use
    if ( $error_flag == 0 ) {
        flock (destiny_file_handle, LOCK_EX) or $error_flag = 1;
        binmode(source_file_handle); # Hack to make Win32 work
        binmode(destiny_file_handle); # Hack to make Win32 work
    }
    if ( $error_flag == 0 ) { # if no errors occured, encript or decrypt the file

        # notice starting from here errors are marked on the error_flag using undef value
        my $counter = 0;
        my $read_buffer = "";
        my $file_position = 0;
        my $encrypting_sed_position = 0;
        my $write_buffer = "";
        my $cripted_sucess_msg = "SuCeSs"; # Marker msg to know if the file is being sucessfuly decrypted or not
        my $encrypting_sed_alternative;
        my ($source_dev,$source_ino,$source_mode,$source_nlink,$source_uid,$source_gid,$source_rdev,$source_size,$source_atime,$source_present_mtime,$source_ctime,$source_blksize,$source_blocks) = stat("$in_file");

        # write the encryption file header if creating a new encrypted file
        if ( $operation eq "encrypt" ) {
            $error_flag = syswrite destiny_file_handle,$crypting_file_algorithm_version;
            $error_flag = 0 if ( defined $error_flag );
        }
        elsif ( $operation eq "decrypt" ) { # decrypting file, remove the file header and test if
            my $crypting_algorithm_version_size = length($crypting_file_algorithm_version);
            my $file_header_identify; # will contain the file header
            # read the file identitifier
            $error_flag = sysseek source_file_handle,$file_position,0; # position (in bytes) the file pointer into the next step
            $error_flag = sysread source_file_handle,$file_header_identify,$crypting_algorithm_version_size; # read the simplecrypt algothm file header
            if ( !defined $file_header_identify or $file_header_identify ne "SimpleCrypt 1.0.0" ) { # test if the file header is valid
                $error_flag = (); # mark error, invalid file header
            }
            else {
                $crypting_file_algorithm_version = $file_header_identify; # we are decrypting a file, get the actual algorithm version from the encrypted file header.
            }
        }

        if ( defined $error_flag and $crypting_file_algorithm_version eq "SimpleCrypt 1.0.0" ) { # if the file is using version 1.0.0 of the encryption algorithm

            # write the encryption file header if creating a new encrypted file
            if ( $operation eq "encrypt" ) {
                # spice up the user encription by encripting it also, the encription sed used, is based on the
                # file size*user string(user encryption sed)
                $encrypting_sed = improve_encryption_sed($encrypting_sed, ($source_size*length($encrypting_sed)), $encryption_times, $encryption_level, $crypting_file_algorithm_version, $global_config_p );
                $encrypting_sed_alternative = build_crc32("$encrypting_sed", $global_config_p); # build the crc32 number for this backup directory
                if ( $encryption_level eq "byte" ) {
                    $encrypting_sed_position = (length($encrypting_sed)-1); # configure the sed pointer
                }
                else { # if encrypting at bit level
                    $encrypting_sed = return_bits($encrypting_sed, $global_config_p); # Convert the spiced user encryption sed string into bits
                    $encrypting_sed_alternative = return_bits($encrypting_sed_alternative, $global_config_p); # Convert the spiced user encryption sed string into bits
                    $encrypting_sed_position = (length($encrypting_sed)-8); # configure the sed pointer
                }
                $cripted_sucess_msg = crypt_decrypt_bytes($cripted_sucess_msg, $encrypting_sed, $encrypting_sed_alternative, \$encrypting_sed_position, $encryption_times, $encryption_level, $operation, $crypting_file_algorithm_version, $global_config_p); # write a encrypted sucess message into the file header to know in the future that de decompress when ok
                $error_flag = syswrite destiny_file_handle,$cripted_sucess_msg; # write the encrypted sucess msg for future decrypt tests
            }
            elsif ( $operation eq "decrypt" ) { # decrypting file, remove the file header and test if
                my $crypting_algorithm_version_size = length($crypting_file_algorithm_version);
                my $cripted_sucess_msg_size = length($cripted_sucess_msg);
                my $file_header_identify; # will contain the file header
                my $sucess_check; # will contain the sucess encrypted msg
                # spice up the user encription by encripting it also, the encription sed used, is based on the
                # file size*user string(user encryption sed), in this case we  count out the encription file header size
                $encrypting_sed = improve_encryption_sed($encrypting_sed, (($source_size-$crypting_algorithm_version_size-$cripted_sucess_msg_size)*length($encrypting_sed)), $encryption_times, $encryption_level, $crypting_file_algorithm_version, $global_config_p );
                $encrypting_sed_alternative = build_crc32("$encrypting_sed", $global_config_p); # build the crc32 number for this backup directory
                $file_position = $crypting_algorithm_version_size; # Position the file read pointer after the file header
                # read the sucess cryption code
                $error_flag = sysseek source_file_handle,$file_position,0; # position (in bytes) the file pointer into the next step
                $error_flag = sysread source_file_handle,$sucess_check,length($cripted_sucess_msg); # read the sucess msg header
                if ( $encryption_level eq "byte" ) {
                    $encrypting_sed_position = (length($encrypting_sed)-1);
                }
                else { # if decrypting at bit level
                    $encrypting_sed = return_bits($encrypting_sed, $global_config_p); # Convert the spiced user encryption sed string into bits
                    $encrypting_sed_alternative = return_bits($encrypting_sed_alternative, $global_config_p); # Convert the spiced user encryption sed string into bits
                    $encrypting_sed_position = (length($encrypting_sed)-8);
                }
                $sucess_check = crypt_decrypt_bytes($sucess_check, $encrypting_sed, $encrypting_sed_alternative, \$encrypting_sed_position, $encryption_times, $encryption_level, $operation, $crypting_file_algorithm_version, $global_config_p); # attempt to decrypt the sucess msg
                $file_position = $file_position + length($cripted_sucess_msg); # place the file pointer after all simplecrypt algorithm headers
                if ( !defined $sucess_check or $sucess_check ne "SuCeSs" ) { # test if the encrypted file versions is valid
                    $error_flag = (); # mark error, invalid file header or uncript went bad
                }
            }
            while ( defined $error_flag and $file_position < $source_size ) {
                print "." if ( $give_feedback eq "yes" ); # print a . char during each read operation (user feedback)
                $error_flag = sysseek source_file_handle,$file_position,0; # position (in bytes) the file pointer into the next step
                if ( ($read_buffer_size + $file_position) > $source_size ) { # detect if the buffer + the file position is overunning the total file size
                    $read_buffer_size = $source_size - $file_position; # fix the buffer size to only the the last file bytes
                }
                $error_flag = sysread source_file_handle,$read_buffer,$read_buffer_size; # position (in bytes) the file pointer into the next step
                $write_buffer .= crypt_decrypt_bytes($read_buffer, $encrypting_sed, $encrypting_sed_alternative, \$encrypting_sed_position, $encryption_times, $encryption_level, $operation, $crypting_file_algorithm_version, $global_config_p); # add the read buffer into the write buffer
                if ( $counter == 128 ) { # check if we need to write anything;
                    $error_flag = syswrite destiny_file_handle,$write_buffer; # write the new file using the write buffer string
                    $write_buffer = (); # clear the write buffer
                    $counter = 0; # reset the read counter
                    print "*" if ( $give_feedback eq "yes" ); # print a . char during each read operation (user feedback)
                }
                $file_position = $file_position + $read_buffer_size; # read the N buffer bytes at once
                $counter++;
                last if ( !(defined $error_flag) );
            }
            if ( defined $error_flag and $write_buffer ne ""  ) { # check if we need to write any file left overs
                print "*" if ( $give_feedback eq "yes" ); # print a . char during each read operation (user feedback)
                $error_flag = syswrite destiny_file_handle,$write_buffer; # write the new file using the write buffer string
            }
        }
        # fix the error flag since it can have undef (if a error occured)
        if ( defined $error_flag ) {
            $error_flag = 0;
        }
        else {
            $error_flag = 1; # error flag had undef so mark error
        }
    }
    close (source_file_handle); # close the source file
    close (destiny_file_handle); # close the destiny file

    if ( $error_flag == 0 and $erase_source eq "yes" ) { # erase the user input file it sucesefull and if required
        unlink $in_file;
    }
    unlink $out_file if ( $error_flag != 0 ); # delete the created file if any error occured

    print "Function crypt_decrypt_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Create or Edit a configuration file using the default operating system editor
# vi for Unix and notepad for windows
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure
sub create_edit_config {

    my $file_path = $_[0]; # this is the first function parameter $_[1] is the second etc etc etc
    my $my_script_version = $_[1]; # script version parameter
    my $error_flag = 0; # to mark errors
    my $full_date = (localtime(time())); # present date in the default format

    print "\n";
    # test if the file is valid
    if ( -d $file_path or -l $file_path or -c $file_path or -b $file_path ) {
        print "[ Error ], the path is not pointing into a valid file.\n\n";
        return 1; # "file" is a directory, link (unix only), caracter device (unix only) or block device (unix only)
    }

    if ( ! -f $file_path ) { # if the file does not exists create a new one
        my $my_option =""; # to contain the user input
        while ( $my_option ne "y" and $my_option ne "n" ) {
            print "File does not exist would you like me create it ?\n";
            print "[ y/n ] ";
            $my_option = <STDIN>;
            chop $my_option; # remove the new line char
        }
        if ( $my_option eq "y" ) { # if user wants to create the file
            # create the log file in > write mode
            open(configuration_file_handle, ">$file_path") or $error_flag = 1;
            if ( $error_flag == 0 ) {
                #lock the file for exclusive script use
                flock (configuration_file_handle, LOCK_EX) or $error_flag = 1;
                # write the new configuration file (using default/standard values)
                print configuration_file_handle <<EOF, or $error_flag = 1;
#
# Simplebackup configuration file
# Created by simplebackup v$my_script_version on $full_date
#
# Comments must be made with the char # on the start of the line,
# also notice to prevent weird backup's always define full path's
#


#
# [ Backup mode ]
#
# Simplebackup supports 3 different backup modes:
#
# full         > In this mode simplebackup will always compress everything
#                that is suppose do be backup.
#                To restore your data, you only need to restore/uncompress a
#                single backup file, but the price is a higher usage of
#                backup space and time. If you use this mode don't forget to
#                check the configuration key [ keep_last_n_files ].
#   ** Logic: full_backup -> full_backup -> full_backup -> etc **
#
# incremental  > In this mode simplebackup will make a full backup (at a
#                chosen date) and from there on it will only make backups of
#                the data that was changed in relation to the previous
#                backup (full or incremental).
#                You gain a smaller and faster backups but the price is the
#                restore, to do a full restore you need to restore the full
#                backup and all the incremental backups in the correct
#                sequence. If you use this mode don't forget to check the
#                configuration key [ full_backup_day ].
#   ** Logic: full_backup -> incremental -> incremental -> etc **
#
# differential > In this mode simplebackup will make a full backup (at a
#                chosen date) and from there on it will only make backups of
#                the data that was changed in relation to the previous full
#                backup. This mode is a mixture between full backup and
#                incremental backup.
#                To do a full restore you need to restore the full backup and
#                the most recent differential backup. If you use this mode
#                don't forget to check the configuration key
#                [ full_backup_day ].
#   ** Logic: full_backup -> differential -> differential -> etc **
#
# Default value is: full
# Valid values are: full ; incremental ; differential
backup_mode = full


#
# [ Full backup day ]
#
# When the full backup day occurs. This option is only used if simplebackup
# is working in incremental or differential backup mode, so check the
# [ backup_mode ].
# Note, when a successful full backup occurs all previous full, incremental
# or differential backups related are erased, also notice that you can do a
# single full backup per year... but one must be really nuts to use this.
#
# Default value is: monday
# Valid values are: monday, tuesday, wednesday, thursday, friday, saturday,
#                   sunday, first_day_month, last_day_month, first_day_year,
#                   last_day_year
full_backup_day = monday


#
# [ Backup format ]
#
# Simplebackup does the backups by compressing the date into archive files,
# here you can chose your favorite format.
# Notice that the use of this formats depend on the availability of the.
# corresponding archive programs (rar/winrar ; 7z/7-zip ; zip/info-zip ; 
# tar ; gzip ; bzip2 ; compress) in your system path.
# Also notice that the use of more advanced tar(s) commands allows several
# improvements over "tar backups", but depend on the availability of a recent
# version of the tar utility. For more info check the faq "Q. What is the
# difference between standard tar and advanced tar ?" in the simplebackup
# documentation (readme.html/readme.txt file).
#
# Valid values are: rar ; 7z ; zip ; tar ; tar.Z ; tar.gz ; tar.bz2 ;
# advanced_tar ; advanced_tar.Z ; advanced_tar.gz ; advanced_tar.bz2
backup_format = zip


#
# [ Backup compression ratio ]
#
# Note that on simple tar backups or tar + compress this value is not
# relevant, in that case you can set it to any value.
#
# Default value is: maximal
# Valid values are: none ; minimal ; average ; maximal
backup_compression_ratio = maximal


#
# [ Backup list ]
#
# Full path into directories and files to backup or a "url" into into a text
# file containing the backup list, the backup list file.
# Notice, if used, the backup file list must be a ascii text file containing
# one line for every directory or file to backup.
# In any case everything must be declared using full path's.
#
# Valid values are: any valid directory, file or list of directories and
#                   files separated by the < char or a full path "url"
#                   into file that contains a list of what to backup
# Examples: c:\\some_directory
#           c:\\some_directory < d:\\another_directory
#           c:\\some_directory < d:\\another_directory < e:\\ok\\some_file.txt
#           c:\\a_file.doc < e:\\ok\\some_file.txt
#           /home/some_directory
#           /home/some_directory< /home/another_directory
#           /home/some_directory< /home/another_directory< /etc/my.conf
#           /etc/my.conf, /root/my_file.txt
#           file://\@/root/files/my_backup_list.txt
#           file://\@c:\\my_backup_list.txt
input_backup =


#
# [ Compressed backup files final destiny ]
#
# Where simplebackup places the backup data.
# It can be any valid directory (including network mounted shares), a ftp
# server, http dav server, one or more email accounts or a tape device
# (unix only).
#
# Examples:
#      /some_directory      (under Unix type of systems)
#      d:\\some_directory    (under Microsoft type of systems)
#      FTP Backups
#       ftp://some_username:some_password\@some_server:8021/some_dir
#       ftp://some_username:some_password\@some_server/some_dir
#       Explained fields :
#        ftp://        ; marks that is a ftp backup type,
#        some_username ; Remote ftp user, this must be able to read,
#                        write and delete from the server,
#        some_password ; Password associated with the ftp username,
#        some_server   ; Ftp server, example ftp.netscape.com
#        8021          ; Server port, if empty the default value is 21,
#         /some_dir     ; Directory on the server to contain the backup files.
#      SFTP Backups (Encrypted FTP Mode using ssh)
#       sftp://some_username:some_password_or_passphrase\@some_server:8022/some_dir
#       sftp://some_username:some_password_or_passphrase\@some_server/some_dir
#       Explained fields :
#        sftp://       ; marks that is a sftp backup type (ssh2 encryption),
#        some_username ; Remote sftp user, this must be able to read,
#                        write and delete from the server,
#        some_password_or_passphrase ; Password or private key passphrase
#                                      associated with the sftp username,
#                                      or with the private key.
#                                      If you are using openssh the private
#                                      key will be automatically used if it's
#                                      available.If you are using the putty
#                                      psftp then you also need to define
#                                      the private key file in the config.
#                                      key [ psftp_private_key_file ].
#                                      The passphrase can be defined has
#                                      [ none ] if your private key was not
#                                      created with a passphrase. Notice that
#                                      this is not recommended, for extra
#                                      security you should always define a
#                                      passphrase when using a private key.
#        some_server   ; SSH server, example sftp.netscape.com
#        8022          ; SSH Server port, if empty the default value is 22,
#        /some_dir     ; Directory on the server to contain the backup files.
#        Please check the configuration key sftp_transport value.
#      Http Dav Backups
#       http://some_username:some_password\@some_server:8080/some_dir
#       http://some_username:some_password\@some_server/some_dir
#       Explained fields :
#        http://       ; marks that is a http dav backup type,
#        some_username ; Remote htpp dav user, this must be able to read,
#                        write and delete from the server,
#        some_password ; Password associated with the ftp username,
#        some_server   ; Ftp server, example ftp.netscape.com
#        8021          ; Server port, if empty the default value is 21,
#        /some_dir     ; Directory on the server to contain the backup files.
#      Email Backups
#       smtp://some_server?mail_from_address=mail_from_address\@some_server.com&mail_to_addresses=to_mail_account_1\@another_server1.com,to_mail_account_2\@other_server.com,to_mail_account_3\@some_server.com
#       smtp://some_server:2025?mail_from_address=mail_from_address\@some_server.com&mail_to_addresses=to_mail_account_1\@another_server1.com,to_mail_account_2\@other_server.com,to_mail_account_3\@some_server.com
#       smtp://some_username:some_password\@some_server?mail_from_address=mail_from_address\@some_server.com&mail_to_addresses=to_mail_account_1\@another_server1.com,to_mail_account_2\@other_server.com,to_mail_account_3\@some_server.com
#       smtp://some_username:some_password\@some_server:2025?mail_from_address=mail_from_address\@some_server.com&mail_to_addresses=to_mail_account_1\@another_server1.com,to_mail_account_2\@other_server.com,to_mail_account_3\@some_server.com
#       explanation (the separated fields) :
#        smtp://       ; marks that is a smtp (mail) backup type,
#        some_username ; If your mail server requires authentication then
#                        place your smtp mail user here,
#        some_password ; Password associated with the smtp mail username,
#        some_server   ; Smtp mail server where the backup mail is sent,
#                        example smtp.google.com
#        2025          ; Server port, if empty the default value is 25,
#        mail_from_address=from_mail_account\@some_server.com
#                      ; Mail account from where the backup mail is sent.
#        mail_to_addresses=to_mail_account_1\@another_server1.com,to_mail_account_2\@other_server.com,to_mail_account_3\@some_server.com
#                      ; address or addresses where the backup mail is sent.
#      Tape Backups (Unix Only)
#       tape://\@/dev/some_tape_device
output_backup =


#
# [ Temporary directory ]
#
# Defines where the compress file and other temporary files are generated.
# This can be automatically resolved by using the option "auto".
#
# Default value is: auto
# Valid values are: auto ; any valid path into a directory
temporary_dir = auto


#
# [ Database support file - copy 1 of 3 ]
#
# This special file is required by simplebackup in order for it to manage
# the backups and restores. It contains such has a list of files and
# directories used during incremental and differential backups, a list of
# the backup files created, the restore dates and restore counters etc.
# For more technical details check the simplebackup documentation.
# Because this information is so important for the backup/restore operations
# simplebackup can use up to three copies of this file
# (backup_support_file_copy1, backup_support_file_copy2 and
# backup_support_file_copy3 ), it is advisable that you configure them both
# and point each support file into different hard disks or at least different
# partitions.
# Notice: DO NOT share support files across different backup types, use one
# database file per backup configuration file.
# Notice: If all copies of the support file are corrupted the backups and
# restores will fail.
# 
# Default value is: auto
# Valid values are: auto (to automatically define the file) ; any valid full
#                   path into a file
# Examples: c:\\temp\\some_support_file_copy1.db
#           /tmp/some_support_file_copy1.db
#           auto
backup_support_file_copy1 = auto


#
# [ Database support file - copy 2 of 3 ]
#
# This is the second copy of the simplebackup support file, please read the
# above text to know more about it.
# 
# Default value is: auto
# Valid values are: auto (to automatically define the file) ; none (to turn
#                   off the second copy, not recommended!) ; any valid full
#                   path into a file
# Examples: c:\\temp\\some_support_file_copy2.db
#           /tmp/some_support_file_copy2.db
#           auto
#           none
backup_support_file_copy2 = auto


#
# [ Database support file - copy 3 of 3 ]
#
# This is the thierd copy of the simplebackup support file, please read the
# above text to know more about it.
# 
# Default value is: auto
# Valid values are: auto (to automatically define the file) ; none (to turn
#                   off the third copy, not recommended!) ; any valid full
#                   path into a file
# Examples: c:\\temp\\some_support_file_copy3.db
#           /tmp/some_support_file_copy3.db
#           auto
#           none
backup_support_file_copy3 = auto


#
# [ Keep n files ]
#
# Defined how many previous backup sessions to keep.
# Notice this option is only configurable if simplebackup is working in full
# backup mode [ backup_mode = full ]. In incremental or differential modes
# this value is automatically managed.
# The valid numbers are:
#   -1               > keep all full backup sessions, no previous backup
#                      are erased.
#   0                > just keep the current full backup session.
#   any_other_number > for example 5 will keep the last 5 + the current
#                      full backup session.
#
# Valid values are: -1 ; 0 ; any_other_number
keep_last_n_files = -1


#
# [Run before backup ]
#
# Optional script/batch file/command that you can run before starting to
# backup.
# Note that this command must end in success in order for the backup to
# start, if it fails simplebackup will not continue.
#
# Valid values are: any valid command ; nothing at all
# Examples: unix /etc/rc.d/mysql.server stop mysql
#           windows > net stop mysql
run_before_backup =


#
# [Run before restore ]
#
# Optional script/batch file/command that you can run before starting to
# restore.
# Note that this command must end in success in order for the restore to
# start, if it fails simplebackup will not continue.
# If the option "auto" is used then it will be the same (if available) has
# the run_before_backup script/batch file/command.
#
# Valid values are: auto ; any valid command or nothing at al
# Examples: unix /etc/rc.d/mysql.server stop mysql
#           windows > net stop mysql
#           auto
run_before_restore =


#
# [ Run after backup ]
#
# Optional script/batch file/command that you can run after the backup ended.
# Notice that by default this always runs even if the backup fails, if you
# don't want that check the [ on_failure_run_after_backup configuration ]
# key.
#
# Valid values are: any valid command ; nothing at all
# Examples: unix > /etc/rc.d/mysql.server start
#           windows > net start mysql
run_after_backup =


#
# [ Run after restore ]
#
# Optional script/batch file/command that you can run after the restore
# ended.
# Notice that by default this always runs even if the restore failed, if you
# don't want that check the [ on_failure_run_after_restore ] configuration
# key.
# If the option "auto" is used then it will be the same (if available) has
# the run_after_backup script/batch file/command.
#
# Valid values are: auto ; any valid command or nothing at al
# Examples: unix > /etc/rc.d/mysql.server start
#           windows > net start mysql
#           auto
run_after_restore =


#
# [ Encryption Password ]
#
# Optional password that can be defined if you want to encrypt the backup
# files generated.
# If defined the backup files generated will be encrypted using a build in
# encryption algorithm (SimpleCrypt algorithm) and will have the [ .sc ]
# extension added, example [ home.zip ] file will became [ home.zip.sc ].
# To restore them you must use simplebackup or the simplecrypt tool, the
# correct password and all (if used) advanced encryption options
# (encryption_cycle ; encryption_level).
# Notice that the SimpleCrypt algorithm uses several encryption tricks and
# can use several user options (apart from the password), there are no back
# doors, so if you forgot any of the encryption options (encryption_passwd ;
# encryption_crypt ; encryption_level), there is nothing that i can do about
# it.
# It's recommended that the password is a complicated sequence of chars with
# letters, numbers and symbols..
#
# Warning this option is provided has a small security feature, it does not
# aim at being "perfect" and "uncrackable". If your backup data really
# requires security please consider adding and using other tools to secure
# it.
#
# Valid values are: any sequence of chars ; nothing at all
encryption_passwd =


#
# [ Log file ]
#
# Full path into the log file or auto (to create it automatically), used by
# simplebackup during backups and restores.
# This file is generated in ascii format (Unix or Windows depending on the
# host operating system).
# Note that you can share a single log file across all backup's, but it's not
# recommended since it will tend to mix the log messages, but it's up to you.
# The auto option creates a path based on the temporary_dir parameter on
# this configuration file name and by adding the .log extension.
#
# Valid values are: auto (to automatically define the file) ; none (to turn
#                   off file logging ; any valid full path into a file
# Examples: c:\\my_logfile.log
#           /home/my_user/my_backup_data.log
#           auto
#           none
log_file = auto


#
# [ Backup list on log ]
#
# This defines if the list of files and directories backuped by simplebackup
# will be added or not to the backup log (log file and email report).
# Please notice that depending on the amount of data to backup this can
# increase the size of the log a lot.
#
# Default value is: no
# Valid values are: yes ; no
backup_list_on_log = no


#
# [ Restore list on log ]
#
# This defines if the list of files and directories restored by simplebackup
# will be added or not into the backup log (log file and email report).
# Please notice that depending on the amount of data to restore this can
# increase the size of the log a lot.
#
# Default value is: no
# Valid values are: yes ; no
restore_list_on_log = no


#
# [ Mail server ]
#
# If you want to send backup and restore reports using email then you must
# configure here a valid mail server relay.
# Note that you must have the correct permissions on the server in order
# for this to work.
#
# Example: some_smtp_server.com
# Valid values are: any valid domain name, mail server or ip address
mail_server =


#
# [ Mail from address ]
#
# The email address where the reports will be generated.
#
# Valid values are: any valid email address
# Examples: backup_reporting\@mail_server.com
mail_from_address =


#
# [ Mail to addresses ]
#
# The email address or addresses where the reports will be send.
#
# Valid values are: any valid email address or addresses separated by the ,
# char.
# Examples: some_adress\@somewhere.com
#           some_adress_1\@somewhere.com, some_adress_2\@anywhere.com
mail_to_addresses =


#
# [ Text Note ]
#
# This allows you to define a personal text note that will be included on
# each backup log and each backup mail (if using smtp/email backups).
#
# Valid values are: any text
# Examples: This is a backup of my company website
#           This is a backup of all my mpg files and of all my work sources
text_note =







# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#   The following parameters are not required to be present,  #
#   use them ONLY if you absolutely require them.             #
#                                                             #
#   To use them uncomment and configure the option.           #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

#
# [ Host Operating System ]
#
# Defines the operating system where simplebackup is running, you can use
# this if the auto detection is not working properly.
#
# Default value is: auto
# Valid values are: auto ; winnt4/win2000/xp/2003 ; unix
#host_os = auto


#
# [ Encryption crypt times (Encryption advanced parameters) ]
#
# This option can be used to define the number of times that the encryption
# algorithm runs over each byte/bit on the backup files generated.
# The higher the number the slower and safer the process is.
#
# Default value is: 2
# Valid values are: any numeric number over zero, example 2
#encryption_crypt = 2


#
# [ Encryption level (Encryption advanced parameters) ]
#
# This option can be used to define at what level the encryption algorithm
# will affect the backup files generated, on every byte or on every bit.
# The bit level is safer but makes the encryption process very slow, so it's
# suggested only to be used in backups with small amounts of data.
#
# Default value is: byte
# Valid values are: byte ; bit
#encryption_level = byte


#
# [ Run backup even on failure of run before backup ]
#
# Run the backup even if the program defined in the [ run_before_backup ]
# configuration key fails ?
#
# Default value is: no
# Valid values are: yes ; no
#run_backup_on_failure_run_before_backup = no


#
# [ Run restore even on failure of run before restore ]
#
# Run the restore even if the program defined in the [ run_before_restore ]
# configuration key fails ?
#
# Default value is: no
# Valid values are: yes ; no
#run_restore_on_failure_run_before_restore = no


#
# [ On failure run after backup ]
#
# Run the after backup program, if defined in the [ run_after_backup ]
# configuration key, even if the backup fails ?
#
# Default value is: yes
# Valid values are: yes ; no
#on_failure_run_after_backup = yes


#
# [ On failure run after restore ]
#
# Run the after restore program, if defined in the [ run_after_restore ]
# configuration key, even if the restore fails ?
#
# Default value is: yes
# Valid values are: yes ; no
#on_failure_run_after_restore = yes


#
# [ Backup full path rejections (Backup advanced parameters) ]
#
# This option can be used to reject files or directories using full paths,
# a standard text file containing the rejections can also be using using a
# a "url" pointing into the rejection file..
# The use of standard wild cards is also available, please notice that the
# use of wild cards is recursive, meaning that files (and only files) under
# subdirectories are also affected. Beware that on unix all paths are case
# sensitive.
# To fully reject a directory add the * char on the end of the path, check
# the examples below for more details.
# Notice this option tends to make backups slower.
#
# Examples: c:\\windows\\*
#           c:\\windows\\*<c:\\Program Files\\*
#           c:\\windows\\*<z:\\\\*<C:\\Documents and Settings\\Administrador\\*.dat
#           C:\\music\\matrix*.avi<c:\\windows\\*<c:\\program files\\*
#           d:\\documents\\document to reject.xls
#           file://\@/c:\\my_rejection_list.txt
#           /proc/*</dev/*</tmp/*
#           /home/migas/*.avi</home/migas/star wars*.*
#           /root/myscript.pl</usr/local/sbin/*
#           /nfs_volume1/*.doc</nfs_volume1/*.xls</nfs_volume1/picture_*
#           file://\@/root/files/my_rejection_list.txt
#           file://\@c:\\my_rejection_list.txt
#backup_full_path_rejections =


#
# [ Backup extension rejections (Backup advanced parameters) ]
#
# This option can be used to reject files of some type or types, the type is
# defined by the file extension.
# Notice this option tends to make backups slower, and it's global for all
# backup data files.
#
# Examples: zip
#           zip,mp3,mpg,mpeg
#backup_extension_rejections =


#
# [ Backup filenames rejections (Backup advanced parameters) ]
#
# This option can be used to reject files by file name.
# Notice this option tends to make backups slower, and it's global for all
# backup data files.
#
# Examples: my_boss_image.png
#           my_boss_image.png,boss_party.png,my secret.doc
#backup_filenames_rejections =


#
# [ Backup file size limit (Backup advanced parameters) ]
#
# This option can be used to limit the maximal size of the files that
# simplebackup will backup (available on the backup list, that is defined by
# the configuration key [ input_backup ]).
# The file size is given in kbytes.
# Notice this option tends to make backups slower, and it's global for all
# backup files.
#
# Default value is: 0 (no limit)
# Valid values are: any valid positive number or 0 (no limit)
# Examples: 1024 (1 megabyte), 15360 (15 megabyte),
#           512 (half a megabyte), 102400 (100 megabytes)
#backup_file_size_limit = 0


#
# [ Compressed file size limit (Backup advanced parameters) ]
#
# This option can be used to limit the maximal size of the backup files
# generated by simplebackup. This is a security limit to prevent overloading
# the backup destination. The file size is given in kbytes.
#
# Default value is: 5120 (5 Megabytes), if using smtp/email backups
#                   0 (no limit), if using any other type of backup
# Valid values are: any valid positive number or 0 (no limit)
# Examples: 1024 (1 megabyte), 15360 (15 megabyte),
#           512 (half a megabyte), 102400 (100 megabytes)
#compressed_file_size_limit = 0


#
# [ Mail Backup files attachment method (Mail Backup advanced parameters) ]
#
# This option defines how simplebackup processes the backup files generated
# and how they will be attached into the email backup.
# This option is only relevant when doing a email backup.
#
# Remember simplebackup will generate a backup file for every file or
# directory listed on the backup list [ input_backup ] configuration key.
#
# Valid values are:
#                   all -> attach all backup files into a single email,
#            individual -> attach each backup file into a separated email.
#
# Default value is: all
#backup_mail_attachment_method = all


#
# [ Backup List encoding format ]
#
# What is the encoding that simplebackup will use when passing the backup
# list into the archive command.
#
# Has part ot the backup and restore procedures simplebackup creates a list
# of files and directories to be backup ed or restored, this list is then
# passed to the archive command (tar, zip, rar, etc). The problem can arrive
# because the archive commands deal with non english filenames in different
# ways, zip (info-zip) for example will accept 8 bits ascii and usually
# process almost all filenames without problems, rar requires a unicode
# (UTF16-LE) encoded file list, 7-zip requires unicode (UTF-8).
#
# This is not related to the configuration key [ backup_list_on_log ].
#
# Values explanation:
#   Auto  -> attempt to detect the correct encoding based on the backup
#            format, the perl version *1 and the operating system where
#            simplebackup is running.
#            will mean:
#              utf16-le, if using the rar backup format and running on a
#              Windows System *1. The Unix rar version does not support
#              unicode at the present time, so it will default to ascii.
#              utf-8, if using the 7z (7-ZIP) backup format *1.
#              ascii, in any other situation.
#   ascii -> to force the use of the ascii format.
#   utf-8 -> to force the use of the Unicode 8 bits *1.
#   utf16-le -> to force the use of the unicode 16 bits little-endian *1.
#
# *1 to use unicode simplebackup needs to be running with perl 5.8 or over,
#    if that is not available in auto mode it will default into ascii.
#
# Default value is: auto
# Valid values are: auto ; utf-8 ; utf16-le ; ascii
#backup_list_encoding = auto


#
# [ Restore List encoding format ]
#
# What is the encoding that simplebackup will use when passing the restore
# list into the archive command.
#
# Has part ot the backup and restore procedures simplebackup creates a list
# of files and directories to be backup ed or restored, this list is then
# passed to the archive command (tar, zip, rar, etc). The problem can arrive
# because the archive commands deal with non english filenames in different
# ways, zip (info-zip) for example will accept 8 bits ascii and usually
# process almost all filenames without problems, rar requires a unicode
# (UTF16-LE) encoded file list, 7-zip requires unicode (UTF-8).
#
# This is not related to the configuration key [ restore_list_on_log ].
#
# Values explanation:
#   Auto  -> dynamic select enconding that will change acordingling to the
#            format of the file being restored, the perl version *1 and the
#            operating system where simplebackup is running.
#            will mean:
#              utf16-le, if the file being restore is in rar format and if
#              running on a Windows System *1. The Unix rar version does not
#              support unicode at the present time, so it will default to
#              ascii.
#              utf-8, if restoring a file in the 7z (7-ZIP) format *1.
#              ascii, in any other situation.
#   ascii -> if you always want to force the ascii format.
#   utf-8 -> if you always want to force unicode 8 bits *1.
#   utf16-le -> if you always want to force unicode 16 bits little-endian *1.
#
# *1 to use unicode simplebackup needs to be running with perl 5.8 or over,
#    if that is not available in auto mode it will default into ascii.
#
# Default value is: auto
# Valid values are: auto ; utf-8 ; utf16-le ; ascii
#restore_list_encoding = auto


#
# [ Simplebackup debug level ]
#
# The amount of messages related to the simplebackup processing that will
# be printed into the shell/prompt.
# Notice this option has nothing to do with the amount of information written
# into the log, the log is always at "full" level.
#
# Levels :
#          none : nothing is printed,
#          half : every simplebackup function() prints a message when it
#                 starts,
#          full : The same has the half debug level, plus the ftp and mail
#                 connections produce a full connection debug and the
#                 external commands used will be allowed to output into the
#                 console/shell.
#
# Default value is: none
# Valid values are: none ; half ; full
#debug_level = none


#
# [ Network Timeout (Network advanced parameters) ]
#
# The timeout value used during some network operations (ftp, email
# reporting, email backups, and some sftp operations)
# 
# Default value is: 480
# Valid values are: any numeric number over zero, example 480
#network_timeout = 480


#
# [ Network Connect Retries (Network advanced parameters) ]
#
# The number of retries that simplebackup will make connecting into a ftp
# or sftp server, during ftp or sftp backups.
# Please notice that in ftp backup (not sftp) after 3 connect attempts
# simplebackup will automatically switch the passive mode,
# [ ftp_passive_mode ] configuration key, reversing the configured value
# from yes to no or from no to yes.
#
# Default value is: 6
# Valid values are: any numeric number over zero, example 6
#network_connect_retries = 6


#
# [ Network Proxy (Network advanced parameters) ]
#
# Proxy used during ftp backups.
# Note that if value is not declared simplebackup will not use a ftp proxy.
# The ftp proxy must be open, proxy authentication is not yet supported.
#
# Valid values are: any valid hostname + port
# examples: my_ftp_proxy:8021
#network_proxy = some_proxy_server:2121


#
# [ Mail server port (Mail advanced parameters) ]
#
# The port where the mail server is running.
# Notice this is NOT used during smtp/email backups.
#
# Default value is: 25
# Valid values are: any numeric number over zero, example 25
#mail_port = 25


#
# [ Mail username (Mail advanced parameters) ]
#
# If your mail server requires authentication then activate this option.
# Notice this is NOT used during smtp/email backups.
#
# Valid values are: any valid mail username
#mail_username =


#
# [ Mail password (Mail advanced parameters, to match the mail username) ]
#
# If your mail server requires authentication then activate this option.
# Notice this is NOT used during smtp/email backups.
#
# Valid values are: any valid mail password
#mail_password =


#
# [ FTP Passive mode (Ftp advanced parameters) ]
#
# Ftp mode used during ftp backups.
# Notice that passive mode is only required for some firewall and network
# systems. Also notice that simplebackup will automatically switch the mode
# after the third connection failure (check the [ network_connect_retries ]
# configuration key value).
#
# Default value is: no
# Valid values are: yes ; no
#ftp_passive_mode = no


#
# [ SFTP transport type (Secure FTP advanced parameters) ]
#
# How of sftp connection will be made, during sftp backups or restores.
# SFTP connections are complex things and to be flexible simplebackup can
# use one of several methods to connected into the ssh/sftp server.
#
# Under Windows operating system simplebackup usually use the putty psftp
# program that is included in the putty ssh package, you can use the program
# included in the simplebackup package or download it from
# [ http://www.chiark.greenend.org.uk/~sgtatham/putty/download.html ].
# Notice nothing needs to be installed if you are using the Win32 Compiled
# version, [ simplebackup.exe ], the putty psftp program is build in, sftp
# just works.
#
# If you are using the auto value simplebackup under Windows will use the
# psftp (Putty psftp program) and under a Unix system it will use the
# sftp (Open ssh sftp program ).
#
# Future simplebackup versions might support build in sftp support using,
# for example the Net::SSH2 or the Net::SFTP perl modules.
#
# Notice it's advised to use the auto value.
#
# Default value is: auto
# Valid values are: auto ; sftp ; psftp
#sftp_transport = auto


#
# [ SFTP private key file (Secure FTP advanced parameters) ]
#
# The full path into a private key file. This should only be used if you
# are using secure ftp backups with using putty psftp program.
# This is a Windows only configuration key, unix users should ignore it
# Windows users should only use it if they want to to access the remote ssh
# server using a public/private key and if a valid private key file
# was using the putty puttygen program.
#
# Valid values are: any valid full path into a putty private key file.
#psftp_private_key_file = some_file


#
# [ Execute before tape writing (Tape advanced parameters) ]
#
# Command or commands to execute before starting to write into the tape
# device.
#
# Default value is: [ mt -t your_tape_device rewind ]
# Valid values are: any command ; none (if you don't want to run anything)
#tape_before_backup = none


#
# [ Execute after tape writing (Tape advanced parameters) ]
#
# Command or commands to execute after ending writing into the tape
# device.
# Notice this only runs if you are doing a backup into a tape device
# and if the tape was used to backup at least one backup file.
#
# Default value is: [ mt -t your_tape_device offline ]
# Valid values are: any command ; none (if you don't want to run anything)
#tape_after_backup = mt -t your_tape_device offline


#
# [ Hostname on backup files ]
#
# If you want to to include the hostname of the machine where simplebackup is
# running on each generated backup file, and auxiliary files (if using the
# auto option) such has log file and the support file(s).
#
# Notice if you change this after running one or more backups and if the
# support file(s) are configured has auto then you must rename them into the
# name(s) reported by simplebackup during the configuration file testing
# (simplebackup --tconf YOUR_CONFIG_FILE.CONF). If you fail to do this
# simplebackup will no longer managed the backup files created and will not
# be able to restore them.
#
# Default value is: no
# Valid values are: yes ; no
#hostname_on_backup_files = no


#
# [ Username on backup files ]
#
# If you want to to include the username of the machine where simplebackup is
# running on each generated backup file, and auxiliary files (if using the
# auto option) such has log file and the support file(s).
#
# Notice if you change this after running one or more backups and if the
# support file(s) are configured has auto then you must rename them into the
# name(s) reported by simplebackup during the configuration file testing
# (simplebackup --tconf YOUR_CONFIG_FILE.CONF). If you fail to do this
# simplebackup will no longer managed the backup files created and will not
# be able to restore them.
#
# Default value is: no
# Valid values are: yes ; no
#username_on_backup_files = no


#
# [Pass log to external command ]
#
# This will enable simplebackup to pass the backup and restore logs into any
# desired command using the standard input (stdin).
# Your command must accept input from the stdin and then do what ever it
# wants to do with it (example print the backup log on a unix systen using
# using lp command).
# Notice this is similar to doing:
#   in unix ...: cat my_file.log | my_command -arguments
#   in windows : type my_file.log | my_command /arguments
#
# Valid values are: any valid command that accesses input from stdin
#                   (standard input)
#pass_log_to_external_cmd =


#
# [ Screen height ]
#
# Number of lines that the console/terminal has.
# This is only relevant when dealing with the backup lists or the restore
# menu
#
# Default value is: 24
# Valid values are: any number over or iqual to 24, example 24
#screen_height = 24
EOF
                print "File was successfully generated\n";
                close (configuration_file_handle); # close the file
            }
            else {
                print "[ Error ], unable to write the new configuration file\n\n";
            }
        }
    }

    if ( $error_flag == 0 and -f $file_path ) { # if file exists and no error occured
        my $try_edit =""; # contain the operating system edit command
        $try_edit = "vi \"$file_path\"" if ( get_os_type() eq "unix" ); # attempt to use the operating system vi command
        $try_edit = "notepad \"$file_path\"" if ( get_os_type() ne "unix" ); # attempt to use the operating system notepad command
        print "Editing the file using [ $try_edit ]\n";
        exec ($try_edit) or $error_flag = 1; # execute the command, with exec so simplebackup will not detect a non existing problem
        print "[ Error ], unable to edit the file, please attempt to edit the configuration file using any standard ascii text editor.\n\n" if ( $error_flag != 0);
    }

    return $error_flag; # always return success
}


#
# Test the command line parameters/commands
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub test_commands {

    my @parameters = @_; # the prompt parameters
    # scalar counts a array, please notice that the restore parameter is tested in the test_and_prepare_restore_config() function
    if ( scalar(@parameters) == 0 ) {
        return 1; # return failure
    }
    elsif ( $parameters[0] ne "--rconf" and $parameters[0] ne "--sconf" and (scalar(@parameters) != 2 or ($parameters[0] ne "--conf" and $parameters[0] ne "--tconf" and $parameters[0] ne "--econf" and $parameters[0] ne "--lconf" and $parameters[0] ne "--ffconf" and $parameters[0] ne "--clconf")) ) {
        return 1; # return failure
    }
    elsif ( $parameters[0] eq "--sconf" and scalar(@parameters) != 2 and scalar(@parameters) != 4 ) { # test if the sconf option has the correct argument numbers
        return 1; # return failure
    }
    elsif ( $parameters[0] eq "--sconf" and scalar(@parameters) == 4 and ( !($parameters[3] =~ /^\d+$/) or $parameters[3] <= 0 ) ) { # test if the sconf option has a valid session number
        return 1; # return failure
    }
    else { # use of the --rconf parameter (restore)
        if ( $parameters[0] eq "--rconf" and test_and_prepare_restore_config("stdout", \@parameters) != 0 ) { # test the restore parameters
            return 1; # return failure
        }
        return 0; # return success
    }
}


#
# Read (and test) the configuration file into the global var %GLOBAL_CONFIG
# Will return: 0 ; 1 ; 2 ; 3 ; 4 ; 5 ; 6 ; 7 ; 8 ; 9 ; 10 ; 11 ; 12 ; 13 ; 14 ; 15 ; 16 ; 17 ; 18 ; 19 ; 20 ; 21 ; 22 ; 23 ; 24 ; 25 ; 26 ; 27 ; 28 ; 29 ; 30 ; 31 ; 32 ; 33 ; 34 ; 35 ; 36 ; 37 ; 38 ; 39 ; 40 ; 41 ; 42 ; 43 ; 44 ; 45 ; 46 ; 47 ; 48 ; 49 ; 50 ; 51 ; 52 ; 53 ; 54 ; 55
# Explain: 0 is success ; any other is failure
sub read_config {

    my $cmd_argument = $_[0]; # what operation simplebackup will make (--conf ; --rconf ; --lconf ; --ffconf ; --tconf ; etc)
    my $file_path = $_[1]; # this is the first function parameter $_[1] is the second etc etc etc
    my $global_config_p = $_[2]; # pointer into the configuration hash
    my $error_flag = 0; # file error flag
    my $error_file_directory = ""; # to keep the description of which directory/file failed

    $$global_config_p{configuration_file} = $file_path; # path into the configuration file used

    # open file in read mode ( < )
    open(config_file_handle, "<$file_path") or $error_flag = 1;
    if ( $error_flag == 0 ) {
        # read the entire config file line by line
        while(<config_file_handle>) {
            # enter only if there is the = char on the set and the char # is NOT on the begining of the line
            if ( $_ =~ /=/ and not $_ =~ /^#/ ) {

                my ( $config_key, $config_value ) = split ( /=/, $_,2); # split the line into the configuration key and the configuration value, limit is 2 meaning it will only split the first = char, the oracle exp command uses = (file=named.dmp) and causes problems
                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                $config_value =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                $config_value =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line

                # use a switch / case this is not a real perl function but it works
                # this will be used to load the global configuration hash
                switch: {
                   $config_key eq "host_os" && do {
                                        $$global_config_p{host_os} = lc $config_value;
                                        $$global_config_p{host_os} = "winnt4/win2000/xp/2003" if ($$global_config_p{host_os} eq "winnt4" or $$global_config_p{host_os} eq "win2000/xp" or $$global_config_p{host_os} eq "win2000/xp/2003"); # this is done to maintain compatibility with previous simplebackup versions
                                    };
                   $config_key eq "debug_level" && do {
                                        $$global_config_p{debug_level} = lc $config_value;
                                    };
                   $config_key eq "backup_mode" && do {
                                       $$global_config_p{backup_mode} = lc $config_value;
                                       $$global_config_p{backup_real_mode} = lc $config_value;
                                    };
                   $config_key eq "full_backup_day" && do {
                                       $$global_config_p{full_backup_day} = lc $config_value;
                                    };
                   $config_key eq "text_note" && do {
                                       $$global_config_p{text_note} = $config_value;
                                    };
                   $config_key eq "backup_full_path_rejections" && do {
                                        $$global_config_p{backup_full_path_rejections} = $config_value;
                                        $$global_config_p{backup_full_path_rejections} = remove_excess_spaces($$global_config_p{backup_full_path_rejections}, "<" ) if $$global_config_p{backup_full_path_rejections} ne "";
                                    };
                   $config_key eq "backup_extension_rejections" && do {
                                       $$global_config_p{backup_extension_rejections} = $config_value;
                                       $$global_config_p{backup_extension_rejections} = remove_excess_spaces($$global_config_p{backup_extension_rejections}, "," ) if $$global_config_p{backup_extension_rejections} ne "";
                                    };
                   $config_key eq "backup_filenames_rejections" && do {
                                       $$global_config_p{backup_filenames_rejections} = $config_value;
                                       $$global_config_p{backup_filenames_rejections} = remove_excess_spaces($$global_config_p{backup_filenames_rejections}, "," ) if $$global_config_p{backup_filenames_rejections} ne "";
                                    };
                   $config_key eq "backup_file_size_limit" && do {
                                       $$global_config_p{backup_file_size_limit} = $config_value;
                                    };
                   $config_key eq "compressed_file_size_limit" && do {
                                       $$global_config_p{compressed_file_size_limit} = $config_value;
                                    };
                   $config_key eq "backup_mail_attachment_method" && do {
                                       $$global_config_p{backup_mail_attachment_method} = lc $config_value;
                                    };
                   $config_key eq "backup_format" && do {
                                       $$global_config_p{backup_format} = lc $config_value;
                                       $$global_config_p{backup_format} = "tar.Z" if ( $$global_config_p{backup_format} eq "tar.z" ); # work around the .Z (compress format) that requires a upper case .Z extension
                                       $$global_config_p{backup_format} = "advanced_tar.Z" if ( $$global_config_p{backup_format} eq "advanced_tar.z" ); # work around the .Z (compress format) that requires a upper case .Z extension
                                       $$global_config_p{backup_format_details} = $$global_config_p{backup_format}; # keep this format... might be required in the future (presently for the gnu tar)
                                       # fix the gnu tar extension if required
                                       $$global_config_p{backup_format} = "tar" if ( $$global_config_p{backup_format} eq "advanced_tar" );
                                       $$global_config_p{backup_format} = "tar.Z" if ( $$global_config_p{backup_format} eq "advanced_tar.Z" );
                                       $$global_config_p{backup_format} = "tar.gz" if ( $$global_config_p{backup_format} eq "advanced_tar.gz" );
                                       $$global_config_p{backup_format} = "tar.bz2" if ( $$global_config_p{backup_format} eq "advanced_tar.bz2" );
                                     };
                   $config_key eq "backup_type" && do { # backward compatibility with simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1
                                        if ( $$global_config_p{backup_format} eq "" ) {
                                            $$global_config_p{backup_format} = lc $config_value;
                                        }
                                     };
                   $config_key eq "backup_compression_ratio" && do {
                                        $$global_config_p{backup_compression_ratio} = lc $config_value;
                                     };
                   $config_key eq "input_backup" && do {
                                        $$global_config_p{input_backup} = $config_value;
                                        $$global_config_p{input_backup} = remove_excess_spaces($$global_config_p{input_backup}, "<" ) if $$global_config_p{input_backup} ne "";
                                    };
                   $config_key eq "input_backup_dirs" && do { # backward compatibility with simplebackup 1.3.0, 1.3.1, 1.4.0, 1.4.1
                                        if ( $$global_config_p{input_backup} eq "" ) {
                                            $$global_config_p{input_backup} = $config_value;
                                            $$global_config_p{input_backup} = remove_excess_spaces($$global_config_p{input_backup}, "<" ) if $$global_config_p{input_backup} ne "";
                                        }
                                    };
                   $config_key eq "input_backup_dir" && do { # backward compatibility with simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1
                                        if ( $$global_config_p{input_backup} eq "" ) {
                                            $$global_config_p{input_backup} = $config_value;
                                            $$global_config_p{input_backup} = remove_excess_spaces($$global_config_p{input_backup}, "<" ) if $$global_config_p{input_backup} ne "";
                                        }
                                    };
                   $config_key eq "output_backup" && do {
                                        $$global_config_p{output_backup} = $config_value;
                                    };
                   $config_key eq "output_backup_dir" && do { # backward compatibility with simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1
                                        if ( $$global_config_p{output_backup} eq "" ) {
                                            $$global_config_p{output_backup} = $config_value;
                                        }
                                    };
                   $config_key eq "temporary_dir" && do {
                                        $$global_config_p{temporary_dir} = $config_value;
                                    };
                   $config_key eq "keep_last_n_files" && do {
                                        $$global_config_p{keep_last_n_files} = $config_value;
                                    };
                   $config_key eq "run_before_backup" && do {
                                        $$global_config_p{run_before_backup} = $config_value;
                                    };
                   $config_key eq "run_backup_on_failure_run_before_backup" && do {
                                        $$global_config_p{run_backup_on_failure_run_before_backup} = lc $config_value;
                                    };
                   $config_key eq "run_before_arguments" && do { # backward compatibility simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1
                                        $config_value =~ s/( )\1/$1/g; # s/ search  /( ) for spaces  \1 first double chars... first double spaces     /$1 replace with first char in this case always a space  /g global to all string
                                        if ( $config_value ne "" ) { # detect empty arguments
                                            $$global_config_p{run_before_backup} = $$global_config_p{run_before_backup} . " " . $config_value;
                                        }
                                    };
                   $config_key eq "run_after_restore" && do {
                                        $$global_config_p{run_after_restore} = $config_value;
                                    };
                   $config_key eq "run_after_backup" && do {
                                        $$global_config_p{run_after_backup} = $config_value;
                                    };
                   $config_key eq "run_after_arguments" && do { # backward compatibility simplebackup 1.0.0, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1
                                        $config_value =~ s/( )\1/$1/g; # s/ search  /( ) for spaces  \1 first double chars... first double spaces     /$1 replace with first char in this case always a space  /g global to all string
                                        if ( $config_value ne "" ) { # detect empty arguments
                                            $$global_config_p{run_after_backup} = $$global_config_p{run_after_backup} . " " . $config_value;
                                        }
                                    };
                   $config_key eq "on_failure_run_after_backup" && do {
                                        $$global_config_p{on_failure_run_after_backup} = lc $config_value;
                                    };
                   $config_key eq "run_before_restore" && do {
                                        $$global_config_p{run_before_restore} = $config_value;
                                    };
                   $config_key eq "run_restore_on_failure_run_before_restore" && do {
                                        $$global_config_p{run_restore_on_failure_run_before_restore} = lc $config_value;
                                    };
                   $config_key eq "run_after_restore" && do {
                                        $$global_config_p{run_after_restore} = $config_value;
                                    };
                   $config_key eq "on_failure_run_after_restore" && do {
                                        $$global_config_p{on_failure_run_after_restore} = lc $config_value;
                                    };
                   $config_key eq "log_file" && do {
                                        if ( lc $config_value ne "none" ) {
                                            $$global_config_p{log_file} = $config_value;
                                        }
                                        else {
                                            $$global_config_p{log_file} = "none";
                                        }
                                    };
                   $config_key eq "ftp_debug_level" && do { # backward compatibility simplebackup 1.5.0, 1.5.1
                                        $config_value = lc $config_value;
                                        if ( ($config_value eq "none" or $config_value eq "full") and $$global_config_p{debug_level} eq "" ) { # backward compatibilty with older simplebackup versions
                                            $$global_config_p{debug_level} = $config_value;
                                        }
                                    };
                   $config_key eq "ftp_passive_mode" && do {
                                        $$global_config_p{ftp_passive_mode} = lc $config_value;
                                    };
                   $config_key eq "ftp_timeout" && do { # backward compatibility simplebackup older than 1.8.0
                                        $$global_config_p{network_timeout} = $config_value if ( $$global_config_p{network_timeout} eq "" );
                                    };
                   $config_key eq "ftp_proxy" && do {
                                        $$global_config_p{network_proxy} = $config_value if ( $$global_config_p{network_proxy} eq "" );
                                    };
                   $config_key eq "ftp_connect_retries" && do { # backward compatibility simplebackup older than 1.8.0
                                        $$global_config_p{network_connect_retries} = $config_value if ( $$global_config_p{network_connect_retries} eq "" );
                                    };
                   $config_key eq "tape_before_backup" && do {
                                        $$global_config_p{tape_before_backup} = $config_value;
                                    };
                   $config_key eq "tape_after_backup" && do {
                                        $$global_config_p{tape_after_backup} = $config_value;
                                    };
                   $config_key eq "mail_server" && do {
                                        $$global_config_p{mail_server} = $config_value;
                                    };
                   $config_key eq "mail_debug_level" && do { # backward compatibility simplebackup 1.5.0, 1.5.1
                                        $config_value = lc $config_value;
                                        if ( ($config_value eq "none" or $config_value eq "full") and $$global_config_p{debug_level} eq "" ) { # backward compatibilty with older simplebackup versions
                                            $$global_config_p{debug_level} = $config_value;
                                        }
                                    };
                   $config_key eq "mail_port" && do {
                                        $$global_config_p{mail_port} = $config_value;
                                    };
                   $config_key eq "mail_timeout" && do { # backward compatibility simplebackup older than 1.8.0
                                        $$global_config_p{network_timeout} = $config_value;
                                    };
                   $config_key eq "network_timeout" && do {
                                        $$global_config_p{network_timeout} = $config_value;
                                    };
                   $config_key eq "network_connect_retries" && do {
                                        $$global_config_p{network_connect_retries} = $config_value;
                                    };
                   $config_key eq "network_proxy" && do {
                                        $$global_config_p{network_proxy} = $config_value;
                                    };
                   $config_key eq "mail_from_address" && do {
                                        $$global_config_p{mail_from_address} = $config_value;
                                    };
                   $config_key eq "mail_to_addresses" && do {
                                        $$global_config_p{mail_to_addresses} = $config_value;
                                        $$global_config_p{mail_to_addresses} = remove_excess_spaces($$global_config_p{mail_to_addresses}, ",") if $$global_config_p{mail_to_addresses} ne "";
                                    };
                   $config_key eq "mail_username" && do {
                                        $$global_config_p{mail_username} = $config_value;
                                    };
                   $config_key eq "mail_password" && do {
                                        $$global_config_p{mail_password} = $config_value;
                                    };
                   $config_key eq "encryption_passwd" && do {
                                        $$global_config_p{encryption_passwd} = $config_value;;
                                    };
                   $config_key eq "encryption_crypt" && do {
                                        $$global_config_p{encryption_crypt} = $config_value;
                                    };
                   $config_key eq "encryption_level" && do {
                                        $$global_config_p{encryption_level} = lc $config_value;;
                                    };
                   $config_key eq "pass_log_to_external_cmd" && do {
                                        $$global_config_p{pass_log_to_external_cmd} = $config_value;
                                    };
                   $config_key eq "hostname_on_backup_files" && do {
                                        $$global_config_p{hostname_on_backup_files} = lc $config_value;
                                    };
                   $config_key eq "username_on_backup_files" && do {
                                        $$global_config_p{username_on_backup_files} = lc $config_value;
                                    };
                   $config_key eq "backup_support_file_copy1" && do {
                                        $$global_config_p{backup_support_file_copy1} = $config_value;
                                    };
                   $config_key eq "backup_support_file_copy2" && do {
                                        if ( lc $config_value ne "none" ) {
                                            $$global_config_p{backup_support_file_copy2} = $config_value;
                                        }
                                        else {
                                            $$global_config_p{backup_support_file_copy2} = "none";
                                        }
                                    };
                   $config_key eq "backup_support_file_copy3" && do {
                                        if ( lc $config_value ne "none" ) {
                                            $$global_config_p{backup_support_file_copy3} = $config_value;
                                        }
                                        else {
                                            $$global_config_p{backup_support_file_copy3} = "none";
                                        }
                                    };
                   $config_key eq "backup_list_on_log" && do {
                                        $$global_config_p{backup_list_on_log} = lc $config_value;
                                    };
                   $config_key eq "restore_list_on_log" && do {
                                        $$global_config_p{restore_list_on_log} = lc $config_value;
                                    };
                   $config_key eq "sftp_transport" && do {
                                        $$global_config_p{sftp_transport} = lc $config_value;
                                    };
                   $config_key eq "psftp_private_key_file" && do {
                                        $$global_config_p{psftp_private_key_file} = $config_value;
                                    };
                   $config_key eq "screen_height" && do {
                                        $$global_config_p{screen_height} = $config_value;
                                    };
                   $config_key eq "backup_list_encoding" && do {
                                        $$global_config_p{backup_list_encoding} = lc $config_value;
                                    };
                   $config_key eq "restore_list_encoding" && do {
                                        $$global_config_p{restore_list_encoding} = lc $config_value;
                                    };
                }
            }
        }
        # close file
        close (config_file_handle);
    }

    # configure the apropriate backup mode
    switch: {
            ( lc(substr($$global_config_p{output_backup},0,6)) ne "ftp://" and lc(substr($$global_config_p{output_backup},0,7)) ne "sftp://" and lc(substr($$global_config_p{output_backup},0,7)) ne "tape://" and lc(substr($$global_config_p{output_backup},0,7)) ne "smtp://" ) && do {
                $$global_config_p{backup_working} = "local file system"; # local file system backup mode (ex. /my_directory or d:\my_directory)
            };
            ( lc(substr($$global_config_p{output_backup},0,6)) eq "ftp://" ) && do {
                $$global_config_p{backup_working} = "ftp"; # ftp backup mode
            };
            ( lc(substr($$global_config_p{output_backup},0,7)) eq "sftp://" ) && do {
                $$global_config_p{backup_working} = "sftp"; # sftp backup mode
            };
            ( lc(substr($$global_config_p{output_backup},0,7)) eq "http://" ) && do {
                $$global_config_p{backup_working} = "http-dav"; # http dav backup mode
            };
            ( lc(substr($$global_config_p{output_backup},0,7)) eq "tape://" ) && do {
                $$global_config_p{backup_working} = "tape"; # tape backup mode
            };
            ( lc(substr($$global_config_p{output_backup},0,7)) eq "smtp://" ) && do {
                $$global_config_p{backup_working} = "smtp"; # smtp/email backup mode
                $$global_config_p{backup_mail_type} = "smtp"; # backup mail type
            };
    }

    # Test the debug level
    $$global_config_p{debug_level} = "none" if $$global_config_p{debug_level} eq "";
    if ( $error_flag == 0 and ($$global_config_p{debug_level} ne "none" and $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full") ) {
        $error_flag = 36; # invalid debug level
    }
    else { # configure the debug levels
        # configure the debug level for ftp & mail
        $$global_config_p{ftp_debug_level} = "none" if ( $$global_config_p{debug_level} eq "none" or $$global_config_p{debug_level} eq "half"); # default value
        $$global_config_p{sftp_debug_level} = "none" if ( $$global_config_p{debug_level} eq "none" or $$global_config_p{debug_level} eq "half"); # default value
        $$global_config_p{mail_debug_level} = "none" if ( $$global_config_p{debug_level} eq "none" or $$global_config_p{debug_level} eq "half"); # default value
        $$global_config_p{dav_debug_level} = "none" if ( $$global_config_p{debug_level} eq "none" or $$global_config_p{debug_level} eq "half"); # default value
        $$global_config_p{ftp_debug_level} = "full" if ( $$global_config_p{debug_level} eq "full" ); # default value
        $$global_config_p{sftp_debug_level} = "full" if ( $$global_config_p{debug_level} eq "full" ); # default value
        $$global_config_p{mail_debug_level} = "full" if ( $$global_config_p{debug_level} eq "full" ); # default value
        $$global_config_p{dav_debug_level} = "full" if ( $$global_config_p{debug_level} eq "full" ); # default value
        # check the real email debug level
        if ( $$global_config_p{mail_debug_level} eq "none" ) {
            $$global_config_p{mail_debug_level_real} = 0; # no debug
        }
        else {
            $$global_config_p{mail_debug_level_real} = 1; # full debug
        }
        # check the real ftp debug level
        if ( $$global_config_p{ftp_debug_level} eq "none" ) {
            $$global_config_p{ftp_debug_level_real} = 0; # no debug
        }
        else {
            $$global_config_p{ftp_debug_level_real} = 1; # full debug
        }
        # check the real sftp debug level
        if ( $$global_config_p{sftp_debug_level} eq "none" ) {
            $$global_config_p{sftp_debug_level_real} = 0; # no debug
        }
        else {
            $$global_config_p{sftp_debug_level_real} = 1; # full debug
        }
        # check the real http dav debug level
        if ( $$global_config_p{dav_debug_level} eq "none" ) {
            $$global_config_p{dav_debug_level_real} = 0; # no debug
        }
        else {
            $$global_config_p{dav_debug_level_real} = 2; # full debug
        }
    }

    # test operating system host values, valid is auto ; winnt4/win2000/xp/2003 ; unix
    $$global_config_p{host_os} = get_os_type() if ( $$global_config_p{host_os} eq "" or $$global_config_p{host_os} eq "auto" ); # autodetect the operating system if required
    if ( $error_flag == 0 and ($$global_config_p{host_os} ne "winnt4/win2000/xp/2003" and $$global_config_p{host_os} ne "unix") ) {
        $error_flag = 3; # invalid operating system
    }
    elsif ( $error_flag == 0 ) { # configure the null device
        # Delete trailing \ or / char same thing kind of but $ represents end of line + represents any \ or / chars
        $$global_config_p{temporary_dir} =~ s/[\\\/]+$// if ( $$global_config_p{temporary_dir} ne "/" and ( (length($$global_config_p{temporary_dir}) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix" ) ); # if not the / or a local drive (in windows) example D:\
        $$global_config_p{output_backup} =~ s/[\\\/]+$// if ( $$global_config_p{backup_working} eq "local file system" and $$global_config_p{output_backup} ne "/" and ( (length($$global_config_p{output_backup}) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix") );
        if ( $$global_config_p{host_os} eq "unix" ) { # unix null device
            $$global_config_p{host_null_device} = "2>/dev/null";
            $$global_config_p{host_stdout_null_device} = "1>/dev/null";
            $$global_config_p{host_file_separator} = "/";
        }
        else { # microsoft null device ; microsoft file separator and lower case any available rejections
            $$global_config_p{host_null_device} = "2>nul";
            $$global_config_p{host_stdout_null_device} = "1>nul";
            $$global_config_p{host_file_separator} = "\\";
            $$global_config_p{temporary_dir} = lc $$global_config_p{temporary_dir}; # under windows so do a lowercase of this
            $$global_config_p{output_backup} = lc $$global_config_p{output_backup} if $$global_config_p{backup_working} eq "local file system"; # under windows so do a lowercase of this if it's a directory
        }
        # get just the configuration file name
        $$global_config_p{configuration_file_name} = get_filedir_name("$$global_config_p{configuration_file}", $global_config_p);
    }

    $$global_config_p{hostname} = hostname(); # configure the hostname
    $$global_config_p{hostname} = "unavailable" if ( !(defined $$global_config_p{hostname}) or $$global_config_p{hostname} eq ""); # if we cannot get the hostname of this machine replaced it by "unavailable"
    if ( $error_flag == 0 ) {
        # Check the hostname on backup files
        if ( $$global_config_p{hostname_on_backup_files} eq "" ) {
            $$global_config_p{hostname_on_backup_files}  = "no"; # change to default value
        }
        if ( $$global_config_p{hostname_on_backup_files} ne "no" and $$global_config_p{hostname_on_backup_files} ne "yes" ) {
            $error_flag = "63"; # mark error invalid value
        }
    }

    $$global_config_p{username} = get_username(); # configure the username running backup/restore
    if ( $error_flag == 0 ) {
        # Check the username on backup files
        if ( $$global_config_p{username_on_backup_files} eq "" ) {
            $$global_config_p{username_on_backup_files}  = "no"; # change to default value
        }
        if ( $$global_config_p{username_on_backup_files} ne "no" and $$global_config_p{username_on_backup_files} ne "yes" ) {
            $error_flag = "64"; # mark error invalid value
        }
    }

    # read the backup file list (if required)
    if ( substr($$global_config_p{input_backup},0,8) eq "file://@" ) {
        my ( $list_config_key, $list_file_path ) = split ( /@/, $$global_config_p{input_backup}); # get the file path
        $error_file_directory = "$list_file_path";
        if ( check_if_full_path($list_file_path, $$global_config_p{host_os}, $global_config_p) != 0 or !-f $list_file_path ) {
            $error_flag = 12; # not a full path or file does not exists
        }
        else { # file is a full path, open and load the backup list
            open(list_file_handle, "<$list_file_path") or $error_flag = 13; # open file in read mode
            if ( $error_flag == 0 ) {
                $$global_config_p{input_backup} = ""; # clear the file path
                while(<list_file_handle>) { # read the entire file into the array
                    chomp($_); # remove the new line chars
                    if ( $_ !~ /^#/ ) { # read only if there is no # char on the start of the line
                        $_ =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                        $_ =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                        if ( $$global_config_p{input_backup} ne "" ) { # if not first line of file
                            $$global_config_p{input_backup} = $$global_config_p{input_backup} . "<" . $_;
                        }
                        else { # if first line
                            $$global_config_p{input_backup} = $_;
                        }
                    }
                }
                close(list_file_handle);
            }
        }
    }

    # test if the file was correctly loaded   used eq and not == because we are using strings
    if ( $error_flag == 0 and ( $$global_config_p{backup_format} eq "" or $$global_config_p{input_backup} eq "" or $$global_config_p{output_backup} eq "" or $$global_config_p{keep_last_n_files} eq "" ) ) {
        $error_flag = 2; # mark corrupted file
    }

    # search for invalid chars, in this case the * char
    if ( $error_flag == 0 and ( $$global_config_p{psftp_private_key_file} =~ /\*/ or $$global_config_p{backup_support_file_copy1} =~ /\*/ or $$global_config_p{backup_support_file_copy2} =~ /\*/ or $$global_config_p{backup_support_file_copy3} =~ /\*/  or $$global_config_p{backup_extension_rejections} =~ /\*/ or $$global_config_p{backup_filenames_rejections} =~ /\*/ or $$global_config_p{input_backup} =~ /\*/ or $$global_config_p{temporary_dir} =~ /\*/ or $$global_config_p{run_before_backup} =~ /\*/ or $$global_config_p{run_after_backup} =~ /\*/ or $$global_config_p{log_file} =~ /\*/) ) { # protection against using the * char
        $error_flag = 2; # mark corrupted file
    }

    # test backup type is valid
    if ( $error_flag == 0 and ($$global_config_p{backup_format} ne "rar" and $$global_config_p{backup_format} ne "7z" and $$global_config_p{backup_format} ne "zip" and $$global_config_p{backup_format} ne "tar.Z" and $$global_config_p{backup_format} ne "tar.bz2" and $$global_config_p{backup_format} ne "tar.gz" and $$global_config_p{backup_format} ne "tar") ) {
        $error_flag = 4; # invalid backup type
    }

    $$global_config_p{backup_compression_ratio} = "maximal" if ( $$global_config_p{backup_compression_ratio} eq "" );
    $$global_config_p{backup_real_ratio} = 0; # default no compression
    # test if backup ratio is valid
    if ( $error_flag == 0 and ($$global_config_p{backup_compression_ratio} ne "none" and $$global_config_p{backup_compression_ratio} ne "minimal" and $$global_config_p{backup_compression_ratio} ne "average" and $$global_config_p{backup_compression_ratio} ne "maximal" )) {
        $error_flag = 5; # invalid backup ratio
    }
    elsif ( $error_flag == 0 ) { # valid backup ratio set the real value that is going to get passed into the compressor
        switch: {
            $$global_config_p{backup_compression_ratio} eq "none" && do { # no compression
                            if ( $$global_config_p{backup_format} ne "rar" and $$global_config_p{backup_format} ne "7z" and $$global_config_p{backup_format} ne "zip" ) {
                                $$global_config_p{backup_real_ratio} = 1; # almost no compression, none is not avaliable for bzip2, and gzip
                            }
                        };
            $$global_config_p{backup_compression_ratio} eq "minimal" && do { # minimal
                            $$global_config_p{backup_real_ratio} = 1; # equal to all compressors
                        };
            $$global_config_p{backup_compression_ratio} eq "average" && do { # average compression
                            if ( $$global_config_p{backup_format} eq "rar" ) {
                                $$global_config_p{backup_real_ratio} = 3; # average, just for rar
                            }
                            elsif ( $$global_config_p{backup_format} eq "7z" ) {
                                $$global_config_p{backup_real_ratio} = 5; # average, just for 7-zip
                            }
                            else {
                                $$global_config_p{backup_real_ratio} = 6; # all others use this
                            }
                        };
            $$global_config_p{backup_compression_ratio} eq "maximal" && do { # average compression
                            if ( $$global_config_p{backup_format} eq "rar" ) {
                                $$global_config_p{backup_real_ratio} = 5; # max just for rar
                            }
                            else {
                                $$global_config_p{backup_real_ratio} = 9; # all others use this
                            }
                        };
        }
    }

    # check if we are using valid path's ... / for unix host system \ for microsoft systems
    if ( $error_flag == 0 and ( $$global_config_p{host_os} eq "unix" and ($$global_config_p{input_backup} =~ /\\/ or $$global_config_p{output_backup} =~ /\\/ or $$global_config_p{temporary_dir} =~ /\\/ or $$global_config_p{log_file} =~ /\\/ or $$global_config_p{backup_support_file_copy1} =~ /\\/ or $$global_config_p{backup_support_file_copy2} =~ /\\/ or $$global_config_p{backup_support_file_copy3} =~ /\\/ or $$global_config_p{psftp_private_key_file} =~ /\\/ ) )) {
        $error_flag = 6; # Using microsoft type of paths \ on a unix system
    }

    # check if we are using valid path's ... / for unix host system \ for microsoft systems
    if ( $error_flag == 0 and ( $$global_config_p{host_os} ne "unix" and ( $$global_config_p{input_backup} =~ /[\/]/ or ($$global_config_p{output_backup} =~ /[\/]/ and $$global_config_p{backup_working} eq "local file system") or $$global_config_p{temporary_dir} =~ /[\/]/ or $$global_config_p{log_file} =~ /[\/]/ or $$global_config_p{backup_support_file_copy1} =~ /[\/]/ or $$global_config_p{backup_support_file_copy2} =~ /[\/]/ or $$global_config_p{backup_support_file_copy3} =~ /[\/]/ or $$global_config_p{psftp_private_key_file} =~ /[\/]/ ) )) {
        $error_flag = 7; # Unix unix type of paths / on a microsoft system
    }

    # test if the backup destiny directory is full path
    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "local file system" and (check_if_full_path($$global_config_p{output_backup}, $$global_config_p{host_os}, $global_config_p) != 0) ) {
        $error_file_directory = "Backup destination directory";
        $error_flag = 8; # mark directory not full path
    }

    # check backup mode
    $$global_config_p{backup_mode} = "full" if $$global_config_p{backup_mode} eq ""; # backward compatibity
    if ( $error_flag == 0 and ($$global_config_p{backup_mode} ne "full" and $$global_config_p{backup_mode} ne "incremental" and $$global_config_p{backup_mode} ne "differential") ) {
        $error_flag = 28; # mark error, invalid backup mode
    }

    # test if the backup temporary directory exists
    $$global_config_p{temporary_dir} = get_tmp_dir($$global_config_p{host_os}) if ( $$global_config_p{temporary_dir} eq "" or $$global_config_p{temporary_dir} eq "auto");
    if ( $error_flag == 0 and check_if_full_path($$global_config_p{temporary_dir}, $$global_config_p{host_os}, $global_config_p) != 0 ) {
        $error_file_directory = "Temporary directory";
        $error_flag = 8; # mark directory not defined has a full path
    }
    elsif ( $error_flag == 0 ) { # temporary directory defined has a full path, configure (if required by using the auto or empty parameter) the auxiliar files
        my $my_hostname_username = "";
        if ( $$global_config_p{hostname_on_backup_files} eq "yes" ) { # if we are including the hostname on the backup file names
            $my_hostname_username = $$global_config_p{hostname};
        }
        if ( $$global_config_p{username_on_backup_files} eq "yes" ) { # if we are including the username on the backup file names
            if ( $my_hostname_username eq "" ) {
                $my_hostname_username = $$global_config_p{username};
            }
            else {
                $my_hostname_username = $my_hostname_username . "." . $$global_config_p{username};
            }
        }
        # if the log file is configured to be automaticly named
        if ( $$global_config_p{log_file} eq "" or $$global_config_p{log_file} eq "auto" ) {
            $$global_config_p{log_file} = rebuild_full_path("$$global_config_p{temporary_dir}", "$$global_config_p{configuration_file_name}.log", $global_config_p) if $my_hostname_username eq ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are not incluing the hostname on the backup files
            $$global_config_p{log_file} = rebuild_full_path("$$global_config_p{temporary_dir}", "$my_hostname_username.$$global_config_p{configuration_file_name}.log", $global_config_p) if $my_hostname_username ne ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are incluing the hostname on the backup files
        }

        $$global_config_p{backup_support_file_copy1} = "auto" if ( $$global_config_p{backup_support_file_copy1} eq "" ); # force a auto mode if required for the support file (copy 1)
        $$global_config_p{backup_support_file_copy2} = "auto" if ( $$global_config_p{backup_support_file_copy2} eq "" ); # force a auto mode if required for the support file (copy 2)
        $$global_config_p{backup_support_file_copy3} = "auto" if ( $$global_config_p{backup_support_file_copy3} eq "" ); # force a auto mode if required for the support file (copy 2)
        if ( $$global_config_p{backup_support_file_copy1} eq "auto" ) {
            $$global_config_p{backup_support_file_copy1} = rebuild_full_path("$$global_config_p{temporary_dir}", "$$global_config_p{configuration_file_name}.support_file_copy1.db", $global_config_p) if $my_hostname_username eq ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are not incluing the hostname on the backup files
            $$global_config_p{backup_support_file_copy1} = rebuild_full_path("$$global_config_p{temporary_dir}", "$my_hostname_username.$$global_config_p{configuration_file_name}.support_file_copy1.db", $global_config_p) if $my_hostname_username ne ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are incluing the hostname on the backup files
        }
        if ( $$global_config_p{backup_support_file_copy2} eq "auto" ) {
            $$global_config_p{backup_support_file_copy2} = rebuild_full_path("$$global_config_p{temporary_dir}", "$$global_config_p{configuration_file_name}.support_file_copy2.db", $global_config_p) if $my_hostname_username eq ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are not incluing the hostname on the backup files
            $$global_config_p{backup_support_file_copy2} = rebuild_full_path("$$global_config_p{temporary_dir}", "$my_hostname_username.$$global_config_p{configuration_file_name}.support_file_copy2.db", $global_config_p) if $my_hostname_username ne ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are incluing the hostname on the backup files
        }
        if ( $$global_config_p{backup_support_file_copy3} eq "auto" ) {
            $$global_config_p{backup_support_file_copy3} = rebuild_full_path("$$global_config_p{temporary_dir}", "$$global_config_p{configuration_file_name}.support_file_copy3.db", $global_config_p) if $my_hostname_username eq ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are not incluing the hostname on the backup files
            $$global_config_p{backup_support_file_copy3} = rebuild_full_path("$$global_config_p{temporary_dir}", "$my_hostname_username.$$global_config_p{configuration_file_name}.support_file_copy3.db", $global_config_p) if $my_hostname_username ne ""; # rebuild the full path pointing also into the path defined by temporary_dir and if we are incluing the hostname on the backup files
        }
    }

    # test if the directory(ies) and files to backup exist and if the their path is a full path
    # this test only runs if not doing a restore and not attempting to see the log file
    if ( $error_flag == 0 ) {
        my @input_backup_split = split(/</,  $$global_config_p{input_backup}); # real all backup directories
        $$global_config_p{input_backup} = ""; # clear up the list for rebuild
        foreach my $test_file_directory (@input_backup_split) { # test each backup directory for full path and if it exists.
            # remove the last \ or / char
            $test_file_directory =~ s/[\\\/]+$// if ( $test_file_directory ne "/" and ( (length($test_file_directory) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix") );
            if ( $$global_config_p{input_backup} ne "" ) { # if not first line of file
               $$global_config_p{input_backup} = $$global_config_p{input_backup} . "<" . $test_file_directory;
            }
            else { # if first line
                $$global_config_p{input_backup} = $test_file_directory;
            }
            if ( check_if_full_path($test_file_directory, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                $error_flag = 40; # mark file or directory does not exit or it's not a full path
            }
            # test if the backup destiny conflits with the temporary or output directory
            if ( $error_flag == 0 and ( ( $$global_config_p{host_os} ne "unix" and lc($test_file_directory) eq ($$global_config_p{temporary_dir} or $$global_config_p{output_backup}) ) or ( $$global_config_p{host_os} eq "unix" and $test_file_directory eq ($$global_config_p{temporary_dir} or $$global_config_p{output_backup}) ) ) ) {
                $error_file_directory = "Backup directory";
                $error_flag = 11; # mark error
            }
            # search for repeted directory paths
            my $file_directory_count =0; # search for
            foreach my $test_file_directory_namesearch (@input_backup_split) { # test each backup directory for full path and if it exists.
                $file_directory_count++ if ( $test_file_directory eq $test_file_directory_namesearch );
            }
            $error_flag = 42 if $file_directory_count > 1; # mark error repeted file or directory path
            $error_file_directory = $test_file_directory if $error_flag != 0; # name of the directory to cause the error will be show on screen
            last if $error_flag != 0; # exit at first error
        }
    }

    # check if the keep_last_n_files value is valid, it must be >= -1  /^[+-]?\d+$/   /^\d+$/
    if (  $error_flag == 0 and ( $$global_config_p{keep_last_n_files} !~ /^[+-]?\d+$/ or $$global_config_p{keep_last_n_files} < -1 ) ) {
        $error_flag = 9; # Invalid value
    }

    # check the network_timeout value
    $$global_config_p{network_timeout} = 480 if ( $$global_config_p{network_timeout} eq "" ); 
    if ( $error_flag == 0 and !($$global_config_p{network_timeout} =~ /^\d+$/) or $$global_config_p{network_timeout} <= 0 ) { # if there was no error get the network timeout value
        $error_flag = 16; # mark error
    }
    
    # check the network_connect_retries value
    $$global_config_p{network_connect_retries} = 6 if ( $$global_config_p{network_connect_retries} eq "" );
    if ( $error_flag == 0 and !($$global_config_p{network_connect_retries} =~ /^\d+$/) or $$global_config_p{network_connect_retries} <= 0 ) { # if there was no error get the network timeout value
        $error_flag = 41; # mark error
    }

    # Ftp setup
    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "ftp" ) { # if we are using ftp backup mode
        eval {
            require Net::FTP; # attempt to detect if the  ftp module is installed
        };
        if ($@) {
            $error_flag = 38; # required module is not available
        }
        # Check if ftp_passive mode is correcly defined, must be yes/no or empty ""
        if ( $error_flag == 0 and ($$global_config_p{ftp_passive_mode} ne "" and $$global_config_p{ftp_passive_mode} ne "yes" and $$global_config_p{ftp_passive_mode} ne "no") ) {
            $error_flag = 14; # mark error invalid passive mode
        }
        else { # configure the passive mode parameter (to pass into NET::FTP)
                if ( $$global_config_p{ftp_passive_mode} eq "" ) {
                    $$global_config_p{ftp_passive_mode}  = "no"; # change to default value
                }
                if ( $$global_config_p{ftp_passive_mode} eq "no" ) { # passive mode no
                    $$global_config_p{ftp_passive_mode_real} = 0; # The real parameter passed into the NET:FTP, here is [ 0 ; 1 ]
                }
                else { # passive mode yes
                    $$global_config_p{ftp_passive_mode_real} = 1; # The real parameter passed into the NET:FTP, here is [ 0 ; 1 ]
                }
        }
        # check if the ftp url is correct, and place all other ftp values in the correct places
        if ( $error_flag == 0 ) {

            my $ftp_username = "";
            my $ftp_password = "";
            my $ftp_server = "";
            my $ftp_port = "";
            my $ftp_directory = "";
            # test and load the ftp configuration from the ftp url
            if ( url_test_load($$global_config_p{output_backup}, \$ftp_username, \$ftp_password, \$ftp_server, \$ftp_port, \$ftp_directory) == 0 ) {
                # remove the last \ or / char
                $ftp_directory =~ s/[\\\/]+$// if ( $ftp_directory ne "/" and ( (length($ftp_directory) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix") );
                # update the main configuration hash
                $$global_config_p{ftp_server} =  $ftp_server;        # Remote ftp server.
                $$global_config_p{ftp_server_port} = $ftp_port;      # Remote ftp server port number.
                $$global_config_p{ftp_username} = $ftp_username;     # FTP Username.
                $$global_config_p{ftp_password} = $ftp_password;     # FTP Password
                $$global_config_p{ftp_directory} = $ftp_directory;   # FTP directory where we will upload the backup file.
            }
            else { # ftp url is damaged
                $error_flag = 15; # mark error
            }
        }
    }

    # Sftp setup
    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "sftp" ) { # if we are using ftp backup mode

        # configure the sftp transport type
        $$global_config_p{sftp_transport} = "auto" if $$global_config_p{sftp_transport} eq "";
        if ( $$global_config_p{sftp_transport} eq "auto" and $$global_config_p{host_os} ne "unix" ) { # if under automode and under windows systems
            $$global_config_p{sftp_transport} = "psftp"; # use the psftp program from the putty package
        }
        elsif ( $$global_config_p{sftp_transport} eq "auto" and $$global_config_p{host_os} eq "unix" ) { # if under automode and under unix systems
                $$global_config_p{sftp_transport} = "sftp"; # use the open ssh sftp program
        }
        if ( $error_flag == 0 and $$global_config_p{sftp_transport} ne "psftp" and $$global_config_p{sftp_transport} ne "sftp" and $$global_config_p{sftp_transport} ne "net::ssh2" and $$global_config_p{sftp_transport} ne "net::sftp" ) { # test the sftp transport
            $error_flag = 27; # mark error invalid sftp transport type
        }
        elsif ( $$global_config_p{sftp_transport} ne "psftp" ) { # test required perl modules
            if ( $error_flag == 0 and $$global_config_p{sftp_transport} eq "net::ssh2" ) { # using the Net::SSH2 Perl Module
                $error_flag = 71;
                eval { # try with Net::SSH2
                    require Net::SSH2; #attempt to detect if the Net::SFTP sftp module is installed
                };
                if ($@) {
                    $error_flag = 37; # required module is not available
                }
            }
            elsif ( $error_flag == 0 and $$global_config_p{sftp_transport} eq "net::sftp" ) { # using the Net::SFTP Perl Module
                $error_flag = 71;
                eval { # try with Net::SFTP
                    require Net::SFTP; #attempt to detect if the Net::SFTP sftp module is installed
                };
                if ($@) {
                    $error_flag = 37; # required module is not available
                }
            }
            elsif ( $$global_config_p{sftp_transport} eq "sftp" ) { # using the open ssh sftp program
                eval { # See if the Expect module is installed
                    require Expect; #attempt to detect if the Expect module is installed
                };
                if ($@) {
                    $error_flag = 10; # required module is not available
                }
            }
        }

        if ( $error_flag == 0 and $$global_config_p{psftp_private_key_file} ne "" and check_if_full_path($$global_config_p{psftp_private_key_file}, $$global_config_p{host_os}, $global_config_p) != 0 ) {
            $error_flag = 66; # key file not defined has full path
        }
        if ( $error_flag == 0 and $$global_config_p{psftp_private_key_file} ne "" and !-f $$global_config_p{psftp_private_key_file} ) {
            $error_flag = 67; # key file does not exists
        }
        # check if the sftp url is correct, and place all other ftp values in the correct places
        if ( $error_flag == 0 ) {

            my $sftp_username = "";
            my $sftp_password = "";
            my $sftp_server = "";
            my $sftp_port = "";
            my $sftp_directory = "";
            # test and load the ftp configuration from the ftp url
            if ( url_test_load($$global_config_p{output_backup}, \$sftp_username, \$sftp_password, \$sftp_server, \$sftp_port, \$sftp_directory) == 0 ) {
                # remove the last \ or / char
                $sftp_directory =~ s/[\\\/]+$// if ( $sftp_directory ne "/" and ( (length($sftp_directory) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix") );
                # update the main configuration hash
                $$global_config_p{sftp_server} =  $sftp_server;        # Remote sftp server.
                $$global_config_p{sftp_server_port} = $sftp_port;      # Remote sftp server port number.
                $$global_config_p{sftp_username} = $sftp_username;     # SFTP Username.
                $sftp_password = "none" if ( lc($sftp_password) eq "none" ); # to support null private keys pharaafrases
                $$global_config_p{sftp_password} = $sftp_password;     # SFTP Password
                $$global_config_p{sftp_directory} = $sftp_directory;   # SFTP directory where we will upload the backup file.
            }
            else { # sftp url is damaged
                $error_flag = 15; # mark error
            }
        }
    }

    # Http Dav setup
    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "http-dav" ) { # if we are using http-dav backup mode
        eval {
            require HTTP::DAV; #attempt to detect if the  http dav module is installed
        };
        if ($@) {
            $error_flag = 65; # required module is not available
        }
        # check if the sftp url is correct, and place all other ftp values in the correct places
        if ( $error_flag == 0 ) {

            my $dav_username = "";
            my $dav_password = "";
            my $dav_server = "";
            my $dav_port = "";
            my $dav_directory = "";
            # test and load the ftp configuration from the ftp url
            if ( url_test_load($$global_config_p{output_backup}, \$dav_username, \$dav_password, \$dav_server, \$dav_port, \$dav_directory) == 0 ) {
                # remove the last \ or / char
                $dav_directory =~ s/[\\\/]+$// if ( $dav_directory ne "/" and ( (length($dav_directory) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix") );
                # update the main configuration hash
                $$global_config_p{dav_server} = $dav_server;        # Remote dav server.
                $$global_config_p{dav_url} = "http://" . $dav_server . ":" . $dav_port;          # Remote dav url with just server name + port
                $$global_config_p{dav_url_full} = $$global_config_p{dav_url} . $dav_directory;  # # Remote dav url with server name + port + backup directory
                $$global_config_p{dav_server_port} = $dav_port;      # Remote dav server port number.
                $$global_config_p{dav_username} = $dav_username;     # dav Username.
                $$global_config_p{dav_password} = $dav_password;     # dav Password
                $$global_config_p{dav_directory} = $dav_directory;   # dav directory where we will upload the backup file.
            }
            else { # http dav url is damaged
                $error_flag = 15; # mark error
            }
        }
    }

    $$global_config_p{compressed_file_size_limit} = 5120 if ( $$global_config_p{compressed_file_size_limit} eq "" and $$global_config_p{backup_working} eq "smtp" ); # configure the default value under smtp mail backps
    $$global_config_p{compressed_file_size_limit} = 0 if ( $$global_config_p{compressed_file_size_limit} eq "" and $$global_config_p{backup_working} ne "smtp" ); # configure the default value for standard backups (no limit)
    if ( $error_flag == 0 and ( !($$global_config_p{compressed_file_size_limit} =~ /^\d+$/) and $$global_config_p{compressed_file_size_limit} ne 0 ) ) {
        $error_flag = 54; # mark error, invalid size limit
    }

    # screen height value
    $$global_config_p{screen_height} = 24 if ( $$global_config_p{screen_height} eq "" );
    if ( $error_flag == 0 and  !($$global_config_p{screen_height} =~ /^\d+$/) or $$global_config_p{screen_height} < 24 ) { # check if the number is a integer over or iqual to 24
        $error_flag = 35; # mark error
    }

    # SMTP backup
    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "smtp" ) { # if we are using smtp backup mode
        if ($$global_config_p{backup_mail_type} eq "smtp" ) { # if the mail server is SMTP type
            eval {
                require Net::SMTP; # attempt to detect if the  smtp module is installed
            };
            if ($@) {
                $error_flag = 39; # required module is not available
            }
        }
        # check if the smtp url is correct, and place all other smtp values in the correct places
        if ( $error_flag == 0 ) {
            my $smtp_username = "";
            my $smtp_password = "";
            my $smtp_server = "";
            my $smtp_port = "";
            my $smtp_mail_from_address = "";
            my $smtp_mail_to_addresses = "";

            # test and load the smtp url, error codes > 2 are errors 0 is sucess 1 and 2 are warnings about invalid email addresses
            my $special_error_flag = smtp_url_test_load($$global_config_p{output_backup}, \$smtp_username, \$smtp_password, \$smtp_server, \$smtp_port, \$smtp_mail_from_address, \$smtp_mail_to_addresses);
            switch: {
                    $special_error_flag < 3 && do { # no error occured, url is correct
                        # update the main configuration hash
                        $$global_config_p{backup_mail_server} =  $smtp_server;                  # Remote SMTP server.
                        $$global_config_p{backup_mail_port} = $smtp_port;                       # Remote SMTP server port number.
                        $$global_config_p{backup_mail_username} = $smtp_username;               # SMTP Username.
                        $$global_config_p{backup_mail_password} = $smtp_password;               # SMTP Password
                        $$global_config_p{backup_mail_from_address} = $smtp_mail_from_address;  # Mail box where the backup is sent
                        $$global_config_p{backup_mail_to_addresses} = $smtp_mail_to_addresses;  # Mail boxes where the backup is going
                        if ( $$global_config_p{backup_mail_username} ne "" ) { # If mail requires authentication
                            eval {
                                require Authen::SASL; # attempt to detect if the mail authentication module is installed
                            };
                            if ($@) {
                                $error_flag = 44; # required module is not available
                            }
                        }
                        $$global_config_p{backup_mail_attachment_method} = "all" if ( $$global_config_p{backup_mail_attachment_method} eq "" ); # configure the default value
                        if ( $error_flag == 0 and ( $$global_config_p{backup_mail_attachment_method} ne "all" and $$global_config_p{backup_mail_attachment_method} ne "individual" ) ) {
                            $error_flag = 55; # mark error, attachment method
                        }
                    };
                ( $special_error_flag == 3 or $special_error_flag == 7 ) && do {
                                    $error_flag = 50; # mark error
                                };
                $special_error_flag == 4 && do {
                                    $error_flag = 51; # mark error user declared a invalid mail server port
                                };
                $special_error_flag == 5 && do {
                                    $error_flag = 52; # mark error, empty smtp from address
                                };
                $special_error_flag == 6 && do {
                                    $error_flag = 53; # mark error, empty to addresses
                                };
            }
        }
    }

    # Check if we are using Windows and Tape backups
    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "tape" and $$global_config_p{host_os} ne "unix" ) {
        $error_flag = 18; # mark error, tape backups are not compatible with windows
    }

    # Check if are not using windows and if we have the before writing to tape and after writing to tape configured
    if ( $error_flag == 0 and $$global_config_p{backup_working} ne "tape" and ( ( $$global_config_p{tape_before_backup} ne "" and $$global_config_p{tape_before_backup} ne "none" ) or ( $$global_config_p{tape_after_backup} ne "" and $$global_config_p{tape_after_backup} ne "none" ) ) ) {
        $error_flag = 34; # mark error using tape procedures and not doing a tape backup
    }

    if ( $error_flag == 0 and $$global_config_p{backup_working} eq "tape" ) {
        if ( ($$global_config_p{output_backup} =~ tr/@//) != 1 ) {
            $error_flag = 19; # mark error, invalid tape url, must be something similar to tape://@/dev/my_tape_device
        }
        else {
            my $trash; # ignore this
            ($trash, $$global_config_p{tape_device} ) = split (/@/, $$global_config_p{output_backup});
            if ( !(-l $$global_config_p{tape_device} or -b $$global_config_p{tape_device} or -c $$global_config_p{tape_device}) ) { # tape device must be a link a block device or a caracter device
                $$global_config_p{tape_device} = ""; # clear the value since it's wrong
                $error_flag = 19; # mark error, invalid tape device
            }
            if ( $error_flag == 0 ) { # all is well, configure the remaining tape stuff
                if ( $$global_config_p{tape_command} eq "" ) { # configure the default tape backup command
                    $$global_config_p{tape_command} = "tar"; # default tape backup command
                }
                # configure the default command to execute before writing and after writing to tape
                if ( $$global_config_p{tape_before_backup} eq "" ) {
                    $$global_config_p{tape_before_backup} = "mt -f " . $$global_config_p{tape_device} . " rewind " . $$global_config_p{host_null_device};
                }
                if ( $$global_config_p{tape_after_backup} eq "" ) {
                    $$global_config_p{tape_after_backup} = "mt -f " . $$global_config_p{tape_device} . " offline " . $$global_config_p{host_null_device};
                }
                # if user doesn't want any command to be runned
                $$global_config_p{tape_before_backup} = "" if $$global_config_p{tape_before_backup} eq "none";
                $$global_config_p{tape_after_backup} = "" if $$global_config_p{tape_after_backup} eq "none";
            }
        }
    }

    # Mail stuff
    if ( $$global_config_p{mail_type} eq "" ) {
        $$global_config_p{mail_type} = "smtp"; # put in the default mail server type
    }
    if ( $error_flag == 0 and $$global_config_p{mail_type} ne "smtp" ) {
        $error_flag = 20; # mark error, invalid smtp mail server type
    }
    elsif ( $error_flag == 0 and $$global_config_p{mail_server} ne "" ) { # if there was no previous error and a mail server is defined
        if ($$global_config_p{mail_type} eq "smtp" ) { # if the mail server is SMTP type
            eval {
                require Net::SMTP; # attempt to detect if the  smtp module is installed
            };
            if ($@) {
                $error_flag = 39; # required module is not available
            }
        }
        if ( $$global_config_p{mail_username} ne "" ) { # If mail requires authentication
            eval {
                require Authen::SASL; # attempt to detect if the mail authentication module is installed
            };
            if ($@) {
                $error_flag = 44; # required module is not available
            }
        }

        # check mail server
        if ( $error_flag == 0 and $$global_config_p{mail_server} =~ /\s/ ) { # if the mail server name contains a invalid char... \n \r, tabs or spaces
            $error_flag = 21; # mark error, invalid smtp mail server
        }
        # check username + password, if username is used and password is not used or password is used and username not used
        if ( $error_flag == 0 and (($$global_config_p{mail_username} ne "" and $$global_config_p{mail_password} eq "") or ($$global_config_p{mail_username} eq "" and $$global_config_p{mail_password} ne "")) ) {
            $error_flag = 22; # mark error, lack of smtp password or lack of smtp username
        }
        # check the from address, must have one @ char and no , char
        if ( $error_flag == 0 and (($$global_config_p{mail_from_address} =~ tr/@//) != 1 or ($$global_config_p{mail_from_address} =~ tr/,//) != 0) ) {
            $error_flag = 23; # mark error, invalid smtp from address
        }
        # check the to addresses, must have at least has many @ has the , char -1
        # valid is: count(@) - count (,) = 1;
        if ( $error_flag == 0 and (($$global_config_p{mail_to_addresses} =~ tr/@//) - ($$global_config_p{mail_to_addresses} =~ tr/,//)) != 1 ) {
            $error_flag = 24; # mark error, invalid smtp to addresses
        }
        # check the mail port value
        if ( $$global_config_p{mail_port} eq "" ) { # not declared by user on config file
            $$global_config_p{mail_port} = 25; # put in the default value
        }
        elsif ( !($$global_config_p{mail_port} =~ /^\d+$/) or $$global_config_p{mail_port} <= 0 ) { # check if the number is a integer
            $error_flag = 26; # mark error user declared a invalid mail server port
        }
    }
    elsif ( $error_flag == 0 ) { # no mail server defined
        if ( $$global_config_p{mail_from_address} ne "" or $$global_config_p{mail_to_addresses} ne "" or $$global_config_p{mail_username} ne "" or $$global_config_p{mail_password} ne "" or $$global_config_p{mail_port} ne "" ) {
            $error_flag = 25; # mark error, we have some mail configuration but no mail server is declared
        }
    }
    # End of Mail stuff

    # check the backup list file encoding
    $$global_config_p{backup_list_encoding} = "auto" if ( $$global_config_p{backup_list_encoding} eq "" );
    # must be auto or utf-8 or utf16-le or ascii
    if ( $error_flag == 0 and ( $$global_config_p{backup_list_encoding} ne "auto" and $$global_config_p{backup_list_encoding} ne "utf-8" and $$global_config_p{backup_list_encoding} ne "utf16-le" and $$global_config_p{backup_list_encoding} ne "ascii" ) ) {
        $error_flag = 68;
    }
    elsif ( $$global_config_p{backup_list_encoding} eq "auto" ) {
        # $] is the perl version
        $$global_config_p{backup_list_encoding} = "ascii"; # by default we are in ascii mode
        $$global_config_p{backup_list_encoding} = "utf-8" if ( $] >= 5.008000 and $$global_config_p{backup_format} eq "7z" ); # unicode 8 bits if running with 7z (7-ZIP)... unicode support needs perl 5.8
        $$global_config_p{backup_list_encoding} = "utf16-le" if ( $] >= 5.008000 and $$global_config_p{backup_format} eq "rar" and $$global_config_p{host_os} ne "unix" ); # unicode 8 bits if running with rar on a windows system... unicode support needs perl 5.8
    }
    # check the restore list file encoding
    $$global_config_p{restore_list_encoding} = "auto" if ( $$global_config_p{restore_list_encoding} eq "" );
    # must be auto or utf-8 or utf16-le or ascii
    if ( $error_flag == 0 and ( $$global_config_p{restore_list_encoding} ne "auto" and $$global_config_p{restore_list_encoding} ne "utf-8" and $$global_config_p{restore_list_encoding} ne "utf16-le" and $$global_config_p{restore_list_encoding} ne "ascii" ) ) {
        $error_flag = 69;
    }
    # check if we are attempting to use unicode with a perl version under 5.8
    if ( $error_flag == 0 and $] < 5.008000 and ( $$global_config_p{backup_list_encoding} eq "utf-8" or $$global_config_p{backup_list_encoding} eq "utf16-le" or $$global_config_p{restore_list_encoding} eq "utf-8" or $$global_config_p{restore_list_encoding} eq "utf16-le" ) ) {
        $error_flag = 70;
    }

    # check the full backup day
    if ( $error_flag == 0 and $$global_config_p{backup_mode} ne "full" ) { # if we are using full backups this parameter is ignored

        $$global_config_p{full_backup_day} = "monday" if ( $$global_config_p{full_backup_day} eq "" );
        $$global_config_p{keep_last_n_files} = -1; # by default don't delete any files
        my $today_result = is_today($$global_config_p{full_backup_day});
        if ( $today_result eq "yes" ) { # if it's the full backup
            $$global_config_p{keep_last_n_files} = 0; # doing a full backup, keep only the present backup and delete all the rest
            $$global_config_p{backup_real_mode} = "full"; # reset the backup type to FULL
        }
        elsif ( $today_result eq "error" ) {
            $error_flag = 29; # mark error, invalid full backup day
        }
    }
    else { # if user is in full backup mode in the configuration file then the real mode is always full
        $$global_config_p{backup_real_mode} = "full"; # reset the backup type to FULL
    }

    if ( $error_flag == 0 and $$global_config_p{host_os} ne "unix" ) { # if running windows lowercase the auxiliary files
        $$global_config_p{backup_support_file_copy1} = lc $$global_config_p{backup_support_file_copy1};
        $$global_config_p{backup_support_file_copy2} = lc $$global_config_p{backup_support_file_copy2};
        $$global_config_p{backup_support_file_copy3} = lc $$global_config_p{backup_support_file_copy3};
        $$global_config_p{log_file} = lc $$global_config_p{log_file};
        $$global_config_p{psftp_private_key_file} = lc $$global_config_p{psftp_private_key_file};
    }
    # check if both copies of the support file are the same
    if ( $error_flag == 0 and ($$global_config_p{backup_support_file_copy1} eq $$global_config_p{backup_support_file_copy2} or $$global_config_p{backup_support_file_copy1} eq $$global_config_p{backup_support_file_copy3} or $$global_config_p{backup_support_file_copy2} eq $$global_config_p{backup_support_file_copy3} ) ) {
        $error_flag = 60; # mark error, some/all copies of the support file are the same
    }

    if ( $error_flag == 0 and $$global_config_p{log_file} ne "" and $$global_config_p{log_file} ne "none" and ($$global_config_p{log_file} eq $$global_config_p{backup_support_file_copy1} or $$global_config_p{log_file} eq $$global_config_p{backup_support_file_copy2} or $$global_config_p{log_file} eq $$global_config_p{backup_support_file_copy3} or $$global_config_p{log_file} eq $$global_config_p{psftp_private_key_file}) ) {
        $error_flag = 33; # mark error, log file is the same has the support file
    }

    # Check the file size
    $$global_config_p{backup_file_size_limit} = 0 if $$global_config_p{backup_file_size_limit} eq ""; # if not reported on the configuration file, change into default value  this is also importante for backward compatibility
    if ( $error_flag == 0 and ( !($$global_config_p{backup_file_size_limit} =~ /^\d+$/) and $$global_config_p{backup_file_size_limit} ne 0 ) ){
        $error_flag = 30; # mark error, invalid size limit
    }

    # Check add backup list data to log value
    $$global_config_p{backup_list_on_log} = "no" if ( $$global_config_p{backup_list_on_log} eq "" );
    if ( $error_flag == 0 and ( $$global_config_p{backup_list_on_log} ne "yes" and $$global_config_p{backup_list_on_log} ne "no" ) ) {
        $error_flag = 31; # mark error, invalid size limit
    }

    # Check add restore list data to log value
    $$global_config_p{restore_list_on_log} = "no" if ( $$global_config_p{restore_list_on_log} eq "" );
    if ( $error_flag == 0 and ( $$global_config_p{restore_list_on_log} ne "yes" and $$global_config_p{restore_list_on_log} ne "no" ) ) {
        $error_flag = 32; # mark error, invalid size limit
    }

    # if no error occured read the rejection list from a external file (if required)
    if ( $error_flag == 0 and substr($$global_config_p{backup_full_path_rejections},0,8) eq "file://@" ) {
        my ( $list_config_key, $list_file_path ) = split ( /@/, $$global_config_p{backup_full_path_rejections}); # get the file path
        $error_file_directory = "$list_file_path";
        if ( check_if_full_path($list_file_path, $$global_config_p{host_os}, $global_config_p) != 0 or ! -f $list_file_path ) {
            $error_flag = 45; # not a full path or does not exists
        }
        else { # file is a full path, open and load the backup list
            open(list_file_handle, "<$list_file_path") or $error_flag = 46; # open file in read mode
            if ( $error_flag == 0 ) {
                $$global_config_p{backup_full_path_rejections} = ""; # clear the file path
                while(<list_file_handle>) { # read the entire file into the array
                    chomp($_); # remove the new line chars
                    if ( $_ !~ /^#/ ) { # read only if there is no # char on the start of the line
                        $_ =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                        $_ =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                        if ( $$global_config_p{backup_full_path_rejections} ne "" ) { # if not first line of file
                            $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $_;
                        }
                        else { # if first line
                            $$global_config_p{backup_full_path_rejections} = $_;
                        }
                    }
                }
                close(list_file_handle);
            }
        }
    }
    # add fixed files into the full path rejection list that can never be included on the backup
    $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $$global_config_p{log_file} if ( $$global_config_p{log_file} ne "" and $$global_config_p{log_file} ne "none" ); # add the log file if one exists
    $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $$global_config_p{backup_support_file_copy1} if ( $$global_config_p{backup_support_file_copy1} ne "" ); # add the support file file copy one
    $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $$global_config_p{backup_support_file_copy2} if ( $$global_config_p{backup_support_file_copy2} ne "" and $$global_config_p{backup_support_file_copy2} ne "none" ); # add the support file file copy two
    $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $$global_config_p{backup_support_file_copy3} if ( $$global_config_p{backup_support_file_copy3} ne "" and $$global_config_p{backup_support_file_copy3} ne "none" ); # add the support file file copy two
    $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $$global_config_p{output_backup} if ( $$global_config_p{output_backup} ne "" and $$global_config_p{backup_working} eq "local file system"  ); # add the output directory, if one exists and if we are working in local file system mode (local backup directory)
    if ( lc $^O eq "linux" ) { # Running Linux so add the /proc file system into the full path rejections, backup of the /proc causes backup problems, the file system is a special kernel file system dinamic generated
        $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . "/proc";
    }
    $$global_config_p{backup_full_path_rejections} =~ s/^<//;  # Delete leading < char
    # Test the backup full path rejections, checking if the their path is a full path and if no conflit exists with the input_backup list
    if ( $error_flag == 0 and $$global_config_p{backup_full_path_rejections} ne "" ) {
        my @input_backup_split = split(/</,  $$global_config_p{input_backup}); # real all, input backup list
        my @backup_full_path_rejections_split = split(/</,  $$global_config_p{backup_full_path_rejections}); # real all rejection list
        $$global_config_p{backup_full_path_rejections} = "";
        foreach my $test_file_directory (@backup_full_path_rejections_split) { # test each backup directory for full path and if it exists.
            # Remove the last \ or / char and rebuild the rejection string
            $test_file_directory =~ s/[\\\/]+$// if ( $test_file_directory ne "/" and ( (length($test_file_directory) != 3 and $$global_config_p{host_os} ne "unix") or $$global_config_p{host_os} eq "unix") );
            if ( $$global_config_p{backup_full_path_rejections} ne "" ) { # if not first line of file
               $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . "<" . $test_file_directory;
            }
            else { # if first line
                $$global_config_p{backup_full_path_rejections} = $test_file_directory;
            }
            if ( check_if_full_path($test_file_directory, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                $error_flag = 47; # mark file or directory it's not a full path
            }
            # search for repeted directory paths
            my $file_directory_count =0; # search for
            foreach my $test_file_directory_namesearch (@backup_full_path_rejections_split) { # test each backup directory for full path and if it exists.
                $file_directory_count++ if ( $test_file_directory eq $test_file_directory_namesearch );
            }
            $error_flag = 48 if $file_directory_count > 1; # mark error repeted file or directory path
            # Check if anything on the rejection list is exactly the same has on the backup list (input_backup)
            foreach my $input_backup_file_dir (@input_backup_split) {
                $error_flag = 49 if ( $test_file_directory eq $input_backup_file_dir );
            }
            $error_file_directory = $test_file_directory if $error_flag != 0; # name of the directory to cause the error will be show on screen
            last if $error_flag != 0; # exit at first error
        }
    }

    # Deal with the encryption configuration
    $$global_config_p{encryption_crypt} = 2 if ( $$global_config_p{encryption_crypt} eq "" ); # default encryption times is 3
    $$global_config_p{encryption_level} = "byte" if ( $$global_config_p{encryption_level} eq "" ); # default encryption level is byte
    $$global_config_p{encryption_file_read_size} = 16384 if ( $$global_config_p{encryption_file_read_size} eq "" ); # default file read during encryption is 16384 bytes
    if ( $error_flag == 0 and $$global_config_p{encryption_passwd} ne "" ) { # if using a password, then file data will be encrypted
        if ( !($$global_config_p{encryption_crypt} =~ /^\d+$/) or $$global_config_p{encryption_crypt} <= 0 ) { # check if the number is a integer and over zero
            $error_flag = 58; # error invalid encryption times value
        }
        if ( $error_flag == 0 and ( $$global_config_p{encryption_level} ne "byte" and $$global_config_p{encryption_level} ne "bit" ) ) { # check if the number is a integer and over zero
            $error_flag = 59; # error invalid encryption level, must be byte or bit
        }
    }

    $$global_config_p{on_failure_run_after_backup} = "yes" if ( $$global_config_p{on_failure_run_after_backup} eq "" ); # configure the default value on_failure_run_after_backup
    if ( $error_flag == 0 and ($$global_config_p{on_failure_run_after_backup} ne "yes" and $$global_config_p{on_failure_run_after_backup} ne "no") ) {
        $error_flag = 56; # mark error
    }

    $$global_config_p{on_failure_run_after_restore} = "yes" if ( $$global_config_p{on_failure_run_after_restore} eq "" ); # configure the default value on_failure_run_after_backup
    if ( $error_flag == 0 and ($$global_config_p{on_failure_run_after_restore} ne "yes" and $$global_config_p{on_failure_run_after_restore} ne "no") ) {
        $error_flag = 57; # mark error
    }

    $$global_config_p{run_backup_on_failure_run_before_backup} = "no" if ( $$global_config_p{run_backup_on_failure_run_before_backup} eq "" ); # configure the default value run_backup_on_failure_run_before_backup
    if ( $error_flag == 0 and ($$global_config_p{run_backup_on_failure_run_before_backup} ne "yes" and $$global_config_p{run_backup_on_failure_run_before_backup} ne "no") ) {
        $error_flag = 61; # mark error
    }

    $$global_config_p{run_restore_on_failure_run_before_restore} = "no" if ( $$global_config_p{run_restore_on_failure_run_before_restore} eq "" ); # configure the default value run_restore_on_failure_run_before_restore
    if ( $error_flag == 0 and ($$global_config_p{run_restore_on_failure_run_before_restore} ne "yes" and $$global_config_p{run_restore_on_failure_run_before_restore} ne "no") ) {
        $error_flag = 62; # mark error
    }

    if ( $error_flag == 0 ) { # if there was not errors configure the operating system null device, which is used all over the program and some other things and the file separator / or \

        # copy the values from the before/after backup command into the before/after restore commands if required
        $$global_config_p{run_before_restore} = $$global_config_p{run_before_backup} if $$global_config_p{run_before_restore} eq "auto";
        $$global_config_p{run_after_restore} = $$global_config_p{run_after_backup} if $$global_config_p{run_after_restore} eq "auto";
        # convert the file size limit in kbytes into bytes on the backup file sizes limit
        $$global_config_p{backup_file_size_limit_bytes} = $$global_config_p{backup_file_size_limit} * 1024; # 1024 bytes = 1 Kbyte
        # convert the file size limit in kbytes into bytes on the mail backup 
        $$global_config_p{compressed_file_size_limit_bytes} = $$global_config_p{compressed_file_size_limit} * 1024; # 1024 bytes = 1 Kbyte
        # if we are working in full backup mode some other things are irrelevent
        if ( $$global_config_p{backup_mode} eq "full" ) {
            $$global_config_p{full_backup_day} = "everyday";
        }
        else { # if in incremental or differential backup mode
            if ( !-f $$global_config_p{backup_support_file_copy1} and !-f $$global_config_p{backup_support_file_copy2} and !-f $$global_config_p{backup_support_file_copy3} ) { # if no copy of the support file is available force full backup
                $$global_config_p{keep_last_n_files} = 0; # doing a full backup, keep only the present backup and delete all the rest
                $$global_config_p{backup_real_mode} = "full"; # reset the backup type to FULL
            }
        }

        # Check if we need to build a backup list
        if ( $$global_config_p{backup_full_path_rejections} ne "" or $$global_config_p{backup_extension_rejections} ne "" or $$global_config_p{backup_filenames_rejections} ne "" or $$global_config_p{backup_file_size_limit} != 0 or $$global_config_p{backup_mode} ne "full" ) {
            $$global_config_p{build_backup_list} = "yes";
        }
        else {
            $$global_config_p{build_backup_list} = "no";
        }
        if ( $$global_config_p{host_os} ne "unix" ) { # if under a microsoft operating system lowercase the file/directory rejections
            $$global_config_p{backup_full_path_rejections} = lc $$global_config_p{backup_full_path_rejections} if ( $$global_config_p{backup_full_path_rejections} ne "" );
            $$global_config_p{backup_extension_rejections} = lc $$global_config_p{backup_extension_rejections} if ( $$global_config_p{backup_extension_rejections} ne "" );
            $$global_config_p{backup_filenames_rejections} = lc $$global_config_p{backup_filenames_rejections} if ( $$global_config_p{backup_filenames_rejections} ne "" );
        }
    }

    # print apropriate messages
    switch: {
        $error_flag > 0 && do {
                            print "\nUsing configuration file: [ $file_path ]\n\n";
                        };
        $error_flag == 1 && do {
                            print "[ Error ], opening the configuration file,\ncheck if file exists and if you have read permissions.\n\n";
                        };
        $error_flag == 2 && do {
                            print "[ Error ], configuration file corrupted,\ncheck configuration file.\n\n";
                        };
        $error_flag == 3 && do {
                            print "[ Error ], invalid operating system,\nvalid values are: auto ; winnt4/win2000/xp/2003 or unix,\ncheck [ host_os ].\n\n";
                        };
        $error_flag == 4 && do {
                            print "[ Error ], invalid backup format,\nvalid values are: rar ; 7z ; zip ; tar ; tar.Z ; tar.gz ; tar.bz2 ;\nadvanced_tar ; advanced_tar.Z ; advanced_tar.gz ; advanced_tar.bz2\ncheck [ backup_format ].\n\n";
                        };
        $error_flag == 5 && do {
                            print "[ Error ], invalid backup compression ratio,\nvalid values are: none ; minimal, average ; maximal,\ncheck [ backup_compression_ratio ].\n\n";
                        };
        $error_flag == 6 && do {
                            print "[ Error ], using microsoft type of paths (\\) on a unix system,\ncheck [ host_os ; input_backup ; output_backup ;\ntemporary_dir ; log_file ; backup_support_file_copy1 ;\n backup_support_file_copy2 ;backup_support_file_copy3 ; psftp_private_key_file ].\n\n";
                        };
        $error_flag == 7 && do {
                            print "[ Error ], using unix type of paths (/) on a microsoft system,\ncheck [ host_os ; input_backup ; output_backup ;\ntemporary_dir ; log_file ; backup_support_file_copy1 ;\n backup_support_file_copy2 ; backup_support_file_copy3 ; psftp_private_key_file ].\n\n";
                        };
        $error_flag == 8 && do {
                            print "[ Error ], [ $error_file_directory ],\nit's not defined has a full path, check [ output_backup ; temporary_dir ].\n\n";
                        };
        $error_flag == 9 && do {
                            print "[ Error ], value is invalid, it must be >= -1,\ncheck [ keep_last_n_files ].\n\n";
                        };
        $error_flag == 10 && do {
                           print "[ Error ], Expect module wasn't found,\nthis is required in order to support sftp backups with the open ssh sftp\nprogram. The Expect module can be dowloaded and installed from perl cpan\nor you can installed it from the original simplebackup package.\n\n";
                        };
        $error_flag == 11 && do {
                            print "[ Error ], [ $error_file_directory ],\ncannot be the same has the backup destination directory\nor the temporary directory,\ncheck [ input_backup ; temporary_dir ; output_backup ].\n\n";
                        };
        $error_flag == 12 && do {
                            print "[ Error ], Backup file list [ $error_file_directory ],\ndoes not exist, it's not defined has a full path\nor you do not have permissions to access it,\ncheck [ input_backup ].\n\n";
                        };
        $error_flag == 13 && do {
                            print "[ Error ], Unable to read the Backup file list [ $error_file_directory ],\ncheck [ input_backup ].\n\n";
                        };
        $error_flag == 14 && do {
                            print "[ Error ], ftp passive mode is badly defined,\nvalid values are: yes/no or not defined at all,\ncheck [ ftp_passive_mode ].\n\n";
                        };
        $error_flag == 15 && do {
                            my $mode_error = $$global_config_p{backup_working};
                            print "[ Error ], $mode_error url is badly defined,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 16 && do {
                            print "[ Error ], network timeout value is invalid,\nit must be a valid number meaning a number over zero, example 480,\ncheck [ network_timeout ].\n\n";
                        };
        $error_flag == 17 && do {
                            print "[ Error ], sftp (secure ftp) backups are not yet supported,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 18 && do {
                            print "[ Error ], tape backups are not supported in the windows operating system,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 19 && do {
                            print "[ Error ], badly defined tape backup or it's not pointing into a block device,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 20 && do {
                            print "[ Error ], invalid mail server type,\nonly smtp mail servers are compatible with simplebackup,\ncheck [ mail_type ].\n\n";
                        };
        $error_flag == 21 && do {
                            print "[ Error ], invalid mail server name or ip,\ncheck [ mail_server ].\n\n";
                        };
        $error_flag == 22 && do {
                            print "[ Error ], incomplete mail authentication,\nyou must fully define the mail username and\npassword or not defining them at all,\ncheck [ mail_username ; mail_password ].\n\n";
                        };
        $error_flag == 23 && do {
                            print "[ Error ], invalid email address,\ncheck [ mail_from_address ].\n\n";
                        };
        $error_flag == 24 && do {
                            print "[ Error ], invalid email address(es),\ncheck [ mail_to_addresses ].\n\n";
                        };
        $error_flag == 25 && do {
                            print "[ Error ], using mail configuration but no mail server is configured,\ncheck [ mail_server ; mail_from_address ; mail_to_addresses ;\nmail_username ; mail_password ].\n\n";
                        };
        $error_flag == 26 && do {
                            print "[ Error ], mail port value is invalid,\nit must be a valid number meaning a number over zero, example 25,\ncheck [ mail_port ].\n\n";
                        };
        $error_flag == 27 && do {
                            print "[ Error ], invalid sftp transport, valid values are: auto ; sftp ; psftp,\ncheck [ sftp_transport ].\n\n";
                        };
        $error_flag == 28 && do {
                            print "[ Error ], invalid backup mode,\nvalid values are: full ;  incremental ; differential,\ncheck [ backup_mode ].\n\n";
                        };
        $error_flag == 29 && do {
                            print "[ Error ], invalid full backup day,\nvalid values are: monday ; tuesday ;\nwednesday ; thursday ; friday ;\nsaturday ; sunday ; first_day_month ;last_day_month ; first_day_year ;\nlast_day_year,\ncheck [ full_backup_day ].\n\n";
                        };
        $error_flag == 30 && do {
                            print "[ Error ], invalid file limit size,\nvalid values are: 0 ; or any valid positive number,\ncheck [ backup_file_size_limit ].\n\n";
                        };
        $error_flag == 31 && do {
                            print "[ Error ], invalid backup list on log value, valid values are: yes ; no ,\ncheck [ backup_list_on_log ].\n\n";
                        };
        $error_flag == 32 && do {
                            print "[ Error ], invalid restore list on log value, valid values are: yes ; no ,\ncheck [ restore_list_on_log ].\n\n";
                        };
        $error_flag == 33 && do {
                            print "[ Error ], path to the log file is duplicated,\ncheck [ backup_support_file_copy1 ; backup_support_file_copy2 ; backup_support_file_copy3 ; log_file ; psftp_private_key_file].\n\n";
                        };
        $error_flag == 34 && do {
                            print "[ Error ], cannot have defined tape procedures if not doing a tape backup,\ncheck [ tape_before_backup ; tape_after_backup ].\n\n";
                        };
        $error_flag == 35 && do {
                            print "[ Error ], screen height value is invalid,\nit must be a valid number meaning a number over or equal to 24, example 24,\ncheck [ screen_height ].\n\n";
                        };
        $error_flag == 36 && do {
                           print "[ Error ], invalid debug level,\nvalid values are: none ; half ; full,\ncheck [ debug_level ].\n\n";
                        };
        $error_flag == 37 && do {
                           my $sftp_transport = "";
                           $sftp_transport = "Net::SFTP" if ( $$global_config_p{sftp_transport} eq "net::sftp" );
                           $sftp_transport = "Net::SSH2" if ( $$global_config_p{sftp_transport} eq "net::ssh2" );
                           print "[ Error ], $sftp_transport wasn't found,\nthis is required in order to support sftp backups,\nyou must install the Net::SSH2 or the Net::SFTP package\nthat contain the support for sftp backups, this are\nincluded in the original simplebackup package.\n\n";
                        };
        $error_flag == 38 && do {
                           print "[ Error ], Net::FTP module wasn't found,\nthis is required in order to support ftp backups,\nyou must install the libnet package that contains the support for ftp backups\nand email reporting, this is included in the original simplebackup package.\n\n";
                        };
        $error_flag == 39 && do {
                            print "[ Error ], Net::SMTP module wasn't found,\nthis is required in order to support email reporting and email backups,\nyou must install the libnet package that contains the support for ftp backups\nand email reporting and is included in the original simplebackup package.\n\n";
                        };
        $error_flag == 40 && do {
                            print "[ Error ], Backup directory/file [ $error_file_directory ],\ndoes not exist, it's not defined has a full path\nor you do not have permissions to access it,\ncheck [ input_backup ].\n\n";
                        };
        $error_flag == 41 && do {
                            print "[ Error ], network connect retries value is invalid,\nit must be a valid number meaning a number over zero, example 6,\ncheck [ network_connect_retries ].\n\n";
                        };
        $error_flag == 42 && do {
                            print "[ Error ], repeated backup directory/file [ $error_file_directory ],\ncheck [ input_backup ].\n\n";
                        };
        $error_flag == 43 && do {
                           print "[ Error ], Net::SSH2 and Net::SFTP wasn't found,\nat least one of this modules must be installed to support\nsftp backups, you must install the Net::SSH2 or the Net::SFTP\npackage that contain the support for sftp backups, this\nare included in the original simplebackup package.\n\n";
                        };
        $error_flag == 44 && do {
                            print "[ Error ], Authen::SASL module wasn't found,\nthis is required in order to support mail servers that request user\nauthentication,\nthis module is included in the original simplebackup package.\n\n";
                        };
        $error_flag == 45 && do {
                            print "[ Error ], rejection file list [ $error_file_directory ],\ndoes not exist, it's not defined has a full path\nor you do not have permissions to access it,\ncheck [ backup_full_path_rejections ].\n\n";
                        };
        $error_flag == 46 && do {
                            print "[ Error ], Unable to read the rejection file list [ $error_file_directory ],\ncheck [ backup_full_path_rejections ].\n\n";
                        };
        $error_flag == 47 && do {
                            print "[ Error ], rejection directory/file [ $error_file_directory ],\nit's not defined has a full path,\ncheck [ backup_full_path_rejections ].\n\n";
                        };
        $error_flag == 48 && do {
                            print "[ Error ], repeated rejection directory/file [ $error_file_directory ],\ncheck [ backup_full_path_rejections ].\n\n";
                        };
        $error_flag == 49 && do {
                            print "[ Error ], rejection directory or file [ $error_file_directory ],\nis exactly the same has one found on the backup list,\ncheck [ input_backup ; backup_full_path_rejections ].\n\n";
                        };
        $error_flag == 50 && do {
                            print "[ Error ], smtp url is badly defined,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 51 && do {
                            print "[ Error ], mail port value is invalid,\nit must be a valid number meaning a number over zero, example 25,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 52 && do {
                            print "[ Error ], empty email address on mail_from_address,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 53 && do {
                            print "[ Error ], empty email address(es) on mail_to_addresses,\ncheck [ output_backup ].\n\n";
                        };
        $error_flag == 54 && do {
                            print "[ Error ], invalid mail backup file size limit,\nvalid values are: 0 ; or any valid positive number,\ncheck [ compressed_file_size_limit ].\n\n";
                        };
        $error_flag == 55 && do {
                            print "[ Error ], invalid backup attachment method,\nvalid values are: all ; individual ,\ncheck [ backup_mail_attachment_method ].\n\n";
                        };
        $error_flag == 56 && do {
                            print "[ Error ], invalid on failure run after backup value,\nvalid values are: yes ; no ,\ncheck [ on_failure_run_after_backup ].\n\n";
                        };
        $error_flag == 57 && do {
                            print "[ Error ], invalid on failure run after restore value,\nvalid values are: yes ; no ,\ncheck [ on_failure_run_after_restore ].\n\n";
                        };
        $error_flag == 58 && do {
                            print "[ Error ], invalid encryption crypt time value,\nit must be a valid number meaning a number over zero, example 3,\ncheck [ encryption_crypt ].\n\n";
                        };
        $error_flag == 59 && do {
                            print "[ Error ], invalid encryption level,\nvalid values are: byte ; bit,\ncheck [ encryption_level ].\n\n";
                        };
        $error_flag == 60 && do {
                            print "[ Error ], the path of the the support files are the same,\ncheck [ backup_support_file_copy1 ; backup_support_file_copy2 ; backup_support_file_copy3 ].\n\n";
                        };
        $error_flag == 61 && do {
                            print "[ Error ], invalid on run backup even on failure of run before backup value,\nvalid values are: yes ; no ,\ncheck [ run_backup_on_failure_run_before_backup ].\n\n";
                        };
        $error_flag == 62 && do {
                            print "[ Error ], invalid on run restore even on failure of run before restore value,\nvalid values are: yes ; no ,\ncheck [ run_restore_on_failure_run_before_restore ].\n\n";
                        };
        $error_flag == 63 && do {
                            print "[ Error ], invalid hostname on backup files value,\nvalid values are: yes/no or not defined at all,\ncheck [ hostname_on_backup_files ].\n\n";
                        };
        $error_flag == 64 && do {
                            print "[ Error ], invalid username on backup files value,\nvalid values are: yes/no or not defined at all,\ncheck [ username_on_backup_files ].\n\n";
                        };
        $error_flag == 65 && do {
                           print "[ Error ], HTTP::DAV module wasn't found,\nthis is required in order to support http dav backups,\nyou must install the HTTP::DAV package that contains the support for\nhttp dav backups, this is included in the original simplebackup package.\n\n";
                        };
        $error_flag == 66 && do {
                           print "[ Error ], putty private key file is not defined has full path,\ncheck [ psftp_private_key_file ].\n\n";
                        };
        $error_flag == 67 && do {
                           print "[ Error ], putty private key file does not exists,\ncheck [ psftp_private_key_file ].\n\n";
                        };
        $error_flag == 68 && do {
                           print "[ Error ], invalid backup list encoding,\nvalid values are : auto ; ascii ; utf-8 ; utf16-le,\ncheck [ backup_list_encoding ].\n\n";
                        };
        $error_flag == 69 && do {
                           print "[ Error ], invalid restore list encoding,\nvalid values are : auto ; ascii ; utf-8 ; utf16-le,\ncheck [ restore_list_encoding ].\n\n";
                        };
        $error_flag == 70 && do {
                           print "[ Error ], for unicode support perl 5.8 or over is needed,\ncheck [ backup_list_encoding ; restore_list_encoding ].\n\n";
                        };
        $error_flag == 71 && do {
                           my $sftp_transport = "";
                           $sftp_transport = "Net::SFTP" if ( $$global_config_p{sftp_transport} eq "net::sftp" );
                           $sftp_transport = "Net::SSH2" if ( $$global_config_p{sftp_transport} eq "net::ssh2" );
                           print "[ Error ], the support for the $sftp_transport perl module is not yet implemented,\ncheck [ sftp_transport ].\n\n";
                        };
    }

    print "Function read_config() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Show the configuration read from the conf file,
# NOTE !! this should only be run if the configuration is correct (passed sucessufly in the
# read_config() function!!)
# Will return: 0
# Explain: 0 is success
sub show_config {

    my $global_config_p = $_[0]; # configuration pointer

    print "Running the show_config() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $my_perl_version = $]; # perl version
    # put variables in local ones to make them easy to place inside strings
    my $running_host_os = $^O; # type of the host operating system
    my $configuration_file = $$global_config_p{configuration_file};
    my $configuration_file_name = $$global_config_p{configuration_file_name};
    my $host_os = $$global_config_p{host_os};
    my $host_null_device = $$global_config_p{host_null_device};
    my $backup_format = $$global_config_p{backup_format};
    my $backup_format_details = $$global_config_p{backup_format_details};
    my $debug_level = $$global_config_p{debug_level};
    my $backup_mode = $$global_config_p{backup_mode};
    my $backup_real_mode = $$global_config_p{backup_real_mode};
    my $full_backup_day = $$global_config_p{full_backup_day};
    my $backup_filenames_rejections = $$global_config_p{backup_filenames_rejections};
    my $backup_extension_rejections = $$global_config_p{backup_extension_rejections};
    my $backup_full_path_rejections = $$global_config_p{backup_full_path_rejections};
    my $backup_file_size_limit = $$global_config_p{backup_file_size_limit};
    my $backup_compression_ratio = $$global_config_p{backup_compression_ratio};
    my $screen_height = $$global_config_p{screen_height};
    my $backup_real_ratio = $$global_config_p{backup_real_ratio};
    my $input_backup = $$global_config_p{input_backup};
    my $text_note = $$global_config_p{text_note};
    my $backup_list_on_log = $$global_config_p{backup_list_on_log};
    my $restore_list_on_log = $$global_config_p{restore_list_on_log};
    my $psftp_private_key_file = $$global_config_p{psftp_private_key_file};
    my @input_backup_split;
    my $input_backup_files_count = 0; # count the number of backup files
    my $input_backup_directories_count = 0; # count the number of backup directories
    my $output_backup = $$global_config_p{output_backup};
    my $temporary_dir = $$global_config_p{temporary_dir};
    my $keep_last_n_files = $$global_config_p{keep_last_n_files};
    my $run_before_backup = $$global_config_p{run_before_backup};
    my $run_after_backup = $$global_config_p{run_after_backup};
    my $run_before_restore = $$global_config_p{run_before_restore};
    my $run_after_restore = $$global_config_p{run_after_restore};
    my $log_file = $$global_config_p{log_file};
    my $pass_log_to_external_cmd = $$global_config_p{pass_log_to_external_cmd};
    my $backup_support_file_copy1 = $$global_config_p{backup_support_file_copy1};
    my $backup_support_file_copy2 = $$global_config_p{backup_support_file_copy2};
    my $backup_support_file_copy3 = $$global_config_p{backup_support_file_copy3};
    my $tape_device = $$global_config_p{tape_device};
    my $tape_command = $$global_config_p{tape_command};
    my $tape_before_backup = $$global_config_p{tape_before_backup};
    my $tape_after_backup = $$global_config_p{tape_after_backup};
    my $hostname_on_backup_files = $$global_config_p{hostname_on_backup_files};
    my $username_on_backup_files = $$global_config_p{username_on_backup_files};
    my $hostname = $$global_config_p{hostname};
    my $my_username = $$global_config_p{username};
    my $backup_list_encoding = $$global_config_p{backup_list_encoding};
    my $restore_list_encoding = $$global_config_p{restore_list_encoding};
    my $mail_debug_level = "";
    my $explain_keep_last_n_files = "";
    my $ftp_debug_level = "";
    my $ftp_server = "";
    my $ftp_port = "";
    my $ftp_username = "";
    my $ftp_password = "";
    my $ftp_directory = "";
    my $ftp_passive_mode = "";
    my $dav_server = "";
    my $dav_url_full = "";
    my $dav_server_port = "";
    my $dav_username = "";
    my $dav_password = "";
    my $dav_directory = "";
    my $dav_debug_level = "";
    my $mail_server = "";
    my $mail_type = "";
    my $mail_port = "";
    my $mail_from_address = "";
    my $mail_to_addresses = "";
    my $mail_username = "";
    my $mail_password = "";
    my $sftp_server = "";
    my $sftp_port = "";
    my $sftp_username = "";
    my $sftp_password = "";
    my $sftp_directory = "";
    my $sftp_debug_level = "";
    my $sftp_transport = "";
    my $invalid_emails = "no";
    my $backup_mail_server = $$global_config_p{backup_mail_server};
    my $backup_mail_type = $$global_config_p{backup_mail_type};
    my $backup_mail_port = $$global_config_p{backup_mail_port};
    my $backup_mail_username = $$global_config_p{backup_mail_username};
    my $backup_mail_password = $$global_config_p{backup_mail_password};
    my $backup_mail_from_address = $$global_config_p{backup_mail_from_address};
    my $backup_mail_to_addresses = $$global_config_p{backup_mail_to_addresses};
    my $network_timeout = $$global_config_p{network_timeout};
    my $network_proxy = $$global_config_p{network_proxy};
    my $network_connect_retries = $$global_config_p{network_connect_retries}; # Connect retries
    my $compressed_file_size_limit = $$global_config_p{compressed_file_size_limit};
    my $backup_mail_attachment_method = $$global_config_p{backup_mail_attachment_method};
    my $on_failure_run_after_backup = $$global_config_p{on_failure_run_after_backup};
    my $on_failure_run_after_restore = $$global_config_p{on_failure_run_after_restore};
    my $run_backup_on_failure_run_before_backup = $$global_config_p{run_backup_on_failure_run_before_backup};
    my $run_restore_on_failure_run_before_restore = $$global_config_p{run_restore_on_failure_run_before_restore};

    @input_backup_split = split(/</,  $$global_config_p{input_backup}); # real all backup directories
    foreach my $my_file_dir (@input_backup_split) { # count the number of files and directories
        if ( -d "$my_file_dir" ) {
            $input_backup_directories_count++; # it's a directory count it
        }
        else {
            $input_backup_files_count++; # it's a file count it
        }
    }

    if ( $backup_full_path_rejections eq "" ) {
        $backup_full_path_rejections = "None configured";
    }

    if ( $backup_extension_rejections eq "" ) {
        $backup_extension_rejections = "None configured";
    }

    if ( $backup_filenames_rejections eq "" ) {
        $backup_filenames_rejections = "None configured";
    }

    if ( $backup_file_size_limit == 0 ) {
        $backup_file_size_limit = "None configured";
    }
    else {
        $backup_file_size_limit = "$backup_file_size_limit Kbytes";
    }
    if ( $network_proxy eq "" ) {
        $network_proxy = "None configured";
    }
    if ( $$global_config_p{backup_working} eq "ftp" ) { # if the backup type is ftp
        $ftp_server = $$global_config_p{ftp_server};        # Remote ftp server.
        $ftp_port = $$global_config_p{ftp_server_port};     # Remote ftp server port number.
        $ftp_username = $$global_config_p{ftp_username};    # FTP Username.
        $ftp_password = $$global_config_p{ftp_password};    # FTP Password
        $ftp_directory = $$global_config_p{ftp_directory};  # FTP directory where we will upload the backup file.
        $ftp_passive_mode = $$global_config_p{ftp_passive_mode}; # FTP passive mode or nor
        $ftp_debug_level = $$global_config_p{ftp_debug_level}; # FTP debug level
    }
    elsif ( $$global_config_p{backup_working} eq "sftp" ) { # if the backup type is sftp
        $sftp_server = $$global_config_p{sftp_server};        # Remote ftp server.
        $sftp_port = $$global_config_p{sftp_server_port};     # Remote ftp server port number.
        $sftp_username = $$global_config_p{sftp_username};    # SFTP Username.
        $sftp_password = $$global_config_p{sftp_password};    # SFTP Password
        $sftp_directory = $$global_config_p{sftp_directory};  # SFTP directory where we will upload the backup file.
        $sftp_debug_level = $$global_config_p{sftp_debug_level}; # SFTP debug level
        $sftp_transport = $$global_config_p{sftp_transport}; # SFTP Transport (perl module Net::SSH2 or the windows psftp putty program
        $sftp_transport = "psftp (Windows Putty SFTP program)" if ( $sftp_transport eq "psftp" );
        $sftp_transport = "sftp (Open SSH SFTP program)" if ( $sftp_transport eq "sftp" );
        if ( $psftp_private_key_file eq "" ) {
            $psftp_private_key_file = "None";
        }
    }
    elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # if the backup type is http dav
        $dav_server = $$global_config_p{dav_server};            # Remote http dav server.
        $dav_url_full = $$global_config_p{dav_url_full};
        $dav_server_port = $$global_config_p{dav_server_port};  # Remote http dav server port number.
        $dav_username = $$global_config_p{dav_username};        # HTTP DAV Username.
        $dav_password = $$global_config_p{dav_password};        # HTTP DAV Password.
        $dav_directory = $$global_config_p{dav_directory};      # HTTP DAV Level.
        $dav_debug_level = $$global_config_p{dav_debug_level};  # HTTP DAV debug level
    }


    if ( $compressed_file_size_limit == 0 ) {
        $compressed_file_size_limit = "None configured";
    }
    else {
        $compressed_file_size_limit = "$compressed_file_size_limit Kbytes";
    }

    if ( $run_before_backup eq "" ) {
        $run_before_backup = "None configured";
    }
    if ( $run_after_backup eq "" ) {
        $run_after_backup = "None configured";
    }

    if ( $run_before_restore eq "" ) {
        $run_before_restore = "None configured";
    }
    if ( $run_after_restore eq "" ) {
        $run_after_restore = "None configured";
    }

    if ( $tape_before_backup eq "" ) {
        $tape_before_backup = "None configured";
    }

    if ( $tape_after_backup eq "" ) {
        $tape_after_backup = "None configured";
    }

    # deal with the external command that can process the current log
    if ( $pass_log_to_external_cmd eq "" ) {
        $pass_log_to_external_cmd = "None configured";
    }
    else {
        $pass_log_to_external_cmd = "current_log | $pass_log_to_external_cmd";
    }

    if ( $backup_mode eq "full" ) { # if backup is in full backup mode
        if ( $keep_last_n_files == -1 ) {
            $explain_keep_last_n_files = "Keep ALL"; # keep all backup files
        }
        elsif ( $keep_last_n_files == 0 ) {
            $explain_keep_last_n_files = "Keep just the current"; # keep just the current backup file
        }
        else {
            $explain_keep_last_n_files = "$keep_last_n_files plus the current";
        }
    }

    if ( $backup_format_details =~ /advanced_/ ) { # if using a "advanced tar version" the tar is the one that configures the compression
        $backup_compression_ratio = "None configured (using tar values)";
        $backup_real_ratio = "None configured (using tar values)";
    }
    $backup_list_encoding = "unicode 8 bits" if ( $backup_list_encoding eq "utf-8" );
    $backup_list_encoding = "unicode 16 bits little-endian" if ( $backup_list_encoding eq "utf16-le" );
    $restore_list_encoding = "selected at restore time" if ( $restore_list_encoding eq "auto" );
    $restore_list_encoding = "unicode 8 bits" if ( $restore_list_encoding eq "utf-8" );
    $restore_list_encoding = "unicode 16 bits little-endian" if ( $restore_list_encoding eq "utf16-le" );

    # mail server stuff
    $mail_server = $$global_config_p{mail_server};
    $mail_debug_level = $$global_config_p{mail_debug_level};
    if ( $mail_server ne "" ) {
        $mail_port = $$global_config_p{mail_port};
        $mail_type = $$global_config_p{mail_type};
        $mail_from_address = $$global_config_p{mail_from_address};
        $mail_to_addresses = $$global_config_p{mail_to_addresses};
        $mail_username = $$global_config_p{mail_username};
        $mail_password = $$global_config_p{mail_password};
    }

    print "\nUsing Perl ........: [ $my_perl_version ]\n";
    print "Hostname ..........: [ $hostname ]\n";
    print "Username ..........: [ $my_username ]\n";
    print "Configuration file : [ $configuration_file ]\n\n";
    print "Directories & Files...\n";
    print " To backup .....: [ $input_backup ]\n";
    if ( ($input_backup_files_count + $input_backup_directories_count) == 1 ) {
        print "                  Will do the backup of $input_backup_files_count file\n" if $input_backup_files_count == 1;
        print "                  Will do the backup of $input_backup_directories_count directory\n" if $input_backup_directories_count == 1;
    }
    else {
        print "                  Will do the backup of $input_backup_directories_count directori(es)\n";
        print "                  and $input_backup_files_count file(s)\n";
    }
    print " Temporary .....: [ $temporary_dir ]\n";
    print " Backup destiny : [ $output_backup ]\n";
    if ( $$global_config_p{backup_working} eq "ftp" ) {
        print "\n  FTP connection details...\n";
        print "   Debug level .....: $ftp_debug_level\n";
        print "   Server ..........: $ftp_server\n";
        print "   Server Port .....: $ftp_port\n";
        print "   Username ........: $ftp_username\n";
        print "   Password ........: $ftp_password\n";
        print "   Remote Directory : $ftp_directory\n";
        print "   Passive mode ....: $ftp_passive_mode\n";
        print "   Proxy ...........: $network_proxy\n";
        print "   Timeout .........: $network_timeout\n";
        print "   Connect retries .: $network_connect_retries\n";
    }
    elsif ( $$global_config_p{backup_working} eq "sftp" ) {
        print "\n  SFTP connection details (encrypted)...\n";
        print "   Debug level ........: $sftp_debug_level\n";
        print "   SSH Transport ......: $sftp_transport\n";
        print "   Server .............: $sftp_server\n";
        print "   Server Port ........: $sftp_port\n";
        print "   Private key file ...: $psftp_private_key_file\n";
        print "   Username ...........: $sftp_username\n";
        if ( $psftp_private_key_file eq "None" ) { # if not using a private key, then you need a ssh user password
            print "   Password/Passphrase : $sftp_password\n";
        }
        else { # if using a private key, then you might need a private key passphrase
            print "   Passphrase .........: $sftp_password\n";
        }
        print "   Remote Directory ...: $sftp_directory\n";
        print "   Connect retries ....: $network_connect_retries\n" if ( $$global_config_p{sftp_transport} ne "psftp" and $$global_config_p{sftp_transport} ne "sftp" );
    }
    elsif ( $$global_config_p{backup_working} eq "http-dav" ) {
        print "\n  HTTP DAV connection details...\n";
        print "   Debug level .....: $dav_debug_level\n";
        print "   Server ..........: $dav_server\n";
        print "   Server Port .....: $dav_server_port\n";
        print "   Url .............: $dav_url_full\n";
        print "   Username ........: $dav_username\n";
        print "   Password ........: $dav_password\n";
        print "   Remote Directory : $dav_directory\n";
        print "   Connect retries .: $network_connect_retries\n";
    }
    elsif ( $$global_config_p{backup_working} eq "tape" ) {
        print "\n  Tape details...\n";
        print "   Device ..................: $tape_device\n";
        print "   Tape program ............: $tape_command\n";
        print "   Run before writting tape : $tape_before_backup\n";
        print "   Run after writing tape ..: $tape_after_backup\n";
    }
    elsif ( $$global_config_p{backup_working} eq "smtp" ) {
        print "\n  Mail backup details...\n";
        print "   Debug level ..........: $mail_debug_level\n";
        print "   Server type ..........: $backup_mail_type\n";
        print "   Mail server ..........: $backup_mail_server\n";
        print "   Server port ..........: $backup_mail_port\n";
        print "   Timeout ..............: $network_timeout\n";
        print "   Attachment method ....: $backup_mail_attachment_method\n";
        print "   From email address ...: $backup_mail_from_address\n";
        if ( check_email($backup_mail_from_address, $global_config_p) != 0 ) { # report if the mail from address is not a valid email address
            print "     Notice: $backup_mail_from_address is not a valid internet mail address\n";
        }
        print "   To email address(es) .: $backup_mail_to_addresses\n";
        my @mail_to_addresses_array = split (/,/, $backup_mail_to_addresses );
        foreach my $test_mail (@mail_to_addresses_array) {
            if ( check_email($test_mail, $global_config_p) != 0 ) { # report if the mail to address is not a valid email address
                print "     Notice: $test_mail is not a valid internet mail address\n";
            }
        }
        print "   Mail Authentication...\n";
        if ( $backup_mail_username ne "" ) {
            print "      Username ..........: $backup_mail_username\n";
            print "      Password ..........: $backup_mail_password\n";
        }
        else {
            print "      -- None configured --\n";
        }
    }
    print "\nGeneric...\n";
    print " Text Note ..............................: $text_note\n" if $text_note ne "";
    print " Screen Height ..........................: $screen_height\n";
    print " Selected O.S. ..........................: $host_os ($running_host_os)\n";
    print " O.S. null device is ....................: $host_null_device\n";
    print " Include hostname on the backup files ...: $hostname_on_backup_files\n";
    print " Include username on the backup files ...: $username_on_backup_files\n";
    print " Backup mode is .........................: $backup_mode\n";
    if ( $backup_mode ne "full" ) {
        print " Today's backup will be .................: $backup_real_mode\n";
        print " Full backup day ........................: $full_backup_day\n";
    }
    print " Network timeout ........................: $network_timeout\n";
    print " Backup rejections (full path) ..........: $backup_full_path_rejections\n";
    print " Backup rejections (file type) ..........: $backup_extension_rejections\n";
    print " Backup rejections (file name) ..........: $backup_filenames_rejections\n";
    print " Backup file size limit .................: $backup_file_size_limit\n";
    print " Compressed backup files size limit .....: $compressed_file_size_limit\n";
    print " Backup archiver format .................: $backup_format";
    if ( $backup_format_details =~ /advanced_/ ) {
        print " (advanced tar)";
    }
    print "\n";
    print " Use Encryption .........................: ";
    if ( $$global_config_p{encryption_passwd} eq "" ) {
        print "no\n";
    }
    else {
        print "yes\n";
    }
    print " Backup compression ratio ...............: $backup_compression_ratio\n";
    print " Real backup ratio (passed to archiver) .: $backup_real_ratio\n";
    print " Backup list encoding ...................: $backup_list_encoding\n";
    print " Restore list encoding ..................: $restore_list_encoding\n";
    print " Debug_level ............................: $debug_level\n";
    print " Backup sessions to keep ................: ";
    if ( $backup_mode eq "full" ) {
        print "$keep_last_n_files ($explain_keep_last_n_files)\n";
    }
    else {
        print "Auto managed\n";
    }
    print " Backup list on log .....................: $backup_list_on_log\n";
    print " Restore list on log ................... : $restore_list_on_log\n";
    print "\nE-mail reporting...\n";
    if ( $mail_server ne "" ) {
        print "   Debug level ..........: $mail_debug_level\n";
        print "   Server type ..........: $mail_type\n";
        print "   Mail server ..........: $mail_server\n";
        print "   Server port ..........: $mail_port\n";
        print "   Timeout ..............: $network_timeout\n";
        print "   From email address ...: $mail_from_address\n";
        if ( check_email($mail_from_address, $global_config_p) != 0 ) { # report if the mail from address is not a valid email address
            print "     Notice: $mail_from_address is not a valid internet mail address\n";
            $invalid_emails = "yes";
        }
        print "   To email address(es) .: $mail_to_addresses\n";
        my @mail_to_addresses_array = split (/,/, $mail_to_addresses );
        foreach my $test_mail (@mail_to_addresses_array) {
            if ( check_email($test_mail, $global_config_p) != 0 ) { # report if the mail to address is not a valid email address
                print "     Notice: $test_mail is not a valid internet mail address\n";
                $invalid_emails = "yes";
            }
        }
        print "   Mail Authentication...\n";
        if ( $mail_username ne "" ) {
            print "      Username ..........: $mail_username\n";
            print "      Password ..........: $mail_password\n";
        }
        else {
            print "      -- None configured --\n";
        }
    }
    else {
        print "   -- None configured --\n";
    }
    print "\nExternal stuff...\n";
    print " Run before backup .: $run_before_backup\n";
    if ( $run_before_backup ne "None configured" ) {
        print "   Notice: Backups will be executed even if this program execution fails\n" if ( $run_backup_on_failure_run_before_backup eq "yes" );
        print "   Notice: Backups will not be executed if this program execution fails\n" if ( $run_backup_on_failure_run_before_backup ne "yes" );
    }
    print " Run after backup ..: $run_after_backup\n";
    if ( $run_after_backup ne "None configured" ) {
        print "   Notice: This will always be executed, even with backup problems\n" if ( $on_failure_run_after_backup eq "yes" );
        print "   Notice: This will only be executed if the backup ends without problems\n" if ( $on_failure_run_after_backup ne "yes" );
    }
    print " Run before restore : $run_before_restore\n";
    if ( $run_before_restore ne "None configured" ) {
        print "   Notice: Restores will be executed even if this program execution fails\n" if ( $run_restore_on_failure_run_before_restore eq "yes" );
        print "   Notice: Restores will not be executed if this program execution fails\n" if ( $run_restore_on_failure_run_before_restore ne "yes" );
    }
    print " Run after restore .: $run_after_restore\n";
    if ( $run_after_restore ne "None configured" ) {
        print "   Notice: This will always be executed, even with restore problems\n" if ( $on_failure_run_after_restore eq "yes" );
        print "   Notice: This will only be executed if the restore ends without problems\n" if ( $on_failure_run_after_restore ne "yes" );
    }
    print " Log is passed to external command : $pass_log_to_external_cmd\n";
    print "\nUsed Files...\n";
    print " Log [ $log_file ]\n";
    print " Support (copy 1 of 3) [ $backup_support_file_copy1 ]\n";
    print " Support (copy 2 of 3) [ $backup_support_file_copy2 ]\n";
    print " Support (copy 3 of 3) [ $backup_support_file_copy3 ]\n";

    print "\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";

    # This section will warning or give some extra notes for the user
    my $warning_and_notes = "";
    if ( lc $^O eq "linux" ) { # Alert the linux user about the /proc file system
        $warning_and_notes .= "\n\nNotice : because simplebackup is running on the Linux operating system the\n         /proc file system is automatically rejected. This special file\n         system creates backup problems.";
    }
    if ( $$global_config_p{backup_working} eq "tape" ) {
        $warning_and_notes .= "\n\nWarning : backup is working in tape mode, this is a experimental feature\n          it's advice not using it to do backups of important data such\n          has production systems."; # write the error message into the console/terminal
    }
    if ( !-d $temporary_dir or ( $$global_config_p{backup_working} eq "local file system" and !-d $output_backup ) ) {
        if ( !-d $temporary_dir ) { # check if the temporary directory exists
            $warning_and_notes .= "\n\nWarning : temporary directory [ $temporary_dir ]\n          does not exists or you do not have permissions to access it."; # write the error message into the console/terminal
        }
        if ( $$global_config_p{backup_working} eq "local file system" and !-d $output_backup ) {
            $warning_and_notes .= "\n\nWarning : backup destination directory [ $output_backup ]\n          does not exists or you do not have permissions to access it."; # write the error message into the console/terminal
        }
    }
    foreach my $test_file_directory (@input_backup_split) { # test each backup directory for full path and if it exists.
        if ( !-f $test_file_directory and !-d $test_file_directory ) {
            $warning_and_notes .= "\n\nWarning : backup file/directory [ $test_file_directory ]\n          does not exists. Access must be given before any backup starts.";
        }
    }
    if ( $backup_support_file_copy1 eq "none" or $backup_support_file_copy2 eq "none" or $backup_support_file_copy3 eq "none" ) {
        $warning_and_notes .= "\n\nWarning : for extra security it's recommended to use three different\n          copies of the support file, preferably on different disks,\n          partitions or file systems.";
    }
    if ( $invalid_emails eq  "yes" ) {
        $warning_and_notes .= "\n\nWarning : one or more invalid email accounts where found.";
    }

    if ( $backup_format eq "zip" ) { # if using the zip command search for the info-zip zip and unzip commands
        $warning_and_notes .= "\n\nWarning : the info-zip zip command was not found please install and add it\n          to your path variable." if ( test_external_command("zip", $global_config_p) != 0 );
        $warning_and_notes .= "\n\nWarning : the info-zip unzip command was not found please install and add\n          it to your path variable." if ( test_external_command("unzip", $global_config_p) != 0 );
    }
    elsif ( $backup_format eq "rar" or $backup_format eq "7z" ) { # if using the rar or 7-zip search for the command
        $warning_and_notes .= "\n\nWarning : the $backup_format command was not found please install and add it to your\n          path variable." if ( test_external_command("$backup_format", $global_config_p) != 0 );
    }
    if ( $backup_format_details eq "tar.gz" or $backup_format_details eq "tar.bz2" ) { # test gzip (under tar + gzip)
        $warning_and_notes .= "\n\nWarning : the gzip command was not found please install and add it to\n          your path variable." if ( test_external_command("gzip", $global_config_p) != 0 );
    }
    if ( $backup_format_details eq "tar.bz2" ) { # test bzip2 (under tar + bzip2)
        $warning_and_notes .= "\n\nWarning : the bzip2 command was not found please install and add it to\n          your path variable." if ( test_external_command("bzip2", $global_config_p) != 0 );
    }
    if ( $$global_config_p{backup_working} eq "sftp" and $$global_config_p{sftp_transport} eq "psftp" ) { # test putty psftp program if working in sftp mode with the psftp program
        $warning_and_notes .= "\n\nWarning : the putty psftp command was not found please install and add it\n          to your path variable." if ( test_external_command("psftp", $global_config_p) != 0 );
    }
    if ( $$global_config_p{backup_working} eq "sftp" and $$global_config_p{sftp_transport} eq "sftp" ) { # test putty psftp program if working in sftp mode with the psftp program
        $warning_and_notes .= "\n\nWarning : the open ssh sftp command was not found please install and add\n          it to your path variable." if ( test_external_command("sftp", $global_config_p) != 0 );
    }
    if ( ($backup_format eq "rar" or $backup_format eq "7z" ) and $my_perl_version < 5.008000 ) { # for full backup security in rar/7z format full unicode support is needed, perl 5.6.x has limited unicode support
        my $my_unicode = "(UTF16-LE)";
        $my_unicode = "(UTF-8)" if ( $backup_format eq "7z" );
        $warning_and_notes .= "\n\nWarning : simplebackup is running with perl $my_perl_version using the $backup_format format,\n          this can cause problems because the command requires unicode\n          $my_unicode support to deal with files and directories that have\n          non english names, example a file name written in Portuguese.\n          Backups can fail completely or even run with success but fail\n          to backup some files, to be safe please update your perl or use\n          another backup format.\n          Full unicode support is present in perl 5.008000 (5.8.0) or over.";
    }
    if ( $warning_and_notes ne "" ) { # print warnings and notes if any exist
        $warning_and_notes .= "\n\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
        print "\n\nWarning and Notes..." . $warning_and_notes; 
    }
    print "\n\n";

    print "Function show_config() exit value is [ 0 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return 0; # always return success
}


#
# Test if a external command exists, notice the funcion get_external_command() is used here.
# Will return: 0 ; 1
# Explain: 0 is success command exists, 1 is failure command does not exists or does not work
sub test_external_command {

    my $command = $_[0]; # what is the command we want to test
    my $global_config_p = $_[1]; # configuration pointer

    print "Running the test_external_command() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $null_device = $$global_config_p{host_null_device}; # operating system null device (stderr)
    my $stdout_null_device = $$global_config_p{host_stdout_null_device}; # operating system null device (stdout)
    my $error_flag = 0;

    my $real_command = get_external_command($command,$global_config_p); # get the command (path or full path if compiled with perl2exe)
    switch: {
        # test the rar compressor
        ($command eq "rar" ) && do {
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                if ( `$real_command -h` !~ "Copyright" ) { # using this trick because psftp returns a error code even by just checking the version
                    $error_flag = 1; # command not available
                }
            }
            else { # using debug mode
                if ( `$real_command -h` !~ "Copyright" ) { # using this trick because psftp returns a error code even by just checking the version
                    $error_flag = 1; # command not available
                }
            }
        };
        ($command eq "zip" and $$global_config_p{host_os} ne "unix" ) && do { # check the zip command, under unix (linux at least, this fails)
            my @command_test;
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                @command_test = ("$real_command", "-v", "$null_device", "$stdout_null_device"); # test zip command
            }
            else { # using debug mode
                @command_test = ("$real_command", "-v"); # test zip command, under unix (linux at least, this fails)
            }
            system("@command_test") == 0 or $error_flag = 1; # mark error unable to connect into the sftp server
        };
        ($command eq "unzip" and $$global_config_p{host_os} ne "unix" ) && do { # check the unzip command, under unix (linux at least, this fails)
            my @command_test;
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                @command_test = ("$real_command", "-v", "$null_device", "$stdout_null_device"); # test unzip command
            }
            else { # using debug mode
                @command_test = ("$real_command", "-v"); # test unzip command, under unix (linux at least, this fails)
            }
            system("@command_test") == 0 or $error_flag = 1; # mark error unable to connect into the sftp server
        };
        ($command eq "gzip" ) && do { # check the gzip command
            my @command_test;
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                @command_test = ("$real_command", "-V", "$null_device", "$stdout_null_device"); # test gzip command
            }
            else { # using debug mode
                @command_test = ("$real_command", "-V"); # test gzip command
            }
            system("@command_test") == 0 or $error_flag = 1; # mark error unable to connect into the sftp server
        };
        ($command eq "bzip2" ) && do { # check the bzip2 command
            my @command_test;
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                @command_test = ("$real_command", "-h", "$null_device", "$stdout_null_device"); # test gzip command
            }
            else { # using debug mode
                @command_test = ("$real_command", "-h"); # test gzip command
            }
            system("@command_test") == 0 or $error_flag = 1; # mark error unable to connect into the sftp server
        };
        ($command eq "7z" ) && do { # check the 7z (7-zip) command
            my @command_test;
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                @command_test = ("$real_command", "-h", "$null_device", "$stdout_null_device"); # test gzip command
            }
            else { # using debug mode
                @command_test = ("$real_command", "-h"); # test gzip command
            }
            system("@command_test") == 0 or $error_flag = 1; # mark error unable to connect into the sftp server
        };
        ($command eq "psftp" ) && do { # check the putty psftp command
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                if ( `$real_command -V -batch $null_device` !~ "psftp:" ) { # using this trick because psftp returns a error code even by just checking the version
                    $error_flag = 1; # command not available
                }
            }
            else { # using debug mode
                if ( `$real_command -V -batch` !~ "psftp:" ) { # using this trick because psftp returns a error code even by just checking the version
                    $error_flag = 1; # command not available
                }
            }
        };
    }

    print "Function test_external_command() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # always return success

}


#
# Return the external command or (if possible) the full path into the external command.
# Notice the full path will only be returned for some few executables (included in the simplebackup
# Windows version).
# Will return: a string
# Explain: the string will be the external command name (e.g. zip) or the full path into
#          the command (e.g. c:\tmp\p2xtmp-1231\zip.exe)
sub get_external_command {

    my $command_wanted = $_[0]; # what is the command we want
    my $global_config_p = $_[1]; # configuration pointer

    print "Running the get_external_command() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $command_return = $command_wanted; # will contain the command name or the full path into the command
    my $file_separator = $$global_config_p{host_file_separator};

    if ( !($^X =~ /(perl)|(perl\.exe)$/i) ) { # if running the perl2exe windows compiled version
        if ( $command_wanted eq "zip" or $command_wanted eq "unzip" or $command_wanted eq "psftp" ) {
            $command_wanted .= ".exe"; # add the .exe file extention
        }
        # get the temporary directory
        my $temp_dir = ( $ENV{TEMP} || $ENV{TMP} || $ENV{WINDIR} || '/tmp' ) . "\\p2xtmp-$$";
        if (-f "$temp_dir$file_separator$command_wanted" ) { # test if file was uncompress from the simplebackup package
            $command_return = "$temp_dir$file_separator$command_wanted"; # command wanted exists in the simplebackup.exe package
        }
    }

    print "Function get_external_command() exit value is [ $command_return ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $command_return; # always return success

}


#
# Attempt to determin what is the operating system we are running, and always return a
# operating system value
# Will return: unix ; winnt4/win2000/xp/2003
# Explain: unix is for any operating system than is not windows; all other are windows
sub get_os_type {

    my $running_host_os = $^O; # type of the host operating system
    if ( $running_host_os eq "MSWin32" ) { # under some kind of windows
        $running_host_os = "winnt4/win2000/xp/2003";
    }
    else { # not windows defaults to unix
        $running_host_os = "unix";
    }

    return $running_host_os; # return the operating system type
}


#
# Attempt to determin what is username running simplebackup
# Will return: a string
# Explain: the string is the hostname or unavailable if unable to get the
#          username
sub get_username {

    my $my_username = "";

    # first # attempt to get the username by using perl commands
    $my_username = getlogin || getpwuid($<) || "unavailable";
    # second attempt to get the ENV enviroment variables
    $my_username = $ENV{USERNAME} if ( !defined $my_username or $my_username eq "" or $my_username eq "unavailable" );
    # second attempt to get the ENV enviroment variables
    $my_username = $ENV{username} if ( !defined $my_username or $my_username eq "" or $my_username eq "unavailable" );

    $my_username = "unavailable" if ( !defined $my_username or $my_username eq "" );

    return $my_username; # return the username
}


#
# Return the most apropriate temporary directory for the running operating system
# Will return: a path (always)
# Explain: the path is the temporary directory
sub get_tmp_dir {

    my $host_type = $_[0]; # configuration pointer
    my $temporary_path = "";

    if ( $host_type eq "unix" ) { # if running on unix
        $temporary_path = "/tmp"; # In unix /tmp is always the default path
    }
    else { # if under windows
        $temporary_path = $ENV{TEMP} if ( $temporary_path eq "" and defined $ENV{TEMP} and $ENV{TEMP} ne "" and -d $ENV{TEMP} ); # if using TEMP
        $temporary_path = $ENV{temp} if ( $temporary_path eq "" and defined $ENV{temp} and $ENV{temp} ne "" and -d $ENV{temp} ); # same, but temp
        $temporary_path = $ENV{TMP} if ( $temporary_path eq "" and defined $ENV{TMP} and $ENV{TMP} ne "" and -d $ENV{TMP} ); # if using TMP
        $temporary_path = $ENV{tmp} if ( $temporary_path eq "" and defined $ENV{tmp} and $ENV{tmp} ne "" and -d $ENV{tmp} ); # same, but tmp
        $temporary_path = "c:\\windows\\temp" if ( $temporary_path eq "" and -d "c:\\windows\\temp" ); # try c:\windows\temp
        $temporary_path = "c:\\winnt\\temp" if ( $temporary_path eq "" and -d "c:\\winnt\\temp" ); # try c:\winnt\temp
        $temporary_path = "c:\\" if ( $temporary_path eq "" ); # last attempt try c:\
    }

    return $temporary_path; # return the temporary dir path
}


#
# Receive a string containing a day order, and check if that order matches the system day
# Will return: yes ; no ; error
# Explain: yes is the today ; no it's not today ; invalid order !
sub is_today {

    my $check_order = $_[0];
    my $return_value = "no"; # by default is no

    if ( $check_order eq "monday" or $check_order eq "tuesday" or $check_order eq "wednesday" or $check_order eq "thursday" or $check_order eq "friday" or $check_order eq "saturday" or $check_order eq "sunday" or $check_order eq "first_day_month" or $check_order eq "last_day_month" or $check_order eq "first_day_year" or $check_order eq "last_day_year" ) {
        switch: {
            # weekday backup
            ($check_order eq "monday" or $check_order eq "tuesday" or $check_order eq "wednesday" or $check_order eq "thursday" or $check_order eq "friday" or $check_order eq "saturday" or $check_order eq "sunday") && do {
                    my $wday = (localtime(time))[6]; # get the weekday number
                    my @days   = ('sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'); # define the weekdays names
                    if ( $days[$wday] eq $check_order ) { # if the present weekday  is equal to the one configured by the user
                        $return_value = "yes";
                    }
            };
            # montly backup/year backup
            ($check_order eq "first_day_month" or $check_order eq "last_day_month" or $check_order eq "first_day_year" or $check_order eq "last_day_year") && do {
                my ($mday, $month) = (localtime(time))[3,4]; # get the monday day 1..28/29/30/31 + the month  0..11
                $month++; # just to make it simple... month 1..12
                if ( $mday == 1 and $check_order eq "first_day_month" ) { # backup on the first day of the month
                    $return_value = "yes";
                }
                elsif ( $mday == 1 and $month == 1 and $check_order eq "first_day_year" ) { # backup on the first day of year
                    $return_value = "yes";
                }
                elsif ( $check_order eq "last_day_month" ) { # let's look for the last day of the month
                    if ( $mday == 30 and ( $month == 4 or $month == 6 or $month == 9 or $month == 11 ) ) { # look for months with the last day has 30 ! remember $month is 1..12
                        $return_value = "yes";
                    }
                    elsif ( $mday == 31 and ( $month == 1 or $month == 3 or $month == 5 or $month == 7 or $month == 8 or $month == 10 or $month == 12 ) ) { # look for months with the last day has 31 ! remember $month is 0..12
                        $return_value = "yes";
                    }
                    elsif ( $month == 2 and $mday == 29 ) { # last day of february on a bi year
                        $return_value = "yes";
                    }
                    elsif ( $month == 2 and $mday == 28 and is_leap_year() eq "no" ) { # check if this is really the last day of the february
                        $return_value = "yes";
                    }
                }
                elsif ( $month == 12 and $mday == 31 and $check_order eq "last_day_year" ) { # let's look for the last day of the year
                    $return_value = "yes";
                }
            };
        }
    }
    else {
        $return_value = "error"; # error, invalid order
    }

    return $return_value;

}


#
# Return if the present year is a leap year or not
# Will return: yes ; no
# Explain: yes is is ; no it's not
sub is_leap_year {

    my $return_value = "no"; # by default it's not
    my $year = (localtime(time))[5];

    $year += 1900; # Add 1900 to the year to get the full 4 digit year
    if ( ($year % 4  == 0 and $year % 100 > 0) or $year % 400 == 0 ) { # check if the a leap year
        $return_value = "yes"; # year has 366 days
    }

    return $return_value;
}


#
# Receive a string, and a host type and return if the string is a full path or not
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure
sub check_if_full_path {

    my $my_path = $_[0]; # string that get's the path
    my $host_type = $_[1]; # windows / unix
    my $global_config_p = $_[2]; # configuration pointer
    print "Running the check_if_full_path() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $error_flag = 0; # return value

    if ( ! defined $my_path )  {
        $error_flag = 1;
    }
    elsif ( $host_type eq "unix" and ( length($my_path) < 1 or substr($my_path,0,1) ne "/" ) ) {
        $error_flag = 1;
    }
    # under windows the length must be at lest 3 chars (d:\) ; there must be the :\ chars and the first char must be a letter
    elsif ( $host_type ne "unix" and (length($my_path) < 3 or substr($my_path,1,2) ne ":\\" or substr($my_path,0,1) !~ m/[a-zA-Z]/) ) {
        $error_flag = 1;
    }

    print "Function check_if_full_path() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive a string that contains full paths separated by a special char, convert into
# perl regular expressions that perl will use (latter) to match against full path
# of files even with the use of wild cards.
# Will return: a string
sub prepare_perl_wildcards {

    my $full_path_string = $_[0];
    my $global_config_p = $_[1]; # configuration pointer
    print "Running the prepare_perl_wildcards() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my @full_path_string_array; # used to contain all entries

    $full_path_string =~ s/\\/\\\\/g; # replace \ with \\    to prevent perl problems
    $full_path_string =~ s/\./\\./g;  # replace . with \.    this will mean to perl look exactly for the . char and not all chars
    $full_path_string =~ s/\*/\.*/g;  # replace * with .*    this will mean to perl look for any char any times

    push (@full_path_string_array, split( /</, $full_path_string));

    $full_path_string = ""; # clear up the string
    foreach ( @full_path_string_array ) { # add $ char into every rejection entry... $ means look for only THIS in last part... example search for *.avi only on the last part
        $_ = "$_\$"; # Add the " $  "char to end of the string, the means that perl will look at the last part
        if ( $full_path_string ne "" ) { # if not first line of file
           $full_path_string = "$full_path_string<$_"
        }
        else { # if first line
            $full_path_string = "$_"
        }
    }

    print "Function prepare_perl_wildcards() exit value is [ $full_path_string ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $full_path_string; # return the prepared string

}


#
# Receive a string separated by a special char, and remove extra spaces bettwen that char
# and return that new string, the separator char can be , or <
# example : *hello , i'm separating,suff, ok*    will became = *hello,i'm separating,suff,ok*
# example : *hello<  i'm separating<suff< ok*    will became = *hello<i'm separating<suff<ok*
# Will return: a string
sub remove_excess_spaces {

    my $input_string = $_[0]; # the string to fix
    my $separator_char  = $_[1]; # the separator char, supported are , and <

    my $fixed_string = ""; # the fixed string to return

    # deal with the separator char
    my @my_rsplit;
    switch: {
        $separator_char eq ',' && do { # separator char is ,
                            @my_rsplit = split(/,/, $input_string);
                        };
        $separator_char eq '<' && do { # separator char is <
                            @my_rsplit = split(/</, $input_string);
                        };
    }
    # remove extra spaces
    foreach my $entry ( @my_rsplit ) {
        $entry =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
        $entry =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
        if ( $fixed_string ne "" ) {
            $fixed_string = "$fixed_string$separator_char$entry";
        }
        else { # first entry
            $fixed_string = "$entry";
        }
    }

    return $fixed_string; # return the fixed string
}


#
# Write a log file into the script log file, this should be used to log error messages
# Will also add the message into a message variable define by a pointer
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure
sub write_file_log {

    my $global_config_p = $_[0]; # configuration pointer
    print "Running the write_file_log() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $error_msg = $_[1]; # error message
    my $error_flag = 0; # write file control flag
    my $full_date = get_file_metadata_date($global_config_p, "yes");
    $full_date = ucfirst $full_date; # turn the first letter to upper case (ex... monday = Monday)
    my $configuration_file_name = $$global_config_p{configuration_file_name};
    my $new_log = "$full_date - $error_msg\n";
    print "log msg: $new_log" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print log message if the debug level requires it
    if  ( defined $_[2] ) { # pointer into a variable that contains all the error messages,
                            # this will be used in the mail backup report, it can be safely ignore
                            # if required
        my $p_all_error_msg = $_[2];
        $$p_all_error_msg = "$$p_all_error_msg$new_log"; # add message into the general variable of all the error messages, the email message will not contain the configuration file name
    }

    my $log_file = $$global_config_p{log_file};
    if ( $log_file ne "none" ) { # write into the log file only if the log is not OFF (not turn off)
        $new_log = "$configuration_file_name ; $new_log"; # add the configuration file name into the file log, this info will not appear in the e-message
        # open or create the log file in append >> write mode
        open(log_file_handle, ">>$log_file") or $error_flag = 1;
        if ( $error_flag == 0 ) {
            #lock the file for exclusive script use
            flock (log_file_handle, LOCK_EX) or $error_flag = 1;
            # write the log message
            print log_file_handle "$new_log", or $error_flag = 1;
            close (log_file_handle); # close the file
        }
        else {
            print "[ Warning ], unable to write into the log file\n\n";
        }
    }

    print "Function write_file_log() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result
}


#
# Check if a server is online/Upload/Download/Delete/Check a file from a ssh/sftp server using the open ssh sftp
# program or the putty psftp program (windows only).
# Notice for the open ssh sftp usage this function depends on having the Perl Expect Module installed.
# Also notice in open ssh sftp operations upload/download timeout after 12 hours
# Will return: 0 ; 1 ; 2 ; 3 ; 4 ; 90 ; 99
# Explain: 0 file upload with success ; 1 failed sftp command not available ; 2 failed unable to create the batch command file (putty psftp only) ;
#          3 failed - unable to connect or loggin into the ssh/sftp server ; 4 failed - unable to check_file/put/get/delete the file.
#          90 - file not found (check_file option) ; 99 - file found (check_file option)
sub sftp_external_commands {

    my $from_file = $_[0]; # origin file (this should be empty during the check_server operation)
    my $to_file = $_[1]; # destiny file (this should be empty during the del and check_server operation)
    my $command = $_[2]; # valid commands are: put ; get ; del ; check_server ; check_file
    my $global_config_p = $_[3]; # configuration pointer

    print "Running the sftp_external_commands() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $null_device = $$global_config_p{host_null_device}; # operating system null device (stderr)
    my $stdout_null_device = $$global_config_p{host_stdout_null_device}; # operating system null device (stdout)
    my $error_flag = 0; # used to mark errors

    my $sftp_server = $$global_config_p{sftp_server}; # sftp server
    my $sftp_server_port = $$global_config_p{sftp_server_port}; # sftp server port
    my $sftp_username = $$global_config_p{sftp_username}; # sftp username
    my $sftp_password = $$global_config_p{sftp_password}; # sftp password
    my $sftp_directory = $$global_config_p{sftp_directory}; # sftp directory
    my $sftp_transport = $$global_config_p{sftp_transport}; # sftp transport (the external command openssh sftp or putty psftp)
    my $sftp_command; # to contain the sftp or psftp command (with or without full path... full path is usually under the windows compiled version)

    if ( $sftp_transport eq "sftp" ) { # open ssh sftp

        $sftp_command = get_external_command("sftp", $global_config_p);
        $error_flag = 1 if ( test_external_command("sftp", $global_config_p) != 0 ); # test if the sftp command exists
        # sftp command is available and login into the sftp server and .... upload/dowload,check,del the file (at last)
        if ( $error_flag == 0 ) {
            sleep 30; # sleep for 30 seconds to prevent over connections into the ssh/sftp server
            my $sftp_expect;
            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                $sftp_expect = Expect->spawn("$sftp_command -oport=$sftp_server_port $sftp_username\@$sftp_server") or $error_flag = 3;
                if ( $error_flag == 0 ) {
                    $sftp_expect->debug(0); # turn off debug
                    $sftp_expect->log_stdout(0); # disable stdout output
                }
            }
            else { # if using debug mode
                $sftp_expect = Expect->spawn("$sftp_command -oport=$sftp_server_port -v $sftp_username\@$sftp_server") or $error_flag = 3;
                if ( $error_flag == 0 ) {
                    $sftp_expect->debug(2); # turn on debug
                }
            }
            if ( $error_flag == 0 ) { # if we manage to call ssh
                if ( $sftp_password ne "none" ) { # if not using a pharafrase
                    $sftp_expect->expect($$global_config_p{network_timeout}, "password:", "Password:", "PASSWORD:", "passphrase", "Passphrase", "PASSPHRASE" ) or $error_flag = 3 if ( $error_flag == 0 ); # check for the password field
                    $sftp_expect->send("$sftp_password\r") if ( $error_flag == 0 ); # Send the password
                }
                $sftp_expect->expect($$global_config_p{network_timeout}, "sftp>") or $error_flag = 3 if ( $error_flag == 0 ); # check we manage to login;
                if ( $error_flag == 0 and ($command eq "check_file" or $command eq "put" or $command eq "get" or $command eq "del") ) { # if upload/dowload,check,del the file
                    $sftp_expect->send("ls \"$from_file\"\r") if ( $command eq "check_file" ); # if checking file
                    $sftp_expect->send("put \"$from_file\" \"$to_file\"\r") if ( $command eq "put" ); # if uploading a file
                    $sftp_expect->send("get \"$from_file\" \"$to_file\"\r") if ( $command eq "get" ); # if getting a file
                    $sftp_expect->send("rm \"$from_file\"\r")  if ( $command eq "del" ); # if deleting a file
                    my $special_timeout = $$global_config_p{network_timeout}; # by default we use the use network value
                    $special_timeout = 43200 if ( $command eq "put" or $command eq "get" ); # during upload/download operatations we use a timeout value of 43200 seconds (12 hours), longer uploads/downloads will fail
                    $sftp_expect->expect($special_timeout, "sftp>") or $error_flag = 4;
                    if ( $error_flag == 0 ) { # test if the command worked... the line before sftp> should not contain any error messages
                        my $before_line = $sftp_expect->before();
                        if ( $before_line ) { # if a previous message exists
                            print "SSH Server returned line is [ $before_line ]\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
                            $before_line = lc($before_line); # lower case it to make it a little bit easiser
                            # test the commands get and del
                            if ( ($command eq "del" or $command eq "get") and ($before_line =~ "couldn't stat remote file:" or $before_line =~ "no such file") ) { # if doing operations on remote files
                                $error_flag = 4; # remark error failed to download/erase the file
                            }
                            # test the command put
                            if ( $command eq "put" and $before_line =~ "\"$from_file\" not found" ) { # if doing operations on remote files
                                $error_flag = 4; # remark error failed to upload
                            }
                            # test the ls command (check_file)
                            if ( $command eq "check_file" ) {
                                if ($before_line =~ "couldn't stat remote file:" or $before_line =~ "no such file") {
                                    $error_flag = 90; # mark remote file not found
                                }
                                else {
                                    $error_flag = 99; # mark remote file found
                                }
                            }
                        }
                    }
                }
                $sftp_expect->send("bye\r") if ( $error_flag == 0 ); # if we manage to login, logout;
                $sftp_expect->close(); # close the expect object
            }
        }
    }
    elsif ( $sftp_transport eq "psftp" ) { # putty sftp
        $sftp_command = get_external_command("psftp", $global_config_p);
        $error_flag = 1 if ( test_external_command("psftp", $global_config_p) != 0 ); # test if the sftp command exists

        if ( $error_flag == 0 ) {
            my $psftp_batch_file = get_filedir_name($$global_config_p{configuration_file_name}, $global_config_p); # path into the psctp batch command
            $psftp_batch_file = "$psftp_batch_file" . "psftp_batch.tmp"; # add the psftp_batch and tmp extension
            $psftp_batch_file = rebuild_full_path("$$global_config_p{temporary_dir}", "$psftp_batch_file", $global_config_p); # rebuild the full path pointing into the path defined by temporary_dir
            open(psftp_batch_file_file_handle, ">$psftp_batch_file") or $error_flag = 2; # create the batch file with the sftp commands
            if ( $error_flag == 0 ) {
                #lock the file for exclusive script use
                flock (psftp_batch_file_file_handle, LOCK_EX) or $error_flag = 2;
                if ( $error_flag == 0 and ( $command eq "check_file" or $command eq "put" or $command eq "get" or $command eq "del") ) { # if upload/dowload,check,del the file
                    print psftp_batch_file_file_handle "del \"$from_file\"\n", or $error_flag = 2 if ( $command eq "del" ); # if deleting a file
                    print psftp_batch_file_file_handle "put \"$from_file\" \"$to_file\"\n", or $error_flag = 2 if ( $command eq "put" ); # if uploading a file
                    print psftp_batch_file_file_handle "get \"$from_file\" \"$to_file\"\n", or $error_flag = 2 if ( $command eq "get" ); # if getting a file
                    print psftp_batch_file_file_handle "ls \"$from_file*\"\n", or $error_flag = 2 if ( $command eq "check_file" ); # list file
                }
                print psftp_batch_file_file_handle "quit\n", or $error_flag = 2; # write only the relative path
                close(psftp_batch_file_file_handle); # close the file
                if ( $error_flag == 0 ) { # if manage to create the bactch file
                    my @sftp_command_full;
                    if ( $command ne "check_file" ) { # run the command get/put/del using perl system command
                        if ( $$global_config_p{psftp_private_key_file} eq "" or $$global_config_p{psftp_private_key_file} eq "none" ) { # not using a private key file
                            if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                                @sftp_command_full = ("$sftp_command", "-batch", "-b", "\"$psftp_batch_file\"", "-P", "$sftp_server_port", "-pw", "$sftp_password", "$sftp_username\@$sftp_server", "$null_device", "$stdout_null_device"); # attempt to login into the sftp server
                            }
                            else { # using debug mode
                                @sftp_command_full = ("$sftp_command", "-batch", "-bc", "-v", "-b", "\"$psftp_batch_file\"", "-P", "$sftp_server_port", "-pw", "$sftp_password", "$sftp_username\@$sftp_server"); # attempt to login into the sftp server
                            }
                        }
                        else { # using a private key file
                            my $psftp_private_key_file = $$global_config_p{psftp_private_key_file};
                            if ( $sftp_password eq "" or $sftp_password eq "none" ) { # if not using the private key passphrase
                                if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                                    @sftp_command_full = ("$sftp_command", "-i", "\"$psftp_private_key_file\"", "-batch", "-b", "\"$psftp_batch_file\"", "-P", "$sftp_server_port", "$sftp_username\@$sftp_server", "$null_device", "$stdout_null_device"); # attempt to login into the sftp server
                                }
                                else { # using debug mode
                                    @sftp_command_full = ("$sftp_command", "-i", "\"$psftp_private_key_file\"", "-batch", "-bc", "-v", "-b", "\"$psftp_batch_file\"", "-P", "$sftp_server_port", "$sftp_username\@$sftp_server"); # attempt to login into the sftp server
                                }
                            }
                            else { # if using private key passphrase
                                if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                                    @sftp_command_full = ("$sftp_command", "-i", "\"$psftp_private_key_file\"", "-batch", "-b", "\"$psftp_batch_file\"", "-P", "$sftp_server_port", "-pw", "$sftp_password", "$sftp_username\@$sftp_server", "$null_device", "$stdout_null_device"); # attempt to login into the sftp server
                                }
                                else { # using debug mode
                                    @sftp_command_full = ("$sftp_command", "-i", "\"$psftp_private_key_file\"", "-batch", "-bc", "-v", "-b", "\"$psftp_batch_file\"", "-P", "$sftp_server_port", "-pw", "$sftp_password", "$sftp_username\@$sftp_server"); # attempt to login into the sftp server
                                }
                            }
                        }
                        system("@sftp_command_full") == 0 or $error_flag = 3; # mark error unable to connect into the sftp server
                    }
                    else { # run the command ls and process the list returned to check if the file exists on the remote sftp server
                        my @return_listing;
                        @return_listing = `$sftp_command -batch -b \"$psftp_batch_file\" -P $sftp_server_port -pw $sftp_password $sftp_username\@$sftp_server $null_device`;
                        if ( $? != 0 ) { # detect if the command executed correcly
                            $error_flag = 3; # failed to run the ls command
                        }
                        else { # command runned ok now read the list (ls) and see if the file exists on the file
                            my $from_file_name = get_filedir_name($from_file, $global_config_p, "/"); # get the remote file name
                            $error_flag = 90; # by default we mark file not found
                            foreach my $single_entry (@return_listing) { # process the list returned by the command, and look for the file we are searching for
                                if ( $single_entry =~ /\s$from_file_name/ ) {
                                    $error_flag = 99; # mark file exists
                                    last; # no need to remain here
                                }
                            }
                        }
                    }
                }
            }
            unlink "$psftp_batch_file" if ( -f $psftp_batch_file ); # erase the temporary file
        }
    }

    print "Function sftp_external_commands() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result

}


#
# moving the backup files into the final destination, the files can be placed into
# another directory, a ftp server, a tape device or into one or more email accounts.
# Will return: 0 ; 1 ; 2
# Explain: 0 is success ; 1 is failure ; 2 is failure when attempted to erase a damaged backup file
#          from a ftp server
sub put_backup_file {

    my $from_file_perl = $_[0]; # origin file, to be passed to perl commands
    my $to_file_perl = $_[1]; # destiny file, to be passed to perl commands
    my $network_connection_p = $_[2]; # ftp connection object
    my $global_config_p = $_[3]; # configuration pointer
    print "Running the put_backup_file() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[4]; # pointer into the email body string

    my $null_device = $$global_config_p{host_null_device}; # operating system null device
    my $error_flag = 0; # to mark errors

    if ( $$global_config_p{backup_working} eq "local file system" ) { # local file system move (mv / move)
        if ( !-f $to_file_perl ) { # only move files if there is no duplicated copy on the destiny location
            $error_flag = move_file("$from_file_perl","$to_file_perl", 16384, $global_config_p); # copy the backup file into the final location
        }
        else { # file with the same name already exists on the destiny directory
            $error_flag = 1; # mark error
        }
    }
    elsif ( $$global_config_p{backup_working} eq "ftp" ) { # ftp move (NET::FTP) and unlink command
        $$network_connection_p->binary(); # put in binary download mode
        if ( $$network_connection_p->size($to_file_perl) ) { # check if the file already exists on the ftp server
            write_file_log($global_config_p, "Error : the backup file already exists on the ftp server, the file is [ $to_file_perl ]", $log_body_p); # write the error message into the script error file
            $error_flag = 1; # mark error
        }
        else {
            if ( !$$network_connection_p->put( "$from_file_perl", "$to_file_perl" ) ) {
                write_file_log($global_config_p, "Error : unable to upload the backup file into the ftp server, it might be lack of permissions, lack of free space or the ftp connection might have dropped, the file is [ $to_file_perl ]", $log_body_p); # write the error message into the script error file
                $error_flag = 1; # mark error
                # now attempt to delete the uploaded file from the ftp server, it might have been partly uploaded
                if ( $$network_connection_p->size($to_file_perl) and $$network_connection_p->size($to_file_perl) >= 0 ) { # check if the file exists
                    write_file_log($global_config_p, "Attempting to erase existing incomplete backup file on the ftp server", $log_body_p); # write the error message into the script error file
                    if ( !($$network_connection_p->delete($to_file_perl)) ) { # erase the file
                        # warn that it failed to erase the previous backup file on the ftp server
                        write_file_log($global_config_p, "Error : failed to erase the damaged backup file on the remote ftp server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                        write_file_log($global_config_p, "Warning : the backup file [ $to_file_perl ] available on the ftp server is corrupted", $log_body_p); # write the error message into the script error file
                        return 2; # return error
                    }
                }
             }
             else { # upload success, erase the local file
                unlink "$from_file_perl"; # erasing the temporary file
             }
        }
    }
    elsif ( $$global_config_p{backup_working} eq "sftp" ) { # sftp
        if ( $$global_config_p{sftp_transport} eq "net::ssh2" ) { # if using the Net::SSH2 perl module
            if ( $$network_connection_p->do_stat($to_file_perl) ) { # check if the file already exists on the ftp server
                write_file_log($global_config_p, "Error : the backup file already exists on the sftp server, the file is [ $to_file_perl ]", $log_body_p); # write the error message into the script error file
                $error_flag = 1; # mark error
            }
            else {
                if ( !$$network_connection_p->put($from_file_perl, $to_file_perl) ) {
                    write_file_log($global_config_p, "Error : unable to upload the backup file into the sftp server, it might be lack of permissions, lack of free space or the sftp connection might have dropped, the file is [ $to_file_perl ]", $log_body_p); # write the error message into the script error file
                    $error_flag = 1; # mark error
                    # now attempt to delete the uploaded file from the ftp server, it might have been partly uploaded
                    if ( $$network_connection_p->do_stat($to_file_perl) ) { # check if the file exists
                        write_file_log($global_config_p, "Attempting to erase existing incomplete backup file on the sftp server", $log_body_p); # write the error message into the script error file
                        if ( !($$network_connection_p->do_remove($to_file_perl)) ) { # erase the file
                            # warn that it failed to erase the previous backup file on the ftp server
                            write_file_log($global_config_p, "Error : failed to erase the damaged backup file on the remote sftp server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                            write_file_log($global_config_p, "Warning : the backup file [ $to_file_perl ] available on the sftp server is corrupted", $log_body_p); # write the error message into the script error file
                            return 2; # return error
                        }
                    }
                }
                else { # upload success, erase the local file
                    unlink "$from_file_perl"; # erasing the temporary file
                }
            }
        }
        elsif ( $$global_config_p{sftp_transport} eq "psftp" or $$global_config_p{sftp_transport} eq "sftp" ) { # if using the openssh sftp or psftp putty program (windows)
            my $sftp_transport = $$global_config_p{sftp_transport};
            my $special_error_flag = sftp_external_commands($from_file_perl, $to_file_perl, "put", $global_config_p);
            if ( $special_error_flag != 0 ) { # put failed
                $error_flag = 1; # mark error
                # write the error message into the script error file, psftp command not available
                write_file_log($global_config_p, "Error : unable to upload the backup file into the sftp server, because the $sftp_transport command is not available", $log_body_p) if ( $special_error_flag == 1 );
                # write the error message into the script error file, unable to create the batch command file
                write_file_log($global_config_p, "Error : unable to upload the backup file into the sftp server, unable to create the sftp batch command file, it might be lack of permissions or lack of free space on the temporary dir", $log_body_p) if ( $special_error_flag == 2 ); 
                # write the error message into the script error file, unable to create the batch command file
                write_file_log($global_config_p, "Error : unable to upload the backup file into the sftp server, ssh/sftp server is not online or the username/password/passphrase combination is invalid", $log_body_p) if ( $special_error_flag == 3 ); 
                if ( $special_error_flag == 4 ) { # write the error message into the script error file, upload failed, part of the file still exists
                    write_file_log($global_config_p, "Error : unable to upload the backup file into the sftp server, it might be lack of permissions, lack of free space or the sftp connection might have dropped, the file is [ $to_file_perl ]", $log_body_p);
                    if ( sftp_external_commands($to_file_perl, "", "check_file", $global_config_p) == 99 ) { # delete the damaged file if it exists
                        if ( sftp_external_commands($to_file_perl, "", "del", $global_config_p) != 0 ) { # attempt to erase the damaged file from the ssh server
                            write_file_log($global_config_p, "Error : failed to erase the damaged backup file on the remote sftp server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                            write_file_log($global_config_p, "Warning : the backup file [ $to_file_perl ] available on the sftp server is corrupted", $log_body_p); # write the error message into the script error file
                            return 2; # return error
                        }
                    }
                }
            }
            else { # upload success, erase the local file
                unlink "$from_file_perl"; # erasing the temporary file
            }
        }
    }
    elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # http dav move (HTTP::DAV) and unlink command
        my $from_file_perl_tmp = $from_file_perl;
        $from_file_perl_tmp =~ s/\\/\\\\/g; # replace \ with \\    to prevent problems with the http dav module under Windows Systems
        eval {
            if ( !$$network_connection_p->put( -local => "$from_file_perl_tmp", -url => "$to_file_perl" ) ) {
                write_file_log($global_config_p, "Error : unable to upload the backup file into the http dav server, it might be lack of permissions, lack of free space or the sftp connection might have dropped, the file is [ $to_file_perl ]", $log_body_p); # write the error message into the script error file
                $error_flag = 1; # mark error
                # now attempt to delete the uploaded file from the ftp server, it might have been partly uploaded
                write_file_log($global_config_p, "Attempting to erase existing incomplete backup file on the http dav server", $log_body_p); # write the error message into the script error file
                if ( !$$network_connection_p->delete(-url=>"$to_file_perl") ) { # erase the file
                    # warn that it failed to erase the previous backup file on the ftp server
                    write_file_log($global_config_p, "Error : failed to erase the damaged backup file on the remote http dav server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                    write_file_log($global_config_p, "Warning : the backup file [ $to_file_perl ] available on the http dav server is corrupted", $log_body_p); # write the error message into the script error file
                    return 2; # return error
                }
            }
            else { # upload success, erase the local file
                unlink "$from_file_perl"; # erasing the temporary file
            }
        };
        if ($@) {
            write_file_log($global_config_p, "Error : unable to upload the backup file into the http dav server, because of a http dav server bug", $log_body_p); # write the error message into the script error file
            $error_flag = 2; # mark error
        }

    }
    elsif ( $$global_config_p{backup_working} eq "tape" or $$global_config_p{backup_working} eq "smtp" ) { # tape backup or smtp backup
        my @full_path_final_file_name_split = split( /</, $to_file_perl);
        if ( ! chdir "$$global_config_p{temporary_dir}" ) { # attempt to change into the temporary directory
            $error_flag = 1; # return failure
        }
        else {
            foreach my $backup_file_name ( @full_path_final_file_name_split ) { # rename each temporary backup file into his final name
                $backup_file_name = get_filedir_name("$backup_file_name", $global_config_p);
                rename("_tmp_$backup_file_name", "$backup_file_name") or $error_flag = 1; # rename the file from something with _tmp_ into some someone without... example _tmp_1.myname.zip into 1.myname.zip
                last if $error_flag == 1; # exit on the first error
            }
        }
        if ( $error_flag == 0 and $$global_config_p{backup_working} eq "tape" ) { # tape backup
            my $local_tape_device = $$global_config_p{tape_device}; # tape device
            my @tape_command; # will contain the command that places the backup data on a the tape
            switch: {
                $$global_config_p{tape_command} eq "tar" && do { # if we are using tar to place data on tape
                                if ( $$global_config_p{debug_level} ne "half" and $$global_config_p{debug_level} ne "full" ) {
                                    @tape_command = ("tar", "-cf", "\"$local_tape_device\"", "\"$to_file_perl\"", "$null_device");
                                }
                                else { # using debug mode
                                    @tape_command = ("tar", "-cf", "\"$local_tape_device\"", "\"$to_file_perl\"");
                                }
                            };
            }
            system("@tape_command") == 0 or $error_flag = 1; # do backup and if we return 1 something failed
        }
        elsif ( $error_flag == 0 and $$global_config_p{backup_working} eq "smtp" ) { # smtp backup
            my $text_note = $$global_config_p{text_note}; # put it in order to easy put it inside a text string
            my $all_size = 0; # contain the size of all files
            my $compressed_file_size_limit = $$global_config_p{compressed_file_size_limit};
            if ( $compressed_file_size_limit != 0 ) { # if a backup limit is defined
                $compressed_file_size_limit = "$compressed_file_size_limit Kbytes";
            }
            else { # No limit is configured
                $compressed_file_size_limit = "None configured";
            }
            my $my_hostname = $$global_config_p{hostname}; # machine hostname
            my $my_username = $$global_config_p{username}; # username
            my $my_configuration_file_name = $$global_config_p{configuration_file_name}; # configuration file name
            my $email_log_body = "";
            $email_log_body .= $$global_config_p{text_note} . "\n\n\n" if $$global_config_p{text_note} ne ""; # put in the personal note
            $email_log_body .= "Email Details...\n";
            $email_log_body .= " Generated by : simplebackup.pl v$script_version - $script_last_update\n";
            $email_log_body .= " Backup Date .: " . (localtime(time())) . "\n";
            $email_log_body .= " On hostname .: $my_hostname\n";
            $email_log_body .= " By the user .: $my_username\n";
            $email_log_body .= " From mail address ....: " . $$global_config_p{backup_mail_from_address} . "\n";
            $email_log_body .= " To mail address(es) ..: " . $$global_config_p{backup_mail_to_addresses} . "\n";
            $email_log_body .= " Configuration file ...: $my_configuration_file_name\n";
            $email_log_body .= " Attachment method ....: " . $$global_config_p{backup_mail_attachment_method} . "\n";
            $email_log_body .= " Attachment size limit : $compressed_file_size_limit\n";
            $email_log_body .= " Backup mode is .......: " . $$global_config_p{backup_mode} . "\n";
            if ( $$global_config_p{backup_mode} ne "full" ) {
                $email_log_body .= " This backup is .......: " . $$global_config_p{backup_real_mode} . "\n\n";
            }
            $email_log_body .= " Backup list is .......: " . $$global_config_p{input_backup} . "\n\n\n";
            $email_log_body .= "Attached file(s) list...\n";
            foreach my $backup_file_name ( @full_path_final_file_name_split ) { # add each backup file into the mail
                # get the present file size (in bytes)
                my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$present_mtime,$ctime,$blksize,$blocks) = stat("$backup_file_name");
                $all_size = $all_size + $size;
                my $size_kbytes = sprintf("%.2f",$size/1024); # 1024 bytes = 1 Kbyte
                my $size_mbytes = sprintf("%.2f",$size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                my $backup_file_name = get_filedir_name("$backup_file_name", $global_config_p); # extract only the file name
                $email_log_body .= "[ $backup_file_name ]\nSize: $size_mbytes Mbytes / $size_kbytes Kbytes\n\n";
            }
            my $all_size_kbytes = sprintf("%.2f",$all_size/1024); # 1024 bytes = 1 Kbyte
            my $all_size_mbytes = sprintf("%.2f",$all_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
            $email_log_body .= "Total size : $all_size_mbytes Mbytes / $all_size_kbytes Kbytes\n\n";
            $email_log_body .= "End of email backup\n\n";
            if ( $error_flag == 0 ) { # if no error occured send the email
                # detect errors
                $error_flag = 1 if ( send_email("Simplebackup Email Backup [ $my_hostname ; $my_configuration_file_name ]", $email_log_body, "$to_file_perl", "$$global_config_p{backup_mail_server}", "$$global_config_p{backup_mail_port}", "$$global_config_p{backup_mail_from_address}", "$$global_config_p{backup_mail_to_addresses}", "$$global_config_p{backup_mail_username}", "$$global_config_p{backup_mail_password}", "simplebackup.pl v$script_version - $script_last_update", $global_config_p, $log_body_p) != 0 );
            }
        }
        # erase any left over files
        foreach my $backup_file_name ( @full_path_final_file_name_split ) {
            unlink "$backup_file_name" if ( -f "$backup_file_name" ); # erase the left over file
        }
    }
    # check if move worked, for backup modes not equal to tape
    if ( $$global_config_p{backup_working} ne "tape" and $$global_config_p{backup_working} ne "smtp") {
        if ( $error_flag == 1 or (-f "$from_file_perl" and (!-f "$to_file_perl" and $$global_config_p{backup_working} eq "local file system") ) ) { # if there where any errors moving the file show them, being carefull to consider ftp backups
            $error_flag = 1; # mark error
        }
    }

    print "Function put_backup_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result
}


#
# Receive a full file/directory path and return the name of the directory or filename.
# Will return: a string
# Explain: the string it a directory path
sub get_filedir_name {

    my $filedir_name_path = $_[0]; # full path into directory or file
    my $global_config_p = $_[1]; # pointer into the configuration
    my $file_separator = $_[2]; # file separator should read / or \
    print "Running the get_filedir_name() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    $file_separator = $$global_config_p{host_file_separator} if ( ! defined $file_separator );
    my @my_split;

    # deal with Operating System dependend stuff
    if ( $file_separator eq "/" ) {
        @my_split = split ( "/", $filedir_name_path ); # unix type paths
    }
    else {
        @my_split = split ( /\\/, $filedir_name_path ); # microsoft type paths
    }
    my $size_value = scalar(@my_split) - 1 ; # read the array size, note array starts at zero size is always bigger
    my $filedir_name = $my_split[$size_value]; # file or directory name

    # deal with Operating System dependend stuff again... check if it's backup up of / or d: ( drive: )
    if ( $$global_config_p{host_os} eq "unix" and ! defined $filedir_name ) { # unix type paths and the path is / (in this case it's detected as undefined)
        $filedir_name = "root"; # backup starting from the root drive /
    }
    elsif ( $filedir_name =~ ":" ) { # microsoft type paths and if it countains the : caracter example D: 
        my @new_my_split = split ( /:/, $filedir_name);
        $filedir_name = "disk_$new_my_split[0]"; # backup of a entire windows partition
    }

    print "Function get_filedir_name() exit value is [ $filedir_name ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $filedir_name;
}


#
# Receive a full directory path and return the name of the last directory or filename,
# in a remote server (ftp/scp).
# Will return: a string
# Explain: the string it a directory path
sub get_filedir_name_remote {

    my $filedir_name_path = $_[0]; # full path into directory or file
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the get_filedir_name_remote() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my @my_split;

    @my_split = split ( "/", $filedir_name_path ); # unix type paths

    my $size_value = scalar(@my_split) - 1 ; # read the array size, note array starts at zero size is always bigger
    my $filedir_name = $my_split[$size_value]; # file or directory name

    if ( $filedir_name eq "" ) { # if there is no / on the ftp file name
        $filedir_name = $filedir_name_path;
    }

    print "Function get_filedir_name_remote() exit value is [ $filedir_name ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $filedir_name;
}


#
# Return the previous directory name, example  /directory/another/directory the previous
# is /directory/another
# Will return the same directory if the path is a root directory example D:\ or /
# Will return: a string
# Explain: the string it a directory path
sub get_previous_filedir_name {

    my $filedir_name_path = $_[0]; # full path into directory or file
    my $global_config_p = $_[1]; # pointer into the configuration
    my $file_separator = $_[2]; # file separator should read / or \

    print "Running the get_previous_filedir_name() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    $file_separator = $$global_config_p{host_file_separator} if ( ! defined $file_separator );

    my @my_split;
    my $previous_dir_fullpath;

    # deal with Operating System dependend stuff
    if ( $file_separator eq "/" ) {
       @my_split = split ( "/", $filedir_name_path ); # unix type paths
    }
    else {
        @my_split = split ( /\\/, $filedir_name_path ); # microsoft type paths
    }
    my $size_value = scalar(@my_split); # array size
    if ( ( $size_value == 0 and $$global_config_p{host_os} eq "unix" ) or ( $size_value == 1 and $$global_config_p{host_os} ne "unix" ) ) { # we are at a starting point... D:\  or / for example
        $previous_dir_fullpath = $filedir_name_path; # unix paths
    }
    $size_value = $size_value - 2; # array size up to the previous backup directory
    if ( $size_value == 0 and $$global_config_p{host_os} ne "unix" ) { # if microsoft path's
        $previous_dir_fullpath = "$my_split[0]$file_separator";
        return $previous_dir_fullpath;
    }

    for my $i ( 0 .. $size_value ) {
        if ( $i == 0 and $size_value > 0 ) { # first part
            $previous_dir_fullpath = "$my_split[$i]";
        }
        elsif ( $i == 0 and $size_value == 0 and $$global_config_p{host_os} eq "unix" ) { # second part unix only
            $previous_dir_fullpath = $file_separator; # backuping up a unix directory close to root, example /etc
        }
        else { # next path's
            $previous_dir_fullpath = "$previous_dir_fullpath$file_separator$my_split[$i]";
        }
    }

    print "Function get_previous_filedir_name() exit value is [ $previous_dir_fullpath ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $previous_dir_fullpath;
}


#
# Receive a date in the format DD-MM-YYYY (01-12-2004) and test if it's valid or not
# Please notice that this does not test the date in 100% !!!
# Will return: 0 ; 1
# Explain: 0 (valid date) ; 1 (invalid date)
sub test_date {

    my $date_to_test = $_[0]; # string representing the date
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the test_date() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my @date_to_test_parts = split(/-/, $date_to_test);
    # test the date
    if ( scalar(@date_to_test_parts) == 3 and (length($date_to_test_parts[0]) == 2 and $date_to_test_parts[0] =~ /^\d+$/ and $date_to_test_parts[0] > 0 and $date_to_test_parts[0] <= 31) and (length($date_to_test_parts[1]) == 2 and $date_to_test_parts[1] =~ /^\d+$/ and $date_to_test_parts[1] > 0 and $date_to_test_parts[1] <= 12) and (length($date_to_test_parts[2]) == 4 and $date_to_test_parts[2] =~ /^\d+$/ and $date_to_test_parts[2] >= 1980) ) {
        print "Function test_date() exit value is [ 0 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return 0; # valid date
    }

    print "Function test_date() exit value is [ 1 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return 1; # invalid date
}


#
# Receive the backup file/directory name and return the session number + the file meta information
# in a string separated by the space char.
# Will return: a string, example "3 full monday 3-1-2005 crc97074048.zip"
sub get_filename_session_metadata {

    my $test_filename = $_[0]; # filename to test
    my $global_config_p = $_[1]; # pointer into the configuration
    my $meta_data = "";
    print "Running the get_filename_session_metadata() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $return_string = ""; # what we are returning

    my @file_parts = split( /\./, "$test_filename" );
    my $file_parts_count = scalar(@file_parts); # count the number of . in the filename

    my $backup_format = $$global_config_p{backup_format}; # extract the backup format
    my $backup_format_count = 1; # at least count 1 part (zip tar rar)
    while ($backup_format =~ /\./g) { $backup_format_count++ } # count the number of . chars

    $backup_format_count++ if ( $test_filename =~ m/\.sc+$/g );; # if using encryption there is one more . char (example home.zip = home.zip.sc)

    $meta_data = $file_parts[$file_parts_count-$backup_format_count-1]; # extract the metadata

    print "Function get_filename_session_metadata() exit value is [ $meta_data ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $meta_data; # return the values
}


#
# Clear the previous backup's
# Will return: 0 ; 1
# Explain: -1 is failure ; 0 is success - no files where erased ; any other positive number is the number of files erased
sub clear_previous_backups {

    my $session_number = $_[0]; # current session number
    my $backup_files_p = $_[1]; # pointer into the list of the backup files
    my $backup_files_details_p = $_[2]; # pointer into the list of the backup files detail list
    my $full_list_p = $_[3]; # pointer into the full list
    my $global_config_p = $_[4]; # pointer into the configuration
    print "Running the clear_previous_backups() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[5]; # pointer into the email body string
    my $file_separator = $$global_config_p{host_file_separator}; # file separator
    my $error_flag = 0; # error flag
    my $erase_file_counter = 0; # real counter that reflects the backup files erased
    my $erase_file_db_counter = 0; # counter that reflects the backup files erased from the support database file
    my $network_connection;

    if ( $$global_config_p{keep_last_n_files} == "-1" ) { # nothing to erase
        write_file_log($global_config_p, "No previous backup sessions files were erased, configuration file disables backup sessions erases", $log_body_p); # write the error message into the script error file
        print "Function clear_previous_backups() exit value is [ 0 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return 0;
    }
    else {
        if ( $error_flag == 0 ) {
             my $check_session_number = $session_number - $$global_config_p{keep_last_n_files}; # calculate the first session to erase
             if ( $check_session_number <= 1 ) {
                 write_file_log($global_config_p, "No previous backup sessions files were erased, no previous backup sessions are in conditions to be erased", $log_body_p); # write the error message into the script error file
                 print "Function clear_previous_backups() exit value is [ 0 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
                 return 0; # there nothing to erase
             }
             my @backup_files_array;
             for my $backup_files_record ( keys %$backup_files_p ) { # read the backup files list
                 push (@backup_files_array, $backup_files_record);
             }

             for my $backup_files_record ( keys %$backup_files_p ) { # read the backup files list
                 # a valid backup files record could be something like this
                 # 1<3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<123123<12/12/2005<1
                 my ($record_type, $backup_file_crc32, $compress_backup_file_name, $compress_backup_file_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_record); # split the record

                 my $session_number_id = 0;
                 my $erase_file = "yes";
                 my $erase_file_with_sucess = "no";
                 my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p)); # get the file session number
                 for $session_number_id ( $check_session_number .. $session_number ) { # search if the file is to be erased
                     if ( "$file_session_number" eq "$session_number_id" ) {
                         $erase_file = "no"; # file is on the NON ERASE LIST
                     }
                 }
                 if ( $erase_file eq "yes" ) { # file is marked to erase
                     my $erase_me = ""; # to contain the full path to the file that is supose to be erased
                     if ( $$global_config_p{backup_working} eq "local file system" ) { # local file system backup
                         $erase_me = $$global_config_p{output_backup};
                     }
                     elsif ( $$global_config_p{backup_working} eq "ftp" ) { # in ftp mode
                         $erase_me = $$global_config_p{ftp_directory}; # ftp directory
                     }
                     elsif ( $$global_config_p{backup_working} eq "sftp" ) { # in sftp mode
                         $erase_me = $$global_config_p{sftp_directory}; # sftp directory
                     }
                     elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # in http dav mode
                         $erase_me = $$global_config_p{dav_directory}; # sftp directory
                     }
                     $erase_me =~ s/[\\\/]$// if "$erase_me" ne "/";;  # Delete trailing \ or / char same thing kind of but $ represents end of line
                     if ( $erase_me eq "/" and ($$global_config_p{host_os} eq "unix" or $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav") ) { # unix type paths or ftp server
                         $erase_me = ""; # protection against ftp/sftp/http-dav paths that are / (root)
                     }
                     if ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) {
                         $erase_me = "$erase_me/$compress_backup_file_name"; # if ftp/sftp/dav paths
                         if ( $$global_config_p{backup_working} eq "http-dav" ) { # if running on http dav then you need to use the full url
                             # format is a full url: http://some_server:some_port/some_dir/some_file
                             $erase_me = $$global_config_p{dav_url} . $erase_me;
                         }
                     }
                     else { # if unix or windows path's
                         $erase_me = "$erase_me$file_separator$compress_backup_file_name";
                     }
                     if ( $$global_config_p{backup_working} ne "tape" and $$global_config_p{backup_working} ne "smtp" ) {
                         if ( ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) and !defined $network_connection ) { # if doing a ftp/sftp/http-dav backup and the  connection does not exists attempt to connect into the ftp/sftp/http-dav server
                            if ( $$global_config_p{sftp_transport} ne "psftp" and $$global_config_p{sftp_transport} ne "sftp" ) { # if NOT using psftp putty command to access the ssh/sftp server
                                my $network_type = $$global_config_p{backup_working};
                                write_file_log($global_config_p, "Connect and login into the $network_type server, for backup file erase", $log_body_p); # write the error message into the script error file
                                sleep 30; # sleep for 30 seconds in order to prevent a overkill of the ftp server with a series of fast login and logoffs
                                 if ( network_connect_login(\$network_connection, "Warning", $global_config_p, $log_body_p) != 0 ) {
                                     write_file_log($global_config_p, "Warning : $network_type server is not available, backup files will not be erased", $log_body_p); # write the error message into the script error file
                                 }
                            }
                         }
                         write_file_log($global_config_p, "Erasing previous backup session file [ $erase_me ]", $log_body_p); # write the error message into the script error file
                     }
                     else { # if "erasing from tape/smtp" this will only erase the record from the support file
                         write_file_log($global_config_p, "Erasing previous backup session file from the support file (only) [ $erase_me ]", $log_body_p); # write the error message into the script error file
                     }
                     # if we are erasing on the local file system
                     if ( $$global_config_p{backup_working} eq "local file system" ) { # erase the local file
                         if ( -f "$erase_me" ) { # test if the file exists
                             if ( unlink "$erase_me" ) { # erase the file or mark has erased if it manually erased by the user
                                 $erase_file_counter++; # add counter to erased file
                                 $erase_file_db_counter++; # add counter to erased file on the support file
                                 $erase_file_with_sucess = "yes"; # file is erased
                             }
                             else { # warn that it failed to erase the previous backup file on the local server
                                 write_file_log($global_config_p, "Warning : failed to erase the previous backup file, you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                             }
                         }
                         else { # file does not exists
                             $erase_file_with_sucess = "yes"; # file is erased
                             $erase_file_db_counter++; # add counter to erased file on the support file
                             write_file_log($global_config_p, "Warning : previous backup file does not exists on the local directory", $log_body_p); # write the error message into the script error file
                         }
                     }
                     elsif ($$global_config_p{backup_working} eq "ftp" ) { # erase the remote ftp file
                         if ( defined $network_connection ) {
                             if ( $network_connection->size($erase_me) ) { # check if the file exists
                                 if ( $network_connection->delete($erase_me) ) { # check if the erase of the remote file worked
                                     $erase_file_counter++; # add counter to erased file
                                     $erase_file_db_counter++; # add counter to erased file on the support file
                                     $erase_file_with_sucess = "yes"; # file is erased
                                 }
                                 else { # warn that it failed to erase the previous backup file on the ftp server
                                     write_file_log($global_config_p, "Warning : failed to erase the previous backup file on the remote ftp server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                                 }
                             }
                             else { # file does not exists
                                 $erase_file_with_sucess = "yes"; # file is erased
                                 $erase_file_db_counter++; # add counter to erased file on the support file
                                 write_file_log($global_config_p, "Warning : previous backup file does not exists on the remote ftp server", $log_body_p); # write the error message into the script error file
                             }
                         }
                     }
                     elsif ($$global_config_p{backup_working} eq "sftp" ) { # erase the remote sftp file
                         if ( $$global_config_p{sftp_transport} eq "net::ssh2" ) {
                             if ( defined $network_connection ) {
                                 if ( $network_connection->do_stat($erase_me) ) { # check if the file exists
                                     if ( $network_connection->do_remove($erase_me) ) { # check if the erase of the remote file worked
                                         $erase_file_counter++; # add counter to erased file
                                         $erase_file_db_counter++; # add counter to erased file on the support file
                                         $erase_file_with_sucess = "yes"; # file is erased
                                     }
                                     else { # warn that it failed to erase the previous backup file on the ftp server
                                         write_file_log($global_config_p, "Warning : failed to erase the previous backup file on the remote sftp server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                                     }
                                 }
                                 else { # file does not exists
                                     $erase_file_with_sucess = "yes"; # file is erased
                                     $erase_file_db_counter++; # add counter to erased file on the support file
                                     write_file_log($global_config_p, "Warning : previous backup file does not exists on the remote sftp server", $log_body_p); # write the error message into the script error file
                                 }
                             }
                         }
                        elsif ( $$global_config_p{sftp_transport} eq "psftp" or $$global_config_p{sftp_transport} eq "sftp" ) { # if using the openssh sftp or psftp putty program (windows)
                            if ( sftp_external_commands($erase_me, "", "del", $global_config_p) == 0 ) { # attempt to erase the file from the ssh server
                                $erase_file_counter++; # add counter to erased file
                                $erase_file_db_counter++; # add counter to erased file on the support file
                                $erase_file_with_sucess = "yes"; # file is erased
                            }
                            else { # warn that it failed to erase the previous backup file on the ftp server
                                write_file_log($global_config_p, "Warning : failed to erase the previous backup file on the remote sftp server, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                            }
                        }
                     }
                     elsif ($$global_config_p{backup_working} eq "http-dav" ) { # erase the remote http dav file
                         if ( defined $network_connection ) {
                             eval {
                                 if ( $network_connection->delete(-url=>"$erase_me") ) { # check if the erase of the remote file worked
                                     $erase_file_counter++; # add counter to erased file
                                     $erase_file_db_counter++; # add counter to erased file on the support file
                                     $erase_file_with_sucess = "yes"; # file is erased
                                 }
                                 else { # warn that it failed to erase the previous backup file on the ftp server
                                     write_file_log($global_config_p, "Warning : failed to erase the previous backup file on the remote http dav server, the file might no longer exist, the connection might have dropped or you might not have the correct permissions", $log_body_p); # write the error message into the script error file
                                 }
                             };
                             if ($@) {
                                 write_file_log($global_config_p, "Warning : failed to erase the previous backup file on the remote http dav server, because of a http dav server bug", $log_body_p); # write the error message into the script error file
                             }
                         }
                     }
                     elsif ($$global_config_p{backup_working} eq "tape" or $$global_config_p{backup_working} eq "smtp" ) { # "erase" from the tape device or smtp mail, this will only erase the entry from the history file
                         $erase_file_counter++;
                         $erase_file_db_counter++; # add counter to erased file on the support file
                         $erase_file_with_sucess = "yes"; # file is erased
                     }
                     if ( $erase_file_with_sucess eq "yes" ) {
                         delete $$backup_files_p{$backup_files_record}; # delete the record from the backup file list
                         patch_backup_files_details_records($backup_files_details_p, "", $compress_backup_file_name, "", "delete", $global_config_p, $log_body_p); # delete the record from the backup file details list
                         patch_full_list_records($full_list_p, $file_session_number, "delete", $global_config_p, $log_body_p);
                     }
                 }
             }
        }
    }

    if ( defined $network_connection and ($$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav") ) { # disconnect the ftp server, if connected before
        my $network_type = $$global_config_p{backup_working};
        write_file_log($global_config_p, "Disconnecting from $network_type server",$log_body_p); # write the error message into the script error file
        if ( $$global_config_p{backup_working} eq "ftp" ) {
            $network_connection->quit(); # disconnect from ftp server
            $network_connection = undef;
        }
        elsif ( $$global_config_p{backup_working} eq "sftp" ) { # disconnect the sftp server, if connected before
            $network_connection = undef;
        }
        else { # disconnect the http-dav server, if connected before
            $network_connection->unlock( -url => $$global_config_p{dav_url_full} );
            $network_connection = undef;
        }
    }
    if ( $error_flag == 0 ) { # only write this last message if there where no errors
        if ( $$global_config_p{backup_working} ne "tape" and $$global_config_p{backup_working} ne "smtp" ) { # if actualy erasing session files
            write_file_log($global_config_p, "Erased [ $erase_file_counter ] previous backup session files", $log_body_p); # write the error message into the script error file
        }
        else {
            write_file_log($global_config_p, "Erased [ $erase_file_counter ] previous backup sessions from the support file (only)", $log_body_p); # write the error message into the script error file
        }
        $error_flag = $erase_file_db_counter;
    }

    print "Function clear_previous_backups() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result
}


#
# Sum all the backup files and sizes sizes and also all files contain inside the backup files/directories 
# and sizes and return the all that info, sizes are return in bytes
# Will return:; a list of integer numbers separated by the space char in the format :
# "current_session_files_number current_session_files_size current_backup_details_number current_backup_details_size all_session_files_number all_session_files_size all_backup_details_number all_backup_details_size"
# Explain: a list of integers that report files count and file sizes total
sub sum_all_backups {

    my $backup_files_p = $_[0]; # pointer into the list of the backup files
    my $supp_backup_files_details_p = $_[1]; # pointer into the list of the backup files details
    my $current_session = $_[2]; # session number
    my $global_config_p = $_[3]; # pointer into the configuration
    print "Running the sum_all_backups() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[4]; # pointer into the email body string
    my $error_flag = 0; # error flag
    my $sum_all_backups = 0; # total of backup files created by simplebackup
    my $sum_all_backups_size = 0; # the total size (in bytes) of the backup files created by simplebackup
    my $sum_all_backups_details = 0; # total files and directories inside of the backup files created by simplebackup
    my $sum_all_backups_details_size = 0; # total size of the files (in bytes) inside of the backup files created by simplebackup
    my $sum_current_backups = 0; # total of backup files created by simplebackup during the current backup session
    my $sum_current_backups_size = 0; # the total size (in bytes) of the backup files created by simplebackup during the current backup session
    my $sum_current_backups_details = 0; # total files and directories inside of the backup files created by simplebackup during the current backup session
    my $sum_current_backups_details_size = 0; # total size of the files (in bytes) inside of the backup files created by simplebackup during the current backup session

    for my $backup_files_record (keys %$backup_files_p) { # read the all backup files list
        my ($backup_files_record_type, $backup_files_backup_file_crc32, $backup_files_backup_file_name, $backup_files_backup_file_size, $backup_files_data_last_rdate, $backup_files_data_rcount ) = split(/</, $backup_files_record); # split the record

        $sum_all_backups++; # found one more file
        $sum_all_backups_size = $sum_all_backups_size + $backup_files_backup_file_size; # add the current file size to the total

        # get the compress backup file metadata
        my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($backup_files_backup_file_name, $global_config_p)); # get the file session number
        my $is_from_current_session = "no";
        if ( $current_session == $file_session_number ) { # if the backup file in question is from the current backup session
            $is_from_current_session = "yes";
            $sum_current_backups++; # found one more file that is from the current backup session
            $sum_current_backups_size = $sum_current_backups_size + $backup_files_backup_file_size # add the current file size to the total size of current backup files
        }

        for my $backup_files_details_record (keys %$supp_backup_files_details_p) { # read the all backup files list
            # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
            my ($backup_files_details_record_type, $backup_files_details_backup_file_crc32, $backup_files_details_backup_file_name, $backup_files_details_data_start_path, $backup_files_details_data_relative_path, $backup_files_details_data_modification_time, $backup_files_details_data_size, $backup_files_details_data_last_rdate, $backup_files_details_data_rcount ) = split(/</, $backup_files_details_record); # split the record
            if ( $backup_files_backup_file_name eq $backup_files_details_backup_file_name ) { # check on the details records for records belonging to the file in question (defined by backup_files_backup_file_name)
                $sum_all_backups_details++; # found one more file or directory
                $sum_all_backups_details_size = $sum_all_backups_details_size + $backup_files_details_data_size if ( $backup_files_details_data_size ne "dir" ); # add the file size (if not a directory)
                if ( $is_from_current_session eq "yes" ) { # if the backup file in question is from the current backup session
                    $sum_current_backups_details++;
                    $sum_current_backups_details_size = $sum_current_backups_details_size + $backup_files_details_data_size if ( $backup_files_details_data_size ne "dir" ); 
                }
            }
        }
    }

    # the record returned is a bunch of numbers separated by the " " (space char)
    # the format is:  "current_session_files_number current_session_files_size current_backup_details_number current_backup_details_size all_session_files_number all_session_files_size all_backup_details_number all_backup_details_size"
    # example "2 203912 30 9871231 10 987123 70 848127312"
    $error_flag = "$sum_current_backups $sum_current_backups_size $sum_current_backups_details $sum_current_backups_details_size $sum_all_backups $sum_all_backups_size $sum_all_backups_details $sum_all_backups_details_size";

    print "Function sum_all_backups() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the apropriated value
}


#
# Sum the types (full, incremental, differencial) of backup files based on a list (array)
# that contains the full path of the backup data
# Will return: a string
# Explain: a string containing the count off all types separated by the space char,
# example "10, 20, 0, 30" 10 is the full backups count ; 20 is the count of all incremental ; 0 is
# the count of all differencial and 30 is the count of all backups tapes 10 + 20 + 0 = 30
sub sum_backup_types {

    my $backup_files_p = $_[0]; # pointer into the list of the backup files
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the sum_backup_types() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[2]; # pointer into the email body string

    # the counters
    my $full_counter = 0;
    my $incremental_counter = 0;
    my $differencial_counter = 0;
    my $total_counter = 0;
    my $return_value = "";

    foreach my $backup_files_record (keys %$backup_files_p) {
        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $compress_backup_file_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_record); # split the record

        # get the file metadata
        my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
        # start counting the types
        switch: {
            $file_type eq "full" && do {
                            $full_counter++; # add to full
                        };
            $file_type eq "incremental" && do {
                            $incremental_counter++; # add to incremental
                        };
            $file_type eq "differential" && do {
                            $differencial_counter++; # add to differencial
                        };
        }

    }

    $total_counter = $full_counter + $incremental_counter + $differencial_counter;
    $return_value = "$full_counter $incremental_counter $differencial_counter $total_counter";

    print "Function sum_backup_types() exit value is [ $return_value ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return "$return_value"; # return the values
}


#
# Connect into a ftp / sftp or http dav server and login.
# Will get all the configuration data from the main configuration hash, plus the
# dbi connection object and try to connect into the ftp server and login, if configured
# by the user on the configuration file it will retry the ftp connection for several
# times and change the passive mode setting
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub network_connect_login {

    my $network_connection_p = $_[0]; # ftp dbi connection pointer
    my $error_level = $_[1]; # error level: it should be  Error OR Warning ; it's directly related to the text written on the log 
    my $global_config_p = $_[2]; # pointer into the configuration
    print "Running the network_connect_login() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[3]; # pointer into the email body string
    my $error_flag = 0; # error flag
    $error_level = "Error" if ( !defined $error_level or $error_level eq "" ); # fix the error level if required

    my $network_server = "";
    my $network_server_port = "";
    my $ftp_passive_mode = ""; # for ftp connections only
    my $ftp_passive_mode_real = ""; # for ftp connections only
    my $dav_url_full = ""; # for dav connections only
    my $network_username = "";
    my $network_password = "";
    my $network_debug_level_real = "";
    my $network_timeout = $$global_config_p{network_timeout}; # ftp connection timeout
    my $network_connect_retries = $$global_config_p{network_connect_retries}; # # ftp connect retries
    my $network_proxy = $$global_config_p{network_proxy};   # FTP Proxy, must work in open mode.
    my $backup_working = $$global_config_p{backup_working};
    if ( $$global_config_p{backup_working} eq "ftp" ) { # ftp mode
        $network_server = $$global_config_p{ftp_server}; # ftp server
        $network_server_port = $$global_config_p{ftp_server_port}; # ftp server port
        $ftp_passive_mode = $$global_config_p{ftp_passive_mode}; # passive mode
        $ftp_passive_mode_real = $$global_config_p{ftp_passive_mode_real};   # The real parameter passed into the NET:FTP, here is 
        $network_username = $$global_config_p{ftp_username}; # ftp username
        $network_password = $$global_config_p{ftp_password}; # ftp password
        $network_debug_level_real = $$global_config_p{ftp_debug_level_real}; # ftp debug level
    }
    elsif ( $$global_config_p{backup_working} eq "sftp" ) { # sftp mode
        $network_server = $$global_config_p{sftp_server}; # sftp server
        $network_server_port = $$global_config_p{sftp_server_port}; # sftp server port
        $network_username = $$global_config_p{sftp_username}; # sftp username
        $network_password = $$global_config_p{sftp_password}; # sftp password
        $network_debug_level_real = $$global_config_p{sftp_debug_level_real}; # sftp debug level
    }
    elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # http dav mode
        $network_server = $$global_config_p{dav_server}; # http dav server
        $dav_url_full = $$global_config_p{dav_url_full};
        $network_server_port = $$global_config_p{dav_server_port}; # http dav  server port
        $network_username = $$global_config_p{dav_username}; # http dav  username
        $network_password = $$global_config_p{dav_password}; # http dav  password
        $network_debug_level_real = $$global_config_p{dav_debug_level_real}; # sftp debug level
    }
    # try a max of N times ftp connects before giving up
    for (my $connect_try=0; $connect_try < $network_connect_retries; $connect_try++) {
        if ( $$global_config_p{backup_working} eq "ftp" and $connect_try == 3 ) { # if we are over 3 connections attempt to switch the ftp passive mode, for ftp mode ONLY
            write_file_log($global_config_p, "Notice : reversing ftp passive mode", $log_body_p); # write the error message into the script error file
            if ( $$global_config_p{ftp_passive_mode} eq "no" ) { # passive mode no, switch to yes
                $ftp_passive_mode = "yes";
                $ftp_passive_mode_real = 1;
                $$global_config_p{ftp_passive_mode} = "yes";
                $$global_config_p{ftp_passive_mode_real} = 1; # The real parameter passed into the NET:FTP, here is [ 0 ; 1 ]
            }
            else { # passive mode yes switch to no
                $ftp_passive_mode = "no";
                $ftp_passive_mode_real = 0;
                $$global_config_p{ftp_passive_mode} = "no";
                $$global_config_p{ftp_passive_mode_real} = 0; # The real parameter passed into the NET:FTP, here is [ 0 ; 1 ]
            }
        }
        if ( $connect_try > 0 ) { # connect into the FTP/SFTP/DAV server failed report that we are retrying
            write_file_log($global_config_p, "Warning : unable to connect into the $backup_working server, retrying in 60 seconds", $log_body_p); # write the error message into the script error file
            sleep 60; # wait 60 seconds before attemping to connect
        }
        write_file_log($global_config_p, "Connect and login into the $backup_working server [ $network_server:$network_server_port ] ; Proxy [  $network_proxy ] ; Passive mode [ $ftp_passive_mode ] ; Timeout [ $network_timeout ]", $log_body_p) if ( $backup_working eq "ftp" ); # write the error message into the script error file
        write_file_log($global_config_p, "Connect and login into the $backup_working server [ $network_server:$network_server_port ]", $log_body_p) if ( $backup_working eq "sftp" ); # write the error message into the script error file
        if ( $$global_config_p{backup_working} eq "ftp" ) { # connect into the ftp server
            if ( $network_proxy ne "" ) { # if we have a firewall / proxy server
                $$network_connection_p = Net::FTP->new("$network_server", Debug => $network_debug_level_real, Port => $network_server_port, Passive => $ftp_passive_mode_real, Firewall => $network_proxy, Timeout => $network_timeout );
            }
            else { # if we don't have a firewall / proxy server
                $$network_connection_p = Net::FTP->new("$network_server", Debug => $network_debug_level_real, Port => $network_server_port, Passive => $ftp_passive_mode_real, Timeout => $network_timeout );
            }
        }
        elsif ( $$global_config_p{backup_working} eq "sftp" and $$global_config_p{sftp_transport} eq "net::sftp" ) { # connect and login into the sftp server using the net:sftp module
               print "net::sftp support is not working yet\n";
        }
        elsif ( $$global_config_p{backup_working} eq "sftp" and $$global_config_p{sftp_transport} eq "net::ssh2" ) { # connect and login into the sftp server using the net:sftp module
               print "net::ssh2 support is not working yet\n";
        }
        elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # connect and login into the http dav server
            my $special_error_flag = 0;
            $$network_connection_p= new HTTP::DAV; # create the web dav object
            $$network_connection_p->DebugLevel($network_debug_level_real); # configure the web dav debug level
            eval {
                $$network_connection_p->credentials( -user=>"$network_username",-pass =>"$network_password", -url =>"$dav_url_full" ); # configure the authenticatation
                $$network_connection_p->open( -url=>"$dav_url_full") or $special_error_flag = 1; # attempt to open a connection into the web dav server
                if ( $special_error_flag == 1 ) { # check if we manage to connect
                    $$network_connection_p = (); # clear object conection failed
                }
            };
            if ( $@ ) { # possible web dav server bug retry
                $$network_connection_p = (); # clear object conection failed
            }
        }
        if ( defined $$network_connection_p ) { # test if the ftp/sftp/http-dav connection worked
            last;
        }
    }
    if ( ! defined $$network_connection_p ) { # test if the ftp /sftp / http dav connection worked
        if ( $$global_config_p{backup_working} ne "http-dav" ) {
            write_file_log($global_config_p, "$error_level : unable connect to the $backup_working server", $log_body_p); # write the error message into the script error file
        }
        else {
            write_file_log($global_config_p, "$error_level : connect and login into the http dav server [ url: $dav_url_full ] ; [  username: $network_username ] ; [ password: ***** ]", $log_body_p); # write the error message into the script error file
        }
        $error_flag = 1; # return failure
    }

    if ( $error_flag == 0 and ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" ) ) { # if managed to connect, attempt to login (use only in ftp, under sftp we connect and login in a single play)
        my $net_mode = $$global_config_p{backup_working};
        if ( ($net_mode eq "ftp" and !$$network_connection_p->login("$network_username", "$network_password")) or ($net_mode eq "sftp" and !$$network_connection_p->auth_password("$network_username", "$network_password")) ) { # login into ftp/sftp server
            write_file_log($global_config_p, "$error_level : login into the $net_mode server [ username: $network_username ] ; [ password: ***** ]", $log_body_p); # write the error message into the script error file
            $error_flag = 1; # mark error
        }
    }

    print "Function network_connect_login() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return result

}


#
# Will return the current date, formated for mail MIME, example : "Wednesday, 5 May, 2004 09:34:37 -0000"
# Will return a date
# Explain: This date is in special format to be send via email and to be understud by email clients
sub get_mail_date {

    my $global_config_p = $_[0]; # pointer into the configuration
    print "Running the get_mail_date() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    # Define the day of the week and the month of the year
    my @days   = ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
    my @months = ('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');

    # Get the current time and format the hour, minutes and seconds.
    my ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
    my $time = sprintf("%02d:%02d:%02d",$hour,$min,$sec);
    $year += 1900; # Add 1900 to the year to get the full 4 digit year

    # Format the date, in this kind "Wednesday, 5 May, 2004 09:34:37 -0000"
    my $date = "$days[$wday], $mday $months[$mon], $year $time -0000";

    print "Function get_mail_date() exit value is [ $date ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $date; # return the date

}


#
# Attachment a file into a string and return the file has a string
# encoded into base64.
# This function was copied and adapted from the send_attachment()
# function of the sendEmail program that was written by:
# Brandon Zehm <caspian@dotconf.net> , huge thankx to him.
# Will return a base64 string ; undef
# Explain: base64 string is success ; undef is failure
sub create_email_attachment {

    my $filename_path = $_[0];    # filename + full path
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the create_email_attachment() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    # Local variables
    my $converted_base64_file = ""; # will contain the converted file
    my $error_flag = 0; # to mark errors
    my $CRLF        = "\015\012";
    my @fields;
    my $y;
    my $filename_name;
    my $encoding;
    my @attachlines;
    my $content_type;
    my $bin = 1;

    $filename_name = get_filedir_name("$filename_path", $global_config_p); # Get the filename without the path

    # Autodetect Mime Type
    @fields = split(/\./, $filename_name);
    $encoding = $fields[$#fields];

    if ($encoding =~ /txt|text|log|conf|^c$|cpp|^h$|inc|m3u/i) {   $content_type = 'text/plain';                      }
    elsif ($encoding =~ /html|htm|shtml|shtm|asp|php|cfm/i) {      $content_type = 'text/html';                       }
    elsif ($encoding =~ /sh$/i) {                                  $content_type = 'application/x-sh';                }
    elsif ($encoding =~ /tcl/i) {                                  $content_type = 'application/x-tcl';               }
    elsif ($encoding =~ /pl$/i) {                                  $content_type = 'application/x-perl';              }
    elsif ($encoding =~ /js$/i) {                                  $content_type = 'application/x-javascript';        }
    elsif ($encoding =~ /man/i) {                                  $content_type = 'application/x-troff-man';         }
    elsif ($encoding =~ /gif/i) {                                  $content_type = 'image/gif';                       }
    elsif ($encoding =~ /jpg|jpeg|jpe|jfif|pjpeg|pjp/i) {          $content_type = 'image/jpeg';                      }
    elsif ($encoding =~ /tif|tiff/i) {                             $content_type = 'image/tiff';                      }
    elsif ($encoding =~ /xpm/i) {                                  $content_type = 'image/x-xpixmap';                 }
    elsif ($encoding =~ /bmp/i) {                                  $content_type = 'image/x-MS-bmp';                  }
    elsif ($encoding =~ /pcd/i) {                                  $content_type = 'image/x-photo-cd';                }
    elsif ($encoding =~ /png/i) {                                  $content_type = 'image/png';                       }
    elsif ($encoding =~ /aif|aiff/i) {                             $content_type = 'audio/x-aiff';                    }
    elsif ($encoding =~ /wav/i) {                                  $content_type = 'audio/x-wav';                     }
    elsif ($encoding =~ /mp2|mp3|mpa/i) {                          $content_type = 'audio/x-mpeg';                    }
    elsif ($encoding =~ /ra$|ram/i) {                              $content_type = 'audio/x-pn-realaudio';            }
    elsif ($encoding =~ /mpeg|mpg/i) {                             $content_type = 'video/mpeg';                      }
    elsif ($encoding =~ /mov|qt$/i) {                              $content_type = 'video/quicktime';                 }
    elsif ($encoding =~ /avi/i) {                                  $content_type = 'video/x-msvideo';                 }
    elsif ($encoding =~ /zip/i) {                                  $content_type = 'application/x-zip-compressed';    }
    elsif ($encoding =~ /tar/i) {                                  $content_type = 'application/x-tar';               }
    elsif ($encoding =~ /jar/i) {                                  $content_type = 'application/java-archive';        }
    elsif ($encoding =~ /exe|bin/i) {                              $content_type = 'application/octet-stream';        }
    elsif ($encoding =~ /ppt|pot|ppa|pps|pwz/i) {                  $content_type = 'application/vnd.ms-powerpoint';   }
    elsif ($encoding =~ /mdb|mda|mde/i) {                          $content_type = 'application/vnd.ms-access';       }
    elsif ($encoding =~ /xls|xlt|xlm|xld|xla|xlc|xlw|xll/i) {      $content_type = 'application/vnd.ms-excel';        }
    elsif ($encoding =~ /doc|dot/i) {                              $content_type = 'application/msword';              }
    elsif ($encoding =~ /rtf/i) {                                  $content_type = 'application/rtf';                 }
    elsif ($encoding =~ /pdf/i) {                                  $content_type = 'application/pdf';                 }
    elsif ($encoding =~ /tex/i) {                                  $content_type = 'application/x-tex';               }
    elsif ($encoding =~ /latex/i) {                                $content_type = 'application/x-latex';             }
    elsif ($encoding =~ /vcf/i) {                                  $content_type = 'application/x-vcard';             }
    else { $content_type = 'application/octet-stream';  }
    # Process the attachment

    # Generate and print MIME headers
    $converted_base64_file = "------MIME delimiter for Simplebackup-$CRLF";
    $converted_base64_file .= "Content-Type: $content_type;$CRLF";
    $converted_base64_file .= "        name=\"$filename_name\"$CRLF";
    $converted_base64_file .= "Content-Transfer-Encoding: base64$CRLF";
    $converted_base64_file .= "Content-Disposition: attachment; filename=\"$filename_name\"$CRLF";
    $converted_base64_file .= "$CRLF";

    # Convert the file to base64 and print it to the server
    open (FILETOATTACH, $filename_path) or $error_flag = 1; # failed to open the attachment file
    if ( $error_flag == 0 ) { # if we manage to open the file
        binmode(FILETOATTACH);                 ## Hack to make Win32 work

        my $res = "";
        my $tmp = "";
        my $base64 = "";
        while (<FILETOATTACH>) {               ## Read a line from the (binary) file
            $res .= $_;
            # Convert binary data to base64
            while ($res =~ s/(.{45})//s) {         ## Get 45 bytes from the binary string
                $tmp = substr(pack('u', $&), 1);   ## Convert the binary to uuencoded text
                chop($tmp);
                $tmp =~ tr|` -_|AA-Za-z0-9+/|;     ## Translate from uuencode to base64
                $base64 .= $tmp;
            }
            # Print chunks to the server
            while ($base64 =~ s/(.{76})//s) {
                $converted_base64_file = $converted_base64_file . "$1$CRLF";
            }
        }
        # Encode and send the leftovers
        my $padding = "";
        if ( ($res) and (length($res) >= 1) ) {
            $padding = (3 - length($res) % 3) % 3;  ## Set flag if binary data isn't divisible by 3
            $res = substr(pack('u', $res), 1);         ## Convert the binary to uuencoded text
            chop($res);
            $res =~ tr|` -_|AA-Za-z0-9+/|;             ## Translate from uuencode to base64
        }
        # Fix padding at the end
        $res = $base64 . $res;                                  ## Get left overs from above
        $res =~ s/.{$padding}$/'=' x $padding/e if $padding;    ## Fix the end padding if flag (from above) is set
        if ($res) {
            while ($res =~ s/(.{1,76})//s) {                        ## Send it to the email server.
                $converted_base64_file = $converted_base64_file . "$1$CRLF";
            }
        }
        close (FILETOATTACH); # close the file
    }

    # test for errors
    if ( $error_flag == 1 ) {
        print "Function create_email_attachment() exit value is [ ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return undef;
    }
    else {
        print "Function create_email_attachment() exit value is [ $converted_base64_file ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return $converted_base64_file
    }
}


#
# Send a email (if configured)
# Will return 0 ; 1 ; 2 ; 3 ; 4
# Explain: 0 is success ; 1 2 3 4 are failures
sub send_email {

    my $my_message_subject = $_[0]; # email message subject
    my $my_message_body = $_[1]; # email message body, the actual email text
    my $my_filenames_path = $_[2]; # eventual file(s) to atach into the email, several filenames are separed by the < char
    my $mail_server = $_[3];
    my $mail_port = $_[4];
    my $mail_from_address = $_[5];
    my $mail_to_addresses = $_[6];
    my $mail_username = $_[7];
    my $mail_password = $_[8];
    my $x_mailer = $_[9]; # name and version of the program that send the email
    my $global_config_p = $_[10]; # pointer into the configuration
    print "Running the send_email() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[11]; # pointer into the email body string
    my $error_flag = 0; # to mark errors
    my $mail_to_addresses_valid = ""; # this will contain the mail addresses that were accepted by the mail server
    # mail configuration stuff
    my $mail_type = $$global_config_p{mail_type};
    my $mail_timeout = $$global_config_p{network_timeout};
    my $mail_debug_level_real = $$global_config_p{mail_debug_level_real}; # debug level
    my $failed_attachment_file = "";

    if ( $mail_type eq "smtp" ) {
        my $smtp_connection = ""; # this will countain the SMTP object that represents the connection into the mail server
        # connect into the smtp mail server
        $smtp_connection = Net::SMTP->new("$mail_server", Port => "$mail_port", Timeout => "$mail_timeout", Debug => "$mail_debug_level_real" );
        if ( ! defined $smtp_connection ) { # check if the SMTP connection is up
            $error_flag = 1; # return failure, fail to connect
        }
        elsif ( $mail_username ne "" ) { # If mail requires authentication 
            if ( !$smtp_connection->auth("$mail_username", "$mail_password") ) {
                    $smtp_connection->quit; # exit the smtp mail server
                    $error_flag = 2; # failed to authenticate
            }
        }
        if ( $error_flag == 0 ) { # manage to connect, attempt to send email messages
            if ( !$smtp_connection->mail($mail_from_address) ) { # pass the from mail address
                $error_flag = 3; # return failure, invalid from email address
            }
            else {
                foreach ( split(',', $mail_to_addresses) ) { # send each email adresss
                    if ( $smtp_connection->recipient("$_", {SkipBad => 1}) ) { # test the email address
                        if ( $mail_to_addresses_valid ne "" ) { # more than one email recipient
                            $mail_to_addresses_valid = "$mail_to_addresses_valid, $_";
                        }
                        else { # first email address
                            $mail_to_addresses_valid = "$_";
                        }
                    }
                }
                if ( $mail_to_addresses_valid ne "" ) { # if there is at least one valid email address in the "to" mail section
                    # Prepare the full mail message, including meta data (data, mail program, from, to, subject and body)
                    my $mail_data = "From: $mail_from_address" . "\n"
                         . "To: " . ( ref($mail_to_addresses_valid) ? join(';', @$mail_to_addresses_valid) : $mail_to_addresses_valid ) . "\n"
                         . "Subject: " . $my_message_subject . "\n"
                         . "Date: " . get_mail_date($global_config_p) . "\n"
                         . "X-Mailer: " . $x_mailer . "\n"
                         . "MIME-Version: 1.0" . "\n"
                         . "Content-Type: multipart/mixed; boundary=\"----MIME delimiter for Simplebackup-\"" . "\n\n"
                         . "This is a multi-part message in MIME format. To properly display this message you need a MIME-Version 1.0 compliant Email program." . "\n\n"
                         . "------MIME delimiter for Simplebackup-" . "\n"
                         . "Content-Type: text/plain; charset=\"iso-8859-1\"" . "\n"
                         . "Content-Transfer-Encoding: 7bit" . "\n\n"
                         . "$my_message_body";
                    if ( $my_filenames_path ne "" ) { # send eventual files
                        $mail_data .= "\n\n";
                        my @my_filenames_path_split = split(/</,  $my_filenames_path); # real all backup directories
                        $my_filenames_path = ""; # recycled variable
                        foreach $my_filenames_path (@my_filenames_path_split) {
                            if ( create_email_attachment("$my_filenames_path", $global_config_p) ) {
                                $mail_data = $mail_data . create_email_attachment("$my_filenames_path", $global_config_p); # atach the file into the message
                            }
                            else {
                                $failed_attachment_file = $my_filenames_path; # name for future use
                                $error_flag = 6; # return failure, failed to attach the email
                                last; # leave the cycle immediatle
                            }
                        }
                    }
                    if ( $error_flag == 0  ) { # send the message, if no error occured
                        if ( !$smtp_connection->data($mail_data) ) {
                            $error_flag = 5; # return failure, failed to send email message
                        }
                    }
                }
                else {
                    $error_flag = 4; # return failure, there was no valid "to" mail address
                }
            }
            $smtp_connection->quit; # exit the smtp mail server
        }
    }
   # write apropriate messages into log file
    my $message_type = "Warning" if $$global_config_p{backup_working} ne "smtp"; # if working a non email backup mode
    $message_type = "Error" if $$global_config_p{backup_working} eq "smtp"; # if working a email backup mode
    switch: {
        $error_flag == 1 && do {
                            write_file_log($global_config_p, "$message_type - unable to connect into the $mail_type mail server named [ $mail_server ]", $log_body_p); # write the error message into the script error file
                        };
        $error_flag == 2 && do {
                            write_file_log($global_config_p, "$message_type - failure on mail authentication [ username: $mail_username ; password: ***** ], make shore that both the mail username and password are correct and that the mail server requires authentication", $log_body_p); # write the error message into the script error file
                        };
        $error_flag == 3 && do {
                            write_file_log($global_config_p, "$message_type - the \"from\" email address [ $mail_from_address ] is invalid", $log_body_p); # write the error message into the script error file
                        };
        $error_flag == 4 && do {
                            write_file_log($global_config_p, "$message_type - there was no valid \"to\" email address, no email was send, check if email address(es) are valid and if the mail server is accepting them", $log_body_p); # write the error message into the script error file
                        };
        $error_flag == 5 && do {
                            write_file_log($global_config_p, "$message_type - failed to send the email, the connection with the mail server might have dropped", $log_body_p); # write the error message into the script error file
                        };
        $error_flag == 6 && do {
                            write_file_log($global_config_p, "$message_type - unable to read the file [ $failed_attachment_file ] for mail attachment", $log_body_p); # write the error message into the script error file
                        };

    }

    print "Function send_email() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result

}


#
# Check if a specific file, directory or link are suppose to backup, this check is done
# by comparing the modification time with the previous list (if any is available of
# course).
# If the modification time is different or the file fize or if it doesn't even exists
# and if the file extension isn't on the reject list then it's approved, else it's not.
# Will return: no -1 -1 ; yes 123 1234 ; no 123 1234
# Explain: yes some_number some_number is if we added into the backup and return the modification time and size (dir for directories)
#          no some_number some_number is if we don't added into the backup and return the modification time and size (dir for directories)
#          no -1 -1 if there was any error
sub check_add_to_backup {

    my $filedirlink_path = $_[0]; # used when actually getting the real file information (stat)
    my $filedirlink_path_tmp = $_[0]; # used when testing for rejections (by name, extension path)
    my $backup_filedir_crc32 = $_[1]; # the crc32 number that defines the backup data path (directory or file)
    my $my_previous_directory = $_[2]; # the directory relative to where the backup starts
    my $dirfilelink_remain = $_[3]; # the remain of the path... filedirlink_path = backup_filedir_crc32 + dirfilelink_remain
    my $supp_managed_data_p = $_[4]; # pointer into the hash that defines the list of the managed data read from the support file
    my $backup_data_type = $_[5]; # define the backup data type (directory or file)
    my $global_config_p = $_[6]; # pointer into the configuration
    if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ) { # print message if the debug level requires it
        print "Running the check_add_to_backup() function\n";
        print "check_add_to_backup() test path: [ $filedirlink_path ]\n";
    }
    my $error_flag = ""; # mark error or status, by default it won't do backup
    my $do_backup = "";

    if ( $backup_data_type ne "file" ) { # if user is doing a backup of a specficic file, then advanced file rejections are not used
        $filedirlink_path_tmp = lc $filedirlink_path_tmp if ( $$global_config_p{host_os} ne "unix" ); # under windows so it's not case sensitive
        # Check if the file is not some how contained on the full path rejections
        if ( $error_flag eq "" and $$global_config_p{backup_full_path_rejections} ne "" ) {
            my @my_split = split(/</,  $$global_config_p{backup_full_path_rejections});
            foreach my $backup_rejection ( @my_split ) {
                if ( $filedirlink_path_tmp =~ /$backup_rejection/ ) {
                    $do_backup = "no"; # don't do backup of this
                    last; # break and exit
                }
                elsif ( -d $filedirlink_path_tmp and !-l $filedirlink_path_tmp ) { # deal with empty directories
                    my $filedirlink_path_tmp_2 = $filedirlink_path_tmp;
                    if ( $$global_config_p{host_os} ne "unix" ) { # add the directory char (\ or /)
                        $filedirlink_path_tmp_2 .= "\\"; # if running on windows
                    }
                    else {
                        $filedirlink_path_tmp_2 .= "/"; # if running on unix
                    }
                    if ( $filedirlink_path_tmp_2 =~ /$backup_rejection/ ) { # now attempt to match up again (example c:\reject_this_empty_dir\ ) with ( example c:\reject_this_empty_dir\* )
                        $do_backup = "no"; # don't do backup of this
                        last; # break and exit
                    }
                }
            }
        }

        # check if the file type is not on the extention rejection list
        if ( $do_backup ne "no" and $$global_config_p{backup_extension_rejections} ne "" and -f $filedirlink_path) {
            my @my_split = split( /\./, $filedirlink_path_tmp); # split the file, in . parts
            my $size_value = scalar(@my_split) - 1 ; # read the array size, note array starts at zero size is always bigger
            if ( $size_value > 0 ) { # check if the file has extension
                my $file_ext = $my_split[$size_value]; # file or directory name
                @my_split = (); # clear the array
                @my_split = split(/,/,  $$global_config_p{backup_extension_rejections});
                foreach my $backup_rejection ( @my_split ) {
                    if ( $backup_rejection eq $file_ext ) { # if the file extension is on the reject list
                        $do_backup = "no"; # don't do backup of this
                        last; # break and exit
                    }
                }
            }
        }

        # check if the file type is not on the filename rejection list, and if not already rejected
        if ( $do_backup ne "no" and $$global_config_p{backup_filenames_rejections} ne "" and -f $filedirlink_path ) {
            my @my_split = split(/,/,  $$global_config_p{backup_filenames_rejections});
            my $filedir_name = get_filedir_name("$filedirlink_path_tmp", $global_config_p);
            foreach my $backup_rejection_filename ( @my_split ) {
                if ( $backup_rejection_filename eq $filedir_name ) { # if the file extension is on the reject list
                    $do_backup = "no"; # don't do backup of this
                    last; # break and exit
                }
            }
        }

        # check if the file size is in the backup size limit (in bytes), and if not already rejected
        if ( $do_backup ne "no" and $$global_config_p{backup_file_size_limit} != 0 and -f $filedirlink_path ) {
            # get the present file size (in bytes)
            my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$present_mtime,$ctime,$blksize,$blocks) = stat("$filedirlink_path");
            # check if the real file size is bigger that the configured limit
            if ( $size > $$global_config_p{backup_file_size_limit_bytes} ) {
                $do_backup = "no"; # don't do backup of this
            }
        }
    }

    # get and check the previous file modification date/time with the present one
    my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$present_mtime,$ctime,$blksize,$blocks);
    if ( -l "$filedirlink_path" ) { # if it's a unix link
        # get the present file modification time
        ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$present_mtime,$ctime,$blksize,$blocks) = lstat("$filedirlink_path");
    }
    elsif ( -d "$filedirlink_path" or -f "$filedirlink_path" ) { # if it's a file or directory
        # get the present file modification time
        ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$present_mtime,$ctime,$blksize,$blocks) = stat("$filedirlink_path");
    }
    if ( defined $present_mtime ) { # if able to get the file modification time
        # build the present backup management line and match it against the backup management file to see if anything changed
        # management record line is similar to:  0<3689257328<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123
        $size = "dir" if ( -d "$filedirlink_path");
        my $rebuild_line = "0<crc$backup_filedir_crc32<$my_previous_directory<$dirfilelink_remain<$present_mtime<$size";
        if ( $do_backup ne "no" and ($$global_config_p{backup_mode} eq "full" or !(exists $$supp_managed_data_p{$rebuild_line}) ) ) {
            $do_backup = "yes";
        }
        else {
            $do_backup = "no";
        }
        # build the return values file modification date/time and the file size, the variable do_backup marks if it will be added into the backup or not
        $error_flag = "$do_backup $present_mtime $size"; 
    }

    if ( $error_flag eq "" ) { # detect possible bugs
        $error_flag = "no -1 -1"; # if $error_flag is still empty a bug occured
    }

    print "Function check_add_to_backup() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result

}


#
# Build the list of files that are suppose to be backup
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure
sub build_backup_list {

    my $filedir_to_check = $_[0]; # file or directory path to check
    my $input_backup_crc32 = $_[1]; # the crc32 of the file or directory to backup
    my $my_previous_directory = $_[2]; # start backup directory... example if backup /home/miguel the start directory is /home
    my $my_backup_file_directoryname = $_[3]; # directory name to be backup
    my $supp_managed_data_p = $_[4]; # pointer into the managed data that was read from the support file
    my $supp_new_managed_data_p = $_[5]; # pointer into the managed data that was created on this backup session
    my $supp_full_list_p = $_[6]; # pointer into the full list, this list describes all the files and directory found during a given backup session, even if they where not backup
    my $supp_full_list_date = $_[7]; # date when the full list was created in the format.... monday 12-12-2006
    my $current_session = $_[8]; # the current session number
    my $file_separator = $_[9]; # file separator / for unix \ for windows
    my $backup_data_type = $_[10]; # if we are building a backup list of a directory (and subdirectories + files) or from a single file
    my $error_flag = $_[11]; # mark the error log 
    my $global_config_p = $_[12]; # pointer into the configuration

    if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ) { # print message if the debug level requires it
        print "Running the build_backup_list() function\n";
        print "build_backup_list() test path: [ $filedir_to_check ]\n";
    }
    my $log_body_p = $_[13]; # pointer into the email body string

    my $rejection_file_order = ""; # this will contain the orders from a available simplebackup_rejection.txt file
    my $my_previous_directory_size = length($my_previous_directory); # will contain the string size of the start backup directoryp

    no warnings 'recursion'; # disable possible recursion warning messages from perl, this could append if you got a very deep directory list
    if ( $error_flag == 0 ) { # if there was any previous error the function will ABORT, backup will not sucessed
        my @filedir_list;
        if ( $backup_data_type eq "directory" ) { # it's a directory
            opendir(dir_handle, "$filedir_to_check") or $error_flag = 1; # open the load directory
            @filedir_list = readdir dir_handle; # read the file list
            closedir(dir_handle);# close the directory handle
            write_file_log($global_config_p, "Warning : unable to open the directory [ $filedir_to_check ], directory will not be backup", $log_body_p) if ( $error_flag != 0 ); # write the error message into the script error file if unable to open the directory
            print "Function build_backup_list() exit value is [ 0 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
            return 0 if $error_flag == 1; # error exit imediatly
        }
        else { # it's a file
            push (@filedir_list, "."); # emulate a directory entry
            push (@filedir_list, ".."); # emulate a directory entry
            push (@filedir_list, "$my_backup_file_directoryname"); # place the name of the file to check
        }
        if ( $error_flag == 0 ) {
            $filedir_to_check =~ s/\\+$//;  # delete any possible ending \ char
            $filedir_to_check =~ s/\/+$//;  # delete any possible ending / char

            #
            # if it's a empty directory
            if ( scalar (@filedir_list) == 2 and $$global_config_p{backup_format_details} ne "tar" and $$global_config_p{backup_format_details} ne "tar.Z" and $$global_config_p{backup_format_details} ne "tar.gz" and $$global_config_p{backup_format_details} ne "tar.bz2"   ) { # if the directory is empty, check if it's supose to be added into the current backup, notice in any tar kind of backups empty directories are ignore
                # break the full directory into the apropriate fields: /input_directory<directory_to_backup<dir
                my $remain_size = length($filedir_to_check);
                my $dirfilelink_remain = substr($filedir_to_check,$my_previous_directory_size,$remain_size);
                $dirfilelink_remain =~ s/^\\//;  # delete any possible leading \ char
                $dirfilelink_remain =~ s/^\///;  # delete any possible leading / char
                if ( $filedir_to_check ne "" ) {
                    my $mtime_size = check_add_to_backup("$filedir_to_check", "$input_backup_crc32", "$my_previous_directory", "$dirfilelink_remain", $supp_managed_data_p, $backup_data_type, $global_config_p ); # check if the empty directory is suppost to be added into the backup
                    if ( $mtime_size ne "no -1 -1" ) {
                        my ($do_backup, $mtime, $size ) = split(/ /, $mtime_size);
                        $$supp_new_managed_data_p{"0<crc$input_backup_crc32<$my_previous_directory<$dirfilelink_remain<$mtime<$size"} = () if ( $do_backup eq "yes" ); # keep the empty directory for backup
                        $$supp_full_list_p{"3<$current_session<$my_previous_directory<$dirfilelink_remain<$size"} = (); # add the empty directory into the list that defines every data found (if it not backuped)
                    }
                    elsif ( $mtime_size eq "no -1 -1" ) { # error getting the file/link modification time, notice mtime = 0 means that the file is not supose to be included in the backup
                        write_file_log($global_config_p, "Warning : unable to access the empty directory [ $filedir_to_check ], directory will not be backup", $log_body_p); # write the error message into the script error file
                    }
                }
                return $error_flag; # exit imediatly
            }
            elsif ( scalar (@filedir_list) == 2 and ( $$global_config_p{backup_format} eq "tar" or $$global_config_p{backup_format} eq "tar.Z" or $$global_config_p{backup_format} eq "tar.gz" or $$global_config_p{backup_format} eq "tar.bz2" )  ) { # if the directory is empty, check if it's supose to be added into the current backup, notice in any tar kind of backups empty directories are ignore
                write_file_log($global_config_p, "Warning : empty directory [ $filedir_to_check ] will not be included on the backup because you are using the tar backup format", $log_body_p); # write the error message into the script error file
                return $error_flag; # exit imediatly
            }

            #
            # if it's a directory with files
            foreach my $filedir_name ( @filedir_list ) { # check the entiry directory list
                if ( $filedir_name ne "." and $filedir_name ne ".." ) { # ignore the system file names . and ..
                    if ( -d "$filedir_to_check$file_separator$filedir_name" and !-l "$filedir_to_check$file_separator$filedir_name") { # if it's a directory and not a link, go all over again
                        my @backup_full_path_rejections_split = split(/</,  $$global_config_p{backup_full_path_rejections}); # real all rejections
                        my $backup_full_path_rejections_found = "no";
                        foreach my $rejection_backup_path ( @backup_full_path_rejections_split ) {
                            if ( "$filedir_to_check$file_separator$filedir_name" =~ $rejection_backup_path ) {
                                $backup_full_path_rejections_found = "yes";
                                last; # found one entry leave immediatly, no need to waste time
                            }
                        }
                        if ( $backup_full_path_rejections_found ne "yes" and $rejection_file_order ne "sub-directories" ) { # if sub-directories are not to be ignored (order by simplebackup_rejection.txt file) full path rejection list
                            $error_flag = build_backup_list("$filedir_to_check$file_separator$filedir_name", "$input_backup_crc32", "$my_previous_directory", $my_backup_file_directoryname, $supp_managed_data_p, $supp_new_managed_data_p, $supp_full_list_p, $supp_full_list_date, $current_session, $file_separator, $backup_data_type, $error_flag, $global_config_p, $log_body_p );
                        }
                    }
                    else { # if it's a file or unix link 
                        my $filelink_full_path = "";
                        my $dirfilelink_remain = "";
                        # break the full directory into the apropriate fields: /input_directory*directory_to_backup*dir
                        if ( $backup_data_type ne "file" ) { # type is a directory
                            $filelink_full_path = "$filedir_to_check$file_separator$filedir_name";
                            my $remain_size = length($filelink_full_path);
                            $dirfilelink_remain = substr("$filelink_full_path",$my_previous_directory_size,$remain_size);
                        }
                        else { # we are doing a backup of a single file
                            $filelink_full_path = "$filedir_to_check";
                            $dirfilelink_remain = "$filedir_name";
                        }
                        $dirfilelink_remain =~ s/^\\//;  # delete any possible leading \ char
                        $dirfilelink_remain =~ s/^\///;  # delete any possible leading / char
                        if ( $filedir_to_check ne "" ) {
                            my $mtime_size = check_add_to_backup("$filelink_full_path", "$input_backup_crc32", "$my_previous_directory", "$dirfilelink_remain", $supp_managed_data_p, $backup_data_type, $global_config_p ); # check if the file is suppost to be added into the backup
                            if ( $mtime_size ne "no -1 -1" ) {
                                my ($do_backup, $mtime, $size ) = split(/ /, $mtime_size);
                                $$supp_new_managed_data_p{"0<crc$input_backup_crc32<$my_previous_directory<$dirfilelink_remain<$mtime<$size"} = () if ($do_backup eq "yes"); # keep the empty directory for backup
                                $$supp_full_list_p{"3<$current_session<$my_previous_directory<$dirfilelink_remain<$size"} = (); # add the empty directory into the list that defines every data found (if it not backuped)
                            }
                            elsif ( $mtime_size eq "no -1 -1" ) { # error getting the file/link modification time, notice mtime = 0 means that the file is not supose to be included in the backup
                                write_file_log($global_config_p, "Warning : unable to access the modification date/time or size of [ $filedir_to_check$file_separator$filedir_name ], file/link will not be backup", $log_body_p); # write the error message into the script error file
                            }
                        }
                    }
                    last if $error_flag != 0; # break cicle imediatly if any error was detected
                }
            }
            
        }
    }

    print "Function build_backup_list() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Get the start of a full path plus the remain of the full path and return the full path
# Will return: the full path of something
sub rebuild_full_path {

    my $start_of_path = $_[0]; # start of path, example /home   or d:\
    my $remain_of_path = $_[1]; # remain of path  example: miguel
    my $global_config_p = $_[2]; # pointer into the configuration
    my $file_separator = $_[3]; # optional argument where you can force the char (can be undefined)
    print "Running the rebuild_full_path() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $return_string = ""; # what is returned   example: /home/miguel  or d:\miguel

    $file_separator = $$global_config_p{host_file_separator} if ( !defined $file_separator ); # file separator

    # deal with Operating System dependend stuff
    if ( $file_separator eq "/" and $start_of_path eq "/" ) { # unix type paths and unix path is /
        $start_of_path = "";
    }
    elsif ( $file_separator eq "\\" ) { # microsoft type paths
        $start_of_path =~ s/\\$//;  # Delete trailing \ char
    }

    $return_string = "$start_of_path$file_separator$remain_of_path"; # rebuild the full path

    print "Function rebuild_full_path() exit value is [ $return_string ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $return_string;

}


#
# Read/Write the simplebackup support file, all the data required to managed a backup configuration is stored here).
# All the reads/writes are done in full run parcial rewrites are not support, manipolations must be done by reading
# the file altering the variables in memory and rewriting the file.
# Sincronization of each support file is garanted by the use of a write counter, write_counter !!.
# Notice partially read/writes file are not allowed, or it correctly reads/writes the full file or it doesn't.
# Will return: 0 ; 1 ; 2 ; 3 ; 4 ; 5 ; 6 ; 7
# Explain: 0 is success ; 1 is success but not support file was found ; 2 damaged managed list ; 3 damaged backup files list  ;
#          4 damaged backup files details list ; 5 damaged full list ; 6 other errors ; 7 the most recent (write_counter) support
#          file is damaged
sub read_write_support_file {

    my $management_p = $_[0]; # pointer into the hash that defines the passed list backup file list
    my $backup_files_p = $_[1]; # pointer into the array that lists the compressed backup files
    my $backup_files_details_p = $_[2]; # pointer into the array that lists the details of compressed backup files
    my $full_list_p = $_[3]; # pointer into the array that gives the full list of the available backup data at a given session
    my $supp_general_p = $_[4]; # pointer into the remain support configuration parts
    my $operation = $_[5]; # the operation, read or write ?
    my $log_level = $_[6]; # How to report problems, errors ; warnings ; none
    my $global_config_p = $_[7]; # pointer into the configuration
    my $log_body_p = $_[8]; # pointer into the email body string
    my $error_flag = 0; # to mark errors
    my @support_files;

    # load up the array that contains the support files
    push (@support_files, $$global_config_p{backup_support_file_copy1});
    push (@support_files, $$global_config_p{backup_support_file_copy2}) if ($$global_config_p{backup_support_file_copy2} ne "none");
    push (@support_files, $$global_config_p{backup_support_file_copy3}) if ($$global_config_p{backup_support_file_copy3} ne "none");

    print "Running the read_write_support_file() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $support_files_done = 0;

    if ( $operation eq "read" ) { # read operation, read all the support file

       my $support_file_counter = 0;
       my $last_write_counter = 0;
       my $last_write_counter_with_success = 0;
       foreach my $backup_support_file (@support_files) { # test each backup directory for full path and if it exists.
            # assuming default value session (in case we don't find any support file...in case of the first backup )
            if ( $last_write_counter_with_success == 0 ) {
                $$supp_general_p{write_counter} = 0;
                $$supp_general_p{current_session} = 0;
                $$supp_general_p{session_date} = "never_backuped";
                $$supp_general_p{autosync_session} = 0;
                $$supp_general_p{autosync_date} = "never_restored";
                $$supp_general_p{restore_count} = 0;
                $$supp_general_p{last_restore_date} = "never_restored";
                $$supp_general_p{last_restore_username} = "never_restored";
                $$supp_general_p{backup_working} = "";
                $$supp_general_p{backup_mode} = "";
                $$supp_general_p{backup_host_os} = "";
                $$supp_general_p{backup_real_host_os} = "";
                $$supp_general_p{backup_os_name} = "";
                $$supp_general_p{backup_username} = "";
                %$management_p = ();
                %$backup_files_p = ();
                %$full_list_p = ();
            }
            $support_file_counter++; # mark what support file we are attepting to read
            my $skip_file = "no";
            my $line_counter = 0; # counter the line number
            if ( -f $backup_support_file ) { # if the file exists attempt to read it
                $support_files_done++; # mark that we are reading a support file
                open(support_file_handle, "<$backup_support_file") or $error_flag = 6;
                if ( $error_flag == 0 ) { # if we manage to open the file
                    my $last_line = ""; # to keep a copy of the last read line
                    $line_counter = 0;
                    EXIT_LINE: while(<support_file_handle>) { # read the entiry file
                        $line_counter++; # add a line number
                        chomp($_); # remove the new line chars
                        # use a switch / case this is not a real perl function but it works
                        switch: {
                           ( $line_counter == 1 and  $_ ne "<-- start of support file -->" ) && do { # first line must be the start file marker
                                                $error_flag = 6; # mark error missing start of file line
                                            };
                           ( $line_counter == 2 ) && do { # 2 line must be the internet support file write counter
                                                my $config_key;
                                                my $write_counter;
                                                ( $config_key, $write_counter ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $write_counter =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $write_counter =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "write_counter" or $write_counter eq "0" or $write_counter !~ /^\d+$/ ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                                else {
                                                    $$supp_general_p{write_counter} = $write_counter;
                                                    # the last write counter is always update no mather if the file was correcly done or not
                                                    if ( $$supp_general_p{write_counter} > $last_write_counter ) {
                                                        $last_write_counter = $$supp_general_p{write_counter};
                                                    }
                                                    elsif ( $$supp_general_p{write_counter} <= $last_write_counter ) {
                                                        # if we have aready read with success a previous support file with a write counter larger
                                                        # or igual than we are reading now, then skip this file
                                                        $$supp_general_p{write_counter} = $last_write_counter;
                                                        $skip_file = "yes";
                                                        last EXIT_LINE;
                                                    }
                                                }
                                            };
                           ( $line_counter == 3 ) && do { # 3 line must be the current session number
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{current_session} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{current_session} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{current_session} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "current_session" or $$supp_general_p{current_session} eq "0" or $$supp_general_p{current_session} !~ /^\d+$/ ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 4 ) && do { # 4 line must be the current session date
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{session_date} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{session_date} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{session_date} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "current_session_date" or $$supp_general_p{session_date} eq "" ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 5 ) && do { # 5 line must be the autosync mode session number
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{autosync_session} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{autosync_session} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{autosync_session} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "autosync_session" or $$supp_general_p{autosync_session} !~ /^\d+$/ ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 6 ) && do { # 6 line must be the autosync mode session date
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{autosync_date} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{autosync_date} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{autosync_date} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "autosync_session_date" or $$supp_general_p{autosync_date} eq "" ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 7 ) && do { # 7 line is the number ot times that this backup was restored
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{restore_count} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{restore_count} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{restore_count} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "restore_count" or $$supp_general_p{restore_count} !~ /^\d+$/ ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 8 ) && do { # 8 line is the last restore date
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{last_restore_date} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{last_restore_date} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{last_restore_date} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "last_restore_date" or $$supp_general_p{last_restore_date} eq "" ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 9 ) && do { # 9 line is the name of the last user that did a restore
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{last_restore_username} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{last_restore_username} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{last_restore_username} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "last_restore_username" or $$supp_general_p{last_restore_username} eq "" ) {
                                                    $error_flag = 6; # mark error invalid session number
                                                }
                                            };
                           ( $line_counter == 10 ) && do { # 10 line must be the (ftp local directory etc)
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{backup_working} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{backup_working} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{backup_working} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "backup_working" or $$supp_general_p{backup_working} eq "" ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                           ( $line_counter == 11 ) && do { # 11 line must be the type of backup (full incremetnal differential)
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{backup_mode} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{backup_mode} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{backup_mode} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "backup_mode" or $$supp_general_p{backup_mode} eq "" ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                           ( $line_counter == 12 ) && do { # 12 line must be the os type that did the backup (unix / winnt4/win2000/xp/2003)
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{backup_host_os} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{backup_host_os} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{backup_host_os} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "backup_host_os" or ($$supp_general_p{backup_host_os} ne "unix" and $$supp_general_p{backup_host_os} ne "winnt4/win2000/xp/2003") ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                           ( $line_counter == 13 ) && do { # 13 line must be the os type that did the backup reported by perl (Linux ; Solaris ; MsWin32)
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{backup_real_host_os} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{backup_real_host_os} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{backup_real_host_os} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "backup_real_host_os" or $$supp_general_p{backup_real_host_os} eq "" ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                           ( $line_counter == 14 ) && do { # 14 line must be the operating system name that did the backup
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{backup_os_name} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{backup_os_name} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{backup_os_name} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "backup_os_name" or $$supp_general_p{backup_os_name} eq "" ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                           ( $line_counter == 15 ) && do { # 15 line must be the name of the user that did the backup
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{backup_username} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{backup_username} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{backup_username} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "backup_username" or $$supp_general_p{backup_username} eq "" ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                           ( $line_counter == 16 ) && do { # 16 line must be the name of the user that did the backup
                                                my $config_key;
                                                ( $config_key, $$supp_general_p{total_lines_number} ) = split ( /=/, $_,2); # split the line
                                                $config_key =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $config_key =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                                                $$supp_general_p{total_lines_number} =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                                                $$supp_general_p{total_lines_number} =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line
                                                if ( $config_key ne "total_lines_number" or $$supp_general_p{total_lines_number} eq "0" or $$supp_general_p{total_lines_number} !~ /^\d+$/ ) {
                                                    $error_flag = 6; # mark error line number counter
                                                }
                                            };
                        }
                        if ( $error_flag == 0 and $line_counter > 16 and $_ ne "<-- end of support file -->" ) {
                            # now check if the line is correct
                            my @my_split = split( /</, $_);
                            my $my_split_size = scalar(@my_split);
                            
                            if ( $my_split_size != 6 and $my_split_size != 5 and $my_split_size != 9 ) { # only 3 types of records are allowed (managed / backup files / full list)
                                $error_flag = 6; # mark error invalid line size
                            }
                            if ( $error_flag == 0 ) { # if no error was detected
                                switch: {
                                    ( $my_split[0] eq "0" ) && do {
                                        if ( check_management_record($_,$global_config_p) == 0 ) { # check the management record
                                            $$management_p{"$_"} = (); # load the line
                                        }
                                        else {
                                            $error_flag = 2; # mark error damaged managed list
                                        }
                                    };
                                    ( $my_split[0] eq "1" ) && do {
                                        if ( check_backup_files_record($_,$global_config_p) == 0 ) { # check the backup files record
                                            $$backup_files_p{"$_"} = (); # load the line
                                        }
                                        else {
                                            $error_flag = 3; # mark error damaged backup files list
                                        }
                                    };
                                    ( $my_split[0] eq "2" ) && do {
                                        if ( check_backup_files_details_record($_,$global_config_p) == 0 ) { # check the backup files record
                                            $$backup_files_details_p{"$_"} = (); # load the line
                                        }
                                        else {
                                            $error_flag = 4; # mark error damaged backup files details list
                                        }
                                    };
                                    ( $my_split[0] eq "3" ) && do {
                                        if ( check_full_list_record($_,$global_config_p) == 0 ) { # check the full record
                                            $$full_list_p{"$_"} = (); # load the line
                                        }
                                        else {
                                            $error_flag = 5; # mark error damaged full list
                                        }
                                    };
                                    ( $my_split[0] ne "0" and $my_split[0] ne "1" and $my_split[0] ne "2" and $my_split[0] ne "3" ) && do {
                                        $error_flag = 6; # line is not of a valid type
                                    };

                                }
                            }
                        }
                        if ( $last_line eq "<-- end of support file -->" ) { # detect duplicated end of file marker
                            $error_flag = 6; # mark error
                        }
                        $last_line = $_; # backup the read line
                        last if ($error_flag != 0 and $error_flag > 3); # break cycle if any error occured
                    }
                    close (support_file_handle); # close the file
                    if ( $skip_file eq "no" and ($$supp_general_p{total_lines_number} != $line_counter or $last_line ne "<-- end of support file -->") ) { # search if first line marks the start of file and if the counted number of lines corresponde with the lines reported by the file
                        $error_flag = 6; # mark error missing end of file line
                    }
                    $last_write_counter_with_success = $last_write_counter if ( $error_flag == 0 and $skip_file eq "no" );
                }
                if ( $error_flag != 0 ) { # a error occured attempt if possible attempt to read another copy of the support file
                    write_file_log($global_config_p, "Warning : unable to $operation the support file [ $backup_support_file ], damaged line number [ $line_counter ]", $log_body_p) if ($log_level eq "errors" or $log_level eq "warnings");
                    print "[ Warning ], unable to $operation the support file [ $backup_support_file ],\n             damaged line number [ $line_counter ]\n" if ($log_level eq "screen_errors" or $log_level eq "screen_warnings");
                    if ( $support_file_counter < scalar(@support_files) ) {
                        $error_flag = 0;
                        my $msg_1 = "Attempting to $operation another copy of the support file";
                        write_file_log($global_config_p, $msg_1, $log_body_p) if ($log_level eq "errors" or $log_level eq "warnings");
                        print "$msg_1\n\n" if ($log_level eq "screen_errors" or $log_level eq "screen_warnings");
                    }
                }
            }
        }

        # if we manage to read a file with success but failed on the reading of the next one(s)
        if ( $last_write_counter_with_success > 0 and $error_flag != 0 ) {
            $error_flag = 0; # unmark error
        }
        # detect if the most recent support file is damaged
        if ( $$supp_general_p{write_counter} and ($last_write_counter_with_success != $$supp_general_p{write_counter}) ) {
            $error_flag = 7;
            write_file_log($global_config_p, "Warning : unable to $operation a valid and updated copy of a support file", $log_body_p) if ($log_level eq "errors" or $log_level eq "warnings");
            print "[ Warning ], unable to $operation a valid and updated copy of a support file\n\n" if ($log_level eq "screen_errors" or $log_level eq "screen_warnings");
        }
        $error_flag = 1 if ( $support_files_done == 0 ); # mark that we didn't find any valid file
        if ( $error_flag != 0 ) { # if failed to read anything clear the variables
            $$supp_general_p{write_counter} = 0;
            $$supp_general_p{current_session} = 0;
            $$supp_general_p{session_date} = "never_backuped";
            $$supp_general_p{autosync_session} = 0;
            $$supp_general_p{autosync_date} = "never_restored";
            $$supp_general_p{restore_count} = 0;
            $$supp_general_p{last_restore_date} = "never_restored";
            $$supp_general_p{last_restore_username} = "never_restored";
            $$supp_general_p{backup_working} = "";
            $$supp_general_p{backup_mode} = "";
            $$supp_general_p{backup_host_os} = "";
            $$supp_general_p{backup_real_host_os} = "";
            $$supp_general_p{backup_os_name} = "";
            $$supp_general_p{backup_username} = "";
            %$management_p = ();
            %$backup_files_p = ();
            %$full_list_p = ();
        }
    }
    elsif ( $operation eq "write" ) { # write operation, write all the support file
        my @file_lines; # to contain the support file lines
        my $total_file_lines = 17; # at least 17 lines must exist
        my $meta_date = get_file_metadata_date($global_config_p); # get the file date
        $$supp_general_p{write_counter}++; # increase the write counter
        for my $line (keys %$management_p) { # add the management file list into the file array
            $total_file_lines++;
            push @file_lines, $line;
        }
        for my $line (keys %$backup_files_p) { # add the backup file list into the file array
            $total_file_lines++;
            push @file_lines, $line;
        }
        for my $line (keys %$backup_files_details_p) { # add the backup file list details into the file array
            $total_file_lines++;
            push @file_lines, $line;
        }
        for my $line (keys %$full_list_p) { # add the full backup list into the file array
            $total_file_lines++;
            push @file_lines, $line;
        }
        @file_lines = sort @file_lines; # sort the list to help performance in future backups (using this list)
        my $support_files_wsucess = 0;
        foreach my $backup_support_file (@support_files) { # write each support file
            $support_files_done++;
            open(support_file_handle, ">$backup_support_file") or $error_flag = 6; # open the file in rewrite mode
            if ( $error_flag == 0 ) { # if all went ok
                #lock the file for exclusive script use
                flock (support_file_handle, LOCK_EX) or $error_flag = 6;
                # write the new lines
                print support_file_handle "<-- start of support file -->\n", or $error_flag = 6;
                print support_file_handle "write_counter = " . $$supp_general_p{write_counter} . "\n", or $error_flag = 6;
                print support_file_handle "current_session = " . $$supp_general_p{current_session} . "\n", or $error_flag = 6;
                print support_file_handle "current_session_date = " . $$supp_general_p{session_date} . "\n", or $error_flag = 6;
                print support_file_handle "autosync_session = " . $$supp_general_p{autosync_session} . "\n", or $error_flag = 6;
                print support_file_handle "autosync_session_date = " . $$supp_general_p{autosync_date} . "\n", or $error_flag = 6;
                print support_file_handle "restore_count = " . $$supp_general_p{restore_count} . "\n", or $error_flag = 6;
                print support_file_handle "last_restore_date = " . $$supp_general_p{last_restore_date} . "\n", or $error_flag = 6;
                print support_file_handle "last_restore_username = " . $$supp_general_p{last_restore_username} . "\n", or $error_flag = 6;
                print support_file_handle "backup_working = " . $$supp_general_p{backup_working} . "\n", or $error_flag = 6;
                print support_file_handle "backup_mode = " . $$supp_general_p{backup_mode} . "\n", or $error_flag = 6;
                print support_file_handle "backup_host_os = " . $$supp_general_p{backup_host_os} . "\n", or $error_flag = 6;
                print support_file_handle "backup_real_host_os = " . $$supp_general_p{backup_real_host_os} . "\n", or $error_flag = 6;
                print support_file_handle "backup_os_name = " . $$supp_general_p{backup_os_name} . "\n", or $error_flag = 6;
                print support_file_handle "backup_username = " . $$supp_general_p{backup_username} . "\n", or $error_flag = 6;
                print support_file_handle "total_lines_number = $total_file_lines\n", or $error_flag = 6;
                foreach my $new_line ( @file_lines ) {
                    # write the actual support file lines
                    print support_file_handle "$new_line\n", or $error_flag = 6;
                    last if $error_flag != 0; # break imediatly if any error occured
                }
                if ( $error_flag == 0 ) { # print the close file line
                    print support_file_handle "<-- end of support file -->", or $error_flag = 6;
                }
                close (support_file_handle); # close the file
                unlink "$backup_support_file" if ( $error_flag != 0 ); # erase the damaged support file, since it's empty or damaged
            }
            if ( $error_flag != 0 ) { # Detect if there where any problems writing the file
                write_file_log($global_config_p, "Warning : unable to $operation support file [ $backup_support_file ]", $log_body_p) if ($log_level eq "errors" or $log_level eq "warnings");
                print "[ Warning ], unable to $operation the support file [ $backup_support_file ]\n" if ($log_level eq "screen_errors" or $log_level eq "screen_warnings");
                if ( $support_files_done < scalar(@support_files) ) {
                    $error_flag = 0;
                    my $msg_1 = "Attempting to $operation another copy of the support file";
                    write_file_log($global_config_p, $msg_1, $log_body_p) if ($log_level eq "errors" or $log_level eq "warnings");
                    print "$msg_1\n\n" if ($log_level eq "screen_errors" or $log_level eq "screen_warnings");
                }
            }
            else {
                $support_files_wsucess++; # increase the counter of the support files copy "written with sucess"
            }
        }
        if ( $support_files_wsucess > 0 ) {
            $error_flag = 0; # we manage to write at least a single copy of support file with sucess
        }
        else {
            $error_flag = 6; # remark error... we could't write with sucess a single support file
        }
    }

    print "Function read_write_support_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive a record of the type management and check if it's under the correct format or not
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure (corrupted record)
sub check_management_record {

    my $test_record = $_[0]; # record to test
    my $global_config_p = $_[1]; # pointer into the configuration
    my $error_flag = 0; # to mark errors
    print "Running the check_management_record() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    # now check if the line is correct
    my @my_split = split( /</, $_);
    my $my_split_size = scalar(@my_split);

    if ( $my_split_size != 6 or $my_split[0] ne "0" ) {
        $error_flag = 1; # mark error invalid line size
    }
    else { # validate what else is possible
        # a valid managed record could be something like this
        # 0<crc3689257328<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123
        my ($record_type, $backup_file_crc32, $data_start_path, $data_relative_path, $data_modification_time, $data_size ) = split(/</, $test_record); # split the record
        # verify that the session number is a integer number over 0 that the backup file name exists that teh crc32 number is a integer number over 0 that the path exists that the modification time is a integer number over zero or dir and that the restore count is a integer number incluiding 0
        if ( $backup_file_crc32 eq "" or $data_start_path eq "" or $data_relative_path eq "" or $data_modification_time !~ /^\d+$/ or ($data_size ne "dir" and $data_size !~ /^\d+$/) ) {
            $error_flag = 1;
        }
    }

    print "Function check_management_record() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive a record of the type backup files and check if it's under the correct format or not
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure (corrupted record)
sub check_backup_files_record {

    my $test_record = $_[0]; # record to test
    my $global_config_p = $_[1]; # pointer into the configuration
    my $error_flag = 0; # to mark errors
    print "Running the check_backup_files_record() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    # now check if the line is correct
    my @my_split = split( /</, $_);
    my $my_split_size = scalar(@my_split);

    if ( $my_split_size != 6 or $my_split[0] ne "1" ) {
        $error_flag = 1; # mark error invalid line size
    }
    else { # validate what else is possible
        # a valid backup files record could be something like this
        # 1<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<123123<12/12/2005<1
        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $compress_backup_file_size, $data_last_rdate, $data_rcount ) = split(/</, $test_record); # split the record
        # verify that the session number is a integer number over 0 that the backup file name exists that teh crc32 number is a integer number over 0 that the path exists that the modification time is a integer number over zero or dir and that the restore count is a integer number incluiding 0
        if ( $backup_file_crc32 eq "" or $compress_backup_file_name eq "" or $compress_backup_file_size eq "0" or $compress_backup_file_size !~ /^\d+$/ or $data_last_rdate eq "" or $data_rcount !~ /^\d+$/ ) {
            $error_flag = 1;
        }
    }

    print "Function check_backup_files_record() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive a record of the type backup files details and check if it's under the correct format or not
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure (corrupted record)
sub check_backup_files_details_record {

    my $test_record = $_[0]; # record to test
    my $global_config_p = $_[1]; # pointer into the configuration
    my $error_flag = 0; # to mark errors
    print "Running the check_backup_files_details_record() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    # now check if the line is correct
    my @my_split = split( /</, $_);
    my $my_split_size = scalar(@my_split);

    if ( $my_split_size != 9 or $my_split[0] ne "2" ) {
        $error_flag = 1; # mark error invalid line size
    }
    else { # validate what else is possible
        # a valid backup files record could be something like this
        # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $test_record); # split the record
        # verify that the session number is a integer number over 0 that the backup file name exists that the crc32 number is a integer number over 0 that the path exists that the modification time is a integer number over zero or dir and that the restore count is a integer number incluiding 0
        if ( $backup_file_crc32 eq "" or $compress_backup_file_name eq "" or $data_start_path eq "" or $data_relative_path eq "" or $data_modification_time !~ /^\d+$/ or ($data_size ne "dir" and $data_size !~ /^\d+$/) or $data_last_rdate eq "" or $data_rcount !~ /^\d+$/ ) {
            $error_flag = 1;
        }
    }

    print "Function check_backup_files_details_record() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive a record of the type full list and check if it's under the correct format or not
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure (corrupted record)
sub check_full_list_record {

    my $test_record = $_[0]; # record to test
    my $global_config_p = $_[1]; # pointer into the configuration
    my $error_flag = 0; # to mark errors
    print "Running the check_full_list_record() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    # now check if the line is correct
    my @my_split = split( /</, $_);
    my $my_split_size = scalar(@my_split);

    if ( $my_split_size != 5 or $my_split[0] ne "3" ) {
        $error_flag = 1; # mark error invalid line size
    }
    else { # validate what else is possible
        # a valid full list record could be something like this
        # 3<3<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<123123
        my ($record_type, $record_session_number, $data_start_path, $data_relative_path, $data_size  ) = split(/</, $test_record); # split the record
        if ( $record_session_number eq "0" or $record_session_number !~ /^\d+$/ or $data_start_path eq "" or $data_relative_path eq "" or ($data_size ne "dir" and $data_size !~ /^\d+$/) ) {
            $error_flag = 1;
        }
    }

    print "Function check_full_list_record() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive the full previous manament list read from the support file, and the full new management list (created during the backups)
# match up both and build the final management list that will include the current management list and all the files that only
# exist on the list read from the support file (that were not backup only)
# Will return: 0
# Explain: 0 is success 
sub patch_management_records {

    my $management_previous_p = $_[0]; # pointer into the hash that defines the previous list backup file list
    my $management_current_p = $_[1]; # pointer into the array that lists the compressed backup files
    my $global_config_p = $_[2]; # pointer into the configuration
    my $log_body_p = $_[3]; # pointer into the email body string
    my $error_flag = 0; # to mark errors
    print "Running the patch_management_records() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    if ( (keys %$management_previous_p) != 0 ) { # if a older management file list exists update the current based on the older + new

        for my $current_manage_record ( keys %$management_current_p ) { # read the previous list
                # Test if a new record of the management data does not exist on the previous management list (read from the support file...
                if ( !(exists $$management_previous_p{$current_manage_record}) ) {
                    $$management_previous_p{$current_manage_record} = (); # add the new record into the main management list
                }
            }
    }
    else { # previous management data is empty so the management data is the entiry new management data
        %$management_previous_p = %$management_current_p;
    }

    print "Function patch_management_records() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Receive the full backup file record and updated for future writing on the support file
# match up both and build the final management list that will include the current management list and all the files that only
# exist on the list read from the support file (that were not backup only)
# Will return: 0
# Explain: 0 is success
sub patch_backup_files_records {

    my $backup_files_p = $_[0]; # pointer into the hash that defines the full backup files list
    my $file_name = $_[1]; # file name to add/update or delete
    my $file_size = $_[2]; # file size in bytes (can be empty during deletes or restores), beware that this value is ignore if the file was already stored on the support file
    my $operation = $_[3]; # valid operations are: backup_add_update ; restore_add_update ; delete
    my $global_config_p = $_[4]; # pointer into the configuration
    my $log_body_p = $_[5]; # pointer into the email body string
    my $error_flag = 0; # to mark errors

    print "Running the patch_backup_files_records() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $found_record = "no"; # by default we mark that the record was not found on the present  full backup list
    my $record_type = "1";
    my $backup_file_crc32 = "";
    my $compress_backup_file_name = "";
    my $compress_backup_file_size = "";
    my $data_last_rdate = "";
    my $data_rcount = "";
    for my $backup_files_record ( keys %$backup_files_p ) { # read the backup files list
        # a valid backup files record could be something like this
        # 1<3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<123123<12/12/2005<1
        ($record_type, $backup_file_crc32, $compress_backup_file_name, $compress_backup_file_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_record); # split the record
        if ( $compress_backup_file_name eq $file_name ) { # file being manipolated exists on the present backup file list
            $found_record = "yes"; # mark that the record existed
            delete $$backup_files_p{"$backup_files_record"}; # delete the record
            last; # found the file no need to continue
        }
    }

    if ( $operation eq "backup_add_update" or $operation eq "restore_add_update" ) { # if adding or updating during backups/restores
        if ( $found_record eq "no" ) { # if we didn't find the record extract/create the remain of the information to create the record
            $data_last_rdate = "never_restored"; # record is new, it was never restored
            $data_rcount = 0; # record is new, it was never restored
            my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($file_name, $global_config_p)); # extract some information from the actual file name
            $backup_file_crc32 = $file_crc32; # get the file crc32 number
        }
        else {
            $file_size = $compress_backup_file_size;
        }
        if ( $operation eq "restore_add_update" ) { # if doing a restore increase the restore values
            $data_last_rdate = get_file_metadata_date($global_config_p); # get the file restore date (present date in the format wednesday 05-03-2004)
            $data_rcount++; # increate the restore count a bit more
        }
        # Add the record in the format " 1<3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<123123<12/12/2005<1 "
        $$backup_files_p{"$record_type<$backup_file_crc32<$file_name<$file_size<$data_last_rdate<$data_rcount"} = ();
    }

    print "Function patch_backup_files_records() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Receive the full backup file details record and updated for future writing on the support file
# match up both and build the final management list that will include the current management list and all the files that only
# exist on the list read from the support file (that were not backup only)
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure 
sub patch_backup_files_details_records {

    my $backup_files_details_p = $_[0]; # pointer into the hash that defines the full backup files details list
    my $new_data_tmp_p = $_[1]; # pointer into the hash containing the data to add/update on the backup file detail list, it's ignored (so it can be empty/undef) if deleting a record from the detail file list
    my $compress_backup_file_name = $_[2]; # compress backup file name
    my $data_last_rdate = $_[3]; # the date when the file was restored, this field is only read during the restore_update operations
    my $operation = $_[4]; # valid operations are: backup_add ; restore_update ; delete
    my $global_config_p = $_[5]; # pointer into the configuration
    my $log_body_p = $_[6]; # pointer into the email body string
    my $error_flag = 0; # to mark errors

    print "Running the patch_backup_files_details_records() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    if ( $operation eq "backup_add" or $operation eq "restore_update" ) { # if doing a backup or restore
        my ($details_record_type, $details_backup_file_crc32, $details_compress_backup_file_name, $details_data_start_path, $details_data_relative_path, $details_data_modification_time, $details_data_size, $details_data_last_rdate, $details_data_rcount );

        for my $new_data_tmp_record ( keys %$new_data_tmp_p ) { # read the temporary managed data
            # by default the file/dir we are adding was never restored
            my $data_rcount = 0;

            if ( $operation eq "backup_add" ) { # during adding operations this function expects to receive a management record list
                my ($managed_record_type, $managed_backup_file_crc32, $managed_data_start_path, $managed_data_relative_path, $managed_data_modification_time, $managed_data_size ) = split(/</, $new_data_tmp_record); # split the record (this is management record)
                # extract the data from the management record to add into the details record
                $details_backup_file_crc32 = $managed_backup_file_crc32;
                $details_data_start_path = $managed_data_start_path;
                $details_data_relative_path = $managed_data_relative_path;
                $details_data_modification_time = $managed_data_modification_time;
                $details_data_size = $managed_data_size;
                $details_data_rcount = 0;
                $data_last_rdate = "never_restored";
            }
            elsif ( $operation eq "restore_update" ) { # during update operations this function expects to receive a copy of the backup files details list

                ($details_record_type, $details_backup_file_crc32, $details_compress_backup_file_name, $details_data_start_path, $details_data_relative_path, $details_data_modification_time, $details_data_size, $details_data_last_rdate, $details_data_rcount ) = split(/</, $new_data_tmp_record); # split the record
                if ( defined delete $$backup_files_details_p{"$new_data_tmp_record"} ) { # delete the previous record
                    $data_rcount = $details_data_rcount + 1;
                }
                else { # record does not exists ???? bug or something strange occured
                    $error_flag = 1;
                    last; # exit imedialy
                }
            }
            # add or read the detail record
            # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
            $$backup_files_details_p{"2<$details_backup_file_crc32<$compress_backup_file_name<$details_data_start_path<$details_data_relative_path<$details_data_modification_time<$details_data_size<$data_last_rdate<$data_rcount"} = (); # add the new record
        }
    }
    elsif ( $operation eq "delete" ) { # if erasing the record
        for my $backup_files_details_record ( keys %$backup_files_details_p ) { # read the detail record
            my ($details_record_type, $details_backup_file_crc32, $details_compress_backup_file_name, $details_data_start_path, $details_data_relative_path, $details_data_modification_time, $details_data_size, $details_data_last_rdate, $details_data_rcount ) = split(/</, $backup_files_details_record); # split the record
            if ( $details_compress_backup_file_name eq $compress_backup_file_name ) { # check if the detail record is part of the file that we want to erase
                delete $$backup_files_details_p{"$backup_files_details_record"} # erase the record
            }
        }
    }
    else {
        $error_flag = 1; # invalid operation
    }

    print "Function patch_backup_files_details_records() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Receive the full file list record and erase any record required
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure 
sub patch_full_list_records {

    my $full_list_p = $_[0]; # pointer into the hash that defines the full list
    my $operation_session_number = $_[1]; # session number of the record (if -1 then all records should be affected)
    my $operation = $_[2]; # valid operations are: delete
    my $global_config_p = $_[3]; # pointer into the configuration
    my $log_body_p = $_[4]; # pointer into the email body string
    my $error_flag = 0; # to mark errors

    print "Running the patch_full_list_records() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    if ( $operation eq "delete" ) { # if erasing the record
        for my $full_list_record ( keys %$full_list_p ) { # read the full list record
            my ($record_type, $record_session_number, $data_start_path, $data_relative_path, $data_size  ) = split(/</, $full_list_record); # split the record
            if ( $operation_session_number == -1 or $record_session_number == $operation_session_number ) {
                delete $$full_list_p{"$full_list_record"} # erase the record
            }
        }
    }
    else {
        $error_flag = 1; # invalid operation
    }

    print "Function patch_full_list_records() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# The passes the backup log into a external command using stdin, this command is
# configured by the user on the configuration file
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure
sub export_log {

    my $log = $_[0]; # email message body, the actual email text
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the export_log() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $pass_log_to_external_cmd = $$global_config_p{pass_log_to_external_cmd};
    my $error_flag = 0;

    open(command_handle, "| $pass_log_to_external_cmd") or $error_flag = 1;
    if ( $error_flag == 0 ) {
        print command_handle $log or $error_flag = 1; # export the log file into the external command
        close(command_handle); # close the command file handle
    }

    print "Function export_log() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result
}


#
# The actual function that compresses the data into a file
# Will return: -1 ; any_other_positive_integer_numeric_value
# Explain: -1 is failure ; any other integer number number that represents the compressed file size
sub do_compress {

    my $archive_file_name = $_[0]; # compressed file name
    my $archive_file_tar_name = $_[1]; # temporary name for used in tar differential/incremental backups
    my $backup_file_directoryname = $_[2]; # file or directory to compress
    my $supp_new_managed_data_tmp_p = $_[3]; # pointer into the backup list, if this is available the backup will be made depending on this
    my $previous_directory = $_[4]; # directory before the backup dir
    my $global_config_p = $_[5]; # pointer into the configuration
    print "Running the do_compress() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[6]; # pointer into the email body string
    my $compression_ratio = $$global_config_p{backup_real_ratio}; # the compression ratio
    my $null_device = $$global_config_p{host_null_device}; # operating system null device
    my $error_flag = 0; # mark errors
    my @compress_command;
    my $my_perl_version = $]; # perl version

    if ( ! chdir "$previous_directory" ) { # attempt to change into the previous directory, this is done to build a backup without a full path into the directory, example...   /home/miguel/documents will compress a file with just the directory documents and not the full path
        write_file_log($global_config_p, "Error : unable access the directory [ $previous_directory ] for backup, check permissions", $log_body_p); # write the error message into the script error file
        print "Function do_compress() exit value is [ -1 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return -1; # return failure
    }

    # erase temporary files could be left over by some simplebackup previous crash or a user kill operation
    unlink "$archive_file_name" if -f "$archive_file_name"; # erase the temporary file could be left over by some user
    unlink "$archive_file_tar_name" if ( -f "$archive_file_tar_name" ); # erase the temporary file could be left over by some user

    my @not_relevant;
    my $tmp_management_file = get_filedir_name($$global_config_p{configuration_file_name}, $global_config_p);
    $tmp_management_file = "$tmp_management_file" . ".tmp"; # add the tmp extension
    $tmp_management_file = rebuild_full_path("$$global_config_p{temporary_dir}", "$tmp_management_file", $global_config_p); # rebuild the full path pointing into the path defined by temporary_dir

    # write a temporary file list, that is actualy passed into the archive command, this file only contains relative paths
    if ( $$global_config_p{backup_list_encoding} eq "ascii" ) {
        open(management_tmp_file_handle, ">$tmp_management_file") or $error_flag = -1;
    }
    elsif ( $$global_config_p{backup_list_encoding} eq "utf-8" ) { # if using unicode 8 bits
        open(management_tmp_file_handle, ">:raw:encoding(UTF-8):crlf:utf8", "$tmp_management_file") or $error_flag = -1;
    }
    elsif ( $$global_config_p{backup_list_encoding} eq "utf16-le" ) { # if using unicode 16 little ending
        open(management_tmp_file_handle, ">:raw:encoding(UTF16-LE):crlf:utf8", "$tmp_management_file") or $error_flag = -1;
    }
    if ( $error_flag == 0 ) {
        #lock the file for exclusive script use
        flock (management_tmp_file_handle, LOCK_EX) or $error_flag = -1;
        if ( $$global_config_p{backup_list_encoding} eq "utf16-le" ) {
            print management_tmp_file_handle "\x{FEFF}", or $error_flag = -1; # write the BOM, Byte Order Marker header to tell the unicode readers that this file is in little endinien
        }
        for my $supp_new_managed_data_tmp_record ( keys %$supp_new_managed_data_tmp_p ) { # read the management list for this backup list
            last if $error_flag != 0; # break imediatly if any error occured
            my ($record_type, $backup_file_crc32, $data_start_path, $data_relative_path, $data_modification_time, $data_size ) = split(/</, $supp_new_managed_data_tmp_record); # split the record
            print management_tmp_file_handle "$data_relative_path\n", or $error_flag = -1; # write only the relative path
        }
        close(management_tmp_file_handle); # close the file
        if ( $error_flag != 0 ) { # if there was a error or but the file contains no data, erase it
            unlink "$tmp_management_file"; # erase the temporary file, since it's empty or damaged
        }
    }

    if ( $error_flag == 0 ) {
        switch: { # prepare backup command
            $$global_config_p{backup_format} eq "rar" && do { # rar type of files
                            my $compressor = get_external_command("rar", $global_config_p);
                            if ( $$global_config_p{debug_level} ne "full" ) {
                                # deal with Operating System dependend stuff and build the full bath into the backup file
                                if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system, unix links are keeped has links
                                    @compress_command = ("$compressor", "a", "-inul", "-isnd", "-m$compression_ratio", "-md4096", "-r", "-s", "-dh", "-rr", "-ow", "-ol", "\"$archive_file_name\"", "@\"$tmp_management_file\"", "$null_device");
                                }
                                else {# windows operating system
                                    @compress_command = ("$compressor", "a", "-inul", "-isnd", "-m$compression_ratio", "-md4096", "-r", "-s", "-dh", "-rr", "-ow", "\"$archive_file_name\"", "@\"$tmp_management_file\"", "$null_device");
                                }
                            }
                            else { # using debug mode
                                # deal with Operating System dependend stuff and build the full bath into the backup file
                                if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system
                                    @compress_command = ("$compressor", "a", "-isnd", "-m$compression_ratio", "-md4096", "-r", "-s", "-dh", "-rr", "-ow", "-ol", "\"$archive_file_name\"", "@\"$tmp_management_file\"");
                                }
                                else {# windows operating system
                                    @compress_command = ("$compressor", "a", "-isnd", "-m$compression_ratio", "-md4096", "-r", "-s", "-dh", "-rr", "-ow", "\"$archive_file_name\"", "@\"$tmp_management_file\"");
                                }
                            }
                        };
            $$global_config_p{backup_format} eq "7z" && do { # 7z (7-zip) type of files
                            my $compressor = get_external_command("7z", $global_config_p);
                            if ( $$global_config_p{debug_level} ne "full" ) {
                                # deal with Operating System dependend stuff and build the full bath into the backup file
                                if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system, unix links are keeped has links
                                    @compress_command = ("$compressor", "a", "-t7z", "-mx$compression_ratio", "-r", "-ms", "\"$archive_file_name\"", "@\"$tmp_management_file\"", "$null_device");
                                }
                                else {# windows operating system
                                    @compress_command = ("$compressor", "a", "-t7z", "-mx$compression_ratio", "-r", "-ms", "\"$archive_file_name\"", "@\"$tmp_management_file\"", "$null_device", ">nul");
                                }
                            }
                            else { # using debug mode
                                @compress_command = ("$compressor", "a", "-t7z", "-mx$compression_ratio", "-r", "-ms", "\"$archive_file_name\"", "@\"$tmp_management_file\"");
                            }
                        };
                        $$global_config_p{backup_format} eq "zip" && do { # tar type of files
                            my $compressor = get_external_command("zip", $global_config_p);
                            if ( $$global_config_p{debug_level} ne "full" ) {
                                # deal with Operating System dependend stuff and build the full bath into the backup file
                                if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system (without -S parameter)
                                    @compress_command = ("cat", "\"$tmp_management_file\"", "|", "$compressor", "-r", "-q", "-y", "-$compression_ratio", "-@", "\"$archive_file_name\"", "$null_device");
                                }
                                else {# windows operating system (with -S parameter, which mean include hidden files)
                                    @compress_command = ("type", "\"$tmp_management_file\"", "|", "$compressor", "-r", "-q", "-$compression_ratio", "-S", "-@", "\"$archive_file_name\"", "$null_device");
                                }
                            }
                            else { # using debug mode
                                # deal with Operating System dependend stuff and build the full bath into the backup file
                                if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system (without -S parameter)
                                    @compress_command = ("cat", "\"$tmp_management_file\"", "|", "$compressor", "-r", "-v", "-y", "-$compression_ratio", "-@", "\"$archive_file_name\"");
                                }
                                else {# windows operating system (with -S parameter, which mean include hidden files)
                                    @compress_command = ("type", "\"$tmp_management_file\"", "|", "$compressor", "-r", "-v", "-$compression_ratio", "-S", "-@", "\"$archive_file_name\"");
                                }
                            }
                        };
                        # if not using a advanced tar
                        ( $$global_config_p{backup_format_details} eq "tar" or $$global_config_p{backup_format_details} eq "tar.Z" or $$global_config_p{backup_format_details} eq "tar.gz" or $$global_config_p{backup_format_details} eq "tar.bz2" )&& do { # tar + bzip2 type of files
                            my $compressor = get_external_command("tar", $global_config_p);
                            write_file_log($global_config_p, "Warning : Your backup configuration does not allow empty directories to be backup", $log_body_p); # write the error message into the script error file
                            if ( $$global_config_p{debug_level} ne "full" ) {
                                if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                    @compress_command = ("$compressor", "-cpf", "\"$archive_file_tar_name\"", "-T", "\"$tmp_management_file\"", "$null_device");
                                }
                                elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                    @compress_command = ("$compressor", "-cpf", "\"$archive_file_tar_name\"", "-L", "\"$tmp_management_file\"", "$null_device");
                                }
                                elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                    @compress_command = ("need examples");
                                }
                                else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                    @compress_command = ("$compressor", "-cpf", "\"$archive_file_tar_name\"", "-I", "\"$tmp_management_file\"", "$null_device");
                                }
                            }
                            else { # using debug mode
                                if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                    @compress_command = ("$compressor", "-cvpf", "\"$archive_file_tar_name\"", "-T", "\"$tmp_management_file\"");
                                }
                                elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                    @compress_command = ("$compressor", "-cvpf", "\"$archive_file_tar_name\"", "-L", "\"$tmp_management_file\"");
                                }
                                elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                    @compress_command = ("need examples");
                                }
                                else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                    @compress_command = ("$compressor", "-cvpf", "\"$archive_file_tar_name\"", "-I", "\"$tmp_management_file\"");
                                }
                            }
                        };
                        # if using a advanced tar
                        ( $$global_config_p{backup_format_details} eq "advanced_tar" or $$global_config_p{backup_format_details} eq "advanced_tar.Z" or $$global_config_p{backup_format_details} eq "advanced_tar.gz" or $$global_config_p{backup_format_details} eq "advanced_tar.bz2" )&& do { # using gnu tar tar + bzip2 type of files
                            my $compressor = get_external_command("tar", $global_config_p);
                            if ( $$global_config_p{debug_level} ne "full" ) {
                                if ( $$global_config_p{backup_format} eq "tar" ) {
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cpf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cpf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cpf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"", "$null_device");
                                    }
                                }
                                elsif ( $$global_config_p{backup_format} eq "tar.Z" ) { # using the compress format
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cpZf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cpZf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cpZf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"", "$null_device");
                                    }
                                }
                                elsif ( $$global_config_p{backup_format} eq "tar.gz" ) { # using the gzip format
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cpzf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cpzf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cpzf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"", "$null_device");
                                    }
                                }
                                elsif ( $$global_config_p{backup_format} eq "tar.bz2" ) { # using the gzip format
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cpf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"", "--use-compress-program bzip2", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cpzf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"", "--use-compress-program bzip2", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cpf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"", "--use-compress-program bzip2", "$null_device");
                                    }
                                }
                            }
                            else { # using debug mode
                                if ( $$global_config_p{backup_format} eq "tar" ) {
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cvpf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cvpf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cvpf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"");
                                    }
                                }
                                elsif ( $$global_config_p{backup_format} eq "tar.Z" ) { # using the compress format
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cvpZf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cvpZf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cvpZf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"");
                                    }
                                }
                                elsif ( $$global_config_p{backup_format} eq "tar.gz" ) { # using the gzip format
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cvpzf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cvpzf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cvpzf", "\"$archive_file_name\"", "-I", "\"$tmp_management_file\"");
                                    }
                                }
                                elsif ( $$global_config_p{backup_format} eq "tar.bz2" ) { # using the gzip format
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @compress_command = ("$compressor", "-cvpf", "\"$archive_file_name\"", "-T", "\"$tmp_management_file\"", "--use-compress-program bzip2");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @compress_command = ("$compressor", "-cvpf", "\"$archive_file_name\"", "-L", "\"$tmp_management_file\"", "--use-compress-program bzip2");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @compress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @compress_command = ("$compressor", "-cvpf", "\"$archive_file_tar_name\"", "-I", "\"$tmp_management_file\"", "--use-compress-program bzip2");
                                    }
                                }
                            }
                        };

        }
        write_file_log($global_config_p, "Backup into temporary file using the command [ @compress_command ]", $log_body_p); # write the error message into the script error file
        system("@compress_command") == 0 or $error_flag = -1; # do backup and if we return -1 something failed
        # prepare compress command (for a tar backups, non gnu tar)
        if ( $error_flag == 0 and ($$global_config_p{backup_format_details} eq "tar.Z" or $$global_config_p{backup_format_details} eq "tar.gz" or $$global_config_p{backup_format_details} eq "tar.bz2" ) ) {
            switch: { # compress type of files
                $$global_config_p{backup_format} eq "tar.Z" && do { # compress type of files
                    my $compressor = get_external_command("compress", $global_config_p);
                    if ( $$global_config_p{debug_level} ne "full" ) {
                        @compress_command = ("$compressor", "\"$archive_file_tar_name\"", "$null_device");
                    }
                    else { # using debug mode
                        @compress_command = ("$compressor", "\"$archive_file_tar_name\"");
                    }
                };
                $$global_config_p{backup_format} eq "tar.gz" && do { # gzip type of files
                    my $compressor = get_external_command("gzip", $global_config_p);
                    if ( $$global_config_p{debug_level} ne "full" ) {
                        @compress_command = ("$compressor", "-$compression_ratio", "\"$archive_file_tar_name\"", "$null_device");
                    }
                    else { # using debug mode
                        @compress_command = ("$compressor", "-v", "-$compression_ratio", "\"$archive_file_tar_name\"");
                    }
                };
                $$global_config_p{backup_format} eq "tar.bz2" && do { # bzip2 type of files
                    my $compressor = get_external_command("bzip2", $global_config_p);
                    if ( $$global_config_p{debug_level} ne "full" ) {
                        @compress_command = ("$compressor", "-$compression_ratio", "\"$archive_file_tar_name\"", "$null_device");
                    }
                    else { # using debug mode
                        @compress_command = ("$compressor", "-v", "-$compression_ratio", "\"$archive_file_tar_name\"");
                    }
                };
            }
            write_file_log($global_config_p, "Compressing tar archive using the command [ @compress_command ]", $log_body_p); # write the error message into the script error file
            system("@compress_command") == 0 or $error_flag = -1; # do backup and if we return 1 something failed
        }
    }
    # clear left over files
    unlink "$archive_file_tar_name" if ( -f "$archive_file_tar_name" and $$global_config_p{backup_format} ne "tar" );
    unlink "$tmp_management_file" if -f "$tmp_management_file"; # erase the temporary management file

    if ( $error_flag == 0 ) { # if no error occured during compression, get the file size
        my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$present_mtime,$ctime,$blksize,$blocks) = stat("$archive_file_name");
        $error_flag = $size; # return the backup file size
    }

    print "Function do_compress() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result or the file size

}


#
# Receive any string and return the corresponding CRC32 number
# The crc32 algorithm used is based in the Swissknife library (crc32.pm module)
# from Wolfgang Fleischmann wfl\@ebi.ac.uk
# Will return: a integer (crc32 number)
# Explain: The integer is a crc32 number
sub build_crc32 {

    my $the_string = $_[0]; # the string that we are going to convert into a CRC32 number
    my $global_config_p = $_[1]; # pointer into the configuration
    print "Running the build_crc32() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it

    $the_string=~tr/a-z/A-Z/;
    my @the_string = split //, $the_string;
    my @crc32_table=();

    # Build the Crc32 table
    my ($i,$j,$crc_table);
    my $CRC32_POLYNOMIAL = 0xEDB88320;
    for ($i=0; $i <= 255; $i++){
        $crc_table = $i;
        for ($j=8; $j>0; $j--){
            if ($crc_table & 1){
                $crc_table = (($crc_table >> 1) & 0x7FFFFFFF) ^ $CRC32_POLYNOMIAL;
            } 
            else {
                $crc_table = ($crc_table >> 1) & 0x7FFFFFFF;
            }
        }
        $crc32_table[$i]=$crc_table;
    }

    # Build the Crc32 number
    my $crc = 0xFFFFFFFF;
    my $temp1;
    my $temp2;
    while (my $c=shift @the_string){
	my $cc=ord($c);
	$temp1 = ($crc >> 8) & 0x00FFFFFF;
	$temp2 = $crc32_table[($crc ^ $cc) & 0xFF ];
	$crc = $temp1 ^ $temp2;
    }

    print "Function build_crc32() exit value is [ $crc ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $crc; # return the crc32 number
}


#
# Call external operating system commands and show the backup log file
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub show_log_file {

    my $global_config_p = $_[0]; # pointer into the configuration
    print "Running the show_log_file() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $error_flag = 0; # mark error

    print "\n";
    if ( $$global_config_p{log_file} ne "none" ) { # if the user configured a log file
        my $file_path = $$global_config_p{log_file}; # the path into the log file
        if ( -f $file_path ) { # if the log file exists
            my $try_show =""; # contain the operating system edit command
            $try_show = "cat \"$file_path\" | more" if ( get_os_type() eq "unix" ); # attempt to use the operating system vi command
            $try_show = "notepad \"$file_path\"" if ( get_os_type() ne "unix" ); # attempt to use the operating system notepad command
            print "Showing the log file using [ $try_show ]\n";
            exec ($try_show) or $error_flag = 1; # execute the command, with exec so simplebackup will not detect a non existing problem
            print "[ Error ], unable to show the log file, check for permission problems,\nif the editor command is available\nor if a operating system lock or file system error exists.\n\n" if ( $error_flag != 0);
        }
        else {
            print "The log file does not exist.\n\n";
        }
    }
    else {
        print "No log file is configured for this backup configuration.\n\n";
    }

    print "Function show_log_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Erase the management data from the support file if under differencial/incremental back modes in order
# to force a full backup.
# Will return: 0 ; 1 
# Explain: 0 is success ; 1 is failure
sub force_full_backup {

    my $script_version_int = $_[0]; # script version
    my $last_update_int = $_[1]; # script last update date
    my $global_config_p = $_[2]; # pointer into the configuration
    print "Running the force_full_backup() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $error_flag = 0; # mark error

    print "\n";
    if ( $$global_config_p{backup_mode} eq "incremental" or $$global_config_p{backup_mode} eq "differential" ) {
        my $my_option =""; # to contain the user input
        while ( $my_option ne "y" and $my_option ne "n" ) {
            print "Would you really like to force a full backup ?\n";
            print "[ y/n ] ";
            $my_option = <STDIN>;
            $my_option = "a" if ( ! defined $my_option );
            chop $my_option; # remove the new line char
            $my_option = lc ($my_option);
        }
        if ( $my_option eq "y" ) { # if user wants to create the file
            my %supp_managed_data; # the managed data that was read from the support file
            my %supp_backup_files; # the list of the backup files available (read and written into the support file)
            my %supp_backup_files_details; # the detail of the list of the backup files available (read and written into the support file)
            my %supp_full_list; # the full list of all data on the backup set (read and written into the support file)
            my %supp_general = ( # Support file general configuration (other configuration parts)
                "write_counter"         => "", # Number of times that the file was written
                "current_session"       => "", # Current backuk session
                "session_date"          => "", #  The date when the last backup session occured
                "autosync_session"      => "", # The autosyunc session number that was read from the support file
                "autosync_date"         => "", #  The date when the last backup session occured in autosync mode
                "restore_count"         => "", # The number of times that the restore was used
                "last_restore_date"     => "", # The last time that the restore was used
                "last_restore_username" => "", # The name of the last user that did a restore
                "backup_working"        => "", # type of backup (local directory, ftp, smtp, etc)
                "backup_mode"           => "", # Type of backup mode used (full differential incremental)
                "backup_host_os"        => "", # operating system that did the backup (has selected by simplebackup)
                "backup_real_host_os"   => "", # real operating system that did the backup (has reported by perl)
                "backup_os_name"        => "", # name of the operating system that did the last backup
                "backup_username"       => "", # name of the user that did the last backup
            );
            my $log_body; # not used

            # attempt to read the support file, errors and warnings are reported inside the read_write_support_file function
            write_file_log($global_config_p, "Starting ( simplebackup.pl v$script_version_int - $last_update_int )"); # write the message into the script error file
            write_file_log($global_config_p, "Forcing full backup at user request"); # write the message into the script error file
            print "Erasing (please wait)...\n";
            if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'read', 'warnings', $global_config_p, \$log_body) == 0 ) {
                %supp_managed_data = (); # clear the previous managed data to force a full backup now and in the future
                if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                    $error_flag = 1; # mark error unable to read support file
                }
            }
            else {
                $error_flag = 1; # mark error unable to read support file
            }

            if ( $error_flag == 0 ) { # check if the operation whent ok
                write_file_log($global_config_p, "Erased the management data from the support file, the next backup session will be a full backup"); # write the message into the script error file
                print "\nErased the management data from the support file,\nthe next backup session will be a full backup.\n\n";
            }
            else {
                write_file_log($global_config_p, "Failed to force a full backup"); # write the message into the script error file
                print "\nFailed to force a full backup, please check the log file.\n\n";
            }
            write_file_log($global_config_p, "Ending\n\n"); # write the error message into the script error file
        }
    }
    else {
        print "This backup is always a full backup.\n\n";
    }

    print "Function force_full_backup() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Erase the backup log file (optionally doing a backup first)
# Will return: 0 ; 1 
# Explain: 0 is success ; 1 is failure
sub clear_log {

    my $script_version_int = $_[0]; # script version
    my $last_update_int = $_[1]; # script last update date
    my $global_config_p = $_[2]; # pointer into the configuration
    print "Running the clear_log() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $error_flag = 0; # mark error

    my $log_file = $$global_config_p{log_file};
    print "\n";
    if ( $log_file ne "none" and -f $log_file ) {
        my $my_option =""; # to contain the user input
        while ( $my_option ne "1" and $my_option ne "2" and $my_option ne "q" ) {
            clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
            my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$log_file_size,$atime,$present_mtime,$ctime,$blksize,$blocks) = stat("$log_file");
            my $log_file_size_kbytes = sprintf("%.2f",$log_file_size/1024); # 1024 bytes = 1 Kbyte
            my $log_file_size_mbytes = sprintf("%.2f",$log_file_size_kbytes/1024); # 1024 kbytes = 1 Mbyte

            print <<EOF;
Clearing the log file

log file is [ $log_file ]
size [ $log_file_size_mbytes Mbytes / $log_file_size_kbytes Kbytes ]

Please select your action...

  1. Clear the log file
  2. Backup and clear the log file
  q. Quit (Do nothing)

EOF
            print ">> ";
            $my_option = <STDIN>;
            $my_option = "" if ( ! defined $my_option ); # control no input from user
            chop $my_option; # remove the new line char
            $my_option = lc ($my_option);
        }
        # reconfirm if the user really want to erase something
        if ( $my_option eq "1" or $my_option eq "2" ) {
            my $my_option_2 = "";
            while ( $my_option_2 ne "y" and $my_option_2 ne "n" ) {
                print "Would you really like to continue ?\n";
                print "[ y/n ] ";
                $my_option_2 = <STDIN>;
                $my_option_2 = "" if ( ! defined $my_option_2 );
                chop $my_option_2; # remove the new line char
                $my_option_2 = lc ($my_option_2);
            }
            $my_option = "q" if ( $my_option_2 ne "y" ); # user has not reconfirm that he want to erase the log
        }
        # now process the option (just the clear log file or backup and clear the log file)
        if ( $my_option eq "1" or $my_option eq "2" ) {
            my $backup_log_file = "";
            if ( $my_option eq "1" ) { # if just clear the log file
                unlink "$log_file";
                $error_flag = 1 if ( -f "$log_file" ); # recheck if the file was erased
            }
            else { # backup and clear the log file
                # Get the current time and format the hour, minutes and seconds.
                my ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
                $year += 1900; # Add 1900 to the year to get the full 4 digit year
                $mon++; # months start at 0 not at 1
                $mon = "0$mon" if ($mon <= 9); # add zero if required
                $mday = "0$mday" if ($mday <= 9); # add zero if required
                $hour = "0$hour" if ($hour <= 9); # add zero if required
                $min = "0$min" if ($min <= 9); # add zero if required
                $sec = "0$sec" if ($sec <= 9); # add zero if required
                $backup_log_file = $log_file . "_" . $year . $mon . $mday . "_" . $hour . $min . $sec; # backup file will have the format... old_log_name_20061113_145111   where 20061112 is year month day and 145111 is hour minutes and seconds
                $error_flag = move_file("$log_file","$backup_log_file", 16384, $global_config_p); # move the backup file into the the backup copy
            }
            write_file_log($global_config_p, "Starting ( simplebackup.pl v$script_version_int - $last_update_int )"); # write the message into the script error file
            # write the apropriate message on the log file
            if ( $my_option eq "1" ) { # if just clear the log file
                write_file_log($global_config_p, "Clearing the log file"); # write the message into the script error file
            }
            else { # backup and clear the log file
                write_file_log($global_config_p, "Backup and clearing the log file"); # write the message into the script error file
                write_file_log($global_config_p, "Notice : log file will be copied into [ $backup_log_file ]"); # write the message into the script error file
            }
            if ( $error_flag != 0 ) { # if all went ok
                print "\nFailed to clear the log file, please check log file permissions and if\nthe log file is not being locked by another program (such has another\nrunning copy of simplebackup)\n";
                write_file_log($global_config_p, "Error : please check log file permissions and if the log file is not being locked by another program (such has another running copy of simplebackup)"); # write the message into the script error file
            }
            else {
                print "\nLog file was cleared\n" if ( $backup_log_file eq "" );
                print "\nLog file was cleared, old file was backup in [ $backup_log_file ]\n" if ( $backup_log_file ne "" );
            }
            write_file_log($global_config_p, "Ending\n\n"); # write the error message into the script error file
        }
    }
    else {
        print "Log file not found or not defined.\n\n";
    }

    print "Function clear_log() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Cmd List, open the support file and list the backup sessions (with dates and sizes) or list the details (with dates and sizes)
# of a individual backup session by calling the list_backup_sessions() function.
# Will return: 0 ; 1 
# Explain: 0 is success ; 1 is failure
sub cmd_list {

    my $detail_session = $_[0]; # session number to show (can be a number or empty)
    my $global_config_p = $_[1]; # pointer into the configuration

    print "Running the cmd_list() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my %supp_managed_data; # the managed data that was read from the support file
    my %supp_new_managed_data; # the managed data that was created on this backup session
    my %supp_backup_files; # the list of the backup files available (read and written into the support file)
    my %supp_backup_files_details; # the detail of the list of the backup files available (read and written into the support file)
    my %supp_full_list; # the full list of all data on the backup set (read and written into the support file)
    my $supp_current_session; # The session number that was read from the support file
    my $supp_session_date; # The date when the last backup session occured
    my $supp_autosync_session; # The autosyunc session number that was read from the support file
    my $supp_autosync_date; # The date when the last backup session occured in autosync mode
    my $supp_restore_count; # The number of times that the restore was used
    my $supp_last_restore_date; # The last time that the restore was used
    my $supp_backup_host_os_p; # operating system that did the backup
    my $record_pos = 0; # record number
    my $last_read = ""; # pointer into the last session number read or backup file name read
    my $current_files_size = 0; # the size (in bytes) of the last session or backup file read
    my $all_files_size = 0; # the size (in bytes) of all sessions or backup files read
    my $error_flag = 0; # to mark errors

    # attempt to read the support file
    if ( read_write_support_file(\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, 'read', 'none', \$supp_current_session, \$supp_session_date, \$supp_autosync_session, \$supp_autosync_date, \$supp_restore_count, \$supp_last_restore_date, \$supp_backup_host_os_p, $global_config_p, "") == 0 ) {
        my $hash_limit;
        $hash_limit = keys( %supp_backup_files) if ( $detail_session eq "" ); # get the backup list size
        $hash_limit = keys( %supp_backup_files_details) if ( $detail_session ne "" ); # the the
        if ( $hash_limit > 0 ) { # if the support file exists and has data
            my @list_text_array = split (/\n/, list_backup_sessions($detail_session, \%supp_backup_files, \%supp_backup_files_details, $global_config_p));
            foreach my $line ( @list_text_array ) {
                print $line;
            }
        }
        else {
            print "\nThere are no backup sessions to list\n";
        }
        
    }
    else {
        print "\nError : unable to read any valid copy of the support file,\n        the list cannot be showed.\n";
        $error_flag = 1; # mark error unable to read support file
    }

    print "Function cmd_list() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# List the backup sessions (with dates and sizes) or list the details (with dates and sizes) of a individual
# backup session
# This function can list all records (if output_lines is empty) or just a given number of lines (defined by screen_height),
# it can be used to list the records with user intervention (press any key to continue...) you just need to call this
# function inside of a cycle (for, while ...)
# Will return: the list
sub list_backup_sessions {

    my $detail_session = $_[0]; # session number to show (can be a number or empty)
    my $supp_backup_files_p = $_[1]; # pointer into the backup files list
    my $supp_backup_files_details_p = $_[2]; # pointer into the backup files details list
    my $global_config_p = $_[3]; # pointer into the configuration

    my $record_pos = 0; # the record number where we will start listing, it will be also updated in the end
    my $last_read = ""; # the last session number read or backup file name read
    my $current_files_size = 0; # the size (in bytes) of the last session or backup file read
    my $all_files_size = 0; # the size (in bytes) of all sessions or backup files read

    print "Running the list_backup_sessions() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $return_list = ""; # the list that will be returned

    # session number is not defined, user wants to list all backup sessions
    if ( $detail_session eq "" ) {
        my $record_counter = 0;
        $last_read = 0 if ( $last_read eq "" );
        my $hash_limit = keys( %$supp_backup_files_p ); # get the backup list size
        for my $supp_backup_record ( keys %$supp_backup_files_p ) { # get the backup file list from the hash into a array
            # show record if the current record is over or equal to the number requested and when there is no screen height limit
            # or when we are inside the limit
            if ( $record_counter >= $record_pos ) {
                # Process the record (break fields, meta data, round up file sizes, etc
                # 1<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<123123<12/12/2005<1
                my ($record_type, $backup_file_crc32, $compress_backup_file_name, $compress_backup_file_size, $data_last_rdate, $data_rcount ) = split(/</, $supp_backup_record); # split the record
                my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p)); # get the file session number
                my $compress_backup_file_size_kbytes = sprintf("%.2f",$compress_backup_file_size/1024); # 1024 bytes = 1 Kbyte
                my $compress_backup_file_size_mbytes = sprintf("%.2f",$compress_backup_file_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                $data_last_rdate = "(never restored)" if ( $data_last_rdate eq "never_restored" );
                if ( $file_session_number != $last_read ) { # write a introdunction line about this session
                    if ( $last_read != 0 ) { # get the total size of all backups for the last backup session
                        # convert the size of the last session, into kbytes and mbytes, since it's in bytes, rounding them up
                        my $current_files_size_kbytes = sprintf("%.2f",$current_files_size/1024); # 1024 bytes = 1 Kbyte
                        my $current_files_size_mbytes = sprintf("%.2f",$current_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                        $return_list .= "Total session size.: $current_files_size_mbytes Mb / $current_files_size_kbytes Kb\n";
                        $current_files_size = 0; # the session changed so reset the size
                    }
                    $return_list .= "\nSession: $file_session_number ($file_weekday $file_date)\n" if ( $record_counter > 0 );
                    $return_list .= "Session: $file_session_number ($file_weekday $file_date)\n" if ( $record_counter == 0 );
                    $current_files_size = $current_files_size + $compress_backup_file_size; # add the size of the compress file into the backup session size
                    $all_files_size = $all_files_size + $compress_backup_file_size; # add the size of the compress file into the backup size of all sessions
                }
                $return_list .=  "  backup file [ $compress_backup_file_name ]\n";
                $return_list .= "  type: $file_type ; size: $compress_backup_file_size_mbytes Mb / $compress_backup_file_size_kbytes Kb\n";
                $return_list .= "  last restore date: $data_last_rdate ; restore count: $data_rcount\n";
                $last_read = $file_session_number; # update the session number for next record match
            }
            $record_counter++;
        }
        $record_pos = $record_counter; # update the record number...where we ended
        if ( $record_counter >= $hash_limit ) { # if we have reached the final record...
            if ( $last_read != 0 ) { # get the total size of all backups for the last backup session
                # convert the size of the last session, into kbytes and mbytes, since it's in bytes, rounding them up
                my $current_files_size_kbytes = sprintf("%.2f",$current_files_size/1024); # 1024 bytes = 1 Kbyte
                my $current_files_size_mbytes = sprintf("%.2f",$current_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                $return_list .= "Total session size.: $current_files_size_mbytes Mb / $current_files_size_kbytes Kb\n";
                $current_files_size = 0; # the session changed so reset the size
            }
            my $all_files_size_kbytes = sprintf("%.2f",$all_files_size/1024); # 1024 bytes = 1 Kbyte
            my $all_files_size_mbytes = sprintf("%.2f",$all_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
            $return_list .= "\nTotal backup files.: $hash_limit\n";
            $return_list .= "Total sessions size: $all_files_size_mbytes Mb / $all_files_size_kbytes Kb\n";
        }
        if ( $record_counter == 0 ) { # if no records where found
            $return_list .= "\n There are no backup sessions available\n";
        }
    }
    elsif ( $detail_session ne "" ) { # session number is defined, user wants to list what a specific session contains
        my $record_counter = 0;
        my $record_counter_details = 0;
        my $hash_limit = keys( %$supp_backup_files_details_p); # get the hash size
        for my $supp_backup_details_record ( keys %$supp_backup_files_details_p ) { # get the backup file list from the hash into a array
            # show record if the current record is over or equal to the number requested and when there is no screen height limit
            # or when we are inside the limit
            if ( $record_counter >= $record_pos ) {

                # Process the record (break fields, meta data, round up file sizes, etc
                # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $supp_backup_details_record); # split the record
                my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p)); # get the file session number
                $data_last_rdate = "(never restored)" if ( $data_last_rdate eq "never_restored" );
                if ( $file_session_number == $detail_session ) { # only show the details for the session records wanted by the user
                    if ( $compress_backup_file_name ne $last_read ) {
                        if ( $last_read ne "" ) { # get the total size of all backups for the last backup file
                            # convert the size of the last session, into kbytes and mbytes, since it's in bytes, rounding them up
                            my $current_files_size_kbytes = sprintf("%.2f",$current_files_size/1024); # 1024 bytes = 1 Kbyte
                            my $current_files_size_mbytes = sprintf("%.2f",$current_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                            $return_list .= "Backup file size (uncompress).: $current_files_size_mbytes Mb / $current_files_size_kbytes Kb\n";
                            $current_files_size = 0; # the session changed so reset the size
                        }
                        $return_list .= "\nBackup file: [ $compress_backup_file_name ]\n" if ( $record_counter > 0 );
                        $return_list .= "Backup file: [ $compress_backup_file_name ]\n" if ( $record_counter == 0 );
                    }
                    my $data_filedir_path = rebuild_full_path($data_start_path, $data_relative_path, $global_config_p); # rebuild the full path pointing into the path defined by temporary_dir
                    my $data_filedir_name = get_filedir_name("$data_filedir_path", $global_config_p); # get the backup directory name
                    my $data_filedir_type = "Directory";
                    my $data_size_size_kbytes = "";
                    my $data_size_size_mbytes = "";
                    if ( $data_size ne "dir" ) {
                        $data_filedir_type = "File";
                        $data_size_size_kbytes = sprintf("%.2f",$data_size/1024); # 1024 bytes = 1 Kbyte
                        $data_size_size_mbytes = sprintf("%.2f",$data_size_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                        $current_files_size = $current_files_size + $data_size;
                        $all_files_size = $all_files_size + $data_size;
                    }
                    $return_list .= "  $data_filedir_type: [ $data_filedir_name ]\n";
                    $return_list .= "    path: [ $data_filedir_path ]\n";
                    $return_list .= "    size: $data_size_size_mbytes Mb / $data_size_size_kbytes Kb\n" if ( $data_size ne "dir" );
                    $return_list .= "    last restore date: $data_last_rdate ; restore count: $data_rcount\n";
                    $last_read = $compress_backup_file_name; # update the compress backup name
                    $record_counter_details++; # number of records of this session found
                }
            }
            $record_counter++;
        }
        $record_pos = $record_counter; # update the record number...where we ended
        if ( $record_counter_details > 0 and $record_counter >= $hash_limit ) { # if we have reached the final record...
           if ( $last_read ne "" ) { # get the total size of all backups for the last backup file
                # convert the size of the last session, into kbytes and mbytes, since it's in bytes, rounding them up
                my $current_files_size_kbytes = sprintf("%.2f",$current_files_size/1024); # 1024 bytes = 1 Kbyte
                my $current_files_size_mbytes = sprintf("%.2f",$current_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
                $return_list .= "Backup file size (uncompress).: $current_files_size_mbytes Mb / $current_files_size_kbytes Kb\n";
                $current_files_size = 0; # the session changed so reset the size
            }
            my $all_files_size_kbytes = sprintf("%.2f",$all_files_size/1024); # 1024 bytes = 1 Kbyte
            my $all_files_size_mbytes = sprintf("%.2f",$all_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
            $return_list .= "\nTotal files and directories...: $record_counter_details\n";
            $return_list .= "Total backup size (uncompress): $all_files_size_mbytes Mb / $all_files_size_kbytes Kb\n";
        }
        if ( $record_counter_details == 0 ) { # if no records where found for this session
            $return_list .= "\n The backup session [ $detail_session ] does not exists\n";
        }
    }

    print "Function list_backup_sessions() exit value is [ $return_list ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    return $return_list;

}


#
# Return the present date in the simplebackup metadata file format (example: monday 14-01-2005)
# Will return: a Date
sub get_file_metadata_date {

    my $global_config_p = $_[0]; # pointer into the configuration
    my $with_time = $_[1]; # will also add the time ? (undef = no ; yes)
    print "Running the get_file_metadata_date() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    $with_time = "no" if ( ! defined $with_time );

    # prepare the generic metadata date, this date is used in all backup filenames
    my @days = ('sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday');
    # Get the current time and format the hour, minutes and seconds.
    my ($sec,$min,$hour,$mday,$mon,$year,$wday) = (localtime(time))[0,1,2,3,4,5,6];
    $year += 1900; # Add 1900 to the year to get the full 4 digit year
    $mon++; # months start at 0 not at 1

    # Format the date, in this kind "wednesday 05-03-2004"
    $mday = "0$mday" if ($mday <= 9); # add zero if required
    $mon = "0$mon" if ($mon <= 9); # add zero if required
    my $meta_date = "$days[$wday] $mday-$mon-$year";

    if ( $with_time eq "yes" ) { # add present time
        $hour = "0$hour" if ($hour <= 9); # add zero if required
        $min = "0$min" if ($min <= 9); # add zero if required
        $sec = "0$sec" if ($sec <= 9); # add zero if required
        $meta_date .= " $hour:$min:$sec";
    }
    print "Function get_file_metadata_date() exit value is [ $meta_date ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $meta_date;
}


#
# Receive a management list or detail file list and write it (with sizes etc) into the log
# This will be done to produce to the user the list of thing that were backup or restored
# Will return: 0
# Explain: 0 is success
sub write_lists {

    my $list_p = $_[0]; # pointer into the list (management list format or detail file list format)
    my $operation = $_[1]; # backup or restore
    my $global_config_p = $_[2]; # pointer into the general configuration
    print "Running the write_lists() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[3]; # Pointer into the scalar that will contain all LOG MESSAGES and will be used (if configured)  to send the full backup log via email

    write_file_log($global_config_p, "Notice : $operation list", $log_body_p); # write the message into the script error file
    my ($my_record_type, $my_backup_file_crc32, $my_compress_backup_file_name, $my_data_start_path, $my_data_relative_path, $my_data_modification_time, $my_data_size, $my_data_last_rdate, $my_data_rcount );

    for my $list_p_record ( keys %$list_p ) {
        my $mt_data_filedir;
        my $mt_data_filedir_name;
        if ( $operation eq "backup" ) { # split the MANAGEMENT record
            ( $my_record_type, $my_backup_file_crc32, $my_data_start_path, $my_data_relative_path, $my_data_modification_time, $my_data_size ) = split(/</, $list_p_record); # split the record
            $mt_data_filedir = rebuild_full_path($my_data_start_path, $my_data_relative_path, $global_config_p); # rebuild the full path pointing into the path where the file was backuped
            $mt_data_filedir_name = get_filedir_name("$mt_data_filedir", $global_config_p); # get the backup directory name
        }
        elsif ( $operation eq "restore" ) { # split the backup files details record
            # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
            ($my_record_type, $my_backup_file_crc32, $my_compress_backup_file_name, $my_data_start_path, $my_data_relative_path, $my_data_modification_time, $my_data_size, $my_data_last_rdate, $my_data_rcount ) = split(/</, $list_p_record); # split the record
            $mt_data_filedir = rebuild_full_path($$list_p{$list_p_record}, $my_data_relative_path, $global_config_p); # rebuild the full path pointing into the path where the file was restored into
            $mt_data_filedir_name = get_filedir_name("$mt_data_filedir", $global_config_p); # get the backup directory name
        }

        if ( $my_data_size ne "dir" ) {
            my $mt_data_size_size_kbytes = sprintf("%.2f",$my_data_size/1024); # 1024 bytes = 1 Kbyte
            my $mt_data_size_size_mbytes = sprintf("%.2f",$mt_data_size_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
            write_file_log($global_config_p, "File [ $mt_data_filedir_name ] occupies [ $mt_data_size_size_mbytes Mbytes / $mt_data_size_size_kbytes Kbytes ] with full path [ $mt_data_filedir ]", $log_body_p); # write the message into the script error file
        }
        else {
            write_file_log($global_config_p, "Directory [ $mt_data_filedir_name ] with full path [ $mt_data_filedir ]", $log_body_p); # write the message into the script error file
        }
    }

    print "Function write_lists() exit value is [ 0 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return 0;
}


#
# Do the actual backup, calling what ever auxiliary function's required
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub do_backup {

    my $script_version_int = $_[0]; # script version
    my $last_update_int = $_[1]; # script last update date
    my $crypting_file_algorithm_version = $_[2]; # The version of the crypting algoritm the encrypted file will use,
                                                 # notice this might change during the decrypt operation (if the file
                                                 # was encrypted with a older version of the algorith)
    my $global_config_p = $_[3]; # pointer into the configuration
    print "Running the do_backup() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    my $error_flag = 0; # to mark errors
    my $session_number = ""; # backup session name
    my $network_connection; # to keep the Net:FTP ; Net::SFTP ; HTTP::DAV connection object
    my $log_body = ""; # will contain all LOG MESSAGES and will be used (if configured)
                       # to send the full backup log via email
    my $machine_hostname = $$global_config_p{hostname}; # get the hostname
    my $my_username = $$global_config_p{username}; # username
    my $backup_filename_final = ""; # will contain the final backup file name
    my $backup_filename_temp_fortar = ""; # for advanced backups using tar
    my $backup_filename_temp = ""; # will contain the temporary backup file name
    my $backup_filename_final_fpath = ""; # will contain the final backup file name and full path
    my $backup_filename_temp_fortar_fpath = ""; # for advanced backups using tar and full path
    my $backup_filename_temp_fpath = ""; # will contain the temporary backup file name and full path
    my %backup_previous_file_list; # keep passed the backup list for incremental and differental backups
    my @backup_present_file_list; # present backup list, is used in incremental, differencial and might be used in full backups
    my $backup_files_count = 0; # the number of backup files that where created in the present backup session
    my $backup_files_sumsize = 0; # the total size in bytes of the backup files that where created in the present backup session
    my $my_perl_version = $];
    my %supp_managed_data; # the managed data that was read from the support file
    my %supp_new_managed_data; # the managed data that was created on this backup session
    my %supp_backup_files; # the list of the backup files available (read and written into the support file)
    my %supp_backup_files_details; # the detail of the list of the backup files available (read and written into the support file)
    my %supp_full_list; # the full list of all data on the backup set (read and written into the support file)
    my %supp_general = ( # Support file general configuration (other configuration parts)
        "write_counter"         => "", # Number of times that the file was written
        "current_session"       => "", # Current backuk session
        "session_date"          => "", #  The date when the last backup session occured
        "autosync_session"      => "", # The autosyunc session number that was read from the support file
        "autosync_date"         => "", #  The date when the last backup session occured in autosync mode
        "restore_count"         => "", # The number of times that the restore was used
        "last_restore_date"     => "", # The last time that the restore was used
        "last_restore_username" => "", # The name of the last user that did a restore
        "backup_working"        => "", # type of backup (local directory, ftp, smtp, etc)
        "backup_mode"           => "", # Type of backup mode used (full differential incremental)
        "backup_host_os"        => "", # operating system that did the backup (has selected by simplebackup)
        "backup_real_host_os"   => "", # real operating system that did the backup (has reported by perl)
        "backup_os_name"        => "", # name of the operating system that did the last backup
        "backup_username"       => "", # name of the user that did the last backup
    );

    my $my_file_separator = $$global_config_p{host_file_separator}; # file separator
    my $backup_mode = $$global_config_p{backup_mode}; # the backup mode used
    my $backup_real_mode = $$global_config_p{backup_real_mode}; # the real backup mode used
    my $backup_working = $$global_config_p{backup_working}; # how is the backup working, ftp, local file system, etc
    my $host_type = $$global_config_p{host_os}; # the configurated operating system.... unix...etc
    my $config_file = $$global_config_p{configuration_file}; # put it in order to easy put it inside a text string
    my $backup_format = $$global_config_p{backup_format}; # put it in order to easy put it inside a text string (rar zip etc)
    my $log_file = $$global_config_p{log_file}; # put it in order to easy put it inside a text string
    my $text_note = $$global_config_p{text_note}; # put it in order to easy put it inside a text string
    my @my_input_backup_split = split(/</,  $$global_config_p{input_backup}); # split each backup directorie in a array
    # prepare the full backup rejections for perl use, converting from standard user entry into standard perl regular expressions
    $$global_config_p{backup_full_path_rejections} = prepare_perl_wildcards($$global_config_p{backup_full_path_rejections}, $global_config_p) if $$global_config_p{backup_full_path_rejections} ne "";
    my @input_backup_done; # contains the list of the actual backups that where done
    # start logging
    write_file_log($global_config_p, "Starting Backup ( simplebackup.pl v$script_version_int - $last_update_int )",\$log_body); # write the message into the script error file
    write_file_log($global_config_p, "$text_note",\$log_body) if $text_note ne ""; # write the message into the script error file
    write_file_log($global_config_p, "Running with perl $my_perl_version",\$log_body); # write the message into the script error file
    write_file_log($global_config_p, "The machine running this backup is called [ $machine_hostname ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "The user running this backup is called [ $my_username ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "The backup files created will be using the [ $backup_format ] format", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "Using configuration file [ $config_file ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "Using log file [ $log_file ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "The configured backup mode is [ $backup_mode ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "Today's backup mode is [ $backup_real_mode ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "Backup is working in [ $backup_working ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "Backup will be done using data encryption ($crypting_file_algorithm_version algorithm)",\$log_body) if ( $$global_config_p{encryption_passwd} ne "" ); # write the message into the script error file
    write_file_log($global_config_p, "Selected host operating system is [ $host_type ], detected is [ $^O ]", \$log_body); # write the message into the script error file
    write_file_log($global_config_p, "Notice : link files are stored as link and not as a copy of the file/directory where they pointed", \$log_body) if ( $$global_config_p{host_os} eq "unix" ); # write the message into the script error file
    if ( $backup_format eq "rar" and $my_perl_version < 5.008000 ) { # for full backup security in rar format full unicode support is needed, perl 5.6.x has limited unicode support
        write_file_log($global_config_p, "Warning : simplebackup is running with perl $my_perl_version using the rar format, this can cause problems because the rar command requires unicode (UTF16-LE) support to deal with files and directories that have non english names, example a file name written in Portuguese. Backups can fail completely or even run with success but fail to backup some files, to be safe please update your perl or use another backup format. Full unicode support is present in perl 5.008000 (5.8.0) or over.", \$log_body); # write the message into the script error file
    }
    # if there is a available script/batch file/command declare by run_before_backup  RUN IT !
    if ( $$global_config_p{run_before_backup} ne "" ) {
        my $run_before_backup_command = $$global_config_p{run_before_backup};
        write_file_log($global_config_p, "Executing before backup procedure using the command [ $run_before_backup_command ]", \$log_body); # write the error message into the script error file
        system("$run_before_backup_command") == 0 or $error_flag = 1; # do backup and if we return 1 something failed
        if ( $error_flag != 0 ) {
            if ( $$global_config_p{run_backup_on_failure_run_before_backup} ne "yes" ) { # check if user want's to continue backup even if the run before backup procedure fails
                write_file_log($global_config_p, "Error : before backup procedure failed, backup will not continue", \$log_body); # write the error message into the script error file
            }
            else {
                write_file_log($global_config_p, "Warning : before backup procedure failed, continuing backup", \$log_body); # write the error message into the script error file
                $error_flag = 0 ; # reset the error to continue backup
            }
        }
        sleep 60 if ( $error_flag == 0 ); # sleep for 60 seconds in order to make it saffer to do backups, in windows some processes (outlook) do not free their files immediatly after ending
    }

    if ( $error_flag == 0 ) { # do some preliminary tests before starting the backup
        # test if the backup destination exists (if doing a backup into the local file system)
        if ( $$global_config_p{backup_working} eq "local file system" and (!-d $$global_config_p{output_backup} ) ) {
            $error_flag = 1; # mark directory does not exit
            write_file_log($global_config_p, "Error : Backup destination directory [ " . $$global_config_p{output_backup} . " ] does not exists or you do not have permissions to access it, backup will not continue",\$log_body); # write the error message into the script error file
        }

        # test if the temporary directory exists
        if ( !-d $$global_config_p{temporary_dir} ) {
            $error_flag = 1; # mark directory does not exit
            write_file_log($global_config_p, "Error : temporary directory [ " . $$global_config_p{temporary_dir} . " ] does not exists or you do not have permissions to access it, backup will not continue",\$log_body); # write the error message into the script error file
        }

        if ( $error_flag == 0 and ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) ) { # connect into the ftp/sftp/dav server to test if it's available
            my $network_type = $$global_config_p{backup_working};
            write_file_log($global_config_p, "Connect and login into the $network_type server, for connection testing",\$log_body); # write the error message into the script error file
            my $special_error_flag = 0;
            if ( $$global_config_p{sftp_transport} ne "psftp" and $$global_config_p{sftp_transport} ne "sftp" ) { # if we are  using perl modules to ssh/sftp connection (web dav, ftp and ssh2 enter here)
                $special_error_flag = network_connect_login(\$network_connection, "Error", $global_config_p, \$log_body);
                if ( $special_error_flag != 0 ) {
                    $error_flag = 1;
                    write_file_log($global_config_p, "Error : $network_type server is not available, backup will not continue",\$log_body); # write the error message into the script error file
                }
            }
            elsif ( $$global_config_p{sftp_transport} eq "psftp" or $$global_config_p{sftp_transport} eq "sftp" ) {
                $special_error_flag = sftp_external_commands("", "", "check_server", $global_config_p);
                if ( $special_error_flag != 0 ) {
                    my $used_command = "putty psftp"; # default to putty
                    $used_command = "open ssh sftp" if ( $$global_config_p{sftp_transport} eq "sftp" );
                    $error_flag = 1;
                    write_file_log($global_config_p, "Error : $used_command command is not available, backup will not continue",\$log_body) if ( $special_error_flag == 1 ); # write the error message into the script error file
                    write_file_log($global_config_p, "Error : unable to create the sftp batch command file on the temporary dir, backup will not continue",\$log_body) if ( $special_error_flag == 2 ); # write the error message into the script error file
                    write_file_log($global_config_p, "Error : ssh server is not online or the username/password/passphrase combination is invalid, backup will not continue",\$log_body) if ( $special_error_flag == 3  ); # write the error message into the script error file
                }
            }
            if ( $special_error_flag == 0 ) {
                write_file_log($global_config_p, "$network_type server is online, continuing backup",\$log_body); # write the error message into the script error file
            }
        }

        if ( defined $network_connection and ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" )) { # disconnect the ftp/sftp/http-dav server, if connected before
            my $network_type = $$global_config_p{backup_working};
            write_file_log($global_config_p, "Disconnecting from $network_type server",\$log_body); # write the error message into the script error file
            if ( $$global_config_p{backup_working} eq "ftp" ) {
                $network_connection->quit() if $network_connection; # disconnect from ftp server
                $network_connection = undef;
            }
            elsif ( $$global_config_p{backup_working} eq "sftp" ) {
                $network_connection = undef;
            }
            else {
                $network_connection->unlock( -url => $$global_config_p{dav_url_full} );
                $network_connection = undef;
            }
        }
    }

    my $meta_date = get_file_metadata_date($global_config_p); # get the file date
    if ( $error_flag == 0 ) { # if no errors occured read the support file
        write_file_log($global_config_p, "Reading the support file", \$log_body); # write the message into the script error file
        # attempt to read the support file, errors and warnings are reported inside the read_write_support_file function
        if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'read', 'warnings', $global_config_p, \$log_body) <= 1 ) {
            $session_number = $supp_general{current_session} + 1; # increase the session number
            $supp_general{backup_working} = $backup_working; # type of backup (local file system, ftp, smtp, etc)
            $supp_general{backup_mode} = $backup_real_mode; # type of backup mode (full incremental differencial)
            $supp_general{backup_host_os} = $$global_config_p{host_os}; # update the operating system type running the software
            $supp_general{backup_real_host_os} = $^O; # type of the host operating system (reported by perl)
            $supp_general{backup_os_name} = $$global_config_p{hostname}; # operating system name (has configured by admin)
            $supp_general{backup_username} = $$global_config_p{username}; # get the username running this program
            if ( $supp_general{session_date} ne "never_backuped" ) {
                my $my_session_date = $supp_general{session_date};
                write_file_log($global_config_p, "Previous backup session date [ $my_session_date ]", \$log_body); # write the message into the script error file
            }
            else {
                write_file_log($global_config_p, "This is the first backup session", \$log_body); # write the message into the script error file
            }
            write_file_log($global_config_p, "The backup session number is [ $session_number ]",\$log_body); # write the message into the script error file
        }
        else {
            write_file_log($global_config_p, "Error : unable to read any valid copy of the support file", \$log_body); # write the message into the script error file
            $error_flag = 1; # mark error unable to read support file
        }
    }
    if ( $error_flag == 0 ) { # only enter if if no error occured.... ftp connect error for example

        if ( $$global_config_p{backup_mode} ne "full" and $$global_config_p{backup_real_mode} ne "full" and keys( %supp_managed_data ) == 0 ) { # if not under full backup mode and the mangement data is full
            $$global_config_p{backup_real_mode} = "full"; # reset the backup type to FULL
            $$global_config_p{keep_last_n_files} = 0; # doing a full backup, keep only the present backup and delete all the rest
            # reset the restore counters and dates and autosync counter and date
            $supp_general{restore_count} = 0;
            $supp_general{last_restore_date} = "never_restored";
            $supp_general{autosync_session} = 0;
            $supp_general{autosync_date} = "never_restored";
            write_file_log($global_config_p, "Notice : empty management data forcing full backup", \$log_body); # write the message into the script error file
        }
        else {
            # detecting if we need to do a full backup, if the backup files (defined by input_backup) is out of sync with the backup list (defined in the support file) or if there are any incremental/differencial backup  files under differencial/incremental backup mode (the reverse)
            my $present_backup_count = sum_backup_types(\%supp_backup_files, $global_config_p, \$log_body);
            if ( defined $present_backup_count ) {
                my ($full_count, $incremental_count, $differencial_count, $all_count ) = split ( / /, $present_backup_count); # split the counts into the apropriate fields
                if ( $$global_config_p{backup_mode} ne "full" and $$global_config_p{backup_real_mode} ne "full" and ($full_count != scalar(@my_input_backup_split) or ($$global_config_p{backup_mode} eq "differential" and $incremental_count != 0) or ($$global_config_p{backup_mode} eq "incremental" and $differencial_count != 0) ) ) { # detect (if required) if the full backup files are different from the backup data
                    $$global_config_p{backup_real_mode} = "full"; # reset the backup type to FULL
                    $$global_config_p{keep_last_n_files} = 0; # doing a full backup, keep only the present backup and delete all the rest
                    write_file_log($global_config_p, "Warning : the backup files are out of sync with the backup list or the backup mode, forcing a full backup", \$log_body); # write the message into the script error file
                }
                # we are implementing a full backup and managed data exists, so force a full backup and in the future even if this backup fails for some reason
                if ( $$global_config_p{backup_real_mode} eq "full" and keys( %supp_managed_data ) > 0 ) {
                    %supp_managed_data = (); # clear the previous managed data to force a full backup now and in the future
                    write_file_log($global_config_p, "Notice : updating support to force full backup", \$log_body); # write the message into the script error file
                    if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                        $error_flag = 1; # mark error unable to read support file
                    }
                }
            }
            else {
                $error_flag = 1; #  mark error
            }
        }
    }

    if ( $error_flag == 0 ) { # do the backups if no error occured
        my $all_backup_file_full_paths = ""; # used only during SMTP backups and with the all backup files in single email activated
        my $all_backup_filename_temp_fpath = ""; # used only during SMTP backups and with the all backup files in single email activated
        my %all_backup_filename_final_fpath_hash; # used only during SMTP backups and with the all backup files in single email activated

        # Compress each backup directory and move the apropriate file into his final location
        foreach my $my_backup_file_directory( @my_input_backup_split ) { # deal with each backup directory
           my $backup_data_type = "directory"; # by default the backup data is a directory
           if ( ! -d $my_backup_file_directory ) {
               $backup_data_type = "file"; # we are doing a backup of a file
           }
           write_file_log($global_config_p, "Processing backup $backup_data_type [ $my_backup_file_directory ]",\$log_body); # write the error message into the script error file
           my $input_backup_crc32 = build_crc32("$my_backup_file_directory", $global_config_p); # build the crc32 number for this backup directory
           my $my_backup_file_directory_name = get_filedir_name("$my_backup_file_directory", $global_config_p); # get the backup directory name
           my $dont_backup = "no"; # do backup (compress) by default
           my $previous_directory = get_previous_filedir_name("$my_backup_file_directory", $global_config_p); # get the directory path up the previous directory of the one to backup
           # build the backup list if no error occured and if required
           my %supp_new_managed_data_tmp; # this will countain the backup file list for the present backup session only
           if (!-d $my_backup_file_directory and !-f $my_backup_file_directory ) {
               $error_flag = 1; # mark directory or file to backup is not available
               write_file_log($global_config_p, "Error : [ $my_backup_file_directory ] does not exists or you do not have permissions to access it",\$log_body); # write the error message into the script error file
           }
           if ( $error_flag == 0 and $$global_config_p{build_backup_list} eq "yes" ) {
                write_file_log($global_config_p, "Building backup list", \$log_body); # write the message into the script error file
                if ( build_backup_list("$my_backup_file_directory", "$input_backup_crc32", "$previous_directory", "$my_backup_file_directory_name", \%supp_managed_data, \%supp_new_managed_data_tmp, \%supp_full_list, $meta_date, $session_number, $$global_config_p{host_file_separator}, $backup_data_type, 0, $global_config_p, \$log_body ) != 0 ) { # read the file into a hash
                    write_file_log($global_config_p, "Error : unable to build the backup list, check permissions and if the file system is not corrupted",\$log_body); # write the error message into the script error file
                    $error_flag = 1; # return failure
                }
                elsif ( keys( %supp_new_managed_data_tmp ) == 0 ) { # check if the backup list is not empty
                    $dont_backup = "yes"; # abort backup
                    write_file_log($global_config_p, "Notice : there is no new data, backup will not continue for $backup_data_type [ $my_backup_file_directory ]",\$log_body); # write the error message into the script error file
                }
            }
            if ( $error_flag == 0 and $dont_backup eq "no" ) { # if backup is required for this directory and if no error occured
                # build the backup file name (if no error occured)
                my $my_hostname_username = "";
                if ( $$global_config_p{hostname_on_backup_files} eq "yes" ) { # if we are including the hostname on the backup file names
                    $my_hostname_username = $$global_config_p{hostname};
                }
                if ( $$global_config_p{username_on_backup_files} eq "yes" ) { # if we are including the username on the backup file names
                    if ( $my_hostname_username eq "" ) {
                        $my_hostname_username = $$global_config_p{username};
                    }
                    else {
                        $my_hostname_username = $my_hostname_username . "." . $$global_config_p{username};
                    }
                }
                if ( $my_hostname_username eq "" ) { # if user doesn't want to include the hostname and/or the username on the backup file names
                    $backup_filename_final = "$my_backup_file_directory_name." . "$session_number " . $$global_config_p{backup_real_mode} . " $meta_date crc$input_backup_crc32." . $$global_config_p{backup_format};
                    $backup_filename_temp_fortar = "_tmp_" . "$my_backup_file_directory_name." . "$session_number " . $$global_config_p{backup_real_mode} . " $meta_date crc$input_backup_crc32." . "tar";
                }
                else { # if user want's to include the hostname and/or the username on the backup file names
                    $backup_filename_final = $my_hostname_username . ".$my_backup_file_directory_name." . "$session_number " . $$global_config_p{backup_real_mode} . " $meta_date crc$input_backup_crc32." . $$global_config_p{backup_format};
                    $backup_filename_temp_fortar = "_tmp_" . $my_hostname_username . ".$my_backup_file_directory_name." . "$session_number " . $$global_config_p{backup_real_mode} . " $meta_date crc$input_backup_crc32." . "tar";
                }
                $backup_filename_temp = "_tmp_$backup_filename_final";
                # deal with the temporary filenames with full path
                my $temporary_dir = "";
                if ( $$global_config_p{host_os} eq "unix" ) { # unix type paths
                    if ( $$global_config_p{temporary_dir} ne "/" ) { # if the temporary data is / (root) BIG mistake but it's up to the user
                        $temporary_dir = $$global_config_p{temporary_dir};
                    }
                    else {
                        $temporary_dir = "";
                    }
                }
                else { # microsoft type paths
                    $temporary_dir = $$global_config_p{temporary_dir};
                    $temporary_dir =~ s/\\$//;  # Delete trailing \ char
                }
                # now build the full path into the temporary files
                $backup_filename_temp_fpath = "$temporary_dir$my_file_separator$backup_filename_temp";
                $backup_filename_temp_fortar_fpath = "$temporary_dir$my_file_separator$backup_filename_temp_fortar";
                # add the temporary compressed files into the full path rejection list in order to prevent backup conflits
                $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . prepare_perl_wildcards($backup_filename_temp_fpath, $global_config_p);
                $$global_config_p{backup_full_path_rejections} = $$global_config_p{backup_full_path_rejections} . prepare_perl_wildcards($backup_filename_temp_fortar_fpath, $global_config_p);
                # Compress the directory
                my $backup_files_sumsize_current = do_compress($backup_filename_temp_fpath, $backup_filename_temp_fortar_fpath, $my_backup_file_directory_name, \%supp_new_managed_data_tmp, $previous_directory, $global_config_p, \$log_body);
                if ( $backup_files_sumsize_current < 0 ) { # detect if there was a error compressing the data
                    $error_flag = 1; # mark error
                    write_file_log($global_config_p, "Error : during backup compress process, check permissions, if you have the appropriate operating system commands, if no file (in the directory to be backup) is being locked by a program or operating system, and if there is enough free space on temporary path, indicated by [ temporary_dir ]", \$log_body); # write the error message into the script error file
                }
                # if the compress is ok, move the backup file into the final location
                if ( $error_flag == 0 ) {
                    # build final backup with the full path and file name
                    my $backup_path = "";
                    if ( $$global_config_p{backup_working} eq "local file system" ) { # if the directory is on the local file system
                        $backup_path = $$global_config_p{output_backup};
                    }
                    elsif ( $$global_config_p{backup_working} eq "ftp" ) { # if the directory is on the ftp server
                        $backup_path = $$global_config_p{ftp_directory};
                    }
                    elsif ( $$global_config_p{backup_working} eq "sftp" ) { # if the directory is on the sftp server
                        $backup_path = $$global_config_p{sftp_directory};
                    }
                    elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # if the directory is on the http dav server
                        $backup_path = $$global_config_p{dav_directory};
                    }
                    $backup_path =~ s/[\\\/]$// if "$backup_path" ne "/";;  # Delete trailing \ or / char same thing kind of but $ represents end of line
                    # deal with Operating System dependend stuff and build the full bath into the backup file
                    if ( $backup_path eq "/" and ($$global_config_p{host_os} eq "unix" or $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav") ) { # unix type paths or ftp/sftp/dav backup type
                        $backup_path = ""; # extra security to deal with / path's
                    }
                    if ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) { # if working in FTP/SFTP/HTTP-DAV
                        $backup_filename_final_fpath = "$backup_path/$backup_filename_final"; # build a full path file
                        if ( $$global_config_p{backup_working} eq "http-dav" ) { # if working in http dav then the full path to the file must be a full URL
                            # in the format http://some_server:server_port/some_file
                            $backup_filename_final_fpath = $$global_config_p{dav_url} . $backup_filename_final_fpath;
                        }
                    }
                    elsif ( $$global_config_p{backup_working} eq "tape" or $$global_config_p{backup_working} eq "smtp" ) { # if working under tape or SMTP email backups
                        $backup_filename_final_fpath = "$temporary_dir$my_file_separator$backup_filename_final"; #  build a full path file
                    }
                    else {
                        $backup_filename_final_fpath = "$backup_path$my_file_separator$backup_filename_final"; #  build a full path file
                    }
                    if ( $error_flag == 0 and $$global_config_p{encryption_passwd} ne "" ) { # if all is ok and encryption is activated
                       my $backup_filename_temp_fpath_encrypted = $backup_filename_temp_fpath . ".sc"; # file to encrypt (the temp file plus the .sc extension)
                       # encrypt the compressed backup file (the one with the _tmp_ in the filename)
                       write_file_log($global_config_p, "Encrypting the backup file [ $backup_filename_temp_fpath ] into [ $backup_filename_temp_fpath_encrypted ]", \$log_body); # write the error message into the script error file
                       $error_flag = crypt_decrypt_file($backup_filename_temp_fpath, $backup_filename_temp_fpath_encrypted, $$global_config_p{encryption_passwd}, "encrypt", $$global_config_p{encryption_file_read_size}, $$global_config_p{encryption_crypt}, $$global_config_p{encryption_level}, $crypting_file_algorithm_version, "yes", "no", $global_config_p );
                       if ( $error_flag == 0 ) {
                           # update the backup file size, since the encryption adds 23 more bytes
                           my ($source_dev,$source_ino,$source_mode,$source_nlink,$source_uid,$source_gid,$source_rdev,$backup_files_sumsize_current,$source_atime,$source_present_mtime,$source_ctime,$source_blksize,$source_blocks) = stat("$backup_filename_temp_fpath");
                           $backup_filename_temp_fpath .= ".sc"; # add the .sc extension into the temp file
                           $backup_filename_final_fpath .= ".sc"; # add the .sc extension into the final backup file (full path)
                           $backup_filename_final .= ".sc"; # add the .sc extension into the final backup file (file name)
                       }
                       else { # encryption failed, write a error msg
                           write_file_log($global_config_p, "Error : [ $backup_filename_temp_fpath ], unable to encrypt the file, check permissions, free space, if the password is correct and if the crypting times number and level are correct", \$log_body); # write the error message into the script error file
                       }
                    }
                    if ( $error_flag == 0 ) { # if all is ok
                       if ( $backup_files_count == 0 ) { # only enter here once, before doing ANY write into the tape device
                           # check if it's required to execute any system command before writing into tape
                           if ( $$global_config_p{backup_working} eq "tape" and $$global_config_p{tape_before_backup} ne "" ) {
                               my @tape_before_backup = $$global_config_p{tape_before_backup};
                               write_file_log($global_config_p, "Executing before writing to tape using the command [ @tape_before_backup ]", \$log_body); # write the error message into the script error file
                               system(@tape_before_backup) == 0 or $error_flag = 1; # execute the do before writing to tape and if we return 1 something failed
                               if ( $error_flag != 0 ) {
                                   write_file_log($global_config_p, "Error : before writing to tape procedure failed", \$log_body); # write the error message into the script error file
                               }
                           }
                        }
                        if ( $error_flag == 0 and ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) ) { # connect into the ftp/sftp/dav server
                            if ( $$global_config_p{sftp_transport} ne "psftp" and $$global_config_p{sftp_transport} ne "sftp") { # if we are  using perl modules to ssh/sftp connection (web dav, ftp and ssh2 enter here)
                                my $network_type = $$global_config_p{backup_working};
                                write_file_log($global_config_p, "Connect and login into the $network_type server, for backup file upload",\$log_body); # write the error message into the script error file
                                sleep 30; # sleep for 30 seconds in order to prevent a overkill of the ftp/sftp/dav server with a series of fast login and logoffs, this  could occured if the backup data is small and we have pleanty of different directories and files to backup
                                if ( network_connect_login(\$network_connection, "Error", $global_config_p, \$log_body) != 0 ) {
                                    $error_flag = 1;
                                    write_file_log($global_config_p, "Error : $network_type server is not available, backup will not continue",\$log_body); # write the error message into the script error file
                                }
                            }
                        }
                        if ( $error_flag == 0 ) { # if no error occured

                            if ( $$global_config_p{build_backup_list} eq "yes" ) { # copy the present backup list into the final backup list if required
                                for my $supp_new_managed_data_tmp_record ( keys %supp_new_managed_data_tmp ) {
                                    $supp_new_managed_data{$supp_new_managed_data_tmp_record} = ();
                                }
                            }
                            # move each file into the final location IF we are not working in SMTP backup mode and if the SMTP backup mode is not individual (a single backup file per email)
                            if ( $$global_config_p{backup_mode} ne "smtp" and $$global_config_p{backup_mail_attachment_method} ne "all" ) {
                                # if a compressed backup file generated by simplebackup limit exists, compare the backup file size with the limit
                                if ($$global_config_p{compressed_file_size_limit} != 0 and $backup_files_sumsize_current > $$global_config_p{compressed_file_size_limit_bytes} ) {
                                    $error_flag = 1;
                                    write_file_log($global_config_p, "Error : The backup file [ $backup_filename_temp_fpath ] is over " . $$global_config_p{compressed_file_size_limit} . " Kbytes (compressed file size limit )", \$log_body); # write the error message into the script error file
                                }
                                if ( $error_flag == 0 ) { # if no error occured
                                    write_file_log($global_config_p, "Moving temporary backup file [ $backup_filename_temp_fpath ] into the final backup file [ $backup_filename_final_fpath ]", \$log_body); # write the error message into the script error file
                                    # move compress backup file from the temporary location into the final backup destination
                                    my $move_result = put_backup_file("$backup_filename_temp_fpath", "$backup_filename_final_fpath", \$network_connection, $global_config_p, \$log_body);
                                    if ( $move_result != 0 ) {
                                        $error_flag = 1; # mark error
                                        write_file_log($global_config_p, "Error : moving temporary backup file [ $backup_filename_temp_fpath ] into the final backup file [ $backup_filename_final_fpath ]", \$log_body); # write the error message into the script error file
                                    }
                                    else { # moving of the file into the final location is a success
                                        $backup_files_count++; # increment the total of backup files that where created
                                        push (@input_backup_done, $my_backup_file_directory); # add the backup directory into the valid done list
                                        $backup_files_sumsize = $backup_files_sumsize + $backup_files_sumsize_current; # file move works increment the backup files size
                                        # add the list of files and directories backuped into the log if the user so want's it
                                        if ( $$global_config_p{backup_list_on_log} eq "yes" ) {
                                            write_lists(\%supp_new_managed_data_tmp, "backup", $global_config_p, \$log_body);
                                        }
                                    }
                                    # update the support file with the new file backuped, PS: $move_result == 2 means that the upload into the ftp server failed and the partialy uploaded file also failed to be erase
                                    if ( $move_result == 0 or $move_result == 2 ) {
                                        if ( $move_result == 0 and $$global_config_p{backup_mode} ne "full" and $$global_config_p{backup_real_mode} ne "differential" ) {
                                            patch_management_records(\%supp_managed_data, \%supp_new_managed_data, $global_config_p, \$log_body); # update the management data with the new data (from this backup session)
                                        }
                                        patch_backup_files_records(\%supp_backup_files, $backup_filename_final, $backup_files_sumsize_current, "backup_add_update", $global_config_p, \$log_body, ); # add the file into the backup files list (in memory)
                                        if ( $move_result != 2 ) { # only write the details if the backup file was correctly writeen
                                            patch_backup_files_details_records(\%supp_backup_files_details, \%supp_new_managed_data_tmp, $backup_filename_final, "", "backup_add", $global_config_p, \$log_body); # add the list of data containined on the backup file into the backup file details list
                                        }
                                        $supp_general{current_session} = $session_number;
                                        $supp_general{session_date} = $meta_date;
                                        write_file_log($global_config_p, "Notice : updating support file", \$log_body); # write the message into the script error file
                                        if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                                            $error_flag = 1; # mark error unable to write support file
                                        }
                                    }
                                }
                            }
                            else { # Doing a SMTP backup using the all option (attach all backup files into a single email)
                                # add the list of files and directories backuped into the log if the user so want's it
                                if ( $$global_config_p{backup_list_on_log} eq "yes" ) {
                                    write_lists(\%supp_new_managed_data_tmp, "backup", $global_config_p, \$log_body);
                                }
                                if ( $all_backup_file_full_paths ne "" ) { # the final names of the backup files
                                    $all_backup_file_full_paths = "$all_backup_file_full_paths<$backup_filename_final_fpath"; # not on the first line
                                }
                                else { # on the first line
                                    $all_backup_file_full_paths = $backup_filename_final_fpath;
                                }
                                if ( $all_backup_filename_temp_fpath ne "" ) { # the temporary final names of the backup files
                                    $all_backup_filename_temp_fpath = "$all_backup_filename_temp_fpath<$backup_filename_temp_fpath"; # not on the first line
                                }
                                else { # on the first line
                                    $all_backup_filename_temp_fpath = $backup_filename_temp_fpath;
                                }
                                $all_backup_filename_final_fpath_hash{$backup_filename_final_fpath} = $backup_files_sumsize_current; # hash to associate the backup file name with his size
                                $backup_files_sumsize = $backup_files_sumsize + $backup_files_sumsize_current; # file move works increment the backup files size
                                if ($$global_config_p{backup_mail_type} eq "smtp" and $$global_config_p{compressed_file_size_limit} != 0 and $backup_files_sumsize > $$global_config_p{compressed_file_size_limit_bytes} ) {
                                    $error_flag = 1;
                                    write_file_log($global_config_p, "Error : The backup files are over " . $$global_config_p{compressed_file_size_limit} . " Kbytes (compressed file size limit )", \$log_body); # write the error message into the script error file
                                }
                                else { # all ok so far
                                    # if doing a email backup and the backup attachment limit exists, compare the backup file size with the limit
                                    $backup_files_count++;
                                    push (@input_backup_done, $my_backup_file_directory); # add the backup directory into the valid done list
                                    if ( $$global_config_p{backup_mode} ne "full" and $$global_config_p{backup_real_mode} ne "differential" ) {
                                        patch_management_records(\%supp_managed_data, \%supp_new_managed_data, $global_config_p, \$log_body); # update the management data with the new data (from this backup session)
                                    }
                                    patch_backup_files_records(\%supp_backup_files, $backup_filename_final, $backup_files_sumsize_current, "backup_add_update", $global_config_p, \$log_body, ); # add the file into the backup files list (in memory)
                                    patch_backup_files_details_records(\%supp_backup_files_details, \%supp_new_managed_data_tmp, $backup_filename_final, "", "backup_add", $global_config_p, \$log_body); # add the list of data containined on the backup file into the backup file details list
                                }
                            }
                        }
                        if ( defined $network_connection and ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) ) { # disconnect the ftp/sftp server, if connected before
                            my $network_type = $$global_config_p{backup_working};
                            write_file_log($global_config_p, "Disconnecting from $network_type server",\$log_body); # write the error message into the script error file
                            if ( $$global_config_p{backup_working} eq "ftp" ) {
                                $network_connection->quit() if $network_connection; # disconnect from ftp server
                                $network_connection = undef;
                            }
                            elsif ( $$global_config_p{backup_working} eq "sftp" ) {
                                $network_connection = undef;
                            }
                            else { # disconnect the http-dav server, if connected before
                                $network_connection->unlock( -url => $$global_config_p{dav_url_full} );
                                $network_connection = undef;
                            }
                        }
                    }
                }
                if ( $$global_config_p{backup_mail_type} ne "smtp" and $$global_config_p{backup_mail_attachment_method} ne "individual" and -f "$backup_filename_temp_fpath" ) { # erase the temporary file if one is still available
                    write_file_log($global_config_p, "Erasing temporary backup file [ $backup_filename_temp_fpath ]", \$log_body); # write the error message into the script error file
                    unlink "$backup_filename_temp_fpath"; # erase temporary file
                }
            }
            last if ( $error_flag != 0 ); # break backup cycle if any error occured
        }

        # doing SMTP email backup and using the all method (all backup files on a single email) and if we did backup any file
        if ( $$global_config_p{backup_mail_type} eq "smtp" and $$global_config_p{backup_mail_attachment_method} eq "all" and $backup_files_count > 0) {
            my @all_backup_file_full_paths_split = split (/</, $all_backup_file_full_paths); # split the temporary compressed files build
            if ( $error_flag == 0 ) { # if no error occured during compress process
                write_file_log($global_config_p, "Moving temporary backup file(s) into the final backup destination email account(s)", \$log_body); # write the error message into the script error file
                # move compress backup file(s) from the temporary location into the final backup destination
                my $move_result = put_backup_file("$all_backup_filename_temp_fpath", "$all_backup_file_full_paths", \$network_connection, $global_config_p, \$log_body);
                if ( $move_result != 0 ) {
                    @input_backup_done = ""; # clear the done list, nothing was done with success
                    $error_flag = 1; # mark error
                    write_file_log($global_config_p, "Error : moving temporary backup file(s) into the final backup destination email account(s)", \$log_body); # write the error message into the script error file
                }
                else { # moving of the file(s) into the final Email is a success
                    foreach my $tmp_all_backup_file_full_paths ( @all_backup_file_full_paths_split ) {
                        # update the support file with the new file backuped
                        $supp_general{current_session} = $session_number;
                        $supp_general{session_date} = $meta_date;
                        write_file_log($global_config_p, "Notice : updating support file", \$log_body); # write the message into the script error file
                        if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                            $error_flag = 1; # mark error unable to write support file
                        }
                        
                    }
                }
            }
            # erase any left over temporary files
            foreach my $tmp_all_backup_file_full_paths ( @all_backup_file_full_paths_split ) {
                $tmp_all_backup_file_full_paths = get_filedir_name("$tmp_all_backup_file_full_paths", $global_config_p); # get the file name only without the full path's
                $tmp_all_backup_file_full_paths = "_tmp_$tmp_all_backup_file_full_paths"; # add the _tmp_
                $tmp_all_backup_file_full_paths = $$global_config_p{temporary_dir} . "$my_file_separator$tmp_all_backup_file_full_paths"; #  build a full path file with the _tmp_ chars
                write_file_log($global_config_p, "Erasing temporary backup file [ $tmp_all_backup_file_full_paths ]", \$log_body); # write the error message into the script error file
                unlink "$tmp_all_backup_file_full_paths" if $tmp_all_backup_file_full_paths; # erase temporary file
            }
        }
    }

    if ( $error_flag == 0 ) { # clear previous backups (if required) and if no error occured
        # check if we need to clear any previous backups, under ftp backups the clear_previous_backups() function will connect into the ftp server (if required) and disconnect when no longer required
        my $clear_previous_backups_result = clear_previous_backups($session_number, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, $global_config_p, \$log_body);
        if ( $clear_previous_backups_result > 0 ) { # update the support file to update the backup file list
            # update the support file
            $supp_general{current_session} = $session_number;
            $supp_general{session_date} = $meta_date;
            write_file_log($global_config_p, "Notice : updating support file", \$log_body); # write the message into the script error file
            if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                $error_flag = 1; # mark error unable to write support file
            }
        }
        elsif( $clear_previous_backups_result < 0 ) { # mark error
            $error_flag = 1; # mark error
        }
    }

    # check if there is a available the script/batch file/command declare by run_after_backup  RUN IT !
    if ( $$global_config_p{run_after_backup} ne "" and ( $$global_config_p{on_failure_run_after_backup} eq "yes" or ($$global_config_p{on_failure_run_after_backup} eq "no" and $error_flag == 0) ) ) {
        sleep 60; # wait 60 seconds prior to running the after restore procedure because some O/S processes might still be writting (example if doing a backup into a previously mounted drive)
        my $special_error_flag = 0;
        my $run_after_backup_command = $$global_config_p{run_after_backup};
        write_file_log($global_config_p, "Executing after backup procedure using the command [ $run_after_backup_command ]", \$log_body); # write the error message into the script error file
        system($run_after_backup_command) == 0 or $special_error_flag = 1; # do backup and if we return 1 something failed
        if ( $special_error_flag > 0 ) {
            write_file_log($global_config_p, "Warning : after backup procedure failed", \$log_body); # write the error message into the script error file
        }
    }
    # check if it's required to execute any system command after writing into tape, this of course if any use of the tape was done in the first place
    if ( $backup_files_count > 0 and $$global_config_p{backup_working} eq "tape" and $$global_config_p{tape_after_backup} ne "" ) {
        my @tape_after_backup = $$global_config_p{tape_after_backup};
        my $special_error_flag = 0;
        write_file_log($global_config_p, "Executing after writing to tape using the command [ @tape_after_backup ]", \$log_body); # write the error message into the script error file
        system(@tape_after_backup) == 0 or $special_error_flag = 1; # execute the do before writing to tape and if we return 1 something failed
        if ( $special_error_flag != 0 ) {
            write_file_log($global_config_p, "Warning : after writing to tape procedure failed", \$log_body); # write the error message into the script error file                        
        }
    }

    # get the total size of all backups, even if the backup runned with or without success
    my ( $current_session_files_number, $current_session_files_size, $current_backup_details_number, $current_backup_details_size, $all_session_files_number, $all_session_files_size, $all_backup_details_number, $all_backup_details_size ) = split ( / /, sum_all_backups(\%supp_backup_files, \%supp_backup_files_details, $supp_general{current_session}, $global_config_p, \$log_body) );
    # convert the size of the backup temporary file, into kbytes and mbytes, since it's in bytes, rounding them up
    my $current_session_files_size_kbytes = sprintf("%.2f",$current_session_files_size/1024); # 1024 bytes = 1 Kbyte
    my $current_session_files_size_mbytes = sprintf("%.2f",$current_session_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
    my $current_backup_details_size_kbytes = sprintf("%.2f",$current_backup_details_size/1024); # 1024 bytes = 1 Kbyte
    my $current_backup_details_size_mbytes = sprintf("%.2f",$current_backup_details_size_kbytes/1024); # 1024 kbytes = 1 Mbyte

    my $all_session_files_size_kbytes = sprintf("%.2f",$all_session_files_size/1024); # 1024 bytes = 1 Kbyte
    my $all_session_files_size_mbytes = sprintf("%.2f",$all_session_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
    my $all_backup_details_size_kbytes = sprintf("%.2f",$all_backup_details_size/1024); # 1024 bytes = 1 Kbyte
    my $all_backup_details_size_mbytes = sprintf("%.2f",$all_backup_details_size_kbytes/1024); # 1024 kbytes = 1 Mbyte

    # write the message reporting the backup data files etc
    my $current_session_msg = "During this backup session a total of [ $current_session_files_number ] backup file(s) were written and occupy [ $current_session_files_size_mbytes Mbytes / $current_session_files_size_kbytes Kbytes ]";
    my $current_session_details_msg = "The written backup files contain a total of [ $current_backup_details_number ] file(s) and directori(es) that occupy [ $current_backup_details_size_mbytes Mbytes / $current_backup_details_size_kbytes Kbytes ]";
    my $all_session_msg = "A total of [ $all_session_files_number ] backup file(s) exist and occupy [ $all_session_files_size_mbytes Mbytes / $all_session_files_size_kbytes Kbytes ]";
    my $all_session_details_msg = "The written backup files contain a total of [ $all_backup_details_number ] file(s) and directori(es) that occupy [ $all_backup_details_size_mbytes Mbytes / $all_backup_details_size_kbytes Kbytes ]";

    if ( $$global_config_p{backup_working} eq "ftp" ) { # ftp backup mode
        my $my_backup_working = $$global_config_p{backup_working}; # backup mode ftp
        my $my_remote_server_name = $$global_config_p{ftp_server}; # remote server name, only ftp is supported so far
        my $my_remote_server_port = $$global_config_p{ftp_server_port}; # remote server port, only ftp is supported so far
        my $my_remote_username = $$global_config_p{ftp_username}; # remote username, only ftp username is supported so far
        my $my_ftp_directory = $$global_config_p{ftp_directory}; # remote ftp direcotry
        $current_session_msg .= ", located in the remote $my_backup_working server [ $my_remote_server_name:$my_remote_server_port ; username: $my_remote_username ; directory: $my_ftp_directory ]";
    }
    if ( $$global_config_p{backup_working} eq "sftp" ) { # sftp backup mode
        my $my_backup_working = $$global_config_p{backup_working}; # backup mode sftp
        my $my_remote_server_name = $$global_config_p{sftp_server}; # remote server name, only sftp is supported so far
        my $my_remote_server_port = $$global_config_p{sftp_server_port}; # remote server port, only sftp is supported so far
        my $my_remote_username = $$global_config_p{sftp_username}; # remote username, only sftp username is supported so far
        my $my_sftp_directory = $$global_config_p{sftp_directory}; # remote sftp direcotry
        $current_session_msg .= ", located in the remote $my_backup_working server [ $my_remote_server_name:$my_remote_server_port ; username: $my_remote_username ; directory: $my_sftp_directory ]";
    }
    if ( $$global_config_p{backup_working} eq "http-dav" ) { # http dav backup mode
        my $my_backup_working = $$global_config_p{backup_working}; # backup mode sftp
        my $my_remote_server_name = $$global_config_p{dav_server}; # remote server name, only sftp is supported so far
        my $my_remote_server_port = $$global_config_p{dav_server_port}; # remote server port, only sftp is supported so far
        my $my_remote_username = $$global_config_p{dav_username}; # remote username, only sftp username is supported so far
        my $my_dav_directory = $$global_config_p{dav_directory}; # remote sftp direcotry
        $current_session_msg .= ", located in the remote $my_backup_working server [ $my_remote_server_name:$my_remote_server_port ; username: $my_remote_username ; directory: $my_dav_directory ]";
    }
    elsif ( $$global_config_p{backup_working} eq "tape" ) { # tape backup mode
        my $my_tape_device = $$global_config_p{tape_device}; # tape get the device
        $current_session_msg .= ", located in tape device [ $my_tape_device ]";
        $all_session_msg .= ", located in tape device [ $my_tape_device ]";
    }
    elsif ( $$global_config_p{backup_working} eq "smtp" ) { # smtp backup mode
        my $backup_mail_to_addresses = $$global_config_p{backup_mail_to_addresses}; # get the email addresses
        $current_session_msg .= ", located in email address(es) [ $backup_mail_to_addresses ]";
        $all_session_msg .= ", located in email address(es) [ $backup_mail_to_addresses ]";
    }
    if ( $backup_files_count > 0 and $current_session_files_number > 0 ) { # control sitiations where the current backup did not start (backup rules inibit this)
        write_file_log($global_config_p, $current_session_msg, \$log_body);
        write_file_log($global_config_p, $current_session_details_msg, \$log_body);
    }
    if ( $all_session_files_number > 0 ) { # control sitiations where there are not backup files available
        write_file_log($global_config_p, $all_session_msg, \$log_body);
        write_file_log($global_config_p, $all_session_details_msg, \$log_body);
    }

    # write the final backup messages and send the email report (if configured by user)
    my $my_configuration_file_name = $$global_config_p{configuration_file_name}; # get the configuration file name, something.conf  , not /path/something.conf or c:\path\something.conf
    my $my_full_date = get_file_metadata_date($global_config_p, "yes");
    $my_full_date = ucfirst $my_full_date; # turn the first letter to upper case (ex... monday = Monday)

    if ( $error_flag == 0 ) { # write the final message on the log/email report, success or failure, error_flag == 0 here means success in backup

        if ( $$global_config_p{pass_log_to_external_cmd} ne "" ) { # if there is any available external command to accept the log
            write_file_log($global_config_p, "Calling external command and passing the backup log by the stdin, notice if the email report is used this will not be reported here", \$log_body); # write the error message into the script error file
            my $ext_log_body = "$log_body" . "$my_full_date - End of Backup in ++ success ++\n\n";
            if ( export_log( $ext_log_body, $global_config_p ) != 0 ) { # there was a error
                my $pass_log_to_external_cmd = $$global_config_p{pass_log_to_external_cmd};
                write_file_log($global_config_p, "Warning : there was a problem calling [ $pass_log_to_external_cmd ]", \$log_body); # write the error message into the script error file
            }
        }
        if ( $$global_config_p{mail_server} ne "" ) { # if mail server is configured then we can send email read_config() functions tests previoulys
            write_file_log($global_config_p, "Sending email backup report", \$log_body); # write the error message into the script error file
            my $email_log_body = "Beginning of email report\n\n" . "$log_body" . "$my_full_date - End of Backup in ++ success ++\n\n" . "End of email report\n\n";
            send_email("Simplebackup report [ $machine_hostname ; $my_configuration_file_name ; $session_number ]. Backup ended in ++ success ++.", $email_log_body, "", "$$global_config_p{mail_server}", "$$global_config_p{mail_port}", "$$global_config_p{mail_from_address}", "$$global_config_p{mail_to_addresses}", "$$global_config_p{mail_username}", "$$global_config_p{mail_password}", "simplebackup.pl v$script_version_int - $last_update_int", $global_config_p);
        }
        write_file_log($global_config_p, "End of Backup in ++ success ++\n\n", \$log_body); # write the error message into the script error file
    }
    else { # if the backup failed
        if ( $$global_config_p{pass_log_to_external_cmd} ne "" ) { # if there is any available external command to accept the log
            write_file_log($global_config_p, "Calling external command and passing the backup log by the stdin, notice if the email report is used this will not be reported here", \$log_body); # write the error message into the script error file
            my $ext_log_body = "$log_body" . "$my_full_date - End of Backup in -- failure --\n\n";
            if ( export_log( $ext_log_body, $global_config_p ) != 0 ) { # there was a error
                my $pass_log_to_external_cmd = $$global_config_p{pass_log_to_external_cmd};
                write_file_log($global_config_p, "Warning : there was a problem calling [ $pass_log_to_external_cmd ]", \$log_body); # write the error message into the script error file
            }
        }
        if ( $$global_config_p{mail_server} ne "" ) { # if mail server is configured then we can send email read_config() functions tests previoulys
            write_file_log($global_config_p, "Sending email backup report", \$log_body); # write the error message into the script error file
            my $email_log_body = "Beginning of email report\n\n" . "$log_body" . "$my_full_date - End of Backup in -- failure --\n\n" . "End of email report\n\n";
            send_email("Simplebackup report [ $machine_hostname ; $my_configuration_file_name ; $session_number ]. Backup ended in -- failure --.", $email_log_body, "", "$$global_config_p{mail_server}", "$$global_config_p{mail_port}", "$$global_config_p{mail_from_address}", "$$global_config_p{mail_to_addresses}", "$$global_config_p{mail_username}", "$$global_config_p{mail_password}", "simplebackup.pl v$script_version_int - $last_update_int", $global_config_p);
        }
        write_file_log($global_config_p, "End of Backup in -- failure --\n\n", \$log_body); # write the error message into the script error file
    }

    print "Function do_backup() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the backup result
}


#
# Test the command line arguments, and load the configuration has
# Will return: 0 ; any other integer number is failure
# Explain: 0 is success ; 1 invalid number of command line arguments; 2 repeated command line arguments ; 3 invalid command line arguments ;
#          4 restore list file does not exists or lack of permissions ; 5 restore into path is not defined has a full path ; 6 restore into path is
#          not a valid directory ; 7 invalid session number, value must be a integer number equal or over zero ; 8 the --erase_extra argument value
#          must be yes or no ; 9 invalid restore mode, valid values are manual ; auto or autosync
sub test_and_prepare_restore_config {

    my $message_output = $_[0]; # where the output goes into
    my $argv_p = $_[1]; # pointer into the command line arguments, can be NOT DEFINED
    my $restore_config_p = $_[2]; # pointer into the restore configuration that will be writing into the restore config hash, can be NOT DEFINED
    my $global_config_p = $_[3]; # pointer into the configuration, can be NOT DEFINED
    print "Running test_and_prepare_restore_config() function\n" if ( defined $global_config_p and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $log_body_p = $_[4]; # pointer into the email body string, can be NOT DEFINED
    
    my $error_flag = 0; # to mark errors
    my @fixed_argv; # will contain the command line arguments (if any), ordered and fixed (windows workaround)!!

    my %rest_config = ( # restore configuration hash
        "rlist_file"    => "",    # The list of files/directories to restore, this can come from command line parameters or from the backup configuration file (input_backup), ALWAYS REQUIRED
        "to"            => "",    # Where to restore the list of files/directories to restore, this can come from command line parameters or from the backup configuration file (input_backup), ALWAYS REQUIRED
        "session"       => "",    # Start the restore from which session (incluing), this comes from command line parameters, NOT REQUIRED
        "erase_extra"   => "",    # Erase files and directories not found on the session refered by the user on the --session ?... this is also automaticly enabled during autosync mode
        "mode"  => "",    # Restore mode (manual ; auto ; autosync)
    );

    if ( defined $argv_p and $argv_p ne "" ) { # if there are any command line arguments
        # work around to deal with windows systems (perl has problems with the \ char)
        # Without this code... this: perl -w simplebackup.pl restore_list "c:\< d:\as <e:\n\"  start_session 10 end_session 12   will fail !!!!
        # This will also create a order command line argument, to give users the freedom to write the restore arguments with any order they want
        my @fixed_argv_tmp; # temporary array
        my $i = 0;
        foreach my $show ( @$argv_p ) {
            if ( $show !~ /"/ ) { # if there is no " char, simply add into the new command line
                $fixed_argv_tmp[$i] = $show;
            }
            else { # there was a " char... so perl will do a poo !!
                my ( $show_split, $show_remain ) = split(/"/, $show,2 ); #limit is 2 meaning it will only split the first " char
                $fixed_argv_tmp[$i] = "$show_split\\";
                # process the remain of the arguments (split by " " (space) char
                my @show_remain_split =  split(/"/, $show_remain ) if ( defined $show_remain );
                $show_remain =~ s/^\s+// if (defined $show_remain);  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                $show_remain =~ s/\s+$// if (defined $show_remain);  # Delete trailing whitespace same thing kind of but $ represents end of line.
                @show_remain_split =  split(/ /, $show_remain ) if ( defined $show_remain );
                foreach my $show2 ( @show_remain_split ) {
                    $i++;
                    $fixed_argv_tmp[($i)] = "$show2";
                }
                last; # end !!
            }
            $i++;
        }
        # Detect if we have a valid number of command line arguments
        if ( scalar(@fixed_argv_tmp) > 12 or (scalar(@fixed_argv_tmp)/2) !~ /^\d+$/ ) {
            $error_flag = 1; # mark error, command line arguments are not multiple of 2 or over 12
        }
        else { # test the actual command line arguments and reorder the command line arguments

            my $counter = 0;
            foreach my $cmd_line_value ( @fixed_argv_tmp ) { # load up the restore configuration using the cmd line values
                switch: {
                        $cmd_line_value eq "--rconf" && do { # the restore cmd line
                                # reset the values for a future check up
                                $fixed_argv_tmp[$counter] = "";
                                $fixed_argv_tmp[$counter+1] = "";
                             };
                        $cmd_line_value eq "--rlist_file" && do { # the restore list file
                                if ( $rest_config{rlist_file} eq "") {
                                    $rest_config{rlist_file} = $fixed_argv_tmp[$counter+1];
                                }
                                else {
                                    $error_flag = 2; #mark error repeted cmd line argument
                                }
                                # reset the values for a future check up
                                $fixed_argv_tmp[$counter] = "";
                                $fixed_argv_tmp[$counter+1] = "";
                             };
                        $cmd_line_value eq "--to" && do { # default path to restore
                                if ( $rest_config{to} eq "" ) {
                                    $rest_config{to} = $fixed_argv_tmp[$counter+1];
                                }
                                else {
                                }
                                # reset the values for a future check up
                                $fixed_argv_tmp[$counter] = "";
                                $fixed_argv_tmp[$counter+1] = "";
                             };
                        $cmd_line_value eq "--session" && do { # session to be the reference when restoring
                                if ( $rest_config{session} eq "" ) {
                                    $rest_config{session} = $fixed_argv_tmp[$counter+1];
                                }
                                else {
                                    $error_flag = 2; #mark error repeted cmd line argument
                                }
                                # reset the values for a future check up
                                $fixed_argv_tmp[$counter] = "";
                                $fixed_argv_tmp[$counter+1] = "";
                             };
                        $cmd_line_value eq "--erase_extra" && do { # erase files/directories not found on the session refered by --session ?
                                if ( $rest_config{erase_extra} eq "" ) {
                                    $rest_config{erase_extra} = lc($fixed_argv_tmp[$counter+1]);
                                }
                                else {
                                    $error_flag = 2; #mark error repeted cmd line argument
                                }
                                # reset the values for a future check up
                                $fixed_argv_tmp[$counter] = "";
                                $fixed_argv_tmp[$counter+1] = "";
                             };
                        $cmd_line_value eq "--mode" && do { # default path to restore
                                if ( $rest_config{mode} eq "" ) {
                                    $rest_config{mode} = lc($fixed_argv_tmp[$counter+1]);
                                }
                                else {
                                    $error_flag = 2; #mark error repeted cmd line argument
                                }
                                # reset the values for a future check up
                                $fixed_argv_tmp[$counter] = "";
                                $fixed_argv_tmp[$counter+1] = "";
                             };
                }
                $counter++;
                last if $error_flag != 0; # exit on error
            }
        }
        if ( $error_flag == 0 ) {
            # look for invalid cmd line arguments
            foreach my $cmd_line_value ( @fixed_argv_tmp ) { # load up the restore configuration using the cmd line values
                if ( $cmd_line_value ne "" ) {
                    $error_flag = 3; # mark error invalid cmd line
                }
                last if $error_flag != 0; # exit on error
            }
        }
    }
    if ( $error_flag == 0 ) { # now load up the default values where required and test everything

        # load up the default vaules if required
        $rest_config{mode} = "manual" if ( $rest_config{mode} eq "" );
        if ( $rest_config{mode} eq "autosync" ) { # if running in autosync mode
            $rest_config{erase_extra} = "yes" if ( $rest_config{erase_extra} eq "" );
        }
        else { # not running in autosync mode then by default we do not erase files
            $rest_config{erase_extra} = "no" if ( $rest_config{erase_extra} eq "" );
        }

        # now test final values
        if ( $rest_config{rlist_file} ne "" and !-f $rest_config{rlist_file} ) {
            $error_flag = 4; # mark error restore file defined by user does not exists
        }
        # this test will only work if the backup configuration file was actually loaded ($global_config_p)
        if ( $error_flag == 0 and defined $$global_config_p{host_os} and $rest_config{to} ne "" and check_if_full_path($rest_config{to}, $$global_config_p{host_os}, $global_config_p) != 0 ) {
            $error_flag = 5; # mark error restore into path is not defined has a full path
        }
        if ( $error_flag == 0 and -f $rest_config{to} ) {
            $error_flag = 6; # mark error restore into path is a file and not a directory
        }
        if ( $error_flag == 0 and $rest_config{session} ne "" and (!($rest_config{session} =~ /^\d+$/) or $rest_config{session} < 0) ) {
            $error_flag = 7; # mark error, invalid session number
        }
        if ( $error_flag == 0 and $rest_config{erase_extra} ne "yes" and $rest_config{erase_extra} ne "no" ) {
            $error_flag = 8; # mark error, value must be yes or no for the erase_extra value
        }
        if ( $error_flag == 0 and $rest_config{mode} ne "manual" and $rest_config{mode} ne "auto" and  $rest_config{mode} ne "autosync" ) {
            $error_flag = 9; # mark error, invalid restore mode,  valid values are manual ; auto ; autosync
        }
    }

    if ( $error_flag == 0 and defined $restore_config_p ) { # if error occured and if we actually want to load the restore configuration hash
        # copy the configuration values from the internal hash into the main configuration hash
        $$restore_config_p{rlist_file} = $rest_config{rlist_file};
        $$restore_config_p{to} = $rest_config{to};
        $$restore_config_p{session} = $rest_config{session};
        $$restore_config_p{erase_extra} = $rest_config{erase_extra};
        $$restore_config_p{mode} = $rest_config{mode};
    }
    elsif ( $error_flag != 0 ) { # a error was found, create the apropriate error message
        my $error_message = "";
        switch: {
            $error_flag == 1 && do {
                                $error_message = "invalid number of command line arguments";
                            };
            $error_flag == 2 && do {
                                $error_message = "repeated command line arguments";
                            };
            $error_flag == 3 && do {
                                $error_message = "invalid command line arguments";
                            };
            $error_flag == 4 && do {
                                $error_message = "restore list file does not exists or lack of permissions";
                            };
            $error_flag == 5 && do {
                                $error_message = "restore into path is not defined has a full path";
                            };
            $error_flag == 6 && do {
                                $error_message = "restore into path is not a valid directory";
                            };
            $error_flag == 7 && do {
                                $error_message = "invalid session number, value must be a integer number equal or over zero";
                            };
            $error_flag == 8 && do {
                                $error_message = "the --erase_extra argument value must be yes or no";
                            };
            $error_flag == 9 && do {
                                $error_message = "invalid restore mode, valid values are manual ; auto or autosync";
                            };
        }

        if ( defined $message_output and $message_output eq "log" ) { # if writting error message into the log file
            $error_message =~ s/\n/ /g; # remove the new line chars and replace them with spaces
            $error_message = "Error : " . $error_message; # add the error marker
            write_file_log($global_config_p, $error_message, $log_body_p); # write the message into the script error file
        }
        elsif ( defined $message_output and $message_output eq "stdout" ) { # if printing into the console/terminal/cmdline
            print "\n[ Error ],\n$error_message\n\n";
        }
    }

    print "Function test_and_prepare_restore_config() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result

}


#
# Get a backup from the backup_output into the temporary directory
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub get_backup_file {

    my $from_file = $_[0]; # origin file, to be passed to perl commands
    my $to_file = $_[1]; # destiny file, to be passed to perl commands
    my $network_connection_p = $_[2]; # ftp connection object
    my $global_config_p = $_[3]; # configuration pointer
    print "Running the get_backup_file() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[4]; # pointer into the email body string

    my $error_flag = 0; # to mark errors

    if ( $$global_config_p{backup_working} eq "local file system" ) { # local file system
        $error_flag = copy_file("$from_file", "$to_file", 16384, $global_config_p); # copy the file from the output directory into the temporary directory, using 16Kb read buffer and 512Kb write buffer
    }
    elsif ( $$global_config_p{backup_working} eq "ftp" ) { # ftp copy (NET::FTP)
        $$network_connection_p->binary(); # put in binary download mode
        if ( !$$network_connection_p->get( "$from_file", "$to_file" ) ) {
            write_file_log($global_config_p, "Error : unable to download the backup file from the ftp server into the temporary directory, it might be lack of permissions, lack of free space or the ftp connection might have dropped, the file is [ $from_file ]", $log_body_p); # write the error message into the script error file
            $error_flag = 1; # mark error
         }
    }
    elsif ( $$global_config_p{backup_working} eq "sftp" ) { # sftp copy (NET::SFTP)
        if ( $$global_config_p{sftp_transport} eq "net::ssh2" ) { # if using the ssh2 perl module
            if ( !$$network_connection_p->get( "$from_file", "$to_file" ) ) {
                write_file_log($global_config_p, "Error : unable to download the backup file from the sftp server into the temporary directory, it might be lack of permissions, lack of free space or the sftp connection might have dropped, the file is [ $from_file ]", $log_body_p); # write the error message into the script error file
                $error_flag = 1; # mark error
             }
        }
        elsif ( $$global_config_p{sftp_transport} eq "psftp" or $$global_config_p{sftp_transport} eq "sftp" ) { # if using the openssh sftp program or psftp putty program (windows)
            my $sftp_transport = $$global_config_p{sftp_transport};
            my $special_error_flag = sftp_external_commands($from_file, $to_file, "get", $global_config_p);
            if ( $special_error_flag != 0 ) { # if get failed
                $error_flag = 1; # mark error
                # write the error message into the script error file, psftp command not available
                write_file_log($global_config_p, "Error : unable to download the backup file into the sftp server, because the $sftp_transport command is not available", $log_body_p) if ( $special_error_flag == 1 );
                # write the error message into the script error file, unable to create the batch command file
                write_file_log($global_config_p, "Error : unable to download the backup file into the sftp server, unable to create the sftp batch command file, it might be lack of permissions or lack of free space on the temporary dir", $log_body_p) if ( $special_error_flag == 2 ); 
                # write the error message into the script error file, ssh not online or username/passoword invalid
                write_file_log($global_config_p, "Error : unable to download the backup file into the sftp server, ssh/sftp server is not online or the username/password/passphrase combination is invalid", $log_body_p) if ( $special_error_flag == 3 );
                # write the error message into the script error file, unable to download the file
                write_file_log($global_config_p, "Error : unable to download the backup file into the sftp server, it might be lack of permissions, lack of free space or the sftp connection might have dropped", $log_body_p) if ( $special_error_flag == 4 );
            }
        }
    }
    elsif ( $$global_config_p{backup_working} eq "http-dav" ) { # http dav copy (HTTP::DAV)
        eval {
            if ( !$$network_connection_p->get( -url=>"$from_file", -to=>"$to_file" ) ) {
                write_file_log($global_config_p, "Error : unable to download the backup file from the http dav server into the temporary directory, it might be lack of permissions, lack of free space or the http dav connection might have dropped, the file is [ $from_file ]", $log_body_p); # write the error message into the script error file
                $error_flag = 1; # mark error
             }
        };
        if ($@) {
            write_file_log($global_config_p, "Error : unable to download the backup file from the http dav server into the temporary directory, because of a http dav server bug", $log_body_p); # write the error message into the script error file
            $error_flag = 1; # mark error
        }
    }
    elsif ( $$global_config_p{backup_working} eq "tape" ) { # tape backups
        $error_flag = 1; # mark error
    }

    unlink "$to_file" if $error_flag != 0; # erasing the backup file from the temporary directory if any error occured
    print "Function get_backup_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result
}


#
# Copy a file from a directory into another
# This function uses optimized code and file buffers in order to spare the machine
# CPU and increase the copy speed.
# It receives the source file path, the destiny file path and the read buffer size
# internally the write buffer size is 32 larger, example: read buffer = 4096 write
# buffer size is 131072 (128Kb).
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub copy_file {

    my $source_file = $_[0]; # path of the original file
    my $destiny_file = $_[1]; # path of the file copy
    my $read_buffer_size = $_[2]; # the read buffer, write buffer is always 32 times larger
    my $global_config_p = $_[3]; # pointer into the configuration
    print "Running the copy_file() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $error_flag = 0; # to mark errors

    # open the source file in read mode ( < )
    open(source_file_handle, "<$source_file") or $error_flag = 1;
    # open or create the log file in append > rewrite mode
    open(destiny_file_handle, ">$destiny_file") or $error_flag = 1;
    #lock the file for exclusive script use
    if ( $error_flag == 0 ) {
        flock (destiny_file_handle, LOCK_EX) or $error_flag = 1;
        binmode(source_file_handle); # Hack to make Win32 work
        binmode(destiny_file_handle); # Hack to make Win32 work
    }
    if ( $error_flag == 0 ) {
        my $counter = 0;
        my $read_buffer = "";
        my $write_buffer = ""; # 32 times larger, example: read_buffer = 4096 (4kb) write_buffer = 131072 (128Kb)
        my ($source_dev,$source_ino,$source_mode,$source_nlink,$source_uid,$source_gid,$source_rdev,$source_size,$source_atime,$source_present_mtime,$source_ctime,$source_blksize,$source_blocks) = stat("$source_file");
        my $file_position = 0;
        while ( $file_position < $source_size ) {
            $error_flag = sysseek source_file_handle,$file_position,0; # position (in bytes) the file pointer into the next step
            if ( ($read_buffer_size + $file_position) > $source_size ) { # detect if the buffer + the file position is overunning the total file size
                $read_buffer_size = $source_size - $file_position; # fix the buffer size to only the the last file bytes
            }
            $error_flag = sysread source_file_handle,$read_buffer,$read_buffer_size; # position (in bytes) the file pointer into the next step
            $write_buffer .= $read_buffer; # add the read buffer into the write buffer
            if ( $counter == 32 ) { # check if we need to write anything
                $error_flag = syswrite destiny_file_handle,$write_buffer; # write the new file using the write buffer string
                $write_buffer = (); # clear the write buffer
                $counter = 0; # reset the write counter
            }
            $file_position = $file_position + $read_buffer_size; # read the N buffer bytes at once
            $counter++;
            last if ( !(defined $error_flag) );
        }
        if ( defined $write_buffer and $write_buffer ne ""  ) { # check if we need to write any file left overs
            $error_flag = syswrite destiny_file_handle,$write_buffer; # write the new file using the write buffer string
        }
        # fix the error flag since it can have undef (if a error occured)
        if ( defined $error_flag ) {
            $error_flag = 0;
        }
        else {
            $error_flag = 1; # error flag had undef so mark error
        }
    }
    close (source_file_handle); # close the source file
    close (destiny_file_handle); # close the destiny file

    if ( $error_flag == 0 ) { # final test, if everything when correcly...
        my ($source_dev,$source_ino,$source_mode,$source_nlink,$source_uid,$source_gid,$source_rdev,$source_size,$source_atime,$source_present_mtime,$source_ctime,$source_blksize,$source_blocks) = stat("$source_file");
        my ($destiny_dev,$destiny_ino,$destiny_mode,$destiny_nlink,$destiny_uid,$destiny_gid,$destiny_rdev,$destiny_size,$destiny_atime,$destiny_present_mtime,$destiny_ctime,$destiny_blksize,$destiny_blocks) = stat("$destiny_file");
        if ( $source_size != $destiny_size ) {
            $error_flag = 1; # mark error source file size is different from the gerenrated copy
        }
    }

    unlink $destiny_file if ( $error_flag != 0 ); # erase new file if any error occured

    print "Function copy_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result of this operation

}


#
# Move a file from a directory into another
# This function first attemps to move the file by changing the name (rename),
# this is useful if the file is on the same file system, if this fails
# a copy (using the copy_file() function) and erase is done.
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub move_file {

    my $source_file = $_[0]; # path of the original file
    my $destiny_file = $_[1]; # path of the file copy
    my $read_buffer_size = $_[2]; # path of the file copy
    my $global_config_p = $_[3]; # pointer into the configuration
    print "Running the move_file() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $error_flag = 0; # to mark errors

    if ( !rename($source_file,$destiny_file)) { # first attempt to rename the file, this only works if moving in the same file system
        # failed rename, attempt to copy and erase the source file
        $error_flag = copy_file("$source_file", "$destiny_file", 16384, $global_config_p); # copy the source file into the destinty file, using 16Kb read buffer and 512Kb write buffer
        unlink $source_file if ( $error_flag == 0 ); # copy worked erase the source file
        if ( $error_flag == 0 and -f $source_file ) { # copy worked, do extra security and check if the source file is erased
            $error_flag = 1;
            unlink $destiny_file; # erase the destiny file, the "move" failed
        }
    }

    print "Function move_file() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;
}


#
# Create a entire directory stucture, example /tmp/auxiliar/more/path....
# This is used because the perl mkdir function can only create only level of directories... 
# example create /tmp/auxiliar/more/path if /tmp/auxiliar/more exists
# Will return: 0 ; 1
# Explain: 0 is success ; 1 is failure
sub make_directory {

    my $directory_path = $_[0]; # the path to create
    my $global_config_p = $_[1]; # configuration pointer
    print "Running the make_directory() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $mode = $_[2];
    $mode = 0777 if ( !defined($mode)); # default more
    my $error_flag = 0; # to mark errors
    # deal with the directory separator char
    my @directory_path_split;
    switch: {
        $$global_config_p{host_file_separator} eq '/' && do { # separator char is / (unix)
                            @directory_path_split = split(/\//, $directory_path);
                        };
        $$global_config_p{host_file_separator} eq '\\' && do { # separator char is \ (microsoft)
                            @directory_path_split = split(/\\/, $directory_path);
                        };
    }

    # flow on each directory and create the entire directory
    $directory_path = ""; # clear this to reuse
    foreach my $my_directory ( @directory_path_split ) {
        if ( $directory_path eq "" ) {
            if ( $$global_config_p{host_file_separator} eq '/' ) { # if running on Unix add the / to the start of the path
                $directory_path = "/$my_directory";
            }
            else {
                $directory_path = $my_directory; # if running on Windows
            }
        }
        else {
            $directory_path = $directory_path . $$global_config_p{host_file_separator} . $my_directory;
        }
        if ( (($directory_path =~ tr/\\//) != 0 or ($directory_path =~ tr/\///) != 0) and !-d ($directory_path) ) { # create the directory if this does not exists and if not on the first level / or d:\
            $error_flag = 1 if ( !mkdir($directory_path,$mode) );
        }
        last if $error_flag != 0; # exit on first error
    }

    print "Function make_directory() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Uncompress the backup file using any required external command
# PS: the compressed file is erased in the end (it should be a temporary file !!)
# Will return: 0 ; 1 ; 2 ;3 ; 4
# Explain: 0 is success ; 1/2/3 are failures
sub do_uncompress {

    my $compressed_file_filename = $_[0]; # the name of the backup file on the support file
    my $compressed_file_fpath = $_[1]; # the full path to the compressed backup file
    my $compressed_file_tar_fpath = $_[2]; # the full path to the special tar file... (example: if compressed_file_fpath = /backup/ola.tar.gz ; then compressed_file_tar_fpath = /tmp/ola.tar
    my $supp_backup_files_details_p = $_[3]; # pointer into the backup files details list, this will be used to update the restore info about the file and directories that where restored
    my $global_config_p = $_[4]; # configuration pointer
    print "Running the do_uncompress() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[5]; # pointer into the email body string
    my $error_flag = 0; # to mark errors
    my @uncompress_command; # to contain the external uncompress command
    my $null_device = $$global_config_p{host_null_device}; # the operating system null device
    my $my_perl_version = $]; # perl version
    my @restore_to_list; # the array will contain the list directories where the stuff is being restored, why ?
                         # because simplebackup will read the list of thing to restore from a given backup file (compressed_file) and
                         # make one restore per restore destination... example: (file backup file home.zip)... 
                         # restore sequence 1 /home/miguel -> /tmp ; restore sequence2 /home/carla/music.mp3 -> /home/test

    # first test check if the backup file exists do be decompress !
    if ( !-f $compressed_file_fpath ) {
        write_file_log($global_config_p, "Error : backup file [ $compressed_file_fpath ], does not exists, please check permissions and if the paths are valid", $log_body_p); # write the error message into the script error file
        print "Function do_uncompress() exit value is [ 1 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return 1; # return error unable to create the destiny directory

    }
    # load up the restore to list (this that contains the paths where to restore)
    for my $supp_backup_details_record ( keys %$supp_backup_files_details_p ) { # search the backup details list

        # Process the record (break fields, meta data, round up file sizes, etc
        # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $supp_backup_details_record); # split the record
        if ( $compress_backup_file_name eq $compressed_file_filename ) { # if the backup file is the one we want to restore
            my $found = "no";
            foreach my $path_to_restored ( @restore_to_list ) { # see if this path to restored was already defined
                if ( $path_to_restored eq $$supp_backup_files_details_p{$supp_backup_details_record} ) {
                    $found = "yes"; # this restore path was already added to the list
                    last; # no need to continue
                }
            }
            push (@restore_to_list, $$supp_backup_files_details_p{$supp_backup_details_record}) if ( $found eq "no" ); # add record if required
        }
    }
    @restore_to_list = sort @restore_to_list; # sort the list by paths

    # the full path to the text file that contains what to restore
    my $restore_list_file = get_filedir_name($$global_config_p{configuration_file_name}, $global_config_p);
    $restore_list_file = "$restore_list_file" . ".tmp"; # add the tmp extension
    $restore_list_file = rebuild_full_path("$$global_config_p{temporary_dir}", "$restore_list_file", $global_config_p); # rebuild the full path pointing into the path defined by temporary_dir

    # now restore the files and directories selected for the compress backup file by the user by restore to path
    foreach my $path_to_restored ( @restore_to_list ) {

        # create the directory where to restore if required
        if ( !(-d $path_to_restored) and !(-f $path_to_restored) ) {
            write_file_log($global_config_p, "Creating the destiny directory [ $path_to_restored ]", $log_body_p); # write the error message into the script error file
            if ( make_directory($path_to_restored, $global_config_p) != 0 ) { # attempt to create the destiny directory if none exists and if no file exists by that name/path
                write_file_log($global_config_p, "Error : unable to create the destiny directory [ $path_to_restored ], please check permissions and if the paths are valid", $log_body_p); # write the error message into the script error file
                print "Function do_uncompress() exit value is [ 2 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
                return 2; # return error unable to create the destiny directory
            }
        }
        if ( ! chdir "$path_to_restored" ) { # attempt to change into the destiny directory
            write_file_log($global_config_p, "Error : unable to change into the destiny directory [ $path_to_restored ], please check permissions and if the paths are valid", $log_body_p); # write the error message into the script error file
            print "Function do_uncompress() exit value is [ 3 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
            return 3; # return error unable to change into the destiny directory
        }

        # write a temporary file list, that is actualy passed into the archive command, this file only contains relative paths
        my $tmp_list_encoding =  $$global_config_p{restore_list_encoding}; # if user is not using the auto value then it's forcing a given enconding type
        if ( $tmp_list_encoding eq "auto" ) { # if user is using the auto value configure the type to use
            if ( $my_perl_version < 5.008000 or ( !($compressed_file_fpath =~ /\.rar+$/) and !($compressed_file_fpath =~ /\.7z+$/) ) or  ( $$global_config_p{host_os} eq "unix" and ($compressed_file_fpath =~ /\.rar+$/) ) ) {
                $tmp_list_encoding = "ascii"; # using ascii value because we are using a format that is not rar or 7z or we are  attempting to use rar under a unix
            }
            else {
                $tmp_list_encoding = "utf-8" if  ( ($compressed_file_fpath =~ /\.7z+$/) ); # use unicode 8 bits, utf-8 if using the 7z (7-ZIP format)
                $tmp_list_encoding = "utf16-le" if  ( ($compressed_file_fpath =~ /\.rar+$/) ); # use unicode 16 bits little ending if using the rar format
            }
        }
        if ( $tmp_list_encoding eq "ascii" ) {
            open(restore_list_file_handle, ">$restore_list_file") or $error_flag = -1;
        }
        elsif ( $tmp_list_encoding eq "utf-8" ) { # if using unicode 8 bits
            open(restore_list_file_handle, ">:raw:encoding(UTF-8):crlf:utf8", "$restore_list_file") or $error_flag = -1;
        }
        elsif ( $tmp_list_encoding eq "utf16-le" ) { # if using unicode 16 little ending
            open(restore_list_file_handle, ">:raw:encoding(UTF16-LE):crlf:utf8", "$restore_list_file") or $error_flag = -1;
        }
        if ( $error_flag == 0 ) {
            #lock the file for exclusive script use
            flock (restore_list_file_handle, LOCK_EX) or $error_flag = 1;
            if ( $tmp_list_encoding eq "utf16-le"  ) {
                print restore_list_file_handle "\x{FEFF}", or $error_flag = -1; # write the BOM, Byte Order Marker header to tell the unicode readers that this file is in little endinien
            }
            for my $supp_backup_details_record ( keys %$supp_backup_files_details_p ) { # search the backup details list

                if ( $$supp_backup_files_details_p{$supp_backup_details_record} eq $path_to_restored ) { # If it's the restore path that we want
                    # Process the record (break fields, meta data, round up file sizes, etc
                    # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                    my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $supp_backup_details_record); # split the record

                    if ( $compress_backup_file_name eq $compressed_file_filename ) { # if it's the backup compress file to restore
                        if ( $compressed_file_fpath =~ /\.zip+$/ ) { # zip archiver requires this
                            $data_relative_path .= "\\" if ( $data_size eq "dir" and $$global_config_p{host_os} ne "unix" ); # if it's a directory on windows
                            $data_relative_path .= "/" if ( $data_size eq "dir" and $$global_config_p{host_os} eq "unix" ); # if it's a directory on unix
                        }
                        print restore_list_file_handle "$data_relative_path\n", or $error_flag = 1; # write only the relative path
                    }
                }
                last if ( $error_flag != 0 ); # exit on first error
            }
            close(restore_list_file_handle); # close the file
            if ( $error_flag != 0 ) { # if there was a error or but the file contains no data, erase it
                write_file_log($global_config_p, "Error : creating the restore list file [ $restore_list_file ]", $log_body_p); # write the error message into the script error file
                unlink "$restore_list_file"; # erase the temporary file, since it's empty or damaged
            }
        }

        if ( $error_flag == 0 ) { # if all is well so far we have a text file with the list of things to restore created
            # create the apropriate external command uncompress command
            switch: {
                ( $compressed_file_fpath =~ /\.rar+$/ ) && do { # rar archiver
                                my $uncompressor = get_external_command("rar", $global_config_p);
                                if ( $$global_config_p{debug_level} ne "full" ) {
                                    # deal with Operating System dependend stuff and build the full bath into the backup file
                                    if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system, unix links are keeped has links
                                        @uncompress_command = ("$uncompressor", "x", "-o+", "-inul", "-isnd", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"", "$null_device");
                                    }
                                    else {# windows operating system
                                        @uncompress_command = ("$uncompressor", "x", "-o+", "-inul", "-isnd", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"", "$null_device");
                                    }
                                }
                                else { # using debug mode
                                    # deal with Operating System dependend stuff and build the full bath into the backup file
                                    if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system
                                        @uncompress_command = ("$uncompressor", "x", "-o+", "-isnd", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"");
                                    }
                                    else {# windows operating system
                                        @uncompress_command = ("$uncompressor", "x", "-o+", "-isnd", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"");
                                    }
                                }
                            };
                ( $compressed_file_fpath =~ /\.7z+$/ ) && do { # 7z (7-Zip) archiver
                                my $uncompressor = get_external_command("7z", $global_config_p);
                                if ( $$global_config_p{debug_level} ne "full" ) {
                                    # deal with Operating System dependend stuff and build the full bath into the backup file
                                    if ( $$global_config_p{host_os} eq "unix" ) { # unix operating system, unix links are keeped has links
                                        @uncompress_command = ("$uncompressor", "x", "-aoa", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"", "$null_device");
                                    }
                                    else {# windows operating system
                                        @uncompress_command = ("$uncompressor", "x", "-aoa", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"", "$null_device", ">nul");
                                    }
                                }
                                else { # using debug mode
                                    @uncompress_command = ("$uncompressor", "x", "-aoa", "\"$compressed_file_fpath\"", "@\"$restore_list_file\"");
                                }
                            };
                    ( $compressed_file_fpath =~ /\.zip+$/ ) && do { # zip info-zip archiver
                                my $uncompressor = get_external_command("unzip", $global_config_p);
                                # the info-zip unzip command does not allow using a text file with the restore list, so we will read this list manually and
                                # extract each file/directory one by one.... unzip command will be callled has many times has possible.
                                if ( $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                                    @uncompress_command = ("$uncompressor", "-o", "-q", "\"$compressed_file_fpath\"", "\"some file or directory on restore list\"", "$null_device");
                                }
                                else { # using debug mode
                                    @uncompress_command = ("$uncompressor", "-o", "-v", "\"$compressed_file_fpath\"", "\"some file or directory on restore list\"");
                                }
                                write_file_log($global_config_p, "Uncompressing the backup file using the command [ @uncompress_command ]", $log_body_p); # write the error message into the script error file
                                open(restore_list_file_handle, "<$restore_list_file") or $error_flag = 1;
                                if ( $error_flag == 0 ) {
                                    #lock the file for exclusive script use
                                    flock (restore_list_file_handle, LOCK_EX) or $error_flag = 1;
                                    # read the entire config file line by line
                                    while(<restore_list_file_handle>) {
                                        if ( $$global_config_p{debug_level} ne "full" ) { # not using debug mode
                                            @uncompress_command = ("$uncompressor", "-o", "-q", "\"$compressed_file_fpath\"", "\"$_\"", "$null_device");
                                        }
                                        else { # using debug mode
                                            @uncompress_command = ("$uncompressor", "-o", "-v", "\"$compressed_file_fpath\"", "\"$_\"");
                                        }
                                        last if ( $error_flag != 0 );
                                        # run the command
                                        system("@uncompress_command") == 0 or $error_flag = 3; # if we return 3 something failed
                                    }
                                }
                                close(restore_list_file_handle); # close the file
                            };
                    ( $compressed_file_fpath =~ /\.tar+$/ ) && do { # tar archiver
                                my $uncompressor = get_external_command("tar", $global_config_p);
                                if ( $$global_config_p{debug_level} ne "full" ) {
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @uncompress_command = ("$uncompressor", "-xpf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @uncompress_command = ("$uncompressor", "-xpf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"", "$null_device");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @uncompress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @uncompress_command = ("$uncompressor", "-xpf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"", "$null_device");
                                    }
                                }
                                else { # using debug mode
                                    if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                        @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"");
                                    }
                                    elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                        @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"");
                                    }
                                    elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                        @uncompress_command = ("need examples");
                                    }
                                    else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                        @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"");
                                    }
                                }
                            };
                    ( $compressed_file_fpath =~ /\.tar.Z+$/g or $compressed_file_fpath =~ /\.tar.gz+$/g or $compressed_file_fpath =~ /\.tar.bz2+$/g  ) && do { # tar archiver + some compressor
                                # if using not using a advanced tar
                                if ( $$global_config_p{backup_format_details} eq "tar.Z" or $$global_config_p{backup_format_details} eq "tar.gz" or $$global_config_p{backup_format_details} eq "tar.bz2" ) { # tar + bzip2 type of files
                                    # first build the uncompress command (to extract the compress/gzip/bzip2)
                                    if ( $compressed_file_fpath =~ /\.tar.Z+$/g ) { # tar + compress
                                        my $uncompressor = get_external_command("uncompress", $global_config_p);
                                        if ( $$global_config_p{debug_level} ne "full" ) {
                                            @uncompress_command = ("$uncompressor", "-c", "\"$compressed_file_fpath\"", ">", "\"$compressed_file_tar_fpath\"");
                                        }
                                        else {
                                            @uncompress_command = ("$uncompressor", "-vc", "\"$compressed_file_fpath\"", ">", "\"$compressed_file_tar_fpath\"");
                                        }
                                    }
                                    elsif ( $compressed_file_fpath =~ /\.tar.gz+$/g ) { # tar + gzip archivers
                                        my $uncompressor = get_external_command("gzip", $global_config_p);
                                        if ( $$global_config_p{debug_level} ne "full" ) {
                                            @uncompress_command = ("$uncompressor", "-dc", "\"$compressed_file_fpath\"", ">", "\"$compressed_file_tar_fpath\"");
                                        }
                                        else { # using debug mode
                                            @uncompress_command = ("$uncompressor", "-dvc", "\"$compressed_file_fpath\"", ">", "\"$compressed_file_tar_fpath\"");
                                        }
                                    }
                                    elsif ( $compressed_file_fpath =~ /\.tar.bz2+$/g ) { # tar + bzip2 archivers
                                        my $uncompressor = get_external_command("bzip2", $global_config_p);
                                        if ( $$global_config_p{debug_level} ne "full" ) {
                                            @uncompress_command = ("$uncompressor", "-dc", "\"$compressed_file_fpath\"", ">", "\"$compressed_file_tar_fpath\"");
                                        }
                                        else { # using debug mode
                                            @uncompress_command = ("$uncompressor", "-dvc", "\"$compressed_file_fpath\"", ">", "\"$compressed_file_tar_fpath\"");
                                        }
                                    }
                                    # now build the part that extracts from the tar
                                    my $uncompressor = get_external_command("tar", $global_config_p);
                                    my @uncompress_command_tar;
                                    if ( $$global_config_p{debug_level} ne "full" ) {
                                        if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                            @uncompress_command_tar = ("&&", "$uncompressor", "-xpf", "\"$compressed_file_tar_fpath\"", "-T", "\"$restore_list_file\"", "$null_device");
                                        }
                                        elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                            @uncompress_command_tar = ("&&", "$uncompressor", "-xpf", "\"$compressed_file_tar_fpath\"", "-L", "\"$restore_list_file\"", "$null_device");
                                        }
                                        elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                            @uncompress_command_tar = ("need examples");
                                        }
                                        else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                            @uncompress_command_tar = ("&&", "$uncompressor", "-xpf", "\"$compressed_file_tar_fpath\"", "-I", "\"$restore_list_file\"", "$null_device");
                                        }
                                    }
                                    else { # using debug mode
                                        if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                            @uncompress_command_tar = ("&&", "$uncompressor", "-xvpf", "\"$compressed_file_tar_fpath\"", "-T", "\"$restore_list_file\"");
                                        }
                                        elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                            @uncompress_command_tar = ("&&", "$uncompressor", "-xvpf", "\"$compressed_file_tar_fpath\"", "-L", "\"$restore_list_file\"");
                                        }
                                        elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                            @uncompress_command_tar = ("need examples");
                                        }
                                        else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                            @uncompress_command_tar = ("&&", "$uncompressor", "-xvpf", "\"$compressed_file_tar_fpath\"", "-I", "\"$restore_list_file\"");
                                        }
                                    }
                                    # now build the full extract command
                                    push(@uncompress_command, @uncompress_command_tar);
                                }
                                # if using a advanced tar
                                elsif ( $$global_config_p{backup_format_details} eq "advanced_tar.Z" or $$global_config_p{backup_format_details} eq "advanced_tar.gz" or $$global_config_p{backup_format_details} eq "advanced_tar.bz2" ) { # tar + bzip2 type of files
                                    my $uncompressor = get_external_command("tar", $global_config_p);
                                    if ( $$global_config_p{debug_level} ne "full" ) {
                                        if ( $compressed_file_fpath =~ /\.tar.Z+$/g ) { # tar + compress
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xpZf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"", "$null_device");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xpZf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"", "$null_device");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xpZf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"", "$null_device");
                                            }
                                        }
                                        elsif ( $compressed_file_fpath =~ /\.tar.gz+$/g ) { # tar + gzip
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xpzf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"", "$null_device");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xpzf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"", "$null_device");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xpzf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"", "$null_device");
                                            }
                                        }
                                        elsif ( $compressed_file_fpath =~ /\.tar.bz2+$/g ) { # tar + bzip2
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xpf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"", "--use-compress-program bzip2", "$null_device");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xpf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"", "--use-compress-program bzip2", "$null_device");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xpf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"", "--use-compress-program bzip2", "$null_device");
                                            }
                                        }
                                    }
                                    else { # using debug mode
                                        if ( $compressed_file_fpath =~ /\.tar+$/g ) { # tar
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"");
                                            }
                                        }
                                        elsif ( $compressed_file_fpath =~ /\.tar.Z+$/g ) { # tar + compress
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xvpZf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xvpZf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xvpZf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"");
                                            }
                                        }
                                        elsif ( $compressed_file_fpath =~ /\.tar.gz+$/g ) { # tar + gzip
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xvpzf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xvpzf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xvpzf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"");
                                            }
                                        }
                                        elsif ( $compressed_file_fpath =~ /\.tar.bz2+$/g ) { # tar + bzip2
                                            if ( lc($^O) =~ "linux" or lc($^O) =~ "mswin32" ) { # deal with different tar command  gnu tar uses -T (linux and windows) other generaly use -I
                                                @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-T", "\"$restore_list_file\"", "--use-compress-program bzip2");
                                            }
                                            elsif ( lc($^O) =~ "aix" ) { # aix accepts the -L argument
                                                @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-L", "\"$restore_list_file\"", "--use-compress-program bzip2");
                                            }
                                            elsif ( lc($^O) =~ "hpux" ) { # hp ux tar is wierd
                                                @uncompress_command = ("need examples");
                                            }
                                            else { # others (openbsd, freebsd, solaris, etc) accept the -I
                                                @uncompress_command = ("$uncompressor", "-xvpf", "\"$compressed_file_fpath\"", "-I", "\"$restore_list_file\"", "--use-compress-program bzip2");
                                            }
                                        }
                                    }
                                }
                       };
            }
        }
        if ( ( !($compressed_file_fpath =~ /\.zip+$/)) ) { # under zip uncompress is done a little (lines) upstairs
            write_file_log($global_config_p, "Uncompressing the backup file using the command [ @uncompress_command ]", $log_body_p); # write the error message into the script error file
            # run the command
            system("@uncompress_command") == 0 or $error_flag = 3; # if we return 3 something failed
            write_file_log($global_config_p, "Error : unable to uncompress the backup file, please check permissions and if the paths are valid", $log_body_p) if ( $error_flag == 3 ); # write the error message into the script error file
        }
    }
    unlink "$restore_list_file" if ( -f $restore_list_file ); # erase the temporary file, if it still exists

    print "Function do_uncompress() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the result

}


#
# Clear the cmdline/terminal/console screen using the cls or clear operating system command
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub clear_screen {

    my $global_config_p = $_[0]; # pointer into the configuration
    print "Running the clear_screen() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it

    if ( $$global_config_p{host_os} ne "unix" ) { # running under windows
        system("cls");
    }
    else { # running under a Unix operating system
        system("clear");
    }
}


#
# This function is responsible for creating the user restore menu (used in manual restored)
# and is also responsable for reading the user input and updating (without any major tests)
# into the restore configuration hash (%restore_config).
# One of the most important parameters is the menu_option that will configure what part
# of the menu to show.
# Please notice that this funcion works in rentry... meaning the user chouses the menu
# option the function returns the option and finish... then the same function must be
# rerunned passing the new option.
# Will return: a string
# Explain: a string that defined what was the last option the user choicen.... example
#          we started with menu_option = "go_main" / main menu... and the user chouse
#          the option go_start_session / configure the start session number
sub restore_menu {

    my $menu_option = $_[0]; # what is the menu and options selected in the format.... go_something option1 option2 option3...etc
    my $script_version_int = $_[1]; # script version
    my $last_update_int = $_[2]; # script last update date
    my $restore_config_p = $_[3]; # pointer into the restore configuration
    my $supp_backup_files_p = $_[4]; # pointer into backup file (that contain the list of backup files generated)
    my $supp_backup_files_details_p = $_[5]; # pointer into backup file details (that contain the restore list)
    my $supp_full_list_p = $_[6]; # pointer into full file list (that contain a list of all files and directories that exited on the backup locations on each backup session) even if they were not backuped
    my $supp_general_p = $_[7];  # pointer into the general information inside the support file
    my $backup_host_os = $_[8]; # type of operating system that did the backup
    my $global_config_p = $_[9]; # pointer into the configuration
    print "Running the restore_menu() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[10]; # pointer into the email body string
    my $my_option = ""; # this will contain the user input, read from the keyboard

    switch: {
#
# go_main
#
            ( $menu_option eq "go_main" ) && do { # start main menu / manual restore
    print <<EOF;
* Simplebackup.pl v$script_version_int * Main Restore Options *

    1. Restore list (what to restore).
    2. Restore into list (where to restore).

    3. Large group selections.
    4. Restore into (default value).
    5. Session number (usually not required).
    6. Erase extra (be careful).

    i. Generic informations
    a. About simplebackup.
    l. List the backup sessions
    d. List the data inside a given backup session

    s. Start the restore.
    q. Quit (exit program).

EOF
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "go_main";
    }
    #define where to navigate next
    $menu_option = "go_restore_list 1" if ($my_option eq "1");
    $menu_option = "go_restore_into_list 1" if ($my_option eq "2");
    $menu_option = "go_large_selections" if ($my_option eq "3");
    $menu_option = "go_default_restore_into 0" if ($my_option eq "4");
    $menu_option = "go_session" if ($my_option eq "5");
    $menu_option = "go_erase_extra" if ($my_option eq "6");
    $menu_option = "go_generic_informations" if ($my_option eq "i");
    $menu_option = "go_about 1" if ($my_option eq "a");
    $menu_option = "go_list_backup_sessions 1" if ($my_option eq "l");
    $menu_option = "go_list_data_session 0 0" if ($my_option eq "d");
    $menu_option = "go_start_restore" if ($my_option eq "s");
    $menu_option = "go_quit" if ($my_option eq "q");
    return $menu_option; # exit function
            };
#
# go_restore_list
#
           ( $menu_option =~ /go_restore_list/ ) && do { # start restore list, what to restore
    my ($menu_option, $start_on) = split ( / /, $menu_option); # get the number where to start the restore list
    my $screen_list_count = $$global_config_p{screen_height} - 20; # number of entries show on screen (number of screen lines minus the number already used by the menu + options)
    my $counter = 1;
    my $found = "x"; # by default we mark that the file is not selected
    print <<EOF;
* Simplebackup.pl v$script_version_int * Restore List *

 Type in the number of the file/directory to select/unselect what to restore.

 [ * ] is selected for restore and [ x ] is not selected.

EOF
    for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
        if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {

            if ( $counter >= $start_on and $counter < $start_on+$screen_list_count) { # only enter if we need to print something on the screen
                if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "dont_restore" ) {
                    $found = "*"; # file is selected to be restored
                }
                else {
                    $found = "x"; # file is not selected to be restored
                }
                # split the detail record
                # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                # Get the backup file meta data
                my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
                # rebuild the full path into the file
                my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
                print " $counter. $found $data_filedir_fpath\n"; # write the line, this describes to the user what is selected or not
            }
            last if ($counter > $start_on+$screen_list_count); # we are over the limit exit imediatly no need to waste more time
            $counter++;
        }
    }
    print "\n";
    print " n. Next $screen_list_count records on restore list.\n" if ( $counter > $start_on+$screen_list_count ); # there is at least one more entry now showed on screen
    print " b. Back $screen_list_count records on restore list.\n" if ( $start_on > $screen_list_count ); # there is something to return
    print " r. Return to main menu.\n\n";
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    if ( $my_option =~ /^\d+$/ ) { # user typed a number... atempt to select/desect
        my $search_counter = 1;
        for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
            if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {

                if ( $search_counter == $my_option ) { # change the record wanted by the user
                    if ( $$supp_backup_files_details_p{$backup_files_details_record} eq "dont_restore" ) {
                        # ask for a restore path
                        # split the detail record
                        # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                        # Get the backup file meta data
                        my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
                        # rebuild the full path into the file
                        my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                        $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
                        $data_start_path = $$restore_config_p{to} if ( $$restore_config_p{to} ne "" );
                        my $tmp_value = "";
                        while ( $tmp_value eq "" ) {
                            clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
                            print <<EOF;
* Simplebackup.pl v$script_version_int * Add Restore Path *

 Please type in the full path where to restore or press enter to accept the
 default value.

 Selected file is [ $data_filedir_fpath ]
 Default value is [ $data_start_path ]

EOF
                            print ">> ";
                            $tmp_value = <STDIN>;
                            if ( defined $tmp_value ) {
                                chop $tmp_value; # remove the new line char
                            }
                            else {
                                $tmp_value = "";
                            }
                            if ( $tmp_value eq "" ) { # add the default value if required
                                $tmp_value = $data_start_path;
                            }
                            $tmp_value =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                            $tmp_value =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                            if ( check_if_full_path($tmp_value, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                                print "[ Error ], restore path is not a full path\n";
                                print "\nPress enter to continue ";
                                <STDIN>;
                                $tmp_value = "";
                            }
                        }
                        $$supp_backup_files_details_p{$backup_files_details_record} = $tmp_value;
                    }
                    else { # user want's to deselect
                        $$supp_backup_files_details_p{$backup_files_details_record} = "dont_restore";
                    }
                    last; # no need to wast more time
                }
                $search_counter++;
            }
        }
    }
    $menu_option = "go_restore_list $start_on"; # if any user uses a valid/invalid input we remain where we are
    #define where to navigate next
    $menu_option = "go_main" if ($my_option eq "r");
    $menu_option = "go_restore_list " . ($start_on+$screen_list_count) if ($my_option eq "n" and $counter >= $start_on+$screen_list_count ); # next
    $menu_option = "go_restore_list " . ($start_on-$screen_list_count) if ($my_option eq "b" and $start_on > $screen_list_count); # less
    return $menu_option; # exit function
            };
#
# go_restore_into_list
#
           ( $menu_option =~ /go_restore_into_list/ ) && do { # start restore into list, where to restore
    my ($menu_option, $start_on) = split ( / /, $menu_option); # get the number where to start the restore list
    my $screen_list_count = $$global_config_p{screen_height} - 20; # number of entries show on screen (number of screen lines minus the number already used by the menu + options)
    my $counter = 1;

    print <<EOF;
* Simplebackup.pl v$script_version_int * Restore Into List *

 Type in the number of the file/directory to change where to restore.

EOF
    for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
        if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" and $$supp_backup_files_details_p{$backup_files_details_record} ne "dont_restore"  ) {

            if ( $counter >= $start_on and $counter < $start_on+$screen_list_count) { # only enter if we need to print something on the screen
                # split the detail record
                # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                # Get the backup file meta data
                my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
                # rebuild the full path into the file
                my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
                print " $counter. $data_filedir_fpath -> " . $$supp_backup_files_details_p{$backup_files_details_record} . "\n"; # write the line, this describes to the user what is selected or not
            }
            last if ($counter > $start_on+$screen_list_count); # we are over the limit exit imediatly no need to waste more time
            $counter++;
        }
    }
    print "\n";
    print " n. Next $screen_list_count records on restore list.\n" if ( $counter > $start_on+$screen_list_count ); # there is at least one more entry now showed on screen
    print " b. Back $screen_list_count records on restore list.\n" if ( $start_on > $screen_list_count ); # there is something to return
    print " r. Return to main menu.\n\n";
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    if ( $my_option =~ /^\d+$/ ) { # user typed a number... atempt to select/desect
        my $search_counter = 1;
        for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
            if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {

                if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "dont_restore" and $search_counter == $my_option ) { # change the record wanted by the user
                    # ask for a restore path
                    # split the detail record
                    # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                    my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                    # Get the backup file meta data
                    my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
                    # rebuild the full path into the file
                    my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                    $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
                    $data_start_path = $$supp_backup_files_details_p{$backup_files_details_record};

                    my $tmp_value = "";
                    while ( $tmp_value eq "" ) {
                        clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
                        print <<EOF;
* Simplebackup.pl v$script_version_int * Change Restore Path *

 Type in the full path where to restore or press enter to keep the current
 value.

 Selected file is [ $data_filedir_fpath ]
 Current value is [ $data_start_path ]

EOF
                        print ">> ";
                        $tmp_value = <STDIN>;
                        if ( defined $tmp_value ) {
                            chop $tmp_value; # remove the new line char
                        }
                        else {
                            $tmp_value = "";
                        }
                        if ( $tmp_value eq "" ) { # add the default value if required
                            $tmp_value = $data_start_path;
                        }
                        $tmp_value =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                        $tmp_value =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                        if ( check_if_full_path($tmp_value, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                            print "[ Error ], restore path is not a full path\n";
                            print "\nPress enter to continue ";
                            <STDIN>;
                            $tmp_value = "";
                        }
                    }
                    $$supp_backup_files_details_p{$backup_files_details_record} = $tmp_value;
                    last; # no need to wast more time
                }
                $search_counter++;
            }
        }
    }
    #define where to navigate next
    $menu_option = "go_restore_into_list $start_on"; # if any user uses invalid input we remain where we are
    $menu_option = "go_main" if ($my_option eq "r");
    $menu_option = "go_restore_into_list " . ($start_on+$screen_list_count) if ($my_option eq "n" and $counter >= $start_on+$screen_list_count ); # next
    $menu_option = "go_restore_into_list " . ($start_on-$screen_list_count) if ($my_option eq "b" and $start_on > $screen_list_count); # less
    return $menu_option; # exit function
            };
#
# go_large_selections
#
           ( $menu_option =~ "go_large_selections" ) && do { # start restore session
    my ($menu_option, $start_on, $selected_counter, $case_sensitive, $previous_menu_option ) = split ( / /, $menu_option); # get the number where to start the restore list
    if ( ! defined $case_sensitive ) {
         $case_sensitive = "yes"; # by default it's case sensitive
         $case_sensitive = "no" if ( $backup_host_os ne "unix" );
    }
    my $case_sensitive_txt = "your wild card will be case sensitive";
    $case_sensitive_txt = "your wild card will not be case sensitive" if ( $case_sensitive eq "no" );
    my $main_selected_txt = "";
    $main_selected_txt = "\n $selected_counter files/directories where selected to be restored\n" if ( defined $previous_menu_option and $previous_menu_option eq "a" and $selected_counter >= 0 ); #text to report the number of affected files/directories selected to be restored
    $main_selected_txt = "\n $selected_counter files/directories where unselected from the restore list\n" if ( defined $previous_menu_option and $previous_menu_option eq "d" and $selected_counter >= 0 ); #text to report the number of affected files/directories selected to be restored
    if ( !defined $start_on or $start_on eq "c" or $start_on eq "a" or $start_on eq "r") { # inicial wild card menus
        print <<EOF;
* Simplebackup.pl v$script_version_int * Large group selections *

 Here you can make large selections of files and directories to be (or not)
 restored.
 Notice: $case_sensitive_txt

 c. change case sensitive mode

 a. mark all files and directories to be restored
 d. remove all files and directories from restore list (nothing to restore)

 m. mark files and directories to be restored (using wild cards)
 u. unmark files and directories from the restore list (using wild cards)
$main_selected_txt
 r. Return to main menu.

EOF
        print ">> ";
        $my_option = <STDIN>; # read the user input
        if ( defined $my_option ) {
            chop $my_option; # remove the new line char
            $my_option = lc $my_option; # lower case the user option
        }
        else {
            $my_option = "";
        }
        if ( $my_option eq "c" ) { # user wants to change the case sensitive mode
            if ( $case_sensitive eq "yes" ) {
                $case_sensitive = "no";
            }
            else {
                $case_sensitive = "yes";
            }
        }
        elsif ( $my_option eq "a" or $my_option eq "d") { # user wants to select or deselect all files and directories
            my $tmp_restore_into = "";
            if ( $my_option eq "a" ) { # if adding files, then must define the path where to restore them
                while ( $tmp_restore_into eq "" ) {
                        clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
                        print <<EOF;
* Simplebackup.pl v$script_version_int * Add Restore Path *

 Please type in the full path where to restore.

 Selected wild card(s) [ * ]

EOF
                    print ">> ";
                    $tmp_restore_into = <STDIN>;
                    if ( defined $tmp_restore_into ) {
                        chop $tmp_restore_into; # remove the new line char
                    }
                    else {
                        $tmp_restore_into = "";
                    }
                    $tmp_restore_into =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                    $tmp_restore_into =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                    if ( check_if_full_path($tmp_restore_into, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                        print "[ Error ], restore path is not a full path\n";
                        print "\nPress enter to continue ";
                        <STDIN>;
                        $tmp_restore_into = "";
                    }
                }
            }
            else { # if deleting
                $tmp_restore_into = "dont_restore";
            }
            $selected_counter = 0; # reset this to the next run
            for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
                if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {
                    # split the detail record
                    # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                    my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                    # rebuild the full path into the file
                    my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                    $data_filedir_fpath = lc($data_filedir_fpath) if ( $case_sensitive eq "no" ); # if user want selection not to be case sensitive
                    $selected_counter++; # add one more to the selected file list
                    $$supp_backup_files_details_p{$backup_files_details_record} = $tmp_restore_into;
                }
            }
        }
        #define where to navigate next
        $menu_option = "go_main" if ($my_option eq "r");
        $menu_option = "go_large_selections c -1 $case_sensitive" if ($my_option eq "" or $my_option eq "c");
        $menu_option = "go_large_selections a $selected_counter $case_sensitive a" if ($my_option eq "a");
        $menu_option = "go_large_selections r $selected_counter $case_sensitive d" if ($my_option eq "d");
        $menu_option = "go_large_selections m -1 $case_sensitive" if ($my_option eq "m");
        $menu_option = "go_large_selections u -1 $case_sensitive" if ($my_option eq "u");
    }
    elsif ( $start_on eq "m" ) { # mark files and directories to select for restore
        my $selected_counter_txt = "";
        $selected_counter_txt = "\n $selected_counter files/directories where selected to be restored\n" if ( $selected_counter >= 0 ); #text to report the number of affected files/directories selected to be restored
        print <<EOF;
* Simplebackup.pl v$script_version_int * Large group selections *

 Type in your wild card combination to select files and directories to be
 restored, you can type a single wild card selection or a combination of
 several wild cards separated by the < char.
 Notice: $case_sensitive_txt
 Examples: *.mp3
           c:\*.txt
           /home/migas
           *.mp3 < c:\*.txt
           /home/carla/*.MPG < /home/carla/*.mpg < /home/migas
$selected_counter_txt
 r. Return to the previous menu

EOF
        print ">> ";
        my $user_restore_into;
        $my_option = <STDIN>; # read the user input
        if ( defined $my_option ) {
            chop $my_option; # remove the new line char
            $my_option = lc $my_option if ( lc $my_option eq "r" or $case_sensitive eq "no" ); # lower case the user option if required (r or if user want it not to be case sensitive)
            if ( $my_option ne "" and $my_option ne "r" ) { # if user is not wanting to return to the previous menu
                my $tmp_restore_into = "";
                while ( $tmp_restore_into eq "" ) {
                    clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
                    print <<EOF;
* Simplebackup.pl v$script_version_int * Add Restore Path *

 Please type in the full path where to restore.

 Selected wild card(s) [ $my_option ]

EOF
                    print ">> ";
                    $tmp_restore_into = <STDIN>;
                    if ( defined $tmp_restore_into ) {
                        chop $tmp_restore_into; # remove the new line char
                    }
                    else {
                        $tmp_restore_into = "";
                    }
                    $tmp_restore_into =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                    $tmp_restore_into =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                    if ( check_if_full_path($tmp_restore_into, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                        print "[ Error ], restore path is not a full path\n";
                        print "\nPress enter to continue ";
                        <STDIN>;
                        $tmp_restore_into = "";
                    }
                }
                # transforme the user wild cards into something perl can understand
                $my_option = prepare_perl_wildcards($my_option, $global_config_p);
                # read the restore list file to see if anything matches up
                my @wild_cards_array = split(/</,  $my_option); # real all rejections
                $selected_counter = 0; # reset this to the next run
                for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
                    if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {
                        # split the detail record
                        # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                        # rebuild the full path into the file
                        my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                        $data_filedir_fpath = lc($data_filedir_fpath) if ( $case_sensitive eq "no" ); # if user want selection not to be case sensitive
                        # now match up the full path to the file / dir with the user wild cards
                        foreach my $single_wild_card ( @wild_cards_array ) {
                            if ( "$data_filedir_fpath" =~ $single_wild_card ) {
                                $selected_counter++; # add one more to the selected file list
                                $$supp_backup_files_details_p{$backup_files_details_record} = $tmp_restore_into;
                                last; # found one entry leave immediatly, no need to waste time
                            }
                        }
                    }
                }
            }
        }
        else {
            $my_option = "m";
        }
        #define where to navigate next
        $menu_option = "go_large_selections" if ($my_option eq "r");
        $menu_option = "go_large_selections m $selected_counter $case_sensitive" if ($my_option ne "r");
    }
    elsif ( $start_on eq "u" ) { # mark files and directories to not to be restored
        my $selected_counter_txt = "";
        $selected_counter_txt = "\n $selected_counter files/directories where unselected from the restore list\n" if ( $selected_counter >= 0 ); #text to report the number of affected files/directories selected to be restored
        print <<EOF;
* Simplebackup.pl v$script_version_int * Wild cards Selections*

 Type in your wild card combination to unselect files and directories from
 the restore list, you can type a single wild card selection or a combination
 of several wild cards separated by the < char.
 Notice: $case_sensitive_txt
 Examples: *.mp3
           c:\*.txt
           /home/migas
           *.mp3 < c:\*.txt
           /home/carla/*.MPG < /home/carla/*.mpg < /home/migas
$selected_counter_txt
 r. Return to the previous menu

EOF
        print ">> ";
        my $user_restore_into;
        $my_option = <STDIN>; # read the user input
        if ( defined $my_option ) {
            chop $my_option; # remove the new line char
            $my_option = lc $my_option if ( lc $my_option eq "r" or $case_sensitive eq "no" ); # lower case the user option if required (r or if user want it not to be case sensitive)
            if ( $my_option ne "" and $my_option ne "r" ) { # if user is not wanting to return to the previous menu
                # transforme the user wild cards into something perl can understand
                $my_option = prepare_perl_wildcards($my_option, $global_config_p);
                # read the restore list file to see if anything matches up
                my @wild_cards_array = split(/</,  $my_option); # real all rejections
                $selected_counter = 0; # reset this to the next run
                for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
                    if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {
                        # split the detail record
                        # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                        # rebuild the full path into the file
                        my $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p);
                        $data_filedir_fpath = lc($data_filedir_fpath) if ( $case_sensitive eq "no" ); # if user want selection not to be case sensitive
                        # now match up the full path to the file / dir with the user wild cards
                        foreach my $single_wild_card ( @wild_cards_array ) {
                            if ( "$data_filedir_fpath" =~ $single_wild_card ) {
                                $selected_counter++; # add one more to the selected file list
                                $$supp_backup_files_details_p{$backup_files_details_record} = "dont_restore";
                                last; # found one entry leave immediatly, no need to waste time
                            }
                        }
                    }
                }
            }
        }
        else {
            $my_option = "u";
        }
        #define where to navigate next
        $menu_option = "go_large_selections" if ($my_option eq "r");
        $menu_option = "go_large_selections u $selected_counter $case_sensitive" if ($my_option ne "r");
    }

    return $menu_option; # exit function
           };
#
# go_default_restore_into
#
           ( $menu_option =~ "go_default_restore_into" ) && do { # default restore into path
               my ($trash, $selected_counter ) = split (/ /, $menu_option);
               my $default_restore_into = "Original Location";
               $default_restore_into = $$restore_config_p{to} if ( $$restore_config_p{to} ne "" );
               my $selected_counter_txt = "";
               $selected_counter_txt = "\n $selected_counter files/directories changed the restored path\n" if ( $selected_counter > 0 ); #text to report the number of affected files/directories selected to be restored

    print <<EOF;
* Simplebackup.pl v$script_version_int * Default Restore Into *

 Here you can select what is the default path where the files and directories
 will be restored.
 Notice that configuring this does not mean that the files and directories
 can only be restored to this path.
 $selected_counter_txt
 Default path [ $default_restore_into ]

 r. Return to main menu.

EOF
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option if ( lc($my_option) eq "r" or $backup_host_os ne "unix" ) ; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    if ( $my_option ne "r" ) {
        $my_option =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
        $my_option =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
        if ( check_if_full_path($my_option, $$global_config_p{host_os}, $global_config_p) != 0 ) {
            print "[ Error ], default path path is not a full path\n";
            print "\nPress enter to continue ";
            <STDIN>;

        }
        else { # is full path, update the main configuration hash
            $$restore_config_p{to} = $my_option;
            my $tmp_value = "";
            while ( $tmp_value ne "y" and $tmp_value ne "n" and $tmp_value ne "r" ) {
                print "Change default path to all data on restore list [y/n] ?\n";
                print ">> ";
                $tmp_value = <STDIN>;
                if ( defined $tmp_value ) {
                    chop $tmp_value; # remove the new line char
                    $tmp_value = lc($tmp_value);
                }
                else {
                    $tmp_value = "";
                }
            }
            if ( $tmp_value eq "y" ) { # user wants all files and dirs to be restored into a given location
                $selected_counter = 0; # reset this to the next run
                for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list
                    if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "dont_restore" and $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {
                        $$supp_backup_files_details_p{$backup_files_details_record} = $$restore_config_p{to};
                        $selected_counter++;
                    }
                }
            }
        }
        $menu_option = "go_default_restore_into $selected_counter";
    }
    #define where to navigate next
    $menu_option = "go_main" if ($my_option eq "r");

    return $menu_option; # exit function
           };
#
# go_session
#
           ( $menu_option eq "go_session" ) && do { # start restore session

               my $session = $$restore_config_p{session};
               $session = "not defined" if ( $session eq "" );
    print <<EOF;
* Simplebackup.pl v$script_version_int * Restore Session *

 Here you can select the session number to take has a reference so only
 files and directories that existed on that backup session will be restored.
 This can be combined with option number 6 (Erase Extra).

 Every time a backup is made a ever larger session number is generated.
 Example: [ music.150 full monday 11-07-2005 crc1971881625.zip ], the 150
 is the backup session number of this backup file. In the process it also
 makes a list of every file and directory existing in the backup list, even
 if it was not backuped on that backup session.

 Current session number [ $session ]

 r. Return to main menu.

EOF
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    #define where to navigate next
    $menu_option = "go_main" if ($my_option eq "r");
    if ( ($my_option =~ /^\d+$/) ) { # if the user type a valid intenger number
        if ( $my_option ne $session ) {
            my $tmp_value = "";
            while ( $tmp_value eq "" ) {
                clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
                print <<EOF;
* Simplebackup.pl v$script_version_int * Change Restore Session*

 This will rebuild the restore list, any previous selections and changes
 will be lost.
 Really change the restore session ?
 
 y. Yes.
 n. No.

EOF
                print ">> ";
                $tmp_value = <STDIN>;
                if ( defined $tmp_value ) {
                    chop $tmp_value; # remove the new line char
                    $tmp_value = lc($tmp_value);
                }
                else {
                    $tmp_value = "";
                }
                $tmp_value = "" if ( $tmp_value ne "y" and $tmp_value ne "n" ); 
                $tmp_value =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                $tmp_value =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.

            }
            if ( $tmp_value eq "y" ) {
                $$restore_config_p{session} = $my_option;
                print "Rebuilding restore list (please wait)...\n";
                if ( build_restore_list("stout", $supp_backup_files_details_p, $supp_full_list_p, $restore_config_p, $backup_host_os, 0, $global_config_p, $log_body_p) > 2 ) {
                    $menu_option = "go_exit_program";
                }
            }
        }
    }
    return $menu_option; # exit function

            };
#
# go_erase_extra
#
           ( $menu_option eq "go_erase_extra" ) && do { # end restore session
               my $tmp_value;
               if ( $$restore_config_p{session} ne "" ) {
                   my $erase_extra = $$restore_config_p{erase_extra};
                   my $session = $$restore_config_p{session};
                   print <<EOF;
* Simplebackup.pl v$script_version_int * Erase Extra *

 Erase (or not) files and directories that didn't existed during the backup
 session defined in option number 5 Session number.

 Warning !!! please be careful with this since it can cause data lost.

 Current value [ $erase_extra ]
 Current session number [ $session ]

  y. Yes.
  n. No.
  r. Return to main menu.

EOF
                    print ">> ";
                    $tmp_value = <STDIN>;
                    if ( defined $tmp_value ) {
                        chop $tmp_value; # remove the new line char
                        $tmp_value = lc($tmp_value);
                    }
                    else {
                        $tmp_value = "";
                    }
                    $$restore_config_p{erase_extra} = "yes" if ( $tmp_value eq "y" );
                    $$restore_config_p{erase_extra} = "no" if ( $tmp_value eq "n" );
               }
               else {
                   print <<EOF;
* Simplebackup.pl v$script_version_int * Erase Extra *

 To use this option you must define a session number, please check 
 option number 5 Session number.

 r. Return to main menu.

EOF
                    print ">> ";
                    $tmp_value = <STDIN>;
                    if ( defined $tmp_value ) {
                        chop $tmp_value; # remove the new line char
                        $tmp_value = lc($tmp_value);
                    }
                    else {
                        $tmp_value = "";
                    }
               }
               
    $menu_option = "go_main" if ( $tmp_value eq "r" );
    return $menu_option; # exit function
            };
#
# go_generic_informations
#
           ( $menu_option eq "go_generic_informations" ) && do { # start restore session
               my $last_backup_date = $$supp_general_p{session_date};
               $last_backup_date = "Never backuped" if ( $last_backup_date eq "never_backuped" );
               my $autosync_date_txt = "last one was " . $$supp_general_p{autosync_date} .  " by user " . $$supp_general_p{last_restore_username};
               $autosync_date_txt = "Never Restored" if ( $$supp_general_p{autosync_date} eq "never_restored" );
               my $last_restore_txt = "last one was " . $$supp_general_p{last_restore_date} .  " by user " . $$supp_general_p{last_restore_username};
               $last_restore_txt = "Never Restored" if ( $$supp_general_p{last_restore_date} eq "never_restored" );
               my $total_restored = 0;
               my $total_restored_size = 0;
               my $total_backuped = 0;
               my $total_backuped_size = 0;
               print "Computing total backup data...\n";
               for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # search the restore list to look for the total restored files/dirs
                   if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "ignore" ) {
                       # split the detail record
                       # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                       my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                       if ( $$supp_backup_files_details_p{$backup_files_details_record} ne "dont_restore" ) {
                           $total_restored++;
                           $total_restored_size = $total_restored_size + $data_size if ( $data_size ne "dir" );
                       }
                       $total_backuped++;
                       $total_backuped_size = $total_backuped_size + $data_size if ( $data_size ne "dir" );
                   }
               }
               clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
               my $total_restored_size_kbytes = sprintf("%.2f",$total_restored_size/1024); # 1024 bytes = 1 Kbyte
               my $total_restored_size_mbytes = sprintf("%.2f",$total_restored_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
               my $total_backuped_size_kbytes = sprintf("%.2f",$total_backuped_size/1024); # 1024 bytes = 1 Kbyte
               my $total_backuped_size_mbytes = sprintf("%.2f",$total_backuped_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
            print <<EOF;
* Simplebackup.pl v$script_version_int * Generic Informations *

 Selected for restore...
  files & directories : $total_restored
  size (uncompressed) : $total_restored_size_mbytes Mbytes / $total_restored_size_kbytes Kbytes

 Backups (last one was $last_backup_date by user $$supp_general_p{backup_username})...
  machine name .......: $$supp_general_p{backup_os_name}
  machine type .......: $$supp_general_p{backup_host_os} ($$supp_general_p{backup_real_host_os})
  backup working in ..: $$supp_general_p{backup_working}
  backup mode ........: $$supp_general_p{backup_mode}
  session number .....: $$supp_general_p{current_session} (support file write counter $$supp_general_p{write_counter})
  files & directories : $total_backuped
  size (uncompressed) : $total_backuped_size_mbytes Mbytes / $total_backuped_size_kbytes Kbytes

EOF
 print " Restores ($last_restore_txt)...\n";
     if ( $last_restore_txt ne "Never Restored" ) {
         print "  number of restores .: $$supp_general_p{restore_count}\n";
         if ( $autosync_date_txt ne "Never Restored" ) {
           print <<EOF;

 Last autosync restore ($autosync_date_txt)...
  session number .....: $$supp_general_p{autosync_session}
EOF
       }
     }
 print "\n r. Return to main menu.\n";


    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    #define where to navigate next
    $menu_option = "go_main" if ($my_option eq "r");
    return $menu_option; # exit function

            };
#
# go_about
#
           ( $menu_option =~ "go_about" ) && do { # About simplebackup
    my ($menu_option, $start_on) = split ( / /, $menu_option); # get the number where to start the restore list
    my $screen_list_count = $$global_config_p{screen_height} -8; # number of entries show on screen (number of screen lines minus the number already used by the menu + options)
    my $counter = 1;
        # load up the about text into a array (this is done to make it easy to alter it in the future)
        my $about_text = join ("\n", <<EOF ); #

 Name ...: simplebackup version v$script_version_int ($last_update_int)
 License : $script_license
 Author .: $script_authors
 E-Mail .: $script_email
 Site ...: $script_site

 Simplebackup is a cross platform backup program and aims to work in the same
 simple manner under all supported operating systems.
 Because backups are boring things simplebackup can work fully unattended in
 all his operations (backups and restores) all it requires is a bit of work
 when installing and configuring the backup settings, after that it just
 works.
 Backups are done in standard compressed files with support for several
 popular formats (rar, zip, 7z, tar, tar+compress, tar+gzip, tar+bzip2).


 Simplebackup features :
  * Support for three backup modes: full, incremental and differential.
  * Restores can be made automatically or manually using text menus.
    [ improved in version 1.8.x ].
  * Can create syncing mechanisms across different systems, even unix to
    windows or windows to unix. [ improved in version 1.8.x ].
  * Support for several backup formats (rar, 7z, zip, tar, tar.Z, tar.gz,
    tar.bz2). [ improved in version 1.8.x ].
  * Can encrypt the backup data using a build in encryption algorithm, the
    SimpleCrypt algorithm.
  * The SimpleCrypt algorithm is also available has the separated simplecrypt
    program included in the simplebackup package. This program can be used to
    encrypt/decrypt any file desired.
  * Creates separate backup files for each backup directory or file on the
    backup list.
  * Can read the backup list from a separated text file.
  * Can read the restore list from a separated text file, even with the use
    of wild cards and with the definition of the restore path.
    [ new in version 1.8.x ].
  * Backups can be made on a type of system (example windows) and restored on
    a different type (example linux). [ new in version 1.8.x ].
  * Allows the selection of the compression ratio.
  * Can reject files and directories by full paths, even with the use of wild
    cards.
  * Can reject files by file type/extention.
  * Can reject files by full name.
  * Can reject files by size limit, example only backup files up to 1
    Megabyte.
  * Can limit the maximal size of the backup data, this can control the
    amount of data that will flow into the backup destination.
  * Can backup into ftp servers, and make use a ftp proxy (must be in open
    mode).
  * Can backup into ssh/sftp servers with or without the use of
    public/private keys. This backup mode uses ssh2 encryption so it's very
    safe to use across the internet. [ new in version 1.8.x ].
  * Can backup into http web-dav servers. [ new in version 1.8.x ].
  * Can backup by email into one or more email accounts.
  * Under unix operating systems it can backup into tape devices, but beware
    that this feature is experimental.
  * Also related to tape devices, it can execute any command desired before
    and after writing to tape, example mt -t /dev/tape0 rewind.
  * Works fully unattended, so you can easily program a at/cron job (unix) or
    task scheduler (windows).
  * Automatic backup session management, old backup data can be automatically
    erased.
  * Can run a script/batch file/command before the backup, example, you can
    use this feature to shut-down the database and free the data files for
    backup.
  * Can run a script/batch file/command after the backup, again a example,
    you can use this feature to bring the database back on-line.
  * Can run a script/batch file/command before the restore, example, you can
    use this feature to shut-down the database and free the data files for
    restore.
  * Can run a script/batch file/command after the restore, again a example,
    you can use this feature to bring the database back on-line.
  * Can send backup reports by e-mail (using smtp mail servers only).
  * Very detailed log information. [ improved in version 1.8.x ].
  * Build in debug to help in the detection of possible bugs or problems.
  * Can export the backup reports into any external program(s) or command(s).
  * Can log all operations into a file that can be consulted latter.


 Thank you :
  * Kent Xu for reporting a bug on the restore algorithm and presenting a
    very accurate replication method of it and for reporting another bug
    related to sftp (secure ftp) support in unix systems.
  * Nick for reporting a bug and presenting a patch related to ftp support
    when using proftp servers. This type of servers fails to support the ftp
    size command if not working in binary mode.
  * Joseph Bacino for helping me test simplebackup.
  * Norman Uittenbogaart for his support and testing.
  * Eugene Roshal for his support and patience helping me fix a problem with
    the rar backups.
    Check out his rar archive program (http://www.rarlab.com) it's excellent,
    stable, can also create zip files, is supported by simplebackup and it's
    not very expensive.
  * Patrick, for reporting a problem with ftp support.
  * Jorge Gomes, for all is 100% support in my development and for being my
    friend.
  * Thomas Schwarz, for reporting a english bug and for being a nice guy to
    talk to.
  * Mikey, for reporting a bug that occurred under tape backups, the null
    device was being incorrectly added into the tape before backup and tape
    after backup procedures.
  * Uwe, for reporting a english bug :).
  * Davide Veneziano, for several test and tips, and for being a great
    guy to talk to.
  * Brandon Zehm <caspian\@dotconf.net>, for his email file attachment code
    that was adapted from his send_attachment() function in the SendEmail
    program (http://caspian.dotconf.net/menu/Software/SendEmail) into
    simplebackup in the function create_email_attachment(), and for being a
    great guy to talk to.
    By the way, if you have the time, check his email anti-spam system in
    http://www.dotclean.com it seams a very interesting project.
  * John, for reporting a bug on the input_backup configuration key that
    would a backup failure if simplebackup was using multi-directories or
    multi-files and space chars.
  * Huge thanks to Dr. A.M. Genaev (Alexandr), for reporting a bug and
    presenting a patch to the backup list coming from a external file.
  * Wolfgang Fleischmann wfl\@ebi.ac.uk, for his crc32 algorithm that was
    adapted from Swissknife library (crc32.pm module) into simplebackup in
    the function build_crc32().
  * Dave Edwards, for a excellent feature request, he requested that
    simplebackup add the hostname into the backup files, for several tests
    and for reporting a problem under simplebackup 1.5.0.
  * McLeod, for reporting a bug and presenting a patch in the mail
    authentication, this was a most excellent work ! thanks, and for
    presenting a true interest to improve the program.
  * Thomas, for a excellent feature request, he requested that simplebackup
    reported the size of the current backup session and of all backup
    sessions, both features where included in simplebackup 1.4.0.
  * lcdm, for reporting a bug in the zip format suppport that only occurs
    under unix operating systems.
  * Renato Leon, for several tests that help me fix a bug on the mail
    support, for pushing me to add tape support to simplebackup and for
    being a excellent guy to talk to.
  * Steve, for a excellent and patient testing.
  * Nelmar Alvarenga, for a good sugestion, for being a excellent tester
    and for being a great guy.
  * Alexandre Pereira, for several tests and suggestions, and for being my
    friend.
  * Goncalo Diniz Oliveira, for his help on general Unix support, and for
    being my friend.
  * Joo Santos, for his explanations on the old Windows 98, general
    Windows help, and for being my friend.
  * Nuno Muoz (Piri), for helping me test the ftp module, and for being my
    friend.
  * Carla Alexandra, the love of my life, for all her 100% support,
    friendship, love and affection :).
  * Finally to any person that has send me feedback positive or negative.
EOF
        # now break the text into a array, to be processed line by line
        my @about_text_array = split (/\n/, $about_text);
        print"* Simplebackup.pl v$script_version_int * About Simplebackup *\n\n";
        foreach my $about_line ( @about_text_array ) { # write the about text line by line
            if ( $counter >= $start_on and $counter < $start_on+$screen_list_count) { # only enter if we need to print something on the screen
                print "$about_line\n";
            }
            last if ($counter > $start_on+$screen_list_count); # we are over the limit exit imediatly no need to waste more time
            $counter++;
        }
    print "\n";
    print " n. Next $screen_list_count lines of the about simplebackup.\n" if ( $counter > $start_on+$screen_list_count ); # there is at least one more entry now showed on screen
    print " b. Back $screen_list_count lines of the about simplebackup.\n" if ( $start_on > $screen_list_count ); # there is something to return
    print " r. Return to main menu.\n\n";
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    #define where to navigate next
    $menu_option = "go_about $start_on"; # if any user uses invalid input we remain where we are
    $menu_option = "go_main" if ($my_option eq "r");
    $menu_option = "go_about " . ($start_on+$screen_list_count) if ($my_option eq "n" and $counter >= $start_on+$screen_list_count ); # next
    $menu_option = "go_about " . ($start_on-$screen_list_count) if ($my_option eq "b" and $start_on > $screen_list_count); # less
    return $menu_option; # exit function
            };
#
# go_list_backup_sessions
#
           ( $menu_option =~ "go_list_backup_sessions" ) && do { # List the backup files
    my ($menu_option, $start_on ) = split ( / /, $menu_option); # get the number where to start the restore list
    my $counter = 1;
    my $screen_list_count = $$global_config_p{screen_height} - 10; # number of entries show on screen (number of screen lines minus the number already used by the menu + options)
    my $hash_limit;
    $hash_limit = keys( %$supp_backup_files_p); # the size of the list
    print"* Simplebackup.pl v$script_version_int * List All Backup Files *\n\n";
    if ( $hash_limit > 0 ) { # if the support file exists and has data
        # now break the text into a array, to be processed line by line
        my @list_text_array = split (/\n/, list_backup_sessions("", $supp_backup_files_p, $supp_backup_files_details_p, $global_config_p));
        foreach my $list_line ( @list_text_array ) { # write the about text line by line
            if ( $counter >= $start_on and $counter < $start_on+$screen_list_count) { # only enter if we need to print something on the screen
                print "$list_line\n"; #
            }
            last if ($counter > $start_on+$screen_list_count); # we are over the limit exit imediatly no need to waste more time
            $counter++;
        }
    }
    else {
        print " There are no backup files available, nothing can be restored\n\n";
    }
    print "\n";
    print " n. Next $screen_list_count lines of the backup files list.\n" if ( $counter > $start_on+$screen_list_count ); # there is at least one more entry now showed on screen
    print " b. Back $screen_list_count lines of the backup files list.\n" if ( $start_on > $screen_list_count ); # there is something to return
    print " r. Return to main menu.\n\n";
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "r";
    }
    #define where to navigate next
    $menu_option = "go_list_backup_sessions $start_on"; # if any user uses invalid input we remain where we are
    $menu_option = "go_main" if ($my_option eq "r");
    $menu_option = "go_list_backup_sessions " . ($start_on+$screen_list_count) if ($my_option eq "n" and $counter >= $start_on+$screen_list_count ); # next
    $menu_option = "go_list_backup_sessions " . ($start_on-$screen_list_count) if ($my_option eq "b" and $start_on > $screen_list_count); # less
    return $menu_option; # exit function
           };
#
# go_list_data_session
#
           ( $menu_option =~ "go_list_data_session" ) && do { # List the backup files
    my ($menu_option, $session, $start_on) = split ( / /, $menu_option); # get the number where to start the restore list
    my $screen_list_count = $$global_config_p{screen_height} - 10; # number of entries show on screen (number of screen lines minus the number already used by the menu + options)
    my $counter = 1;

    if ( $session == 0 ) { # if we don't know what session to list
    print <<EOF;
* Simplebackup.pl v$script_version_int * List Backup Session *

 Type in the session number to detail.

 r. Return to main menu.

EOF
print ">> ";
        $my_option = <STDIN>; # read the user input
        if ( defined $my_option) {
            chop $my_option; # remove the new line char
            $my_option = lc $my_option; # lower case the user option
            if ( $my_option =~ /^\d+$/ ) {
                $menu_option = "go_list_data_session $my_option 1";
            }
            elsif ( $my_option ne "r" ) {
                $menu_option = "go_list_data_session 0 0"; # by default we remain where we are
            }
        }
        else {
            $my_option = "r";
        }
    }
    else { # we have a session now list it
        my $hash_limit;
        $hash_limit = keys( %$supp_backup_files_details_p); # the size of the list
        print"* Simplebackup.pl v$script_version_int * List Backup Session [ $session ] *\n\n";
        if ( $hash_limit > 0 ) { # if the support file exists and has data
            # now break the text into a array, to be processed line by line
            my @list_text_array = split (/\n/, list_backup_sessions($session, $supp_backup_files_p, $supp_backup_files_details_p, $global_config_p));
            foreach my $list_line ( @list_text_array ) { # write the about text line by line
                if ( $counter >= $start_on and $counter < $start_on+$screen_list_count) { # only enter if we need to print something on the screen
                    print "$list_line\n"; #
                }
                last if ($counter > $start_on+$screen_list_count); # we are over the limit exit imediatly no need to waste more time
                $counter++;
            }
        }
        else {
            print " There are no backup files available, nothing can be restored\n\n";
        }
        print "\n";
        print " n. Next $screen_list_count lines of the backup files list.\n" if ( $counter > $start_on+$screen_list_count ); # there is at least one more entry now showed on screen
        print " b. Back $screen_list_count lines of the backup files list.\n" if ( $start_on > $screen_list_count ); # there is something to return
        print " r. Return to the previous menu.\n\n";
        print ">> ";
        $my_option = <STDIN>; # read the user input
        if ( defined $my_option ) {
            chop $my_option; # remove the new line char
            $my_option = lc $my_option; # lower case the user option
        }
        else {
            $my_option = "r";
        }
        $menu_option = "go_list_data_session $session $start_on"; # if any user uses invalid input we remain where we are
        $menu_option = "go_list_data_session " . $session . " " . ($start_on+$screen_list_count) if ($my_option eq "n" and $counter >= $start_on+$screen_list_count ); # next
        $menu_option = "go_list_data_session " . $session . " " . ($start_on-$screen_list_count) if ($my_option eq "b" and $start_on > $screen_list_count); # less
    }
    #define where to navigate next
    
    $menu_option = "go_list_data_session 0 0" if ($my_option eq "r" and $session != 0 );
    $menu_option = "go_main" if ($my_option eq "r" and $session == 0 );
    return $menu_option; # exit function
           };
#
# go_start_restore
#
           ( $menu_option eq "go_start_restore" ) && do { # confirm if we want to start the restore

    print <<EOF;
* Simplebackup.pl v$script_version_int * Start Restore *

  This will start the restore using your restore configuration options.

  y. Yes, start the restore.
  n. No, don't start the restore.

EOF
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "n";
    }
    #define where to navigate next
    $menu_option = "go_restore" if ($my_option eq "y");
    $menu_option = "go_main" if ($my_option eq "n");
    return $menu_option; # exit function
            };
#
# go_quit
#
           ( $menu_option eq "go_quit" ) && do { # confirm if we want exit the program

    print <<EOF;
* Simplebackup.pl v$script_version_int * Quit *

  Really abort the restore and exit simplebackup ?

  y. Yes, exit simplebackup.
  n. No, don't exit simplebackup.

EOF
    print ">> ";
    $my_option = <STDIN>; # read the user input
    if ( defined $my_option ) {
        chop $my_option; # remove the new line char
        $my_option = lc $my_option; # lower case the user option
    }
    else {
        $my_option = "n"; 
    }
    #define where to navigate next
    if ($my_option eq "y") {
        print "Thank you for using simplebackup\n";
        $menu_option = "go_exit_program"
    }
    $menu_option = "go_main" if ($my_option eq "n");
    return $menu_option; # exit function

            };
    }

}


#
# Build or rebuild the restore list with restore path's, by changing the values on the backup files
# details hash into one of the following values (ignore : treat this like it does not exists ; 
# dont_restore : mark the record not to be restored but be showed on the restore menu ; some restore
# path: path where the file/directory will be restored.
# This is one of the biggests and complicated simplebackup functions because it takes in consideration
# many factors restore such has the restore mode (autosync) the restore list file usage, cross plantform
# restores (unix backup and windows restores or vise-versa)
# Will return: 0 ; 1 ; 2 ; 3 ; 4 ; 5
# Explain: 0 (is success all went ok) ; 1 (is sucess but we generated a empty restore list) ; 2 (is
#          sucess but we were trying to restore into invalid paths, using unix paths in windows or
#          vise-versa, in this cases the restore path is reseted into the defined temporary dir ;
#          3 (unable to read the restore list file) ; 4 (found mixed backup files that have the
#          same backup session and are available with full backups and other backup modes) ; 5 (found
#          a mix of files that has incremental and differencial backup modes).
sub build_restore_list {

    my $message_output = $_[0]; # where the message goes into (stdout ; log ; both)
    my $supp_backup_files_details_p = $_[1]; # pointer into the backup files details hash list
    my $supp_full_list_p = $_[2]; # pointer into the full file list hash
    my $restore_config_p = $_[3]; # pointer into the restore configuration
    my $backup_host_os = $_[4]; # Type of operating system that did the backup
    my $autosync_session = $_[5]; # Autosync session number (only available and used during autosync restore mode)
    my $global_config_p = $_[6]; # pointer into the configuration
    print "Running the build_restore_list() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $log_body_p = $_[7]; # pointer into the email body string
    my $start_session = 0;
    my $end_session = 0;
    my $error_flag = 0;# mark errors

    my $separator = "/"; # by default we run on Unix so the separator char for files and directories is /
    if ( $backup_host_os ne "unix" ) {
        $separator = "\\"; # if running on windows the separator char for files and directories is \
    }

    # load up the restore file list (if required)
    my %restore_file_list; # restore list file
    if ( $$restore_config_p{rlist_file} ne "" and -f $$restore_config_p{rlist_file} ) { # restore list file is defined and exists, so load it
        # open file in read mode ( < )
        open(restore_list_handle, "<$$restore_config_p{rlist_file}") or $error_flag = 3;
        if ( $error_flag == 0 ) {
            # read the entire config file line by line
            while(<restore_list_handle>) {
                # enter only if there char # is NOT on the begining of the line
                if ( not $_ =~ /^#/ ) {
                    my ( $restore_filedir, $restore_path ) = split ( /</, $_,2); # split the line
                    $restore_filedir =~ s/^\s+//;  # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                    $restore_filedir =~ s/\s+$//;  # Delete trailing whitespace same thing kind of but $ represents end of line.
                    $restore_path =~ s/^\s+// if ( defined $restore_path ); # Delete leading whitespace ^ is the first caracter  \s is space then // replace with nothing if there was /a/ then replace with a
                    $restore_path =~ s/\s+$// if ( defined $restore_path ); # Delete trailing whitespace same thing kind of but $ represents end of line
                    # Remove the last \ or / char
                    $restore_filedir =~ s/[\\\/]+$// if ( $restore_filedir ne "/" and ( (length($restore_filedir) != 3 and $backup_host_os ne "unix") or $backup_host_os eq "unix") );
                    $restore_filedir = lc($restore_filedir) if ( $backup_host_os ne "unix" ); # lower case the user selections if the backup was running under windows (case is not relevant)
                    # Deal with eventual usage of wildcards on the restore list file
                    $restore_filedir = prepare_perl_wildcards($restore_filedir, $global_config_p);
                    $restore_file_list{"$restore_filedir"} = $restore_path; # load the line, eventually adding the restore path (if defined)
                }
            }
            # close file
            close (restore_list_handle);
        }
    }

    if ( $error_flag == 0 ) { # continue if no error occured
        # try to determin what is the backup list start session and end session this is important for future usage
        my $backup_type_found; # used to keep the first
        for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # read the backup files list

            # we always clear the restore destination when building or rebuilding the backup list
            $$supp_backup_files_details_p{$backup_files_details_record} = ();
            # split the detail record
            # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
            my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
            # Get the backup file meta data
            my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));

            $backup_type_found = $file_type if ( !defined $backup_type_found and $file_type ne "full" );
            # If the the backup session number is greater user defined session (to take has a max referece), then don't do the backup
            if ( $$restore_config_p{session} eq "" or $file_session_number <= $$restore_config_p{session} ) {
                if ( $file_type eq "full" and $start_session < $file_session_number ) {
                    $start_session = $file_session_number;
                    $end_session = $file_session_number if ( $end_session == 0 );
                }
                if ( $file_type ne "full" and $end_session < $file_session_number ) {
                    $end_session = $file_session_number; # update the end session
                }
                # now detect possible problems
                if ( $file_type ne "full" and $start_session == $file_session_number ) {
                    $error_flag = 4; # mark error, found mixed backup files that have the same backup session and are available with full backups and other backup modes
                }
                if ( $file_type ne "full" and defined $backup_type_found and $file_type ne $backup_type_found ) {
                    $error_flag = 5; # mark error, found a mix of files that has incremental and differencial backup modes
                }
            }
        }
        # update the end session if the user so want's it (--session 0 ) or if is running in autosync mode and if the user didn't force a sepecific session
        if ( $$restore_config_p{session} eq 0 or ($$restore_config_p{session} eq "" and $$restore_config_p{mode} eq "autosync") ) {
            $$restore_config_p{session} = $end_session;
        }
    }

    if ( $error_flag == 0 ) { # continue if no error occured

        # to improve performance (a lot on large backup sets with many backup selections), copy just the full list session that we want
        # into a hash... this hash  be used further down during file/dir session matching
        my %supp_full_list_session;
        if ( $$restore_config_p{session} ne "" ) {
            for my $full_list_record ( keys %$supp_full_list_p ) { # read the full list record
                my ($fl_record_type, $fl_record_session_number, $fl_data_start_path, $fl_data_relative_path, $fl_data_size  ) = split(/</, $full_list_record); # split the record
                # test only for the session wanted for the user
                if ( $fl_record_session_number == $$restore_config_p{session} ) {
                    my $fl_data_filedir_fpath = rebuild_full_path("$fl_data_start_path", "$fl_data_relative_path", $global_config_p, $separator); # rebuild the full path pointing into the path defined by temporary_dir
                    $fl_data_filedir_fpath = lc($fl_data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
                    $supp_full_list_session{$fl_data_filedir_fpath} = ();
                }
            }
        }

        my %full_path_hash; # this will be used to contain the full path into a given file and the session number... used to search for files to be ignored during restores
        for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # read the backup files list
            # split the detail record
            # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
            my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
            # Get the backup file meta data
            my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));

            # if simplebackup is working in autosync mode, and the file session number is under the last autosync session number... file will NOT be restored
            # because it is not relevant
            if ( $$restore_config_p{mode} eq "autosync" and $file_session_number <= $autosync_session ) {
                $$supp_backup_files_details_p{$backup_files_details_record} = "dont_restore"; # mark for NOT RESTORE
            }

            # If the the backup session number is greater than the max session (defined by the user), then don't do the backup
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} and $file_session_number > $end_session ) {
                $$supp_backup_files_details_p{$backup_files_details_record} = "ignore"; # mark for NOT RESTORE
            }

            # process and rebuild the full path into the file (if file/dir wasn't rejected already)
            my $data_filedir_fpath;
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p, $separator); # rebuild the full path pointing into the path defined by temporary_dir
                $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
            }

            # if file was not already ignored and if the user wants only to restore files/directories that existed on a spefic session
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} and $$restore_config_p{session} ne "" and !(exists $supp_full_list_session{$data_filedir_fpath}) ) {
                $$supp_backup_files_details_p{$backup_files_details_record} = "ignore"; # user is using a session number and this file/dir is not found on the corresponding session of the full list hash
            }

            # if the file was not already rejected continue
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                if ( !( ( ($file_type eq "full" or $file_type eq "incremental") and $file_session_number >= $start_session and $file_session_number <= $end_session) or ($file_type eq "differential" and $file_session_number == $end_session) ) ) {
                    # file session number is not bettwen the start session interval and the end sessio
                    $$supp_backup_files_details_p{$backup_files_details_record} = "ignore";
                }
                else { # the file was not yet ignored
                    # keep this for future compare
                    $full_path_hash{$data_filedir_fpath} = $file_session_number;
                }
            }

            # If using a restore list file, check if the file/directory exists on it, it not the file will NOT be restored
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} and $$restore_config_p{rlist_file} ne "" ) {
                # read the restore list file to see if anything matches up
                my $backup_full_path_rejections_found = "no";
                my $restore_file_list_key_found = "";
                for my $restore_file_list_record ( keys %restore_file_list ) {
                    if ( $data_filedir_fpath =~ /$restore_file_list_record/ ) {
                        $backup_full_path_rejections_found = "yes";
                        $restore_file_list_key_found = $restore_file_list_record;
                        last; # found one entry leave immediatly, no need to waste time
                    }
                    else { # deal with empty directories
                        my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                        if ( $data_size eq "dir" ) { # it's a empty directory
                            my $data_filedir_fpath_tmp = $data_filedir_fpath;
                            if ( $$global_config_p{host_os} ne "unix" ) { # add the directory char (\ or /)
                                $data_filedir_fpath_tmp .= "\\"; # if running on windows
                            }
                            else {
                                $data_filedir_fpath_tmp .= "/"; # if running on unix
                            }
                            if ( $data_filedir_fpath_tmp =~ /$restore_file_list_record/ ) { # now attempt to match up again (example c:\reject_this_empty_dir\ ) with ( example c:\reject_this_empty_dir\* )
                                $backup_full_path_rejections_found = "yes";
                                $restore_file_list_key_found = $restore_file_list_record;
                                last; # break and exit
                            }
                        }
                    }
                }
                $$supp_backup_files_details_p{$backup_files_details_record} = "dont_restore" if ( $backup_full_path_rejections_found ne "yes" )
            }
        }

        # Finally look into the restore list (present on the backup details has) created and remove repeated files and directories that make no
        # sense restoring... example... i will not want to restore the file /home/my_music.mp3 from the full backup session file 1 and again from
        # the incremental backup session file 2 i will only want to restore the file /home/my_music.mp3 from the most recent version... in this 
        # case from the backup file session 2
        my %supp_backup_files_details_hash;
        # First load up the backup file details temporary hash with the correct session number for each file
        for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # read the backup files list

            my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
            # process and rebuild the full path into the file (if file/dir wasn't rejected already)
            my $data_filedir_fpath;
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p, $separator); # rebuild the full path pointing into the path defined by temporary_dir
                $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
            }
            my ( $file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
            # if the record was not already ignored
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                # if what is keep is lower than the current or it does even exists
                $supp_backup_files_details_hash{$data_filedir_fpath} = $file_session_number if ( !(exists $supp_backup_files_details_hash{$data_filedir_fpath}) or $supp_backup_files_details_hash{$data_filedir_fpath} < $file_session_number );
            }
        }
        my $empty_restore_list = "yes"; # with this we will detect if the restore list is empty... (nothing to restore)
        for my $backup_files_details_record ( keys %$supp_backup_files_details_p ) { # read the backup files list

            my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
            # process and rebuild the full path into the file (if file/dir wasn't rejected already)
            my $data_filedir_fpath;
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                $data_filedir_fpath = rebuild_full_path("$data_start_path", "$data_relative_path", $global_config_p, $separator); # rebuild the full path pointing into the path defined by temporary_dir
                $data_filedir_fpath = lc($data_filedir_fpath) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
            }

            # if the record was not already ignored
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                # Get the backup file meta data
                my ( $file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($compress_backup_file_name, $global_config_p));
                # match up the present file session number with the keep session number, only newer are selected
                if ( $supp_backup_files_details_hash{$data_filedir_fpath} > $file_session_number ) {
                    $$supp_backup_files_details_p{$backup_files_details_record} = "ignore";
                }
            }
            # if in the end of all this the file was not rejected, configure the restore path
            if ( !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                $empty_restore_list = "no";
                my $restore_list_file_path; # if using a restore list file this can eventually defined if the restore path was defined on the restore list file
                # If using a restore list file, check if the file/directory exists on it, it not the file will NOT be restored
                if ( $$restore_config_p{rlist_file} ne "" and !defined $$supp_backup_files_details_p{$backup_files_details_record} ) {
                    # read the restore list file to see if anything matches up
                    for my $restore_file_list_record ( keys %restore_file_list ) {
                        $restore_file_list_record = lc($restore_file_list_record) if ( $backup_host_os ne "unix" ); # if running on a windows system then the paths are not case sensitive
                        my ( $restore_filedir, $restore_list_file_path_tmp ) = split ( /</, $restore_file_list_record,2); # split the line
                        if ( "$data_filedir_fpath" =~ $restore_filedir ) {
                            $restore_list_file_path = $restore_list_file_path_tmp;
                            last; # found one entry leave immediatly, no need to waste time
                        }
                    }
                }
                if ( defined $restore_list_file_path ) { # first priority... (if existing) restore path comes from restore list file
                    $$supp_backup_files_details_p{$backup_files_details_record} = $restore_list_file_path;
                }
                elsif ( $$restore_config_p{to} ne "" ) { # second priority... (if existing) restore path comes default restore path (--to)
                    $$supp_backup_files_details_p{$backup_files_details_record} = $$restore_config_p{to};
                }
                else { # last priority... restore path comes from the path where it was originally backuped
                    # deal with possible situations where the user backups on unix and restore on windows, or backups on windows
                    # and restore on unix
                    if ( $backup_host_os ne "unix" and substr($data_start_path,0,1) eq "/" ) { # change the unix root path / to the default c:\, example /home/migas into c:\home/migas
                        $data_start_path = "c:\\" . substr($data_start_path,1,length($data_start_path));
                    }
                    elsif ( $backup_host_os eq "unix" and substr($data_start_path,0,1) ne "/" ) { # change the windows path / to the default /, example c:\home\migas into /home\migas
                        $data_start_path = "/" . substr($data_start_path,3,length($data_start_path));
                    }
                    # convert separator char (if required)
                    if ( $$global_config_p{host_os} ne "unix") { # we are running on a microsoft system... convert / char into \
                        $data_start_path =~ tr/\//\\/; # example c:\home/migas into c:\home\migas
                    }
                    else { # we are running on a unix system... convert \ char into /
                        $data_start_path =~ tr/\\/\//; # example c:\home/migas into c:\home\migas
                    }
                    $$supp_backup_files_details_p{$backup_files_details_record} = $data_start_path; # restore into the original place where we did the backup
                }
                # check if we are restoring under a unix (/) or windows (\) and restoring into a invalid path unix (with \) and windows (with /)
                if ( check_if_full_path($$supp_backup_files_details_p{$backup_files_details_record}, $$global_config_p{host_os}, $global_config_p) != 0 ) {
                    $$supp_backup_files_details_p{$backup_files_details_record} = $$global_config_p{temporary_dir}; # reset the invalid path into the temporary dir
                    $error_flag = 2; #mark invalid restore paths are defined using a invalid path (unix paths on windows or windows paths on unix)
                }
            }
        }
        if ( $empty_restore_list eq "yes" ) {
            $error_flag = 1; # mark... empty restore list
        }
    }

    if ( $error_flag != 0 ) { # a error or warning was found, create the apropriate error or warning message
        my $error_message = "";
        switch: {
            $error_flag == 1 && do {
                                $error_message = "empty restore list";
                            };
            $error_flag == 2 && do {
                                $error_message = "some restore paths where invalid and where reseted to temporary dir";
                            };
            $error_flag == 3 && do {
                                $error_message = "unable to read the restore list file";
                            };
            $error_flag == 4 && do {
                                $error_message = "found conflictingly backup sessions";
                            };
            $error_flag == 5 && do {
                                $error_message = "found conflictingly backup modes";
                            };
        }

        # if defined to go into the log or both
        if ( defined $message_output and ( $message_output eq "log" or $message_output eq "both")  ) { # if writting error message into the log file
            my $log_error_message;
            if ( $error_flag <= 2 ) {
                $log_error_message = "Warning : " . $error_message;
            }
            else {
                $log_error_message = "Error : " . $error_message;
            }
            write_file_log($global_config_p, $log_error_message, $log_body_p); # write the message into the script error file
        }
        # if defined to go into the screen or both
        if ( defined $message_output and ($message_output eq "stdout" or $message_output eq "both") ) { # if printing into the console/terminal/cmdline
            my $screen_error_message;
            if ( $error_flag <= 2 ) {
                $screen_error_message = "[ Warning ], " . $error_message;
            }
            else {
                $screen_error_message = "[ Error ], " . $error_message;
            }
            print "\n$screen_error_message\n";
        }
    }

     print "Function build_restore_list() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
     return $error_flag;

}


#
# Since perl has limitations when erasing directories that are not empty (have files and/or sub-directories), this
# function will loop across the entiry directory structure erasing every file and directory it finds until it can
# erase the top directory.
#
# Why not use the standard perl module File::Path ?, because of two things first it would mean that the user would
# have to install and load yet another perl module and lastly because of the way the module works... acording
# to the File::Path manual when erasing directories "Files and directories which were not deleted may be left with
# permissions reset to allow world read and write access", to me this makes absolute no sense, why does it reset the
# permissions before erasing data ?
# Explain: 0 is success ; 1 failure
sub remove_directory {

    my $rm_directory = $_[0]; # directory to be erased
    my $error_flag = $_[1]; # mark the error log
    my $global_config_p = $_[2]; # pointer into the configuration

    if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ) { # print message if the debug level requires it
        print "Running the remove_directory() function\n";
        print "remove_directory() rmdir path: [ $rm_directory ]\n";
    }
    no warnings 'recursion'; # disable possible recursion warning messages from perl, this could append if you got a very deep directory list

    if ( $error_flag == 0 ) { # if no previous error occured continue
        my @filedir_list; # to contain the directory listing
        opendir(dir_handle, "$rm_directory") or $error_flag = 1; # open the load directory
        print "error reading directory [ $rm_directory ]\n" if ( $error_flag != 0 and defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") );
        @filedir_list = readdir dir_handle; # read the file list
        closedir(dir_handle);# close the directory handle
        if ( $error_flag == 0 ) { # continue if we manage to read the directory
            # if it's a empty directory
            if ( scalar (@filedir_list) == 2 ) {
                $error_flag = 1 if ( ! rmdir "$rm_directory" ); # erase the directory and detect any possible problems (lack of permissions etc)
                print "error erasing directory [ $rm_directory ]\n" if ( $error_flag != 0 and defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") );
            }
            else { # directory not empty.. boring... more work to do
                #
                # if it's a directory with files
                my $filedir_name_fpath;
                foreach my $filedir_name ( @filedir_list ) { # check the entiry directory list
                    if ( $filedir_name ne "." and $filedir_name ne ".." ) { # ignore the system file names . and ..
                        # rebuild the full path into the file or directory
                        $filedir_name_fpath = rebuild_full_path("$rm_directory", "$filedir_name", $global_config_p);
                        if ( -d "$filedir_name_fpath" and !-l "$filedir_name_fpath") { # if it's a directory and not a link, go all over again
                            $error_flag = remove_directory($filedir_name_fpath, $error_flag, $global_config_p);
                        }
                        else { # it's a file, erase it
                            unlink $filedir_name_fpath;
                            $error_flag = 1 if ( -f $filedir_name_fpath ); # if we failed to erase the file mark error
                            print "error erasing file [ $filedir_name_fpath ]\n" if ( $error_flag != 0 and defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") );
                        }
                    }
                }
                # cleared the directory, now erased it
                if ( $error_flag == 0 ) {
                    $error_flag = 1 if ( ! rmdir $rm_directory ); # erase the directory and detect any possible problems (lack of permissions etc)
                    print "error erasing directory [ $rm_directory ]\n" if ( $error_flag != 0 and defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") );
                }
            }
        }
    }

    print "Function remove_directory() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Receive a full path into a file, the full file list, and return yes (erase the file) or
# no for not erasing it
# Will return: yes ; no
# Explain: yes erase the file/dir ; no don't erase file/dir
sub check_if_erase {

    my $tested_filedir_name_fpath = $_[0]; # file or directory to be tested for erasing
    my $supp_full_list_p = $_[1]; # pointer into the full backup files hash list
    my $full_list_session = $_[2]; # pointer into the full backup files hash list
    my $to_path = $_[3]; # path where files where restored
    my $global_config_p = $_[4]; # pointer into the configuration
    my $error_flag = "yes"; # erase by default

    print "Running the check_if_erase() function\n" if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ); # print message if the debug level requires it
    my $tested_filedir_name_type = "file"; # will contain dir or file (if this is a file or directory), by default it's a file
    $tested_filedir_name_type = "dir" if ( -d "$tested_filedir_name_fpath" and !-l "$tested_filedir_name_fpath");

    # lower case this if restoring in windows (under windows file and directories names are case insesitive)
    $tested_filedir_name_fpath = lc($tested_filedir_name_fpath) if ( $$global_config_p{host_os} ne "unix" );

    for my $full_list_record ( keys %$supp_full_list_p ) { # read the full list record
        my ($record_type, $record_session_number, $data_start_path, $data_relative_path, $data_size ) = split(/</, $full_list_record); # split the record
        if ( $record_session_number == $full_list_session ) { # only process records belonging to this

            # convert separator char (if required)
            if ( $$global_config_p{host_os} ne "unix") { # we are running on a microsoft system... convert / char into \
                $data_relative_path =~ tr/\//\\/;
            }
            else { # we are running on a unix system... convert \ char into /
                $data_relative_path =~ tr/\\/\//;
            }
            # rebuild the full path into the file or directory
            my $rebuild_filedir_name_fpath = rebuild_full_path("$to_path", "$data_relative_path", $global_config_p);
            # lower case this if restoring in windows (under windows file and directories names are case insesitive)
            $rebuild_filedir_name_fpath = lc($rebuild_filedir_name_fpath) if ( $$global_config_p{host_os} ne "unix" );

            if ( $tested_filedir_name_fpath eq $rebuild_filedir_name_fpath and ( ($tested_filedir_name_type eq "dir" and $data_size eq "dir") or ($tested_filedir_name_type eq "file" and $data_size ne "dir") )  ) { # if file or directory is on the EXACT restore to path then it's not to be erased
                $error_flag = "no"; # mark file/dir not to be erased
                last; # found it no need to waste more time
            }
            if ( $tested_filedir_name_type eq "dir" ) { # if it's a directory and not a link test if there is any file or sub directory in the backup list with it (example testing d:\music and there is a file on the full list named d:\music\one.mp3)
                if ( index($rebuild_filedir_name_fpath, $tested_filedir_name_fpath) == 0 ) {
                    $error_flag = "no"; # mark dir not to be erased
                    last; # found it no need to waste more time
                }
            }
        }
    }

    print "Function check_if_erase() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Read the full list (list that contains the full list of files and directories found during the backup)
# and clear every file and directory on the restore into path that is not found in it.
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub clear_to {

    my $rm_directory = $_[0]; # directory to be tested for erasing
    my $supp_full_list_p = $_[1]; # pointer into the full backup files hash list
    my $restore_config_p = $_[2]; # pointer into the restore configuration (get the restore to path)
    my $error_flag = $_[3]; # mark the error log
    my $erased_counter_p = $_[4]; # counter that marks the total files and directories erased
    my $failed_erased_counter_p = $_[5]; # counter that marks the total files and directories that failed to be erased
    my $global_config_p = $_[6]; # pointer into the configuration
    my $log_body_p = $_[7]; # pointer into the email body string
    my $marked_file_dir_error = ""; # will contain the full path that failed to be erased

    if ( defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") ) { # print message if the debug level requires it
        print "Running the clear_to() function\n";
        print "clear_to() test path: [ $rm_directory ]\n";
    }
    no warnings 'recursion'; # disable possible recursion warning messages from perl, this could append if you got a very deep directory list

    if ( $error_flag == 0 ) { # if no previous error occured continue
        my @filedir_list; # to contain the directory listing
        opendir(dir_handle, "$rm_directory") or $error_flag = 2; # open the load directory
        print "error reading directory [ $rm_directory ]\n" if ( $error_flag != 0 and defined $$global_config_p{debug_level} and ($$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full") );
        $marked_file_dir_error = $rm_directory if ( $error_flag != 0 );
        @filedir_list = readdir dir_handle; # read the file list
        closedir(dir_handle);# close the directory handle
        if ( $error_flag == 0 ) { # continue if we manage to read the directory

            # if it's a empty directory
            if ( scalar (@filedir_list) == 2 ) {
                # erase the directory if not found on the full backup list
                $error_flag = remove_directory($rm_directory, 0, $global_config_p) if ( check_if_erase($rm_directory, $supp_full_list_p, $$restore_config_p{session}, $$restore_config_p{to}, $global_config_p) eq "yes" );
                $marked_file_dir_error = $rm_directory if ( $error_flag != 0 );
            }
            else { # directory not empty.. boring... more work to do
                #
                # if it's a directory with files
                my $filedir_name_fpath;
                foreach my $filedir_name ( @filedir_list ) { # check the entiry directory list
                    if ( $filedir_name ne "." and $filedir_name ne ".." ) { # ignore the system file names . and ..
                        # rebuild the full path into the file or directory
                        $filedir_name_fpath = rebuild_full_path("$rm_directory", "$filedir_name", $global_config_p);
                        # if it's marked to be erased
                        if ( check_if_erase($filedir_name_fpath, $supp_full_list_p, $$restore_config_p{session}, $$restore_config_p{to}, $global_config_p) eq "yes" ) {
                            if ( -d "$filedir_name_fpath" and !-l "$filedir_name_fpath") { # if it's a directory and not a link, go all over again
                                $error_flag = remove_directory($filedir_name_fpath, 0, $global_config_p);
                                if ( $error_flag == 0 ) {
                                    $$erased_counter_p++; # increase sucess counter
                                }
                                else {
                                    $$failed_erased_counter_p++; # increase failure counter
                                    $marked_file_dir_error = $filedir_name_fpath if ( $error_flag != 0 );
                                }
                            }
                            else { # it's a file
                                unlink $filedir_name_fpath;
                                $error_flag = 1 if ( -f $filedir_name_fpath ); # if we failed to erase the file mark error
                                if ( $error_flag == 0 ) {
                                    $$erased_counter_p++; # increase erase sucess counter
                                }
                                else {
                                    $$failed_erased_counter_p++; # increase erase failure counter
                                    $marked_file_dir_error = $filedir_name_fpath if ( $error_flag != 0 );
                                }                            }
                        }
                        elsif ( -d "$filedir_name_fpath" and !-l "$filedir_name_fpath") { # if it's not marked to be erased and if it's a directory go all over again
                            $error_flag = clear_to($filedir_name_fpath, $supp_full_list_p, $restore_config_p, $error_flag, $erased_counter_p, $failed_erased_counter_p, $global_config_p, $log_body_p);
                        }
                    }
                }
            }
        }
    }
    if ( $error_flag != 0 ) {
        if ( $error_flag == 1 ) { # failed to erase
            write_file_log($global_config_p, "Warning - possible lack of permissions, failed to erase [ $marked_file_dir_error ]", $log_body_p); # write the message into the script error file
        }
        else { # failed to open directory for listing
            write_file_log($global_config_p, "Warning - possible lack of permissions, failed to read directory [ $marked_file_dir_error ]", $log_body_p); # write the message into the script error file
        }
        $error_flag = 0; # unmark error to continue
        $marked_file_dir_error = ""; # clear error path
    }
    print "Function clear_to() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag;

}


#
# Do the actual restore, calling what ever auxiliary function's required
# Will return: 0 ; 1
# Explain: 0 is success ; 1 failure
sub do_restore {

    my $script_version_int = $_[0]; # script version
    my $last_update_int = $_[1]; # script last update date
    my $crypting_file_algorithm_version = $_[2]; # The version of the crypting algoritm the encrypted file will use,
                                                 # notice this might change during the decrypt operation (if the file
                                                 # was encrypted with a older version of the algorith)
    my $argv_p = $_[3]; # pointer into the command line arguments
    my $global_config_p = $_[4]; # pointer into the configuration
    print "Running the do_restore() function\n" if ( $$global_config_p{debug_level} eq "half" or $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    my $error_flag = 0; # to mark errors
    my $network_connection; # to keep the Net::FTP ; Net::SFTP ; HTTP::DAV connection object
    my $log_body = ""; # will contain all LOG MESSAGES and will be used (if configured)
                       # to send the full backup log via email
    my $machine_hostname = $$global_config_p{hostname}; # get the hostname
    my $my_username = $$global_config_p{username}; # get the username

    my $all_sessions_files_dir_number = 0; # the total files/directories that where restored
    my $backup_files_number = 0; # the total backup files used in restored
    my $all_sessions_files_size = 0; # the total size (in bytes) of the data that was restored
    my $backup_files_size = 0; # the total size of the backup files used
    my $my_perl_version = $];
    my $my_file_separator = $$global_config_p{host_file_separator}; # file separator
    my $backup_mode = $$global_config_p{backup_mode}; # the backup mode used
    my $restore_working = $$global_config_p{backup_working}; # how is the backup working, ftp, local file system, etc
    my $host_type = $$global_config_p{host_os}; # the configurated operating system.... unix...etc
    my $config_file = $$global_config_p{configuration_file}; # put it in order to easy put it inside a text string
    my $log_file = $$global_config_p{log_file}; # put it in order to easy put it inside a text string
    my $text_note = $$global_config_p{text_note}; # put it in order to easy put it inside a text string
    my $backup_format = $$global_config_p{backup_format}; # put it in order to easy put it inside a text string (rar zip etc)
    my %supp_managed_data; # the managed data that was read from the support file
    my %supp_new_managed_data; # the managed data that was created on this backup session
    my %supp_backup_files; # the list of the backup files available (read and written into the support file)
    my %supp_backup_files_details; # the detail of the list of the backup files available (read and written into the support file)
    my %supp_full_list; # the full list of all data on the backup set (read and written into the support file)
    my %supp_general = ( # Support file general configuration (other configuration parts)
        "write_counter"         => "", # Number of times that the file was written
        "current_session"       => "", # Current backuk session
        "session_date"          => "", #  The date when the last backup session occured
        "autosync_session"      => "", # The autosyunc session number that was read from the support file
        "autosync_date"         => "", #  The date when the last backup session occured in autosync mode
        "restore_count"         => "", # The number of times that the restore was used
        "last_restore_date"     => "", # The last time that the restore was used
        "last_restore_username" => "", # The name of the last user that did a restore
        "backup_mode"           => "", # Type of backup mode used (local directory, ftp, smtp, etc)
        "backup_host_os"        => "", # operating system that did the backup (has selected by simplebackup)
        "backup_real_host_os"   => "", # real operating system that did the backup (has reported by perl)
        "backup_os_name"        => "", # name of the operating system that did the last backup
        "backup_username"       => "", # name of the user that did the last backup
    );
    my $restore_list_status = 0; # if 0 list is generated with sucess ; 1 list is empty nothing to restore ; 2 restore list had some invalid restore paths ; any other is a error
    my %restore_config = ( # restore configuration hash
        "rlist_file"    => "",    # The list of files/directories to restore, this can come from command line parameters or from the backup configuration file (input_backup), ALWAYS REQUIRED
        "to"            => "",    # Where to restore the list of files/directories to restore, this can come from command line parameters or from the backup configuration file (input_backup), ALWAYS REQUIRED
        "session"       => "",    # The session that is the reference where restoring... restore will only take in consideration backups done until(including) this backup session, NOT REQUIRED
        "erase_extra"   => "",    # Erase files and directories not found on the session refered by the user on the --session ?... this is also automaticly enabled during autosync mode
        "mode"  => "",    # Restore mode (manual ; auto ; autosync)
    );

    if ( $restore_working eq "smtp" or $restore_working eq "tape" ) { # simplebackup cannot restore from email backups, because that would mean a lot more stuff to do... pop3 server... user/passwords... etc
        print "\n[ Error ], simplebackup is unable to restore from email/smtp backups,\nplease check the faq \"How to restore from email/smtp backups ?\" in\nthe readme.html/readme.txt file.\n" if $restore_working eq "smtp";
        print "\n[ Error ], simplebackup is unable to restore from tape a backup,\nplease check the faq \"How to restore from tape backups ?\" in\nthe readme.html/readme.txt file.\n" if $restore_working eq "tape";
        print "Function do_restore() exit value is [ 1 ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
        return 1;
    }

    # test the cmd line options and if correct load the restore configuratio hash
    if ( $error_flag == 0 and test_and_prepare_restore_config( "stout", $argv_p , \%restore_config, $global_config_p) != 0 ) {
        return 1; # invalid cmd line options
    }

    if ( $restore_config{mode} eq "manual" ) { # if running on manual mode

        if ( $error_flag == 0  ) { # if running on manual mode continue restore if we manage load the restore config
            # attempt to read the support file, errors and warnings are reported inside the read_write_support_file function
            print "\nWorking in manual restore mode\n";
            print "Reading the support file (please wait)...\n";
            my $special_error_flag = read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'read', 'screen_warnings', $global_config_p, \$log_body);
            if ( $special_error_flag != 0 ) {
                print "\n[ Error ], unable to read any valid copy of the support file\n" if ( $restore_config{mode} eq "manual" and  $special_error_flag > 1 );# write the message into screen
                print "\n[ Error ], no support file was available so nothing can be restored.\n           Did a backup ever occured ?\n" if ( $restore_config{mode} eq "manual" and $special_error_flag == 1 );# write the message into screen
                return 0; # exit program immediatly
            }
        }

        if ( $error_flag == 0 ) { # if running on manual mode continue restore if we manage to read the support file and load the restore config
            print "Building restore list (please wait)...\n" if ( $restore_config{mode} eq "manual" );
            $restore_list_status = build_restore_list("stdout", \%supp_backup_files_details, \%supp_full_list, \%restore_config, $supp_general{backup_host_os}, $supp_general{autosync_session}, $global_config_p, \$log_body);
            $error_flag = 1 if ( $restore_list_status > 2 ); # if the error code returned is over 2 then it's a real error
            # if no error occured and we are running in manual mode... show the restore menu
            if ( $error_flag == 0 and $restore_config{mode} eq "manual" ) {
                my $backup_option = "go_main";
                my @backup_files_list; # will contain the full backup list
                while ( $backup_option ne "go_restore" and $backup_option ne "go_exit_program") {
                    clear_screen($global_config_p); # clear the screen using the operating system command, perl has no such thing...
                    $backup_option = restore_menu($backup_option, $script_version_int, $last_update_int, \%restore_config, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, $supp_general{backup_host_os}, $global_config_p, \$log_body); # print the menu
                }
                return 0 if ( $backup_option eq "go_exit_program" ); # deal with situations where the user exited the program
            }
            return 1 if ( $error_flag != 0 ); # exit function if a error occured here
            $restore_list_status = 1; # mark by default empty restore list
            # rechech if the restore list is empty
            for my $backup_files_details_record ( keys %supp_backup_files_details ) { # read the backup files list
                if ( $supp_backup_files_details{$backup_files_details_record} ne "ignore" and $supp_backup_files_details{$backup_files_details_record} ne "dont_restore"  ) {
                    $restore_list_status = 0; # mark list is not empty
                    last; # no need to continue
                }
            }
        }
        # no error occured so continue, it any error occures before this nothing is written on the log 
        # start logging
        write_file_log($global_config_p, "Starting Restore ( simplebackup.pl v$script_version_int - $last_update_int )",\$log_body); # write the message into the script error file
        write_file_log($global_config_p, "$text_note",\$log_body) if $text_note ne ""; # write the message into the script error file
        write_file_log($global_config_p, "Running with perl $my_perl_version",\$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The machine running this restore is called [ $machine_hostname ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The user running this restore is called [ $my_username ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Using configuration file [ $config_file ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Using log file [ $log_file ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The configured restore mode is [ $backup_mode ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Restore is working in [ $restore_working ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Restore will be done considering data encryption",\$log_body) if ( $$global_config_p{encryption_passwd} ne "" ); # write the message into the script error file
        write_file_log($global_config_p, "Selected host operating system is [ $host_type ], detected is [ $^O ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The restore mode is [ " . $restore_config{mode} . " ]", \$log_body); # write the message into the script error file
        if ( $backup_format eq "rar" and $my_perl_version < 5.008000 ) { # for full restore security in rar format full unicode support is needed, perl 5.6.x has limited unicode support
            write_file_log($global_config_p, "Warning : simplebackup is running with perl $my_perl_version using the rar format, this can cause problems because the rar command requires unicode (UTF16-LE) support to deal with files and directories that have non english names, example a file name written in Portuguese. Restores can fail completely or even run with success but fail to restore some files, to be safe please update your perl or use another backup format. Full unicode support is present in perl 5.008000 (5.8.0) or over.", \$log_body); # write the message into the script error file
        }
        write_file_log($global_config_p, "The support file and the restore list where previously read and created",\$log_body) if ( $$global_config_p{encryption_passwd} ne "" ); # write the message into the script error file
    }
    else { # not running in manual mode

        # start logging
        write_file_log($global_config_p, "Starting Restore ( simplebackup.pl v$script_version_int - $last_update_int )",\$log_body); # write the message into the script error file
        write_file_log($global_config_p, "$text_note",\$log_body) if $text_note ne ""; # write the message into the script error file
        write_file_log($global_config_p, "Running with perl $my_perl_version",\$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Hostname is [ $machine_hostname ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The user running this restore is [ $my_username ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Using configuration file [ $config_file ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Using log file [ $log_file ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The configured restore mode is [ $backup_mode ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Restore is working in [ $restore_working ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "Restore will be done considering data encryption",\$log_body) if ( $$global_config_p{encryption_passwd} ne "" ); # write the message into the script error file
        write_file_log($global_config_p, "Selected host operating system is [ $host_type ], detected is [ $^O ]", \$log_body); # write the message into the script error file
        write_file_log($global_config_p, "The restore mode is [ " . $restore_config{mode} . " ]", \$log_body); # write the message into the script error file
        if ( $backup_format eq "rar" and $my_perl_version < 5.008000 ) { # for full restore security in rar format full unicode support is needed, perl 5.6.x has limited unicode support
            write_file_log($global_config_p, "Warning : simplebackup is running with perl $my_perl_version using the rar format, this can cause problems because the rar command requires unicode (UTF16-LE) support to deal with files and directories that have non english names, example a file name written in Portuguese. Restores can fail completely or even run with success but fail to restore some files, to be safe please update your perl or use another backup format. Full unicode support is present in perl 5.008000 (5.8.0) or over.", \$log_body); # write the message into the script error file
        }
        if ( $error_flag == 0  ) { # continue restore if we manage load the restore config
            # attempt to read the support file, errors and warnings are reported inside the read_write_support_file function
            write_file_log($global_config_p, "Reading the support file", \$log_body) if ( $restore_config{mode} eq "manual" ); # write the message into the script error file
            if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'read', 'warnings', $global_config_p, \$log_body) != 0 ) {
                write_file_log($global_config_p, "Error : unable to read any valid copy of the support file", \$log_body) if ( $restore_config{mode} ne "manual" );# write the message into the script error file
                $error_flag = 1; # mark error unable to read support file
            }
        }

        if ( $error_flag == 0 ) { # continue restore if we manage to read the support file and load the restore config
            write_file_log($global_config_p, "Building restore list", \$log_body); # write the message into the script error file
            $restore_list_status = build_restore_list("log", \%supp_backup_files_details, \%supp_full_list, \%restore_config, $supp_general{backup_host_os}, $supp_general{autosync_session}, $global_config_p, \$log_body);
            $error_flag = 1 if ( $restore_list_status > 2 ); # if the error code returned is over 2 then it's a real error
        }
    }

    write_file_log($global_config_p, "Nothing was selected to be restored (empty restore list), restore will not continue.",\$log_body) if ( $restore_list_status == 1); # write the message into the script error file
    if ( $error_flag == 0 and $restore_list_status != 1) { # it no error occured and the restore list is not empty

       print "\nRestoring (please wait)...\n" if ( $restore_config{mode} eq "manual" );
        # if there is a available the script/batch file/command declare by run_before_restore  RUN IT !
       if ( $error_flag == 0 and $$global_config_p{run_before_restore} ne "" ) {
           my $run_before_restore_command = $$global_config_p{run_before_restore};
           write_file_log($global_config_p, "Executing before restore procedure using the command [ $run_before_restore_command ]", \$log_body); # write the error message into the script error file
           system("$run_before_restore_command") == 0 or $error_flag = 1; # do restore procedure and if we return 1 something failed
           if ( $error_flag != 0 ) {
               if ( $$global_config_p{run_restore_on_failure_run_before_restore} ne "yes" ) { # check if user want's to continue restore even if the run before restore procedure fails
                   write_file_log($global_config_p, "Error : before restore procedure failed, restore will not continue", \$log_body); # write the error message into the script error file
               }
               else {
                   write_file_log($global_config_p, "Warning : before restore procedure failed, continuing restore", \$log_body); # write the error message into the script error file
                   $error_flag = 0; # reset error to continue restore
               }
           }
           sleep 60 if ( $error_flag == 0 ); # sleep for 60 seconds in order to make it saffer to do restore, in windows some processes (outlook) do not free thier files impediatly after ending
       }
        # test if the backup destination exists (if doing a restore from the local file system)
        if ( $$global_config_p{backup_working} eq "local file system" and (!-d $$global_config_p{output_backup} ) ) {
            $error_flag = 1; # mark directory does not exit
            write_file_log($global_config_p, "Error : Backup destination directory [ " . $$global_config_p{output_backup} . " ] does not exists or you do not have permissions to access it",\$log_body); # write the error message into the script error file
        }
        # test if the temporary directory exists
        if ( !-d $$global_config_p{temporary_dir} ) {
            $error_flag = 1; # mark directory does not exit
            write_file_log($global_config_p, "Error : temporary directory [ " . $$global_config_p{temporary_dir} . " ] does not exists or you do not have permissions to access it",\$log_body); # write the error message into the script error file
        }

        if ( $error_flag == 0 ) { # if no error occured continue

            my @restore_backup_files_list; # array list that will contain the list of the restore files, to be processed one by one (sorted by filename and session)
            for my $backup_files_details_record ( keys %supp_backup_files_details ) { # load up the list
                if ( $supp_backup_files_details{$backup_files_details_record} ne "ignore" and $supp_backup_files_details{$backup_files_details_record} ne "dont_restore"  ) {
                    # split the detail record
                    # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                    my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $backup_files_details_record); # split the record
                    my $found = "no";
                    foreach my $file ( @restore_backup_files_list ) { # now look to see if the backup file is already added into the restore backup_files list
                        if ( $compress_backup_file_name eq $file ) { # security check... confirm if the file is not already on the list
                            $found = "yes";
                            last; # found it no need to continue.
                        }
                    }
                    push (@restore_backup_files_list, $compress_backup_file_name) if ( $found eq "no" );
                }
            }

            @restore_backup_files_list = sort @restore_backup_files_list;

            my $meta_date = get_file_metadata_date($global_config_p); # get the date
            my $supp_restore_count_tmp = $supp_general{restore_count} + 1; # restore count, this is done here because this is the global value for the entire support file
            my $autosync_session_tmp = 0; # this will be used in autosyinc mode only
            foreach my $backup_filename ( @restore_backup_files_list ) { # process all backup files, in order to restore them

                print "Processing [ $backup_filename ]\n" if ( $restore_config{mode} eq "manual" );
                if ( $error_flag == 0 ) {
                    #
                    # Now build all the correct paths, dealing with operating system depend stuff, etc
                    #
                    my $backup_file_uncompress_fpath = ""; # the full path into the backup file that will be uncompress (decrypted if needed)
                    my $backup_file_uncompress_tar_fpath = ""; # the full path into the tar backup file that will be uncompress, this tar file is where intermediate
                                                               # tar formats will uncompress (example /home/ola.tar.gz -> /tmp/ola.tar)
                    my $backup_file_encrypted_fpath = ""; # the full path into the backup file that is encrypted, this only has a path if simplebackup is
                                                          # using encryption
                    my $backup_file_from_fpath = ""; # the full path where the original backup is... this might be equal to the path defined (and
                                                    # in this case there is no need to copy the file into the temporary path)
                                                    # by backup_file_uncompress_path or empty if restoring from a "wierd" system such has
                                                    # email backups (where there are no paths)
                    my $erase_backup_file_encrypted = "no"; # if this file shall be erased or not, default NO
                    my $erase_backup_file_uncompress = "no"; # if this file shall be erased or not, default NO

                    if ( $$global_config_p{backup_working} eq "local file system" ) { # if working in local file system
                        if ( !($backup_filename =~ /\.sc+$/) ) { # if not using encryption
                            $backup_file_uncompress_fpath = rebuild_full_path($$global_config_p{output_backup}, "$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory (exept when restoring from tar and not using tar advaced formats)
                            $backup_file_from_fpath = rebuild_full_path($$global_config_p{output_backup}, "$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory same has above
                        }
                        else { # if using encrytion
                            $backup_file_uncompress_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # file will be decrypted from the backup directory into the temporary directory
                            $backup_file_uncompress_fpath =~ s/.sc$//; # removing the [ .sc ] simplebackup encryption extension from the filename
                            $erase_backup_file_uncompress = "yes";
                            $backup_file_from_fpath = rebuild_full_path($$global_config_p{output_backup}, "$backup_filename", $global_config_p); # path where the encrypted file is
                            $backup_file_encrypted_fpath = $backup_file_from_fpath; # decryption is done directly from the encriton path into the file to uncompress has defined by backup_file_uncompress_fpath
                        }
                    }
                    elsif ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) { # if working in ftp/sftp/dav mode
                        $erase_backup_file_uncompress = "yes";
                        if ( !($backup_filename =~ /\.sc+$/) ) { # if not using encryption
                            $backup_file_uncompress_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory
                            if ( $$global_config_p{backup_working} eq "ftp" ) {
                                $backup_file_from_fpath = rebuild_full_path($$global_config_p{ftp_directory}, "$backup_filename", $global_config_p, "/"); # file will be uncompress directoly from the backup directory same has above
                            }
                            elsif ( $$global_config_p{backup_working} eq "sftp" ) {
                                $backup_file_from_fpath = rebuild_full_path($$global_config_p{sftp_directory}, "$backup_filename", $global_config_p, "/"); # file will be uncompress directoly from the backup directory same has above
                            }
                            elsif ( $$global_config_p{backup_working} eq "http-dav" ) {
                                $backup_file_from_fpath = rebuild_full_path($$global_config_p{dav_directory}, "$backup_filename", $global_config_p, "/"); # file will be uncompress directoly from the backup directory same has above
                            }
                        }
                        else { # if using encrytion
                            $erase_backup_file_encrypted = "yes";
                            $backup_file_uncompress_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory
                            $backup_file_uncompress_fpath =~ s/.sc$//; # removing the [ .sc ] simplebackup encryption extension from the filename
                            if ( $$global_config_p{backup_working} eq "ftp" ) {
                                $backup_file_from_fpath = rebuild_full_path($$global_config_p{ftp_directory}, "$backup_filename", $global_config_p, "/"); # file will be uncompress directoly from the backup directory same has above
                            }
                            elsif ( $$global_config_p{backup_working} eq "sftp" ) {
                                $backup_file_from_fpath = rebuild_full_path($$global_config_p{sftp_directory}, "$backup_filename", $global_config_p, "/"); # file will be uncompress directoly from the backup directory same has above
                            }
                            elsif ( $$global_config_p{backup_working} eq "http-dav" ) {
                                $backup_file_from_fpath = rebuild_full_path($$global_config_p{dav_directory}, "$backup_filename", $global_config_p, "/"); # file will be uncompress directoly from the backup directory same has above
                            }
                            $backup_file_encrypted_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # path to the encrypted file (on the temporary dir)
                        }
                    }
                    if ( $$global_config_p{backup_format_details} eq "tar.Z" ) { # using standard tar commands + compress format
                        $backup_file_uncompress_tar_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory
                        $backup_file_uncompress_tar_fpath =~ s/.tar.Z$/.tar/g;
                    }
                    elsif ( $$global_config_p{backup_format_details} eq "tar.gz" ) { # using standard tar commands + gzip
                        $backup_file_uncompress_tar_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory
                        $backup_file_uncompress_tar_fpath =~ s/.tar.gz$/.tar/g;
                    }
                    if ( $$global_config_p{backup_format_details} eq "tar.bz2" ) { # using standard tar commands + bzip2
                        $backup_file_uncompress_tar_fpath = rebuild_full_path($$global_config_p{temporary_dir}, "_tmp_$backup_filename", $global_config_p); # file will be uncompress directoly from the backup directory
                        $backup_file_uncompress_tar_fpath =~ s/.tar.bz2$/.tar/g;
                    }

                    if ( $$global_config_p{backup_working} eq "http-dav" ) { # now addd the url http path because we are restoring from a http server
                         # format is a full url: http://some_server:some_port/some_dir/some_file
                         $backup_file_from_fpath = $$global_config_p{dav_url} . $backup_file_from_fpath;
                    }

                    if ( ($backup_filename =~ /\.sc+$/) and $$global_config_p{encryption_passwd} eq "" ) {
                        write_file_log($global_config_p, "Error : encryption password is not defined, encrypted file cannot be restored, please check your configuration file", \$log_body); # write the error message into the script error file
                        $error_flag = 1; # mark error
                    }

                    if ( $error_flag == 0 and $$global_config_p{backup_working} ne "local file system" ) { # if not working on local file system mode, then we need to copy the backup file
                                                                                      # from the backup destination into the temporary directory
                        if ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) { # connect into the ftp/sftp server if required
                            if ( $$global_config_p{sftp_transport} ne "psftp" and $$global_config_p{sftp_transport} ne "sftp" ) { # if we are  using perl modules to ssh/sftp connection (web dav, ftp and ssh2 enter here)
                                my $network_type = $$global_config_p{backup_working};
                                write_file_log($global_config_p, "Connect and login into the $network_type server, for backup file download",\$log_body); # write the error message into the script error file
                                sleep 30; # sleep for 30 seconds in order to prevent a overkill of the ftp/sftp/dav server with a series of fast login and logoffs
                                if ( network_connect_login(\$network_connection, "Error", $global_config_p, \$log_body) != 0 ) {
                                    $error_flag = 1;
                                    write_file_log($global_config_p, "Error : $network_type server is not available, restore will not continue",\$log_body); # write the error message into the script error file
                                }
                            }
                        }
                        if ( $error_flag == 0 ) {
                            my $backup_file_to_fpath; # path where the file will be copied/downloaded
                            if ( !($backup_filename =~ /\.sc+$/) ) {
                                $backup_file_to_fpath = $backup_file_uncompress_fpath; # if not using encryption
                            }
                            else {
                                $backup_file_to_fpath = $backup_file_encrypted_fpath; # if using encryption
                            }
                            if ( $error_flag == 0 ) {
                                write_file_log($global_config_p, "Copying backup file [ $backup_file_from_fpath ] into [ $backup_file_to_fpath ]", \$log_body); # write the message into the script error file
                                if ( get_backup_file($backup_file_from_fpath, $backup_file_to_fpath, \$network_connection, $global_config_p, \$log_body) != 0 ) {
                                    $error_flag = 1; # mark error
                                    unlink $backup_file_to_fpath if ( -f $backup_file_to_fpath ); # erase the generated damaged file (if it still exists)
                                    write_file_log($global_config_p, "Unable to restore the file [ $backup_file_from_fpath ] ", \$log_body); # write the message into the script error file
                                }
                            }
                        }
                        if ( defined $network_connection and ( $$global_config_p{backup_working} eq "ftp" or $$global_config_p{backup_working} eq "sftp" or $$global_config_p{backup_working} eq "http-dav" ) ) { # disconnect the ftp server, if connected before
                            my $network_type = $$global_config_p{backup_working};
                            write_file_log($global_config_p, "Disconnecting from $network_type server", \$log_body); # write the error message into the script error file
                            if ( $$global_config_p{backup_working} eq "ftp" ) {
                                $network_connection->quit() if $network_connection; # disconnect from ftp server
                                $network_connection = undef;
                            }
                            elsif ( $$global_config_p{backup_working} eq "sftp" ) {
                                $network_connection = undef;
                            }
                            else {
                                $network_connection->unlock( -url => $$global_config_p{dav_url_full} );
                                $network_connection = undef;
                            }
                        }
                    }

                    if ( $error_flag == 0 and ($backup_filename =~ /\.sc+$/) ) { # if all is ok so far and encryption for this file is activated, decrypted
                       # decrypt the encrypted compress backup file
                       write_file_log($global_config_p, "Decrypting the backup file [ $backup_file_encrypted_fpath ] into [ $backup_file_uncompress_fpath ]", \$log_body); # write the error message into the script error file
                       if ( crypt_decrypt_file($backup_file_encrypted_fpath, $backup_file_uncompress_fpath, $$global_config_p{encryption_passwd}, "decrypt", $$global_config_p{encryption_file_read_size}, $$global_config_p{encryption_crypt}, $$global_config_p{encryption_level}, $crypting_file_algorithm_version, "no", "no", $global_config_p ) != 0 ) {
                           $error_flag = 1; # mark error
                           unlink $backup_file_uncompress_fpath if ( -f $backup_file_uncompress_fpath ); # erase the generated damaged file (if it still exists)
                           write_file_log($global_config_p, "Error : [ $backup_file_encrypted_fpath ], unable to decrypt the file, check permissions, free space, if the password is correct and if the crypting times number and level are correct", \$log_body) if ( $error_flag != 0 ); # write the error message into the script error file
                       }
                       else { # file was decrypted with sucess
                           unlink $backup_file_encrypted_fpath if ( $erase_backup_file_encrypted eq "yes" and -f $backup_file_encrypted_fpath ); # erase encrypted file if required
                       }
                    }

                    if ( $error_flag == 0 ) { # if all ok so far, do the actual restore
                        my $all_sessions_files_dir_number_tmp = 0; # the total files/directories that where restored (temporary)
                        my $all_sessions_files_size_tmp = 0; # the total size (in bytes) of the data that was restored (temporary)
                        my %supp_backup_files_details_tmp; # temporary hash that contains the exact list of all to restore, and nothing more
                        for my $supp_backup_details_record ( keys %supp_backup_files_details ) { # search the backup details list for records belong to the file we want to restore
                            # extra security, don't add records that where already ignored or mark to not be restored
                            if ( defined $supp_backup_files_details{$supp_backup_details_record} and $supp_backup_files_details{$supp_backup_details_record} ne "ignore" and $supp_backup_files_details{$supp_backup_details_record} ne "dont_restore" ) {
                                # Process the record (break fields, meta data, round up file sizes, etc
                                # 2<crc3689257328<DGOI249.processamento.ficheiros.115 full monday 10-04-2006 crc3689257328.zip<D:\migas<processamento.ficheiros\scripts\build_statistic.pl<1068456910<123<12/12/2005<3
                                my ($record_type, $backup_file_crc32, $compress_backup_file_name, $data_start_path, $data_relative_path, $data_modification_time, $data_size, $data_last_rdate, $data_rcount ) = split(/</, $supp_backup_details_record); # split the record
                                if ( $backup_filename eq $compress_backup_file_name ) { # if the backup file is the one we want to restore
                                    # load only records that belong to the backup file that we want to restore
                                    $supp_backup_files_details_tmp{$supp_backup_details_record} = $supp_backup_files_details{$supp_backup_details_record};
                                    $all_sessions_files_dir_number_tmp++;
                                    $all_sessions_files_size_tmp = $all_sessions_files_size_tmp + $data_size if ( $data_size ne "dir" );
                                }
                            }
                        }
                        # uncompress the backup file based on the list present on the %supp_backup_files_details hash, the support file hashes and supp_backup_files
                        # and supp_backup_files_details will be also updated
                        if ( do_uncompress($backup_filename, $backup_file_uncompress_fpath, $backup_file_uncompress_tar_fpath, \%supp_backup_files_details_tmp, $global_config_p, \$log_body) == 0 ) {
                            write_file_log($global_config_p, "Backup file [ $backup_file_uncompress_fpath ] restored", \$log_body); # write the error message into the script error file
                            # add the list of files and directories backuped into the log if the user so want's it
                            if ( $$global_config_p{restore_list_on_log} eq "yes" ) {
                                write_lists(\%supp_backup_files_details_tmp, "restore", $global_config_p, \$log_body);
                            }
                            # update the backup files restore count and restore date
                            patch_backup_files_records(\%supp_backup_files, $backup_filename, "", "restore_add_update", $global_config_p, \$log_body, );
                            # now update the backup files details restore count and restore date for the records that where restored
                            patch_backup_files_details_records(\%supp_backup_files_details, \%supp_backup_files_details_tmp, $backup_filename, "$meta_date", "restore_update", $global_config_p, \$log_body); # add the list of data containined on the backup file into the backup file details list
                            # update the main support file restore fields
                            if ( $restore_config{mode} eq "autosync" ) {
                                my ($file_session_number, $file_type, $file_weekday, $file_date, $file_crc32 ) = split ( / /, get_filename_session_metadata($backup_filename, $global_config_p)); # get the file session number
                                $autosync_session_tmp = $file_session_number if ( $file_session_number > $autosync_session_tmp );
                            }
                            $supp_general{restore_count} = $supp_restore_count_tmp;
                            $supp_general{last_restore_date} = $meta_date;
                            $supp_general{last_restore_username} = $my_username;
                            write_file_log($global_config_p, "Notice : updating support file", \$log_body); # write the message into the script error file
                            if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                                $error_flag = 1; # mark error unable to read support file
                            }
                            # if all is ok, store the values of the files/dirs restored size and number for future reporting
                            if ( $error_flag == 0 ) {
                                $all_sessions_files_dir_number = $all_sessions_files_dir_number + $all_sessions_files_dir_number_tmp; # total files/directories restored
                                $all_sessions_files_size = $all_sessions_files_size + $all_sessions_files_size_tmp; # total size of the files/directories restored
                                # get this backup file size
                                my ($source_dev,$source_ino,$source_mode,$source_nlink,$source_uid,$source_gid,$source_rdev,$source_size,$source_atime,$source_present_mtime,$source_ctime,$source_blksize,$source_blocks) = stat("$backup_file_uncompress_fpath");
                                $backup_files_number++; # number of backup files used
                                $backup_files_size = $backup_files_size + $source_size; # total size of the backup files used
                            }
                        }
                        else {
                            write_file_log($global_config_p, "Error : unable to restore the backup file, check permissions, free space and if the file system is not corrupted", \$log_body); # write the error message into the script error file
                            $error_flag = 1; # mark error
                        }
                    }
                    # erase left over files if required
                    unlink $backup_file_uncompress_fpath if ( $erase_backup_file_uncompress eq "yes" and -f $backup_file_uncompress_fpath ); # backup file (if it's on the temporary directory)
                    unlink $backup_file_uncompress_tar_fpath if ( -f $backup_file_uncompress_tar_fpath ); # tar temporary file
                }
                last if $error_flag != 0; # abort on any error
            }

            # if restore went all ok and running in autosync mode
            if ( $error_flag == 0 and $restore_config{mode} eq "autosync" ) {
                # update the autosync session number and autosync session date
                $supp_general{autosync_session} = $autosync_session_tmp;
                $supp_general{autosync_date} = $meta_date;
                write_file_log($global_config_p, "Notice : updating support file", \$log_body); # write the message into the script error file
                if ( read_write_support_file (\%supp_managed_data, \%supp_backup_files, \%supp_backup_files_details, \%supp_full_list, \%supp_general, 'write', 'warnings', $global_config_p, \$log_body) != 0 ) {
                    $error_flag = 1; # mark error unable to read support file
                }
            }
        }

        # check if there is a available the script/batch file/command declare by run_after_restore  RUN IT !
        if ( $$global_config_p{run_after_restore} ne "" and ( $$global_config_p{on_failure_run_after_restore} eq "yes" or ($$global_config_p{on_failure_run_after_restore} eq "no" and $error_flag == 0) ) ) {
            sleep 60; # wait 60 seconds prior to running the after restore procedure because some O/S processes might still be writting (example if doing a backup into a previously mounted drive)
            my $special_error_flag = 0;
            my $run_after_restore_command = $$global_config_p{run_after_restore};
            write_file_log($global_config_p, "Executing after restore procedure using the command [ $run_after_restore_command ]", \$log_body); # write the error message into the script error file
            system($run_after_restore_command) == 0 or $special_error_flag = 1; # do backup and if we return 1 something failed
            if ( $special_error_flag > 0 ) {
                write_file_log($global_config_p, "Warning : after restore procedure failed", \$log_body); # write the error message into the script error file
            }
        }
    }

    # erase extra files and directories on default restore directory (if required by user) and if the default restore to directory is defined
    if ( $error_flag == 0 and $restore_config{erase_extra} eq "yes" and $restore_config{to} ne "" ) {
        my $erased_counter = 0; # counter that marks the total files and directories erased
        my $failed_erased_counter = 0; # counter that marks the total files and directories that failed to be erased
        print "Searching and erasing extra files and directories not belonging to the\nbackup set in [ $restore_config{to} ]\n" if ( $restore_config{mode} eq "manual" );
        write_file_log($global_config_p, "Searching and erasing extra files and directories not belonging to the backup set in [ $restore_config{to} ]", \$log_body); # write the error message into the script error file
        clear_to($restore_config{to}, \%supp_full_list, \%restore_config, 0, \$erased_counter, \$failed_erased_counter, $global_config_p, \$log_body);
        if ( $erased_counter > 0 ) { # write the error message into the script error file
            write_file_log($global_config_p, "Erased [ $erased_counter ] files and directories", \$log_body);
        }
        else {
            write_file_log($global_config_p, "Nothing was erased in [ $restore_config{to} ]", \$log_body);
        }
        write_file_log($global_config_p, "Failed to erase [ $failed_erased_counter ] files and directories", \$log_body) if ( $failed_erased_counter > 0 ); # write the error message into the script error file
    }

    # convert the size of the restored files, into kbytes and mbytes, since it's in bytes, rounding them up
    my $all_sessions_files_size_kbytes = sprintf("%.2f",$all_sessions_files_size/1024); # 1024 bytes = 1 Kbyte
    my $all_sessions_files_size_mbytes = sprintf("%.2f",$all_sessions_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte
    my $backup_files_size_kbytes = sprintf("%.2f",$backup_files_size/1024); # 1024 bytes = 1 Kbyte
    my $backup_files_size_mbytes = sprintf("%.2f",$backup_files_size_kbytes/1024); # 1024 kbytes = 1 Mbyte

    if ( $backup_files_number > 0 and $all_sessions_files_dir_number > 0 ) { # control sitiations where the current restore did not start
        # write the message reporting the backup data files etc
        my $all_sessions_msg = "During this restore a total of [ $all_sessions_files_dir_number ] files and directories were restored and occupy [ $all_sessions_files_size_mbytes Mbytes / $all_sessions_files_size_kbytes Kbytes ]";
        my $backup_files_msg = "The restore was done from a total of [ $backup_files_number ] backup file(s) that occupy [ $backup_files_size_mbytes Mbytes / $backup_files_size_kbytes Kbytes ]";

        if ( $backup_mode eq "ftp" ) { # ftp backup mode
            my $my_remote_server_name = $$global_config_p{ftp_server}; # remote server name, only ftp is supported so far
            my $my_remote_server_port = $$global_config_p{ftp_server_port}; # remote server port, only ftp is supported so far
            my $my_remote_username = $$global_config_p{ftp_username}; # remote username, only ftp username is supported so far
            my $my_ftp_directory = $$global_config_p{ftp_directory}; # remote ftp direcotry
            $all_sessions_msg .= ", from the remote $backup_mode server [ $my_remote_server_name:$my_remote_server_port ; username: $my_remote_username ; directory: $my_ftp_directory ]";
        }
        elsif ( $backup_mode eq "sftp" ) { # sftp backup mode
            my $my_remote_server_name = $$global_config_p{sftp_server}; # remote server name, only ftp is supported so far
            my $my_remote_server_port = $$global_config_p{sftp_server_port}; # remote server port, only ftp is supported so far
            my $my_remote_username = $$global_config_p{sftp_username}; # remote username, only ftp username is supported so far
            my $my_sftp_directory = $$global_config_p{sftp_directory}; # remote ftp direcotry
            $all_sessions_msg .= ", from the remote $backup_mode server [ $my_remote_server_name:$my_remote_server_port ; username: $my_remote_username ; directory: $my_sftp_directory ]";
        }
        elsif ( $backup_mode eq "http-dav" ) { # http dav backup mode
            my $my_remote_server_name = $$global_config_p{dav_server}; # remote server name, only ftp is supported so far
            my $my_remote_server_port = $$global_config_p{dav_server_port}; # remote server port, only ftp is supported so far
            my $my_remote_username = $$global_config_p{dav_username}; # remote username, only ftp username is supported so far
            my $my_dav_directory = $$global_config_p{dav_directory}; # remote ftp direcotry
            $all_sessions_msg .= ", from the remote $backup_mode server [ $my_remote_server_name:$my_remote_server_port ; username: $my_remote_username ; directory: $my_dav_directory ]";
        }
        elsif ( $backup_mode eq "tape" ) { # tape backup mode
            my $my_tape_device = $$global_config_p{tape_device}; # tape get the device
            $all_sessions_msg .= ", from the tape device [ $my_tape_device ]";
        }
        elsif ( $backup_mode eq "smtp" ) { # smtp backup mode
            my $backup_mail_to_addresses = $$global_config_p{backup_mail_to_addresses}; # get the email addresses
            $all_sessions_msg .= ", from the email address(es) [ $backup_mail_to_addresses ]";
        }
        write_file_log($global_config_p, $all_sessions_msg, \$log_body);
        write_file_log($global_config_p, $backup_files_msg, \$log_body);
    }

    # write the final restore messages and send the email report (if configured by user)
    my $my_configuration_file_name = $$global_config_p{configuration_file_name}; # get the configuration file name, something.conf  , not /path/something.conf or c:\path\something.conf
    my $my_full_date = get_file_metadata_date($global_config_p, "yes");
    $my_full_date = ucfirst $my_full_date; # turn the first letter to upper case (ex... monday = Monday)

    if ( $error_flag == 0 ) { # write the final message on the log/email report, success or failure, error_flag == 0 here means success in backup

        if ( $$global_config_p{pass_log_to_external_cmd} ne "" ) { # if there is any available external command to accept the log
            write_file_log($global_config_p, "Calling external command and passing the restore log by the stdin, notice if the email report is used this will not be reported here", \$log_body); # write the error message into the script error file
            my $ext_log_body = "$log_body" . "$my_full_date - End of Backup in ++ success ++\n\n";
            if ( export_log( $ext_log_body, $global_config_p ) != 0 ) { # there was a error
                my $pass_log_to_external_cmd = $$global_config_p{pass_log_to_external_cmd};
                write_file_log($global_config_p, "Warning : there was a problem calling [ $pass_log_to_external_cmd ]", \$log_body); # write the error message into the script error file
            }
        }
        if ( $$global_config_p{mail_server} ne "" ) { # if mail server is configured then we can send email read_config() functions tests previoulys
            write_file_log($global_config_p, "Sending email restore report", \$log_body); # write the error message into the script error file
            my $email_log_body = "Beginning of email report\n\n" . "$log_body" . "$my_full_date - End of Restore in ++ success ++\n\n" . "End of email report\n\n";
            send_email("Simplebackup report [ $machine_hostname ; $my_configuration_file_name ]. Restore ended in ++ success ++.", $email_log_body, "", "$$global_config_p{mail_server}", "$$global_config_p{mail_port}", "$$global_config_p{mail_from_address}", "$$global_config_p{mail_to_addresses}", "$$global_config_p{mail_username}", "$$global_config_p{mail_password}", "simplebackup.pl v$script_version_int - $last_update_int", $global_config_p);
        }
        print "End of Restore in ++ success ++, check restore log for more details\n" if $restore_config{mode} eq "manual";
        write_file_log($global_config_p, "End of Restore in ++ success ++\n\n", \$log_body); # write the error message into the script error file
    }
    else { # if the backup failed
        if ( $$global_config_p{pass_log_to_external_cmd} ne "" ) { # if there is any available external command to accept the log
            write_file_log($global_config_p, "Calling external command and passing the restore log by the stdin, notice if the email report is used this will not be reported here", \$log_body); # write the error message into the script error file
            my $ext_log_body = "$log_body" . "$my_full_date - End of Restore in -- failure --\n\n";
            if ( export_log( $ext_log_body, $global_config_p ) != 0 ) { # there was a error
                my $pass_log_to_external_cmd = $$global_config_p{pass_log_to_external_cmd};
                write_file_log($global_config_p, "Warning : there was a problem calling [ $pass_log_to_external_cmd ]", \$log_body); # write the error message into the script error file
            }
        }
        if ( $$global_config_p{mail_server} ne "" ) { # if mail server is configured then we can send email read_config() functions tests previoulys
            write_file_log($global_config_p, "Sending email restore report", \$log_body); # write the error message into the script error file
            my $email_log_body = "Beginning of email report\n\n" . "$log_body" . "$my_full_date - End of Restore in -- failure --\n\n" . "End of email report\n\n";
            send_email("Simplebackup report [ $machine_hostname ; $my_configuration_file_name ]. Restore ended in -- failure --.", $email_log_body, "", "$$global_config_p{mail_server}", "$$global_config_p{mail_port}", "$$global_config_p{mail_from_address}", "$$global_config_p{mail_to_addresses}", "$$global_config_p{mail_username}", "$$global_config_p{mail_password}", "simplebackup.pl v$script_version_int - $last_update_int", $global_config_p);
        }
        print "End of Restore in -- failure --, check restore log for more details\n" if $restore_config{mode} eq "manual";
        write_file_log($global_config_p, "End of Restore in -- failure --\n\n", \$log_body); # write the error message into the script error file
    }
    print "\nThank you for using simplebackup\n\n" if $restore_config{mode} eq "manual";

    print "Function do_restore() exit value is [ $error_flag ]\n" if ( defined $$global_config_p{debug_level} and $$global_config_p{debug_level} eq "full" ); # print message if the debug level requires it
    return $error_flag; # return the restore result
}


##########################
# Main
##########################

# test if the commands/parameters are correct
if ( test_commands(@ARGV) != 0 ) {
    if ( !(defined $ARGV[0] and $ARGV[0] eq "--version") ) {
        show_commands($script_version, $script_last_update, $script_license, $script_authors, $script_email, $script_site, $script_forum, $ARGV[0]); # show the valid commands
    }
    else {
        print "$script_version";
    }
    exit 0; # exit from script if checking the version, if the arguments are wrong or there are no arguments
}

# create/edit configuration
if ( $ARGV[0] eq "--econf" ) { # create/edit configuration
    exit create_edit_config($ARGV[1], $script_version);
}

# Read the configuration file
if ( read_config($ARGV[0], $ARGV[1], \%global_config) != 0 ) {
    exit 1; # exit from script if there are any problems on the config file
}

if ( $ARGV[0] eq "--tconf" ) { # show configuration
    show_config(\%global_config);
    print "** Configuration file has passed the tests **\n";
    exit 0; # exit without erros, this is just to show the configuration not to do the backup
}
elsif ( $ARGV[0] eq "--lconf" ) { # see the log file
    exit show_log_file(\%global_config); # exit with the error code return by the function
}
elsif ( $ARGV[0] eq "--sconf" ) { # list backup sessions or list a backup session details
    my $list_session = "";
    $list_session = $ARGV[3] if ( defined $ARGV[3] );
    exit cmd_list($list_session, \%global_config); # exit with the error code return by the function
}
elsif ( $ARGV[0] eq "--ffconf" ) { # force full backup (during incremental/differencial backups, by erasing the management file
    exit force_full_backup($script_version, $script_last_update, \%global_config); # exit with the error code return by the function
}
elsif ( $ARGV[0] eq "--clconf" ) { # clear log file (with optional backup option)
    exit clear_log($script_version, $script_last_update, \%global_config); # exit with the error code return by the function
}
elsif ( $ARGV[0] eq "--rconf" ) { # do a restore
    exit do_restore($script_version, $script_last_update, $crypting_algorithm_version, \@ARGV, \%global_config);
}

# Do the backup
if ( do_backup($script_version, $script_last_update, $crypting_algorithm_version, \%global_config) != 0 ) {
    exit 1; # backup failure
};

exit 0; # all worked