/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.sandmann;

import eu.geekplace.sandmann.IdleCheck;
import eu.geekplace.sandmann.Sandmann;
import eu.geekplace.scala.BrightFuture$;
import java.io.Serializable;
import java.time.Duration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.ExtendedLogger;
import os.CommandResult;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.ProcessInput;
import os.ProcessOutput;
import os.RelPath$;
import os.Shellable;
import os.Shellable$;
import os.list$;
import os.package$;
import os.proc;
import os.proc$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.Arrays$;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public class ActivityCheckHookDir
extends IdleCheck {
    private final Path activityCheckHookDir = package$.MODULE$.root().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("etc")))).$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("sandmann")))).$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("activity-check.d"))));
    private final Path sandmannLibexecDir = (Path)this.config().cli().sourceRoot().map((Function1<Path, Path> & Serializable)_$1 -> _$1.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("libexec"))))).getOrElse(ActivityCheckHookDir::$init$$$anonfun$2);

    public ActivityCheckHookDir(Sandmann sandmann) {
        super(sandmann);
    }

    private Sandmann sandmann$accessor() {
        return super.sandmann();
    }

    public Path activityCheckHookDir() {
        return this.activityCheckHookDir;
    }

    public Path sandmannLibexecDir() {
        return this.sandmannLibexecDir;
    }

    @Override
    public Future<IdleCheck.Result> checkIdle(ExecutionContext ec) {
        if (!this.activityCheckHookDir().toIO().isDirectory()) {
            ExtendedLogger Logger_this = this.logger();
            if (Logger_this.isEnabled(Level.DEBUG)) {
                Logger_this.log(Level.DEBUG, "Hook dir {} does not exist, returning idle".toString(), (Object)this.activityCheckHookDir());
            }
            return Future$.MODULE$.apply(ActivityCheckHookDir::checkIdle$$anonfun$1, ec);
        }
        String envPathOrig = (String)scala.sys.package$.MODULE$.env().get("PATH").getOrElse(ActivityCheckHookDir::$anonfun$1);
        String envPathNew = new StringBuilder(1).append(this.sandmannLibexecDir()).append(":").append(envPathOrig).toString();
        String token = ((AbstractIterable)Random$.MODULE$.alphanumeric().take(12)).mkString();
        String idleMatch = new StringBuilder(15).append("SANDMANN ").append(token).append(": idle").toString();
        String activeMatch = new StringBuilder(17).append("SANDMANN ").append(token).append(": active").toString();
        String inhibitIdleMatch = new StringBuilder(23).append("SANDMANN ").append(token).append(": inhibit-idle").toString();
        Tuple2[] tuple2Array = new Tuple2[2];
        String string2 = Predef$.MODULE$.ArrowAssoc("PATH");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, envPathNew);
        String string3 = Predef$.MODULE$.ArrowAssoc("SANDMANN_TOKEN");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, token);
        Map env = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
        Seq futures = ((IndexedSeqOps)list$.MODULE$.apply(this.activityCheckHookDir()).filter((Function1<Path, boolean> & Serializable)_$2 -> _$2.toIO().canExecute())).view().map((Function1<Path, Future> & Serializable)hook -> Future$.MODULE$.apply(() -> this.$anonfun$3$$anonfun$1(hook, env, activeMatch, inhibitIdleMatch, idleMatch), ec)).toSeq();
        Future<Either<IdleCheck.ActiveOrInhibited, Seq<Try<IdleCheck.Result>>>> future = BrightFuture$.MODULE$.firstCompletedOf(futures, new Serializable(){

            public final boolean isDefinedAt(Try x) {
                IdleCheck.Result result;
                Try try_ = x;
                if (try_ instanceof Success && (result = (IdleCheck.Result)((Success)try_).value()) instanceof IdleCheck.ActiveOrInhibited) {
                    IdleCheck.ActiveOrInhibited a = (IdleCheck.ActiveOrInhibited)result;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                IdleCheck.Result result;
                Try try_ = x;
                if (try_ instanceof Success && (result = (IdleCheck.Result)((Success)try_).value()) instanceof IdleCheck.ActiveOrInhibited) {
                    IdleCheck.ActiveOrInhibited a = (IdleCheck.ActiveOrInhibited)result;
                    return a;
                }
                return function1.apply(x);
            }
        }, ec);
        return future.map((Function1<Either, IdleCheck.Result> & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                IdleCheck.ActiveOrInhibited active = (IdleCheck.ActiveOrInhibited)((Left)either).value();
                return active;
            }
            if (either instanceof Right) {
                Seq nonActiveResults = (Seq)((Right)either).value();
                return this.sandmann$accessor().extractIdleInformationAndLogFailures(nonActiveResults);
            }
            throw new MatchError(either);
        }, ec);
    }

    private static final Path $init$$$anonfun$2() {
        return package$.MODULE$.root().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("usr")))).$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("libexec")))).$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString("sandmann"))));
    }

    private static final IdleCheck.Idle checkIdle$$anonfun$1() {
        return new IdleCheck.Idle();
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final CommandResult $anonfun$4(Path hook$2, Map env$2) {
        proc proc2 = proc$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Shellable[]{Shellable$.MODULE$.PathShellable(hook$2)}));
        long l = Duration.ofMinutes(1L).toMillis();
        Path path = proc2.call$default$1();
        ProcessInput processInput = proc2.call$default$3();
        ProcessOutput processOutput = proc2.call$default$4();
        ProcessOutput processOutput2 = proc2.call$default$5();
        boolean bl = proc2.call$default$6();
        boolean bl2 = proc2.call$default$8();
        long l2 = proc2.call$default$10();
        boolean bl3 = proc2.call$default$11();
        return proc2.call(path, env$2, processInput, processOutput, processOutput2, bl, l, bl2, false, l2, bl3);
    }

    private static final String stdoutStderrMessage$lzyINIT1$1(LazyRef stdoutStderrMessage$lzy1$1, CommandResult res$1, String stdout$2) {
        String string2;
        LazyRef lazyRef = stdoutStderrMessage$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (stdoutStderrMessage$lzy1$1.initialized()) {
                object = stdoutStderrMessage$lzy1$1.value();
            } else {
                String stderr = res$1.err().text();
                String stderrMessage = stderr.isEmpty() ? "" : StringOps$.MODULE$.format$extension("\nstderr:\n%s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{stderr}));
                object = stdoutStderrMessage$lzy1$1.initialize(stdout$2.isEmpty() && stderrMessage.isEmpty() ? " (no stdout/stderr)" : StringOps$.MODULE$.format$extension("\nstdout:\n%s%s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{stdout$2, stderrMessage})));
            }
            string2 = (String)object;
        }
        return string2;
    }

    private static final String stdoutStderrMessage$1(LazyRef stdoutStderrMessage$lzy1$2, CommandResult res$2, String stdout$3) {
        return (String)(stdoutStderrMessage$lzy1$2.initialized() ? stdoutStderrMessage$lzy1$2.value() : ActivityCheckHookDir.stdoutStderrMessage$lzyINIT1$1(stdoutStderrMessage$lzy1$2, res$2, stdout$3));
    }

    private static final IdleCheck.Result $anonfun$3$$anonfun$1$$anonfun$1(Path hook$3, LazyRef stdoutStderrMessage$lzy1$3, CommandResult res$3, String stdout$4) {
        throw new Exception(new StringBuilder(44).append(hook$3).append(": did not include any activity-check marker.").append(ActivityCheckHookDir.stdoutStderrMessage$1(stdoutStderrMessage$lzy1$3, res$3, stdout$4)).toString());
    }

    private final IdleCheck.Result $anonfun$3$$anonfun$1(Path hook$1, Map env$1, String activeMatch$1, String inhibitIdleMatch$1, String idleMatch$1) {
        Option<IdleCheck.Result> hookResult;
        String stdout;
        CommandResult res;
        LazyRef lazyRef;
        block2: {
            lazyRef = new LazyRef();
            ExtendedLogger Logger_this = this.logger();
            if (Logger_this.isEnabled(Level.DEBUG)) {
                Logger_this.log(Level.DEBUG, "Invoking {}".toString(), (Object)hook$1);
            }
            res = (CommandResult)scala.concurrent.package$.MODULE$.blocking(() -> ActivityCheckHookDir.$anonfun$4(hook$1, env$1));
            stdout = res.out().text();
            int exitStatus = res.exitCode();
            if (res.exitCode() != 0) {
                throw new Exception(new StringBuilder(32).append(hook$1).append(": returned failure exit status ").append(exitStatus).append(".").append(ActivityCheckHookDir.stdoutStderrMessage$1(lazyRef, res, stdout)).toString());
            }
            hookResult = ((IterableOnceOps)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(stdout)).toSeq().reverse()).collectFirst(new Serializable(activeMatch$1, inhibitIdleMatch$1, idleMatch$1){
                private final String activeMatch$3;
                private final String inhibitIdleMatch$3;
                private final String idleMatch$3;
                {
                    this.activeMatch$3 = activeMatch$4;
                    this.inhibitIdleMatch$3 = inhibitIdleMatch$4;
                    this.idleMatch$3 = idleMatch$4;
                }

                public final boolean isDefinedAt(String x) {
                    String string2 = x;
                    String line = string2;
                    if (line.equals(this.activeMatch$3)) {
                        return true;
                    }
                    String line2 = string2;
                    if (line2.equals(this.inhibitIdleMatch$3)) {
                        return true;
                    }
                    String line3 = string2;
                    return line3.equals(this.idleMatch$3);
                }

                public final Object applyOrElse(String x, Function1 function1) {
                    String string2 = x;
                    String line = string2;
                    if (line.equals(this.activeMatch$3)) {
                        return new IdleCheck.Active();
                    }
                    String line2 = string2;
                    if (line2.equals(this.inhibitIdleMatch$3)) {
                        return new IdleCheck.InhibitIdle();
                    }
                    String line3 = string2;
                    if (line3.equals(this.idleMatch$3)) {
                        return new IdleCheck.Idle();
                    }
                    return function1.apply(x);
                }
            });
            ExtendedLogger Logger_this2 = this.logger();
            if (!Logger_this2.isEnabled(Level.DEBUG)) break block2;
            Logger_this2.log(Level.DEBUG, "{}: returned hook result {}.{}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{hook$1, hookResult, ActivityCheckHookDir.stdoutStderrMessage$1(lazyRef, res, stdout)}), Object.class));
        }
        return (IdleCheck.Result)hookResult.getOrElse(() -> ActivityCheckHookDir.$anonfun$3$$anonfun$1$$anonfun$1(hook$1, lazyRef, res, stdout));
    }
}

