/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.io.FileNotFoundException;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.AbstractRepositoryListener;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.RepositoryEvent;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.transfer.MetadataNotFoundException;
import org.apache.tools.ant.Task;

class AntRepositoryListener
extends AbstractRepositoryListener {
    private Task task;

    AntRepositoryListener(Task task) {
        this.task = task;
    }

    @Override
    public void artifactInstalling(RepositoryEvent event) {
        this.task.log("Installing " + event.getArtifact().getFile() + " to " + event.getFile());
    }

    @Override
    public void metadataInstalling(RepositoryEvent event) {
        this.task.log("Installing " + event.getMetadata() + " to " + event.getFile());
    }

    @Override
    public void metadataResolved(RepositoryEvent event) {
        Exception e = event.getException();
        if (e != null) {
            if (e instanceof MetadataNotFoundException) {
                this.task.log(e.getMessage(), 4);
            } else {
                this.task.log(e.getMessage(), (Throwable)e, 1);
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event) {
        Exception exception = event.getException();
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The metadata ");
        if (event.getMetadata().getFile() != null) {
            buffer.append(event.getMetadata().getFile());
        } else {
            buffer.append(event.getMetadata());
        }
        if (exception instanceof FileNotFoundException) {
            buffer.append(" is inaccessible");
        } else {
            buffer.append(" is invalid");
        }
        if (exception != null) {
            buffer.append(": ");
            buffer.append(exception.getMessage());
        }
        this.task.log(buffer.toString(), (Throwable)exception, 1);
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event) {
        this.task.log("The POM for " + event.getArtifact() + " is invalid, transitive dependencies (if any) will not be available: " + event.getException().getMessage(), (Throwable)event.getException(), 1);
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.task.log("The POM for " + event.getArtifact() + " is missing, no dependency information available", 1);
    }
}

