/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.tasks;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;

public abstract class RefTask
extends Task {
    private Reference ref;

    public boolean isReference() {
        return this.ref != null;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
    }

    protected void checkAttributesAllowed() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
    }

    protected void checkChildrenAllowed() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
    }

    protected BuildException tooManyAttributes() {
        return new BuildException("You must not specify more than one attribute when using refid");
    }

    protected BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using refid");
    }

    protected String getDataTypeName() {
        return ComponentHelper.getElementName((Project)this.getProject(), (Object)((Object)this), (boolean)true);
    }

    protected Object getCheckedRef() {
        return this.getCheckedRef(((Object)((Object)this)).getClass(), this.getDataTypeName(), this.getProject());
    }

    protected Object getCheckedRef(Class<?> requiredClass, String dataTypeName, Project project) {
        if (project == null) {
            throw new BuildException("No Project specified");
        }
        Object o = this.ref.getReferencedObject(project);
        if (!requiredClass.isAssignableFrom(o.getClass())) {
            this.log("Class " + o.getClass() + " is not a subclass of " + requiredClass, 3);
            String msg = this.ref.getRefId() + " doesn't denote a " + dataTypeName;
            throw new BuildException(msg);
        }
        return o;
    }
}

