/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant.types;

import java.util.Collections;
import java.util.List;
import org.apache.maven.resolver.internal.ant.AntRepoSys;
import org.apache.maven.resolver.internal.ant.types.Authentication;
import org.apache.maven.resolver.internal.ant.types.RemoteRepositoryContainer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class RemoteRepository
extends DataType
implements RemoteRepositoryContainer {
    private String id;
    private String url;
    private String type;
    private Policy releasePolicy;
    private Policy snapshotPolicy;
    private boolean releases = true;
    private boolean snapshots = false;
    private String checksums;
    private String updates;
    private Authentication authentication;

    public void setProject(Project project) {
        super.setProject(project);
        AntRepoSys.getInstance(project);
    }

    protected RemoteRepository getRef() {
        return (RemoteRepository)this.getCheckedRef();
    }

    @Override
    public void validate(Task task) {
        if (this.isReference()) {
            this.getRef().validate(task);
        } else {
            if (this.url == null || this.url.length() <= 0) {
                throw new BuildException("You must specify the 'url' for a remote repository");
            }
            if (this.id == null || this.id.length() <= 0) {
                throw new BuildException("You must specify the 'id' for a remote repository");
            }
        }
    }

    public void setRefid(Reference ref) {
        if (this.id != null || this.url != null || this.type != null || this.checksums != null || this.updates != null) {
            throw this.tooManyAttributes();
        }
        if (this.releasePolicy != null || this.snapshotPolicy != null || this.authentication != null) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(ref);
    }

    public String getId() {
        if (this.isReference()) {
            return this.getRef().getId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        if (this.isReference()) {
            return this.getRef().getUrl();
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.checkAttributesAllowed();
        this.url = url;
    }

    public String getType() {
        if (this.isReference()) {
            return this.getRef().getType();
        }
        return this.type != null ? this.type : "default";
    }

    public void setType(String type) {
        this.checkAttributesAllowed();
        this.type = type;
    }

    public Policy getReleasePolicy() {
        if (this.isReference()) {
            return this.getRef().getReleasePolicy();
        }
        return this.releasePolicy;
    }

    public void addReleases(Policy policy) {
        this.checkChildrenAllowed();
        if (this.releasePolicy != null) {
            throw new BuildException("You must not specify multiple <releases> elements");
        }
        this.releasePolicy = policy;
    }

    public Policy getSnapshotPolicy() {
        if (this.isReference()) {
            return this.getRef().getSnapshotPolicy();
        }
        return this.snapshotPolicy;
    }

    public void addSnapshots(Policy policy) {
        this.checkChildrenAllowed();
        if (this.snapshotPolicy != null) {
            throw new BuildException("You must not specify multiple <snapshots> elements");
        }
        this.snapshotPolicy = policy;
    }

    public boolean isReleases() {
        if (this.isReference()) {
            return this.getRef().isReleases();
        }
        return this.releases;
    }

    public void setReleases(boolean releases) {
        this.checkAttributesAllowed();
        this.releases = releases;
    }

    public boolean isSnapshots() {
        if (this.isReference()) {
            return this.getRef().isSnapshots();
        }
        return this.snapshots;
    }

    public void setSnapshots(boolean snapshots) {
        this.checkAttributesAllowed();
        this.snapshots = snapshots;
    }

    public String getUpdates() {
        if (this.isReference()) {
            return this.getRef().getUpdates();
        }
        return this.updates != null ? this.updates : "daily";
    }

    public void setUpdates(String updates) {
        this.checkAttributesAllowed();
        RemoteRepository.checkUpdates(updates);
        this.updates = updates;
    }

    protected static void checkUpdates(String updates) {
        if (!("always".equals(updates) || "daily".equals(updates) || "never".equals(updates) || updates.startsWith("interval"))) {
            throw new BuildException("'" + updates + "' is not a permitted update policy");
        }
    }

    public String getChecksums() {
        if (this.isReference()) {
            return this.getRef().getChecksums();
        }
        return this.checksums != null ? this.checksums : "warn";
    }

    public void setChecksums(String checksums) {
        this.checkAttributesAllowed();
        RemoteRepository.checkChecksums(checksums);
        this.checksums = checksums;
    }

    protected static void checkChecksums(String checksums) {
        if (!("fail".equals(checksums) || "warn".equals(checksums) || "ignore".equals(checksums))) {
            throw new BuildException("'" + checksums + "' is not a permitted checksum policy");
        }
    }

    public Authentication getAuthentication() {
        if (this.isReference()) {
            return this.getRef().getAuthentication();
        }
        return this.authentication;
    }

    public void addAuthentication(Authentication authentication) {
        this.checkChildrenAllowed();
        if (this.authentication != null) {
            throw new BuildException("You must not specify multiple <authentication> elements");
        }
        this.authentication = authentication;
    }

    public void setAuthRef(Reference ref) {
        this.checkAttributesAllowed();
        if (this.authentication == null) {
            this.authentication = new Authentication();
            this.authentication.setProject(this.getProject());
        }
        this.authentication.setRefid(ref);
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return Collections.singletonList(this);
    }

    public static class Policy {
        private boolean enabled = true;
        private String checksumPolicy;
        private String updatePolicy;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getChecksums() {
            return this.checksumPolicy;
        }

        public void setChecksums(String checksumPolicy) {
            RemoteRepository.checkChecksums(checksumPolicy);
            this.checksumPolicy = checksumPolicy;
        }

        public String getUpdates() {
            return this.updatePolicy;
        }

        public void setUpdates(String updatePolicy) {
            RemoteRepository.checkUpdates(updatePolicy);
            this.updatePolicy = updatePolicy;
        }
    }
}

