/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.args4j.spi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.cli.internal.args4j.IllegalAnnotationError;
import org.jacoco.cli.internal.args4j.spi.FieldSetter;
import org.jacoco.cli.internal.args4j.spi.Messages;
import org.jacoco.cli.internal.args4j.spi.Setter;

final class MultiValueFieldSetter
implements Setter {
    private final Object bean;
    private final Field f;

    public MultiValueFieldSetter(Object bean, Field f) {
        this.bean = bean;
        this.f = f;
        if (!List.class.isAssignableFrom(f.getType())) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(f.getType()));
        }
    }

    public boolean isMultiValued() {
        return true;
    }

    public FieldSetter asFieldSetter() {
        return new FieldSetter(this.bean, this.f);
    }

    public AnnotatedElement asAnnotatedElement() {
        return this.f;
    }

    public Class getType() {
        ParameterizedType pt;
        Type t = this.f.getGenericType();
        if (t instanceof ParameterizedType && (t = (pt = (ParameterizedType)t).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)t;
        }
        return Object.class;
    }

    public void addValue(Object value) {
        try {
            this.doAddValue(this.bean, value);
        }
        catch (IllegalAccessException ex) {
            this.f.setAccessible(true);
            try {
                this.doAddValue(this.bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private void doAddValue(Object bean, Object value) throws IllegalAccessException {
        ArrayList o = this.f.get(bean);
        if (o == null) {
            o = new ArrayList();
            this.f.set(bean, o);
        }
        if (!(o instanceof List)) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_LIST.format(this.f));
        }
        ((List)o).add(value);
    }
}

