/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis;

import java.util.ArrayList;
import java.util.Collection;
import org.jacoco.cli.internal.core.analysis.IClassCoverage;
import org.jacoco.cli.internal.core.analysis.ICoverageNode;
import org.jacoco.cli.internal.core.analysis.IMethodCoverage;
import org.jacoco.cli.internal.core.internal.analysis.CounterImpl;
import org.jacoco.cli.internal.core.internal.analysis.SourceNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCoverageImpl
extends SourceNodeImpl
implements IClassCoverage {
    private final long id;
    private final boolean noMatch;
    private final Collection<IMethodCoverage> methods;
    private String signature;
    private String superName;
    private String[] interfaces;
    private String sourceFileName;

    public ClassCoverageImpl(String name, long id, boolean noMatch) {
        super(ICoverageNode.ElementType.CLASS, name);
        this.id = id;
        this.noMatch = noMatch;
        this.methods = new ArrayList<IMethodCoverage>();
    }

    public void addMethod(IMethodCoverage method) {
        this.methods.add(method);
        this.increment(method);
        this.classCounter = this.methodCounter.getCoveredCount() > 0 ? CounterImpl.COUNTER_0_1 : CounterImpl.COUNTER_1_0;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public void setInterfaces(String[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean isNoMatch() {
        return this.noMatch;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public String getSuperName() {
        return this.superName;
    }

    @Override
    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    @Override
    public String getPackageName() {
        int pos = this.getName().lastIndexOf(47);
        return pos == -1 ? "" : this.getName().substring(0, pos);
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Override
    public Collection<IMethodCoverage> getMethods() {
        return this.methods;
    }
}

