_prefix=/usr
_libdir=/usr/lib
_bindir=/usr/bin

case `uname -m` in
	"x86_64")
		_machine_type="MACHINETYPE=x86_64"
		_cflags="CFLAGS=-m64 -march=x86-64"
		if which rpm > /dev/null 2>&1; then
			_libdir=/usr/lib64
		fi
	;;

	"i686")
		_machine_type="MACHINETYPE=i686"
		_cflags="CFLAGS=-m32 -march=i686"
	;;

	"aarch64"|"mips64")
		if which rpm > /dev/null 2>&1; then
			_libdir=/usr/lib64
		fi
	;;
esac

cd buftool
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}" --libdir="${_libdir}" --enable-progpath="${_bindir}" --disable-shared --enable-static
make
cp libbuftool.a ../../lib

cd ../cngplp
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}" --libdir="${_libdir}" COMMON_SUFFIX=2
make

cd ../backend
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}" --libdir="${_libdir}" MODULE_SUFFIX="ufr2"
make

cd ../rasterfilter
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}" --libdir="${_libdir}"
make

cd ../cnjbig
./autogen.sh "${_machine_type}" "${_cflags}" --prefix="${_prefix}"
make 
