/* collection.c generated by valac 0.56.17, the Vala compiler
 * generated from collection.vala, do not modify */

/* collection.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _Block5Data {
	int _ref_count_;
	GeeCollection* self;
	gboolean changed;
};

struct _Block6Data {
	int _ref_count_;
	GeeCollection* self;
	gboolean changed;
};

static gboolean gee_collection_real_add_all (GeeCollection* self,
                                      GeeCollection* collection);
static gboolean __lambda34_ (GeeCollection* self,
                      gpointer item,
                      gboolean changed);
static gpointer ___lambda34__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gboolean gee_collection_real_contains_all (GeeCollection* self,
                                           GeeCollection* collection);
static gboolean __lambda35_ (GeeCollection* self,
                      gpointer item);
static gboolean ___lambda35__gee_forall_func (gpointer g,
                                       gpointer self);
static gboolean gee_collection_real_remove_all (GeeCollection* self,
                                         GeeCollection* collection);
static gboolean __lambda36_ (GeeCollection* self,
                      gpointer item,
                      gboolean changed);
static gpointer ___lambda36__gee_fold_func (gpointer g,
                                     gpointer a,
                                     gpointer self);
static gboolean gee_collection_real_retain_all (GeeCollection* self,
                                         GeeCollection* collection);
static gpointer* gee_collection_real_to_array (GeeCollection* self,
                                        gint* result_length1);
static gboolean* gee_collection_to_bool_array (GeeCollection* coll,
                                        gint* result_length1);
static gchar* gee_collection_to_char_array (GeeCollection* coll,
                                     gint* result_length1);
static guchar* gee_collection_to_uchar_array (GeeCollection* coll,
                                       gint* result_length1);
static gint* gee_collection_to_int_array (GeeCollection* coll,
                                   gint* result_length1);
static guint* gee_collection_to_uint_array (GeeCollection* coll,
                                     gint* result_length1);
static gint64** gee_collection_to_int64_array (GeeCollection* coll,
                                        gint* result_length1);
static guint64** gee_collection_to_uint64_array (GeeCollection* coll,
                                          gint* result_length1);
static glong* gee_collection_to_long_array (GeeCollection* coll,
                                     gint* result_length1);
static gulong* gee_collection_to_ulong_array (GeeCollection* coll,
                                       gint* result_length1);
static gfloat** gee_collection_to_float_array (GeeCollection* coll,
                                        gint* result_length1);
static gdouble** gee_collection_to_double_array (GeeCollection* coll,
                                          gint* result_length1);
static gboolean gee_collection_real_add_all_array (GeeCollection* self,
                                            gpointer* array,
                                            gint array_length1);
static gboolean gee_collection_add_all_bool_array (GeeCollection* coll,
                                            gboolean* arr,
                                            gint arr_length1);
static gboolean gee_collection_add_all_char_array (GeeCollection* coll,
                                            gchar* arr,
                                            gint arr_length1);
static gboolean gee_collection_add_all_uchar_array (GeeCollection* coll,
                                             guchar* arr,
                                             gint arr_length1);
static gboolean gee_collection_add_all_int_array (GeeCollection* coll,
                                           gint* arr,
                                           gint arr_length1);
static gboolean gee_collection_add_all_uint_array (GeeCollection* coll,
                                            guint* arr,
                                            gint arr_length1);
static gboolean gee_collection_add_all_int64_array (GeeCollection* coll,
                                             gint64** arr,
                                             gint arr_length1);
static gboolean gee_collection_add_all_uint64_array (GeeCollection* coll,
                                              guint64** arr,
                                              gint arr_length1);
static gboolean gee_collection_add_all_long_array (GeeCollection* coll,
                                            glong* arr,
                                            gint arr_length1);
static gboolean gee_collection_add_all_ulong_array (GeeCollection* coll,
                                             gulong* arr,
                                             gint arr_length1);
static gboolean gee_collection_add_all_float_array (GeeCollection* coll,
                                             gfloat** arr,
                                             gint arr_length1);
static gboolean gee_collection_add_all_double_array (GeeCollection* coll,
                                              gdouble** arr,
                                              gint arr_length1);
static gboolean gee_collection_real_contains_all_array (GeeCollection* self,
                                                 gpointer* array,
                                                 gint array_length1);
static gboolean gee_collection_contains_all_bool_array (GeeCollection* coll,
                                                 gboolean* arr,
                                                 gint arr_length1);
static gboolean gee_collection_contains_all_char_array (GeeCollection* coll,
                                                 gchar* arr,
                                                 gint arr_length1);
static gboolean gee_collection_contains_all_uchar_array (GeeCollection* coll,
                                                  guchar* arr,
                                                  gint arr_length1);
static gboolean gee_collection_contains_all_int_array (GeeCollection* coll,
                                                gint* arr,
                                                gint arr_length1);
static gboolean gee_collection_contains_all_uint_array (GeeCollection* coll,
                                                 guint* arr,
                                                 gint arr_length1);
static gboolean gee_collection_contains_all_int64_array (GeeCollection* coll,
                                                  gint64** arr,
                                                  gint arr_length1);
static gboolean gee_collection_contains_all_uint64_array (GeeCollection* coll,
                                                   guint64** arr,
                                                   gint arr_length1);
static gboolean gee_collection_contains_all_long_array (GeeCollection* coll,
                                                 glong* arr,
                                                 gint arr_length1);
static gboolean gee_collection_contains_all_ulong_array (GeeCollection* coll,
                                                  gulong* arr,
                                                  gint arr_length1);
static gboolean gee_collection_contains_all_float_array (GeeCollection* coll,
                                                  gfloat** arr,
                                                  gint arr_length1);
static gboolean gee_collection_contains_all_double_array (GeeCollection* coll,
                                                   gdouble** arr,
                                                   gint arr_length1);
static gboolean gee_collection_real_remove_all_array (GeeCollection* self,
                                               gpointer* array,
                                               gint array_length1);
static gboolean gee_collection_remove_all_bool_array (GeeCollection* coll,
                                               gboolean* arr,
                                               gint arr_length1);
static gboolean gee_collection_remove_all_char_array (GeeCollection* coll,
                                               gchar* arr,
                                               gint arr_length1);
static gboolean gee_collection_remove_all_uchar_array (GeeCollection* coll,
                                                guchar* arr,
                                                gint arr_length1);
static gboolean gee_collection_remove_all_int_array (GeeCollection* coll,
                                              gint* arr,
                                              gint arr_length1);
static gboolean gee_collection_remove_all_uint_array (GeeCollection* coll,
                                               guint* arr,
                                               gint arr_length1);
static gboolean gee_collection_remove_all_int64_array (GeeCollection* coll,
                                                gint64** arr,
                                                gint arr_length1);
static gboolean gee_collection_remove_all_uint64_array (GeeCollection* coll,
                                                 guint64** arr,
                                                 gint arr_length1);
static gboolean gee_collection_remove_all_long_array (GeeCollection* coll,
                                               glong* arr,
                                               gint arr_length1);
static gboolean gee_collection_remove_all_ulong_array (GeeCollection* coll,
                                                gulong* arr,
                                                gint arr_length1);
static gboolean gee_collection_remove_all_float_array (GeeCollection* coll,
                                                gfloat** arr,
                                                gint arr_length1);
static gboolean gee_collection_remove_all_double_array (GeeCollection* coll,
                                                 gdouble** arr,
                                                 gint arr_length1);
static gboolean gee_collection_real_add_all_iterator (GeeCollection* self,
                                               GeeIterator* iter);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda37_ (Block5Data* _data5_,
                      gpointer val);
static gboolean ___lambda37__gee_forall_func (gpointer g,
                                       gpointer self);
static gboolean gee_collection_real_contains_all_iterator (GeeCollection* self,
                                                    GeeIterator* iter);
static gboolean __lambda38_ (GeeCollection* self,
                      gpointer val);
static gboolean ___lambda38__gee_forall_func (gpointer g,
                                       gpointer self);
static gboolean gee_collection_real_remove_all_iterator (GeeCollection* self,
                                                  GeeIterator* iter);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean __lambda39_ (Block6Data* _data6_,
                      gpointer val);
static gboolean ___lambda39__gee_forall_func (gpointer g,
                                       gpointer self);
static GType gee_collection_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
 * Determines whether this collection contains the specified item.
 *
 * @param item the item to locate in the collection
 *
 * @return     ``true`` if item is found, ``false`` otherwise
 */
gboolean
gee_collection_contains (GeeCollection* self,
                         gconstpointer item)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->contains) {
		return _iface_->contains (self, item);
	}
	return FALSE;
}

/**
 * Adds an item to this collection. Must not be called on read-only
 * collections.
 *
 * @param item the item to add to the collection
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean
gee_collection_add (GeeCollection* self,
                    gconstpointer item)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->add) {
		return _iface_->add (self, item);
	}
	return FALSE;
}

/**
 * Removes the first occurrence of an item from this collection. Must not
 * be called on read-only collections.
 *
 * @param item the item to remove from the collection
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean
gee_collection_remove (GeeCollection* self,
                       gconstpointer item)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->remove) {
		return _iface_->remove (self, item);
	}
	return FALSE;
}

/**
 * Removes all items from this collection. Must not be called on
 * read-only collections.
 */
void
gee_collection_clear (GeeCollection* self)
{
	GeeCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->clear) {
		_iface_->clear (self);
	}
}

/**
 * Adds all items in the input collection to this collection.
 *
 * @param collection the collection which items will be added to this
 *                   collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
__lambda34_ (GeeCollection* self,
             gpointer item,
             gboolean changed)
{
	gboolean result;
	result = changed | gee_collection_add (self, item);
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gpointer
___lambda34__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda34_ ((GeeCollection*) self, g, (gboolean) ((gintptr) a)));
	return result;
}

static gboolean
gee_collection_real_add_all (GeeCollection* self,
                             GeeCollection* collection)
{
	gpointer _tmp0_;
	gboolean result;
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = gee_traversable_fold ((GeeTraversable*) collection, G_TYPE_BOOLEAN, NULL, NULL, ___lambda34__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
	result = (gboolean) ((gintptr) _tmp0_);
	return result;
}

gboolean
gee_collection_add_all (GeeCollection* self,
                        GeeCollection* collection)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->add_all) {
		return _iface_->add_all (self, collection);
	}
	return FALSE;
}

/**
 * Returns ``true`` it this collection contains all items as the input
 * collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
__lambda35_ (GeeCollection* self,
             gpointer item)
{
	gboolean result;
	result = gee_collection_contains (self, item);
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda35__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda35_ ((GeeCollection*) self, g);
	return result;
}

static gboolean
gee_collection_real_contains_all (GeeCollection* self,
                                  GeeCollection* collection)
{
	gboolean result;
	g_return_val_if_fail (collection != NULL, FALSE);
	result = gee_traversable_foreach ((GeeTraversable*) collection, ___lambda35__gee_forall_func, self);
	return result;
}

gboolean
gee_collection_contains_all (GeeCollection* self,
                             GeeCollection* collection)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->contains_all) {
		return _iface_->contains_all (self, collection);
	}
	return FALSE;
}

/**
 * Removes the subset of items in this collection corresponding to the
 * elements in the input collection. If there is several occurrences of
 * the same value in this collection they are decremented of the number
 * of occurrences in the input collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
__lambda36_ (GeeCollection* self,
             gpointer item,
             gboolean changed)
{
	gboolean result;
	result = changed | gee_collection_remove (self, item);
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gpointer
___lambda36__gee_fold_func (gpointer g,
                            gpointer a,
                            gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) __lambda36_ ((GeeCollection*) self, g, (gboolean) ((gintptr) a)));
	return result;
}

static gboolean
gee_collection_real_remove_all (GeeCollection* self,
                                GeeCollection* collection)
{
	gpointer _tmp0_;
	gboolean result;
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp0_ = gee_traversable_fold ((GeeTraversable*) collection, G_TYPE_BOOLEAN, NULL, NULL, ___lambda36__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
	result = (gboolean) ((gintptr) _tmp0_);
	return result;
}

gboolean
gee_collection_remove_all (GeeCollection* self,
                           GeeCollection* collection)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->remove_all) {
		return _iface_->remove_all (self, collection);
	}
	return FALSE;
}

/**
 * Removes all items in this collection that are not contained in the input
 * collection. In other words all common items of both collections are
 * retained in this collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
gee_collection_real_retain_all (GeeCollection* self,
                                GeeCollection* collection)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (collection != NULL, FALSE);
	changed = FALSE;
	{
		GeeIterator* iter = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) self);
		iter = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeIterator* _tmp2_;
				gpointer item = NULL;
				GeeIterator* _tmp3_;
				gpointer _tmp4_;
				gconstpointer _tmp5_;
				if (!_tmp1_) {
				}
				_tmp1_ = FALSE;
				_tmp2_ = iter;
				if (!gee_iterator_next (_tmp2_)) {
					break;
				}
				_tmp3_ = iter;
				_tmp4_ = gee_iterator_get (_tmp3_);
				item = _tmp4_;
				_tmp5_ = item;
				if (!gee_collection_contains (collection, _tmp5_)) {
					GeeIterator* _tmp6_;
					_tmp6_ = iter;
					gee_iterator_remove (_tmp6_);
					changed = TRUE;
				}
				((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
			}
		}
		_g_object_unref0 (iter);
	}
	result = changed;
	return result;
}

gboolean
gee_collection_retain_all (GeeCollection* self,
                           GeeCollection* collection)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->retain_all) {
		return _iface_->retain_all (self, collection);
	}
	return FALSE;
}

/**
 * Returns an array containing all of items from this collection.
 *
 * @return an array containing all of items from this collection
 */
static gpointer*
gee_collection_real_to_array (GeeCollection* self,
                              gint* result_length1)
{
	GType t = 0UL;
	gpointer* result;
	t = GEE_COLLECTION_GET_INTERFACE (self)->get_g_type (self);
	if (t == G_TYPE_BOOLEAN) {
		gint _tmp0_ = 0;
		gboolean* _tmp1_;
		gpointer* _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = gee_collection_to_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp0_);
		_tmp2_ = (gpointer*) _tmp1_;
		_tmp2__length1 = _tmp0_;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			gint _tmp3_ = 0;
			gchar* _tmp4_;
			gpointer* _tmp5_;
			gint _tmp5__length1;
			_tmp4_ = gee_collection_to_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp3_);
			_tmp5_ = (gpointer*) _tmp4_;
			_tmp5__length1 = _tmp3_;
			if (result_length1) {
				*result_length1 = _tmp5__length1;
			}
			result = _tmp5_;
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				gint _tmp6_ = 0;
				guchar* _tmp7_;
				gpointer* _tmp8_;
				gint _tmp8__length1;
				_tmp7_ = gee_collection_to_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp6_);
				_tmp8_ = (gpointer*) _tmp7_;
				_tmp8__length1 = _tmp6_;
				if (result_length1) {
					*result_length1 = _tmp8__length1;
				}
				result = _tmp8_;
				return result;
			} else {
				if (t == G_TYPE_INT) {
					gint _tmp9_ = 0;
					gint* _tmp10_;
					gpointer* _tmp11_;
					gint _tmp11__length1;
					_tmp10_ = gee_collection_to_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp9_);
					_tmp11_ = (gpointer*) _tmp10_;
					_tmp11__length1 = _tmp9_;
					if (result_length1) {
						*result_length1 = _tmp11__length1;
					}
					result = _tmp11_;
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						gint _tmp12_ = 0;
						guint* _tmp13_;
						gpointer* _tmp14_;
						gint _tmp14__length1;
						_tmp13_ = gee_collection_to_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp12_);
						_tmp14_ = (gpointer*) _tmp13_;
						_tmp14__length1 = _tmp12_;
						if (result_length1) {
							*result_length1 = _tmp14__length1;
						}
						result = _tmp14_;
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							gint _tmp15_ = 0;
							gint64** _tmp16_;
							gpointer* _tmp17_;
							gint _tmp17__length1;
							_tmp16_ = gee_collection_to_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp15_);
							_tmp17_ = (gpointer*) _tmp16_;
							_tmp17__length1 = _tmp15_;
							if (result_length1) {
								*result_length1 = _tmp17__length1;
							}
							result = _tmp17_;
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								gint _tmp18_ = 0;
								guint64** _tmp19_;
								gpointer* _tmp20_;
								gint _tmp20__length1;
								_tmp19_ = gee_collection_to_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp18_);
								_tmp20_ = (gpointer*) _tmp19_;
								_tmp20__length1 = _tmp18_;
								if (result_length1) {
									*result_length1 = _tmp20__length1;
								}
								result = _tmp20_;
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									gint _tmp21_ = 0;
									glong* _tmp22_;
									gpointer* _tmp23_;
									gint _tmp23__length1;
									_tmp22_ = gee_collection_to_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp21_);
									_tmp23_ = (gpointer*) _tmp22_;
									_tmp23__length1 = _tmp21_;
									if (result_length1) {
										*result_length1 = _tmp23__length1;
									}
									result = _tmp23_;
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										gint _tmp24_ = 0;
										gulong* _tmp25_;
										gpointer* _tmp26_;
										gint _tmp26__length1;
										_tmp25_ = gee_collection_to_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp24_);
										_tmp26_ = (gpointer*) _tmp25_;
										_tmp26__length1 = _tmp24_;
										if (result_length1) {
											*result_length1 = _tmp26__length1;
										}
										result = _tmp26_;
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											gint _tmp27_ = 0;
											gfloat** _tmp28_;
											gpointer* _tmp29_;
											gint _tmp29__length1;
											_tmp28_ = gee_collection_to_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp27_);
											_tmp29_ = (gpointer*) _tmp28_;
											_tmp29__length1 = _tmp27_;
											if (result_length1) {
												*result_length1 = _tmp29__length1;
											}
											result = _tmp29_;
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												gint _tmp30_ = 0;
												gdouble** _tmp31_;
												gpointer* _tmp32_;
												gint _tmp32__length1;
												_tmp31_ = gee_collection_to_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp30_);
												_tmp32_ = (gpointer*) _tmp31_;
												_tmp32__length1 = _tmp30_;
												if (result_length1) {
													*result_length1 = _tmp32__length1;
												}
												result = _tmp32_;
												return result;
											} else {
												gboolean _tmp33_ = FALSE;
												if (G_TYPE_IS_ENUM (t)) {
													_tmp33_ = TRUE;
												} else {
													_tmp33_ = G_TYPE_IS_FLAGS (t);
												}
												if (_tmp33_) {
													gint _tmp34_ = 0;
													gint* _tmp35_;
													gpointer* _tmp36_;
													gint _tmp36__length1;
													_tmp35_ = gee_collection_to_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp34_);
													_tmp36_ = (gpointer*) _tmp35_;
													_tmp36__length1 = _tmp34_;
													if (result_length1) {
														*result_length1 = _tmp36__length1;
													}
													result = _tmp36_;
													return result;
												} else {
													gpointer* array = NULL;
													gint _tmp37_;
													gint _tmp38_;
													gpointer* _tmp39_;
													gint array_length1;
													gint _array_size_;
													gint index = 0;
													gpointer* _tmp47_;
													gint _tmp47__length1;
													_tmp37_ = gee_collection_get_size (self);
													_tmp38_ = _tmp37_;
													_tmp39_ = g_new0 (gpointer, _tmp38_);
													array = _tmp39_;
													array_length1 = _tmp38_;
													_array_size_ = array_length1;
													index = 0;
													{
														GeeIterator* _element_it = NULL;
														GeeIterator* _tmp40_;
														_tmp40_ = gee_iterable_iterator ((GeeIterable*) self);
														_element_it = _tmp40_;
														while (TRUE) {
															GeeIterator* _tmp41_;
															gpointer element = NULL;
															GeeIterator* _tmp42_;
															gpointer _tmp43_;
															gpointer* _tmp44_;
															gint _tmp44__length1;
															gint _tmp45_;
															gpointer _tmp46_;
															_tmp41_ = _element_it;
															if (!gee_iterator_next (_tmp41_)) {
																break;
															}
															_tmp42_ = _element_it;
															_tmp43_ = gee_iterator_get (_tmp42_);
															element = _tmp43_;
															_tmp44_ = array;
															_tmp44__length1 = array_length1;
															_tmp45_ = index;
															index = _tmp45_ + 1;
															_tmp46_ = element;
															element = NULL;
															((_tmp44_[_tmp45_] == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_tmp44_[_tmp45_] = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (_tmp44_[_tmp45_]), NULL));
															_tmp44_[_tmp45_] = _tmp46_;
															((element == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (element = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (element), NULL));
														}
														_g_object_unref0 (_element_it);
													}
													_tmp47_ = array;
													_tmp47__length1 = array_length1;
													if (result_length1) {
														*result_length1 = _tmp47__length1;
													}
													result = _tmp47_;
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gpointer*
gee_collection_to_array (GeeCollection* self,
                         gint* result_length1)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->to_array) {
		return _iface_->to_array (self, result_length1);
	}
	return NULL;
}

/**
 * Adds all items in the input array to this collection.
 *
 * @param array the array which items will be added to this
 *              collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
gee_collection_real_add_all_array (GeeCollection* self,
                                   gpointer* array,
                                   gint array_length1)
{
	GType t = 0UL;
	gboolean result;
	t = GEE_COLLECTION_GET_INTERFACE (self)->get_g_type (self);
	if (t == G_TYPE_BOOLEAN) {
		result = gee_collection_add_all_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gboolean*) array, (gint) array_length1);
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			result = gee_collection_add_all_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gchar*) array, (gint) array_length1);
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				result = gee_collection_add_all_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guchar*) array, (gint) array_length1);
				return result;
			} else {
				if (t == G_TYPE_INT) {
					result = gee_collection_add_all_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint*) array, (gint) array_length1);
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						result = gee_collection_add_all_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guint*) array, (gint) array_length1);
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							result = gee_collection_add_all_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint64**) array, (gint) array_length1);
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								result = gee_collection_add_all_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guint64**) array, (gint) array_length1);
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									result = gee_collection_add_all_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (glong*) array, (gint) array_length1);
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										result = gee_collection_add_all_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gulong*) array, (gint) array_length1);
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											result = gee_collection_add_all_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gfloat**) array, (gint) array_length1);
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												result = gee_collection_add_all_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gdouble**) array, (gint) array_length1);
												return result;
											} else {
												gboolean _tmp0_ = FALSE;
												if (G_TYPE_IS_ENUM (t)) {
													_tmp0_ = TRUE;
												} else {
													_tmp0_ = G_TYPE_IS_FLAGS (t);
												}
												if (_tmp0_) {
													result = gee_collection_add_all_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint*) array, (gint) array_length1);
													return result;
												} else {
													gboolean changed = FALSE;
													changed = FALSE;
													{
														gpointer* item_collection = NULL;
														gint item_collection_length1 = 0;
														gint _item_collection_size_ = 0;
														gint item_it = 0;
														item_collection = array;
														item_collection_length1 = array_length1;
														for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
															gconstpointer item = NULL;
															item = item_collection[item_it];
															{
																gconstpointer _tmp1_;
																_tmp1_ = item;
																changed |= gee_collection_add (self, _tmp1_);
															}
														}
													}
													result = changed;
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gboolean
gee_collection_add_all_array (GeeCollection* self,
                              gpointer* array,
                              gint array_length1)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->add_all_array) {
		return _iface_->add_all_array (self, array, array_length1);
	}
	return FALSE;
}

/**
 * Returns ``true`` it this collection contains all items as the input
 * array.
 *
 * @param array the array which items will be compared with
 *              this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
gee_collection_real_contains_all_array (GeeCollection* self,
                                        gpointer* array,
                                        gint array_length1)
{
	GType t = 0UL;
	gboolean result;
	t = GEE_COLLECTION_GET_INTERFACE (self)->get_g_type (self);
	if (t == G_TYPE_BOOLEAN) {
		result = gee_collection_contains_all_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gboolean*) array, (gint) array_length1);
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			result = gee_collection_contains_all_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gchar*) array, (gint) array_length1);
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				result = gee_collection_contains_all_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guchar*) array, (gint) array_length1);
				return result;
			} else {
				if (t == G_TYPE_INT) {
					result = gee_collection_contains_all_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint*) array, (gint) array_length1);
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						result = gee_collection_contains_all_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guint*) array, (gint) array_length1);
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							result = gee_collection_contains_all_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint64**) array, (gint) array_length1);
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								result = gee_collection_contains_all_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guint64**) array, (gint) array_length1);
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									result = gee_collection_contains_all_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (glong*) array, (gint) array_length1);
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										result = gee_collection_contains_all_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gulong*) array, (gint) array_length1);
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											result = gee_collection_contains_all_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gfloat**) array, (gint) array_length1);
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												result = gee_collection_contains_all_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gdouble**) array, (gint) array_length1);
												return result;
											} else {
												gboolean _tmp0_ = FALSE;
												if (G_TYPE_IS_ENUM (t)) {
													_tmp0_ = TRUE;
												} else {
													_tmp0_ = G_TYPE_IS_FLAGS (t);
												}
												if (_tmp0_) {
													result = gee_collection_contains_all_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint*) array, (gint) array_length1);
													return result;
												} else {
													{
														gpointer* item_collection = NULL;
														gint item_collection_length1 = 0;
														gint _item_collection_size_ = 0;
														gint item_it = 0;
														item_collection = array;
														item_collection_length1 = array_length1;
														for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
															gconstpointer item = NULL;
															item = item_collection[item_it];
															{
																gconstpointer _tmp1_;
																_tmp1_ = item;
																if (!gee_collection_contains (self, _tmp1_)) {
																	result = FALSE;
																	return result;
																}
															}
														}
													}
													result = TRUE;
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gboolean
gee_collection_contains_all_array (GeeCollection* self,
                                   gpointer* array,
                                   gint array_length1)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->contains_all_array) {
		return _iface_->contains_all_array (self, array, array_length1);
	}
	return FALSE;
}

/**
 * Removes the subset of items in this collection corresponding to the
 * elements in the input array. If there is several occurrences of
 * the same value in this collection they are decremented of the number
 * of occurrences in the input array.
 *
 * @param array the array which items will be compared with
 *              this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean
gee_collection_real_remove_all_array (GeeCollection* self,
                                      gpointer* array,
                                      gint array_length1)
{
	GType t = 0UL;
	gboolean result;
	t = GEE_COLLECTION_GET_INTERFACE (self)->get_g_type (self);
	if (t == G_TYPE_BOOLEAN) {
		result = gee_collection_remove_all_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gboolean*) array, (gint) array_length1);
		return result;
	} else {
		if (t == G_TYPE_CHAR) {
			result = gee_collection_remove_all_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gchar*) array, (gint) array_length1);
			return result;
		} else {
			if (t == G_TYPE_UCHAR) {
				result = gee_collection_remove_all_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guchar*) array, (gint) array_length1);
				return result;
			} else {
				if (t == G_TYPE_INT) {
					result = gee_collection_remove_all_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint*) array, (gint) array_length1);
					return result;
				} else {
					if (t == G_TYPE_UINT) {
						result = gee_collection_remove_all_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guint*) array, (gint) array_length1);
						return result;
					} else {
						if (t == G_TYPE_INT64) {
							result = gee_collection_remove_all_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint64**) array, (gint) array_length1);
							return result;
						} else {
							if (t == G_TYPE_UINT64) {
								result = gee_collection_remove_all_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (guint64**) array, (gint) array_length1);
								return result;
							} else {
								if (t == G_TYPE_LONG) {
									result = gee_collection_remove_all_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (glong*) array, (gint) array_length1);
									return result;
								} else {
									if (t == G_TYPE_ULONG) {
										result = gee_collection_remove_all_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gulong*) array, (gint) array_length1);
										return result;
									} else {
										if (t == G_TYPE_FLOAT) {
											result = gee_collection_remove_all_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gfloat**) array, (gint) array_length1);
											return result;
										} else {
											if (t == G_TYPE_DOUBLE) {
												result = gee_collection_remove_all_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gdouble**) array, (gint) array_length1);
												return result;
											} else {
												gboolean _tmp0_ = FALSE;
												if (G_TYPE_IS_ENUM (t)) {
													_tmp0_ = TRUE;
												} else {
													_tmp0_ = G_TYPE_IS_FLAGS (t);
												}
												if (_tmp0_) {
													result = gee_collection_remove_all_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), (gint*) array, (gint) array_length1);
													return result;
												} else {
													gboolean changed = FALSE;
													changed = FALSE;
													{
														gpointer* item_collection = NULL;
														gint item_collection_length1 = 0;
														gint _item_collection_size_ = 0;
														gint item_it = 0;
														item_collection = array;
														item_collection_length1 = array_length1;
														for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
															gconstpointer item = NULL;
															item = item_collection[item_it];
															{
																gconstpointer _tmp1_;
																_tmp1_ = item;
																changed |= gee_collection_remove (self, _tmp1_);
															}
														}
													}
													result = changed;
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gboolean
gee_collection_remove_all_array (GeeCollection* self,
                                 gpointer* array,
                                 gint array_length1)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->remove_all_array) {
		return _iface_->remove_all_array (self, array, array_length1);
	}
	return FALSE;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GeeCollection* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda37_ (Block5Data* _data5_,
             gpointer val)
{
	GeeCollection* self;
	gboolean result;
	self = _data5_->self;
	_data5_->changed |= gee_collection_add (self, val);
	result = TRUE;
	((val == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (val = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (val), NULL));
	return result;
}

static gboolean
___lambda37__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda37_ (self, g);
	return result;
}

static gboolean
gee_collection_real_add_all_iterator (GeeCollection* self,
                                      GeeIterator* iter)
{
	Block5Data* _data5_;
	gboolean result;
	g_return_val_if_fail (iter != NULL, FALSE);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->changed = FALSE;
	gee_traversable_foreach ((GeeTraversable*) iter, ___lambda37__gee_forall_func, _data5_);
	result = _data5_->changed;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

gboolean
gee_collection_add_all_iterator (GeeCollection* self,
                                 GeeIterator* iter)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->add_all_iterator) {
		return _iface_->add_all_iterator (self, iter);
	}
	return FALSE;
}

static gboolean
__lambda38_ (GeeCollection* self,
             gpointer val)
{
	gboolean result;
	result = gee_collection_contains (self, val);
	((val == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (val = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (val), NULL));
	return result;
}

static gboolean
___lambda38__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda38_ ((GeeCollection*) self, g);
	return result;
}

static gboolean
gee_collection_real_contains_all_iterator (GeeCollection* self,
                                           GeeIterator* iter)
{
	gboolean result;
	g_return_val_if_fail (iter != NULL, FALSE);
	result = gee_traversable_foreach ((GeeTraversable*) iter, ___lambda38__gee_forall_func, self);
	return result;
}

gboolean
gee_collection_contains_all_iterator (GeeCollection* self,
                                      GeeIterator* iter)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->contains_all_iterator) {
		return _iface_->contains_all_iterator (self, iter);
	}
	return FALSE;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GeeCollection* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
__lambda39_ (Block6Data* _data6_,
             gpointer val)
{
	GeeCollection* self;
	gboolean result;
	self = _data6_->self;
	_data6_->changed |= gee_collection_remove (self, val);
	result = TRUE;
	((val == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (val = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (val), NULL));
	return result;
}

static gboolean
___lambda39__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda39_ (self, g);
	return result;
}

static gboolean
gee_collection_real_remove_all_iterator (GeeCollection* self,
                                         GeeIterator* iter)
{
	Block6Data* _data6_;
	gboolean result;
	g_return_val_if_fail (iter != NULL, FALSE);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->changed = FALSE;
	result = gee_traversable_foreach ((GeeTraversable*) iter, ___lambda39__gee_forall_func, _data6_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

gboolean
gee_collection_remove_all_iterator (GeeCollection* self,
                                    GeeIterator* iter)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->remove_all_iterator) {
		return _iface_->remove_all_iterator (self, iter);
	}
	return FALSE;
}

/**
 * Returns an immutable empty collection.
 *
 * @return an immutable empty collection
 */
GeeCollection*
gee_collection_empty (GType g_type,
                      GBoxedCopyFunc g_dup_func,
                      GDestroyNotify g_destroy_func)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* result;
	_tmp0_ = gee_hash_set_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GeeCollection*) _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gboolean*
gee_collection_to_bool_array (GeeCollection* coll,
                              gint* result_length1)
{
	gboolean* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gboolean* _tmp10_;
	gint _tmp10__length1;
	gboolean* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean element = FALSE;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gboolean* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gboolean _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gboolean) ((gintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gchar*
gee_collection_to_char_array (GeeCollection* coll,
                              gint* result_length1)
{
	gchar* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gchar* _tmp10_;
	gint _tmp10__length1;
	gchar* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gchar element = '\0';
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gchar* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gchar _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gchar) ((gintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static guchar*
gee_collection_to_uchar_array (GeeCollection* coll,
                               gint* result_length1)
{
	guchar* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guchar* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	guchar* _tmp10_;
	gint _tmp10__length1;
	guchar* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (guchar, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			guchar element = '\0';
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			guchar* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			guchar _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (guchar) ((guintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gint*
gee_collection_to_int_array (GeeCollection* coll,
                             gint* result_length1)
{
	gint* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gint, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gint element = 0;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gint* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gint _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gint) ((gintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static guint*
gee_collection_to_uint_array (GeeCollection* coll,
                              gint* result_length1)
{
	guint* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guint* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	guint* _tmp10_;
	gint _tmp10__length1;
	guint* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (guint, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			guint element = 0U;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			guint* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			guint _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (guint) ((guintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gint64**
gee_collection_to_int64_array (GeeCollection* coll,
                               gint* result_length1)
{
	gint64** array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint64** _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gint64** _tmp10_;
	gint _tmp10__length1;
	gint64** result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gint64*, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gint64* element = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gint64** _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gint64* _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gint64*) _tmp6_;
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			element = NULL;
			_g_free0 (_tmp7_[_tmp8_]);
			_tmp7_[_tmp8_] = _tmp9_;
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static guint64**
gee_collection_to_uint64_array (GeeCollection* coll,
                                gint* result_length1)
{
	guint64** array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	guint64** _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	guint64** _tmp10_;
	gint _tmp10__length1;
	guint64** result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (guint64*, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			guint64* element = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			guint64** _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			guint64* _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (guint64*) _tmp6_;
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			element = NULL;
			_g_free0 (_tmp7_[_tmp8_]);
			_tmp7_[_tmp8_] = _tmp9_;
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static glong*
gee_collection_to_long_array (GeeCollection* coll,
                              gint* result_length1)
{
	glong* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	glong* _tmp10_;
	gint _tmp10__length1;
	glong* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (glong, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			glong element = 0L;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			glong* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			glong _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (glong) ((gintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gulong*
gee_collection_to_ulong_array (GeeCollection* coll,
                               gint* result_length1)
{
	gulong* array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gulong* _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gulong* _tmp10_;
	gint _tmp10__length1;
	gulong* result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gulong, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gulong element = 0UL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gulong* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gulong _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gulong) ((guintptr) _tmp6_);
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			_tmp7_[_tmp8_] = _tmp9_;
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gfloat**
gee_collection_to_float_array (GeeCollection* coll,
                               gint* result_length1)
{
	gfloat** array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gfloat** _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gfloat** _tmp10_;
	gint _tmp10__length1;
	gfloat** result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gfloat*, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gfloat* element = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gfloat** _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gfloat* _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gfloat*) _tmp6_;
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			element = NULL;
			_g_free0 (_tmp7_[_tmp8_]);
			_tmp7_[_tmp8_] = _tmp9_;
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gdouble**
gee_collection_to_double_array (GeeCollection* coll,
                                gint* result_length1)
{
	gdouble** array = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gdouble** _tmp2_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gdouble** _tmp10_;
	gint _tmp10__length1;
	gdouble** result;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = gee_collection_get_size (coll);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gdouble*, _tmp1_);
	array = _tmp2_;
	array_length1 = _tmp1_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) coll);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gdouble* element = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gdouble** _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			gdouble* _tmp9_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gdouble*) _tmp6_;
			_tmp7_ = array;
			_tmp7__length1 = array_length1;
			_tmp8_ = index;
			index = _tmp8_ + 1;
			_tmp9_ = element;
			element = NULL;
			_g_free0 (_tmp7_[_tmp8_]);
			_tmp7_[_tmp8_] = _tmp9_;
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static gboolean
gee_collection_add_all_bool_array (GeeCollection* coll,
                                   gboolean* arr,
                                   gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gboolean* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gboolean el = FALSE;
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_char_array (GeeCollection* coll,
                                   gchar* arr,
                                   gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gchar* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gchar el = '\0';
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_uchar_array (GeeCollection* coll,
                                    guchar* arr,
                                    gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		guchar* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guchar el = '\0';
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((guintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_int_array (GeeCollection* coll,
                                  gint* arr,
                                  gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gint* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gint el = 0;
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_uint_array (GeeCollection* coll,
                                   guint* arr,
                                   gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		guint* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guint el = 0U;
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((guintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_int64_array (GeeCollection* coll,
                                    gint64** arr,
                                    gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gint64** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gint64* el = NULL;
			el = el_collection[el_it];
			{
				gint64* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_add (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_uint64_array (GeeCollection* coll,
                                     guint64** arr,
                                     gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		guint64** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guint64* el = NULL;
			el = el_collection[el_it];
			{
				guint64* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_add (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_long_array (GeeCollection* coll,
                                   glong* arr,
                                   gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		glong* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			glong el = 0L;
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_ulong_array (GeeCollection* coll,
                                    gulong* arr,
                                    gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gulong* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gulong el = 0UL;
			el = el_collection[el_it];
			{
				changed |= gee_collection_add (coll, (gpointer) ((guintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_float_array (GeeCollection* coll,
                                    gfloat** arr,
                                    gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gfloat** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gfloat* el = NULL;
			el = el_collection[el_it];
			{
				gfloat* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_add (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_add_all_double_array (GeeCollection* coll,
                                     gdouble** arr,
                                     gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gdouble** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gdouble* el = NULL;
			el = el_collection[el_it];
			{
				gdouble* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_add (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_contains_all_bool_array (GeeCollection* coll,
                                        gboolean* arr,
                                        gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gboolean* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gboolean el = FALSE;
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((gintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_char_array (GeeCollection* coll,
                                        gchar* arr,
                                        gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gchar* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gchar el = '\0';
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((gintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_uchar_array (GeeCollection* coll,
                                         guchar* arr,
                                         gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		guchar* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guchar el = '\0';
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((guintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_int_array (GeeCollection* coll,
                                       gint* arr,
                                       gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gint* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gint el = 0;
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((gintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_uint_array (GeeCollection* coll,
                                        guint* arr,
                                        gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		guint* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guint el = 0U;
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((guintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_int64_array (GeeCollection* coll,
                                         gint64** arr,
                                         gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gint64** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gint64* el = NULL;
			el = el_collection[el_it];
			{
				gint64* _tmp0_;
				_tmp0_ = el;
				if (!gee_collection_contains (coll, _tmp0_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_uint64_array (GeeCollection* coll,
                                          guint64** arr,
                                          gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		guint64** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guint64* el = NULL;
			el = el_collection[el_it];
			{
				guint64* _tmp0_;
				_tmp0_ = el;
				if (!gee_collection_contains (coll, _tmp0_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_long_array (GeeCollection* coll,
                                        glong* arr,
                                        gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		glong* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			glong el = 0L;
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((gintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_ulong_array (GeeCollection* coll,
                                         gulong* arr,
                                         gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gulong* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gulong el = 0UL;
			el = el_collection[el_it];
			{
				if (!gee_collection_contains (coll, (gpointer) ((guintptr) el))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_float_array (GeeCollection* coll,
                                         gfloat** arr,
                                         gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gfloat** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gfloat* el = NULL;
			el = el_collection[el_it];
			{
				gfloat* _tmp0_;
				_tmp0_ = el;
				if (!gee_collection_contains (coll, _tmp0_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_contains_all_double_array (GeeCollection* coll,
                                          gdouble** arr,
                                          gint arr_length1)
{
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	{
		gdouble** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gdouble* el = NULL;
			el = el_collection[el_it];
			{
				gdouble* _tmp0_;
				_tmp0_ = el;
				if (!gee_collection_contains (coll, _tmp0_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gee_collection_remove_all_bool_array (GeeCollection* coll,
                                      gboolean* arr,
                                      gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gboolean* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gboolean el = FALSE;
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_char_array (GeeCollection* coll,
                                      gchar* arr,
                                      gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gchar* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gchar el = '\0';
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_uchar_array (GeeCollection* coll,
                                       guchar* arr,
                                       gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		guchar* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guchar el = '\0';
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((guintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_int_array (GeeCollection* coll,
                                     gint* arr,
                                     gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gint* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gint el = 0;
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_uint_array (GeeCollection* coll,
                                      guint* arr,
                                      gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		guint* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guint el = 0U;
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((guintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_int64_array (GeeCollection* coll,
                                       gint64** arr,
                                       gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gint64** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gint64* el = NULL;
			el = el_collection[el_it];
			{
				gint64* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_remove (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_uint64_array (GeeCollection* coll,
                                        guint64** arr,
                                        gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		guint64** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			guint64* el = NULL;
			el = el_collection[el_it];
			{
				guint64* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_remove (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_long_array (GeeCollection* coll,
                                      glong* arr,
                                      gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		glong* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			glong el = 0L;
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((gintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_ulong_array (GeeCollection* coll,
                                       gulong* arr,
                                       gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gulong* el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gulong el = 0UL;
			el = el_collection[el_it];
			{
				changed |= gee_collection_remove (coll, (gpointer) ((guintptr) el));
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_float_array (GeeCollection* coll,
                                       gfloat** arr,
                                       gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gfloat** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gfloat* el = NULL;
			el = el_collection[el_it];
			{
				gfloat* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_remove (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

static gboolean
gee_collection_remove_all_double_array (GeeCollection* coll,
                                        gdouble** arr,
                                        gint arr_length1)
{
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (coll != NULL, FALSE);
	changed = FALSE;
	{
		gdouble** el_collection = NULL;
		gint el_collection_length1 = 0;
		gint _el_collection_size_ = 0;
		gint el_it = 0;
		el_collection = arr;
		el_collection_length1 = arr_length1;
		for (el_it = 0; el_it < el_collection_length1; el_it = el_it + 1) {
			gdouble* el = NULL;
			el = el_collection[el_it];
			{
				gdouble* _tmp0_;
				_tmp0_ = el;
				changed |= gee_collection_remove (coll, _tmp0_);
			}
		}
	}
	result = changed;
	return result;
}

gint
gee_collection_get_size (GeeCollection* self)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_size) {
		return _iface_->get_size (self);
	}
	return -1;
}

gboolean
gee_collection_get_is_empty (GeeCollection* self)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_is_empty) {
		return _iface_->get_is_empty (self);
	}
	return FALSE;
}

static gboolean
gee_collection_real_get_is_empty (GeeCollection* base)
{
	gboolean result;
	GeeCollection* self;
	gint _tmp0_;
	gint _tmp1_;
	self = base;
	_tmp0_ = gee_collection_get_size (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == 0;
	return result;
}

gboolean
gee_collection_get_read_only (GeeCollection* self)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_read_only) {
		return _iface_->get_read_only (self);
	}
	return FALSE;
}

GeeCollection*
gee_collection_get_read_only_view (GeeCollection* self)
{
	GeeCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_read_only_view) {
		return _iface_->get_read_only_view (self);
	}
	return NULL;
}

static void
gee_collection_default_init (GeeCollectionIface * iface,
                             gpointer iface_data)
{
	/**
	 * The number of items in this collection.
	 */
	g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this collection can change - i.e. whether {@link add},
	 * {@link remove} etc. are legal operations.
	 */
	g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The read-only view of this collection.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->add_all = gee_collection_real_add_all;
	iface->contains_all = gee_collection_real_contains_all;
	iface->remove_all = gee_collection_real_remove_all;
	iface->retain_all = gee_collection_real_retain_all;
	iface->to_array = gee_collection_real_to_array;
	iface->add_all_array = gee_collection_real_add_all_array;
	iface->contains_all_array = gee_collection_real_contains_all_array;
	iface->remove_all_array = gee_collection_real_remove_all_array;
	iface->add_all_iterator = gee_collection_real_add_all_iterator;
	iface->contains_all_iterator = gee_collection_real_contains_all_iterator;
	iface->remove_all_iterator = gee_collection_real_remove_all_iterator;
	iface->get_is_empty = gee_collection_real_get_is_empty;
}

/**
 * A generic collection of objects.
 */
static GType
gee_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeCollectionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_collection_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_collection_type_id;
	gee_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeCollection", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_collection_type_id, GEE_TYPE_ITERABLE);
	return gee_collection_type_id;
}

GType
gee_collection_get_type (void)
{
	static volatile gsize gee_collection_type_id__once = 0;
	if (g_once_init_enter (&gee_collection_type_id__once)) {
		GType gee_collection_type_id;
		gee_collection_type_id = gee_collection_get_type_once ();
		g_once_init_leave (&gee_collection_type_id__once, gee_collection_type_id);
	}
	return gee_collection_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

