/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.resolution.failure.transform.SourceVariantData;
import org.gradle.internal.component.resolution.failure.transform.TransformData;

public final class TransformationChainData {
    private final SourceVariantData startingVariant;
    private final ImmutableList<TransformData> steps;
    private final ImmutableAttributes finalAttributes;

    public TransformationChainData(SourceVariantData startingVariant, ImmutableList<TransformData> steps, ImmutableAttributes finalAttributes) {
        this.startingVariant = startingVariant;
        this.steps = steps;
        this.finalAttributes = finalAttributes;
    }

    public SourceVariantData getInitialVariant() {
        return this.startingVariant;
    }

    public String summarizeTransformations() {
        return this.steps.stream().map(t -> "'" + t.getTransformName() + "'").collect(Collectors.joining(" -> "));
    }

    public ImmutableList<TransformData> getSteps() {
        return this.steps;
    }

    public ImmutableAttributes getFinalAttributes() {
        return this.finalAttributes;
    }

    public TransformationChainFingerprint fingerprint() {
        return new TransformationChainFingerprint(this);
    }

    public static final class TransformationChainFingerprint {
        private final SourceVariantData startingVariant;
        private final ImmutableSet<TransformData> steps;

        public TransformationChainFingerprint(TransformationChainData chain) {
            this.startingVariant = chain.startingVariant;
            this.steps = ImmutableSet.copyOf((Collection)chain.steps);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformationChainFingerprint that = (TransformationChainFingerprint)o;
            return Objects.equals(this.startingVariant, that.startingVariant) && this.steps.equals(that.steps);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.startingVariant);
            result = 31 * result + this.steps.hashCode();
            return result;
        }
    }
}

