/*  MaitreTarot.
 *  (C) 2002 Yves Mettier <ymettier@libertysurf.fr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <libintl.h>
#define _(a) gettext (a)
#include <stdlib.h>
#include <maitretarot.h>
#include "config_utils.h"

static void
usage ()
{
  g_printerr (_
  ("maitretarot [-h | -- help] [-v | --version] [-p port] [-c filename]\n"));
  g_printerr (_ ("-h, --help\t\tGives this help display.\n"));
  g_printerr (_ ("-v, --version\t\tDisplay program version.\n"));
  g_printerr (_ ("-p port\t\t\tSet the port.\n"));
  g_printerr (_ ("-c filename\t\tUse an alternate configuration file.\n"));
}

gint
conf_update_with_command_line (config_t * conf, int argc, char **argv)
{
  int i;
  args_e prev_arg;

  prev_arg = ARGS_UNSET;
  for (i = 0; i < argc; i++)
  {
    if (prev_arg == ARGS_UNSET)
    {
      if (!strcmp (argv[i], "-h"))
      {
	usage (argv[0]);
	return (-1);
      }
      else if (!strcmp (argv[i], "--help"))
      {
	usage (argv[0]);
	return (-1);
      }
      else if (!strcmp (argv[i], "--version"))
      {
	g_print (VERSION);
	return (-2);
      }
      else if (!strcmp (argv[i], "-v"))
      {
	g_print (VERSION);
	return (-2);
      }
      else if (!strncmp (argv[i], "--port=", sizeof ("--port")))
      {
	conf->port = atoi (&(argv[i][sizeof ("--port")]));
      }
      else if (!strcmp (argv[i], "-p"))
      {
	prev_arg = ARGS_PORT;
      }
    }
    else if (prev_arg == ARGS_PORT)
    {
      conf->port = atoi (argv[i]);
      prev_arg = ARGS_UNSET;
    }
    else
    {
      g_printerr (_ ("This case should never appear"));
    }
  }

  return (0);
}

void
conf_free (config_t * conf)
{
  g_free (conf);
}

config_t *
config_read (int argc, char **argv)
{
  config_t *conf;
  const gchar * key;
  int i;
  const gchar default_config_file_name[] = CONFIGFILENAME;
  const gchar * config_file_name = NULL;

/* Find if a config file name was specified in the command line */
  for (i = 0; i < argc; i++)
  {
    if (!strcmp (argv[i], "-c"))
    {
      i++;
      if (i < argc)
      {
	config_file_name = argv[i];
	break;
      }
      else
      {
	usage (argv[0]);
	return (NULL);
      }
    }
    else if (!strncmp
	     (argv[i], "--config-file-name=",
	      sizeof ("--config-file-name")))
    {
      config_file_name =
	&(argv[i][sizeof ("--config-file-name")]);
      break;
    }
  }
  if (!config_file_name)
    config_file_name = default_config_file_name;

/* Init the config */

  if (!libmt_xmlconfig_init_from_file (config_file_name))
  {
    g_message (_ ("Could not load config file. Using the default one. "));
    if (!libmt_xmlconfig_init_from_string (DEFAULT_CONFIG_STRING))
    {
      g_error (_ ("Could use the default config. Aborting. "));
      return (NULL);
    }
  }
  conf = g_malloc (sizeof (config_t));
  if (!conf)
    g_error (_ ("Not enough memory. Aborting."));


  /* Port */
  conf->port = 0;
  key = libmt_xmlconfig_get_value
    ("/maitretarot/server/port/text()");
  if (key)
    conf->port = atoi (key);
  if (conf->port == 0)
    conf->port = atoi (DEFAULT_CONFIG_SERVER_PORT);

  i = conf_update_with_command_line (conf, argc, argv);
  if (i != 0)
  {
    conf_free (conf);
    return (NULL);
  }
  return (conf);
}

void
config_print (config_t * config)
{
  printf ("\n==========================================\n" "Dump of config_t structure\n" "==========================================\n");
  printf ("port = '%d'\n", config->port);
  printf ("==========================================\n");
}
