/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.google.common.net.HostAndPort;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionExKt;
import com.intellij.openapi.util.Pair;
import com.intellij.python.wsl.PyWSLSocketProvider;
import com.intellij.remote.ProcessControlWithMappings;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.python.debugger.PositionConverterProvider;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.remote.vfs.PyRemotePositionConverter;
import com.jetbrains.python.remote.RemoteProcessControl;
import com.jetbrains.python.run.PythonProcessHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/python/wsl/PyWSLProcessHandler;", "Lcom/jetbrains/python/run/PythonProcessHandler;", "Lcom/intellij/remote/ProcessControlWithMappings;", "Lcom/jetbrains/python/debugger/PositionConverterProvider;", "Lcom/jetbrains/python/remote/RemoteProcessControl;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "wslSocketProvider", "Lcom/intellij/python/wsl/PyWSLSocketProvider;", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "additionalMappings", "Lcom/intellij/util/PathMappingSettings;", "<init>", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/python/wsl/PyWSLSocketProvider;Lcom/intellij/execution/wsl/WSLDistribution;Lcom/intellij/util/PathMappingSettings;)V", "getFileMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "kotlin.jvm.PlatformType", "createPositionConverter", "Lcom/jetbrains/python/debugger/remote/vfs/PyRemotePositionConverter;", "debugProcess", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "getRemoteSocket", "Lcom/intellij/openapi/util/Pair;", "", "", "localPort", "getLocalTunnel", "Lcom/google/common/net/HostAndPort;", "remotePort", "readerOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "intellij.python.wsl"})
public final class PyWSLProcessHandler
extends PythonProcessHandler
implements ProcessControlWithMappings,
PositionConverterProvider,
RemoteProcessControl {
    @NotNull
    private final PyWSLSocketProvider wslSocketProvider;
    @NotNull
    private final WSLDistribution distribution;
    @NotNull
    private final PathMappingSettings additionalMappings;

    public PyWSLProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull PyWSLSocketProvider wslSocketProvider, @NotNull WSLDistribution distribution, @NotNull PathMappingSettings additionalMappings) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)wslSocketProvider, (String)"wslSocketProvider");
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Intrinsics.checkNotNullParameter((Object)additionalMappings, (String)"additionalMappings");
        super(commandLine);
        this.wslSocketProvider = wslSocketProvider;
        this.distribution = distribution;
        this.additionalMappings = additionalMappings;
    }

    @NotNull
    public List<PathMappingSettings.PathMapping> getFileMappings() {
        Collection collection = WslDistributionExKt.getRootMappings((WSLDistribution)this.distribution);
        List list = this.additionalMappings.getPathMappings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathMappings(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public PyRemotePositionConverter createPositionConverter(@NotNull PyDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return new PyRemotePositionConverter(debugProcess, new PathMappingSettings(this.getFileMappings()));
    }

    @NotNull
    public Pair<String, Integer> getRemoteSocket(int localPort) {
        return this.wslSocketProvider.getRemoteSocket(localPort);
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return null;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"BLOCKING");
        return options;
    }
}

