/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.CanonicalFileHashStrategy;
import com.intellij.util.containers.CanonicalPathHashStrategy;
import com.intellij.util.containers.CaseInsensitivePathHashStrategy;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007H\u0007J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u00072\u0014\u0010\u000f\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00070\u0010H\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014H\u0007J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0007J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0007J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0007J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0007J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/containers/FileCollectionFactory;", "", "<init>", "()V", "createCanonicalPathLinkedMap", "", "Ljava/nio/file/Path;", "V", "createCanonicalFilePathLinkedMap", "", "createCanonicalFileMap", "Ljava/io/File;", "createCanonicalPathMap", "expected", "", "map", "", "createCanonicalFileSet", "", "files", "", "createCanonicalPathSet", "createCanonicalLinkedPathSet", "createCaseSensitiveAwarePathSet", "size", "createCanonicalFilePathSet", "createCanonicalFileLinkedSet", "intellij.platform.util.base"})
public final class FileCollectionFactory {
    @NotNull
    public static final FileCollectionFactory INSTANCE = new FileCollectionFactory();

    private FileCollectionFactory() {
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<Path, V> createCanonicalPathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap(CanonicalPathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap(new Hash.Strategy<String>(){

            public int hashCode(String value) {
                return FileUtilRt.pathHashCode((String)value);
            }

            public boolean equals(String val1, String val2) {
                return FileUtilRt.pathsEqual((String)val1, (String)val2);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<File, V> createCanonicalFileMap() {
        return new Object2ObjectOpenCustomHashMap(CanonicalFileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<Path, V> createCanonicalPathMap() {
        return new Object2ObjectOpenCustomHashMap(CanonicalPathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<File, V> createCanonicalFileMap(int expected) {
        return new Object2ObjectOpenCustomHashMap(expected, (Hash.Strategy)CanonicalFileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final <V> Map<File, V> createCanonicalFileMap(@NotNull Map<? extends File, ? extends V> map2) {
        Intrinsics.checkNotNullParameter(map2, "map");
        return new Object2ObjectOpenCustomHashMap<File, V>(map2, (Hash.Strategy)CanonicalFileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> createCanonicalFileSet() {
        return new ObjectOpenCustomHashSet(CanonicalFileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> createCanonicalFileSet(@NotNull Collection<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, "files");
        return new ObjectOpenCustomHashSet<File>(files, (Hash.Strategy)CanonicalFileHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCanonicalPathSet() {
        return new ObjectOpenCustomHashSet(CanonicalPathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCanonicalLinkedPathSet() {
        return new ObjectLinkedOpenCustomHashSet(CanonicalPathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCaseSensitiveAwarePathSet() {
        if (SystemInfoRt.isMac && !SystemInfoRt.isFileSystemCaseSensitive) {
            return new ObjectOpenCustomHashSet(CaseInsensitivePathHashStrategy.INSTANCE);
        }
        return new HashSet();
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCanonicalPathSet(@NotNull Collection<? extends Path> files) {
        Intrinsics.checkNotNullParameter(files, "files");
        return new ObjectOpenCustomHashSet<Path>(files, (Hash.Strategy)CanonicalPathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<Path> createCanonicalPathSet(int size) {
        return new ObjectOpenCustomHashSet(size, (Hash.Strategy)CanonicalPathHashStrategy.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final Set<String> createCanonicalFilePathSet() {
        return new ObjectOpenCustomHashSet<String>(FastUtilHashingStrategies.FILE_PATH_HASH_STRATEGY);
    }

    @JvmStatic
    @NotNull
    public static final Set<File> createCanonicalFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet(CanonicalFileHashStrategy.INSTANCE);
    }
}

