/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMUseElement;
import org.jetbrains.relocated.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.ClipBridge;
import org.jetbrains.relocated.apache.batik.bridge.GVTBuilder;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.ClipRable;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.ShapeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGClipPathElementBridge
extends AnimatableGenericSVGBridge
implements ClipBridge {
    @Override
    public String getLocalName() {
        return "clipPath";
    }

    @Override
    public ClipRable createClip(BridgeContext ctx2, Element clipElement, Element clipedElement, GraphicsNode clipedNode) {
        Filter filter2;
        String s = clipElement.getAttributeNS(null, "transform");
        AffineTransform Tx = s.length() != 0 ? SVGUtilities.convertTransform(clipElement, "transform", s, ctx2) : new AffineTransform();
        s = clipElement.getAttributeNS(null, "clipPathUnits");
        int coordSystemType = s.length() == 0 ? 1 : (int)SVGUtilities.parseCoordinateSystem(clipElement, "clipPathUnits", s, ctx2);
        if (coordSystemType == 2) {
            Tx = SVGUtilities.toObjectBBox(Tx, clipedNode);
        }
        Area clipPath = new Area();
        GVTBuilder builder = ctx2.getGVTBuilder();
        boolean hasChildren = false;
        for (Node node = clipElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node shadowChild;
            Element child;
            GraphicsNode clipNode;
            if (node.getNodeType() != 1 || (clipNode = builder.build(ctx2, child = (Element)node)) == null) continue;
            hasChildren = true;
            if (child instanceof SVGOMUseElement && (shadowChild = ((SVGOMUseElement)child).getCSSFirstChild()) != null && shadowChild.getNodeType() == 1) {
                child = (Element)shadowChild;
            }
            int wr = CSSUtilities.convertClipRule(child);
            GeneralPath path2 = new GeneralPath(clipNode.getOutline());
            path2.setWindingRule(wr);
            AffineTransform at = clipNode.getTransform();
            if (at == null) {
                at = Tx;
            } else {
                at.preConcatenate(Tx);
            }
            Shape outline = at.createTransformedShape(path2);
            ShapeNode outlineNode = new ShapeNode();
            outlineNode.setShape(outline);
            ClipRable clip = CSSUtilities.convertClipPath(child, outlineNode, ctx2);
            if (clip != null) {
                Area area2 = new Area(outline);
                area2.subtract(new Area(clip.getClipPath()));
                outline = area2;
            }
            clipPath.add(new Area(outline));
        }
        if (!hasChildren) {
            return null;
        }
        ShapeNode clipPathNode = new ShapeNode();
        clipPathNode.setShape(clipPath);
        ClipRable clipElementClipPath = CSSUtilities.convertClipPath(clipElement, clipPathNode, ctx2);
        if (clipElementClipPath != null) {
            clipPath.subtract(new Area(clipElementClipPath.getClipPath()));
        }
        if ((filter2 = clipedNode.getFilter()) == null) {
            filter2 = clipedNode.getGraphicsNodeRable(true);
        }
        boolean useAA = false;
        RenderingHints hints = CSSUtilities.convertShapeRendering(clipElement, null);
        if (hints != null) {
            Object o = hints.get(RenderingHints.KEY_ANTIALIASING);
            useAA = o == RenderingHints.VALUE_ANTIALIAS_ON;
        }
        return new ClipRable8Bit(filter2, clipPath, useAA);
    }
}

