/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteTransfer {
    private static final Logger LOG = Logger.getInstance(RemoteTransfer.class);
    private static final String VERSION_FILE = "build.txt";
    public static final String UPLOAD_HELPERS_ID_PREFIX = "UploadHelpers";
    @Nullable
    private final Project myProject;
    private final ConnectionOwner myConnectionOwner;
    private final HelpersTransferConfig myHelpersTransferConfig;
    private boolean myTransferTaskModal;

    protected RemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull HelpersTransferConfig helpersTransferConfig) {
        if (helpersTransferConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(0);
        }
        this.myTransferTaskModal = true;
        this.myProject = project;
        this.myConnectionOwner = ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project, (Component)component);
        this.myHelpersTransferConfig = helpersTransferConfig;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public HelpersTransferConfig getHelpersTransferConfig() {
        HelpersTransferConfig helpersTransferConfig = this.myHelpersTransferConfig;
        if (helpersTransferConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(1);
        }
        return helpersTransferConfig;
    }

    protected void uploadHelpers(boolean uploadOnSnapshot, @NotNull Collection<String> helpersPaths, @NotNull String remoteHelperPath, @NotNull @NlsContexts.DialogTitle String title) {
        if (helpersPaths == null) {
            RemoteTransfer.$$$reportNull$$$0(2);
        }
        if (remoteHelperPath == null) {
            RemoteTransfer.$$$reportNull$$$0(3);
        }
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(4);
        }
        if (this.myHelpersTransferConfig.isHelpersVersionChecked() && !uploadOnSnapshot) {
            return;
        }
        LOG.info("Uploading helpers to " + remoteHelperPath);
        this.createTask(this.myProject, title, false, indicator -> this.doCopyHelpers(indicator, title, uploadOnSnapshot, helpersPaths, remoteHelperPath)).queue();
    }

    @NotNull
    protected Task createTask(@Nullable Project project, @NotNull @NlsContexts.DialogTitle String title, boolean canBeCancelled, final @NotNull Progressive progressive) {
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(5);
        }
        if (progressive == null) {
            RemoteTransfer.$$$reportNull$$$0(6);
        }
        if (this.isTransferTaskModal()) {
            return new Task.Modal(project, title, canBeCancelled){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    progressive.run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$1", "run"));
                }
            };
        }
        return new Task.Backgroundable(project, title, canBeCancelled){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                progressive.run(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/RemoteTransfer$2", "run"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyHelpers(ProgressIndicator indicator, String title, boolean uploadOnSnapshot, Collection<String> helpersPaths, String remoteHelperPath) {
        CredentialsDeployable deployable = new CredentialsDeployable((RemoteCredentials)new RemoteCredentialsHolder());
        deployable.setId(UPLOAD_HELPERS_ID_PREFIX + String.valueOf((Object)deployable));
        this.myHelpersTransferConfig.createFileTransferConfig(deployable);
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        RemoteConnection connection = null;
        try {
            indicator.setFraction(0.0);
            connection = this.openConnection(title, (Deployable)deployable, indicator);
            RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, (Deployable)deployable);
            context.setPromptForOverwrite(true);
            if (RemoteTransfer.helpersUpdateNeeded(indicator, connection, this.getHelpersTransferConfig().getHelpersPath(), uploadOnSnapshot)) {
                context.getConfig().setPathMappings(deployable.getId(), RemoteTransfer.createMapping(helpersPaths, remoteHelperPath));
                context.getConfig().setExcludedPaths(deployable.getId(), new ArrayList());
                try {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles((ExecutionContext)context, (Collection)ContainerUtil.map(helpersPaths, arg_0 -> ((LocalFileSystem)LocalFileSystem.getInstance()).findFileByPath(arg_0)));
                    ArrayList<TransferOperation> operations = new ArrayList<TransferOperation>(resultWithErrors.operations);
                    operations.add(RemoteTransfer.writeHelpersVersion(connection, this.getHelpersTransferConfig().getHelpersPath()));
                    RemoteTransfer.executeOperationsBatch(indicator, context, operations);
                }
                catch (ProcessCanceledException cancelled) {
                    throw cancelled;
                }
                catch (Exception e) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        LOG.warn("Can't copy helpers", (Throwable)e);
                        Messages.showErrorDialog((String)e.getMessage(), (String)RemoteSdkBundle.message("dialog.title.error.copying.helpers", new Object[0]));
                    });
                }
            }
            LOG.info("Helpers upload successfully completed");
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        this.myHelpersTransferConfig.setHelpersVersionChecked(true);
        snapshot.logResponsivenessSinceCreation("Helpers uploaded");
    }

    protected final RemoteConnection openConnection(@NotNull String title, @NotNull Deployable webServerConfig, @Nullable ProgressIndicator indicator) throws FileSystemException {
        if (title == null) {
            RemoteTransfer.$$$reportNull$$$0(7);
        }
        if (webServerConfig == null) {
            RemoteTransfer.$$$reportNull$$$0(8);
        }
        return RemoteConnectionManager.getInstance().openConnection(this.myConnectionOwner, title, (Connectable)webServerConfig, FileTransferConfig.Origin.Default, null, indicator);
    }

    protected RemoteSdkExecutionContext getRemoteSdkExecutionContext(@NotNull ProgressIndicator indicator, @NotNull RemoteConnection connection, @NotNull Deployable deployable) {
        if (indicator == null) {
            RemoteTransfer.$$$reportNull$$$0(9);
        }
        if (connection == null) {
            RemoteTransfer.$$$reportNull$$$0(10);
        }
        if (deployable == null) {
            RemoteTransfer.$$$reportNull$$$0(11);
        }
        return new RemoteSdkExecutionContext(this.myProject, indicator, deployable, connection);
    }

    private static boolean helpersUpdateNeeded(ProgressIndicator indicator, RemoteConnection connection, String helpersPath, boolean updateOnSnapshot) throws FileSystemException {
        FileObject versionFile = RemoteTransfer.getVersionFileObject(connection, helpersPath);
        connection.resolveRoot().resolveFile(RemoteFile.createRemoteFile((String)helpersPath, (String)VERSION_FILE).getPath());
        try {
            String content = new String(FileTransferUtil.getContent((FileObject)versionFile, (ProgressIndicator)indicator), StandardCharsets.UTF_8);
            String localContent = RemoteTransfer.getLocalVersion();
            LOG.info("Remote helpers version is " + content + ", local helpers version is " + localContent);
            if (!content.isEmpty()) {
                return !localContent.equals(content) || localContent.endsWith(".SNAPSHOT") && updateOnSnapshot;
            }
        }
        catch (IOException e) {
            LOG.info("Failed to retrieve helpers version file", (Throwable)e);
        }
        return true;
    }

    private static String getLocalVersion() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    private static TransferOperation writeHelpersVersion(RemoteConnection connection, String helpersPath) throws FileSystemException {
        final FileObject target = RemoteTransfer.getVersionFileObject(connection, helpersPath);
        return new TransferOperation(){

            @NlsContexts.ProgressText
            public String getProgressText(ExecutionContext context) {
                return RemoteSdkBundle.message("progress.text.writing.version.file", new Object[0]);
            }

            @NlsContexts.ProgressDetails
            public String getDetailedText(ExecutionContext context) {
                return RemoteSdkBundle.message("writing.to.0", target.getName());
            }

            public void execute(ExecutionContext context) throws FileSystemException {
                if (!target.exists()) {
                    target.createFile();
                }
                try (PrintWriter pw = new PrintWriter(target.getContent().getOutputStream(), false, StandardCharsets.UTF_8);){
                    pw.print(RemoteTransfer.getLocalVersion());
                }
            }

            @NlsContexts.DialogMessage
            @NotNull
            public String getErrorMessage(ExecutionContext context, @NlsContexts.DialogMessage @NotNull String reason) {
                if (reason == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = RemoteSdkBundle.message("can.t.write.helpers.version", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void onLocalMove(FileObject sourceFrom, FileObject sourceTo) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reason";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteTransfer$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteTransfer$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getErrorMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getErrorMessage";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static FileObject getVersionFileObject(RemoteConnection connection, String helpersPath) throws FileSystemException {
        return connection.resolveRoot().resolveFile(helpersPath).resolveFile(VERSION_FILE);
    }

    private static List<DeploymentPathMapping> createMapping(Collection<String> paths, String remotePath) {
        return ContainerUtil.map(paths, path -> {
            DeploymentPathMapping mapping = new DeploymentPathMapping();
            mapping.setLocalPath(path);
            mapping.setDeployPath(remotePath);
            return mapping;
        });
    }

    protected static void executeOperationsBatch(@NotNull ProgressIndicator indicator, @NotNull RemoteSdkExecutionContext context, @NotNull List<? extends TransferOperation> operations) throws FileSystemException {
        if (indicator == null) {
            RemoteTransfer.$$$reportNull$$$0(12);
        }
        if (operations == null) {
            RemoteTransfer.$$$reportNull$$$0(13);
        }
        if (context == null) {
            RemoteTransfer.$$$reportNull$$$0(14);
        }
        int complete = 0;
        for (TransferOperation transferOperation : operations) {
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(transferOperation.getProgressText((ExecutionContext)context));
            transferOperation.execute((ExecutionContext)context);
            indicator.setFraction((double)(++complete) / (double)operations.size());
        }
    }

    protected String @NotNull [] getAdditionalExcludePatterns() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            RemoteTransfer.$$$reportNull$$$0(15);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public boolean isTransferTaskModal() {
        return this.myTransferTaskModal;
    }

    public void setTransferTaskModal(boolean transferTaskModal) {
        this.myTransferTaskModal = transferTaskModal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersTransferConfig";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteTransfer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHelperPath";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressive";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webServerConfig";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteTransfer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersTransferConfig";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalExcludePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uploadHelpers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openConnection";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkExecutionContext";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeOperationsBatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 15 -> new IllegalStateException(string);
        };
    }

    public static interface HelpersTransferConfig {
        @NotNull
        public String getHelpersPath();

        public void createFileTransferConfig(@NotNull CredentialsDeployable var1);

        public boolean isHelpersVersionChecked();

        public void setHelpersVersionChecked(boolean var1);
    }

    protected final class RemoteSdkExecutionContext
    implements ExecutionContext {
        @Nullable
        private final Project myProject;
        private final ProgressIndicator myProgressIndicator;
        private final PublishConfig myPublishConfig;
        private final Deployable myWebServerConfig;
        private final RemoteConnection myConnection;
        private Boolean myPromptForOverwrite = null;
        private boolean myServerSideModification = true;

        private RemoteSdkExecutionContext(Project project, ProgressIndicator progressIndicator, Deployable webServerConfig, RemoteConnection connection) {
            this.myProject = project;
            this.myProgressIndicator = progressIndicator;
            this.myWebServerConfig = webServerConfig;
            this.myConnection = connection;
            this.myPublishConfig = new PublishConfig(project);
            this.myPublishConfig.setPromptOnRemoteOverwrite(PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP);
            this.myPublishConfig.setExcludeMask(StringUtil.join((String[])ArrayUtil.mergeArrays((String[])PublishConfig.DEFAULT_EXCLUDES, (String[])RemoteTransfer.this.getAdditionalExcludePatterns()), (String)";"));
        }

        public PublishConfig getConfig() {
            return this.myPublishConfig;
        }

        public void incCounter(String counterTitle) {
        }

        public void incBytesTransmitted(long bytes) {
        }

        public void console(String message, ConsoleViewContentType type) {
        }

        public boolean isMultipleOperations() {
            return true;
        }

        public void setPromptForOverwrite(boolean promptForOverwrite) {
            this.myPromptForOverwrite = promptForOverwrite;
        }

        public boolean promptForOverwrite(@Nullable FileObject source, @NotNull FileObject target) throws IOException {
            if (target == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(0);
            }
            return this.myPromptForOverwrite != null ? this.myPromptForOverwrite : !TransferOperation.isUpToDate((FileObject)source, (FileObject)target, (Deployable)this.getServer());
        }

        public ProgressIndicator getProgressIndicator() {
            return this.myProgressIndicator;
        }

        public void addAffectedRoot(FileName fileName, boolean remote) {
        }

        public boolean isServerSideModification() {
            return this.myServerSideModification;
        }

        public void setServerSideModification(boolean serverSideModification) {
            this.myServerSideModification = serverSideModification;
        }

        public Deployable getServer() {
            return this.myWebServerConfig;
        }

        public FileObject findRemoteFile(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
            if (path == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(1);
            }
            FileObject file = PublishUtils.findFile((RemoteConnection)this.myConnection, (WebServerConfig.RemotePath)path, (Connectable)this.myWebServerConfig);
            if (refreshUpRecursively) {
                DeploymentPathUtils.refreshRemoteFile((FileObject)file, (ExecutionContextBase)this);
            } else {
                file.refresh();
            }
            return file;
        }

        @NotNull
        public FileName findRemoteFileName(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull WebServerConfig.RemotePath path) throws FileSystemException {
            if (path == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(2);
            }
            FileName fileName = PublishUtils.findRemoteFileName((RemoteConnection)this.myConnection, (WebServerConfig.RemotePath)path, (Connectable)this.myWebServerConfig);
            if (fileName == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(3);
            }
            return fileName;
        }

        public FileObject resolveFileName(@NotNull FileName name, boolean refreshUpRecursively) throws FileSystemException {
            FileObject file;
            if (name == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(4);
            }
            if ((file = this.myConnection.resolveFile(name)) != null) {
                if (refreshUpRecursively) {
                    DeploymentPathUtils.refreshRemoteFile((FileObject)file, (ExecutionContextBase)this);
                } else {
                    file.refresh();
                }
            }
            return file;
        }

        public boolean isTolerateSetPermissionsErrors() {
            return true;
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        public boolean isCancellable() {
            return false;
        }

        public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
        }

        public void setCurrentFileFraction(double fraction) {
        }

        public void setIgnoreOverwritingStrategy(@NotNull IgnoreOverwritingStrategy strategy) {
            if (strategy == null) {
                RemoteSdkExecutionContext.$$$reportNull$$$0(5);
            }
        }

        public void increaseFailureCount() {
            throw new UnsupportedOperationException("increaseFailureCount is not supported");
        }

        public DeploymentMode getDeploymentMode() {
            return DeploymentMode.CUSTOM;
        }

        public DeploymentRevisionTracker getRevisionTracker() {
            return DeploymentRevisionTracker.DEAF;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteTransfer$RemoteSdkExecutionContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteTransfer$RemoteSdkExecutionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRemoteFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "promptForOverwrite";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findRemoteFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findRemoteFileName";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveFileName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setIgnoreOverwritingStrategy";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

