/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.vagrant.VagrantItem;
import com.jetbrains.plugins.vagrant.VagrantItemsModel;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VagrantItemListPanel<T extends VagrantItem>
extends PanelWithButtons {
    private final Project myProject;
    private final VagrantItemsModel<T> myModel;
    private JBTable myTable;
    private DefaultTableModel myDataModel;

    public VagrantItemListPanel(@NotNull Project project, @NotNull VagrantItemsModel<T> model) {
        if (project == null) {
            VagrantItemListPanel.$$$reportNull$$$0(0);
        }
        if (model == null) {
            VagrantItemListPanel.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myModel = model;
        this.myModel.addListener(new VagrantItemsModel.VagrantItemListener(){

            @Override
            public void fireEvent() {
                VagrantItemListPanel.this.updateTable();
            }
        });
    }

    protected String getLabelText() {
        return null;
    }

    protected JButton[] createButtons() {
        return new JButton[0];
    }

    private void removeItem() {
        T item = this.getSelectedItem();
        if (item != null && Messages.showYesNoDialog((Project)this.myProject, (String)this.deleteConfirmation(item), (String)this.deleteConfirmationTitle(), (Icon)Messages.getQuestionIcon()) == 0) {
            this.myModel.remove(item);
        }
    }

    @Nls
    protected abstract String deleteConfirmationTitle();

    @Nls
    protected abstract String deleteConfirmation(T var1);

    protected JComponent createMainComponent() {
        final String[] names = new String[]{this.firstColumn(), this.secondColumn()};
        this.myDataModel = new DefaultTableModel(){

            @Override
            public int getColumnCount() {
                return names.length;
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                if (c == 0) {
                    return String.class;
                }
                if (c == 1) {
                    return String.class;
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.myTable = new JBTable((TableModel)this.myDataModel);
        this.myTable.setEnableAntialiasing(true);
        this.myTable.setShowGrid(false);
        this.myTable.getEmptyText().setText(this.uninitializedListText());
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)300, (int)-1));
        this.myTable.setVisibleRowCount(6);
        this.myTable.getColumn((Object)names[0]).setPreferredWidth(350);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myModel.addListener(new VagrantItemsModel.VagrantItemListener(){

            @Override
            public void fireEvent() {
                UIUtil.invokeLaterIfNeeded(() -> VagrantItemListPanel.this.myTable.updateUI());
            }
        });
        return this.createToolbarDecorator().createPanel();
    }

    public void updateTable() {
        new SwingWorker<List<? extends T>>(){
            List<? extends T> items;

            public List<? extends T> construct() {
                this.items = VagrantItemListPanel.this.myModel.listItems();
                return this.items;
            }

            public void finished() {
                VagrantItemListPanel.this.myDataModel.setNumRows(0);
                if (this.items != null) {
                    int i = 0;
                    for (VagrantItem item : this.items) {
                        VagrantItemListPanel.this.myDataModel.insertRow(i++, new String[]{item.getName(), item.getType()});
                    }
                }
                VagrantItemListPanel.this.myTable.getEmptyText().setText(this.items == null ? VagrantItemListPanel.this.uninitializedListText() : VagrantItemListPanel.this.emptyListText());
            }
        }.start();
    }

    protected ToolbarDecorator createToolbarDecorator() {
        return ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                VagrantItemListPanel.this.myModel.add();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                VagrantItemListPanel.this.removeItem();
            }
        });
    }

    @Nls
    protected abstract String secondColumn();

    @Nls
    protected abstract String firstColumn();

    @NotNull
    @Nls
    protected abstract String uninitializedListText();

    @Nls
    protected abstract String emptyListText();

    @Nullable
    protected T getSelectedItem() {
        List<T> items = this.myModel.listItems();
        if (items != null && this.myTable.getSelectedRow() >= 0) {
            return (T)((VagrantItem)items.get(this.myTable.getSelectedRow()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/vagrant/VagrantItemListPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

