/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.AsyncIteratorHelperPrototypeBuiltins;
import com.oracle.truffle.js.builtins.AsyncIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.IteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.AsyncIteratorCloseNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorDrainQueueNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.AsyncHandlerRootNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.builtins.JSAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.util.ArrayDeque;
import java.util.function.Function;

public final class AsyncIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<AsyncIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncIteratorPrototypeBuiltins();
    public static final HiddenKey PROMISE_ID = new HiddenKey("promise");

    AsyncIteratorPrototypeBuiltins() {
        super(JSAsyncIterator.PROTOTYPE_NAME, AsyncIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, AsyncIteratorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorMapNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 1: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorFilterNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 2: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorTakeNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 3: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorDropNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 4: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorFlatMapNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 5: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorReduceNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context2));
            }
            case 6: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorToArrayNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 7: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorForEachNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 8: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorSomeNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 9: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorEveryNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 10: {
                return AsyncIteratorPrototypeBuiltinsFactory.AsyncIteratorFindNodeGen.create(context2, builtin, AsyncIteratorPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum AsyncIteratorPrototype implements BuiltinEnum<AsyncIteratorPrototype>
    {
        map(1),
        filter(1),
        take(1),
        drop(1),
        flatMap(1),
        reduce(1),
        toArray(0),
        forEach(1),
        some(1),
        every(1),
        find(1);

        private final int length;

        private AsyncIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    protected static abstract class AsyncIteratorMapNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorMapArgs> awaitNode;
        @Node.Child
        private AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode createAsyncIteratorHelperNode;

        public AsyncIteratorMapNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createAsyncIteratorHelperNode = AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode.create(context2);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorMap, AsyncIteratorMapNode::createMapFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(mapper)"})
        public JSDynamicObject map(Object thisObj, Object mapper) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            return this.createAsyncIteratorHelperNode.execute(record, this.awaitNode.createFunction(new AsyncIteratorMapArgs(record, mapper)));
        }

        @Specialization(guards={"!isCallable(mapper)"})
        public Object unsupported(Object thisObj, Object mapper) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createMapFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorMapRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createMapWithValueFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorMapWithValueRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorMapArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object mapper;

            public AsyncIteratorMapArgs(IteratorRecord iterated, Object mapper) {
                super(iterated);
                this.mapper = mapper;
            }
        }

        protected static class AsyncIteratorMapRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorYieldResumptionRootNode<AsyncIteratorMapArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorMapArgs> awaitNode;

            public AsyncIteratorMapRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorMapWithValue, AsyncIteratorMapNode::createMapWithValueFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorMapArgs args = (AsyncIteratorMapArgs)this.getArgs(frame);
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, value2, args);
            }
        }

        protected static class AsyncIteratorMapWithValueRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithCloseRootNode<AsyncIteratorMapArgs> {
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> yieldNode;

            public AsyncIteratorMapWithValueRootNode(JSContext context2) {
                super(context2);
                this.yieldNode = AsyncIteratorAwaitNode.createGeneratorYield(context2);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorMapArgs args = (AsyncIteratorMapArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.mapper, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                ++args.counter;
                return this.yieldNode.execute(frame, result2, args);
            }
        }
    }

    protected static abstract class AsyncIteratorFilterNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorFilterArgs> awaitNode;
        @Node.Child
        private AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode createAsyncIteratorHelperNode;

        public AsyncIteratorFilterNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createAsyncIteratorHelperNode = AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode.create(context2);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFilter, AsyncIteratorFilterNode::createFilterFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(filterer)"})
        public JSDynamicObject filter(Object thisObj, Object filterer) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            return this.createAsyncIteratorHelperNode.execute(record, this.awaitNode.createFunction(new AsyncIteratorFilterArgs(record, filterer)));
        }

        @Specialization(guards={"!isCallable(filterer)"})
        public Object unsupported(Object thisObj, Object filterer) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createFilterFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFilterRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createFilterWithValueFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFilterWithValueRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createFilterWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFilterWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorFilterArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object filterer;
            public Object value;

            public AsyncIteratorFilterArgs(IteratorRecord iterated, Object filterer) {
                super(iterated);
                this.filterer = filterer;
            }
        }

        protected static class AsyncIteratorFilterRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorYieldResumptionRootNode<AsyncIteratorFilterArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFilterArgs> awaitNode;

            public AsyncIteratorFilterRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFilterWithValue, AsyncIteratorFilterNode::createFilterWithValueFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorFilterArgs args = (AsyncIteratorFilterArgs)this.getArgs(frame);
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, value2, args);
            }
        }

        protected static class AsyncIteratorFilterWithValueRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithCloseRootNode<AsyncIteratorFilterArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFilterArgs> awaitNode;

            public AsyncIteratorFilterWithValueRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFilterWithResult, AsyncIteratorFilterNode::createFilterWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorFilterArgs args = (AsyncIteratorFilterArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.filterer, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                args.value = value2;
                ++args.counter;
                return this.awaitNode.execute(frame, result2, args);
            }
        }

        protected static class AsyncIteratorFilterWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionRootNode<AsyncIteratorFilterArgs> {
            @Node.Child
            private JSToBooleanNode toBooleanNode = JSToBooleanNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFilterArgs> awaitNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> yieldNode;

            public AsyncIteratorFilterWithResultRootNode(JSContext context2) {
                super(context2);
                this.yieldNode = AsyncIteratorAwaitNode.createGeneratorYield(context2);
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFilter, AsyncIteratorFilterNode::createFilterFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorFilterArgs args = (AsyncIteratorFilterArgs)this.getArgs(frame);
                Object value2 = args.value;
                assert (value2 != null);
                args.value = null;
                if (this.toBooleanNode.executeBoolean(this.valueNode.execute(frame))) {
                    return this.yieldNode.execute(frame, value2, args);
                }
                return this.awaitNode.execute(frame, Undefined.instance, args);
            }
        }
    }

    protected static abstract class AsyncIteratorTakeNode
    extends IteratorPrototypeBuiltins.IteratorMethodNode {
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorTakeArgs> awaitNode;
        @Node.Child
        private AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode createAsyncIteratorHelperNode;
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToIntegerOrInfinityNode toIntegerOrInfinityNode;

        public AsyncIteratorTakeNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createAsyncIteratorHelperNode = AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode.create(context2);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorTake, AsyncIteratorTakeNode::createTakeFunctionImpl, false);
            this.toNumberNode = JSToNumberNode.create();
            this.toIntegerOrInfinityNode = JSToIntegerOrInfinityNode.create();
        }

        @Specialization
        public JSDynamicObject take(Object thisObj, Object limit, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch) {
            if (!isObjectNode.executeBoolean(thisObj)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorNotAnObject(thisObj, this);
            }
            Number numLimit = this.toNumberNode.executeNumber(limit);
            if (JSRuntime.isNaN(numLimit)) {
                errorBranch.enter(this);
                throw Errors.createRangeError("NaN is not allowed", (Node)this);
            }
            double integerLimit = JSRuntime.doubleValue(this.toIntegerOrInfinityNode.executeNumber(numLimit));
            if (integerLimit < 0.0) {
                errorBranch.enter(this);
                throw Errors.createRangeErrorIndexNegative(this);
            }
            IteratorRecord record = this.getIteratorDirect(thisObj);
            AsyncIteratorTakeArgs args = new AsyncIteratorTakeArgs(record, integerLimit);
            return this.createAsyncIteratorHelperNode.execute(record, this.awaitNode.createFunction(args));
        }

        private static JSFunctionData createTakeFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorTakeRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createTakeWithValueFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorTakeWithValueRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static class AsyncIteratorTakeArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorArgs {
            public double remaining;

            public AsyncIteratorTakeArgs(IteratorRecord iterated, double limit) {
                super(iterated);
                this.remaining = limit;
            }
        }

        protected static class AsyncIteratorTakeRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorYieldResumptionRootNode<AsyncIteratorTakeArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorTakeArgs> awaitNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorTakeArgs> awaitInnerResultNode;
            @Node.Child
            private CreateIterResultObjectNode createIterResultObjectNode;
            @Node.Child
            private AsyncIteratorCloseNode asyncIteratorCloseNode;

            public AsyncIteratorTakeRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorTakeWithValue, AsyncIteratorTakeNode::createTakeWithValueFunctionImpl, false);
                this.awaitInnerResultNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorGeneratorReturn, AsyncIteratorAwaitNode::createGeneratorReturnFunctionImpl, false);
                this.createIterResultObjectNode = CreateIterResultObjectNode.create(context2);
                this.asyncIteratorCloseNode = AsyncIteratorCloseNode.create(context2);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorTakeArgs args = (AsyncIteratorTakeArgs)this.getArgs(frame);
                double remaining = args.remaining;
                if (remaining == 0.0) {
                    Object returnValue = this.asyncIteratorCloseNode.execute(args.iterated.getIterator(), Undefined.instance);
                    if (returnValue == Undefined.instance) {
                        return returnValue;
                    }
                    return this.awaitInnerResultNode.execute(frame, returnValue, args);
                }
                if (remaining != Double.POSITIVE_INFINITY) {
                    args.remaining -= 1.0;
                }
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, value2, args);
            }
        }

        protected static class AsyncIteratorTakeWithValueRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithNextRootNode<AsyncIteratorTakeArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> yieldNode;

            public AsyncIteratorTakeWithValueRootNode(JSContext context2) {
                super(context2);
                this.yieldNode = AsyncIteratorAwaitNode.createGeneratorYield(context2);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                AsyncIteratorTakeArgs args = (AsyncIteratorTakeArgs)this.getArgs(frame);
                Object value2 = this.iteratorValueNode.execute(next);
                return this.yieldNode.execute(frame, value2, args);
            }
        }
    }

    protected static abstract class AsyncIteratorDropNode
    extends IteratorPrototypeBuiltins.IteratorMethodNode {
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorDropArgs> awaitNode;
        @Node.Child
        private AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode createAsyncIteratorHelperNode;
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        private JSToIntegerOrInfinityNode toIntegerOrInfinityNode;

        public AsyncIteratorDropNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createAsyncIteratorHelperNode = AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode.create(context2);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorDrop, AsyncIteratorDropNode::createDropFunctionImpl, false);
            this.toNumberNode = JSToNumberNode.create();
            this.toIntegerOrInfinityNode = JSToIntegerOrInfinityNode.create();
        }

        @Specialization
        public JSDynamicObject drop(Object thisObj, Object limit, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch) {
            if (!isObjectNode.executeBoolean(thisObj)) {
                errorBranch.enter(this);
                throw Errors.createTypeErrorNotAnObject(thisObj, this);
            }
            Number numLimit = this.toNumberNode.executeNumber(limit);
            if (JSRuntime.isNaN(numLimit)) {
                errorBranch.enter(this);
                throw Errors.createRangeError("NaN is not allowed", (Node)this);
            }
            double integerLimit = JSRuntime.doubleValue(this.toIntegerOrInfinityNode.executeNumber(numLimit));
            if (integerLimit < 0.0) {
                errorBranch.enter(this);
                throw Errors.createRangeErrorIndexNegative(this);
            }
            IteratorRecord record = this.getIteratorDirect(thisObj);
            AsyncIteratorDropArgs args = new AsyncIteratorDropArgs(record, integerLimit);
            return this.createAsyncIteratorHelperNode.execute(record, this.awaitNode.createFunction(args));
        }

        private static JSFunctionData createDropFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorDropRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createDropWithValueLoopFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorDropWithValueLoopRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createDropWithValueFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorDropWithValueRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static class AsyncIteratorDropArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorArgs {
            public double remaining;

            public AsyncIteratorDropArgs(IteratorRecord iterated, double limit) {
                super(iterated);
                this.remaining = limit;
            }
        }

        protected static class AsyncIteratorDropRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorYieldResumptionRootNode<AsyncIteratorDropArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorDropArgs> awaitNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorDropArgs> awaitLoopNode;

            public AsyncIteratorDropRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorDropWithValue, AsyncIteratorDropNode::createDropWithValueFunctionImpl, false);
                this.awaitLoopNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorDropWithValueLoop, AsyncIteratorDropNode::createDropWithValueLoopFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorDropArgs args = (AsyncIteratorDropArgs)this.getArgs(frame);
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                double remaining = args.remaining;
                if (remaining > 0.0) {
                    return this.awaitLoopNode.execute(frame, value2, args);
                }
                return this.awaitNode.execute(frame, value2, args);
            }
        }

        protected static class AsyncIteratorDropWithValueLoopRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithNextRootNode<AsyncIteratorDropArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> yieldNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorDropArgs> awaitNode;

            public AsyncIteratorDropWithValueLoopRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.yieldNode = AsyncIteratorAwaitNode.createGeneratorYield(context2);
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorDropWithValueLoop, AsyncIteratorDropNode::createDropWithValueLoopFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorDropArgs args = (AsyncIteratorDropArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                double remaining = args.remaining;
                if (remaining > 0.0) {
                    if (remaining != Double.POSITIVE_INFINITY) {
                        args.remaining -= 1.0;
                    }
                    Object value2 = this.iteratorNextNode.execute(args.iterated);
                    return this.awaitNode.execute(frame, value2, args);
                }
                Object nextValue = this.iteratorValueNode.execute(next);
                return this.yieldNode.execute(frame, nextValue, args);
            }
        }

        protected static class AsyncIteratorDropWithValueRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithNextRootNode<AsyncIteratorDropArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> yieldNode;

            public AsyncIteratorDropWithValueRootNode(JSContext context2) {
                super(context2);
                this.yieldNode = AsyncIteratorAwaitNode.createGeneratorYield(context2);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                AsyncIteratorDropArgs args = (AsyncIteratorDropArgs)this.getArgs(frame);
                Object nextValue = this.iteratorValueNode.execute(next);
                return this.yieldNode.execute(frame, nextValue, args);
            }
        }
    }

    protected static abstract class AsyncIteratorFlatMapNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorFlatMapArgs> awaitNode;
        @Node.Child
        private AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode createAsyncIteratorHelperNode;

        public AsyncIteratorFlatMapNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.createAsyncIteratorHelperNode = AsyncIteratorHelperPrototypeBuiltins.CreateAsyncIteratorHelperNode.create(context2);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFlatMap, AsyncIteratorFlatMapNode::createFlatMapFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(mapper)"})
        public JSDynamicObject flatMap(Object thisObj, Object mapper) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            return this.createAsyncIteratorHelperNode.execute(record, this.awaitNode.createFunction(new AsyncIteratorFlatMapArgs(record, mapper)));
        }

        @Specialization(guards={"!isCallable(mapper)"})
        public Object unsupported(Object thisObj, Object mapper) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createFlatMapFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFlatMapRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createFlatMapWithValueFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFlatMapWithValueRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createFlatMapWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFlatMapWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createFlatMapInnerWithValueFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFlatMapInnerWithValueRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorFlatMapArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object mapper;
            protected IteratorRecord innerIterator;

            public AsyncIteratorFlatMapArgs(IteratorRecord iterated, Object mapper) {
                super(iterated);
                this.mapper = mapper;
            }
        }

        protected static class AsyncIteratorFlatMapRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorYieldResumptionRootNode<AsyncIteratorFlatMapArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFlatMapArgs> awaitInnerNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFlatMapArgs> awaitOuterNode;

            public AsyncIteratorFlatMapRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.awaitOuterNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFlatMapWithValue, AsyncIteratorFlatMapNode::createFlatMapWithValueFunctionImpl, false);
                this.awaitInnerNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFlatMapInnerWithValue, AsyncIteratorFlatMapNode::createFlatMapInnerWithValueFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorFlatMapArgs args = (AsyncIteratorFlatMapArgs)this.getArgs(frame);
                IteratorRecord iterated = args.iterated;
                IteratorRecord inner = args.innerIterator;
                if (inner != null) {
                    Object value2 = this.iteratorNextNode.execute(inner);
                    return this.awaitInnerNode.execute(frame, value2, args);
                }
                Object value3 = this.iteratorNextNode.execute(iterated);
                return this.awaitOuterNode.execute(frame, value3, args);
            }
        }

        protected static class AsyncIteratorFlatMapWithValueRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithCloseRootNode<AsyncIteratorFlatMapArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFlatMapArgs> awaitNode;
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

            public AsyncIteratorFlatMapWithValueRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFlatMapWithResult, AsyncIteratorFlatMapNode::createFlatMapWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object mapped;
                AsyncIteratorFlatMapArgs args = (AsyncIteratorFlatMapArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    mapped = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.mapper, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                ++args.counter;
                return this.awaitNode.execute(frame, mapped, args);
            }
        }

        protected static class AsyncIteratorFlatMapWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionRootNode<AsyncIteratorFlatMapArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private GetIteratorFlattenableNode getIteratorFlattenableNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFlatMapArgs> awaitInnerNode;

            public AsyncIteratorFlatMapWithResultRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(true, true, context2);
                this.awaitInnerNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFlatMapInnerWithValue, AsyncIteratorFlatMapNode::createFlatMapInnerWithValueFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                IteratorRecord inner;
                AsyncIteratorFlatMapArgs args = (AsyncIteratorFlatMapArgs)this.getArgs(frame);
                Object mapped = this.valueNode.execute(frame);
                args.innerIterator = inner = this.getIteratorFlattenableNode.execute(mapped);
                Object innerNext = this.iteratorNextNode.execute(inner);
                return this.awaitInnerNode.execute(frame, innerNext, args);
            }
        }

        protected static class AsyncIteratorFlatMapInnerWithValueRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionWithNextRootNode<AsyncIteratorFlatMapArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> yieldNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFlatMapArgs> awaitNode;

            public AsyncIteratorFlatMapInnerWithValueRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.yieldNode = AsyncIteratorAwaitNode.createGeneratorYield(context2);
                this.awaitNode = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFlatMap, AsyncIteratorFlatMapNode::createFlatMapFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorFlatMapArgs args = (AsyncIteratorFlatMapArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    args.innerIterator = null;
                    return this.awaitNode.execute(frame, Undefined.instance, args);
                }
                Object value2 = this.iteratorValueNode.execute(next);
                return this.yieldNode.execute(frame, value2, args);
            }
        }
    }

    protected static abstract class AsyncIteratorReduceNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorReduceArgs> initialAwaitNode;
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorReduceArgs> awaitNode;

        public AsyncIteratorReduceNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorReduce, AsyncIteratorReduceNode::createReduceFunctionImpl, false);
            this.initialAwaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorReduceInitial, AsyncIteratorReduceNode::createReduceInitialFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(reducer)"})
        public JSDynamicObject reduce(Object thisObj, Object reducer, Object[] args) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            Object value2 = this.iteratorNextNode.execute(record);
            if (args.length == 0) {
                return this.initialAwaitNode.executeThis(value2, new AsyncIteratorReduceArgs(record, reducer, Undefined.instance), thisObj);
            }
            Object initialValue = args[0];
            return this.awaitNode.executeThis(value2, new AsyncIteratorReduceArgs(record, reducer, initialValue), thisObj);
        }

        @Specialization(guards={"!isCallable(reducer)"})
        public Object unsupported(Object thisObj, Object reducer, Object[] args) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createReduceFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorReduceRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createReduceInitialFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorReduceInitialRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createReduceWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorReduceWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorReduceArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object reducer;
            public Object accumulator;

            AsyncIteratorReduceArgs(IteratorRecord iterated, Object reducer, Object accumulator) {
                super(iterated);
                this.reducer = reducer;
                this.accumulator = accumulator;
            }
        }

        protected static class AsyncIteratorReduceRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionWithCloseRootNode<AsyncIteratorReduceArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorReduceArgs> awaitNode;
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

            public AsyncIteratorReduceRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorReduceWithResult, AsyncIteratorReduceNode::createReduceWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorReduceArgs args = (AsyncIteratorReduceArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return args.accumulator;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.reducer, args.accumulator, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                args.accumulator = result2;
                ++args.counter;
                return this.awaitNode.execute(frame, result2, args);
            }
        }

        protected static class AsyncIteratorReduceInitialRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorReduceArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private IteratorValueNode iteratorValueNode = IteratorValueNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorReduceArgs> awaitNode;

            public AsyncIteratorReduceInitialRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorReduce, AsyncIteratorReduceNode::createReduceFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorReduceArgs args = (AsyncIteratorReduceArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    throw Errors.createTypeError("Reduce of empty iterator with no initial value");
                }
                Object value2 = this.iteratorValueNode.execute(next);
                Object nextNext = this.iteratorNextNode.execute(args.iterated);
                args.accumulator = value2;
                args.counter = 1L;
                return this.awaitNode.execute(frame, nextNext, args);
            }
        }

        protected static class AsyncIteratorReduceWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorReduceArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorReduceArgs> awaitNode;

            public AsyncIteratorReduceWithResultRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorReduce, AsyncIteratorReduceNode::createReduceFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorReduceArgs args = (AsyncIteratorReduceArgs)this.getArgs(frame);
                Object result2 = this.valueNode.execute(frame);
                Object next = this.iteratorNextNode.execute(args.iterated);
                args.accumulator = result2;
                return this.awaitNode.execute(frame, next, args);
            }
        }
    }

    protected static abstract class AsyncIteratorToArrayNode
    extends IteratorPrototypeBuiltins.IteratorMethodNode {
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorToArrayArgs> awaitNode;

        public AsyncIteratorToArrayNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorToArray, AsyncIteratorToArrayNode::createToArrayFunctionImpl, false);
        }

        @Specialization
        public JSDynamicObject toArray(Object thisObj) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            Object value2 = this.iteratorNextNode.execute(record);
            return this.awaitNode.executeThis(value2, new AsyncIteratorToArrayArgs(record, new SimpleArrayList<Object>()), thisObj);
        }

        private static JSFunctionData createToArrayFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorToArrayRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorToArrayArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorArgs {
            public final SimpleArrayList<Object> result;

            AsyncIteratorToArrayArgs(IteratorRecord iterated, SimpleArrayList<Object> result2) {
                super(iterated);
                this.result = result2;
            }
        }

        protected static class AsyncIteratorToArrayRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorToArrayArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode;
            @Node.Child
            private IteratorValueNode iteratorValueNode;
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorToArrayArgs> awaitNode;
            private final JSContext context;

            public AsyncIteratorToArrayRootNode(JSContext context2) {
                super(context2);
                this.context = context2;
                this.iteratorNextNode = IteratorNextNode.create();
                this.iteratorValueNode = IteratorValueNode.create();
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorToArray, AsyncIteratorToArrayNode::createToArrayFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorToArrayArgs args = (AsyncIteratorToArrayArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return JSArray.createConstant(this.context, this.getRealm(), args.result.toArray());
                }
                Object value2 = this.iteratorValueNode.execute(next);
                args.result.add(value2, null, InlinedBranchProfile.getUncached());
                return this.awaitNode.execute(frame, this.iteratorNextNode.execute(args.iterated), args);
            }
        }
    }

    protected static abstract class AsyncIteratorForEachNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorForEachArgs> awaitNode;

        public AsyncIteratorForEachNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorForEach, AsyncIteratorForEachNode::createForEachFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(fn)"})
        public JSDynamicObject forEach(Object thisObj, Object fn) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            Object value2 = this.iteratorNextNode.execute(record);
            return this.awaitNode.executeThis(value2, new AsyncIteratorForEachArgs(record, fn), thisObj);
        }

        @Specialization(guards={"!isCallable(fn)"})
        public Object unsupported(Object thisObj, Object fn) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createForEachFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorForEachRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createForEachWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorForEachWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorForEachArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object fn;

            AsyncIteratorForEachArgs(IteratorRecord iterated, Object fn) {
                super(iterated);
                this.fn = fn;
            }
        }

        protected static class AsyncIteratorForEachRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionWithCloseRootNode<AsyncIteratorForEachArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorForEachArgs> awaitNode;
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

            public AsyncIteratorForEachRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorForEachWithResult, AsyncIteratorForEachNode::createForEachWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorForEachArgs args = (AsyncIteratorForEachArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.fn, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                ++args.counter;
                return this.awaitNode.execute(frame, result2, args);
            }
        }

        protected static class AsyncIteratorForEachWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorForEachArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorForEachArgs> awaitNode;

            public AsyncIteratorForEachWithResultRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorForEach, AsyncIteratorForEachNode::createForEachFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorForEachArgs args = (AsyncIteratorForEachArgs)this.getArgs(frame);
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, value2, args);
            }
        }
    }

    protected static abstract class AsyncIteratorSomeNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorSomeArgs> awaitNode;

        public AsyncIteratorSomeNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorSome, AsyncIteratorSomeNode::createSomeFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(fn)"})
        public JSDynamicObject some(Object thisObj, Object fn) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            Object value2 = this.iteratorNextNode.execute(record);
            return this.awaitNode.executeThis(value2, new AsyncIteratorSomeArgs(record, fn), thisObj);
        }

        @Specialization(guards={"!isCallable(fn)"})
        public Object unsupported(Object thisObj, Object fn) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createSomeFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorSomeRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createSomeWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorSomeWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorSomeArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object fn;

            AsyncIteratorSomeArgs(IteratorRecord iterated, Object fn) {
                super(iterated);
                this.fn = fn;
            }
        }

        protected static class AsyncIteratorSomeRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionWithCloseRootNode<AsyncIteratorSomeArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorSomeArgs> awaitNode;
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

            public AsyncIteratorSomeRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorSomeWithResult, AsyncIteratorSomeNode::createSomeWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorSomeArgs args = (AsyncIteratorSomeArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return false;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.fn, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                ++args.counter;
                return this.awaitNode.execute(frame, result2, args);
            }
        }

        protected static class AsyncIteratorSomeWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorSomeArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorSomeArgs> awaitNode;
            @Node.Child
            private JSToBooleanNode toBooleanNode;
            @Node.Child
            private AsyncIteratorCloseNode asyncIteratorCloseNode;

            public AsyncIteratorSomeWithResultRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.toBooleanNode = JSToBooleanNode.create();
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorSome, AsyncIteratorSomeNode::createSomeFunctionImpl, false);
                this.asyncIteratorCloseNode = AsyncIteratorCloseNode.create(context2);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorSomeArgs args = (AsyncIteratorSomeArgs)this.getArgs(frame);
                Object result2 = this.valueNode.execute(frame);
                if (this.toBooleanNode.executeBoolean(result2)) {
                    return this.asyncIteratorCloseNode.execute(args.iterated.getIterator(), true);
                }
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, value2, args);
            }
        }
    }

    protected static abstract class AsyncIteratorEveryNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorEveryArgs> awaitNode;

        public AsyncIteratorEveryNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorEvery, AsyncIteratorEveryNode::createEveryFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(fn)"})
        public JSDynamicObject every(Object thisObj, Object fn) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            Object value2 = this.iteratorNextNode.execute(record);
            return this.awaitNode.executeThis(value2, new AsyncIteratorEveryArgs(record, fn), thisObj);
        }

        @Specialization(guards={"!isCallable(fn)"})
        public Object unsupported(Object thisObj, Object fn) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createEveryFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorEveryRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createEveryWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorEveryWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorEveryArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object fn;

            AsyncIteratorEveryArgs(IteratorRecord iterated, Object fn) {
                super(iterated);
                this.fn = fn;
            }
        }

        protected static class AsyncIteratorEveryRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionWithCloseRootNode<AsyncIteratorEveryArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorEveryArgs> awaitNode;
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

            public AsyncIteratorEveryRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorEveryWithResult, AsyncIteratorEveryNode::createEveryWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorEveryArgs args = (AsyncIteratorEveryArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return true;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.fn, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                ++args.counter;
                return this.awaitNode.execute(frame, result2, args);
            }
        }

        protected static class AsyncIteratorEveryWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorEveryArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorEveryArgs> awaitNode;
            @Node.Child
            private JSToBooleanNode toBooleanNode;
            @Node.Child
            private AsyncIteratorCloseNode asyncIteratorCloseNode;

            public AsyncIteratorEveryWithResultRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.toBooleanNode = JSToBooleanNode.create();
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorEvery, AsyncIteratorEveryNode::createEveryFunctionImpl, false);
                this.asyncIteratorCloseNode = AsyncIteratorCloseNode.create(context2);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorEveryArgs args = (AsyncIteratorEveryArgs)this.getArgs(frame);
                Object result2 = this.valueNode.execute(frame);
                if (!this.toBooleanNode.executeBoolean(result2)) {
                    return this.asyncIteratorCloseNode.execute(args.iterated.getIterator(), false);
                }
                Object value2 = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, value2, args);
            }
        }
    }

    protected static abstract class AsyncIteratorFindNode
    extends IteratorPrototypeBuiltins.IteratorMethodWithCallableNode {
        @Node.Child
        private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorFindArgs> awaitNode;

        public AsyncIteratorFindNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFind, AsyncIteratorFindNode::createFindFunctionImpl, false);
        }

        @Specialization(guards={"isCallable(fn)"})
        public JSDynamicObject find(Object thisObj, Object fn) {
            IteratorRecord record = this.getIteratorDirect(thisObj);
            Object value2 = this.iteratorNextNode.execute(record);
            return this.awaitNode.executeThis(value2, new AsyncIteratorFindArgs(record, fn), thisObj);
        }

        @Specialization(guards={"!isCallable(fn)"})
        public Object unsupported(Object thisObj, Object fn) {
            throw Errors.createTypeErrorCallableExpected();
        }

        private static JSFunctionData createFindFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFindRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createFindWithResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFindWithResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static final class AsyncIteratorFindArgs
        extends AsyncIteratorAwaitNode.AsyncIteratorWithCounterArgs {
            public final Object fn;
            public Object value;

            AsyncIteratorFindArgs(IteratorRecord iterated, Object fn) {
                super(iterated);
                this.fn = fn;
            }
        }

        protected static class AsyncIteratorFindRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionWithCloseRootNode<AsyncIteratorFindArgs> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFindArgs> awaitNode;
            @Node.Child
            private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();

            public AsyncIteratorFindRootNode(JSContext context2) {
                super(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFindWithResult, AsyncIteratorFindNode::createFindWithResultFunctionImpl, true);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                Object result2;
                AsyncIteratorFindArgs args = (AsyncIteratorFindArgs)this.getArgs(frame);
                Object next = this.valueNode.execute(frame);
                this.checkNext(next);
                if (this.iteratorComplete(next)) {
                    return Undefined.instance;
                }
                Object value2 = this.iteratorValueNode.execute(next);
                try {
                    result2 = this.callNode.executeCall(JSArguments.create(Undefined.instance, args.fn, value2, this.indexToJS(args.counter)));
                }
                catch (AbstractTruffleException ex) {
                    return this.asyncIteratorCloseAbrupt(args.iterated, ex);
                }
                args.value = value2;
                ++args.counter;
                return this.awaitNode.execute(frame, result2, args);
            }
        }

        protected static class AsyncIteratorFindWithResultRootNode
        extends AsyncIteratorAwaitNode.AsyncIteratorNonGeneratorResumptionRootNode<AsyncIteratorFindArgs> {
            @Node.Child
            private IteratorNextNode iteratorNextNode = IteratorNextNode.create();
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorFindArgs> awaitNode;
            @Node.Child
            private JSToBooleanNode toBooleanNode;
            @Node.Child
            private AsyncIteratorCloseNode asyncIteratorCloseNode;

            public AsyncIteratorFindWithResultRootNode(JSContext context2) {
                super(context2);
                this.callNode = JSFunctionCallNode.createCall();
                this.toBooleanNode = JSToBooleanNode.create();
                this.asyncIteratorCloseNode = AsyncIteratorCloseNode.create(context2);
                this.awaitNode = AsyncIteratorAwaitNode.create(context2, JSContext.BuiltinFunctionKey.AsyncIteratorFind, AsyncIteratorFindNode::createFindFunctionImpl, false);
            }

            @Override
            public Object executeBody(VirtualFrame frame) {
                AsyncIteratorFindArgs args = (AsyncIteratorFindArgs)this.getArgs(frame);
                Object result2 = this.valueNode.execute(frame);
                Object value2 = args.value;
                assert (value2 != null);
                args.value = null;
                if (this.toBooleanNode.executeBoolean(result2)) {
                    return this.asyncIteratorCloseNode.execute(args.iterated.getIterator(), value2);
                }
                Object next = this.iteratorNextNode.execute(args.iterated);
                return this.awaitNode.execute(frame, next, args);
            }
        }
    }

    protected static class AsyncIteratorFlatMapUnwrapYieldResumptionRootNode
    extends AsyncIteratorUnwrapYieldResumptionRootNode<AsyncIteratorFlatMapNode.AsyncIteratorFlatMapArgs> {
        @Node.Child
        private AsyncIteratorAwaitNode<AsyncIteratorFlatMapNode.AsyncIteratorFlatMapArgs> awaitInnerIteratorReturnResult;

        protected AsyncIteratorFlatMapUnwrapYieldResumptionRootNode(JSContext context2, boolean closeResumption) {
            super(context2, closeResumption);
            this.awaitInnerIteratorReturnResult = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorUnwrapYieldResumptionCloseInnerIteratorResumption, AsyncIteratorFlatMapUnwrapYieldResumptionRootNode::createCreateUnwrapYieldResumptionCloseResumptionImpl, true);
        }

        @Override
        public Object executeBody(VirtualFrame frame) {
            Object awaitedValue = this.valueNode.execute(frame);
            JSAsyncGeneratorObject generator = this.getThis(frame);
            ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
            assert (!queue.isEmpty());
            AsyncGeneratorRequest result2 = queue.peekFirst();
            if (result2.isReturn()) {
                AsyncIteratorFlatMapNode.AsyncIteratorFlatMapArgs args = (AsyncIteratorFlatMapNode.AsyncIteratorFlatMapArgs)this.getArgs(frame);
                if (this.isObjectNode == null) {
                    assert (args.innerIterator != null);
                    Object iterator = args.innerIterator.getIterator();
                    Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
                    if (returnMethod != Undefined.instance) {
                        Object returnResult = this.callNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                        return this.awaitInnerIteratorReturnResult.executeThis(returnResult, args, generator);
                    }
                    args.innerIterator = null;
                    iterator = args.iterated.getIterator();
                    returnMethod = this.getReturnNode.executeWithTarget(iterator);
                    if (returnMethod != Undefined.instance) {
                        Object returnResult = this.callNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                        return this.awaitReturnResult.executeThis(returnResult, args, generator);
                    }
                } else {
                    if (!this.isObjectNode.executeBoolean(awaitedValue)) {
                        throw Errors.createTypeErrorIterResultNotAnObject(awaitedValue, this);
                    }
                    assert (args.innerIterator != null);
                    args.innerIterator = null;
                    Object iterator = args.iterated.getIterator();
                    Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
                    if (returnMethod != Undefined.instance) {
                        Object returnResult = this.callNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                        return this.awaitReturnResult.executeThis(returnResult, args, generator);
                    }
                }
            }
            return Undefined.instance;
        }

        protected static JSFunctionData createCreateUnwrapYieldResumptionCloseImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFlatMapUnwrapYieldResumptionRootNode(context2, false).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static JSFunctionData createCreateUnwrapYieldResumptionCloseResumptionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorFlatMapUnwrapYieldResumptionRootNode(context2, true).getCallTarget(), 1, Strings.EMPTY_STRING);
        }
    }

    protected static class AsyncIteratorUnwrapYieldResumptionRootNode<T extends AsyncIteratorAwaitNode.AsyncIteratorArgs>
    extends AsyncIteratorAwaitNode.AsyncIteratorGeneratorAwaitResumptionRootNode<T> {
        @Node.Child
        protected GetMethodNode getReturnNode;
        @Node.Child
        protected AsyncIteratorAwaitNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> awaitReturnResult;
        @Node.Child
        protected IsJSObjectNode isObjectNode;

        protected AsyncIteratorUnwrapYieldResumptionRootNode(JSContext context2, boolean closeResumption) {
            super(context2);
            this.getReturnNode = GetMethodNode.create(context2, Strings.RETURN);
            this.awaitReturnResult = AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorUnwrapYieldResumptionCloseResumption, AsyncIteratorUnwrapYieldResumptionRootNode::createCreateUnwrapYieldResumptionCloseResumptionImpl, false);
            this.isObjectNode = closeResumption ? IsJSObjectNode.create() : null;
        }

        @Override
        public Object executeBody(VirtualFrame frame) {
            Object awaitedValue = this.valueNode.execute(frame);
            JSAsyncGeneratorObject generator = this.getThis(frame);
            ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
            assert (!queue.isEmpty());
            AsyncGeneratorRequest result2 = queue.peekFirst();
            if (result2.isReturn()) {
                Object args = this.getArgs(frame);
                if (this.isObjectNode == null) {
                    Object iterator = ((AsyncIteratorAwaitNode.AsyncIteratorArgs)args).iterated.getIterator();
                    Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
                    if (returnMethod != Undefined.instance) {
                        Object returnResult = this.callNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                        return this.awaitReturnResult.executeThis(returnResult, (AsyncIteratorAwaitNode.AsyncIteratorArgs)args, generator);
                    }
                } else if (!this.isObjectNode.executeBoolean(awaitedValue)) {
                    throw Errors.createTypeErrorIterResultNotAnObject(awaitedValue, this);
                }
            }
            return Undefined.instance;
        }

        protected static JSFunctionData createCreateUnwrapYieldResumptionCloseImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorUnwrapYieldResumptionRootNode(context2, false).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        protected static JSFunctionData createCreateUnwrapYieldResumptionCloseResumptionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorUnwrapYieldResumptionRootNode(context2, true).getCallTarget(), 1, Strings.EMPTY_STRING);
        }
    }

    protected static class AsyncIteratorYieldResultRootNode
    extends AsyncIteratorAwaitNode.AbstractAsyncIteratorGeneratorResumptionRootNode<AsyncIteratorAwaitNode.AsyncIteratorArgs> {
        @Node.Child
        private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
        @Node.Child
        private PropertyGetNode getContinuation;

        protected AsyncIteratorYieldResultRootNode(JSContext context2) {
            super(context2);
            this.getContinuation = PropertyGetNode.createGetHidden(AsyncIteratorHelperPrototypeBuiltins.IMPL_ID, context2);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object value2 = this.valueNode.execute(frame);
            JSAsyncGeneratorObject generator = this.getThis(frame);
            ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
            assert (!queue.isEmpty());
            this.asyncGeneratorCompleteStep(frame, Completion.Type.Normal, value2, false, queue);
            if (!queue.isEmpty()) {
                return this.asyncGeneratorUnwrapYieldResumption(generator);
            }
            generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.SuspendedYield);
            return Undefined.instance;
        }

        private Object asyncGeneratorUnwrapYieldResumption(JSAsyncGeneratorObject generator) {
            generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.SuspendedYield);
            Object continuation = this.getContinuation.getValue(generator);
            return this.callNode.executeCall(JSArguments.createZeroArg(generator, continuation));
        }

        protected static JSFunctionData createYieldResultFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorYieldResultRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }
    }

    public static class AsyncIteratorAwaitNode<T extends AsyncIteratorArgs>
    extends JavaScriptBaseNode {
        public static final HiddenKey THIS_ID = new HiddenKey("awaitThis");
        private static final HiddenKey ARGS_ID = new HiddenKey("awaitArgs");
        @Node.Child
        private PropertySetNode setArgs;
        @Node.Child
        private PropertySetNode setThisNode;
        @Node.Child
        private PropertyGetNode getThisNode;
        @Node.Child
        protected JSFunctionCallNode callNode;
        @Node.Child
        protected PropertyGetNode getConstructorNode;
        @Node.Child
        protected NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        protected PerformPromiseThenNode performPromiseThenNode;
        private final JSContext.BuiltinFunctionKey thenKey;
        private final Function<JSContext, JSFunctionData> thenCreate;
        private final JSContext.BuiltinFunctionKey catchKey;
        private final Function<JSContext, JSFunctionData> catchCreate;
        private final JSContext context;

        public AsyncIteratorAwaitNode(JSContext context2, JSContext.BuiltinFunctionKey thenKey, Function<JSContext, JSFunctionData> thenCreate, JSContext.BuiltinFunctionKey catchKey, Function<JSContext, JSFunctionData> catchCreate) {
            this.context = context2;
            this.thenKey = thenKey;
            this.thenCreate = thenCreate;
            this.catchKey = catchKey;
            this.catchCreate = catchCreate;
            this.setArgs = PropertySetNode.createSetHidden(ARGS_ID, context2);
            this.setThisNode = PropertySetNode.createSetHidden(THIS_ID, context2);
            this.getThisNode = PropertyGetNode.createGetHidden(THIS_ID, context2);
            this.getConstructorNode = PropertyGetNode.create(JSObject.CONSTRUCTOR, context2);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context2);
            this.performPromiseThenNode = PerformPromiseThenNode.create(context2);
            this.callNode = JSFunctionCallNode.createCall();
        }

        public final JSDynamicObject execute(VirtualFrame frame, Object promiseOrValue, T args) {
            return this.executeThis(promiseOrValue, args, this.getThisNode.getValue(JSFrameUtil.getFunctionObject(frame)));
        }

        private JSPromiseObject promiseResolve(Object promiseOrValue) {
            if (JSPromise.isJSPromise(promiseOrValue) && this.getConstructorNode.getValueOrDefault(promiseOrValue, Undefined.instance) == this.getRealm().getPromiseConstructor()) {
                return (JSPromiseObject)promiseOrValue;
            }
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
            this.callNode.executeCall(JSArguments.createOneArg(promiseCapability.getPromise(), promiseCapability.getResolve(), promiseOrValue));
            return (JSPromiseObject)promiseCapability.getPromise();
        }

        public final JSDynamicObject executeThis(Object promiseOrValue, T args, Object thisObj) {
            JSPromiseObject promise = this.promiseResolve(promiseOrValue);
            JSFunctionObject then = this.createFunction(args);
            JSFunctionObject catchObj = this.createFunctionWithArgs((AsyncIteratorArgs)args, this.context.getOrCreateBuiltinFunctionData(this.catchKey, this.catchCreate));
            this.setThisNode.setValue(then, thisObj);
            this.setThisNode.setValue(catchObj, thisObj);
            return this.performPromiseThenNode.execute(promise, then, catchObj, this.newPromiseCapabilityNode.executeDefault());
        }

        protected final JSFunctionObject createFunctionWithArgs(AsyncIteratorArgs args, JSFunctionData functionData) {
            JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
            this.setArgs.setValue(function, args);
            return function;
        }

        public JSFunctionObject createFunction(T args) {
            return this.createFunctionWithArgs((AsyncIteratorArgs)args, this.context.getOrCreateBuiltinFunctionData(this.thenKey, this.thenCreate));
        }

        public static <T extends AsyncIteratorArgs> AsyncIteratorAwaitNode<T> create(JSContext context2, JSContext.BuiltinFunctionKey key, Function<JSContext, JSFunctionData> create2, boolean closeOnAbrupt) {
            Function<JSContext, JSFunctionData> catchCreate;
            JSContext.BuiltinFunctionKey catchKey;
            if (closeOnAbrupt) {
                catchKey = JSContext.BuiltinFunctionKey.AsyncIteratorIfAbruptClose;
                catchCreate = AsyncIteratorAwaitNode::createIfAbruptCloseFunctionImpl;
            } else {
                catchKey = JSContext.BuiltinFunctionKey.AsyncIteratorIfAbruptReturn;
                catchCreate = AsyncIteratorAwaitNode::createIfAbruptReturnFunctionImpl;
            }
            return AsyncIteratorAwaitNode.create(context2, key, create2, catchKey, catchCreate);
        }

        public static <T extends AsyncIteratorArgs> AsyncIteratorAwaitNode<T> createGen(JSContext context2, JSContext.BuiltinFunctionKey key, Function<JSContext, JSFunctionData> create2, boolean closeOnAbrupt) {
            Function<JSContext, JSFunctionData> catchCreate;
            JSContext.BuiltinFunctionKey catchKey;
            if (closeOnAbrupt) {
                catchKey = JSContext.BuiltinFunctionKey.AsyncIteratorGeneratorIfAbruptClose;
                catchCreate = AsyncIteratorAwaitNode::createGeneratorIfAbruptCloseFunctionImpl;
            } else {
                catchKey = JSContext.BuiltinFunctionKey.AsyncIteratorGeneratorIfAbruptReturn;
                catchCreate = AsyncIteratorAwaitNode::createGeneratorIfAbruptReturnFunctionImpl;
            }
            return AsyncIteratorAwaitNode.create(context2, key, create2, catchKey, catchCreate);
        }

        public static <T extends AsyncIteratorArgs> AsyncIteratorAwaitNode<T> create(JSContext context2, JSContext.BuiltinFunctionKey thenKey, Function<JSContext, JSFunctionData> thenCreate, JSContext.BuiltinFunctionKey catchKey, Function<JSContext, JSFunctionData> catchCreate) {
            return new AsyncIteratorAwaitNode<T>(context2, thenKey, thenCreate, catchKey, catchCreate);
        }

        public static <T extends AsyncIteratorArgs> AsyncIteratorAwaitNode<T> createGeneratorYield(JSContext context2) {
            return AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorYield, AsyncIteratorYieldResultRootNode::createYieldResultFunctionImpl, true);
        }

        private static JSFunctionData createIfAbruptCloseFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorIfAbruptCloseNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createIfAbruptReturnFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorIfAbruptReturnNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createGeneratorIfAbruptCloseFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorGeneratorIfAbruptCloseNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createGeneratorIfAbruptReturnFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorGeneratorIfAbruptReturnNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        private static JSFunctionData createGeneratorReturnFunctionImpl(JSContext context2) {
            return JSFunctionData.createCallOnly(context2, new AsyncIteratorGeneratorReturnNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
        }

        public static class AsyncIteratorArgs {
            public final IteratorRecord iterated;

            public AsyncIteratorArgs(IteratorRecord iterated) {
                this.iterated = iterated;
            }
        }

        private static class AsyncIteratorIfAbruptCloseNode
        extends AsyncIteratorRootNode<AsyncIteratorArgs> {
            @Node.Child
            private AsyncIteratorCloseNode closeNode;

            AsyncIteratorIfAbruptCloseNode(JSContext context2) {
                super(context2);
                this.closeNode = AsyncIteratorCloseNode.create(context2);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object args = this.getArgs(frame);
                return this.closeNode.executeAbrupt(((AsyncIteratorArgs)args).iterated.getIterator(), this.valueNode.execute(frame));
            }
        }

        private static class AsyncIteratorIfAbruptReturnNode
        extends AsyncIteratorRootNode<AsyncIteratorArgs> {
            @Node.Child
            private NewPromiseCapabilityNode newPromiseCapabilityNode;

            AsyncIteratorIfAbruptReturnNode(JSContext context2) {
                super(context2);
                this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context2);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                PromiseCapabilityRecord capabilityRecord = this.newPromiseCapabilityNode.executeDefault();
                Object rejection = this.valueNode.execute(frame);
                this.callNode.executeCall(JSArguments.createOneArg(capabilityRecord.getPromise(), capabilityRecord.getReject(), rejection));
                return capabilityRecord.getPromise();
            }
        }

        private static class AsyncIteratorGeneratorIfAbruptCloseNode
        extends AbstractAsyncIteratorGeneratorResumptionRootNode<AsyncIteratorArgs> {
            @Node.Child
            private AsyncIteratorCloseNode closeNode;

            AsyncIteratorGeneratorIfAbruptCloseNode(JSContext context2) {
                super(context2);
                this.closeNode = AsyncIteratorCloseNode.create(context2);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object rejection = this.valueNode.execute(frame);
                Object args = this.getArgs(frame);
                this.closeNode.executeAbrupt(((AsyncIteratorArgs)args).iterated.getIterator(), rejection);
                return this.asyncGeneratorComplete(frame, Completion.Type.Throw, rejection);
            }
        }

        private static class AsyncIteratorGeneratorIfAbruptReturnNode
        extends AbstractAsyncIteratorGeneratorResumptionRootNode<AsyncIteratorArgs> {
            AsyncIteratorGeneratorIfAbruptReturnNode(JSContext context2) {
                super(context2);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object rejection = this.valueNode.execute(frame);
                return this.asyncGeneratorComplete(frame, Completion.Type.Throw, rejection);
            }
        }

        private static class AsyncIteratorGeneratorReturnNode
        extends AbstractAsyncIteratorGeneratorResumptionRootNode<AsyncIteratorArgs> {
            AsyncIteratorGeneratorReturnNode(JSContext context2) {
                super(context2);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object value2 = this.valueNode.execute(frame);
                return this.asyncGeneratorComplete(frame, Completion.Type.Normal, value2);
            }
        }

        protected static class AsyncIteratorWithCounterArgs
        extends AsyncIteratorArgs {
            public long counter;

            protected AsyncIteratorWithCounterArgs(IteratorRecord iterated) {
                super(iterated);
            }
        }

        public static abstract class AsyncIteratorGeneratorYieldResumptionRootNode<T extends AsyncIteratorArgs>
        extends AbstractAsyncIteratorGeneratorResumptionRootNode<T> {
            @Node.Child
            private AsyncIteratorAwaitNode<AsyncIteratorArgs> awaitYieldResumptionNode;

            AsyncIteratorGeneratorYieldResumptionRootNode(JSContext context2) {
                super(context2);
                this.awaitYieldResumptionNode = this instanceof AsyncIteratorFlatMapNode.AsyncIteratorFlatMapRootNode ? AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorUnwrapYieldResumptionCloseInnerIterator, AsyncIteratorFlatMapUnwrapYieldResumptionRootNode::createCreateUnwrapYieldResumptionCloseImpl, true) : AsyncIteratorAwaitNode.createGen(context2, JSContext.BuiltinFunctionKey.AsyncIteratorUnwrapYieldResumptionClose, AsyncIteratorUnwrapYieldResumptionRootNode::createCreateUnwrapYieldResumptionCloseImpl, true);
            }

            public abstract Object executeBody(VirtualFrame var1);

            @Override
            public final Object execute(VirtualFrame frame) {
                JSAsyncGeneratorObject generator = this.getThis(frame);
                JSFunction.AsyncGeneratorState suspendedState = generator.getAsyncGeneratorState();
                assert (suspendedState == JSFunction.AsyncGeneratorState.SuspendedStart || suspendedState == JSFunction.AsyncGeneratorState.SuspendedYield || suspendedState == JSFunction.AsyncGeneratorState.Executing) : suspendedState;
                generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Executing);
                Completion.Type resultType = Completion.Type.Normal;
                Object resultValue = Undefined.instance;
                if (suspendedState == JSFunction.AsyncGeneratorState.SuspendedYield) {
                    ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
                    assert (!queue.isEmpty());
                    AsyncGeneratorRequest toYield = queue.peekFirst();
                    if (toYield.isReturn()) {
                        return this.awaitYieldResumptionNode.executeThis(toYield.getCompletionValue(), (AsyncIteratorArgs)this.getArgs(frame), generator);
                    }
                    if (toYield.isThrow()) {
                        resultType = Completion.Type.Throw;
                        resultValue = toYield.getCompletionValue();
                    }
                }
                if (resultType == Completion.Type.Normal) {
                    try {
                        resultValue = this.executeBody(frame);
                        if (resultValue instanceof JSPromiseObject) {
                            return resultValue;
                        }
                    }
                    catch (AbstractTruffleException e) {
                        resultType = Completion.Type.Throw;
                        resultValue = this.getErrorObject(e);
                    }
                }
                assert (resultType == Completion.Type.Normal || resultType == Completion.Type.Throw);
                return this.asyncGeneratorComplete(frame, resultType, resultValue);
            }
        }

        public static abstract class AsyncIteratorGeneratorAwaitResumptionWithCloseRootNode<T extends AsyncIteratorArgs>
        extends AsyncIteratorGeneratorAwaitResumptionWithNextRootNode<T> {
            @Node.Child
            private AsyncIteratorCloseNode closeNode;

            AsyncIteratorGeneratorAwaitResumptionWithCloseRootNode(JSContext context2) {
                super(context2);
            }

            protected final Object asyncIteratorCloseAbrupt(IteratorRecord iterated, AbstractTruffleException exception) {
                Object rejection = this.getErrorObject(exception);
                if (this.closeNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.closeNode = this.insert(AsyncIteratorCloseNode.create(this.context));
                }
                this.closeNode.executeAbrupt(iterated.getIterator(), rejection);
                throw exception;
            }
        }

        public static abstract class AsyncIteratorGeneratorAwaitResumptionWithNextRootNode<T extends AsyncIteratorArgs>
        extends AsyncIteratorGeneratorAwaitResumptionRootNode<T> {
            @Node.Child
            private IsObjectNode isObjectNode = IsObjectNode.create();
            @Node.Child
            private IteratorCompleteNode iteratorCompleteNode = IteratorCompleteNode.create();
            @Node.Child
            protected IteratorValueNode iteratorValueNode = IteratorValueNode.create();

            AsyncIteratorGeneratorAwaitResumptionWithNextRootNode(JSContext context2) {
                super(context2);
            }

            protected final void checkNext(Object value2) {
                if (!this.isObjectNode.executeBoolean(value2)) {
                    throw Errors.createTypeErrorIterResultNotAnObject(value2, this);
                }
            }

            protected final boolean iteratorComplete(Object value2) {
                return this.iteratorCompleteNode.execute(value2);
            }
        }

        public static abstract class AsyncIteratorGeneratorAwaitResumptionRootNode<T extends AsyncIteratorArgs>
        extends AbstractAsyncIteratorGeneratorResumptionRootNode<T> {
            AsyncIteratorGeneratorAwaitResumptionRootNode(JSContext context2) {
                super(context2);
            }

            public abstract Object executeBody(VirtualFrame var1);

            @Override
            public final Object execute(VirtualFrame frame) {
                Completion.Type resultType;
                Object resultValue;
                this.assertResumingAwait(frame);
                try {
                    resultValue = this.executeBody(frame);
                    if (resultValue instanceof JSPromiseObject) {
                        return resultValue;
                    }
                    resultType = Completion.Type.Normal;
                }
                catch (AbstractTruffleException e) {
                    resultType = Completion.Type.Throw;
                    resultValue = this.getErrorObject(e);
                }
                return this.asyncGeneratorComplete(frame, resultType, resultValue);
            }

            protected final void assertResumingAwait(VirtualFrame frame) {
                JSAsyncGeneratorObject generator = this.getThis(frame);
                assert (generator.getAsyncGeneratorState() == JSFunction.AsyncGeneratorState.Executing) : generator.getAsyncGeneratorState();
            }
        }

        public static abstract class AbstractAsyncIteratorGeneratorResumptionRootNode<T extends AsyncIteratorArgs>
        extends AsyncIteratorRootNode<T> {
            @Node.Child
            private AsyncGeneratorDrainQueueNode asyncGeneratorOpNode;

            protected AbstractAsyncIteratorGeneratorResumptionRootNode(JSContext context2) {
                super(context2);
                this.asyncGeneratorOpNode = AsyncGeneratorDrainQueueNode.create(context2);
            }

            protected final Object getErrorObject(AbstractTruffleException ex) {
                return this.asyncGeneratorOpNode.getErrorObject(ex);
            }

            protected final Object asyncGeneratorComplete(VirtualFrame frame, Completion.Type resultType, Object resultValue) {
                JSAsyncGeneratorObject generator = this.getThis(frame);
                this.asyncGeneratorOpNode.asyncGeneratorCompleteStepAndDrainQueue(frame, generator, resultType, resultValue);
                return Undefined.instance;
            }

            protected final void asyncGeneratorCompleteStep(VirtualFrame frame, Completion.Type completionType, Object completionValue, boolean done, ArrayDeque<AsyncGeneratorRequest> queue) {
                this.asyncGeneratorOpNode.asyncGeneratorCompleteStep(frame, completionType, completionValue, done, queue);
            }
        }

        public static abstract class AsyncIteratorNonGeneratorResumptionWithCloseRootNode<T extends AsyncIteratorArgs>
        extends AsyncIteratorNonGeneratorResumptionRootNode<T> {
            @Node.Child
            protected IteratorValueNode iteratorValueNode = IteratorValueNode.create();
            @Node.Child
            private AsyncIteratorCloseNode closeNode;

            AsyncIteratorNonGeneratorResumptionWithCloseRootNode(JSContext context2) {
                super(context2);
                this.closeNode = AsyncIteratorCloseNode.create(context2);
            }

            protected final Object asyncIteratorCloseAbrupt(IteratorRecord iterated, AbstractTruffleException exception) {
                Object rejection = this.getErrorObject(exception);
                this.closeNode.executeAbrupt(iterated.getIterator(), rejection);
                throw exception;
            }
        }

        public static abstract class AsyncIteratorNonGeneratorResumptionRootNode<T extends AsyncIteratorArgs>
        extends AsyncIteratorRootNode<T> {
            @Node.Child
            private NewPromiseCapabilityNode newPromiseCapabilityNode;
            @Node.Child
            private IsObjectNode isObjectNode;
            @Node.Child
            private IteratorCompleteNode iteratorCompleteNode;
            @Node.Child
            private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

            AsyncIteratorNonGeneratorResumptionRootNode(JSContext context2) {
                super(context2);
                this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context2);
                this.isObjectNode = IsObjectNode.create();
                this.iteratorCompleteNode = IteratorCompleteNode.create();
            }

            public abstract Object executeBody(VirtualFrame var1);

            @Override
            public Object execute(VirtualFrame frame) {
                PromiseCapabilityRecord promiseCapability;
                try {
                    Object resultValue = this.executeBody(frame);
                    if (resultValue instanceof JSPromiseObject) {
                        return resultValue;
                    }
                    promiseCapability = this.newPromiseCapabilityNode.executeDefault();
                    this.callNode.executeCall(JSArguments.createOneArg(promiseCapability.getPromise(), promiseCapability.getResolve(), resultValue));
                }
                catch (AbstractTruffleException e) {
                    Object resultValue = this.getErrorObject(e);
                    promiseCapability = this.newPromiseCapabilityNode.executeDefault();
                    this.callNode.executeCall(JSArguments.createOneArg(promiseCapability.getPromise(), promiseCapability.getReject(), resultValue));
                }
                return promiseCapability.getPromise();
            }

            protected final Object getErrorObject(AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                }
                return this.getErrorObjectNode.execute(ex);
            }

            protected final Object checkNext(Object value2) {
                if (!this.isObjectNode.executeBoolean(value2)) {
                    throw Errors.createTypeErrorIterResultNotAnObject(value2, this);
                }
                return value2;
            }

            protected final boolean iteratorComplete(Object value2) {
                return this.iteratorCompleteNode.execute(value2);
            }
        }

        public static abstract class AsyncIteratorRootNode<T extends AsyncIteratorArgs>
        extends JavaScriptRootNode
        implements AsyncHandlerRootNode {
            @Node.Child
            protected JavaScriptNode valueNode;
            @Node.Child
            private PropertyGetNode getArgsNode;
            @Node.Child
            private PropertyGetNode getThisNode;
            @Node.Child
            protected JSFunctionCallNode callNode;
            @Node.Child
            private LongToIntOrDoubleNode indexToNumber = LongToIntOrDoubleNode.create();
            protected final JSContext context;

            protected AsyncIteratorRootNode(JSContext context2) {
                super(context2.getLanguage(), null, null);
                this.context = context2;
                this.valueNode = AccessIndexedArgumentNode.create(0);
                this.getArgsNode = PropertyGetNode.createGetHidden(ARGS_ID, context2);
                this.callNode = JSFunctionCallNode.createCall();
            }

            protected final T getArgs(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                return (T)((AsyncIteratorArgs)this.getArgsNode.getValue(functionObject));
            }

            protected final JSAsyncGeneratorObject getThis(VirtualFrame frame) {
                if (this.getThisNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getThisNode = this.insert(PropertyGetNode.createGetHidden(THIS_ID, this.context));
                }
                return (JSAsyncGeneratorObject)this.getThisNode.getValue(JSFrameUtil.getFunctionObject(frame));
            }

            @Override
            public AsyncHandlerRootNode.AsyncStackTraceInfo getAsyncStackTraceInfo(JSFunctionObject handlerFunction) {
                assert (JSFunction.isJSFunction(handlerFunction) && ((RootCallTarget)JSFunction.getFunctionData(handlerFunction).getCallTarget()).getRootNode() == this);
                JSDynamicObject promise = (JSDynamicObject)JSObjectUtil.getHiddenProperty((JSDynamicObject)JSObjectUtil.getHiddenProperty(handlerFunction, THIS_ID), PROMISE_ID);
                return new AsyncHandlerRootNode.AsyncStackTraceInfo(promise, null);
            }

            protected final Object indexToJS(long index) {
                return this.indexToNumber.fromIndex(null, index);
            }
        }
    }
}

