/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerateNodeGen;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSForInIterator;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.interop.EmptyIterator;
import com.oracle.truffle.js.runtime.interop.InteropArrayIndexIterator;
import com.oracle.truffle.js.runtime.interop.InteropMemberIterator;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class EnumerateNode
extends JavaScriptNode {
    private final boolean values;
    private final boolean requireIterable;
    protected final JSContext context;
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    private PropertySetNode setEnumerateIteratorNode;

    protected EnumerateNode(JSContext context2, boolean values, boolean requireIterable, JavaScriptNode targetNode) {
        this.context = context2;
        this.values = values;
        this.requireIterable = requireIterable;
        this.targetNode = targetNode;
    }

    public static EnumerateNode create(JSContext context2, JavaScriptNode target, boolean values) {
        return EnumerateNodeGen.create(context2, values, false, target);
    }

    public static EnumerateNode create(JSContext context2, boolean values, boolean requireIterable) {
        return EnumerateNodeGen.create(context2, values, requireIterable, null);
    }

    @NeverDefault
    EnumerateNode copyRecursive() {
        return EnumerateNode.create(this.context, this.values, this.requireIterable);
    }

    @Override
    public abstract JSObject execute(VirtualFrame var1);

    public abstract JSObject execute(Object var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return EnumerateNodeGen.create(this.context, this.values, this.requireIterable, EnumerateNode.cloneUninitialized(this.targetNode, materializedTags));
    }

    @Specialization(guards={"!isJSAdapter(iteratedObject)"})
    protected JSObject doEnumerateObject(JSObject iteratedObject) {
        return this.newForInIterator(iteratedObject);
    }

    @Specialization(guards={"isNullOrUndefined(iteratedObject)"})
    protected JSObject doEnumerateNullOrUndefined(Object iteratedObject) {
        return this.newEmptyIterator();
    }

    @Specialization(guards={"isJSAdapter(iteratedObject)"})
    protected JSObject doEnumerateJSAdapter(JSObject iteratedObject, @Cached(value="createValues()") EnumerateNode enumerateCallbackResultNode) {
        Object returnValue;
        JSDynamicObject adaptee = JSAdapter.getAdaptee(iteratedObject);
        assert (JSRuntime.isObject(adaptee));
        Object getIds = JSObject.get(adaptee, this.values ? JSAdapter.GET_VALUES : JSAdapter.GET_IDS);
        if (JSFunction.isJSFunction(getIds) && JSRuntime.isObject(returnValue = JSFunction.call((JSFunctionObject)getIds, adaptee, JSArguments.EMPTY_ARGUMENTS_ARRAY))) {
            return enumerateCallbackResultNode.execute(returnValue);
        }
        return this.newEmptyIterator();
    }

    @NeverDefault
    EnumerateNode createValues() {
        return EnumerateNode.create(this.context, true, false);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(iteratedObject)"}, limit="InteropLibraryLimit")
    protected JSObject doEnumerateTruffleObject(Object iteratedObject, @Bind(value="this") Node node, @CachedLibrary(value="iteratedObject") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary keysInterop, @Cached InlinedBranchProfile notIterable, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
        try {
            if (!interop.isNull(iteratedObject)) {
                if (this.values) {
                    if (interop.hasIterator(iteratedObject)) {
                        Object iterator = interop.getIterator(iteratedObject);
                        return this.newEnumerateIterator(iterator);
                    }
                } else if (interop.hasArrayElements(iteratedObject)) {
                    return this.newEnumerateIterator(InteropArrayIndexIterator.create(iteratedObject));
                }
                if (interop.isString(iteratedObject)) {
                    return this.enumerateString(Strings.interopAsTruffleString(iteratedObject, interop, switchEncoding));
                }
                if (interop.hasHashEntries(iteratedObject)) {
                    Object iterator = this.values ? interop.getHashValuesIterator(iteratedObject) : interop.getHashKeysIterator(iteratedObject);
                    return this.newEnumerateIterator(iterator);
                }
                if (interop.hasMembers(iteratedObject)) {
                    Object keysObj = interop.getMembers(iteratedObject);
                    assert (InteropLibrary.getUncached().hasArrayElements(keysObj));
                    long longSize = keysInterop.getArraySize(keysObj);
                    return this.newEnumerateIterator(InteropMemberIterator.create(this.values, iteratedObject, keysObj, longSize));
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            // empty catch block
        }
        notIterable.enter(node);
        if (this.requireIterable) {
            throw Errors.createTypeErrorNotIterable(iteratedObject, this);
        }
        return this.newEmptyIterator();
    }

    private JSObject enumerateString(TruffleString string) {
        return this.newForInIterator(JSString.create(this.context, this.getRealm(), string));
    }

    private JSObject newEmptyIterator() {
        return this.newEnumerateIterator(EmptyIterator.create());
    }

    private JSObject newEnumerateIterator(Object iterator) {
        if (this.setEnumerateIteratorNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setEnumerateIteratorNode = this.insert(PropertySetNode.createSetHidden(JSRuntime.ENUMERATE_ITERATOR_ID, this.context));
        }
        JSObject obj = JSOrdinary.create(this.context, this.context.getEnumerateIteratorFactory(), this.getRealm());
        this.setEnumerateIteratorNode.setValue(obj, iterator);
        return obj;
    }

    private JSObject newForInIterator(JSObject obj) {
        return JSForInIterator.create(this.context, this.getRealm(), obj, this.values);
    }

    @Specialization(guards={"!isJSDynamicObject(iteratedObject)", "!isForeignObject(iteratedObject)"})
    protected JSObject doNonObject(Object iteratedObject, @Cached JSToObjectNode toObjectNode, @Cached(value="copyRecursive()") EnumerateNode enumerateNode) {
        return enumerateNode.execute(toObjectNode.execute(iteratedObject));
    }
}

