/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Strings;

public final class StringBuilderProfile
extends NodeCloneable {
    private static final int MAX_INT_STRING_LENGTH = 11;
    private static final int MAX_LONG_STRING_LENGTH = 20;
    private final int stringLengthLimit;
    private final BranchProfile errorBranch;

    private StringBuilderProfile(int stringLengthLimit) {
        this.stringLengthLimit = stringLengthLimit;
        this.errorBranch = BranchProfile.create();
    }

    public static StringBuilderProfile create(int stringLengthLimit) {
        return new StringBuilderProfile(stringLengthLimit);
    }

    public TruffleStringBuilderUTF16 newStringBuilder() {
        return Strings.builderCreate();
    }

    public TruffleStringBuilderUTF16 newStringBuilder(int capacity) {
        return Strings.builderCreate(capacity);
    }

    public static TruffleString toString(TruffleStringBuilder.ToStringNode node, TruffleStringBuilderUTF16 builder2) {
        return Strings.builderToString(node, builder2);
    }

    public void append(TruffleStringBuilder.AppendStringNode node, TruffleStringBuilderUTF16 builder2, TruffleString str) {
        if (Strings.builderLength(builder2) + Strings.length(str) > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Strings.builderAppend(node, builder2, str);
    }

    public void append(TruffleStringBuilder.AppendCharUTF16Node node, TruffleStringBuilderUTF16 builder2, char c) {
        if (Strings.builderLength(builder2) + 1 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Strings.builderAppend(node, builder2, c);
    }

    public void append(TruffleStringBuilder.AppendIntNumberNode node, TruffleStringBuilderUTF16 builder2, int intValue) {
        if (Strings.builderLength(builder2) + 11 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Strings.builderAppend(node, builder2, intValue);
    }

    public void append(TruffleStringBuilder.AppendLongNumberNode node, TruffleStringBuilderUTF16 builder2, long longValue) {
        if (Strings.builderLength(builder2) + 20 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Strings.builderAppend(node, builder2, longValue);
    }

    public void append(TruffleStringBuilder.AppendSubstringByteIndexNode node, TruffleStringBuilderUTF16 builder2, TruffleString charSequence, int start2, int end) {
        assert (start2 <= end);
        int length2 = end - start2;
        this.appendLen(node, builder2, charSequence, start2, length2);
    }

    public void appendLen(TruffleStringBuilder.AppendSubstringByteIndexNode node, TruffleStringBuilderUTF16 builder2, TruffleString str, int start2, int length2) {
        if (Strings.builderLength(builder2) + length2 > this.stringLengthLimit) {
            this.errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength();
        }
        Strings.builderAppendLen(node, builder2, str, start2, length2);
    }

    public static int length(TruffleStringBuilderUTF16 builder2) {
        return Strings.builderLength(builder2);
    }

    @Override
    protected Object clone() {
        return new StringBuilderProfile(this.stringLengthLimit);
    }
}

