/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.editor;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintConfigWrapper;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintRule;
import com.intellij.lang.javascript.linter.tslint.editor.TsLintCodeStyleEditorNotificationProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000e\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0010\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/editor/TsLintCodeStyleEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "NOTIFICATION_DISMISSED_PROPERTY", "", "isNotificationDismissed", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dismissNotification", "", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "intellij.tslint"})
final class TsLintCodeStyleEditorNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final String NOTIFICATION_DISMISSED_PROPERTY;

    public TsLintCodeStyleEditorNotificationProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.NOTIFICATION_DISMISSED_PROPERTY = "tslint.code.style.apply.dismiss";
    }

    private final boolean isNotificationDismissed(VirtualFile file) {
        return PropertiesComponent.getInstance((Project)this.project).getBoolean(this.NOTIFICATION_DISMISSED_PROPERTY) || !TslintUtil.isConfigFile(file);
    }

    private final void dismissNotification() {
        PropertiesComponent.getInstance((Project)this.project).setValue(this.NOTIFICATION_DISMISSED_PROPERTY, true);
        EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isNotificationDismissed(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        TsLintConfigWrapper tsLintConfigWrapper = TsLintConfigWrapper.Companion.getConfigForFile(psiFile2);
        if (tsLintConfigWrapper == null) {
            return null;
        }
        TsLintConfigWrapper wrapper = tsLintConfigWrapper;
        Collection<TsLintRule> rules = wrapper.getRulesToApply(project);
        if (rules.isEmpty()) {
            return null;
        }
        return arg_0 -> TsLintCodeStyleEditorNotificationProvider.collectNotificationData$lambda$0(this, arg_0);
    }

    private static final collectNotificationData.1.1 collectNotificationData$lambda$0(TsLintCodeStyleEditorNotificationProvider this$0, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ColorKey colorKey = EditorColors.GUTTER_BACKGROUND;
        EditorNotificationPanel.Status status = EditorNotificationPanel.Status.Info;
        return new EditorNotificationPanel(this$0, colorKey, status){
            {
                this.setText(TsLintBundle.message("tslint.code.style.apply.message", new Object[0]));
                this.createActionLabel(CommonBundle.message((String)"button.without.mnemonic.yes", (Object[])new Object[0]), "TslintImportCodeStyleAction", false);
                this.createActionLabel(CommonBundle.message((String)"button.without.mnemonic.no", (Object[])new Object[0]), () -> collectNotificationData.1.1._init_$lambda$0($receiver), false);
            }

            private static final void _init_$lambda$0(TsLintCodeStyleEditorNotificationProvider this$0) {
                TsLintCodeStyleEditorNotificationProvider.access$dismissNotification(this$0);
            }
        };
    }

    public static final /* synthetic */ void access$dismissNotification(TsLintCodeStyleEditorNotificationProvider $this) {
        $this.dismissNotification();
    }
}

