/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.ruby;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;

class RubyEnvironmentCallsVisitor
extends PsiRecursiveElementVisitor {
    private final Collection<KeyUsagePsiElement> collectedItems = new HashSet<KeyUsagePsiElement>();

    RubyEnvironmentCallsVisitor() {
    }

    public void visitElement(PsiElement element) {
        if (element instanceof RArrayIndexing) {
            this.visitFunction((RArrayIndexing)element);
        }
        super.visitElement(element);
    }

    private void visitFunction(RArrayIndexing expression) {
        RPsiElement receiver = expression.getReceiver();
        if (!(receiver instanceof RConstant)) {
            return;
        }
        if (receiver.getFirstChild() == null) {
            return;
        }
        if (!Objects.equals(receiver.getFirstChild().getText(), "ENV")) {
            return;
        }
        PsiElement stringLiteral = (PsiElement)expression.getIndexes().get(0);
        if (stringLiteral == null) {
            return;
        }
        if (!(stringLiteral instanceof RStringLiteral)) {
            return;
        }
        String key = ((RStringLiteral)stringLiteral).getContent();
        this.collectedItems.add(new KeyUsagePsiElement(key, stringLiteral));
    }

    @NotNull
    Collection<KeyUsagePsiElement> getCollectedItems() {
        Collection<KeyUsagePsiElement> collection = this.collectedItems;
        if (collection == null) {
            RubyEnvironmentCallsVisitor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/adelf/idea/dotenv/ruby/RubyEnvironmentCallsVisitor", "getCollectedItems"));
    }
}

