/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.externalProcessAuthHelper.AuthenticationMode;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JZ\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0018\u001a\u00020\u0019JV\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u001226\u0010\u001c\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00070\u001dJ\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/ProjectGitHelper;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "runGitCommand", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Ljava/nio/file/Path;", "command", "Lgit4idea/commands/GitCommand;", "params", "", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "throwOnError", "", "stdoutLinesConsumer", "Lkotlin/Function1;", "logRecentCommits", "limit", "", "logGitBlobHashes", "repo", "consumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "relPath", "hash", "logGitModifiedFiles", "", "intellij.indexing.shared.ultimate.git"})
@SourceDebugExtension(value={"SMAP\nProjectGitHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectGitHelper.kt\ncom/intellij/indexing/shared/ultimate/git/ProjectGitHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n37#2:95\n36#2,3:96\n15#3:99\n*S KotlinDebug\n*F\n+ 1 ProjectGitHelper.kt\ncom/intellij/indexing/shared/ultimate/git/ProjectGitHelper\n*L\n34#1:95\n34#1:96,3\n19#1:99\n*E\n"})
public final class ProjectGitHelper {
    @NotNull
    public static final ProjectGitHelper INSTANCE = new ProjectGitHelper();
    @NotNull
    private static final Logger LOG;

    private ProjectGitHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runGitCommand(Project project, Path root, GitCommand command, List<String> params, ProgressIndicator indicator, boolean throwOnError, Function1<? super String, Unit> stdoutLinesConsumer) {
        long startTime = System.currentTimeMillis();
        try {
            GitLineHandler handler = new GitLineHandler(project, root.toFile(), command);
            handler.setIgnoreAuthenticationMode(AuthenticationMode.SILENT);
            handler.setWithMediator(false);
            Collection $this$toTypedArray$iv = params;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            handler.addParameters(Arrays.copyOf(stringArray, stringArray.length));
            handler.addLineListener(new GitLineHandlerListener(indicator, stdoutLinesConsumer){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ Function1<String, Unit> $stdoutLinesConsumer;
                {
                    this.$indicator = $indicator;
                    this.$stdoutLinesConsumer = $stdoutLinesConsumer;
                }

                public void onLineAvailable(String line, Key<?> outputType) {
                    ProgressIndicator progressIndicator = this.$indicator;
                    if (progressIndicator != null) {
                        progressIndicator.checkCanceled();
                    }
                    if (!Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT) || line == null) {
                        return;
                    }
                    this.$stdoutLinesConsumer.invoke((Object)line);
                }
            });
            GitCommandResult gitCommandResult = Git.getInstance().runCommandWithoutCollectingOutput(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommandWithoutCollectingOutput(...)");
            GitCommandResult result = gitCommandResult;
            if (throwOnError) {
                result.throwOnError(new int[0]);
            }
        }
        catch (Exception t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            LOG.debug("Shared Indexes Git command " + command + " with " + params + " failed " + t.getMessage(), (Throwable)t);
        }
        finally {
            long duration = RangesKt.coerceAtLeast((long)(System.currentTimeMillis() - startTime), (long)1L);
            LOG.info("Shared Indexes git " + command.name() + " took " + StringUtil.formatDuration((long)duration));
        }
    }

    static /* synthetic */ void runGitCommand$default(ProjectGitHelper projectGitHelper, Project project, Path path, GitCommand gitCommand, List list, ProgressIndicator progressIndicator, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        projectGitHelper.runGitCommand(project, path, gitCommand, list, progressIndicator, bl, (Function1<? super String, Unit>)function1);
    }

    @NotNull
    public final List<String> logRecentCommits(@Nullable Project project, @NotNull Path root, int limit) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        LinkedHashSet result = new LinkedHashSet();
        GitCommand gitCommand = GitCommand.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"LOG");
        Object[] objectArray = new String[]{"-" + limit, "--topo-order", "--format=%H"};
        ProjectGitHelper.runGitCommand$default(this, project, root, gitCommand, CollectionsKt.listOf((Object[])objectArray), null, false, arg_0 -> ProjectGitHelper.logRecentCommits$lambda$0(result, arg_0), 48, null);
        return CollectionsKt.toList((Iterable)result);
    }

    public static /* synthetic */ List logRecentCommits$default(ProjectGitHelper projectGitHelper, Project project, Path path, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 2048;
        }
        return projectGitHelper.logRecentCommits(project, path, n);
    }

    public final void logGitBlobHashes(@NotNull Project project, @NotNull Path repo, @NotNull ProgressIndicator indicator, @NotNull Function2<? super String, ? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        GitCommand gitCommand = GitCommand.LS_TREE;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"LS_TREE");
        Object[] objectArray = new String[]{"--full-tree", "-r", "HEAD"};
        ProjectGitHelper.runGitCommand$default(this, project, repo, gitCommand, CollectionsKt.listOf((Object[])objectArray), indicator, false, arg_0 -> ProjectGitHelper.logGitBlobHashes$lambda$1(consumer, arg_0), 32, null);
    }

    @NotNull
    public final Set<String> logGitModifiedFiles(@NotNull Project project, @NotNull Path repo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        HashSet result = new HashSet();
        GitCommand gitCommand = GitCommand.STATUS;
        Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"STATUS");
        Object[] objectArray = new String[]{"--no-renames", "--porcelain=1", "--ignore-submodules"};
        ProjectGitHelper.runGitCommand$default(this, project, repo, gitCommand, CollectionsKt.listOf((Object[])objectArray), null, false, arg_0 -> ProjectGitHelper.logGitModifiedFiles$lambda$2(result, arg_0), 48, null);
        return result;
    }

    private static final Unit logRecentCommits$lambda$0(LinkedHashSet $result, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String text = ((Object)StringsKt.trim((CharSequence)line)).toString();
        if (!StringsKt.isBlank((CharSequence)text)) {
            Collection collection = $result;
            String string = text;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            string = string2;
            collection.add(string);
        }
        return Unit.INSTANCE;
    }

    private static final Unit logGitBlobHashes$lambda$1(Function2 $consumer, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        char[] cArray = new char[]{' ', '\t'};
        List it = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (it.size() == 4 && Intrinsics.areEqual(it.get(1), (Object)"blob")) {
            String path = (String)it.get(3);
            String hash2 = (String)it.get(2);
            $consumer.invoke((Object)path, (Object)hash2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit logGitModifiedFiles$lambda$2(HashSet $result, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String[] stringArray = new String[]{" "};
        String path = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (!StringsKt.isBlank((CharSequence)path)) {
            ((Collection)$result).add(path);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectGitHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

