/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurableWithId;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;
import org.jetbrains.plugins.terminal.ui.OpenPredefinedTerminalActionProvider;

public final class TerminalNewPredefinedSessionAction
extends DumbAwareAction {
    private static final List<String> UNIX_BINARIES_DIRECTORIES = List.of("/bin", "/usr/bin", "/usr/local/bin", "/opt/homebrew/bin");
    private static final List<String> UNIX_SHELL_NAMES = List.of("bash", "zsh", "fish", "pwsh");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        RelativePoint popupPoint = TerminalNewPredefinedSessionAction.getPreferredPopupPoint(e);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<OpenShellAction> shells = TerminalNewPredefinedSessionAction.detectShells();
            List<OpenShellAction> wsl = TerminalNewPredefinedSessionAction.listOpenWslShellActions();
            List<AnAction> customActions = OpenPredefinedTerminalActionProvider.collectAll(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                ListPopup popup = TerminalNewPredefinedSessionAction.createPopup(shells, wsl, customActions, e.getDataContext());
                if (popupPoint != null) {
                    popup.show(popupPoint);
                } else {
                    popup.showInFocusCenter();
                }
                InputEvent inputEvent = e.getInputEvent();
                if (inputEvent != null && inputEvent.getComponent() != null) {
                    PopupUtil.setPopupToggleComponent((JBPopup)popup, (Component)inputEvent.getComponent());
                }
            }, project.getDisposed());
        });
    }

    @Nullable
    private static RelativePoint getPreferredPopupPoint(@NotNull AnActionEvent e) {
        Component comp;
        InputEvent inputEvent;
        if (e == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(1);
        }
        if ((inputEvent = e.getInputEvent()) instanceof MouseEvent && (comp = inputEvent.getComponent()) instanceof AnActionHolder) {
            return new RelativePoint((Component)comp.getParent(), new Point(comp.getX() + JBUI.scale((int)3), comp.getY() + comp.getHeight() + JBUI.scale((int)3)));
        }
        return null;
    }

    @NotNull
    private static ListPopup createPopup(@NotNull List<OpenShellAction> shells, @NotNull List<OpenShellAction> wsl, @NotNull List<AnAction> customActions, @NotNull DataContext dataContext) {
        if (shells == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(2);
        }
        if (wsl == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(3);
        }
        if (customActions == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(5);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(shells);
        group.addAll(wsl);
        group.addAll(customActions);
        if (shells.size() + wsl.size() + customActions.size() > 0) {
            group.addSeparator();
        }
        group.add((AnAction)new TerminalSettingsAction());
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, false, true, false, null, -1, null);
        if (listPopup == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(6);
        }
        return listPopup;
    }

    @NotNull
    private static List<OpenShellAction> listOpenWslShellActions() {
        if (WSLDistribution.findWslExe() == null) {
            List<OpenShellAction> list = List.of();
            if (list == null) {
                TerminalNewPredefinedSessionAction.$$$reportNull$$$0(7);
            }
            return list;
        }
        List distributions = WslDistributionManager.getInstance().getInstalledDistributions();
        List list = ContainerUtil.map((Collection)distributions, d -> new OpenShellAction(() -> d.getMsId(), List.of("wsl.exe", "-d", d.getMsId()), AllIcons.RunConfigurations.Wsl));
        if (list == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static List<OpenShellAction> detectShells() {
        ArrayList<OpenShellAction> actions = new ArrayList<OpenShellAction>();
        if (SystemInfo.isUnix) {
            for (String unixShellName : UNIX_SHELL_NAMES) {
                ArrayList<String> validExecutablesDirectories = new ArrayList<String>();
                for (String executablesDirectory : UNIX_BINARIES_DIRECTORIES) {
                    String shellPath2 = executablesDirectory + "/" + unixShellName;
                    if (!Files.exists(Path.of(shellPath2, new String[0]), new LinkOption[0])) continue;
                    validExecutablesDirectories.add(executablesDirectory);
                }
                if (validExecutablesDirectories.size() > 1) {
                    for (String executablesDirectory : validExecutablesDirectories) {
                        ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(executablesDirectory + "/" + unixShellName, List.of(), unixShellName + " (" + executablesDirectory + ")")));
                    }
                    continue;
                }
                if (validExecutablesDirectories.size() != 1) continue;
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create((String)validExecutablesDirectories.get(0) + "/" + unixShellName, List.of(), unixShellName)));
            }
        } else if (SystemInfo.isWindows) {
            File cmderInitBat;
            String cmderRoot;
            File gitBash;
            File pwsh;
            File cmd;
            File powershell = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
            if (powershell != null && StringUtil.startsWithIgnoreCase((String)powershell.getAbsolutePath(), (String)"C:\\Windows\\System32\\WindowsPowerShell\\")) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(powershell.getAbsolutePath(), List.of(), "Windows PowerShell")));
            }
            if ((cmd = PathEnvironmentVariableUtil.findInPath((String)"cmd.exe")) != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(cmd.getAbsolutePath(), List.of(), "Command Prompt")));
            }
            if ((pwsh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe")) != null && StringUtil.startsWithIgnoreCase((String)pwsh.getAbsolutePath(), (String)"C:\\Program Files\\PowerShell\\")) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(pwsh.getAbsolutePath(), List.of(), "PowerShell")));
            }
            File gitBashGlobal = new File("C:\\Program Files\\Git\\bin\\bash.exe");
            File gitBashLocal = new File(System.getenv("LocalAppData") + "\\Programs\\Git\\bin\\bash.exe");
            File file = gitBashLocal.isFile() ? gitBashLocal : (gitBash = gitBashGlobal.isFile() ? gitBashGlobal : null);
            if (gitBash != null) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(gitBash.getAbsolutePath(), List.of(), "Git Bash")));
            }
            if ((cmderRoot = EnvironmentUtil.getValue((String)"CMDER_ROOT")) != null && cmd != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\") && (cmderInitBat = new File(cmderRoot, "vendor\\init.bat")).isFile()) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(cmd.getAbsolutePath(), List.of("/k", cmderInitBat.getAbsolutePath()), "Cmder")));
            }
        }
        ArrayList<OpenShellAction> arrayList = actions;
        if (arrayList == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static OpenShellAction create(@NotNull String shellPath2, @NotNull List<String> shellOptions, @NlsSafe String presentableName) {
        if (shellPath2 == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(10);
        }
        if (shellOptions == null) {
            TerminalNewPredefinedSessionAction.$$$reportNull$$$0(11);
        }
        if (Files.exists(Path.of(shellPath2, new String[0]), new LinkOption[0])) {
            List<String> shellCommand = LocalTerminalStartCommandBuilder.convertShellPathToCommand(shellPath2);
            List<String> otherOptions = shellOptions.stream().filter(opt -> !shellCommand.contains(opt)).toList();
            return new OpenShellAction(() -> presentableName, ContainerUtil.concat(shellCommand, otherOptions), null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shells";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/action/TerminalNewPredefinedSessionAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/action/TerminalNewPredefinedSessionAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "listOpenWslShellActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "detectShells";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredPopupPoint";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class TerminalSettingsAction
    extends DumbAwareAction {
        private TerminalSettingsAction() {
            super(IdeBundle.message((String)"action.text.settings", (Object[])new Object[0]), null, AllIcons.General.Settings);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                TerminalSettingsAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) != null) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, configurable -> {
                    ConfigurableWithId withId;
                    return configurable instanceof ConfigurableWithId && "terminal".equals((withId = (ConfigurableWithId)configurable).getId());
                }, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/action/TerminalNewPredefinedSessionAction$TerminalSettingsAction", "actionPerformed"));
        }
    }

    private static final class OpenShellAction
    extends DumbAwareAction {
        private final List<String> myCommand;
        private final Supplier<@NlsActions.ActionText String> myPresentableName;

        private OpenShellAction(@NotNull Supplier<@NlsActions.ActionText String> presentableName, @NotNull List<String> command2, @Nullable Icon icon) {
            if (presentableName == null) {
                OpenShellAction.$$$reportNull$$$0(0);
            }
            if (command2 == null) {
                OpenShellAction.$$$reportNull$$$0(1);
            }
            super(presentableName, icon);
            this.myPresentableName = presentableName;
            this.myCommand = command2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                OpenShellAction.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) != null) {
                TerminalTabState tabState = new TerminalTabState();
                tabState.myTabName = this.myPresentableName.get();
                tabState.myShellCommand = this.myCommand;
                TerminalToolWindowManager.getInstance(project).createNewSession(tabState);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/terminal/action/TerminalNewPredefinedSessionAction$OpenShellAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

