/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer.model;

import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.python.concurrencyVisualizer.PythonConcurrencyVisualizerBundle;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphElement;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphPresentationModel;
import com.intellij.python.concurrencyVisualizer.model.ConcurrencyGraphVisualSettings;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyGraphCellRenderer;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyGraphSettings;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyRenderingUtil;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyTableUtil;
import com.intellij.python.concurrencyVisualizer.tool.panels.ConcurrencyToolWindowPanel;
import com.intellij.ui.table.JBTable;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyTable
extends JBTable {
    private final ConcurrencyGraphPresentationModel myPresentationModel;
    private final ConcurrencyGraphCellRenderer myRenderer;
    private final ConcurrencyToolWindowPanel myPanel;

    public ConcurrencyTable(ConcurrencyGraphPresentationModel presentationModel, TableModel tableModel, ConcurrencyToolWindowPanel panel) {
        this.myPresentationModel = presentationModel;
        this.myPanel = panel;
        this.setModel(tableModel);
        this.myRenderer = new ConcurrencyGraphCellRenderer(this.myPresentationModel, (JTable)((Object)this), this.myPanel);
        this.setDefaultRenderer(ConcurrencyTableUtil.GraphCell.class, (TableCellRenderer)((Object)this.myRenderer));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                Point cursorPoint = e.getPoint();
                ConcurrencyTable.this.myPresentationModel.getGraphModel().setTimeCursor(cursorPoint.x);
                int n = row = ConcurrencyTable.this.rowAtPoint(cursorPoint) >= 0 ? ConcurrencyTable.this.rowAtPoint(cursorPoint) : ConcurrencyTable.this.getSelectedRow();
                if (row >= 0) {
                    int eventIndex = ConcurrencyTable.this.getEventIndex(cursorPoint, row);
                    PyConcurrencyEvent event = eventIndex != -1 ? ConcurrencyTable.this.myPresentationModel.getGraphModel().getEventAt(eventIndex) : null;
                    ConcurrencyTable.this.myPanel.showStackTrace(event);
                }
                ConcurrencyTable.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)new PopUpMenu(e.getPoint()));
                }
            }
        });
    }

    private int getEventIndex(Point clickPoint, int row) {
        ArrayList<ConcurrencyGraphElement> elements;
        int index = ConcurrencyRenderingUtil.getElementIndex(this.myRenderer.getPadding(), this.myPresentationModel.getVisibleGraph(), clickPoint.x);
        if (index != -1 && row < (elements = this.myPresentationModel.getVisibleGraph()[index].getElements()).size()) {
            return elements.get(row).getEventIndex();
        }
        return -1;
    }

    private void drawTimeCursor(@NotNull Graphics g) {
        if (g == null) {
            ConcurrencyTable.$$$reportNull$$$0(0);
        }
        int cursorPosition = Math.max(0, this.myPresentationModel.getCellsNumber() * 1);
        if (this.myPresentationModel.getGraphModel().getTimeCursor() > 0) {
            cursorPosition = this.myPresentationModel.getGraphModel().getTimeCursor();
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(ConcurrencyGraphSettings.TIME_CURSOR_COLOR);
        g2.drawLine(cursorPosition, 0, cursorPosition, this.myPresentationModel.getVisualSettings().getVerticalMax());
    }

    private void paintRuler(@NotNull Graphics g) {
        if (g == null) {
            ConcurrencyTable.$$$reportNull$$$0(1);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(ConcurrencyGraphSettings.RULER_COLOR);
        ConcurrencyGraphVisualSettings settings = this.myPresentationModel.getVisualSettings();
        int y = settings.getVerticalValue() + settings.getVerticalExtent() - 1;
        g.drawLine(0, y, this.getWidth(), y);
        FontMetrics metrics = g.getFontMetrics(this.getFont());
        int rulerUnitWidth = 1 * this.myPresentationModel.getVisualSettings().getCellsPerRulerUnit();
        int horizontalValue = this.myPresentationModel.getVisualSettings().getHorizontalValue();
        for (int i = horizontalValue / rulerUnitWidth; i < (horizontalValue + this.myPresentationModel.getVisualSettings().getHorizontalExtent()) / rulerUnitWidth; ++i) {
            int markY = i % 10 == 0 ? y - 10 : y - 5;
            g.drawLine(i * rulerUnitWidth, markY, i * rulerUnitWidth, y);
            if (i == 0 || i % 10 != 0) continue;
            int ms = this.myPresentationModel.getVisualSettings().getMcsPerCell() * this.myPresentationModel.getVisualSettings().getCellsPerRulerUnit() * i / 1000;
            String text = String.format("%.2f s", Float.valueOf((float)ms / 1000.0f));
            int textWidth = metrics.stringWidth(text);
            int textHeight = metrics.getHeight();
            g.drawString(text, i * rulerUnitWidth - textWidth / 2, markY - textHeight / 3);
        }
    }

    private void painRelations(@NotNull Graphics g) {
        if (g == null) {
            ConcurrencyTable.$$$reportNull$$$0(2);
        }
        ConcurrencyRenderingUtil.paintRelations(g, this.myPresentationModel.getPadding(), this.myPresentationModel.getRelations(), this.myPresentationModel.getGraphModel().isLockSelected());
    }

    private void updateSize() {
        int width = Math.max(this.myPresentationModel.getCellsNumber() * 1, this.myPanel.getGraphPaneWidth());
        int height = this.myPresentationModel.getGraphModel().getMaxThread() * ConcurrencyGraphSettings.TABLE_ROW_HEIGHT;
        if (this.getPreferredSize().getWidth() != (double)width || this.getPreferredSize().getHeight() != (double)height) {
            this.setSize(new Dimension(width, height));
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            ConcurrencyTable.$$$reportNull$$$0(3);
        }
        super.paintComponent(g);
        this.updateSize();
        this.painRelations(g);
        this.paintRuler(g);
        this.drawTimeCursor(g);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "g";
        objectArray2[1] = "com/intellij/python/concurrencyVisualizer/model/ConcurrencyTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "drawTimeCursor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paintRuler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "painRelations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paintComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PopUpMenu
    extends JPopupMenu {
        JMenuItem myShowLocks = new JMenuItem(PythonConcurrencyVisualizerBundle.message("show.related.locks", new Object[0]));
        JMenuItem myHideLocks;

        PopUpMenu(final Point point) {
            this.myShowLocks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row;
                    int n = row = ConcurrencyTable.this.rowAtPoint(point) >= 0 ? ConcurrencyTable.this.rowAtPoint(point) : ConcurrencyTable.this.getSelectedRow();
                    if (row >= 0) {
                        ConcurrencyTable.this.myPresentationModel.applySelectionFilter(ConcurrencyTable.this.getEventIndex(point, row));
                    }
                }
            });
            this.add(this.myShowLocks);
            this.myHideLocks = new JMenuItem(PythonConcurrencyVisualizerBundle.message("hide.related.locks", new Object[0]));
            this.myHideLocks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConcurrencyTable.this.myPresentationModel.getGraphModel().setFilterLockId(null);
                }
            });
            this.add(this.myHideLocks);
        }
    }
}

