/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.python.remoteInterpreter.add.wizard.DeploymentConfigurationUtil;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.jetbrains.plugins.remotesdk.target.webDeployment.WebDeploymentTargetEnvironmentConfiguration;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0003\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00020\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\t*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "webServerConfigIds", "", "Lcom/intellij/openapi/module/Module;", "", "expectedWebServerConfigIdsToIgnore", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "sdkAdded", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "modulesUpdate", "makeWebServerConfigIds", "webServerConfigId", "getWebServerConfigId", "(Lcom/intellij/openapi/projectRoots/Sdk;)Ljava/lang/String;", "ModuleRootListener", "PySshProjectManagerListener", "SdkTableListener", "intellij.python.remoteInterpreter"})
@SourceDebugExtension(value={"SMAP\nPySshInterpreterDeploymentUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,97:1\n1#2:98\n19#3:99\n19#3:100\n*S KotlinDebug\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater\n*L\n85#1:99\n90#1:100\n*E\n"})
final class PySshInterpreterDeploymentUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private Map<Module, String> webServerConfigIds;
    @NotNull
    private final HashSet<String> expectedWebServerConfigIdsToIgnore;

    public PySshInterpreterDeploymentUpdater(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.webServerConfigIds = this.makeWebServerConfigIds();
        this.expectedWebServerConfigIdsToIgnore = new HashSet();
    }

    private final void sdkAdded(Sdk sdk) {
        String id = this.getWebServerConfigId(sdk);
        if (((CharSequence)id).length() > 0) {
            ((Collection)this.expectedWebServerConfigIdsToIgnore).add(id);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void modulesUpdate() {
        Map<Module, String> newMap = this.makeWebServerConfigIds();
        for (Map.Entry<Module, String> entry : newMap.entrySet()) {
            void it;
            String string;
            Module module = entry.getKey();
            String newId = entry.getValue();
            if (Intrinsics.areEqual((Object)this.webServerConfigIds.getOrDefault(module, ""), (Object)newId) || this.expectedWebServerConfigIdsToIgnore.remove(newId)) continue;
            String string2 = string = newId;
            Project project = this.project;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            DeploymentConfigurationUtil.handleSshSdkSwitch(project, bl2 ? string : null);
        }
        this.webServerConfigIds = newMap;
    }

    private final Map<Module, String> makeWebServerConfigIds() {
        WeakHashMap weakHashMap;
        WeakHashMap it = weakHashMap = new WeakHashMap();
        boolean bl = false;
        for (Module module : PyStatisticToolsKt.getModules((Project)this.project)) {
            String webServerConfigId;
            Sdk sdk = PySdkExtKt.getPythonSdk((Module)module);
            String string = webServerConfigId = sdk != null ? this.getWebServerConfigId(sdk) : null;
            if (webServerConfigId == null) continue;
            ((Map)it).put(module, webServerConfigId);
        }
        return weakHashMap;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getWebServerConfigId(Sdk $this$webServerConfigId) {
        String string;
        SdkAdditionalData data = $this$webServerConfigId.getSdkAdditionalData();
        if (data instanceof PyRemoteSdkAdditionalData) {
            WebDeploymentCredentialsHolder webDeploymentCredentialsHolder;
            void $this$asSafely$iv;
            Object object = ((PyRemoteSdkAdditionalData)data).connectionCredentials().getCredentials();
            if (object == null) return "";
            Object object2 = object;
            boolean $i$f$asSafely = false;
            Object v0 = $this$asSafely$iv;
            if (!(v0 instanceof WebDeploymentCredentialsHolder)) {
                v0 = null;
            }
            if ((webDeploymentCredentialsHolder = (WebDeploymentCredentialsHolder)v0) == null) return "";
            string = webDeploymentCredentialsHolder.getWebServerConfigId();
        } else {
            WebDeploymentTargetEnvironmentConfiguration webDeploymentTargetEnvironmentConfiguration;
            void $this$asSafely$iv;
            if (!(data instanceof PyTargetAwareAdditionalData)) return "";
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = ((PyTargetAwareAdditionalData)data).getTargetEnvironmentConfiguration();
            boolean $i$f$asSafely = false;
            Object v2 = $this$asSafely$iv;
            if (!(v2 instanceof WebDeploymentTargetEnvironmentConfiguration)) {
                v2 = null;
            }
            if ((webDeploymentTargetEnvironmentConfiguration = (WebDeploymentTargetEnvironmentConfiguration)v2) == null) return "";
            targetEnvironmentConfiguration = webDeploymentTargetEnvironmentConfiguration.findWebServerConfig(this.project);
            if (targetEnvironmentConfiguration == null) return "";
            string = targetEnvironmentConfiguration.getId();
        }
        String string2 = string;
        if (string != null) return string2;
        return "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$ModuleRootListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rootsChanged", "", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "intellij.python.remoteInterpreter"})
    @SourceDebugExtension(value={"SMAP\nPySshInterpreterDeploymentUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$ModuleRootListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n31#2,2:98\n*S KotlinDebug\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$ModuleRootListener\n*L\n34#1:98,2\n*E\n"})
    public static final class ModuleRootListener
    implements com.intellij.openapi.roots.ModuleRootListener {
        @NotNull
        private final Project project;

        public ModuleRootListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<PySshInterpreterDeploymentUpdater> serviceClass$iv = PySshInterpreterDeploymentUpdater.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((PySshInterpreterDeploymentUpdater)object).modulesUpdate();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$PySshProjectManagerListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "<init>", "()V", "projectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.remoteInterpreter"})
    @SourceDebugExtension(value={"SMAP\nPySshInterpreterDeploymentUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$PySshProjectManagerListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n31#2,2:98\n*S KotlinDebug\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$PySshProjectManagerListener\n*L\n40#1:98,2\n*E\n"})
    public static final class PySshProjectManagerListener
    implements ProjectManagerListener {
        public void projectOpened(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PySshInterpreterDeploymentUpdater> serviceClass$iv = PySshInterpreterDeploymentUpdater.class;
            if ($this$service$iv.getService(serviceClass$iv) == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$SdkTableListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "jdkAdded", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.python.remoteInterpreter"})
    @SourceDebugExtension(value={"SMAP\nPySshInterpreterDeploymentUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$SdkTableListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n31#2,2:98\n*S KotlinDebug\n*F\n+ 1 PySshInterpreterDeploymentUpdater.kt\ncom/intellij/python/remoteInterpreter/PySshInterpreterDeploymentUpdater$SdkTableListener\n*L\n46#1:98,2\n*E\n"})
    public static final class SdkTableListener
    implements ProjectJdkTable.Listener {
        @NotNull
        private final Project project;

        public SdkTableListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void jdkAdded(@NotNull Sdk jdk) {
            Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<PySshInterpreterDeploymentUpdater> serviceClass$iv = PySshInterpreterDeploymentUpdater.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((PySshInterpreterDeploymentUpdater)object).sdkAdded(jdk);
        }
    }
}

