/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.references;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactsIndex;
import com.intellij.lang.puppet.psi.PuppetClassDefinition;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.references.PuppetPolyVariantCachingReferenceWithFullQualifiedName;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetClassStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTopLevelVariablesStubsIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PuppetVariableReference
extends PuppetPolyVariantCachingReferenceWithFullQualifiedName<PuppetVariable> {
    public PuppetVariableReference(PuppetVariable psiElement, TextRange range) {
        super(psiElement, range, psiElement.getFullQualifiedName());
    }

    @Override
    @NotNull
    protected String adjustNewName(@NonNls String newElementName) {
        String string = newElementName;
        if (string == null) {
            PuppetVariableReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected ResolveResult @NotNull [] resolveInner(boolean incompleteCode) {
        if (StringUtil.isEmpty((String)this.myFullQualifiedName)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PuppetVariableReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (((PuppetVariable)this.myElement).isFullQualified()) {
            String namespaceName = ((PuppetVariable)this.myElement).getNamespaceName();
            assert (namespaceName != null);
            String variableName = ((PuppetVariable)this.myElement).getName();
            assert (variableName != null);
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            if (namespaceName.equals("")) {
                List<PsiElement> externalFacts = PuppetFactsIndex.findElementsByKey(variableName, ((PuppetVariable)this.myElement).getProject(), ((PuppetVariable)this.myElement).getResolveScope(), Integer.MAX_VALUE);
                boolean foundFact = !externalFacts.isEmpty();
                result.addAll(externalFacts);
                for (PuppetVariable puppetVariable : PuppetTopLevelVariablesStubsIndex.getInstance().find(variableName, this.myElement)) {
                    if (puppetVariable.isCoreFact() && foundFact) continue;
                    result.add(puppetVariable);
                }
            } else {
                PsiElementProcessor variableProcessor = variable -> {
                    if (StringUtil.equals((CharSequence)variableName, (CharSequence)variable.getName())) {
                        result.add(variable);
                        return false;
                    }
                    return true;
                };
                PsiElementProcessor parentClassProcessor = parentClass -> parentClass.processVariablesDeclarations(variableProcessor);
                Collection classDefinitions = PuppetClassStubsIndex.getInstance().find(namespaceName, this.myElement);
                for (PuppetClassDefinition classDefinition : classDefinitions) {
                    if (!classDefinition.processVariablesDeclarations(variableProcessor)) continue;
                    classDefinition.processParentClasses((PsiElementProcessor<? super PuppetClassDefinition>)parentClassProcessor);
                }
            }
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(result);
            if (resolveResultArray == null) {
                PuppetVariableReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        Collection<PsiElement> lexicalVariableDeclarations = PuppetResolveUtil.getLexicalVariableDeclaration((PuppetVariable)this.myElement);
        if (!lexicalVariableDeclarations.isEmpty()) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(lexicalVariableDeclarations);
            if (resolveResultArray == null) {
                PuppetVariableReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            PuppetVariableReference.$$$reportNull$$$0(4);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = PuppetBundle.message("puppet.type.names.variable", new Object[0]);
        if (string == null) {
            PuppetVariableReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/puppet/psi/references/PuppetVariableReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustNewName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

