/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeGuardFixHelper {
    public static final String CALL_PROP = new String("_$_$WS_TG_call$_$_");
    public static final String INDEXER_PROP = new String("_$_$WS_TG_idx$_$_");

    public static boolean addTypeGuardFixes(@NotNull JSExpression qualifier, @NotNull @NotNull Collection<? super @NotNull LocalQuickFix> fixes, @NotNull String name) {
        String key;
        int properCandidatesCount;
        if (qualifier == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(0);
        }
        if (fixes == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(1);
        }
        if (name == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(2);
        }
        JSType qualifierType = TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive(qualifier);
        ArrayList<JSType> candidateTypes = new ArrayList<JSType>();
        HashMap<String, JSType> candidateLiteralTypes = new HashMap<String, JSType>();
        HashMap<String, JSType> candidateNegativeLiteralTypes = new HashMap<String, JSType>();
        ArrayList<JSType> notHavingPropTypes = new ArrayList<JSType>();
        HashSet<String> literalProps = new HashSet<String>();
        HashSet<String> bannedPropsForLiterals = new HashSet<String>();
        HashMap<JSType, String> inGuardCandidates = new HashMap<JSType, String>();
        if (qualifierType instanceof JSUnionType) {
            List<JSType> types = ((JSUnionType)qualifierType).getTypes();
            int i = -1;
            for (JSType type2 : types) {
                ++i;
                JSRecordType recordType = type2.asRecordType();
                boolean hasProperty = !Strings.areSameInstance((String)name, (String)CALL_PROP) && recordType.hasProperty(name);
                for (JSRecordType.PropertySignature member : recordType.getProperties()) {
                    String memberName = member.getMemberName();
                    if (!Strings.areSameInstance((String)name, (String)CALL_PROP) && name.equals(memberName)) {
                        inGuardCandidates.put(type2, memberName);
                        continue;
                    }
                    if (bannedPropsForLiterals.contains(memberName)) continue;
                    if (i > 0 && !literalProps.contains(memberName)) {
                        bannedPropsForLiterals.add(memberName);
                        continue;
                    }
                    JSType memberType = member.getJSType();
                    if (JSTypeUtils.isLiteralType(memberType, true)) {
                        literalProps.add(memberName);
                        if (hasProperty) {
                            candidateLiteralTypes.put(memberName, memberType);
                            continue;
                        }
                        candidateNegativeLiteralTypes.put(memberName, memberType);
                        continue;
                    }
                    bannedPropsForLiterals.add(memberName);
                }
                if (Strings.areSameInstance((String)name, (String)CALL_PROP) && recordType.getCallSignatures().stream().anyMatch(s -> !s.hasNew()) || Strings.areSameInstance((String)name, (String)INDEXER_PROP) && (recordType.hasProperties() || recordType.hasIndexers())) {
                    candidateTypes.add(type2);
                    continue;
                }
                if (hasProperty) {
                    candidateTypes.add(type2);
                    continue;
                }
                notHavingPropTypes.add(type2);
            }
        }
        if ((properCandidatesCount = candidateTypes.size()) == 0) {
            return false;
        }
        boolean hasOnlyOneNonMatch = notHavingPropTypes.size() == 1;
        int candidatesCount = properCandidatesCount + (hasOnlyOneNonMatch ? 1 : 0);
        boolean isInConditional = TypeScriptTypeGuardFixHelper.isInConditionInstruction(qualifier);
        boolean isStatementInsertionAllowed = TypeScriptTypeGuardFixHelper.isStatementInsertionAllowed(qualifier);
        for (String key2 : literalProps) {
            if (bannedPropsForLiterals.contains(key2) || !candidateLiteralTypes.containsKey(key2)) continue;
            JSType type3 = (JSType)candidateLiteralTypes.get(key2);
            TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, type3, key2, null, false, false, isInConditional, isStatementInsertionAllowed, true);
            if (isStatementInsertionAllowed && TypeScriptTypeGuardFixHelper.isSwitchableType(type3)) {
                fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type3, new JSTypeGuardFixData(TypeGuardSurroundKind.SwitchStatement, key2, null, false, true)));
            }
            ++candidatesCount;
        }
        if (candidateNegativeLiteralTypes.size() == 1 && !bannedPropsForLiterals.contains(key = (String)candidateNegativeLiteralTypes.keySet().iterator().next())) {
            JSType candidate = (JSType)candidateNegativeLiteralTypes.get(key);
            TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, candidate, key, null, true, false, isInConditional, isStatementInsertionAllowed, true);
            ++candidatesCount;
        }
        for (JSType candidateType : candidateTypes) {
            TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, candidateType, null, (String)inGuardCandidates.get(candidateType), false, candidatesCount <= 2, isInConditional, isStatementInsertionAllowed, true);
        }
        if (!notHavingPropTypes.isEmpty()) {
            if (notHavingPropTypes.stream().allMatch(t -> t instanceof JSNullType || t instanceof JSUndefinedType)) {
                TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, (JSType)notHavingPropTypes.get(0), null, null, true, candidatesCount <= 2, isInConditional, isStatementInsertionAllowed, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(candidateTypes));
            } else if (hasOnlyOneNonMatch) {
                TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, (JSType)notHavingPropTypes.get(0), null, null, true, candidatesCount <= 2, isInConditional, isStatementInsertionAllowed, true);
            }
        }
        return true;
    }

    public static boolean canSimplifyNullCheck(List<? extends JSType> types) {
        for (JSType jSType : types) {
            if (jSType instanceof JSStringType || jSType instanceof JSNumberType || jSType instanceof JSBigIntType) {
                return false;
            }
            if (!(jSType instanceof JSUnionType) || TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(((JSUnionType)jSType).getTypes())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSwitchableType(@Nullable JSType type2) {
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return true;
        }
        if (type2 instanceof JSResolvableType) {
            JSResolvedTypeInfo typeInfo = ((JSResolvableType)type2).resolveType();
            return typeInfo.isEnumLiteral();
        }
        return false;
    }

    private static boolean isStatementInsertionAllowed(@NotNull JSExpression expression) {
        JSStatement statement;
        if (expression == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(3);
        }
        return (statement = (JSStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)expression, (Class[])new Class[]{JSStatement.class})) instanceof JSExpressionStatement || statement instanceof JSVarStatement;
    }

    private static boolean isInConditionInstruction(@NotNull JSExpression expression) {
        JSConditionOwner conditionalExpression;
        if (expression == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(4);
        }
        if ((conditionalExpression = (JSConditionOwner)PsiTreeUtil.getContextOfType((PsiElement)expression, JSConditionOwner.class, (boolean)true, (Class[])new Class[]{JSStatement.class})) != null && PsiTreeUtil.isContextAncestor((PsiElement)conditionalExpression.getCondition(), (PsiElement)expression, (boolean)false)) {
            return true;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, JSBinaryExpression.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
        return binaryExpression != null && (binaryExpression.getOperationSign() == JSTokenTypes.ANDAND || binaryExpression.getOperationSign() == JSTokenTypes.OROR) && PsiTreeUtil.isContextAncestor((PsiElement)binaryExpression.getLOperand(), (PsiElement)expression, (boolean)false);
    }

    private static void addAllTypeGuardFixes(@NotNull JSExpression qualifier, @NotNull @NotNull Collection<? super @NotNull LocalQuickFix> fixes, @NotNull JSType type2, @Nullable String discriminatedPropertyName, @Nullable String propertyNameForInGuard, boolean isNegative, boolean addExtras, boolean isConditionalContext, boolean isStatementInsertionAllowed, boolean allowSimplifyForNullable) {
        if (qualifier == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(6);
        }
        if (type2 == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(7);
        }
        if (isStatementInsertionAllowed) {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type2, new JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, discriminatedPropertyName, propertyNameForInGuard, isNegative, allowSimplifyForNullable)));
        }
        if (!isStatementInsertionAllowed || addExtras) {
            if (!isConditionalContext) {
                fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type2, new JSTypeGuardFixData(TypeGuardSurroundKind.Ternary, discriminatedPropertyName, propertyNameForInGuard, isNegative, allowSimplifyForNullable)));
            } else {
                fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type2, new JSTypeGuardFixData(TypeGuardSurroundKind.And, discriminatedPropertyName, propertyNameForInGuard, isNegative, allowSimplifyForNullable)));
                fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type2, new JSTypeGuardFixData(TypeGuardSurroundKind.Or, discriminatedPropertyName, propertyNameForInGuard, isNegative, allowSimplifyForNullable)));
            }
            if (qualifier instanceof JSReferenceExpression && allowSimplifyForNullable && discriminatedPropertyName == null && !isNegative) {
                fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type2, new JSTypeGuardFixData(TypeGuardSurroundKind.OptionalChaining, null, propertyNameForInGuard, false, true)));
                fixes.add((LocalQuickFix)JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type2, new JSTypeGuardFixData(TypeGuardSurroundKind.NullishCoalescing, null, propertyNameForInGuard, false, true)));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeGuardFixHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeGuardFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatementInsertionAllowed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInConditionInstruction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addAllTypeGuardFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JSTypeGuardFixData {
        @NotNull
        private final TypeGuardSurroundKind mySurroundKind;
        @Nullable
        private final String myDiscriminatedPropertyName;
        @Nullable
        private final String myPropertyNameForInGuard;
        private final boolean myIsNegative;
        private final boolean myAllowSimplifyForNullable;

        public JSTypeGuardFixData(@NotNull TypeGuardSurroundKind surroundKind, @Nullable String discriminatedPropertyName, @Nullable String propertyNameForInGuard, boolean isNegative, boolean allowSimplifyForNullable) {
            if (surroundKind == null) {
                JSTypeGuardFixData.$$$reportNull$$$0(0);
            }
            this.mySurroundKind = surroundKind;
            this.myDiscriminatedPropertyName = discriminatedPropertyName;
            this.myPropertyNameForInGuard = propertyNameForInGuard;
            this.myIsNegative = isNegative;
            this.myAllowSimplifyForNullable = allowSimplifyForNullable;
        }

        @NotNull
        public TypeGuardSurroundKind getSurroundKind() {
            TypeGuardSurroundKind typeGuardSurroundKind = this.mySurroundKind;
            if (typeGuardSurroundKind == null) {
                JSTypeGuardFixData.$$$reportNull$$$0(1);
            }
            return typeGuardSurroundKind;
        }

        @Nullable
        public String getDiscriminatedPropertyName() {
            return this.myDiscriminatedPropertyName;
        }

        public boolean isNegative() {
            return this.myIsNegative;
        }

        public boolean isAllowSimplifyForNullable() {
            return this.myAllowSimplifyForNullable;
        }

        @Nullable
        public String getPropertyNameForInGuard() {
            return this.myPropertyNameForInGuard;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surroundKind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeGuardFixHelper$JSTypeGuardFixData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeGuardFixHelper$JSTypeGuardFixData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSurroundKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

