/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.recordImpl.ComputedPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0013\u001a\u00020\rH\u0002J(\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u00192\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSObjectLiteralTypeEvaluator;", "", "evaluatePropertyTypes", "", "isContextualOverloadEvaluation", "isAstAccessAllowed", "<init>", "(ZZZ)V", "evaluate", "Lcom/intellij/lang/javascript/psi/JSType;", "expression", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "mergeIfOptional", "Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;", "typeSource", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "propertyMembers", "", "", "member", "addMember", "", "nonPropertyMembers", "Ljava/util/ArrayList;", "Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;", "Lkotlin/collections/ArrayList;", "getTypeMemberFromSimplePropertyValue", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "modifyTypeIfAccessor", "type", "getWidenedPropertyType", "contextualOwner", "intellij.javascript.psi.impl"})
public final class JSObjectLiteralTypeEvaluator {
    private final boolean evaluatePropertyTypes;
    private final boolean isContextualOverloadEvaluation;
    private final boolean isAstAccessAllowed;

    public JSObjectLiteralTypeEvaluator(boolean evaluatePropertyTypes, boolean isContextualOverloadEvaluation, boolean isAstAccessAllowed) {
        this.evaluatePropertyTypes = evaluatePropertyTypes;
        this.isContextualOverloadEvaluation = isContextualOverloadEvaluation;
        this.isAstAccessAllowed = isAstAccessAllowed;
    }

    @NotNull
    public final JSType evaluate(@NotNull JSObjectLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        JSElement[] jSElementArray = expression.getPropertiesIncludingSpreads();
        Intrinsics.checkNotNullExpressionValue((Object)jSElementArray, (String)"getPropertiesIncludingSpreads(...)");
        JSElement[] properties2 = jSElementArray;
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true);
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource, (String)"createTypeSource(...)");
        JSTypeSource typeSource = jSTypeSource;
        Map propertyMembers = new LinkedHashMap();
        ArrayList<JSRecordType.TypeMember> nonPropertyMembers = new ArrayList<JSRecordType.TypeMember>();
        List syntheticStringIndexerTypes = (List)new SmartList();
        List syntheticNumericIndexerTypes = (List)new SmartList();
        List syntheticSymbolIndexerTypes = (List)new SmartList();
        boolean hasComputedStringProperty = false;
        boolean hasComputedNumberProperty = false;
        boolean hasComputedSymbolProperty = false;
        List unexpandedTypes = new ArrayList();
        for (JSElement property : properties2) {
            JSType spreadType;
            if (property instanceof JSProperty) {
                ES6ComputedName computedPropertyName;
                JSRecordType.PropertySignature member = this.getTypeMemberFromSimplePropertyValue((JSProperty)property, this.evaluatePropertyTypes);
                if (member != null && member.hasValidName()) {
                    propertyMembers.put(member.getMemberName(), member);
                }
                if (!(property instanceof JSComputedPropertyNameOwner) || (computedPropertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName()) == null || !this.evaluatePropertyTypes) continue;
                JSExpression jsExpression = computedPropertyName.getExpression();
                JSType propNameType = JSResolveUtil.getElementJSType((PsiElement)jsExpression, this.isContextualOverloadEvaluation);
                JSType propNameValuableType = JSTypeUtils.getValuableType(propNameType, (PsiElement)jsExpression);
                if (propNameValuableType instanceof JSAnyType) {
                    hasComputedNumberProperty = true;
                    ContainerUtil.addIfNotNull((Collection)syntheticNumericIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                }
                if (propNameValuableType instanceof JSStringType) {
                    if (!TypeScriptLiteralKeyUtil.isTypeUsableAsPropertyName(propNameValuableType)) {
                        hasComputedStringProperty = true;
                    }
                    ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                }
                if (propNameValuableType instanceof JSNumberType) {
                    if (!TypeScriptLiteralKeyUtil.isTypeUsableAsPropertyName(propNameValuableType)) {
                        hasComputedNumberProperty = true;
                    }
                    JSType propertyType = this.getWidenedPropertyType((JSProperty)property);
                    ContainerUtil.addIfNotNull((Collection)syntheticNumericIndexerTypes, (Object)propertyType);
                    ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)propertyType);
                }
                if (!(propNameValuableType instanceof JSSymbolType)) continue;
                if (!TypeScriptLiteralKeyUtil.isTypeUsableAsPropertyName(propNameValuableType)) {
                    hasComputedSymbolProperty = true;
                }
                ContainerUtil.addIfNotNull((Collection)syntheticSymbolIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                continue;
            }
            if (!(property instanceof JSSpreadExpression) || (spreadType = JSTypeUtils.getValuableType(((JSSpreadExpression)property).getInnerExpressionType(), (PsiElement)property)) == null) continue;
            if (spreadType instanceof JSAnyType) {
                JSTypeSource jSTypeSource2 = ((JSAnyType)spreadType).getSource();
                Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource2, (String)"getSource(...)");
                JSTypeSource source = jSTypeSource2;
                if (((JSAnyType)spreadType).isTypeScript()) {
                    return spreadType;
                }
                PsiElement sourceElement = ((JSAnyType)spreadType).getSourceElement();
                if (sourceElement == null) {
                    sourceElement = (PsiElement)property;
                }
                return new JSRecordTypeImpl(source, CollectionsKt.listOf((Object)new IndexSignatureImpl((JSType)JSNamedTypeFactory.createStringPrimitiveType(source), spreadType, JSRecordMemberSourceFactory.createSource(sourceElement), false)));
            }
            if (JSTypeUtils.hasForeignGenericParameter(spreadType) || spreadType instanceof JSEvaluableOnlyType && ((JSEvaluableOnlyType)spreadType).isJavaScript()) {
                unexpandedTypes.add(spreadType);
                continue;
            }
            for (JSRecordType.TypeMember member : spreadType.asRecordType().getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    if (member instanceof PsiElement && JSUtils.isPrivateSharpItem((PsiElement)member)) continue;
                    propertyMembers.put(((JSRecordType.PropertySignature)member).getMemberName(), this.mergeIfOptional(typeSource, propertyMembers, (JSRecordType.PropertySignature)member));
                    continue;
                }
                if (spreadType.getSourceElement() instanceof TypeScriptEnum && member instanceof JSRecordType.IndexSignature) continue;
                Intrinsics.checkNotNull((Object)member);
                this.addMember(nonPropertyMembers, member);
            }
        }
        if (hasComputedStringProperty && !syntheticStringIndexerTypes.isEmpty()) {
            this.addMember(nonPropertyMembers, new IndexSignatureImpl((JSType)JSNamedTypeFactory.createStringPrimitiveType(typeSource), JSCompositeTypeFactory.createUnionType(typeSource, syntheticStringIndexerTypes).substitute(), null, true));
        }
        if (hasComputedNumberProperty && !syntheticNumericIndexerTypes.isEmpty()) {
            this.addMember(nonPropertyMembers, new IndexSignatureImpl((JSType)JSNamedTypeFactory.createNumberPrimitiveType(typeSource), JSCompositeTypeFactory.createUnionType(typeSource, syntheticNumericIndexerTypes).substitute(), null, true));
        }
        if (hasComputedSymbolProperty && !syntheticSymbolIndexerTypes.isEmpty()) {
            this.addMember(nonPropertyMembers, new IndexSignatureImpl((JSType)JSNamedTypeFactory.createSymbolPrimitiveType(typeSource), JSCompositeTypeFactory.createUnionType(typeSource, syntheticSymbolIndexerTypes).substitute(), null, true));
        }
        JSFreshObjectLiteralTypeImpl literalType = new JSFreshObjectLiteralTypeImpl(typeSource, ContainerUtil.concat((List)nonPropertyMembers, (List)new ArrayList(propertyMembers.values())));
        if (unexpandedTypes.isEmpty()) {
            return literalType;
        }
        if (literalType.hasMembers()) {
            unexpandedTypes.add(literalType);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType((Collection<? extends JSType>)unexpandedTypes, typeSource, true);
        Intrinsics.checkNotNullExpressionValue((Object)jSType, (String)"createIntersectionType(...)");
        return jSType;
    }

    private final JSRecordType.PropertySignature mergeIfOptional(JSTypeSource typeSource, Map<String, ? extends JSRecordType.PropertySignature> propertyMembers, JSRecordType.PropertySignature member) {
        String string = member.getMemberName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
        String memberName = string;
        if (propertyMembers.containsKey(memberName) && member.isOptional()) {
            JSRecordType.PropertySignature oldMember;
            JSRecordType.PropertySignature propertySignature = oldMember = propertyMembers.get(memberName);
            Intrinsics.checkNotNull((Object)propertySignature);
            return new PropertySignatureImpl(memberName, JSCompositeTypeFactory.getCommonType((JSType)ObjectUtils.coalesce((Object)propertySignature.getJSType(), (Object)JSAnyType.get(typeSource)), (JSType)ObjectUtils.coalesce((Object)member.getJSType(), (Object)JSAnyType.get(typeSource)), typeSource, true), oldMember.isOptional() && member.isOptional(), oldMember.isConst() || member.isConst());
        }
        return member;
    }

    private final void addMember(ArrayList<JSRecordType.TypeMember> nonPropertyMembers, JSRecordType.TypeMember member) {
        boolean memberSet = false;
        if (member instanceof JSRecordType.IndexSignature) {
            int n = ((Collection)nonPropertyMembers).size();
            for (int i = 0; i < n; ++i) {
                JSType memberParameterType;
                JSRecordType.TypeMember propertyMember;
                Intrinsics.checkNotNullExpressionValue((Object)nonPropertyMembers.get(i), (String)"get(...)");
                if (!(propertyMember instanceof JSRecordType.IndexSignature)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((JSRecordType.IndexSignature)propertyMember).getMemberParameterType(), (String)"getMemberParameterType(...)");
                if (!memberParameterType.isEquivalentTo(((JSRecordType.IndexSignature)member).getMemberParameterType(), null, false)) continue;
                nonPropertyMembers.set(i, member);
                memberSet = true;
            }
        }
        if (!memberSet) {
            nonPropertyMembers.add(member);
        }
    }

    private final JSRecordType.PropertySignature getTypeMemberFromSimplePropertyValue(JSProperty property, boolean evaluatePropertyTypes) {
        String name = property.getName();
        if (name == null && property instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets(property);
        }
        if (name == null && !(property instanceof JSComputedPropertyNameOwner)) {
            return null;
        }
        JSType type2 = null;
        if (property instanceof JSFunctionProperty) {
            type2 = TypeScriptTypeParser.buildFunctionType((JSFunction)((Object)property));
        } else {
            type2 = this.getWidenedPropertyType(property);
            if (!DialectDetector.isTypeScript((PsiElement)property) && !property.requiresTypeChecking() && evaluatePropertyTypes) {
                type2 = JSResolveUtil.getElementJSType((PsiElement)property.getValue(), this.isContextualOverloadEvaluation);
            }
        }
        type2 = this.modifyTypeIfAccessor(property, type2);
        if (name == null) {
            String referenceName;
            ES6ComputedName propertyName;
            Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner");
            ES6ComputedName eS6ComputedName = propertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName();
            String string = referenceName = eS6ComputedName != null ? eS6ComputedName.getExpressionAsReferenceName() : null;
            if (referenceName != null) {
                return new ComputedPropertySignatureImpl(referenceName, type2, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)((Object)property)).isConst(), JSRecordMemberSourceFactory.createSource((PsiElement)property));
            }
            return null;
        }
        return new PropertySignatureImpl(name, false, -1, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)((Object)property)).isConst(), type2, null, false, property.isNumericKey(), JSRecordMemberSourceFactory.createSource((PsiElement)property));
    }

    private final JSType modifyTypeIfAccessor(JSProperty property, JSType type2) {
        boolean isGetter = property.isGetProperty();
        boolean isSetter = property.isSetProperty();
        if (!isGetter && !isSetter) {
            return type2;
        }
        if (type2 instanceof JSFunctionTypeImpl) {
            if (isGetter) {
                return ((JSFunctionTypeImpl)type2).getReturnType();
            }
            List<JSParameterTypeDecorator> list = ((JSFunctionTypeImpl)type2).getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            List<JSParameterTypeDecorator> parameters2 = list;
            if (!parameters2.isEmpty()) {
                return parameters2.get(0).getSimpleType();
            }
        }
        return JSAnyType.get(JSTypeSourceFactory.createTypeSource((PsiElement)property, false));
    }

    private final JSType getWidenedPropertyType(JSProperty contextualOwner) {
        JSType exprType = contextualOwner.getJSType();
        if (exprType == null || this.isContextualOverloadEvaluation) {
            return exprType;
        }
        if (!(exprType instanceof JSEvaluableType) && !JSTypeUtils.isLiteralOrCompositeWithLiteralType(exprType)) {
            return exprType;
        }
        return TypeScriptTypeEvaluator.createWidening(exprType, (PsiElement)contextualOwner, this.isAstAccessAllowed);
    }
}

