/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExitPoint;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSUtils {
    public static final String DUMMY_FILE_NAME_PREFIX = "dummy.";
    private static final Logger LOG = Logger.getInstance(JSUtils.class);

    public static boolean isJavaScriptFile(PsiFile file) {
        return file != null && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    @Nullable
    public static PsiElement findFunctionAnchor(@Nullable PsiElement scope2, @Nullable PsiElement functionAnchor, boolean shouldPlaceAtScopeStart) {
        PsiElement grandParent;
        PsiComment docComment;
        if (scope2 == null || functionAnchor == null) {
            return null;
        }
        PsiElement originalAnchor = functionAnchor;
        while (functionAnchor != null && functionAnchor.getParent() != scope2) {
            functionAnchor = functionAnchor.getParent();
        }
        if (functionAnchor instanceof JSProperty && (docComment = JSDocumentationUtils.findDocComment(functionAnchor)) != null) {
            functionAnchor = docComment;
        }
        if ((grandParent = scope2.getParent()) instanceof JSFunction && shouldPlaceAtScopeStart) {
            JSStatement statement = JSPsiImplUtils.findFirstFunctionStatement((JSFunction)grandParent);
            while (statement instanceof JSVarStatement && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)grandParent, (boolean)true) || statement instanceof PsiWhiteSpace || statement instanceof PsiComment) {
                statement = statement.getNextSibling();
            }
            if (statement != null) {
                return statement;
            }
        }
        return JSDialectSpecificHandlersFactory.forElement(originalAnchor).adjustFunctionAnchor(functionAnchor, scope2, originalAnchor);
    }

    public static PsiElement findStatementAnchor(@Nullable PsiElement referenceExpression) {
        return JSUtils.findStatementAnchor(referenceExpression, false);
    }

    @Nullable
    public static PsiElement findStatementAnchor(@Nullable PsiElement referenceExpression, boolean withSource) {
        PsiElement dialectSpecificAnchor;
        PsiElement blockParent;
        JSSourceElement anchor;
        if (referenceExpression == null) {
            return null;
        }
        JSSourceElement jSSourceElement = anchor = withSource ? JSUtils.findSourceAnchor(referenceExpression, DialectDetector.isActionScript(referenceExpression)) : (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSStatement.class);
        if (anchor instanceof JSPackageStatement) {
            return null;
        }
        if (anchor instanceof JSVarStatement && anchor.getParent() instanceof JSVariableDeclaringScope) {
            anchor = (JSSourceElement)anchor.getParent();
        }
        if (anchor instanceof JSBlockStatement && ((blockParent = anchor.getParent()) instanceof JSLoopStatement || blockParent instanceof JSIfStatement || blockParent instanceof JSTryStatement)) {
            anchor = (JSSourceElement)blockParent;
        }
        if (anchor instanceof JSLoopStatement && anchor.getParent() instanceof JSLabeledStatement) {
            anchor = (JSSourceElement)anchor.getParent();
        }
        if ((dialectSpecificAnchor = JSDialectSpecificHandlersFactory.forElement(referenceExpression).adjustStatementAnchor(anchor, referenceExpression)) == anchor) {
            JSEmbeddedContent scriptTagAnchor;
            PsiFile file = referenceExpression.getContainingFile();
            if (file instanceof XmlFile && PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, XmlAttributeValue.class) != null && (scriptTagAnchor = JSUtils.findScriptTagContent((XmlFile)file)) != null) {
                return scriptTagAnchor;
            }
            return anchor;
        }
        return dialectSpecificAnchor;
    }

    @Nullable
    public static JSEmbeddedContent findScriptTagContent(@NotNull XmlFile file) {
        JSEmbeddedContent content;
        XmlTag[] heads;
        XmlFile root;
        XmlTag rootTag;
        if (file == null) {
            JSUtils.$$$reportNull$$$0(0);
        }
        if ((rootTag = (root = JSUtils.getRootXmlFile(file)).getRootTag()) == null) {
            return null;
        }
        for (XmlTag headTag : heads = rootTag.findSubTags("head")) {
            JSEmbeddedContent content2 = JSUtils.findScriptTagWithEmbeddedContent(headTag);
            if (content2 == null) continue;
            return content2;
        }
        if (heads.length > 0) {
            return null;
        }
        if ("html".equals(rootTag.getName()) && (content = JSUtils.findScriptTagWithEmbeddedContent(rootTag)) != null) {
            return content;
        }
        XmlDocument document = root.getDocument();
        if (document == null) {
            return null;
        }
        XmlTag[] children = (XmlTag[])PsiTreeUtil.getChildrenOfType((PsiElement)document, XmlTag.class);
        if (children != null) {
            for (XmlTag child : children) {
                JSEmbeddedContent content3;
                if (!"script".equals(child.getLocalName()) || (content3 = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)child, JSEmbeddedContent.class)) == null) continue;
                return content3;
            }
        }
        return null;
    }

    @NotNull
    private static XmlFile getRootXmlFile(@NotNull XmlFile file) {
        TemplateLanguageFileViewProvider viewProvider;
        PsiFile psi;
        XmlFile root;
        FileViewProvider fileViewProvider;
        if (file == null) {
            JSUtils.$$$reportNull$$$0(1);
        }
        if ((fileViewProvider = (root = file).getViewProvider()) instanceof TemplateLanguageFileViewProvider && (psi = (viewProvider = (TemplateLanguageFileViewProvider)fileViewProvider).getPsi(viewProvider.getTemplateDataLanguage())) instanceof XmlFile) {
            root = (XmlFile)psi;
        }
        XmlFile xmlFile = root;
        if (xmlFile == null) {
            JSUtils.$$$reportNull$$$0(2);
        }
        return xmlFile;
    }

    @Nullable
    private static JSEmbeddedContent findScriptTagWithEmbeddedContent(@NotNull XmlTag tag) {
        XmlTag[] scriptTags;
        if (tag == null) {
            JSUtils.$$$reportNull$$$0(3);
        }
        for (XmlTag scriptTag : scriptTags = tag.findSubTags("script")) {
            JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)scriptTag, JSEmbeddedContent.class);
            if (embeddedContent == null) continue;
            return embeddedContent;
        }
        return null;
    }

    @Nullable
    public static JSSourceElement findSourceAnchor(PsiElement expression, boolean acceptMembers) {
        JSSourceElement anchor = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSSourceElement.class, (boolean)true);
        if (anchor == null || anchor instanceof JSStatement && (acceptMembers || !JSUtils.isMember((PsiElement)anchor))) {
            return anchor;
        }
        if (!(anchor instanceof JSExpression || !acceptMembers && JSUtils.isMember((PsiElement)anchor))) {
            return anchor;
        }
        return JSUtils.findSourceAnchor((PsiElement)anchor, acceptMembers);
    }

    @NotNull
    public static JSAttributeList.AccessType getImplicitAccessType(@NotNull PsiElement element) {
        boolean typeScript;
        PsiElement parent;
        if (element == null) {
            JSUtils.$$$reportNull$$$0(4);
        }
        if ((parent = element.getContext()) == null) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
            if (accessType == null) {
                JSUtils.$$$reportNull$$$0(5);
            }
            return accessType;
        }
        if (parent instanceof JSClass && ((JSClass)parent).isInterface()) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                JSUtils.$$$reportNull$$$0(6);
            }
            return accessType;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        boolean bl = typeScript = dialect != null && dialect.isTypeScript;
        if (typeScript) {
            if (TypeScriptModule.isImplicitExportAvailable(element) && (parent instanceof JSFile && !((JSFile)parent).isCommonJSModule() || TypeScriptPsiUtil.hasImplicitExportForDeclarations(parent))) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    JSUtils.$$$reportNull$$$0(7);
                }
                return accessType;
            }
            JSAttributeListOwner firstAttributeListParent = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)parent, JSAttributeListOwner.class, (boolean)false);
            if (firstAttributeListParent instanceof TypeScriptModule) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
                if (accessType == null) {
                    JSUtils.$$$reportNull$$$0(8);
                }
                return accessType;
            }
        }
        JSAttributeList.AccessType accessType = dialect != null && dialect.isECMA4 ? JSAttributeList.AccessType.PACKAGE_LOCAL : JSAttributeList.AccessType.PUBLIC;
        if (accessType == null) {
            JSUtils.$$$reportNull$$$0(9);
        }
        return accessType;
    }

    @Contract(value="null->false")
    public static boolean isMember(@Nullable PsiElement element) {
        return JSUtils.getMemberContainingClass(element) != null;
    }

    @Contract(value="null->null")
    public static JSClass getMemberContainingClass(@Nullable PsiElement methodOrField) {
        PsiElement clazz = null;
        if (methodOrField instanceof JSFunction) {
            clazz = methodOrField.getContext();
            if (clazz instanceof JSExpressionCodeFragment) {
                clazz = clazz.getContext();
            }
        } else if (methodOrField instanceof JSParameter) {
            JSFunction function;
            JSParameter parameter = (JSParameter)methodOrField;
            if (TypeScriptPsiUtil.isFieldParameter(parameter) && (function = parameter.getDeclaringFunction()) instanceof TypeScriptFunction && function.isConstructor()) {
                clazz = function.getContext();
            }
        } else if (methodOrField instanceof JSVariable) {
            PsiElement context2 = methodOrField.getContext();
            clazz = context2 == null ? null : context2.getContext();
        } else if (methodOrField instanceof JSVarStatement) {
            clazz = methodOrField.getContext();
        } else if (methodOrField instanceof JSField) {
            clazz = methodOrField.getContext();
        } else if (methodOrField instanceof JSImplicitPrototypeElement) {
            clazz = methodOrField.getContext();
        } else if (methodOrField instanceof TypeScriptTypeMember) {
            clazz = methodOrField.getContext();
        }
        if (clazz instanceof JSFile) {
            clazz = JSResolveUtil.getXmlBackedClass((JSFile)clazz);
        }
        if (clazz instanceof TypeScriptObjectType) {
            clazz = clazz.getContext();
        }
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @Nullable
    public static JSReferenceExpression getMethodNameIfInsideCall(@Nullable PsiElement parent) {
        JSExpression invokedMethod;
        PsiElement grandParent;
        if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (invokedMethod = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            return (JSReferenceExpression)invokedMethod;
        }
        return null;
    }

    @Nullable
    public static JSCallExpression findCallExprByArg(@Nullable PsiElement arg) {
        PsiElement argList;
        PsiElement psiElement = argList = arg == null ? null : arg.getParent();
        if (argList instanceof JSArgumentList) {
            return (JSCallExpression)ObjectUtils.tryCast((Object)argList.getParent(), JSCallExpression.class);
        }
        return null;
    }

    public static JSReferenceExpression findRefExprThatStartCallChaining(JSReferenceExpression qualifier) {
        JSExpression methodExpression;
        JSExpression expression;
        JSReferenceExpression localQualifier = qualifier;
        while ((expression = localQualifier.getQualifier()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSReferenceExpression) {
            localQualifier = (JSReferenceExpression)methodExpression;
        }
        return localQualifier;
    }

    @Nullable
    public static JSExpression unparenthesize(@Nullable JSExpression expression) {
        while (expression instanceof JSParenthesizedExpression) {
            expression = ((JSParenthesizedExpression)expression).getInnerExpression();
        }
        return expression;
    }

    @NotNull
    public static JSExpression getTopmostParenthesizedOrSelf(@NotNull JSExpression expression) {
        if (expression == null) {
            JSUtils.$$$reportNull$$$0(10);
        }
        JSExpression node = expression;
        PsiElement parent = node.getParent();
        while (parent instanceof JSParenthesizedExpression) {
            node = (JSParenthesizedExpression)parent;
            parent = parent.getParent();
        }
        JSExpression jSExpression = node;
        if (jSExpression == null) {
            JSUtils.$$$reportNull$$$0(11);
        }
        return jSExpression;
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(@Nullable PsiElement element) {
        return PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{JSParenthesizedExpression.class});
    }

    public static JSExpression[] findExpressionOccurrences(@NotNull PsiElement scope2, @Nullable Pair<JSExpression, TextRange> expr, boolean visitInnerFunctions) {
        if (scope2 == null) {
            JSUtils.$$$reportNull$$$0(12);
        }
        if (expr == null) {
            return JSExpression.EMPTY_ARRAY;
        }
        if (expr.second != null) {
            return new JSExpression[]{(JSExpression)expr.first};
        }
        ArrayList<JSExpression> array = new ArrayList<JSExpression>();
        JSUtils.addExpressionOccurrences(JSUtils.unparenthesize((JSExpression)expr.first), array, scope2, visitInnerFunctions);
        return array.toArray(JSExpression.EMPTY_ARRAY);
    }

    private static void addExpressionOccurrences(@Nullable JSExpression expr, @NotNull List<JSExpression> array, @NotNull PsiElement scope2, boolean visitInnerFunctions) {
        PsiElement[] children;
        if (array == null) {
            JSUtils.$$$reportNull$$$0(13);
        }
        if (scope2 == null) {
            JSUtils.$$$reportNull$$$0(14);
        }
        if (expr == null) {
            return;
        }
        if (scope2 instanceof TypeScriptTypePredicate) {
            return;
        }
        for (Object child : children = scope2.getChildren()) {
            if (child instanceof JSTypeDeclaration) continue;
            if (child instanceof JSExpression) {
                child = JSUtils.unparenthesize((JSExpression)child);
            }
            if (child == null) continue;
            if (child instanceof JSExpression) {
                boolean add;
                boolean bl = add = JSUtils.stringLiteralsEquivalent((JSExpression)child, expr) || PsiEquivalenceUtil.areEquivalent((PsiElement)child, (PsiElement)expr, null, null);
                if (add && child != expr) {
                    add = !JSResolveUtil.isSelfReference(scope2, child);
                    add &= JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)child) == ReadWriteAccessDetector.Access.Read || JSResolveUtil.isSelfReference((PsiElement)expr);
                }
                if ((add &= !(scope2 instanceof JSPrefixExpression) || ((JSPrefixExpression)scope2).getOperationSign() != JSTokenTypes.DELETE_KEYWORD) && child instanceof JSParenthesizedExpression && (scope2 instanceof JSPrefixExpression && (((JSPrefixExpression)scope2).getOperationSign() == JSTokenTypes.DELETE_KEYWORD || ((JSPrefixExpression)scope2).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) || scope2 instanceof JSNewExpression || scope2 instanceof JSCaseClause || scope2 instanceof JSReturnStatement || scope2 instanceof JSBinaryExpression && ((JSBinaryExpression)scope2).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD)) {
                    add = false;
                }
                if (add) {
                    array.add(JSUtils.getTopmostParenthesizedOrSelf((JSExpression)child));
                    continue;
                }
            }
            if (!visitInnerFunctions && child instanceof JSFunctionExpression && !((JSFunctionExpression)child).isShorthandArrowFunction()) continue;
            JSUtils.addExpressionOccurrences(expr, array, child, visitInnerFunctions);
        }
    }

    private static boolean stringLiteralsEquivalent(@NotNull JSExpression l, @NotNull JSExpression r) {
        if (l == null) {
            JSUtils.$$$reportNull$$$0(15);
        }
        if (r == null) {
            JSUtils.$$$reportNull$$$0(16);
        }
        if (l instanceof JSLiteralExpression && r instanceof JSLiteralExpression && ((JSLiteralExpression)l).isQuotedLiteral() && ((JSLiteralExpression)r).isQuotedLiteral()) {
            if (l instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)l).getArguments().length != 0 || r instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)r).getArguments().length != 0) {
                return false;
            }
            return StringUtil.equals((CharSequence)((JSLiteralExpression)l).getStringValue(), (CharSequence)((JSLiteralExpression)r).getStringValue());
        }
        return false;
    }

    @NotNull
    public static String getConfigJavaScriptDirPath() {
        String string = PathManager.getConfigPath() + File.separatorChar + "javascript";
        if (string == null) {
            JSUtils.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getExtLibsDirPath() {
        String string = JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "extLibs";
        if (string == null) {
            JSUtils.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static boolean isScopeOwner(@NotNull PsiElement element) {
        if (element == null) {
            JSUtils.$$$reportNull$$$0(19);
        }
        return element instanceof JSFunction || element instanceof JSClass || element instanceof TypeScriptModule || element instanceof JSPackageStatement || element instanceof JSPackage;
    }

    public static boolean isLineBreakWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)element.getText());
    }

    @Nullable
    public static JSAttributeList getAttributeList(@NotNull StubBasedPsiElementBase<?> elementBase) {
        if (elementBase == null) {
            JSUtils.$$$reportNull$$$0(20);
        }
        return (JSAttributeList)JSStubBasedPsiTreeUtil.getStubOrPsiChild(elementBase, JSStubElementTypes.ATTRIBUTE_LISTS, Holder.ATTRIBUTE_LIST_STOP_AT);
    }

    public static boolean statementRequiresSemicolon(@NotNull JSStatement node) {
        if (node == null) {
            JSUtils.$$$reportNull$$$0(21);
        }
        if (node instanceof JSVarStatement) {
            return !JSUtils.varStatementForbidsSemicolon(node);
        }
        return node instanceof JSExpressionStatement || node instanceof JSBreakStatement || node instanceof JSContinueStatement || node instanceof JSFunctionExitPoint || node instanceof JSDoWhileStatement || node instanceof JSEmptyStatement || node instanceof TypeScriptImportStatement;
    }

    public static boolean statementNeverRequiresSemicolon(@NotNull JSStatement node) {
        if (node == null) {
            JSUtils.$$$reportNull$$$0(22);
        }
        return node instanceof JSIfStatement || node instanceof JSSwitchStatement || node instanceof JSBlockStatement || node instanceof JSPackageStatement || node instanceof JSLoopStatement || JSUtils.varStatementForbidsSemicolon(node);
    }

    private static boolean varStatementForbidsSemicolon(@NotNull JSStatement node) {
        PsiElement parent;
        if (node == null) {
            JSUtils.$$$reportNull$$$0(23);
        }
        return (parent = node.getParent()) instanceof TypeScriptEnum || parent instanceof JSVariableDeclaringScope;
    }

    public static boolean isIdentifierNameOrPrivateIdentifier(@NotNull String name) {
        if (name == null) {
            JSUtils.$$$reportNull$$$0(24);
        }
        return StringUtil.isJavaIdentifier((String)name) || name.length() >= 2 && name.charAt(0) == '#' && StringUtil.isJavaIdentifier((String)name.substring(1));
    }

    @Contract(value="null -> false")
    public static boolean isPrivateSharpItem(@Nullable PsiElement element) {
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        return ((JSQualifiedNamedElement)element).isPrivateName();
    }

    @Contract(value="null -> false")
    public static boolean isPrivateNameReference(@Nullable PsiElement place) {
        if (place instanceof JSReferenceExpression) {
            PsiElement nameElement = ((JSReferenceExpression)place).getReferenceNameElement();
            if (nameElement == null) {
                return false;
            }
            return nameElement.getNode().getElementType() == JSTokenTypes.PRIVATE_IDENTIFIER;
        }
        return false;
    }

    public static boolean isPrivateBrandCheckReference(@NotNull JSReferenceExpression memberReference) {
        JSExpression qualifier;
        if (memberReference == null) {
            JSUtils.$$$reportNull$$$0(25);
        }
        if ((qualifier = memberReference.getQualifier()) != null) {
            return false;
        }
        if (!JSUtils.isPrivateNameReference((PsiElement)memberReference)) {
            return false;
        }
        PsiElement parent = memberReference.getParent();
        return parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.IN_KEYWORD && ((JSBinaryExpression)parent).getLOperand() == memberReference;
    }

    @Nullable
    public static JSExpression getPrivateBrandCheckRhsByLhs(@NotNull JSReferenceExpression memberReference) {
        if (memberReference == null) {
            JSUtils.$$$reportNull$$$0(26);
        }
        if (!JSUtils.isPrivateBrandCheckReference(memberReference)) {
            LOG.error("Not private member reference: " + String.valueOf(memberReference));
            return null;
        }
        return ((JSBinaryExpression)memberReference.getParent()).getROperand();
    }

    public static boolean isDecoratorAccessContext(@Nullable PsiElement place) {
        if (place instanceof JSReferenceExpression) {
            return place.getParent() instanceof ES6Decorator;
        }
        return false;
    }

    public static boolean areElementsEquivalent(@Nullable PsiElement lhs, @Nullable PsiElement rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return CompletionUtilCoreImpl.getOriginalElement((PsiElement)rhs) == CompletionUtilCoreImpl.getOriginalElement((PsiElement)lhs);
    }

    public static boolean isNullishOrORAssignment(JSAssignmentExpression assignment) {
        @Nullable ASTNode node = assignment.getOperationNode();
        return node != null && (node.getElementType() == JSTokenTypes.QUEST_QUEST_EQ || node.getElementType() == JSTokenTypes.OR_OR_EQ);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9, 11, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/util/JSUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementBase";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootXmlFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitAccessType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostParenthesizedOrSelf";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigJavaScriptDirPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtLibsDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScriptTagContent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRootXmlFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 17: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findScriptTagWithEmbeddedContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitAccessType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParenthesizedOrSelf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionOccurrences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addExpressionOccurrences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "stringLiteralsEquivalent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isScopeOwner";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "statementRequiresSemicolon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "statementNeverRequiresSemicolon";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "varStatementForbidsSemicolon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifierNameOrPrivateIdentifier";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isPrivateBrandCheckReference";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPrivateBrandCheckRhsByLhs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9, 11, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        private static final TokenSet ATTRIBUTE_LIST_STOP_AT = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE})});

        private Holder() {
        }
    }
}

