/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.actions.ImportDataSourceAction;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0006"}, d2={"scanForNewConfigurations", "", "project", "Lcom/intellij/openapi/project/Project;", "notifyNewDataSourcesDetected", "", "intellij.database.impl"})
public final class DatabaseConfigStartupActivityKt {
    private static final boolean scanForNewConfigurations(Project project) {
        Object[] modules = project.isDisposed() ? Module.EMPTY_ARRAY : ModuleManager.Companion.getInstance(project).getModules();
        Intrinsics.checkNotNull((Object)modules);
        if (modules.length == 0) {
            return false;
        }
        DataSourceRegistry registry = new DataSourceRegistry(project);
        for (DataSourceDetector detector : DataSourceDetector.EP_NAME.getExtensionList()) {
            if (!detector.isApplicable(project)) continue;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])modules);
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                ProgressManager.checkCanceled();
                detector.collectDataSources(module, registry.getBuilder(), false);
                if (registry.getDataSources().isEmpty()) continue;
                Collection<? extends LocalDataSource> collection = registry.getNewDataSources();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getNewDataSources(...)");
                if (!(!collection.isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    private static final void notifyNewDataSourcesDetected(Project project) {
        if (!project.isOpen()) {
            return;
        }
        String string = DatabaseBundle.message("data.sources.detected", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message("data.sources.detected.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        DatabaseNotifications.DATABASE_DETECTION_GROUP.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.create((String)DatabaseBundle.message("data.sources.detected.configure", new Object[0]), (String)"data.sources.detected.configure", (arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$1((arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$0(project, arg_0, arg_1), arg_0, arg_1))).addAction((AnAction)NotificationAction.create((String)DatabaseBundle.message("data.sources.detected.do.not.suggest.again", new Object[0]), (String)"data.sources.detected.do.not.suggest.again", (arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$3((arg_0, arg_1) -> DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected$lambda$2(project, arg_0, arg_1), arg_0, arg_1))).setSuggestionType(true).setDisplayId("DatabaseConfigFileWatcher.found").notify(project);
    }

    private static final Unit notifyNewDataSourcesDetected$lambda$0(Project $project, AnActionEvent anActionEvent, Notification notification) {
        if (ImportDataSourceAction.doImportAction($project, true)) {
            notification.expire();
        }
        return Unit.INSTANCE;
    }

    private static final void notifyNewDataSourcesDetected$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit notifyNewDataSourcesDetected$lambda$2(Project $project, AnActionEvent anActionEvent, Notification notification) {
        notification.setDoNotAskFor($project);
        notification.expire();
        return Unit.INSTANCE;
    }

    private static final void notifyNewDataSourcesDetected$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$notifyNewDataSourcesDetected(Project project) {
        DatabaseConfigStartupActivityKt.notifyNewDataSourcesDetected(project);
    }

    public static final /* synthetic */ boolean access$scanForNewConfigurations(Project project) {
        return DatabaseConfigStartupActivityKt.scanForNewConfigurations(project);
    }
}

