/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackend;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipData;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPathTrie;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public class DbSrcBackendFiles {
    static final Logger LOG = Logger.getInstance(DbSrcBackendFiles.class);
    private final @SystemDependent String myRoot;
    private final DbSrcBackend.Listener myListener;
    private final ReadWriteLock myLock;
    private final Locker myWriteLocker;
    private final Locker myReadLocker;
    private final ObjectPathTrie<DbSrcStorageDsMetadata.MetaData> myMetaDataCache;
    private final ObjectPathTrie<DbSrcBackendZipData> myZipDataCache;

    public DbSrcBackendFiles(@SystemDependent @NotNull String root, @NotNull DbSrcBackend.Listener listener2) {
        if (root == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(1);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myWriteLocker = new Locker(this.myLock.writeLock());
        this.myReadLocker = new Locker(this.myLock.readLock());
        this.myMetaDataCache = ObjectPathTrie.createConcurrentSoftValueTrie();
        this.myZipDataCache = ObjectPathTrie.createConcurrent();
        this.myRoot = root;
        this.myListener = listener2;
    }

    @NotNull
    public @SystemDependent String getRoot() {
        String string = this.myRoot;
        if (string == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public DbSrcBackend.Listener getListener() {
        DbSrcBackend.Listener listener2 = this.myListener;
        if (listener2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(3);
        }
        return listener2;
    }

    @NotNull
    public Locker readLock() {
        Locker locker = this.myReadLocker.lock();
        if (locker == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(4);
        }
        return locker;
    }

    @NotNull
    public Locker writeLock() {
        Locker locker = this.myWriteLocker.lock();
        if (locker == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(5);
        }
        return locker;
    }

    public void list(@Nullable ObjectPath object, @NotNull ObjectKind group, boolean staging, @NotNull DbSrcStorage.ListingConsumer consumer) {
        String name2;
        Path[] paths;
        Path path;
        if (group == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(7);
        }
        if (!Files.isDirectory(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, group, null), new LinkOption[0])) {
            return;
        }
        try (Stream<Path> list = Files.list(path);){
            paths = (Path[])list.toArray(Path[]::new);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return;
        }
        HashMap<String, ObjectPath> names = new HashMap<String, ObjectPath>();
        for (Path p2 : paths) {
            name2 = p2.getFileName().toString();
            if (!name2.endsWith(".meta")) continue;
            name2 = StringUtil.trimEnd((String)name2, (String)".meta");
            Pair<String, String> id = DbSrcBackendFiles.readNameAndIdentity(p2);
            if (id == null) continue;
            names.put(name2, DbSrcBackendUtils.createPath(object, (String)id.first, group, (String)id.second));
        }
        for (Path p2 : paths) {
            DbSrcBackendUtils.SrcTypeOrFolder type;
            name2 = p2.getFileName().toString();
            if (!Files.isDirectory(p2, new LinkOption[0])) {
                if (name2.endsWith(".sql")) {
                    name2 = StringUtil.trimEnd((String)name2, (String)".sql");
                    if (!staging) {
                        type = DbSrcBackendUtils.SrcType.ORIGINAL;
                    } else if (name2.endsWith(".base")) {
                        name2 = StringUtil.trimEnd((String)name2, (String)".base");
                        type = DbSrcBackendUtils.SrcType.USER_BASE;
                    } else {
                        type = DbSrcBackendUtils.SrcType.USER;
                    }
                } else if (name2.endsWith(".zip")) {
                    name2 = StringUtil.trimEnd((String)name2, (String)".zip");
                    type = DbSrcBackendUtils.SrcType.FOLDER;
                } else {
                    if (!name2.endsWith(".zip.tmp")) continue;
                    name2 = StringUtil.trimEnd((String)name2, (String)".zip.tmp");
                    type = DbSrcBackendUtils.SrcType.FOLDER;
                }
            } else {
                type = DbSrcBackendUtils.SrcType.FOLDER;
            }
            ObjectPath child = (ObjectPath)names.get(name2);
            if (child == null) continue;
            consumer.consume(child, type);
        }
    }

    @Nullable
    private static Pair<String, String> readNameAndIdentity(Path p2) {
        try {
            byte[] bytes2 = Files.readAllBytes(p2);
            return DbSrcBackendUtils.extractNameAndIdentity(bytes2);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void listGroups(@Nullable ObjectPath object, boolean staging, @NotNull Consumer<? super ObjectKind> consumer) {
        Path[] paths;
        Path path;
        if (consumer == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(8);
        }
        if (!Files.isDirectory(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null), new LinkOption[0])) {
            return;
        }
        try (Stream<Path> list = Files.list(path);){
            paths = (Path[])list.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toArray(Path[]::new);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return;
        }
        for (Path dir : paths) {
            ObjectKind kind = DbSrcUtilsCore.findKind(dir.getFileName().toString());
            if (kind == null) continue;
            consumer.consume((Object)kind);
        }
    }

    public boolean hasChildren(@Nullable ObjectPath object, boolean staging) {
        boolean bl;
        block9: {
            Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            Stream<Path> list = Files.list(path);
            try {
                bl = list.anyMatch(p2 -> Files.isDirectory(p2, new LinkOption[0]));
                if (list == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return false;
                }
            }
            list.close();
        }
        return bl;
    }

    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group, boolean staging) {
        boolean bl;
        block10: {
            Path path;
            if (group == null) {
                DbSrcBackendFiles.$$$reportNull$$$0(9);
            }
            if (!Files.isDirectory(path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null), new LinkOption[0])) {
                return false;
            }
            Stream<Path> list = Files.list(path);
            try {
                String code = group.code();
                bl = list.anyMatch(p2 -> Files.isDirectory(p2, new LinkOption[0]) && code.equals(p2.getFileName().toString()));
                if (list == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    return false;
                }
            }
            list.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(@Nullable ObjectPath object, boolean staging, boolean physical) throws IOException {
        ObjectPath root = object;
        try {
            try (Locker lock = this.writeLock();){
                ObjectPath objectPath = root = object == null ? null : this.findCascadeRemovalRoot(object, staging);
                if (!staging) {
                    if (object != null && DbSrcBackendFiles.isZipRoot(object.kind)) {
                        this.closeSingleZip(object);
                    } else {
                        this.closeAllZips();
                    }
                    this.removeCachedMetaDataRec(root);
                }
                if (physical) {
                    Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, root, null, null);
                    FileUtil.delete((File)path.toFile());
                    if (root != null) {
                        DbSrcBackendFiles.dropSrcAndMeta(path);
                    }
                }
            }
            this.getListener().dirChanged(root, staging, true);
            if (root != null) {
                this.getListener().fileChanged(root, staging ? DbSrcBackendUtils.SrcType.USER : DbSrcBackendUtils.SrcType.ORIGINAL);
            }
        }
        catch (Throwable throwable) {
            this.getListener().dirChanged(root, staging, true);
            if (root != null) {
                this.getListener().fileChanged(root, staging ? DbSrcBackendUtils.SrcType.USER : DbSrcBackendUtils.SrcType.ORIGINAL);
            }
            throw throwable;
        }
    }

    private void closeAllZips() {
        for (DbSrcBackendZipData zip : this.myZipDataCache.clearAndCollectValues()) {
            zip.closeWriter();
        }
    }

    private void closeSingleZip(@NotNull ObjectPath object) {
        DbSrcBackendZipData zip;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(10);
        }
        if ((zip = this.myZipDataCache.remove(object)) != null) {
            zip.closeWriter();
        }
    }

    void removeCachedMetaDataRec(@Nullable ObjectPath root) {
        if (root == null) {
            this.myMetaDataCache.clear();
        } else {
            this.myMetaDataCache.removeCascade(root);
        }
    }

    public byte @Nullable [] getContent(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) throws IOException {
        Path path;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(11);
        }
        if (type == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(12);
        }
        if (Files.isRegularFile(path = DbSrcBackendUtils.getSrc(this.myRoot, object, type), new LinkOption[0])) {
            try (Locker lock = this.readLock();){
                byte[] byArray = FileUtil.loadFileBytes((File)path.toFile());
                return byArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputStream getContentInputStream(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) throws IOException {
        Path path;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(13);
        }
        if (type == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(14);
        }
        if (Files.isRegularFile(path = DbSrcBackendUtils.getSrc(this.myRoot, object, type), new LinkOption[0])) {
            DbSrcBackendUtils.InputStreamWrapper result2 = null;
            final Locker lock = this.readLock();
            try {
                DbSrcBackendUtils.InputStreamWrapper inputStreamWrapper = result2 = new DbSrcBackendUtils.InputStreamWrapper(Files.newInputStream(path, new OpenOption[0])){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            lock.close();
                        }
                    }
                };
                return inputStreamWrapper;
            }
            finally {
                if (result2 == null) {
                    lock.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, byte @Nullable [] content) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(15);
        }
        if (type == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(16);
        }
        Path path = DbSrcBackendUtils.getSrc(this.myRoot, object, type);
        try (Locker lock = this.writeLock();){
            if (content == null) {
                Files.deleteIfExists(path);
            } else {
                FileUtil.writeToFile((File)path.toFile(), (byte[])content);
            }
        }
        finally {
            this.getListener().fileChanged(object, type);
        }
    }

    @Nullable
    public ObjectPath findCascadeRemovalRoot(@NotNull ObjectPath object, boolean staging) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(17);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, null);
        return this.findCascadeRemovalRootImpl(path, object, staging);
    }

    @Nullable
    private ObjectPath findCascadeRemovalRootImpl(@NotNull Path path, @NotNull ObjectPath object, boolean staging) {
        Boolean willCascadeFast;
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(18);
        }
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(19);
        }
        ObjectPath parent = object.parent;
        Boolean bl = willCascadeFast = staging ? null : this.isParentWillCascadeFast(parent, object);
        if (willCascadeFast != null) {
            return willCascadeFast != false ? parent : object;
        }
        Path group = path.getParent();
        if (group == null) {
            return object;
        }
        if (this.hasOtherChild(group, object)) {
            return object;
        }
        Path parentPath = group.getParent();
        if (parentPath == null) {
            return object;
        }
        if (DbSrcBackendFiles.hasOtherGroup(parentPath, object.kind)) {
            return object;
        }
        if (parent == null) {
            return null;
        }
        if (this.hasSrcOrMeta(parentPath, object, staging)) {
            return object;
        }
        return this.findCascadeRemovalRootImpl(parentPath, parent, staging);
    }

    private Boolean isParentWillCascadeFast(@Nullable ObjectPath parent, @NotNull ObjectPath object) {
        Iterator<ObjectPath> cIt;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(20);
        }
        if (!(cIt = this.myMetaDataCache.getChildren(parent).iterator()).hasNext()) {
            return null;
        }
        ObjectPath c2 = cIt.next();
        if (c2 != object) {
            return false;
        }
        if (!cIt.hasNext()) {
            return null;
        }
        return false;
    }

    boolean hasSrcOrMeta(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(21);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, false, object, null, null);
        return this.hasSrcOrMeta(path, object, false);
    }

    private boolean hasSrcOrMeta(@NotNull Path path, @NotNull ObjectPath object, boolean staging) {
        Path basePath;
        Path sqlPath;
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(22);
        }
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(23);
        }
        if (Files.exists(sqlPath = path.resolveSibling(path.getFileName().toString() + ".sql"), new LinkOption[0])) {
            return true;
        }
        if (staging && Files.exists(basePath = path.resolveSibling(path.getFileName().toString() + ".base.sql"), new LinkOption[0])) {
            return true;
        }
        return !staging && !DbSrcStorageDsMetadata.MetaData.isEmpty(this.getMetaData(object));
    }

    void dropSrcAndMeta(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(24);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, false, object, null, null);
        DbSrcBackendFiles.dropSrcAndMeta(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAll(ObjectPath from, ObjectPath to, boolean staging, boolean physical) throws IOException {
        try {
            DbSrcStorageDsMetadata.MetaData meta;
            DbSrcStorageDsMetadata.MetaData metaData = meta = staging ? this.getStagingMetaData(from) : this.getMetaData(from);
            if (meta == null) {
                return;
            }
            try (Locker ignored = this.writeLock();){
                this.closeAncestorZips(from);
                this.closeAncestorZips(to);
                if (physical) {
                    Path fromPath = DbSrcBackendUtils.getDir(this.myRoot, staging, from, null, null);
                    Path toPath = DbSrcBackendUtils.getDir(this.myRoot, staging, to, null, null);
                    FileUtil.moveDirWithContent((File)fromPath.toFile(), (File)toPath.toFile());
                    this.moveFile(fromPath, toPath, ".zip");
                    this.moveFile(fromPath, toPath, ".sql");
                    this.moveFile(fromPath, toPath, ".base.sql");
                }
                this.putMetaData(to, staging, meta);
                this.dropObject(from, staging, physical);
            }
        }
        finally {
            this.getListener().fileMoved(from, to);
        }
    }

    private void closeAncestorZips(ObjectPath from) {
        List<DbSrcBackendZipData> removed = this.myZipDataCache.removeCascadeAndCollectValues(from);
        for (DbSrcBackendZipData data : removed) {
            data.closeWriter();
        }
    }

    protected void moveFile(Path fromPath, Path toPath, String ext) throws IOException {
        Path from = DbSrcBackendFiles.folderToFile(fromPath, ext);
        if (!Files.exists(from, new LinkOption[0])) {
            return;
        }
        Files.move(from, DbSrcBackendFiles.folderToFile(toPath, ext), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void dropSrcAndMeta(Path path) throws IOException {
        Files.deleteIfExists(DbSrcBackendFiles.folderToFile(path, ".meta"));
        Files.deleteIfExists(DbSrcBackendFiles.folderToFile(path, ".sql"));
        Files.deleteIfExists(DbSrcBackendFiles.folderToFile(path, ".base.sql"));
    }

    @NotNull
    private static Path folderToFile(Path path, String ext) {
        Path path2 = path.resolveSibling(String.valueOf(path.getFileName()) + ext);
        if (path2 == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(25);
        }
        return path2;
    }

    public void resetCaches() {
        this.finish();
        this.myMetaDataCache.clear();
        this.myZipDataCache.clear();
    }

    public void finish() {
        try (Locker lock = this.writeLock();){
            for (DbSrcBackendZipData data : this.myZipDataCache.clearAndCollectValues()) {
                data.closeWriter();
            }
        }
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getStagingMetaData(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(26);
        }
        return Files.isRegularFile(DbSrcBackendUtils.getDir(this.myRoot, true, object, null, ".meta"), new LinkOption[0]) ? DbSrcStorageDsMetadata.MetaData.EMPTY : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() {
        try (Locker lock = this.writeLock();){
            this.closeAllZips();
            FileUtil.delete((File)new File(this.myRoot));
        }
        finally {
            this.getListener().dirChanged(null, true, true);
            this.getListener().dirChanged(null, false, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasOtherChild(@NotNull Path group, @NotNull ObjectPath object) {
        if (group == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(27);
        }
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(28);
        }
        if (!Files.isDirectory(group, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> list = Files.list(group);){
            Path p2;
            block14: {
                boolean checkName = true;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    p2 = (Path)it.next();
                    String name2 = p2.getFileName().toString();
                    if (!name2.endsWith(".meta") || !Files.isRegularFile(p2, new LinkOption[0])) continue;
                    if (checkName) {
                        boolean isMe;
                        String curName = DbSrcBackendUtils.getSimpleName(object.getName(), object.getIdentity());
                        boolean bl = isMe = curName.length() + ".meta".length() == name2.length() && name2.startsWith(curName);
                        if (isMe) {
                            checkName = false;
                            continue;
                        }
                    }
                    break block14;
                }
                return false;
            }
            this.getMetaData(object.parent, object.kind, p2);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasOtherGroup(@NotNull Path path, @NotNull ObjectKind group) {
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(29);
        }
        if (group == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(30);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> list = Files.list(path);){
            Path p2;
            String code = group.code();
            Iterator it = list.iterator();
            do {
                if (!it.hasNext()) return false;
            } while (!Files.isDirectory(p2 = (Path)it.next(), new LinkOption[0]) || p2.endsWith(code));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMetaData(@NotNull ObjectPath object, boolean staging, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(31);
        }
        if (metaData == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(32);
        }
        Path path = DbSrcBackendUtils.getDir(this.myRoot, staging, object, null, ".meta");
        try {
            try (Locker lock = this.writeLock();){
                FileUtil.writeToFile((File)path.toFile(), (byte[])DbSrcBackendUtils.serializeMetaData(object, metaData));
            }
            this.getListener().dirChanged(object, staging, false);
            this.getListener().fileChanged(object, staging ? DbSrcBackendUtils.SrcType.USER : DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        catch (Throwable throwable) {
            this.getListener().dirChanged(object, staging, false);
            this.getListener().fileChanged(object, staging ? DbSrcBackendUtils.SrcType.USER : DbSrcBackendUtils.SrcType.ORIGINAL);
            throw throwable;
        }
    }

    @Nullable
    private DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath object) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(33);
        }
        if ((metaData = this.getCachedMetaData(object)) == null && (metaData = this.readMetaData(object)) != null) {
            this.putMetaDataToCache(object, metaData);
        }
        return metaData;
    }

    @Nullable
    private DbSrcStorageDsMetadata.MetaData getMetaData(@Nullable ObjectPath parent, @NotNull ObjectKind group, @NotNull Path path) {
        Pair<String, String> nameAndId;
        if (group == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(34);
        }
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(35);
        }
        if ((nameAndId = DbSrcBackendFiles.readNameAndIdentity(path)) == null) {
            return null;
        }
        ObjectPath object = DbSrcBackendUtils.createPath(parent, (String)nameAndId.first, group, (String)nameAndId.second);
        return this.getMetaData(object);
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData readMetaData(@NotNull ObjectPath object) {
        Path path;
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(36);
        }
        return Files.isRegularFile(path = DbSrcBackendUtils.getDir(this.myRoot, false, object, null, ".meta"), new LinkOption[0]) ? this.readMetaData(path) : null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DbSrcStorageDsMetadata.MetaData readMetaData(@NotNull Path path) {
        if (path == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(37);
        }
        try (Locker ignored = this.readLock();){
            DbSrcStorageDsMetadata.MetaData metaData;
            block15: {
                InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    metaData = DbSrcBackendUtils.deserializeMetaData(stream);
                    if (stream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return metaData;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(38);
        }
        if (type == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(39);
        }
        Path path = DbSrcBackendUtils.getSrc(this.myRoot, object, type);
        return FileSystemUtil.getAttributes((String)path.toString());
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getCachedMetaData(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(40);
        }
        return this.myMetaDataCache.get(object);
    }

    public void putMetaDataToCache(@NotNull ObjectPath object, @Nullable DbSrcStorageDsMetadata.MetaData metaData) {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(41);
        }
        if (metaData == null) {
            this.myMetaDataCache.remove(object);
        } else {
            this.myMetaDataCache.put(object, metaData);
        }
    }

    @Nullable
    DbSrcBackendZipData getCachedZipData(@NotNull ObjectPath root) {
        if (root == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(42);
        }
        return this.myZipDataCache.get(root);
    }

    @NotNull
    DbSrcBackendZipData getZipData(@NotNull ObjectPath root) {
        DbSrcBackendZipData data;
        if (root == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(43);
        }
        if ((data = this.myZipDataCache.get(root)) == null) {
            String path = DbSrcBackendUtils.getDir(this.myRoot, false, root, null, ".zip").toString();
            data = new DbSrcBackendZipData(path, root, this);
            DbSrcBackendZipData prev2 = this.myZipDataCache.putIfAbsent(root, data);
            data = (DbSrcBackendZipData)ObjectUtils.chooseNotNull((Object)prev2, (Object)data);
        }
        data.build();
        DbSrcBackendZipData dbSrcBackendZipData = data;
        if (dbSrcBackendZipData == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(44);
        }
        return dbSrcBackendZipData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, long timestamp) throws IOException {
        if (object == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(45);
        }
        if (type == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(46);
        }
        Path path = DbSrcBackendUtils.getSrc(this.myRoot, object, type);
        try (Locker lock = this.writeLock();){
            Files.setLastModifiedTime(path, FileTime.fromMillis(timestamp));
        }
        finally {
            this.getListener().fileChanged(object, type);
        }
    }

    static boolean isZipRoot(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbSrcBackendFiles.$$$reportNull$$$0(47);
        }
        return ObjectKind.SCHEMA == kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 25, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 25: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendFiles";
                break;
            }
            case 6: 
            case 9: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 40: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 22: 
            case 29: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readLock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLock";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "folderToFile";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 25: 
            case 44: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "listGroups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "closeSingleZip";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRoot";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRootImpl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isParentWillCascadeFast";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasSrcOrMeta";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "dropSrcAndMeta";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getStagingMetaData";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherChild";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherGroup";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readMetaData";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMetaData";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "putMetaDataToCache";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getCachedZipData";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getZipData";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isZipRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 25, 44 -> new IllegalStateException(string);
        };
    }

    public static class Locker
    implements AutoCloseable {
        private final Lock myLock;

        public Locker(Lock lock) {
            this.myLock = lock;
        }

        @Override
        public void close() {
            this.myLock.unlock();
        }

        public Locker lock() {
            this.myLock.lock();
            return this;
        }
    }
}

