/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/base/generator/ScriptingResultImpl;", "Lcom/intellij/database/script/generator/ScriptingResult;", "statements", "", "Lcom/intellij/database/model/properties/CompositeText;", "statementDelimiterStr", "", "statementDelimiterOwnsLine", "", "<init>", "(Ljava/util/List;Ljava/lang/String;Z)V", "getStatements", "()Ljava/util/List;", "getStatementDelimiterStr", "()Ljava/lang/String;", "getStatementDelimiterOwnsLine", "()Z", "getScriptStatements", "getScriptStatementsTexts", "", "()[Ljava/lang/String;", "getScriptText", "getScript", "hasDelimiter", "b", "Lcom/intellij/database/script/generator/CodeTextBuilder;", "isComment", "text", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nAbstractCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/ScriptingResultImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,523:1\n1797#2,3:524\n2632#2,3:527\n*S KotlinDebug\n*F\n+ 1 AbstractCodeGenerator.kt\ncom/intellij/database/dialects/base/generator/ScriptingResultImpl\n*L\n360#1:524,3\n379#1:527,3\n*E\n"})
public final class ScriptingResultImpl
implements ScriptingResult {
    @NotNull
    private final List<CompositeText> statements;
    @NotNull
    private final String statementDelimiterStr;
    private final boolean statementDelimiterOwnsLine;

    public ScriptingResultImpl(@NotNull List<? extends CompositeText> statements2, @NotNull String statementDelimiterStr, boolean statementDelimiterOwnsLine) {
        Intrinsics.checkNotNullParameter(statements2, (String)"statements");
        Intrinsics.checkNotNullParameter((Object)statementDelimiterStr, (String)"statementDelimiterStr");
        this.statements = statements2;
        this.statementDelimiterStr = statementDelimiterStr;
        this.statementDelimiterOwnsLine = statementDelimiterOwnsLine;
    }

    @NotNull
    public final List<CompositeText> getStatements() {
        return this.statements;
    }

    @NotNull
    public final String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    public final boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    public List<CompositeText> getScriptStatements() {
        return this.statements;
    }

    @Override
    @NotNull
    public String[] getScriptStatementsTexts() {
        int n = 0;
        int n2 = this.statements.size();
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = ((Object)this.statements.get(n3).getText()).toString();
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String getScriptText() {
        return ((Object)this.getScript().getText()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeText getScript() {
        void $this$fold$iv;
        Iterable iterable = this.statements;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void t;
            CompositeText compositeText = (CompositeText)element$iv;
            int x = accumulator$iv;
            boolean bl = false;
            accumulator$iv = x + t.getText().length();
        }
        int capacity = accumulator$iv + 8 * this.statements.size();
        CodeTextBuilder b = new CodeTextBuilder(capacity);
        for (CompositeText stmt : this.statements) {
            block5: {
                block7: {
                    block6: {
                        boolean separate;
                        for (CompositeText.Fragment f : stmt.getFragments()) {
                            b.append(f);
                        }
                        boolean bl = separate = !this.isComment(stmt) && !this.hasDelimiter(b);
                        if (!separate) break block5;
                        if (this.statementDelimiterOwnsLine) break block6;
                        CompositeText.Fragment fragment = (CompositeText.Fragment)CollectionsKt.lastOrNull(stmt.getFragments());
                        if ((fragment != null ? fragment.getKind() : null) != CompositeText.Kind.COMMENT) break block7;
                    }
                    b.ensureEoln(CompositeText.Kind.SQL_DELIMITER);
                }
                CodeTextBuilder.append$default(b, this.statementDelimiterStr, CompositeText.Kind.SQL_DELIMITER, false, null, 12, null);
            }
            b.ensureBlankLine(CompositeText.Kind.SQL_DELIMITER);
        }
        return b.build();
    }

    private final boolean hasDelimiter(CodeTextBuilder b) {
        return b.endsWithIgnoreSpace(this.statementDelimiterStr) && (!Intrinsics.areEqual((Object)this.statementDelimiterStr, (Object)"/") || !b.endsWithIgnoreSpace("*/"));
    }

    private final boolean isComment(CompositeText text2) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = text2.getFragments();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    CompositeText.Fragment it = (CompositeText.Fragment)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind() != CompositeText.Kind.COMMENT && !StringsKt.isBlank((CharSequence)it.getText()))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

