/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 )2\u00020\u0001:\u0003'()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J.\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H&J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "setNewPassword", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "newPass", "", "handleConnectionFailure", "e", "", "silent", "attempt", "", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Throwable;ZILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAuthType", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "getRequiredArtifact", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "RequiredArtifact", "MsAzureAuthType", "Companion", "intellij.database.dialects.mssql"})
public abstract class MsAzureAuthProviderBase
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final RequiredArtifact ADAL4J;
    @NotNull
    private static final RequiredArtifact MSAL4J;
    @NotNull
    private static final RequiredArtifact AZURE_IDENTITY;

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return !MsUtils.isMs(point.getDatabaseDriver()) ? DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return DatabaseCredentialsAuthProvider.Companion.loadCredentialsConfig(point, credentials, external);
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DatabaseCredentialsAuthProvider.Companion.saveCredentialsConfig(config, credentials, data instanceof DatabaseCredentialsAuthProvider.UserPassCredentials ? (DatabaseCredentialsAuthProvider.UserPassCredentials)data : null, external);
    }

    @Override
    public void setNewPassword(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @Nullable String newPass) {
        Intrinsics.checkNotNullParameter((Object)proto2, (String)"proto");
        DatabaseCredentialsAuthProvider.Companion.applyNewPassword(proto2, newPass);
    }

    @Override
    @Nullable
    public Object handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull Throwable e, boolean silent, int attempt, @NotNull Continuation<? super Boolean> $completion) {
        return MsAzureAuthProviderBase.handleConnectionFailure$suspendImpl(this, proto2, e, silent, attempt, $completion);
    }

    static /* synthetic */ Object handleConnectionFailure$suspendImpl(MsAzureAuthProviderBase $this, DatabaseConnectionInterceptor.ProtoConnection proto2, Throwable e, boolean silent, int attempt, Continuation<? super Boolean> $completion) {
        String message = e.getMessage();
        DatabaseDriver driver = proto2.getConnectionPoint().getDatabaseDriver();
        if (driver != null && message != null) {
            RequiredArtifact ra;
            RequiredArtifact requiredArtifact = StringsKt.contains$default((CharSequence)message, (CharSequence)"Failed to load ADAL4J", (boolean)false, (int)2, null) ? ADAL4J : (StringsKt.contains$default((CharSequence)message, (CharSequence)"Failed to load MSAL4J", (boolean)false, (int)2, null) ? MSAL4J : (ra = StringsKt.contains$default((CharSequence)message, (CharSequence)"class 'com.azure.identity.ManagedIdentityCredential' not found", (boolean)false, (int)2, null) ? AZURE_IDENTITY : null));
            if (ra != null) {
                ErrorInfo info2 = SimpleErrorInfo.create((String)message, (Throwable)e, (List)CollectionsKt.listOf((Object)ra.createSetUpFix(driver, true)));
                throw new KnownDatabaseException(info2);
            }
        }
        return DatabaseAuthProvider.super.handleConnectionFailure(proto2, e, silent, attempt, $completion);
    }

    @NotNull
    public abstract MsAzureAuthType getAuthType();

    @NotNull
    public RequiredArtifact getRequiredArtifact(@NotNull LocalDataSource target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        return MSAL4J;
    }

    @JvmStatic
    @Nullable
    public static final String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2, @NotNull MsAzureAuthType authentication) {
        return Companion.setAuthentication(p2, authentication);
    }

    @JvmStatic
    @NotNull
    public static final RequiredArtifact guessRequired(@NotNull LocalDataSource target2, @NotNull MsAzureAuthType authType) {
        return Companion.guessRequired(target2, authType);
    }

    static {
        Logger logger2 = Logger.getInstance(MsAzureAuthProviderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        ADAL4J = new RequiredArtifact(){

            public boolean checkFile(String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"adal4j", (boolean)false, (int)2, null);
            }
        };
        MSAL4J = new RequiredArtifact(){

            public boolean checkFile(String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"msal4j", (boolean)false, (int)2, null);
            }
        };
        AZURE_IDENTITY = new RequiredArtifact(){

            public boolean checkFile(String u) {
                Intrinsics.checkNotNullParameter((Object)u, (String)"u");
                return StringsKt.contains$default((CharSequence)u, (CharSequence)"azure-identity", (boolean)false, (int)2, null);
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "setAuthentication", "", "p", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "authentication", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "guessRequired", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "authType", "ADAL4J", "MSAL4J", "AZURE_IDENTITY", "intellij.database.dialects.mssql"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String setAuthentication(@NotNull DatabaseConnectionInterceptor.ProtoConnection p2, @NotNull MsAzureAuthType authentication) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            Intrinsics.checkNotNullParameter((Object)((Object)authentication), (String)"authentication");
            return DbImplUtilCore.putOrRemove(p2.getConnectionProperties(), "authentication", authentication.getAuthString());
        }

        @JvmStatic
        @NotNull
        public final RequiredArtifact guessRequired(@NotNull LocalDataSource target2, @NotNull MsAzureAuthType authType) {
            int[] nArray;
            Version version;
            DatabaseDriver.ArtifactRef artifact;
            DatabaseDriver driver;
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
            DatabaseDriver databaseDriver = driver = target2.getDatabaseDriver();
            DatabaseDriver.ArtifactRef artifactRef = artifact = databaseDriver == null ? null : RequiredArtifact.Companion.findArtifact(databaseDriver, "SQL Server");
            Version version2 = version = artifactRef == null ? Version.parse(target2.getDriverVersion().version) : artifactRef.getArtifactVersion();
            if (version != null && version.less(nArray = new int[]{9})) {
                return ADAL4J;
            }
            return MsAzureAuthType.Companion.isRequiredAzureIdentity(authType) ? AZURE_IDENTITY : MSAL4J;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "", "authString", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getAuthString", "()Ljava/lang/String;", "AD_INTEGRATED", "AD_INTERACTIVE", "AD_PASSWORD", "AD_MSI", "AD_DEFAULT", "Companion", "intellij.database.dialects.mssql"})
    public static final class MsAzureAuthType
    extends Enum<MsAzureAuthType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String authString;
        public static final /* enum */ MsAzureAuthType AD_INTEGRATED;
        public static final /* enum */ MsAzureAuthType AD_INTERACTIVE;
        public static final /* enum */ MsAzureAuthType AD_PASSWORD;
        public static final /* enum */ MsAzureAuthType AD_MSI;
        public static final /* enum */ MsAzureAuthType AD_DEFAULT;
        private static final /* synthetic */ MsAzureAuthType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MsAzureAuthType(String authString) {
            this.authString = authString;
        }

        @NotNull
        public final String getAuthString() {
            return this.authString;
        }

        public static MsAzureAuthType[] values() {
            return (MsAzureAuthType[])$VALUES.clone();
        }

        public static MsAzureAuthType valueOf(String value) {
            return Enum.valueOf(MsAzureAuthType.class, value);
        }

        @NotNull
        public static EnumEntries<MsAzureAuthType> getEntries() {
            return $ENTRIES;
        }

        static {
            AD_INTEGRATED = new MsAzureAuthType("ActiveDirectoryIntegrated");
            AD_INTERACTIVE = new MsAzureAuthType("ActiveDirectoryInteractive");
            AD_PASSWORD = new MsAzureAuthType("ActiveDirectoryPassword");
            AD_MSI = new MsAzureAuthType("ActiveDirectoryMSI");
            AD_DEFAULT = new MsAzureAuthType("ActiveDirectoryDefault");
            $VALUES = msAzureAuthTypeArray = new MsAzureAuthType[]{MsAzureAuthType.AD_INTEGRATED, MsAzureAuthType.AD_INTERACTIVE, MsAzureAuthType.AD_PASSWORD, MsAzureAuthType.AD_MSI, MsAzureAuthType.AD_DEFAULT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType$Companion;", "", "<init>", "()V", "isRequiredAzureIdentity", "", "authentication", "Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$MsAzureAuthType;", "intellij.database.dialects.mssql"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isRequiredAzureIdentity(@NotNull MsAzureAuthType authentication) {
                Intrinsics.checkNotNullParameter((Object)((Object)authentication), (String)"authentication");
                return switch (WhenMappings.$EnumSwitchMapping$0[authentication.ordinal()]) {
                    case 1, 2 -> true;
                    default -> false;
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[MsAzureAuthType.values().length];
                    try {
                        nArray[MsAzureAuthType.AD_MSI.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[MsAzureAuthType.AD_DEFAULT.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H&J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact;", "", "artifactId", "", "<init>", "(Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "findArtifact", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$ArtifactVersion;", "checkFile", "", "u", "createSetUpFix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "navigate", "Companion", "intellij.database.dialects.mssql"})
    public static abstract class RequiredArtifact {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String artifactId;

        public RequiredArtifact(@NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            this.artifactId = artifactId;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        private final DatabaseArtifactList.ArtifactVersion findArtifact() {
            return DatabaseArtifactManager.getArtifacts().resolveVersion(this.artifactId, null, "stable", null);
        }

        public abstract boolean checkFile(@NotNull String var1);

        @Nullable
        public final ErrorInfo.Fix createSetUpFix(@Nullable DatabaseDriver driver, boolean navigate) {
            DatabaseFixFactory fixFactory;
            DatabaseFixFactory databaseFixFactory = fixFactory = DatabaseFixFactory.getInstance();
            return databaseFixFactory != null ? databaseFixFactory.setUpArtifact(driver, navigate, () -> RequiredArtifact.createSetUpFix$lambda$0(this)) : null;
        }

        private static final DatabaseArtifactList.ArtifactVersion createSetUpFix$lambda$0(RequiredArtifact this$0) {
            DatabaseArtifactList.ArtifactVersion adal = this$0.findArtifact();
            if (adal == null) {
                LOG.error(this$0.artifactId + " artifact not found");
                return null;
            }
            return adal;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$Companion;", "", "<init>", "()V", "findArtifact", "Lcom/intellij/database/dataSource/DatabaseDriver$ArtifactRef;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "artifactId", "", "intellij.database.dialects.mssql"})
        @SourceDebugExtension(value={"SMAP\nMsAzureAuthProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsAzureAuthProviderBase.kt\ncom/intellij/database/dialects/mssql/MsAzureAuthProviderBase$RequiredArtifact$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DatabaseDriver.ArtifactRef findArtifact(@NotNull DatabaseDriver driver, @NotNull String artifactId) {
                Object v1;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                    Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                    List<DatabaseDriver.ArtifactRef> list = driver.getArtifacts();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getArtifacts(...)");
                    Iterable iterable = list;
                    for (Object t : iterable) {
                        DatabaseDriver.ArtifactRef it = (DatabaseDriver.ArtifactRef)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)artifactId)) continue;
                        v1 = t;
                        break block1;
                    }
                    v1 = null;
                }
                return v1;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

